(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7408,        281]
NotebookOptionsPosition[      5041,        203]
NotebookOutlinePosition[      6020,        231]
CellTagsIndexPosition[      5977,        228]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`ContinuousDistributions`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "Distributions defined in this package have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\nThe input syntax for ",
 Cell[BoxData[
  ButtonBox["UniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UniformDistribution"]], "InlineFormula"],
 " has changed.\n",
 Cell[BoxData["Random"], "InlineFormula"],
 " and ",
 Cell[BoxData["RandomArray"], "InlineFormula"],
 " are replaced by ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Continuous distributions are now part of the built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "UpgradeDetail",
 CellID->7810128],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`ContinuousDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Mean", "[", 
  RowBox[{"BetaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"BetaDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->1746043248],

Cell[BoxData[
 FractionBox["\[Alpha]", 
  RowBox[{"\[Alpha]", "+", "\[Beta]"}]]], "Output",
 CellLabel->"Out[50]=",
 CellID->767477755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12859929],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UniformDistribution"]], "InlineFormula"],
 " is now parameterized by a pair of real endpoints {",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 "}:"
}], "UpgradeDetail",
 CellID->380726846],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"min", ",", "max"}], "]"}], "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->391943743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63946252],

Cell[BoxData[
 FractionBox[
  RowBox[{"max", "+", "min"}], "2"]], "Output",
 CellLabel->"Out[2]=",
 CellID->68700898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->260366343],

Cell[TextData[{
 "Random elements for continuous distributions are generated via ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->148245370],

Cell[BoxData[
 RowBox[{"Random", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{"1", ",", "1.5"}], "]"}], "]"}]], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->873779382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{"GammaDistribution", "[", 
   RowBox[{"1", ",", "1.5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75025638],

Cell[BoxData["3.7405648285186377`"], "Output",
 CellLabel->"Out[2]=",
 CellID->52195965]
}, Open  ]],

Cell[BoxData[
 RowBox[{"RandomArray", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"1", ",", "1.5"}], "]"}], ",", "5"}], "]"}]], "Input", \
"LegacyInput",
 CellLabel->"In[3]:=",
 CellID->156217555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"1", ",", "1.5"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->438868097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.09888875851094342`", ",", "1.9200408230863348`", ",", 
   "0.004626426758136136`", ",", "0.6694394662645294`", ",", 
   "5.519719338798976`"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->546859665]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 13.4402874}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/ContinuousDistributions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 85, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[897, 35, 630, 20, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1530, 57, 182, 6, 70, "UpgradeDetail",
 CellID->7810128],
Cell[1715, 65, 278, 8, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2018, 77, 182, 5, 70, "Input",
 CellID->1746043248],
Cell[2203, 84, 135, 4, 70, "Output",
 CellID->767477755]
}, Open  ]],
Cell[2353, 91, 124, 3, 70, "ExampleDelimiter",
 CellID->12859929],
Cell[2480, 96, 384, 13, 70, "UpgradeDetail",
 CellID->380726846],
Cell[2867, 111, 189, 5, 70, "Input",
 CellID->391943743],
Cell[CellGroupData[{
Cell[3081, 120, 198, 6, 70, "Input",
 CellID->63946252],
Cell[3282, 128, 117, 4, 70, "Output",
 CellID->68700898]
}, Open  ]],
Cell[3414, 135, 125, 3, 70, "ExampleDelimiter",
 CellID->260366343],
Cell[3542, 140, 252, 8, 70, "UpgradeDetail",
 CellID->148245370],
Cell[3797, 150, 187, 5, 70, "Input",
 CellID->873779382],
Cell[CellGroupData[{
Cell[4009, 159, 175, 5, 70, "Input",
 CellID->75025638],
Cell[4187, 166, 88, 2, 70, "Output",
 CellID->52195965]
}, Open  ]],
Cell[4290, 171, 219, 7, 70, "Input",
 CellID->156217555],
Cell[CellGroupData[{
Cell[4534, 182, 201, 6, 70, "Input",
 CellID->438868097],
Cell[4738, 190, 249, 7, 70, "Output",
 CellID->546859665]
}, Open  ]]
}, Open  ]],
Cell[5014, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

