(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25919,        999]
NotebookOptionsPosition[     19912,        793]
NotebookOutlinePosition[     20889,        821]
CellTagsIndexPosition[     20846,        818]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`DescriptiveStatistics`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "Functionality in this package has been added to the built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\n",
 Cell[BoxData["Mode"], "InlineFormula"],
 " is replaced by the kernel function ",
 Cell[BoxData[
  ButtonBox["Commonest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Commonest"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CentralMoment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CentralMoment"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["GeometricMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricMean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["HarmonicMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HarmonicMean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InterquartileRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterquartileRange"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Kurtosis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Kurtosis"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["QuartileDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuartileDeviation"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Quartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quartiles"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["QuartileSkewness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuartileSkewness"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Skewness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skewness"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TrimmedMean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrimmedMean"]], "InlineFormula"],
 " are now part of the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "UpgradeDetail",
 CellID->556646693],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"GeometricMean", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeometricMean", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[61]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"10", " ", 
  SuperscriptBox["15", 
   RowBox[{"1", "/", "5"}]]}]], "Output",
 CellLabel->"Out[61]=",
 CellID->221693580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56503734],

Cell[TextData[{
 "Mode is replaced by ",
 Cell[BoxData[
  ButtonBox["Commonest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Commonest"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->245467195],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Mode", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->212315539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Commonest", "[", 
   RowBox[{"{", 
    RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], "]"}], 
  "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166843422],

Cell[BoxData["10"], "Output",
 CellLabel->"Out[2]=",
 CellID->207239211]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->150417488],

Cell[TextData[{
 Cell[BoxData["CoefficientOfVariation"], "InlineFormula"],
 " can be computed using ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->598717502],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CoefficientOfVariation", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->106920771],

Cell[BoxData[
 RowBox[{
  RowBox[{"CoefficientOfVariation", "[", "data_", "]"}], ":=", 
  RowBox[{
   RowBox[{"StandardDeviation", "[", "data", "]"}], "/", 
   RowBox[{"Mean", "[", "data", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->170295378],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientOfVariation", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->103035930],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SqrtBox[
    FractionBox["10", "7"]]}], "3"]], "Output",
 CellLabel->"Out[3]=",
 CellID->269469406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->782357569],

Cell[TextData[{
 Cell[BoxData["SampleRange"], "InlineFormula"],
 " can be computed using ",
 Cell[BoxData[
  ButtonBox["Min",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Min"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->48587845],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SampleRange", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->23348653],

Cell[BoxData[
 RowBox[{
  RowBox[{"SampleRange", "[", "data_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Min", "[", "data", "]"}], ",", 
    RowBox[{"Max", "[", "data", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->499922830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SampleRange", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->359718975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "50"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->141889972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14318716],

Cell[TextData[{
 Cell[BoxData["KurtosisExcess"], "InlineFormula"],
 " can be computed from ",
 Cell[BoxData[
  ButtonBox["Kurtosis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Kurtosis"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->40519099],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"KurtosisExcess", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->81254237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Kurtosis", "[", 
   RowBox[{"{", 
    RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], "]"}], 
  "-", "3"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->354492564],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["739", "12544"]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->762569132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->216775021],

Cell[TextData[{
 Cell[BoxData["ZeroMean"], "InlineFormula"],
 " can be computed by subtracting the mean from the data:"
}], "UpgradeDetail",
 CellID->784821678],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ZeroMean", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->153396708],

Cell[BoxData[
 RowBox[{
  RowBox[{"ZeroMean", "[", "data_", "]"}], ":=", 
  RowBox[{"data", "-", 
   RowBox[{"Mean", "[", "data", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->103283878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZeroMean", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->52286549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "11"}], ",", "29", ",", 
   RowBox[{"-", "11"}], ",", 
   RowBox[{"-", "6"}], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->141115223]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73644665],

Cell[TextData[{
 Cell[BoxData["InterpolatedQuantile"], "InlineFormula"],
 " can be computed as a parameterized ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->83316969],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"InterpolatedQuantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], ",", 
   RowBox[{"3", "/", "4"}]}], "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->58899754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], ",", 
   RowBox[{"3", "/", "4"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280392641],

Cell[BoxData[
 FractionBox["55", "2"]], "Output",
 CellLabel->"Out[2]=",
 CellID->564521995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146979865],

Cell[TextData[{
 Cell[BoxData["LocationReport"], "InlineFormula"],
 ", ",
 Cell[BoxData["DispersionReport"], "InlineFormula"],
 ", and ",
 Cell[BoxData["ShapeReport"], "InlineFormula"],
 " can be constructed directly from the report elements:"
}], "UpgradeDetail",
 CellID->342839127],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LocationReport", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->127458192],

Cell[BoxData[
 RowBox[{
  RowBox[{"LocationReport", "[", "data_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Mean", "\[Rule]", 
     RowBox[{"Mean", "[", "data", "]"}]}], ",", 
    RowBox[{"HarmonicMean", "->", 
     RowBox[{"HarmonicMean", "[", "data", "]"}]}], ",", 
    RowBox[{"Median", "\[Rule]", 
     RowBox[{"Median", "[", "data", "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->359904671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocationReport", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->278227412],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mean", "\[Rule]", "21"}], ",", 
   RowBox[{"HarmonicMean", "\[Rule]", 
    FractionBox["1500", "101"]}], ",", 
   RowBox[{"Median", "\[Rule]", "15"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->84608528]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221477223],

Cell[TextData[{
 "Alternate standard deviations and variances can be computed from ",
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->166469807],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"StandardDeviationMLE", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->269574689],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardDeviationMLE", "[", "data_", "]"}], ":=", 
  RowBox[{
   RowBox[{"StandardDeviation", "[", "data", "]"}], 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}], "/", 
     RowBox[{"Length", "[", "data", "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63041525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviationMLE", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->348436510],

Cell[BoxData[
 RowBox[{"4", " ", 
  SqrtBox["14"]}]], "Output",
 CellLabel->"Out[3]=",
 CellID->51928612]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"VarianceMLE", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[4]:=",
 CellID->55056357],

Cell[BoxData[
 RowBox[{
  RowBox[{"VarianceMLE", "[", "data_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Variance", "[", "data", "]"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}], "/", 
    RowBox[{"Length", "[", "data", "]"}]}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->7649341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceMLE", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->591527702],

Cell[BoxData["224"], "Output",
 CellLabel->"Out[6]=",
 CellID->108834532]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"StandardErrorOfSampleMean", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[7]:=",
 CellID->77293247],

Cell[BoxData[
 RowBox[{
  RowBox[{"StandardErrorOfSampleMean", "[", "data_", "]"}], ":=", 
  RowBox[{
   RowBox[{"StandardDeviation", "[", "data", "]"}], "/", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"Length", "[", "data", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->365779903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardErrorOfSampleMean", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->6720497],

Cell[BoxData[
 RowBox[{"2", " ", 
  SqrtBox["14"]}]], "Output",
 CellLabel->"Out[9]=",
 CellID->331769432]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"VarianceOfSampleMean", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[10]:=",
 CellID->155758076],

Cell[BoxData[
 RowBox[{
  RowBox[{"VarianceOfMean", "[", "data_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Variance", "[", "data", "]"}], "/", 
   RowBox[{"Length", "[", "data", "]"}]}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->513001525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VarianceOfMean", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->860717815],

Cell[BoxData["56"], "Output",
 CellLabel->"Out[12]=",
 CellID->251511959]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->315191894],

Cell["\<\
Pearson skewness measures can be computed from basic statistics:\
\>", "UpgradeDetail",
 CellID->346231866],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"PearsonSkewness1", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[1]:=",
 CellID->54858774],

Cell[BoxData[
 RowBox[{
  RowBox[{"PearsonSkewness1", "[", "data_", "]"}], ":=", 
  RowBox[{"3", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Mean", "[", "data", "]"}], "-", 
      RowBox[{
       RowBox[{"Commonest", "[", "data", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", 
    RowBox[{"StandardDeviation", "[", "data", "]"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->391287669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PearsonSkewness1", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->534955481],

Cell[BoxData[
 FractionBox["33", 
  RowBox[{"2", " ", 
   SqrtBox["70"]}]]], "Output",
 CellLabel->"Out[3]=",
 CellID->379999412]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DescriptiveStatistics`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"PearsonSkewness2", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[4]:=",
 CellID->96979782],

Cell[BoxData[
 RowBox[{
  RowBox[{"PearsonSkewness2", "[", "data_", "]"}], ":=", 
  RowBox[{"3", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Mean", "[", "data", "]"}], "-", 
      RowBox[{"Median", "[", "data", "]"}]}], ")"}], "/", 
    RowBox[{"StandardDeviation", "[", "data", "]"}]}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->17907746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PearsonSkewness2", "[", 
  RowBox[{"{", 
   RowBox[{"10", ",", "50", ",", "10", ",", "15", ",", "20"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->920638389],

Cell[BoxData[
 FractionBox["9", 
  SqrtBox["70"]]], "Output",
 CellLabel->"Out[6]=",
 CellID->58140289]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 18.5810440}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/DescriptiveStatistics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 83, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[895, 35, 404, 13, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1302, 50, 1912, 70, 70, "UpgradeDetail",
 CellID->556646693],
Cell[3217, 122, 288, 8, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[3530, 134, 196, 6, 70, "Input",
 CellID->1746043248],
Cell[3729, 142, 144, 5, 70, "Output",
 CellID->221693580]
}, Open  ]],
Cell[3888, 150, 124, 3, 70, "ExampleDelimiter",
 CellID->56503734],
Cell[4015, 155, 207, 8, 70, "UpgradeDetail",
 CellID->245467195],
Cell[4225, 165, 301, 9, 70, "Input",
 CellID->212315539],
Cell[CellGroupData[{
Cell[4551, 178, 243, 8, 70, "Input",
 CellID->166843422],
Cell[4797, 188, 72, 2, 70, "Output",
 CellID->207239211]
}, Open  ]],
Cell[4884, 193, 125, 3, 70, "ExampleDelimiter",
 CellID->150417488],
Cell[5012, 198, 406, 14, 70, "UpgradeDetail",
 CellID->598717502],
Cell[5421, 214, 319, 9, 70, "Input",
 CellID->106920771],
Cell[5743, 225, 252, 7, 70, "Input",
 CellID->170295378],
Cell[CellGroupData[{
Cell[6020, 236, 203, 6, 70, "Input",
 CellID->103035930],
Cell[6226, 244, 151, 6, 70, "Output",
 CellID->269469406]
}, Open  ]],
Cell[6392, 253, 125, 3, 70, "ExampleDelimiter",
 CellID->782357569],
Cell[6520, 258, 364, 14, 70, "UpgradeDetail",
 CellID->48587845],
Cell[6887, 274, 307, 9, 70, "Input",
 CellID->23348653],
Cell[7197, 285, 252, 8, 70, "Input",
 CellID->499922830],
Cell[CellGroupData[{
Cell[7474, 297, 192, 6, 70, "Input",
 CellID->359718975],
Cell[7669, 305, 118, 4, 70, "Output",
 CellID->141889972]
}, Open  ]],
Cell[7802, 312, 124, 3, 70, "ExampleDelimiter",
 CellID->14318716],
Cell[7929, 317, 257, 9, 70, "UpgradeDetail",
 CellID->40519099],
Cell[8189, 328, 310, 9, 70, "Input",
 CellID->81254237],
Cell[CellGroupData[{
Cell[8524, 341, 214, 7, 70, "Input",
 CellID->354492564],
Cell[8741, 350, 115, 4, 70, "Output",
 CellID->762569132]
}, Open  ]],
Cell[8871, 357, 125, 3, 70, "ExampleDelimiter",
 CellID->216775021],
Cell[8999, 362, 160, 4, 70, "UpgradeDetail",
 CellID->784821678],
Cell[9162, 368, 305, 9, 70, "Input",
 CellID->153396708],
Cell[9470, 379, 193, 6, 70, "Input",
 CellID->103283878],
Cell[CellGroupData[{
Cell[9688, 389, 188, 6, 70, "Input",
 CellID->52286549],
Cell[9879, 397, 225, 8, 70, "Output",
 CellID->141115223]
}, Open  ]],
Cell[10119, 408, 124, 3, 70, "ExampleDelimiter",
 CellID->73644665],
Cell[10246, 413, 277, 9, 70, "UpgradeDetail",
 CellID->83316969],
Cell[10526, 424, 362, 10, 70, "Input",
 CellID->58899754],
Cell[CellGroupData[{
Cell[10913, 438, 428, 14, 70, "Input",
 CellID->280392641],
Cell[11344, 454, 92, 3, 70, "Output",
 CellID->564521995]
}, Open  ]],
Cell[11451, 460, 125, 3, 70, "ExampleDelimiter",
 CellID->146979865],
Cell[11579, 465, 284, 8, 70, "UpgradeDetail",
 CellID->342839127],
Cell[11866, 475, 311, 9, 70, "Input",
 CellID->127458192],
Cell[12180, 486, 423, 12, 70, "Input",
 CellID->359904671],
Cell[CellGroupData[{
Cell[12628, 502, 195, 6, 70, "Input",
 CellID->278227412],
Cell[12826, 510, 264, 8, 70, "Output",
 CellID->84608528]
}, Open  ]],
Cell[13105, 521, 125, 3, 70, "ExampleDelimiter",
 CellID->221477223],
Cell[13233, 526, 397, 13, 70, "UpgradeDetail",
 CellID->166469807],
Cell[13633, 541, 317, 9, 70, "Input",
 CellID->269574689],
Cell[13953, 552, 399, 12, 70, "Input",
 CellID->63041525],
Cell[CellGroupData[{
Cell[14377, 568, 201, 6, 70, "Input",
 CellID->348436510],
Cell[14581, 576, 105, 4, 70, "Output",
 CellID->51928612]
}, Open  ]],
Cell[14701, 583, 307, 9, 70, "Input",
 CellID->55056357],
Cell[15011, 594, 343, 11, 70, "Input",
 CellID->7649341],
Cell[CellGroupData[{
Cell[15379, 609, 192, 6, 70, "Input",
 CellID->591527702],
Cell[15574, 617, 73, 2, 70, "Output",
 CellID->108834532]
}, Open  ]],
Cell[15662, 622, 321, 9, 70, "Input",
 CellID->77293247],
Cell[15986, 633, 290, 8, 70, "Input",
 CellID->365779903],
Cell[CellGroupData[{
Cell[16301, 645, 204, 6, 70, "Input",
 CellID->6720497],
Cell[16508, 653, 106, 4, 70, "Output",
 CellID->331769432]
}, Open  ]],
Cell[16629, 660, 318, 9, 70, "Input",
 CellID->155758076],
Cell[16950, 671, 238, 7, 70, "Input",
 CellID->513001525],
Cell[CellGroupData[{
Cell[17213, 682, 196, 6, 70, "Input",
 CellID->860717815],
Cell[17412, 690, 73, 2, 70, "Output",
 CellID->251511959]
}, Open  ]],
Cell[17500, 695, 125, 3, 70, "ExampleDelimiter",
 CellID->315191894],
Cell[17628, 700, 117, 3, 70, "UpgradeDetail",
 CellID->346231866],
Cell[17748, 705, 312, 9, 70, "Input",
 CellID->54858774],
Cell[18063, 716, 424, 13, 70, "Input",
 CellID->391287669],
Cell[CellGroupData[{
Cell[18512, 733, 197, 6, 70, "Input",
 CellID->534955481],
Cell[18712, 741, 129, 5, 70, "Output",
 CellID->379999412]
}, Open  ]],
Cell[18856, 749, 312, 9, 70, "Input",
 CellID->96979782],
Cell[19171, 760, 359, 11, 70, "Input",
 CellID->17907746],
Cell[CellGroupData[{
Cell[19555, 775, 197, 6, 70, "Input",
 CellID->920638389],
Cell[19755, 783, 103, 4, 70, "Output",
 CellID->58140289]
}, Open  ]]
}, Open  ]],
Cell[19885, 791, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

