(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8547,        326]
NotebookOptionsPosition[      5901,        238]
NotebookOutlinePosition[      6878,        266]
CellTagsIndexPosition[      6835,        263]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`DiscreteDistributions`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "Distributions defined in this package have been added to the built-in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel.\nThe input syntax for ",
 Cell[BoxData[
  ButtonBox["DiscreteUniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteUniformDistribution"]], "InlineFormula"],
 " has changed.\n",
 Cell[BoxData["Random"], "InlineFormula"],
 " and ",
 Cell[BoxData["RandomArray"], "InlineFormula"],
 " are replaced by ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Discrete distributions are now part of the built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "UpgradeDetail",
 CellID->7810128],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DiscreteDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Mean", "[", 
  RowBox[{"BinomialDistribution", "[", 
   RowBox[{"n", ",", "p"}], "]"}], "]"}]}], "Input", "LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"BinomialDistribution", "[", 
   RowBox[{"n", ",", "p"}], "]"}], "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->1746043248],

Cell[BoxData[
 RowBox[{"n", " ", "p"}]], "Output",
 CellLabel->"Out[45]=",
 CellID->17938542]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12859929],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiscreteUniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteUniformDistribution"]], "InlineFormula"],
 " is now parameterized by a pair of integer endpoints {",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 "}:"
}], "UpgradeDetail",
 CellID->380726846],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DiscreteDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Mean", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", "max", "]"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->391943743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63946252],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "max"}], "2"]], "Output",
 CellLabel->"Out[2]=",
 CellID->79334015]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122019624],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiscreteUniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteUniformDistribution"]], "InlineFormula"],
 " allows for integer ranges for which ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " is not 1:"
}], "UpgradeDetail",
 CellID->40926091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"5", ",", "10"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->801939590],

Cell[BoxData[
 FractionBox["15", "2"]], "Output",
 CellLabel->"Out[1]=",
 CellID->50723949]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->260366343],

Cell[TextData[{
 "Random elements for discrete distributions are generated via ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->148245370],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DiscreteDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Random", "[", 
  RowBox[{"PoissonDistribution", "[", "10", "]"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->873779382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{"PoissonDistribution", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75025638],

Cell[BoxData["11"], "Output",
 CellLabel->"Out[2]=",
 CellID->30706131]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`DiscreteDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomArray", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "10", "]"}], ",", "5"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[3]:=",
 CellID->156217555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "10", "]"}], ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->438868097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "13", ",", "6", ",", "7", ",", "9"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->555979633]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 18.7685488}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/DiscreteDistributions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 83, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[895, 35, 652, 20, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1550, 57, 180, 6, 70, "UpgradeDetail",
 CellID->7810128],
Cell[1733, 65, 265, 7, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2023, 76, 173, 5, 70, "Input",
 CellID->1746043248],
Cell[2199, 83, 93, 3, 70, "Output",
 CellID->17938542]
}, Open  ]],
Cell[2307, 89, 124, 3, 70, "ExampleDelimiter",
 CellID->12859929],
Cell[2434, 94, 403, 13, 70, "UpgradeDetail",
 CellID->380726846],
Cell[2840, 109, 274, 8, 70, "Input",
 CellID->391943743],
Cell[CellGroupData[{
Cell[3139, 121, 204, 6, 70, "Input",
 CellID->63946252],
Cell[3346, 129, 115, 4, 70, "Output",
 CellID->79334015]
}, Open  ]],
Cell[3476, 136, 125, 3, 70, "ExampleDelimiter",
 CellID->122019624],
Cell[3604, 141, 327, 10, 70, "UpgradeDetail",
 CellID->40926091],
Cell[CellGroupData[{
Cell[3956, 155, 204, 6, 70, "Input",
 CellID->801939590],
Cell[4163, 163, 91, 3, 70, "Output",
 CellID->50723949]
}, Open  ]],
Cell[4269, 169, 125, 3, 70, "ExampleDelimiter",
 CellID->260366343],
Cell[4397, 174, 256, 8, 70, "UpgradeDetail",
 CellID->148245370],
Cell[4656, 184, 267, 8, 70, "Input",
 CellID->873779382],
Cell[CellGroupData[{
Cell[4948, 196, 155, 4, 70, "Input",
 CellID->75025638],
Cell[5106, 202, 71, 2, 70, "Output",
 CellID->30706131]
}, Open  ]],
Cell[5192, 207, 297, 9, 70, "Input",
 CellID->156217555],
Cell[CellGroupData[{
Cell[5514, 220, 183, 6, 70, "Input",
 CellID->438868097],
Cell[5700, 228, 147, 4, 70, "Output",
 CellID->555979633]
}, Open  ]]
}, Open  ]],
Cell[5874, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

