(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9632,        349]
NotebookOptionsPosition[      7244,        271]
NotebookOutlinePosition[      8226,        299]
CellTagsIndexPosition[      8183,        296]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPATIBILITY PACKAGE UPGRADE INFORMATION", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Upgrading from:", "UpgradeLabel",
 CellID->509267359],

Cell["Statistics`MultiDiscreteDistributions`", "UpgradeObjectName",
 CellID->1949069365],

Cell[TextData[{
 "Distributions defined in this package are included in the newly created ",
 ButtonBox["Multivariate Statistics Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:MultivariateStatistics/guide/MultivariateStatisticsPackage"],
 ".\n",
 Cell[BoxData[
  ButtonBox["Random",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Random"]], "InlineFormula"],
 " and ",
 Cell[BoxData["RandomArray"], "InlineFormula"],
 " are replaced by ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ".\n",
 Cell[BoxData["CovarianceMatrix"], "InlineFormula"],
 " and ",
 Cell[BoxData["CorrelationMatrix"], "InlineFormula"],
 " are replaced by ",
 Cell[BoxData[
  ButtonBox["Covariance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Covariance"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Correlation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Correlation"]], "InlineFormula"],
 "."
}], "UpgradeSummary",
 CellID->1010000471],

Cell[TextData[{
 "Load ",
 Cell[BoxData["MultivariateStatistics`"], "InlineFormula"],
 " to use ",
 ButtonBox["Multivariate Statistics Package",
  BaseStyle->"Link",
  ButtonData->
   "paclet:MultivariateStatistics/guide/MultivariateStatisticsPackage"],
 " functionality:"
}], "UpgradeDetail",
 CellID->746756666],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDiscreteDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultinomialDistribution", "[", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "5"}], ",", 
       RowBox[{"3", "/", "10"}], ",", 
       RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3"}], "}"}]}], "]"}]}], "Input", \
"LegacyInput",
 CellID->1663071679],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "MultivariateStatistics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultinomialDistribution", "[", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "5"}], ",", 
       RowBox[{"3", "/", "10"}], ",", 
       RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "3"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[123]:=",
 CellID->2088293695],

Cell[BoxData[
 FractionBox["1701", "50000"]], "Output",
 CellLabel->"Out[124]=",
 CellID->707650785]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->260366343],

Cell[TextData[{
 "Random elements for multivariate discrete distributions are generated via \
",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ":"
}], "UpgradeDetail",
 CellID->148245370],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDiscreteDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Random", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{"10", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->873779382],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "MultivariateStatistics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomInteger", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{"10", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->75025638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "14", ",", "11"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->85691727]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDiscreteDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomArray", "[", 
  RowBox[{
   RowBox[{"MultiPoissonDistribution", "[", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], ",", "5"}], 
  "]"}]}], "Input", "LegacyInput",
 CellLabel->"In[3]:=",
 CellID->156217555],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "MultivariateStatistics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"MultiPoissonDistribution", "[", 
    RowBox[{"10", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], ",", "5"}], 
  "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->438868097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11", ",", "12", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "11", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"16", ",", "15", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "11", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"11", ",", "13", ",", "12"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->598679114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->249932506],

Cell["Covariance matrix for a multivariate distribution:", "UpgradeDetail",
 CellID->415013396],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "Statistics`MultiDiscreteDistributions`"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CovarianceMatrix", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{"10", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "Input", \
"LegacyInput",
 CellLabel->"In[1]:=",
 CellID->193580160],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "MultivariateStatistics`"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Covariance", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{"10", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->414360418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11", ",", "10", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "12", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "10", ",", "13"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->487474372]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->" - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 19.4091902}", "context" -> "XXXX`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Compatibility Package Upgrade Information", "language" -> "en", "paclet" -> 
    "Compatibility Package", "status" -> "None", "summary" -> "", 
    "synonyms" -> {}, "title" -> "", "type" -> "Upgrade Information", "uri" -> 
    "Compatibility/ref/MultiDiscreteDistributions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 124, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[747, 29, 59, 1, 70, "UpgradeLabel",
 CellID->509267359],
Cell[809, 32, 88, 1, 70, "UpgradeObjectName",
 CellID->1949069365],
Cell[900, 35, 1032, 34, 70, "UpgradeSummary",
 CellID->1010000471],
Cell[1935, 71, 313, 10, 70, "UpgradeDetail",
 CellID->746756666],
Cell[2251, 83, 507, 16, 70, "Input",
 CellID->1663071679],
Cell[CellGroupData[{
Cell[2783, 103, 497, 15, 70, "Input",
 CellID->2088293695],
Cell[3283, 120, 100, 3, 70, "Output",
 CellID->707650785]
}, Open  ]],
Cell[3398, 126, 125, 3, 70, "ExampleDelimiter",
 CellID->260366343],
Cell[3526, 131, 271, 9, 70, "UpgradeDetail",
 CellID->148245370],
Cell[3800, 142, 362, 11, 70, "Input",
 CellID->873779382],
Cell[CellGroupData[{
Cell[4187, 157, 333, 9, 70, "Input",
 CellID->75025638],
Cell[4523, 168, 128, 4, 70, "Output",
 CellID->85691727]
}, Open  ]],
Cell[4666, 175, 395, 12, 70, "Input",
 CellID->156217555],
Cell[CellGroupData[{
Cell[5086, 191, 364, 11, 70, "Input",
 CellID->438868097],
Cell[5453, 204, 453, 14, 70, "Output",
 CellID->598679114]
}, Open  ]],
Cell[5921, 221, 125, 3, 70, "ExampleDelimiter",
 CellID->249932506],
Cell[6049, 226, 95, 1, 70, "UpgradeDetail",
 CellID->415013396],
Cell[6147, 229, 372, 11, 70, "Input",
 CellID->193580160],
Cell[CellGroupData[{
Cell[6544, 244, 331, 9, 70, "Input",
 CellID->414360418],
Cell[6878, 255, 312, 10, 70, "Output",
 CellID->487474372]
}, Open  ]]
}, Open  ]],
Cell[7217, 269, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

