(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5662,        191]
NotebookOptionsPosition[      4083,        143]
NotebookOutlinePosition[      5206,        173]
CellTagsIndexPosition[      5163,        170]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Computational Geometry Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ConvexHull" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/ConvexHull"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ConvexHull\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ConvexHullArea", "ObjectName",
 CellID->2807],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ConvexHullArea", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TI"], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["n", "TI"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["n", "TI"]]}], "}"}]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the area of the convex hull of the bivariate \
data."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18127]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2594],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ConvexHull",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/ConvexHull"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->1569708019]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3092],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], "Tutorials",\

 CellID->1882]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConvexHullArea - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 27.6125252}", "context" -> 
    "ComputationalGeometry`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Symbol", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "ConvexHullArea[{{x_1, y_1}, ..., {x_n, y_n}}] gives the area of the \
convex hull of the bivariate data.", "synonyms" -> {}, "title" -> 
    "ConvexHullArea", "type" -> "Symbol", "uri" -> 
    "ComputationalGeometry/ref/ConvexHullArea"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1272, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1895, 61, 51, 1, 70, "ObjectName",
 CellID->2807],
Cell[1949, 64, 974, 31, 70, "Usage",
 CellID->18127]
}, Open  ]],
Cell[CellGroupData[{
Cell[2960, 100, 310, 9, 70, "SeeAlsoSection",
 CellID->2594],
Cell[3273, 111, 227, 6, 70, "SeeAlso",
 CellID->1569708019]
}, Open  ]],
Cell[CellGroupData[{
Cell[3537, 122, 313, 9, 70, "TutorialsSection",
 CellID->3092],
Cell[3853, 133, 188, 5, 70, "Tutorials",
 CellID->1882]
}, Open  ]],
Cell[4056, 141, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

