(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11990,        403]
NotebookOptionsPosition[      9853,        340]
NotebookOutlinePosition[     11165,        372]
CellTagsIndexPosition[     11122,        369]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Computational Geometry Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VoronoiDiagram" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/VoronoiDiagram"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"VoronoiDiagram\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DiagramPlot", "ObjectName",
 CellID->19904],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DiagramPlot", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]plots the Voronoi diagram of the points ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DiagramPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["q", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["q", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]plots the points ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " as well as the diagram described by the vertices ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["q", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["q", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     " and the vertex adjacency list ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23338]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["DiagramPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions:"
}], "Notes",
 CellID->17900],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LabelPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ComputationalGeometry/ref/LabelPoints"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether points are labeled", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TrimPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ComputationalGeometry/ref/TrimPoints"], "0", Cell[
    "number of diagram vertices to trim", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->8276],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["LabelPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/LabelPoints"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LabelPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/LabelPoints"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", each point is labeled according to its position in the input list."
}], "Notes",
 CellID->1542],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["TrimPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/TrimPoints"]], 
  "InlineFormula"],
 " is any nonnegative integer. Regardless of the setting for ",
 Cell[BoxData[
  ButtonBox["TrimPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/TrimPoints"]], 
  "InlineFormula"],
 ", the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is always large enough to include all of the points ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["1", "TR"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", 
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["2", "TR"]]}], "}"}], ",", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"]
}], "Notes",
 CellID->26465]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26330],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["VoronoiDiagram",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/VoronoiDiagram"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->1825041491]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30831],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], "Tutorials",\

 CellID->8344]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DiagramPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 35.0189648}", "context" -> 
    "ComputationalGeometry`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Symbol", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "DiagramPlot[{{x_1, y_1}, {x_2, y_2}, ...}] plots the Voronoi diagram of \
the points {{x_1, y_1}, ...}. DiagramPlot[{{x_1, y_1}, {x_2, y_2}, ...}, \
{q_1, q_2, ...}, val] plots the points {{x_1, y_1}, ...} as well as the \
diagram described by the vertices q_1, q_2, ... and the vertex adjacency list \
val.", "synonyms" -> {}, "title" -> "DiagramPlot", "type" -> "Symbol", "uri" -> 
    "ComputationalGeometry/ref/DiagramPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1284, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1907, 61, 49, 1, 70, "ObjectName",
 CellID->19904],
Cell[1959, 64, 3243, 104, 70, "Usage",
 CellID->23338]
}, Open  ]],
Cell[CellGroupData[{
Cell[5239, 173, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5717, 190, 276, 9, 70, "Notes",
 CellID->17900],
Cell[5996, 201, 774, 20, 70, "3ColumnTableMod",
 CellID->8276],
Cell[6773, 223, 807, 28, 70, "Notes",
 CellID->1542],
Cell[7583, 253, 1100, 39, 70, "Notes",
 CellID->26465]
}, Closed]],
Cell[CellGroupData[{
Cell[8720, 297, 311, 9, 70, "SeeAlsoSection",
 CellID->26330],
Cell[9034, 308, 235, 6, 70, "SeeAlso",
 CellID->1825041491]
}, Open  ]],
Cell[CellGroupData[{
Cell[9306, 319, 314, 9, 70, "TutorialsSection",
 CellID->30831],
Cell[9623, 330, 188, 5, 70, "Tutorials",
 CellID->8344]
}, Open  ]],
Cell[9826, 338, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

