(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7677,        266]
NotebookOptionsPosition[      5812,        209]
NotebookOutlinePosition[      6980,        239]
CellTagsIndexPosition[      6937,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Computational Geometry Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DelaunayTriangulation" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/DelaunayTriangulation"], 
          "ConvexHull" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/ConvexHull"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DelaunayTriangulation\"\>", 
       2->"\<\"ConvexHull\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Hull", "ObjectName",
 CellID->7968],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Hull"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["DelaunayTriangulation",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"]],
       "InlineFormula"],
     " that specifies whether the convex hull ",
     Cell[BoxData[
      StyleBox["hull", "TI"]], "InlineFormula"],
     " is to be returned in addition to the vertex adjacency list ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " describing the triangulation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25657]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31515],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"Hull", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 " is returned. With the setting ",
 Cell[BoxData[
  RowBox[{"Hull", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["val", "TI"], ",", 
    StyleBox["hull", "TI"]}], "}"}]], "InlineFormula"],
 " is returned."
}], "Notes",
 CellID->30689]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20062],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DelaunayTriangulation",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConvexHull",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/ConvexHull"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->865]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8574],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], "Tutorials",\

 CellID->22603]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Hull - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 35.1908442}", "context" -> 
    "ComputationalGeometry`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Symbol", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "Hull is an option to DelaunayTriangulation that specifies whether the \
convex hull hull is to be returned in addition to the vertex adjacency list \
val describing the triangulation. ", "synonyms" -> {}, "title" -> "Hull", 
    "type" -> "Symbol", "uri" -> "ComputationalGeometry/ref/Hull"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1453, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2076, 64, 41, 1, 70, "ObjectName",
 CellID->7968],
Cell[2120, 67, 793, 22, 70, "Usage",
 CellID->25657]
}, Open  ]],
Cell[CellGroupData[{
Cell[2950, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3428, 111, 307, 13, 70, "Notes",
 CellID->31515],
Cell[3738, 126, 616, 24, 70, "Notes",
 CellID->30689]
}, Closed]],
Cell[CellGroupData[{
Cell[4391, 155, 311, 9, 70, "SeeAlsoSection",
 CellID->20062],
Cell[4705, 166, 523, 17, 70, "SeeAlso",
 CellID->865]
}, Open  ]],
Cell[CellGroupData[{
Cell[5265, 188, 313, 9, 70, "TutorialsSection",
 CellID->8574],
Cell[5581, 199, 189, 5, 70, "Tutorials",
 CellID->22603]
}, Open  ]],
Cell[5785, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

