(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11332,        385]
NotebookOptionsPosition[      9201,        322]
NotebookOutlinePosition[     10508,        354]
CellTagsIndexPosition[     10465,        351]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Computational Geometry Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DelaunayTriangulation" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/DelaunayTriangulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"DelaunayTriangulation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PlanarGraphPlot", "ObjectName",
 CellID->834],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PlanarGraphPlot", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots the Delaunay triangulation of the points ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"PlanarGraphPlot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["y", "TI"], 
              StyleBox["1", "TR"]]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["2", "TR"]], ",", 
             SubscriptBox[
              StyleBox["y", "TI"], 
              StyleBox["2", "TR"]]}], "}"}], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["g", "TI"]}], "]"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]plots the points ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     " as well as the planar graph described by the vertex adjacency list or \
circuit ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30086]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The planar graph ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " may be a vertex adjacency list of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " or a single circuit of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " refers to the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20716],

Cell[TextData[{
 Cell[BoxData["PlanarGraphPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following addition:"
}], "Notes",
 CellID->20692],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LabelPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ComputationalGeometry/ref/LabelPoints"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether points are labeled", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->24772],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["LabelPoints",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/LabelPoints"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LabelPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/LabelPoints"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", each point is labeled according to its position in the input list."
}], "Notes",
 CellID->28722]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22519],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DelaunayTriangulation",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/DelaunayTriangulation"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->1774592082]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31132],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], "Tutorials",\

 CellID->5618]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PlanarGraphPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 35.6596062}", "context" -> 
    "ComputationalGeometry`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Symbol", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "PlanarGraphPlot[{{x_1, y_1}, {x_2, y_2}, ...}] plots the Delaunay \
triangulation of the points {{x_1, y_1}, ...}. PlanarGraphPlot[{{x_1, y_1}, \
{x_2, y_2}, ...}, g]] plots the points {{x_1, y_1}, ...} as well as the \
planar graph described by the vertex adjacency list or circuit g.", 
    "synonyms" -> {}, "title" -> "PlanarGraphPlot", "type" -> "Symbol", "uri" -> 
    "ComputationalGeometry/ref/PlanarGraphPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1306, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1929, 61, 51, 1, 70, "ObjectName",
 CellID->834],
Cell[1983, 64, 2732, 87, 70, "Usage",
 CellID->30086]
}, Open  ]],
Cell[CellGroupData[{
Cell[4752, 156, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5230, 173, 1150, 43, 70, "Notes",
 CellID->20716],
Cell[6383, 218, 279, 9, 70, "Notes",
 CellID->20692],
Cell[6665, 229, 541, 15, 70, "3ColumnTableMod",
 CellID->24772],
Cell[7209, 246, 808, 28, 70, "Notes",
 CellID->28722]
}, Closed]],
Cell[CellGroupData[{
Cell[8054, 279, 311, 9, 70, "SeeAlsoSection",
 CellID->22519],
Cell[8368, 290, 249, 6, 70, "SeeAlso",
 CellID->1774592082]
}, Open  ]],
Cell[CellGroupData[{
Cell[8654, 301, 314, 9, 70, "TutorialsSection",
 CellID->31132],
Cell[8971, 312, 188, 5, 70, "Tutorials",
 CellID->5618]
}, Open  ]],
Cell[9174, 320, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

