(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7337,        259]
NotebookOptionsPosition[      5408,        198]
NotebookOutlinePosition[      6528,        228]
CellTagsIndexPosition[      6485,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTATIONAL GEOMETRY PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Computational Geometry Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DiagramPlot" :> 
          Documentation`HelpLookup[
           "paclet:ComputationalGeometry/ref/DiagramPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"DiagramPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TrimPoints", "ObjectName",
 CellID->10808],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["TrimPoints"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["DiagramPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"]], 
      "InlineFormula"],
     " that specifies which diagram outlier vertex lies on the ",
     Cell[BoxData[
      ButtonBox["PlotRange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
     " limit."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5983]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Valid settings are nonnegative integers.", "Notes",
 CellID->17913],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"TrimPoints", "->", "0"}]], "InlineFormula"],
 " includes all diagram vertices."
}], "Notes",
 CellID->1451],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"TrimPoints", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " places the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], "th"]], "InlineFormula"],
 " largest diagram vertex on the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " limit."
}], "Notes",
 CellID->6916],

Cell[TextData[{
 "In all cases, ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " is set large enough to include all points specified in ",
 Cell[BoxData[
  ButtonBox["DiagramPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->30945]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21502],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DiagramPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputationalGeometry/ref/DiagramPlot"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->1899158999]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29695],

Cell[TextData[ButtonBox["Computational Geometry Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputationalGeometry/tutorial/ComputationalGeometry"]], "Tutorials",\

 CellID->14644]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrimPoints - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 42.8785410}", "context" -> 
    "ComputationalGeometry`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computational Geometry Package Symbol", "language" -> "en", "paclet" -> 
    "ComputationalGeometry Package", "status" -> "None", "summary" -> 
    "TrimPoints is an option to DiagramPlot that specifies which diagram \
outlier vertex lies on the PlotRange limit.", "synonyms" -> {}, "title" -> 
    "TrimPoints", "type" -> "Symbol", "uri" -> 
    "ComputationalGeometry/ref/TrimPoints"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1275, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1898, 61, 48, 1, 70, "ObjectName",
 CellID->10808],
Cell[1949, 64, 704, 21, 70, "Usage",
 CellID->5983]
}, Open  ]],
Cell[CellGroupData[{
Cell[2690, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3168, 107, 73, 1, 70, "Notes",
 CellID->17913],
Cell[3244, 110, 174, 6, 70, "Notes",
 CellID->1451],
Cell[3421, 118, 419, 16, 70, "Notes",
 CellID->6916],
Cell[3843, 136, 400, 14, 70, "Notes",
 CellID->30945]
}, Closed]],
Cell[CellGroupData[{
Cell[4280, 155, 311, 9, 70, "SeeAlsoSection",
 CellID->21502],
Cell[4594, 166, 229, 6, 70, "SeeAlso",
 CellID->1899158999]
}, Open  ]],
Cell[CellGroupData[{
Cell[4860, 177, 314, 9, 70, "TutorialsSection",
 CellID->29695],
Cell[5177, 188, 189, 5, 70, "Tutorials",
 CellID->14644]
}, Open  ]],
Cell[5381, 196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

