(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8841,        281]
NotebookOptionsPosition[      6811,        223]
NotebookOutlinePosition[      8222,        257]
CellTagsIndexPosition[      8179,        254]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetArithmetic" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/SetArithmetic"], "Arithmetic" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/Arithmetic"], "NaN" :> 
          Documentation`HelpLookup["paclet:ComputerArithmetic/ref/NaN"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SetArithmetic\"\>", 
       2->"\<\"Arithmetic\"\>", 3->"\<\"NaN\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ComputerNumber", "ObjectName",
 CellID->21086],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ComputerNumber", "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the ",
     Cell[BoxData["ComputerNumber"], "InlineFormula"],
     " object equivalent to the ordinary number ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " in the arithmetic currently in effect."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ComputerNumber", "[", 
       RowBox[{
        StyleBox["sign", "TI"], ",", 
        StyleBox["mantissa", "TI"], ",", 
        StyleBox["exp", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the ",
     Cell[BoxData["ComputerNumber"], "InlineFormula"],
     " object whose value is ",
     Cell[BoxData[
      RowBox[{
       StyleBox["sign", "TI"], 
       StyleBox[" ", "TI"], 
       StyleBox["mantissa", "TI"], 
       StyleBox[" ", "TI"], 
       SuperscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["exp", "TI"]]}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " is the base in the arithmetic currently in effect."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ComputerNumber", "[", 
       RowBox[{
        StyleBox["sign", "TI"], ",", 
        StyleBox["mantissa", "TI"], ",", 
        StyleBox["exp", "TI"], ",", 
        StyleBox["value", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]is the complete data object that makes up a computer \
number."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->32094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16280],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetArithmetic",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arithmetic",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/Arithmetic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NaN",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/NaN"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23455]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7846],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->27043]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->83201422],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]], "MoreAbout",
 CellID->138768646]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ComputerNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 44.5660842}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "ComputerNumber[x] gives the ComputerNumber object equivalent to the \
ordinary number x in the arithmetic currently in effect. ComputerNumber[sign, \
mantissa, exp] gives the ComputerNumber object whose value is sign mantissa \
b^exp, where b is the base in the arithmetic currently in effect. \
ComputerNumber[sign, mantissa, exp, value, x] is the complete data object \
that makes up a computer number.", "synonyms" -> {}, "title" -> 
    "ComputerNumber", "type" -> "Symbol", "uri" -> 
    "ComputerArithmetic/ref/ComputerNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2124, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2747, 80, 52, 1, 70, "ObjectName",
 CellID->21086],
Cell[2802, 83, 1784, 53, 70, "Usage",
 CellID->32094]
}, Open  ]],
Cell[CellGroupData[{
Cell[4623, 141, 311, 9, 70, "SeeAlsoSection",
 CellID->16280],
Cell[4937, 152, 757, 26, 70, "SeeAlso",
 CellID->23455]
}, Open  ]],
Cell[CellGroupData[{
Cell[5731, 183, 313, 9, 70, "TutorialsSection",
 CellID->7846],
Cell[6047, 194, 178, 4, 70, "Tutorials",
 CellID->27043]
}, Open  ]],
Cell[CellGroupData[{
Cell[6262, 203, 318, 9, 70, "MoreAboutSection",
 CellID->83201422],
Cell[6583, 214, 186, 4, 70, "MoreAbout",
 CellID->138768646]
}, Open  ]],
Cell[6784, 221, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

