(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7152,        245]
NotebookOptionsPosition[      5411,        191]
NotebookOutlinePosition[      6508,        220]
CellTagsIndexPosition[      6465,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Ulps" :> 
          Documentation`HelpLookup["paclet:ComputerArithmetic/ref/Ulps"], 
          "MicroscopePlot" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/MicroscopePlot"], 
          "MicroscopicErrorPlot" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/MicroscopicErrorPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Ulps\"\>", 
       2->"\<\"MicroscopePlot\"\>", 
       3->"\<\"MicroscopicErrorPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MachineError", "ObjectName",
 CellID->11158],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MachineError", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{
         StyleBox["x", "TI"], "->", 
         StyleBox["a", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the error involved in evaluating ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " at ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "=", 
       StyleBox["a", "TI"]}]], "InlineFormula"],
     " using machine arithmetic."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15606]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The error is given in units of ",
 Cell[BoxData[
  ButtonBox["Ulps",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputerArithmetic/ref/Ulps"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16938]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19685],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ulps",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/Ulps"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MicroscopePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/MicroscopePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MicroscopicErrorPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/MicroscopicErrorPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9023]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19463],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->20920]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MachineError - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 50.8943712}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "MachineError[f, x -> a] gives the error involved in evaluating f at x = \
a using machine arithmetic.", "synonyms" -> {}, "title" -> "MachineError", 
    "type" -> "Symbol", "uri" -> "ComputerArithmetic/ref/MachineError"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1563, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2186, 67, 50, 1, 70, "ObjectName",
 CellID->11158],
Cell[2239, 70, 737, 24, 70, "Usage",
 CellID->15606]
}, Open  ]],
Cell[CellGroupData[{
Cell[3013, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3491, 116, 215, 8, 70, "Notes",
 CellID->16938]
}, Closed]],
Cell[CellGroupData[{
Cell[3743, 129, 311, 9, 70, "SeeAlsoSection",
 CellID->19685],
Cell[4057, 140, 780, 26, 70, "SeeAlso",
 CellID->9023]
}, Open  ]],
Cell[CellGroupData[{
Cell[4874, 171, 314, 9, 70, "TutorialsSection",
 CellID->19463],
Cell[5191, 182, 178, 4, 70, "Tutorials",
 CellID->20920]
}, Open  ]],
Cell[5384, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

