(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9432,        321]
NotebookOptionsPosition[      7310,        257]
NotebookOutlinePosition[      8561,        288]
CellTagsIndexPosition[      8518,        285]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MicroscopePlot" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/MicroscopePlot"], "MachineError" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/MachineError"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MicroscopePlot\"\>", 
       2->"\<\"MachineError\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MicroscopicErrorPlot", "ObjectName", "MicroscopicError",
 CellID->27740],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MicroscopicErrorPlot", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["a", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots the error incurred by using machine arithmetic to \
evaluate the expression ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in a small neighborhood of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MicroscopicErrorPlot", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["a", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots the error from ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "-", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " ulps to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "+", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " ulps."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->18255]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The scale on the vertical axis represents the error in ulps.", "Notes",
 CellID->4468],

Cell["The following option can be given:", "Notes",
 CellID->22070],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Joined",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Joined",
     ButtonNote->"ObsLink: PlotJoined -> Joined (ListLinePlot)"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to join points", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->16843],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined",
   ButtonNote->"ObsLink: PlotJoined -> Joined (ListLinePlot)"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10030],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Joined",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Joined",
    ButtonNote->"ObsLink: PlotJoined -> Joined (ListLinePlot)"], "->", 
   ButtonBox["Real",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Real"]}]], "InlineFormula"],
 ", the line joining the plot points represents the mapping from the set of \
real numbers to the error in the machine number output."
}], "Notes",
 CellID->15756]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12358],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MicroscopePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/MicroscopePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachineError",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/MachineError"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8124]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10765],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->3114]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MicroscopicErrorPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 51.2537554}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "MicroscopicErrorPlot[f, {x, a}] plots the error incurred by using \
machine arithmetic to evaluate the expression f in a small neighborhood of a. \
MicroscopicErrorPlot[f, {x, a, n}] plots the error from a - n ulps to a + n \
ulps.", "synonyms" -> {}, "title" -> "MicroscopicErrorPlot", "type" -> 
    "Symbol", "uri" -> "ComputerArithmetic/ref/MicroscopicErrorPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1405, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2028, 63, 78, 1, 70, "ObjectName",
 CellID->27740],
Cell[2109, 66, 1414, 46, 70, "Usage",
 CellID->18255]
}, Open  ]],
Cell[CellGroupData[{
Cell[3560, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4038, 134, 92, 1, 70, "Notes",
 CellID->4468],
Cell[4133, 137, 67, 1, 70, "Notes",
 CellID->22070],
Cell[4203, 140, 570, 16, 70, "3ColumnTableMod",
 CellID->16843],
Cell[4776, 158, 616, 25, 70, "Notes",
 CellID->10030],
Cell[5395, 185, 483, 14, 70, "Notes",
 CellID->15756]
}, Closed]],
Cell[CellGroupData[{
Cell[5915, 204, 311, 9, 70, "SeeAlsoSection",
 CellID->12358],
Cell[6229, 215, 508, 17, 70, "SeeAlso",
 CellID->8124]
}, Open  ]],
Cell[CellGroupData[{
Cell[6774, 237, 314, 9, 70, "TutorialsSection",
 CellID->10765],
Cell[7091, 248, 177, 4, 70, "Tutorials",
 CellID->3114]
}, Open  ]],
Cell[7283, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

