(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6756,        218]
NotebookOptionsPosition[      5089,        169]
NotebookOutlinePosition[      6300,        200]
CellTagsIndexPosition[      6257,        197]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RoundingRule" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/RoundingRule"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"], "Truncation" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/Truncation"], "RoundToInfinity" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/RoundToInfinity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RoundingRule\"\>", 
       2->"\<\"Round\"\>", 3->"\<\"Truncation\"\>", 
       4->"\<\"RoundToInfinity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RoundToEven", "ObjectName",
 CellID->17377],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["RoundToEven"], "InlineFormula"],
     " \[LineSeparator]is a setting for the option ",
     Cell[BoxData[
      ButtonBox["RoundingRule",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/RoundingRule"]], 
      "InlineFormula"],
     " of ",
     Cell[BoxData[
      ButtonBox["SetArithmetic",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"]], 
      "InlineFormula"],
     " that specifies rounding to the nearest representable number and, in \
the case of a tie, rounding to the one represented by an even mantissa."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10130]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15000],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RoundingRule",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/RoundingRule"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Truncation",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/Truncation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RoundToInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/RoundToInfinity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27754]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28487],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->26555]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RoundToEven - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 58.3789378}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "RoundToEven is a setting for the option RoundingRule of SetArithmetic \
that specifies rounding to the nearest representable number and, in the case \
of a tie, rounding to the one represented by an even mantissa.", 
    "synonyms" -> {}, "title" -> "RoundToEven", "type" -> "Symbol", "uri" -> 
    "ComputerArithmetic/ref/RoundToEven"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1638, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2261, 67, 49, 1, 70, "ObjectName",
 CellID->17377],
Cell[2313, 70, 833, 23, 70, "Usage",
 CellID->10130]
}, Open  ]],
Cell[CellGroupData[{
Cell[3183, 98, 311, 9, 70, "SeeAlsoSection",
 CellID->15000],
Cell[3497, 109, 1018, 35, 70, "SeeAlso",
 CellID->27754]
}, Open  ]],
Cell[CellGroupData[{
Cell[4552, 149, 314, 9, 70, "TutorialsSection",
 CellID->28487],
Cell[4869, 160, 178, 4, 70, "Tutorials",
 CellID->26555]
}, Open  ]],
Cell[5062, 167, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

