(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6114,        214]
NotebookOptionsPosition[      4451,        160]
NotebookOutlinePosition[      5475,        189]
CellTagsIndexPosition[      5432,        186]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Ulp" :> 
          Documentation`HelpLookup["paclet:ComputerArithmetic/ref/Ulp"], 
          "MachineError" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/MachineError"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Ulp\"\>", 
       2->"\<\"MachineError\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Ulps", "ObjectName",
 CellID->27222],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Ulps"], "InlineFormula"],
     "\[LineSeparator]is a unit of error in machine arithmetic. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
An ulp is the distance between two consecutive machine numbers and varies \
with the size of the numbers involved.\
\>", "Notes",
 CellID->553]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8029],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ulp",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/Ulp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachineError",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/MachineError"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3128]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26271],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->6955]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Ulps - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 59.1289570}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "Ulps is a unit of error in machine arithmetic. ", "synonyms" -> {}, 
    "title" -> "Ulps", "type" -> "Symbol", "uri" -> 
    "ComputerArithmetic/ref/Ulps"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1371, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1994, 63, 42, 1, 70, "ObjectName",
 CellID->27222],
Cell[2039, 66, 335, 10, 70, "Usage",
 CellID->22957]
}, Open  ]],
Cell[CellGroupData[{
Cell[2411, 81, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2889, 98, 153, 4, 70, "Notes",
 CellID->553]
}, Closed]],
Cell[CellGroupData[{
Cell[3079, 107, 310, 9, 70, "SeeAlsoSection",
 CellID->8029],
Cell[3392, 118, 486, 17, 70, "SeeAlso",
 CellID->3128]
}, Open  ]],
Cell[CellGroupData[{
Cell[3915, 140, 314, 9, 70, "TutorialsSection",
 CellID->26271],
Cell[4232, 151, 177, 4, 70, "Tutorials",
 CellID->6955]
}, Open  ]],
Cell[4424, 158, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

