(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9881,        346]
NotebookOptionsPosition[      6917,        256]
NotebookOutlinePosition[      8104,        287]
CellTagsIndexPosition[      8061,        284]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Developer Utilities Package", "GuideTitle",
 CellID->942062912],

Cell[TextData[{
 "The Developer Utilities Package includes functions that directly access \
specific internal algorithms and capabilities of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " that are normally used only as part of more general functions. "
}], "GuideAbstract",
 CellID->2001916300],

Cell[TextData[{
 Cell[TextData[ButtonBox["$MaxMachineInteger",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/$MaxMachineInteger"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " maximum integer represented as an atomic data element"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["MachineIntegerQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/MachineIntegerQ"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether a number is represented as a machine-sized integer"
}], "GuideText",
 CellID->1463276848],

Cell["\t", "GuideDelimiter",
 CellID->328230329],

Cell[TextData[{
 Cell[TextData[ButtonBox["BesselSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/BesselSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " transform Bessel functions in an expression"
}], "GuideText",
 CellID->535473769],

Cell[TextData[{
 Cell[TextData[ButtonBox["GammaSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/GammaSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " transform gamma functions"
}], "GuideText",
 CellID->272933244],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyGammaSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/PolyGammaSimplify"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " transform polygamma functions"
}], "GuideText",
 CellID->245006009],

Cell[TextData[{
 Cell[TextData[ButtonBox["ZetaSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/ZetaSimplify"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " transform zeta functions"
}], "GuideText",
 CellID->88235417],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolyLogSimplify",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/PolyLogSimplify"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " transform polylogarithm functions"
}], "GuideText",
 CellID->2529196],

Cell[TextData[{
 Cell[TextData[ButtonBox["TrigToRadicals",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/TrigToRadicals"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert trigonometric functions to radicals in an expression"
}], "GuideText",
 CellID->400479100],

Cell["\t", "GuideDelimiter",
 CellID->259371390],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToPackedArray",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/ToPackedArray"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert the internal representation of an expression to a packed array"
}], "GuideText",
 CellID->102431329],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromPackedArray",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/FromPackedArray"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " unpack a packed array"
}], "GuideText",
 CellID->135857025],

Cell[TextData[{
 Cell[TextData[ButtonBox["PackedArrayForm",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/PackedArrayForm"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " print packed arrays in summary form"
}], "GuideText",
 CellID->177225575],

Cell[TextData[{
 Cell[TextData[ButtonBox["PackedArrayQ",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/PackedArrayQ"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " whether an expression is a packed array of an optionally given type"
}], "GuideText",
 CellID->173021732],

Cell["\t", "GuideDelimiterSubsection",
 CellID->50304232],

Cell[CellGroupData[{

Cell["Notebook Manipulation", "GuideFunctionsSubsection",
 CellID->115847969],

Cell[TextData[{
 Cell[TextData[ButtonBox["CellInformation",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/CellInformation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " information about selected cells in a given notebook object"
}], "GuideText",
 CellID->16734012],

Cell[TextData[{
 Cell[TextData[ButtonBox["NotebookConvert",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/NotebookConvert"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert a notebook from a legacy version of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"]
}], "GuideText",
 CellID->79822810],

Cell["\t", "GuideDelimiter",
 CellID->88779859],

Cell[TextData[{
 Cell[TextData[ButtonBox["PartitionMap",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/PartitionMap"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply a function to a list after partitioning the list into sublists"
}], "GuideText",
 CellID->340406878],

Cell[TextData[{
 Cell[TextData[ButtonBox["FindDivisions",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/FindDivisions"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " evenly spaced divisions of a given interval"
}], "GuideText",
 CellID->86809362],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReplaceAllUnheld",
  BaseStyle->"Link",
  ButtonData->"paclet:Developer/ref/ReplaceAllUnheld"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " apply rules to parts of an expression that would be evaluated"
}], "GuideText",
 CellID->585632643]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MemoryMeasurementAndOptimization"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Developer Utilities Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 0.0352302}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Developer Package Guide", 
    "language" -> "en", "paclet" -> "Developer Package", "status" -> "None", 
    "summary" -> 
    "The Developer Utilities Package includes functions that directly access \
specific internal algorithms and capabilities of Mathematica that are \
normally used only as part of more general functions. ", "synonyms" -> {}, 
    "title" -> "Developer Utilities Package", "type" -> "Guide", "uri" -> 
    "Developer/guide/DeveloperPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 69, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[691, 28, 302, 7, 70, "GuideAbstract",
 CellID->2001916300],
Cell[996, 37, 310, 9, 70, "GuideText",
 CellID->203374175],
Cell[1309, 48, 310, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1622, 59, 48, 1, 70, "GuideDelimiter",
 CellID->328230329],
Cell[1673, 62, 289, 8, 70, "GuideText",
 CellID->535473769],
Cell[1965, 72, 269, 8, 70, "GuideText",
 CellID->272933244],
Cell[2237, 82, 284, 9, 70, "GuideText",
 CellID->245006009],
Cell[2524, 93, 265, 8, 70, "GuideText",
 CellID->88235417],
Cell[2792, 103, 282, 9, 70, "GuideText",
 CellID->2529196],
Cell[3077, 114, 306, 8, 70, "GuideText",
 CellID->400479100],
Cell[3386, 124, 48, 1, 70, "GuideDelimiter",
 CellID->259371390],
Cell[3437, 127, 314, 8, 70, "GuideText",
 CellID->102431329],
Cell[3754, 137, 272, 9, 70, "GuideText",
 CellID->135857025],
Cell[4029, 148, 286, 9, 70, "GuideText",
 CellID->177225575],
Cell[4318, 159, 309, 8, 70, "GuideText",
 CellID->173021732],
Cell[4630, 169, 57, 1, 70, "GuideDelimiterSubsection",
 CellID->50304232],
Cell[CellGroupData[{
Cell[4712, 174, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->115847969],
Cell[4792, 177, 309, 9, 70, "GuideText",
 CellID->16734012],
Cell[5104, 188, 343, 11, 70, "GuideText",
 CellID->79822810],
Cell[5450, 201, 47, 1, 70, "GuideDelimiter",
 CellID->88779859],
Cell[5500, 204, 310, 8, 70, "GuideText",
 CellID->340406878],
Cell[5813, 214, 286, 8, 70, "GuideText",
 CellID->86809362],
Cell[6102, 224, 314, 9, 70, "GuideText",
 CellID->585632643]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6465, 239, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[6530, 242, 157, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[6690, 247, 185, 4, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[6890, 254, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

