(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5926,        201]
NotebookOptionsPosition[      4251,        150]
NotebookOutlinePosition[      5388,        180]
CellTagsIndexPosition[      5345,        177]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DEVELOPER PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"MachineIntegerQ" :> 
         Documentation`HelpLookup["paclet:Developer/ref/MachineIntegerQ"], 
         "$MaxMachineNumber" :> 
         Documentation`HelpLookup["paclet:ref/$MaxMachineNumber"], 
         "$MachinePrecision" :> 
         Documentation`HelpLookup["paclet:ref/$MachinePrecision"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"MachineIntegerQ\"\>", 
      2->"\<\"$MaxMachineNumber\"\>", 
      3->"\<\"$MachinePrecision\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MaxMachineInteger", "ObjectName",
 CellID->28094],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$MaxMachineInteger"], "InlineFormula"],
     " \[LineSeparator]gives the maximum integer that is represented \
internally as a single atomic data element on your computer system. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3582]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["$MaxMachineInteger"], "InlineFormula"],
 " is typically ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"n", "-", "1"}]], "-", "1"}], TraditionalForm]], "InlineMath"],
 " on a computer system that is referred to as an ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]bit system. "
}], "Notes",
 CellID->8867],

Cell[TextData[{
 "Arithmetic operations involving integers smaller than ",
 Cell[BoxData["$MaxMachineInteger"], "InlineFormula"],
 " are typically faster than those involving larger integers. "
}], "Notes",
 CellID->8627]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18237],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachineIntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Developer/ref/MachineIntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxMachineNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachinePrecision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22850]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MaxMachineInteger - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 22.3795522}", "context" -> "Developer`", 
    "keywords" -> {"$MaxMachineInteger"}, "index" -> True, "label" -> 
    "Developer Package Symbol", "language" -> "en", "paclet" -> 
    "Developer Package", "status" -> "None", "summary" -> 
    "$MaxMachineInteger gives the maximum integer that is represented \
internally as a single atomic data element on your computer system. ", 
    "synonyms" -> {}, "title" -> "$MaxMachineInteger", "type" -> "Symbol", 
    "uri" -> "Developer/ref/$MaxMachineInteger"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 866, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1489, 47, 56, 1, 70, "ObjectName",
 CellID->28094],
Cell[1548, 50, 423, 11, 70, "Usage",
 CellID->3582]
}, Open  ]],
Cell[CellGroupData[{
Cell[2008, 66, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2486, 83, 392, 13, 70, "Notes",
 CellID->8867],
Cell[2881, 98, 221, 5, 70, "Notes",
 CellID->8627]
}, Closed]],
Cell[CellGroupData[{
Cell[3139, 108, 311, 9, 70, "SeeAlsoSection",
 CellID->18237],
Cell[3453, 119, 756, 26, 70, "SeeAlso",
 CellID->22850]
}, Open  ]],
Cell[4224, 148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

