(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12595,        436]
NotebookOptionsPosition[     10194,        370]
NotebookOutlinePosition[     11833,        407]
CellTagsIndexPosition[     11790,        404]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DEVELOPER PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Ticks" :> Documentation`HelpLookup["paclet:ref/Ticks"], "Range" :> 
         Documentation`HelpLookup["paclet:ref/Range"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Ticks\"\>", 
      2->"\<\"Range\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FindDivisions", "ObjectName",
 CellID->19882],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FindDivisions", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]finds a list of about ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " \[OpenCurlyDoubleQuote]nice\[CloseCurlyDoubleQuote] numbers that \
divide the interval around ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " into equally spaced parts. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FindDivisions", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dx", "TI"]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]makes the parts always have lengths that are integer \
multiples of ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FindDivisions", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]finds successive subdivisions into about ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]",
     " ",
     " parts. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FindDivisions", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["dx", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["dx", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses spacings that are forced to be multiples of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dx", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dx", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]",
     " ",
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FindDivisions", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["min", "TI"]], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["max", "TI"]], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["dx", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["dx", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]gives all numbers in the interval with spacings ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dx", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->1608]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FindDivisions", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " searches for numbers that are shortest in their decimal representation. "
}], "Notes",
 CellID->12654],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FindDivisions", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " searches for numbers that are shortest in their base ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " representation. "
}], "Notes",
 CellID->3822],

Cell[TextData[{
 "The first and last numbers may be slightly outside the range ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32707],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dx", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be exact numbers such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Pi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pi"], "/", "2"}]], "InlineFormula"],
 " specified in symbolic form. "
}], "Notes",
 CellID->24245],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FindDivisions", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " yields a list of lists, where later lists omit elements that occur in \
earlier lists. "
}], "Notes",
 CellID->1338],

Cell[TextData[{
 "For some choices of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dx", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", some of the lists generated may be empty. "
}], "Notes",
 CellID->144]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22225],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ticks",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Ticks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Range",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Range"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20078]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FindDivisions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 6.6135236}", "context" -> "Developer`", 
    "keywords" -> {"FindDivisions"}, "index" -> True, "label" -> 
    "Developer Package Symbol", "language" -> "en", "paclet" -> 
    "Developer Package", "status" -> "None", "summary" -> 
    "FindDivisions[{x_min, x_max}, n] finds a list of about n \
\\[OpenCurlyDoubleQuote]nice\\[CloseCurlyDoubleQuote] numbers that divide the \
interval around x_min to x_max into equally spaced parts. \
FindDivisions[{x_min, x_max, dx}, n] makes the parts always have lengths that \
are integer multiples of dx. FindDivisions[{x_min, x_max}, {n_1, n_2, ...}] \
finds successive subdivisions into about n_1, n_2, ... parts. \
FindDivisions[{x_min, x_max, {dx_1, dx_2, ...}}, {n_1, n_2, ...}] uses \
spacings that are forced to be multiples of dx_1, dx_2, ... . \
FindDivisions[{x_min, x_max, {dx_1, dx_2, ...}}] gives all numbers in the \
interval with spacings dx_i. ", "synonyms" -> {}, "title" -> "FindDivisions", 
    "type" -> "Symbol", "uri" -> "Developer/ref/FindDivisions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 630, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1253, 42, 51, 1, 70, "ObjectName",
 CellID->19882],
Cell[1307, 45, 4943, 162, 70, "Usage",
 CellID->1608]
}, Open  ]],
Cell[CellGroupData[{
Cell[6287, 212, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6765, 229, 447, 15, 70, "Notes",
 CellID->12654],
Cell[7215, 246, 537, 19, 70, "Notes",
 CellID->3822],
Cell[7755, 267, 329, 13, 70, "Notes",
 CellID->32707],
Cell[8087, 282, 355, 14, 70, "Notes",
 CellID->24245],
Cell[8445, 298, 682, 24, 70, "Notes",
 CellID->1338],
Cell[9130, 324, 216, 8, 70, "Notes",
 CellID->144]
}, Closed]],
Cell[CellGroupData[{
Cell[9383, 337, 311, 9, 70, "SeeAlsoSection",
 CellID->22225],
Cell[9697, 348, 455, 17, 70, "SeeAlso",
 CellID->20078]
}, Open  ]],
Cell[10167, 368, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

