(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6151,        219]
NotebookOptionsPosition[      4515,        168]
NotebookOutlinePosition[      5610,        198]
CellTagsIndexPosition[      5567,        195]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DEVELOPER PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"$MaxMachineInteger" :> 
         Documentation`HelpLookup["paclet:Developer/ref/$MaxMachineInteger"], 
         "Precision" :> Documentation`HelpLookup["paclet:ref/Precision"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"$MaxMachineInteger\"\>", 
      2->"\<\"Precision\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MachineIntegerQ", "ObjectName",
 CellID->25679],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MachineIntegerQ", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " corresponds to a machine\[Hyphen]sized integer, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28053]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "On a typical computer system machine\[Hyphen]sized integers must lie in the \
range ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"-", "2"}], "31"], "+", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"+", "2"}], "31"], "-", "1"}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"-", "2"}], "63"], "+", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"+", "2"}], "63"], "-", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->13043],

Cell[TextData[{
 "Results from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are not affected by whether an integer is machine\[Hyphen]sized or not; \
the speed of operations may however be affected. "
}], "Notes",
 CellID->14522]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7240],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxMachineInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:Developer/ref/$MaxMachineInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21911]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MachineIntegerQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 7.0979110}", "context" -> "Developer`", 
    "keywords" -> {"MachineIntegerQ"}, "index" -> True, "label" -> 
    "Developer Package Symbol", "language" -> "en", "paclet" -> 
    "Developer Package", "status" -> "None", "summary" -> 
    "MachineIntegerQ[expr] returns True if expr corresponds to a \
machine-sized integer, and False otherwise. ", "synonyms" -> {}, "title" -> 
    "MachineIntegerQ", "type" -> "Symbol", "uri" -> 
    "Developer/ref/MachineIntegerQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 702, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1325, 43, 53, 1, 70, "ObjectName",
 CellID->25679],
Cell[1381, 46, 792, 25, 70, "Usage",
 CellID->28053]
}, Open  ]],
Cell[CellGroupData[{
Cell[2210, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2688, 93, 710, 28, 70, "Notes",
 CellID->13043],
Cell[3401, 123, 239, 7, 70, "Notes",
 CellID->14522]
}, Closed]],
Cell[CellGroupData[{
Cell[3677, 135, 310, 9, 70, "SeeAlsoSection",
 CellID->7240],
Cell[3990, 146, 483, 17, 70, "SeeAlso",
 CellID->21911]
}, Open  ]],
Cell[4488, 166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

