(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6809,        233]
NotebookOptionsPosition[      5029,        182]
NotebookOutlinePosition[      6320,        214]
CellTagsIndexPosition[      6277,        211]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DEVELOPER PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ToPackedArray" :> 
         Documentation`HelpLookup["paclet:Developer/ref/ToPackedArray"], 
         "ByteCount" :> Documentation`HelpLookup["paclet:ref/ByteCount"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"ToPackedArray\"\>", 
      2->"\<\"ByteCount\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PackedArrayQ", "ObjectName",
 CellID->1071],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PackedArrayQ", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a packed array in its internal representation, and returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PackedArrayQ", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a packed array of objects of the specified type. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PackedArrayQ", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["type", "TI"], ",", 
        StyleBox["rank", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a packed array of the specified rank. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->32080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Supported types are ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4712],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToPackedArray",
    BaseStyle->"Link",
    ButtonData->"paclet:Developer/ref/ToPackedArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13037]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PackedArrayQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 14.3949728}", "context" -> "Developer`", 
    "keywords" -> {"PackedArrayQ"}, "index" -> True, "label" -> 
    "Developer Package Symbol", "language" -> "en", "paclet" -> 
    "Developer Package", "status" -> "None", "summary" -> 
    "PackedArrayQ[expr] returns True if expr is a packed array in its \
internal representation, and returns False otherwise. PackedArrayQ[expr, \
type] returns True if expr is a packed array of objects of the specified \
type. PackedArrayQ[expr, type, rank] returns True if expr is a packed array \
of the specified rank. ", "synonyms" -> {}, "title" -> "PackedArrayQ", "type" -> 
    "Symbol", "uri" -> "Developer/ref/PackedArrayQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 687, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1310, 43, 49, 1, 70, "ObjectName",
 CellID->1071],
Cell[1362, 46, 1850, 58, 70, "Usage",
 CellID->32080]
}, Open  ]],
Cell[CellGroupData[{
Cell[3249, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3727, 126, 437, 18, 70, "Notes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[4201, 149, 310, 9, 70, "SeeAlsoSection",
 CellID->4712],
Cell[4514, 160, 473, 17, 70, "SeeAlso",
 CellID->13037]
}, Open  ]],
Cell[5002, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

