(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7301,        260]
NotebookOptionsPosition[      5085,        189]
NotebookOutlinePosition[      6418,        226]
CellTagsIndexPosition[      6334,        221]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DEVELOPER PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ReplaceAll" :> 
         Documentation`HelpLookup["paclet:ref/ReplaceAll"], "Hold" :> 
         Documentation`HelpLookup["paclet:ref/Hold"], "Verbatim" :> 
         Documentation`HelpLookup["paclet:ref/Verbatim"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ReplaceAll\"\>", 2->"\<\"Hold\"\>", 
      3->"\<\"Verbatim\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ReplaceAllUnheld", "ObjectName",
 CellID->17553],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ReplaceAllUnheld", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["rules", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]applies a rule or list of rules in an attempt to \
transform each subpart of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " that would be automatically evaluated. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplaceAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceAll"]], "InlineFormula"],
 " operates on all subparts of an expression; ",
 Cell[BoxData["ReplaceAllUnheld"], "InlineFormula"],
 " operates only on those subparts that would normally be evaluated. "
}], "Notes",
 CellID->27091]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173605525],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->70795788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Developer`ReplaceAllUnheld", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{"a", ",", "a", ",", "a"}], "]"}], ",", 
   RowBox[{"a", "->", "b"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1099600665],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"b", ",", "a", ",", "a"}], "]"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->676145352]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22045],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAll",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/ReplaceAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hold",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Hold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Verbatim",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Verbatim"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12356]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ReplaceAllUnheld - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 15.0356142}", "context" -> "Developer`", 
    "keywords" -> {"ReplaceAllUnheld"}, "index" -> True, "label" -> 
    "Developer Package Symbol", "language" -> "en", "paclet" -> 
    "Developer Package", "status" -> "None", "summary" -> 
    "ReplaceAllUnheld[expr, rules] applies a rule or list of rules in an \
attempt to transform each subpart of expr that would be automatically \
evaluated. ", "synonyms" -> {}, "title" -> "ReplaceAllUnheld", "type" -> 
    "Symbol", "uri" -> "Developer/ref/ReplaceAllUnheld"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2937, 101, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->173605525]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6191, 214}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 748, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1371, 44, 54, 1, 70, "ObjectName",
 CellID->17553],
Cell[1428, 47, 617, 18, 70, "Usage",
 CellID->24705]
}, Open  ]],
Cell[CellGroupData[{
Cell[2082, 70, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2560, 87, 340, 9, 70, "Notes",
 CellID->27091]
}, Closed]],
Cell[CellGroupData[{
Cell[2937, 101, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173605525],
Cell[CellGroupData[{
Cell[3322, 115, 147, 5, 70, "ExampleSection",
 CellID->70795788],
Cell[CellGroupData[{
Cell[3494, 124, 236, 7, 28, "Input",
 CellID->1099600665],
Cell[3733, 133, 219, 7, 36, "Output",
 CellID->676145352]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4013, 147, 311, 9, 70, "SeeAlsoSection",
 CellID->22045],
Cell[4327, 158, 716, 26, 70, "SeeAlso",
 CellID->12356]
}, Open  ]],
Cell[5058, 187, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

