(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6916,        235]
NotebookOptionsPosition[      5065,        179]
NotebookOutlinePosition[      6275,        210]
CellTagsIndexPosition[      6232,        207]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EQUATION TREKKER PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker Package" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/tutorial/EquationTrekker"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EquationTrekker Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TrekGenerator" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/TrekGenerator"], "PoincareSection" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/PoincareSection"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"TrekGenerator\"\>", 
       2->"\<\"PoincareSection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DifferentialEquationTrek", "ObjectName",
 CellID->8917],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["DifferentialEquationTrek"], "InlineFormula"],
     " \[LineSeparator]is a setting for the option ",
     Cell[BoxData[
      ButtonBox["TrekGenerator",
       BaseStyle->"Link",
       ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"]], 
      "InlineFormula"],
     " that specifies that treks are generated from the phase space of the \
numerical solution of a differential equation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28290]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"DifferentialEquationTrek", ",", 
    StyleBox["opts", "TI"]}], "}"}]], "InlineFormula"],
 " can be used to pass the options ",
 Cell[BoxData[
  StyleBox["opts", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3967]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19402],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrekGenerator",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoincareSection",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/PoincareSection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8239]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1707],

Cell[TextData[ButtonBox["EquationTrekker Package",
 BaseStyle->"Link",
 ButtonData->"paclet:EquationTrekker/tutorial/EquationTrekker"]], "Tutorials",\

 CellID->8234]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DifferentialEquationTrek - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 22.6920602}", "context" -> 
    "EquationTrekker`", "keywords" -> {}, "index" -> True, "label" -> 
    "Equation Trekker Package Symbol", "language" -> "en", "paclet" -> 
    "EquationTrekker Package", "status" -> "None", "summary" -> 
    "DifferentialEquationTrek is a setting for the option TrekGenerator that \
specifies that treks are generated from the phase space of the numerical \
solution of a differential equation.", "synonyms" -> {}, "title" -> 
    "DifferentialEquationTrek", "type" -> "Symbol", "uri" -> 
    "EquationTrekker/ref/DifferentialEquationTrek"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1388, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2011, 63, 61, 1, 70, "ObjectName",
 CellID->8917],
Cell[2075, 66, 636, 17, 70, "Usage",
 CellID->28290]
}, Open  ]],
Cell[CellGroupData[{
Cell[2748, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3226, 105, 421, 16, 70, "Notes",
 CellID->3967]
}, Closed]],
Cell[CellGroupData[{
Cell[3684, 126, 311, 9, 70, "SeeAlsoSection",
 CellID->19402],
Cell[3998, 137, 506, 17, 70, "SeeAlso",
 CellID->8239]
}, Open  ]],
Cell[CellGroupData[{
Cell[4541, 159, 313, 9, 70, "TutorialsSection",
 CellID->1707],
Cell[4857, 170, 166, 4, 70, "Tutorials",
 CellID->8234]
}, Open  ]],
Cell[5038, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

