(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14580,        478]
NotebookOptionsPosition[     12419,        414]
NotebookOutlinePosition[     13747,        447]
CellTagsIndexPosition[     13704,        444]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EQUATION TREKKER PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker Package" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/tutorial/EquationTrekker"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EquationTrekker Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/EquationTrekker"], "TrekGenerator" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/TrekGenerator"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EquationTrekker\"\>", 
       2->"\<\"TrekGenerator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InitializeGenerator", "ObjectName",
 CellID->6450],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InitializeGenerator", "[", 
       RowBox[{
        StyleBox["gen", "TI"], ",", 
        StyleBox["problem", "TI"], ",", 
        StyleBox["dvars", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the trek generator ",
     Cell[BoxData[
      RowBox[{
       StyleBox["gen", "TI"], "[", 
       StyleBox["data", "TI"], "]"}]], "InlineFormula"],
     " when called by ",
     Cell[BoxData[
      ButtonBox["EquationTrekker",
       BaseStyle->"Link",
       ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
      "InlineFormula"],
     ". The specific form of ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " depends on the trek generator ",
     Cell[BoxData[
      StyleBox["gen", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"IntializeGenerator", "[", 
       RowBox[{
        StyleBox["gen", "TI"], ",", 
        StyleBox["problem", "TI"], ",", 
        StyleBox["dvars", "TI"], ",", 
        StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns a trek generator which does not use an \
independent variable."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19982]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EquationTrekker",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"], "[", 
   RowBox[{
    StyleBox["problem", "TI"], ",", 
    StyleBox["dvars", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", 
    RowBox[{
     ButtonBox["TrekGenerator",
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"], "->", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["gen", "TI"], ",", 
       StyleBox["subopts", "TI"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " calls ",
 Cell[BoxData[
  RowBox[{"InitializeGenerator", "[", 
   RowBox[{
    StyleBox["gen", "TI"], ",", 
    StyleBox["problem", "TI"], ",", 
    StyleBox["dvars", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     StyleBox["subopts", "TI"], "}"}]}], "]"}]], "InlineFormula"],
 " to initialize the generator ",
 Cell[BoxData[
  StyleBox["gen", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28621],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["EquationTrekker",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"], "[", 
   RowBox[{
    StyleBox["problem", "TI"], ",", 
    StyleBox["dvars", "TI"], ",", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], ",", 
    RowBox[{
     ButtonBox["TrekGenerator",
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"], "->", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["gen", "TI"], ",", 
       StyleBox["subopts", "TI"]}], "}"}]}]}], "]"}]], "InlineFormula"],
 " should be used when ",
 Cell[BoxData[
  StyleBox["gen", "TI"]], "InlineFormula"],
 " does not use an independent variable, in which case ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " will call ",
 Cell[BoxData[
  RowBox[{"InitializeGenerator", "[", 
   RowBox[{
    StyleBox["gen", "TI"], ",", 
    StyleBox["problem", "TI"], ",", 
    StyleBox["dvars", "TI"], ",", 
    RowBox[{"{", 
     StyleBox["subopts", "TI"], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5193],

Cell[TextData[{
 "A new generator ",
 Cell[BoxData[
  StyleBox["newgen", "TI"]], "InlineFormula"],
 " can be created by giving the additional ",
 Cell[BoxData["InitializeGenerator"], "InlineFormula"],
 " definition, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["newgen", "TI"], "/:", 
   RowBox[{"IntializeGenerator", "[", 
    RowBox[{
     StyleBox["newgen", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], ":=", 
   RowBox[{
    StyleBox["newgen", "TI"], "[", 
    StyleBox["data", "TI"], "]"}]}]], "InlineFormula"],
 ". In addition, definitions for the following ",
 Cell[BoxData[
  ButtonBox["DownValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DownValues"]], "InlineFormula"],
 " of the function ",
 Cell[BoxData[
  RowBox[{
   StyleBox["newgen", "TI"], "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 " need to be given:"
}], "Notes",
 CellID->27038],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{
      StyleBox["newgen", "TI"], "[", 
      StyleBox["data", "TI"], "]"}], "[", 
     RowBox[{"\"\<Variables\>\"", "[", "]"}], "]"}], Cell[
    "list of variables", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{
      StyleBox["newgen", "TI"], "[", 
      StyleBox["data", "TI"], "]"}], "[", 
     RowBox[{"\"\<Display\>\"", "[", "]"}], "]"}], Cell[
    "problem description to be displayed", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{
      StyleBox["newgen", "TI"], "[", 
      StyleBox["data", "TI"], "]"}], "[", 
     RowBox[{"\"\<DisplayMode\>\"", "[", "]"}], "]"}], Cell[
    "the display mode, either \"Line\" or \"Points\"", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{
      StyleBox["newgen", "TI"], "[", 
      StyleBox["data", "TI"], "]"}], "[", 
     RowBox[{"\"\<FormatTrek\>\"", "[", 
      RowBox[{
       SubscriptBox[
        StyleBox["t", "TI"], "0"], ",", 
       SubscriptBox[
        StyleBox["dvars", "TI"], "0"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["min", "TI"]], ",", 
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["max", "TI"]]}], "}"}]}], "]"}], "]"}], Cell[TextData[{
     "information used to tag ",
     Cell[BoxData[
      ButtonBox["TrekData",
       BaseStyle->"Link",
       ButtonData->"paclet:EquationTrekker/ref/TrekData"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{
      StyleBox["newgen", "TI"], "[", 
      StyleBox["data", "TI"], "]"}], "[", 
     RowBox[{"\"\<ChangeParameters\>\"", "[", 
      StyleBox["prules", "TI"], "]"}], "]"}], Cell[
    "generator with data modified by new parameters", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{
      StyleBox["newgen", "TI"], "[", 
      StyleBox["data", "TI"], "]"}], "[", 
     RowBox[{"\"\<GenerateTrek\>\"", "[", 
      RowBox[{
       SubscriptBox[
        StyleBox["dvars", "TI"], "0"], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["t", "TI"], "0"], ",", 
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["min", "TI"]], ",", 
         SubscriptBox[
          StyleBox["t", "TI"], 
          StyleBox["max", "TI"]]}], "}"}]}], "]"}], "]"}], Cell[TextData[{
     "list of data points to plot, with initial point given by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["dvars", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->16754]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25167],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EquationTrekker",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrekGenerator",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1631906646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4593],

Cell[TextData[ButtonBox["EquationTrekker Package",
 BaseStyle->"Link",
 ButtonData->"paclet:EquationTrekker/tutorial/EquationTrekker"]], "Tutorials",\

 CellID->14895]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InitializeGenerator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 23.4108286}", "context" -> 
    "EquationTrekker`", "keywords" -> {}, "index" -> True, "label" -> 
    "Equation Trekker Package Symbol", "language" -> "en", "paclet" -> 
    "EquationTrekker Package", "status" -> "None", "summary" -> 
    "InitializeGenerator[gen, problem, dvars, {t, t_min, t_max}, opts] \
returns the trek generator gen[data] when called by EquationTrekker. The \
specific form of data depends on the trek generator gen. \
IntializeGenerator[gen, problem, dvars, opts] returns a trek generator which \
does not use an independent variable.", "synonyms" -> {}, "title" -> 
    "InitializeGenerator", "type" -> "Symbol", "uri" -> 
    "EquationTrekker/ref/InitializeGenerator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1388, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2011, 63, 56, 1, 70, "ObjectName",
 CellID->6450],
Cell[2070, 66, 1742, 53, 70, "Usage",
 CellID->19982]
}, Open  ]],
Cell[CellGroupData[{
Cell[3849, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4327, 141, 1419, 49, 70, "Notes",
 CellID->28621],
Cell[5749, 192, 1221, 40, 70, "Notes",
 CellID->5193],
Cell[6973, 234, 885, 29, 70, "Notes",
 CellID->27038],
Cell[7861, 265, 3133, 91, 70, "2ColumnTableMod",
 CellID->16754]
}, Closed]],
Cell[CellGroupData[{
Cell[11031, 361, 311, 9, 70, "SeeAlsoSection",
 CellID->25167],
Cell[11345, 372, 512, 17, 70, "SeeAlso",
 CellID->1631906646]
}, Open  ]],
Cell[CellGroupData[{
Cell[11894, 394, 313, 9, 70, "TutorialsSection",
 CellID->4593],
Cell[12210, 405, 167, 4, 70, "Tutorials",
 CellID->14895]
}, Open  ]],
Cell[12392, 412, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

