(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9624,        327]
NotebookOptionsPosition[      7492,        260]
NotebookOutlinePosition[      8641,        290]
CellTagsIndexPosition[      8598,        287]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EQUATION TREKKER PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker Package" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/tutorial/EquationTrekker"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EquationTrekker Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/EquationTrekker"], "TrekGenerator" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/TrekGenerator"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EquationTrekker\"\>", 
       2->"\<\"TrekGenerator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PoincareSection", "ObjectName",
 CellID->32106],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PoincareSection"], "InlineFormula"],
     " \[LineSeparator]is a setting for the option ",
     Cell[BoxData[
      ButtonBox["TrekGenerator",
       BaseStyle->"Link",
       ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"]], 
      "InlineFormula"],
     " that specifies that the Poincare section for differential equations is \
used to generate treks."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31302]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrekGenerator",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"], "->", 
   RowBox[{"{", 
    RowBox[{"PoincareSection", ",", 
     RowBox[{
      StyleBox["method", "TI"], "->", 
      StyleBox["value", "TI"]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " possible method options are:"
}], "Notes",
 CellID->24696],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<SectionCondition\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "when section variables will be shown", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SectionVariables\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "variables to be plotted", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FilterFunction\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "function applied to variables before plotting", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->8833],

Cell[TextData[{
 "Options specific to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " may also be included as method options."
}], "Notes",
 CellID->7611],

Cell[TextData[{
 "The method options ",
 Cell[BoxData["\"\<SectionCondition\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<SectionVariables\>\""], "InlineFormula"],
 " are required to have a value other than ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19067],

Cell[TextData[{
 "The method option ",
 Cell[BoxData[
  RowBox[{"\"\<SectionCondition\>\"", "->", 
   StyleBox["cond", "TI"]}]], "InlineFormula"],
 " plots section variables whenever ",
 Cell[BoxData[
  RowBox[{
   StyleBox["cond", "TI"], "==", "0"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->415],

Cell[TextData[{
 "The setting for the method option ",
 Cell[BoxData["\"\<SectionVariables\>\""], "InlineFormula"],
 " should be a list of two of the dependent variables. If the differential \
equations are second order or higher, than derivatives of the dependent \
variables may also be chosen."
}], "Notes",
 CellID->6645],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<FilterFunction\>\"", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", the argument supplied to ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is a list of the coordinates to be plotted."
}], "Notes",
 CellID->30175]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27988],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EquationTrekker",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrekGenerator",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1631906646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6354],

Cell[TextData[ButtonBox["EquationTrekker Package",
 BaseStyle->"Link",
 ButtonData->"paclet:EquationTrekker/tutorial/EquationTrekker"]], "Tutorials",\

 CellID->23448]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PoincareSection - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 23.5983334}", "context" -> 
    "EquationTrekker`", "keywords" -> {}, "index" -> True, "label" -> 
    "Equation Trekker Package Symbol", "language" -> "en", "paclet" -> 
    "EquationTrekker Package", "status" -> "None", "summary" -> 
    "PoincareSection is a setting for the option TrekGenerator that specifies \
that the Poincare section for differential equations is used to generate \
treks.", "synonyms" -> {}, "title" -> "PoincareSection", "type" -> "Symbol", 
    "uri" -> "EquationTrekker/ref/PoincareSection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1388, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2011, 63, 53, 1, 70, "ObjectName",
 CellID->32106],
Cell[2067, 66, 607, 17, 70, "Usage",
 CellID->31302]
}, Open  ]],
Cell[CellGroupData[{
Cell[2711, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3189, 105, 446, 15, 70, "Notes",
 CellID->24696],
Cell[3638, 122, 902, 22, 70, "3ColumnTableMod",
 CellID->8833],
Cell[4543, 146, 229, 8, 70, "Notes",
 CellID->7611],
Cell[4775, 156, 362, 12, 70, "Notes",
 CellID->19067],
Cell[5140, 170, 302, 11, 70, "Notes",
 CellID->415],
Cell[5445, 183, 325, 7, 70, "Notes",
 CellID->6645],
Cell[5773, 192, 294, 10, 70, "Notes",
 CellID->30175]
}, Closed]],
Cell[CellGroupData[{
Cell[6104, 207, 311, 9, 70, "SeeAlsoSection",
 CellID->27988],
Cell[6418, 218, 512, 17, 70, "SeeAlso",
 CellID->1631906646]
}, Open  ]],
Cell[CellGroupData[{
Cell[6967, 240, 313, 9, 70, "TutorialsSection",
 CellID->6354],
Cell[7283, 251, 167, 4, 70, "Tutorials",
 CellID->23448]
}, Open  ]],
Cell[7465, 258, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

