(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7987,        272]
NotebookOptionsPosition[      6123,        214]
NotebookOutlinePosition[      7282,        245]
CellTagsIndexPosition[      7239,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EQUATION TREKKER PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker Package" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/tutorial/EquationTrekker"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EquationTrekker Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/EquationTrekker"], 
          "DifferentialEquationTrek" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/DifferentialEquationTrek"], 
          "PoincareSection" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/PoincareSection"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EquationTrekker\"\>", 
       2->"\<\"DifferentialEquationTrek\"\>", 
       3->"\<\"PoincareSection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TrekData", "ObjectName",
 CellID->3145],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TrekData", "[", 
       RowBox[{
        StyleBox["tag", "TI"], ",", 
        StyleBox["data", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a data object that contains the information \
necessary to recreate the trek associated with the tag ",
     Cell[BoxData[
      StyleBox["tag", "TI"]], "InlineFormula"],
     " in a graphical interface created by ",
     Cell[BoxData[
      ButtonBox["EquationTrekker",
       BaseStyle->"Link",
       ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
      "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20481]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The trek generators ",
 Cell[BoxData[
  ButtonBox["DifferentialEquationTrek",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/DifferentialEquationTrek"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PoincareSection",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/PoincareSection"]], 
  "InlineFormula"],
 " by default tag treks with their initial conditions."
}], "Notes",
 CellID->11714],

Cell[TextData[{
 "The standard output format for a ",
 Cell[BoxData["TrekData"], "InlineFormula"],
 " object with the tag ",
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"TrekData", "[", 
   RowBox[{
    StyleBox["tag", "TI"], ",", "<>"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20149]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23504],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EquationTrekker",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DifferentialEquationTrek",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/DifferentialEquationTrek"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoincareSection",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/PoincareSection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->350188832]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24168],

Cell[TextData[ButtonBox["EquationTrekker Package",
 BaseStyle->"Link",
 ButtonData->"paclet:EquationTrekker/tutorial/EquationTrekker"]], "Tutorials",\

 CellID->13338]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrekData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 23.7702128}", "context" -> 
    "EquationTrekker`", "keywords" -> {}, "index" -> True, "label" -> 
    "Equation Trekker Package Symbol", "language" -> "en", "paclet" -> 
    "EquationTrekker Package", "status" -> "None", "summary" -> 
    "TrekData[tag, data] is a data object that contains the information \
necessary to recreate the trek associated with the tag tag in a graphical \
interface created by EquationTrekker.", "synonyms" -> {}, "title" -> 
    "TrekData", "type" -> "Symbol", "uri" -> 
    "EquationTrekker/ref/TrekData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1597, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2220, 68, 45, 1, 70, "ObjectName",
 CellID->3145],
Cell[2268, 71, 811, 24, 70, "Usage",
 CellID->20481]
}, Open  ]],
Cell[CellGroupData[{
Cell[3116, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3594, 117, 457, 15, 70, "Notes",
 CellID->11714],
Cell[4054, 134, 347, 13, 70, "Notes",
 CellID->20149]
}, Closed]],
Cell[CellGroupData[{
Cell[4438, 152, 311, 9, 70, "SeeAlsoSection",
 CellID->23504],
Cell[4752, 163, 808, 26, 70, "SeeAlso",
 CellID->350188832]
}, Open  ]],
Cell[CellGroupData[{
Cell[5597, 194, 314, 9, 70, "TutorialsSection",
 CellID->24168],
Cell[5914, 205, 167, 4, 70, "Tutorials",
 CellID->13338]
}, Open  ]],
Cell[6096, 212, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

