(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8602,        298]
NotebookOptionsPosition[      6712,        238]
NotebookOutlinePosition[      7796,        267]
CellTagsIndexPosition[      7753,        264]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EQUATION TREKKER PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker Package" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/tutorial/EquationTrekker"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EquationTrekker Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InitiatlizeGenerator" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/InitializeGenerator"], 
          "DifferentialEquationTrek" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/DifferentialEquationTrek"], 
          "PoincareSection" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/PoincareSection"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"InitiatlizeGenerator\"\>", 
       2->"\<\"DifferentialEquationTrek\"\>", 
       3->"\<\"PoincareSection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TrekGenerator", "ObjectName",
 CellID->28781],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["TrekGenerator"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["EquationTrekker",
       BaseStyle->"Link",
       ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
      "InlineFormula"],
     " that specifies the method used to generate treks."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["DifferentialEquationTrek",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/DifferentialEquationTrek"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PoincareSection",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/PoincareSection"]], 
  "InlineFormula"],
 ". Other settings may be installed with ",
 Cell[BoxData[
  ButtonBox["InitializeGenerator",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/InitializeGenerator"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->12833],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  ButtonBox["DifferentialEquationTrek",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/DifferentialEquationTrek"]], 
  "InlineFormula"],
 " creates treks by following the phase path of the dependent variables \
generated by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8672],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  ButtonBox["PoincareSection",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/PoincareSection"]], 
  "InlineFormula"],
 " creates treks by sampling the phase space at predetermined",
 " ",
 "(usually periodic) intervals."
}], "Notes",
 CellID->1563],

Cell[TextData[{
 "Suboptions for a method may be specified using the setting ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["method", "TI"], ",", 
    StyleBox["subopts", "TI"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21302]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31447],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InitiatlizeGenerator",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/InitializeGenerator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DifferentialEquationTrek",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/DifferentialEquationTrek"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PoincareSection",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/PoincareSection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10945]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->502],

Cell[TextData[ButtonBox["EquationTrekker Package",
 BaseStyle->"Link",
 ButtonData->"paclet:EquationTrekker/tutorial/EquationTrekker"]], "Tutorials",\

 CellID->26928]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrekGenerator - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 30.3797570}", "context" -> 
    "EquationTrekker`", "keywords" -> {}, "index" -> True, "label" -> 
    "Equation Trekker Package Symbol", "language" -> "en", "paclet" -> 
    "EquationTrekker Package", "status" -> "None", "summary" -> 
    "TrekGenerator is an option to EquationTrekker that specifies the method \
used to generate treks.", "synonyms" -> {}, "title" -> "TrekGenerator", 
    "type" -> "Symbol", "uri" -> "EquationTrekker/ref/TrekGenerator"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1611, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2234, 68, 51, 1, 70, "ObjectName",
 CellID->28781],
Cell[2288, 71, 550, 16, 70, "Usage",
 CellID->20990]
}, Open  ]],
Cell[CellGroupData[{
Cell[2875, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3353, 109, 609, 21, 70, "Notes",
 CellID->12833],
Cell[3965, 132, 450, 15, 70, "Notes",
 CellID->8672],
Cell[4418, 149, 315, 11, 70, "Notes",
 CellID->1563],
Cell[4736, 162, 251, 9, 70, "Notes",
 CellID->21302]
}, Closed]],
Cell[CellGroupData[{
Cell[5024, 176, 311, 9, 70, "SeeAlsoSection",
 CellID->31447],
Cell[5338, 187, 813, 26, 70, "SeeAlso",
 CellID->10945]
}, Open  ]],
Cell[CellGroupData[{
Cell[6188, 218, 312, 9, 70, "TutorialsSection",
 CellID->502],
Cell[6503, 229, 167, 4, 70, "Tutorials",
 CellID->26928]
}, Open  ]],
Cell[6685, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

