(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    432428,       8567]
NotebookOptionsPosition[    421399,       8196]
NotebookOutlinePosition[    423484,       8243]
CellTagsIndexPosition[    423441,       8240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EQUATION TREKKER PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"EquationTrekker" :> 
         Documentation`HelpLookup[
          "paclet:EquationTrekker/ref/EquationTrekker"], 
         "EquationTrekkerState" :> 
         Documentation`HelpLookup[
          "paclet:EquationTrekker/ref/EquationTrekkerState"], 
         "InitializeGenerator" :> 
         Documentation`HelpLookup[
          "paclet:EquationTrekker/ref/InitializeGenerator"], "None" :> 
         Documentation`HelpLookup["paclet:ref/None"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"EquationTrekker\"\>", 
      2->"\<\"EquationTrekkerState\"\>", 3->"\<\"InitializeGenerator\"\>", 
      4->"\<\"None\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EquationTrekker Package", "Title",
 CellID->20031],

Cell["\<\
This package provides an interactive tool for investigating the solutions of \
differential equations as well as other types of equations that have \
solutions that can be viewed as paths or trajectories.\
\>", "Text",
 CellID->12958],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides a general tool, ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", for finding numerical solutions of differential equations. The ability to \
simply specify differentiation equations in mathematical form gives a great \
deal of convenience over FORTRAN and C++ solver packages. However, for low \
dimensional systems, an additional level of interactivity can be achieved \
with a graphical user interface. ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " allows you to give the equation, optionally with parameters, and then it \
opens a window that allows you to specify initial conditions simply by using \
the mouse."
}], "Text",
 CellID->11183],

Cell["This loads the package.", "MathCaption",
 CellID->1508],

Cell[BoxData[
 RowBox[{"<<", " ", "EquationTrekker`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16186],

Cell[CellGroupData[{

Cell["Basic use", "Section",
 CellID->12997],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox[
      StyleBox["EquationTrekker", "MR"],
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"], 
     StyleBox["[", "MR"], 
     StyleBox["eqns", "TI"], ",", " ", 
     StyleBox["y", "TI"], ",", " ", "{", 
     StyleBox["x", "TI"], ",", " ", 
     StyleBox["xmin", "TI"], ",", " ", 
     StyleBox["xmax", "TI"], "}", ",", " ", 
     StyleBox["opts", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "open a graphical interface for specifying initial conditions and \
showing the resulting numerical solutions to the ordinary differential \
equations ",
     StyleBox["eqns", "TI"],
     " for the function ",
     StyleBox["y", "TI"],
     " with the independent variable ",
     StyleBox["x", "TI"],
     " in the range ",
     StyleBox["xmin", "TI"],
     " to ",
     StyleBox["xmax", "TI"],
     ". "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->21299],

Cell["\<\
Choosing initial conditions for differential equations using a graphical \
interface.\
\>", "Caption",
 CellID->13224],

Cell[TextData[{
 "It is appropriate to start with a very simple example to demonstrate how \
the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " operates. Entering"
}], "Text",
 CellID->29754],

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", " ", 
     RowBox[{"y", "[", "x", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", "y", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     FractionBox["\[Pi]", "8"], ",", " ", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22308],

Cell["\<\
brings up a separate window like the one shown below (starting with a blank \
canvas)\
\>", "Text",
 CellID->8500],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 Evaluatable->False,
 ImageSize->{567, 461},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[6]:=",
 CellID->2186],

Cell[TextData[{
 "The curves shown, which will be called \"treks\", are the solutions (shown \
in the y' versus y phase plane) with initial conditions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"y", "(", 
      SubscriptBox["x", "0"], ")"}], ",", " ", 
     RowBox[{
      RowBox[{"y", "'"}], 
      RowBox[{"(", 
       SubscriptBox["x", "0"], ")"}]}]}], ")"}], TraditionalForm]],
  GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
      Scaled[0.35], {
       Scaled[0.65]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " through the points displayed as dots. By default, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "0"], TraditionalForm]],
  GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
      Scaled[0.35], {
       Scaled[0.65]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is taken to be zero, and the trek is shown for the extent of the range (",
 StyleBox["xmin", "TI"],
 ", ",
 StyleBox["xmax", "TI"],
 ") given in the command, in this example, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["\[Pi]", "8"], "to", " ", "\[Pi]"}], TraditionalForm]],
  GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
      Scaled[0.35], {
       Scaled[0.65]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". To choose an initial condition, all you have to do is position the cursor \
and click the right mouse button. The trek will be shown as soon as it can be \
computed by ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", which, for this example, is within the blink of an eye! If you hold the \
right button down and drag the cursor, the solution will be updated in real \
time as you drag. The currently selected trek is indicated by the larger \
yellow circle. You can see from the screen shot above that there are numerous \
controls and values that can be set.",
 " ",
 "Each of these will be described once the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interface has been demonstrated."
}], "Text",
 CellID->26667],

Cell[TextData[{
 "This starts the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " for the simple harmonic oscillator. When you enter this command, a window \
like the screen shot above will open. The window is running modally, which \
means that until you close the window, the kernel is controlled through the \
window.",
 " ",
 "When you close the window, a list is returned and kernel control reverts to \
the notebook."
}], "MathCaption",
 CellID->5578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", " ", 
     RowBox[{"y", "[", "x", "]"}]}], " ", "\[Equal]", " ", "0"}], ",", "y", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     FractionBox["\[Pi]", "8"], ",", " ", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"EquationTrekkerState", "[", 
     RowBox[{"\<\"\\\"\\!\\({y[x] + \\*\\nSuperscriptBox[\\\"y\\\", \\\"\
\[Prime]\[Prime]\\\",\\nMultilineFunction->None][x] \[Equal] 0, y, {x, \
\\n\\*FractionBox[\\(\[Pi]\\), \\(8\\)], 2\\\\ \[Pi]}}\\)\\\"\"\>", 
      ",", "\<\"\\\"\\!\\({}\\)\\\"\"\>", ",", 
      TagBox[
       TagBox[GridBox[{
          {
           InterpretationBox[
            StyleBox[
             RowBox[{"TrekData", "[", 
              
              RowBox[{"\<\"\\\"\\!\\({y[0.39269908169872414`] \[Equal] \
0.11499999999999999`, \\*\\nSuperscriptBox[\\\"y\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None][0.39269908169872414`] \[Equal] \
0.10999999999999999`}\\)\\\"\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
             FontColor->RGBColor[0.7137255072593689, 0., 1.]],
            
            TrekData[{
             y[0.39269908169872414`] == 0.11499999999999999`, 
              Derivative[1][y][0.39269908169872414`] == 
              0.10999999999999999`}, {0.11499999999999999`, 
             0.10999999999999999`}, {
             0.39269908169872414`, {0.39269908169872414`, 
              6.283185307179586}}, {
              RGBColor[0.7137255072593689, 0., 1.], "Line"}]]},
          {
           InterpretationBox[
            StyleBox[
             RowBox[{"TrekData", "[", 
              
              RowBox[{"\<\"\\\"\\!\\({y[0.39269908169872414`] \[Equal] 0.71`, \
\\*\\nSuperscriptBox[\\\"y\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None][0.39269908169872414`] \[Equal] \
0.7150000000000001`}\\)\\\"\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
             FontColor->RGBColor[1., 0., 0.5647059082984924]],
            
            TrekData[{
             y[0.39269908169872414`] == 0.71, 
              Derivative[1][y][0.39269908169872414`] == 0.7150000000000001}, {
             0.71, 0.7150000000000001}, {
             0.39269908169872414`, {0.39269908169872414`, 
              6.283185307179586}}, {
              RGBColor[1., 0., 0.5647059082984924], "Line"}]]},
          {
           InterpretationBox[
            StyleBox[
             RowBox[{"TrekData", "[", 
              
              RowBox[{"\<\"\\\"\\!\\({y[0.39269908169872414`] \[Equal] \
0.43999999999999995`, \\*\\nSuperscriptBox[\\\"y\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None][0.39269908169872414`] \[Equal] \
0.42000000000000004`}\\)\\\"\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
             FontColor->RGBColor[0., 0.43921568989753723`, 1.]],
            
            TrekData[{
             y[0.39269908169872414`] == 0.43999999999999995`, 
              Derivative[1][y][0.39269908169872414`] == 
              0.42000000000000004`}, {0.43999999999999995`, 
             0.42000000000000004`}, {
             0.39269908169872414`, {0.39269908169872414`, 
              6.283185307179586}}, {
              RGBColor[0., 0.43921568989753723`, 1.], "Line"}]]},
          {
           InterpretationBox[
            StyleBox[
             RowBox[{"TrekData", "[", 
              
              RowBox[{"\<\"\\\"\\!\\({y[0.39269908169872414`] \[Equal] 0.26`, \
\\*\\nSuperscriptBox[\\\"y\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None][0.39269908169872414`] \[Equal] \
0.22999999999999998`}\\)\\\"\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
             FontColor->RGBColor[0.545098066329956, 0., 1.]],
            
            TrekData[{
             y[0.39269908169872414`] == 0.26, 
              Derivative[1][y][0.39269908169872414`] == 
              0.22999999999999998`}, {0.26, 0.22999999999999998`}, {
             0.39269908169872414`, {0.39269908169872414`, 
              6.283185307179586}}, {
              RGBColor[0.545098066329956, 0., 1.], "Line"}]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], ",", "\<\" <>\"\>"}], "]"}],
    EquationTrekker`EquationTrekkerState[{$CellContext`y[$CellContext`x] + 
       Derivative[2][$CellContext`y][$CellContext`x] == 
      0, $CellContext`y, {$CellContext`x, Rational[1, 8] Pi, 2 Pi}}, {}, {
      EquationTrekker`TrekData[{$CellContext`y[0.39269908169872414`] == 
        0.11499999999999999`, 
        Derivative[1][$CellContext`y][0.39269908169872414`] == 
        0.10999999999999999`}, {0.11499999999999999`, 0.10999999999999999`}, {
       0.39269908169872414`, {0.39269908169872414`, 6.283185307179586}}, {
        RGBColor[0.7137255072593689, 0., 1.], "Line"}], 
      EquationTrekker`TrekData[{$CellContext`y[0.39269908169872414`] == 0.71, 
        Derivative[1][$CellContext`y][0.39269908169872414`] == 
        0.7150000000000001}, {0.71, 0.7150000000000001}, {
       0.39269908169872414`, {0.39269908169872414`, 6.283185307179586}}, {
        RGBColor[1., 0., 0.5647059082984924], "Line"}], 
      EquationTrekker`TrekData[{$CellContext`y[0.39269908169872414`] == 
        0.43999999999999995`, 
        Derivative[1][$CellContext`y][0.39269908169872414`] == 
        0.42000000000000004`}, {0.43999999999999995`, 0.42000000000000004`}, {
       0.39269908169872414`, {0.39269908169872414`, 6.283185307179586}}, {
        RGBColor[0., 0.43921568989753723`, 1.], "Line"}], 
      EquationTrekker`TrekData[{$CellContext`y[0.39269908169872414`] == 0.26, 
        Derivative[1][$CellContext`y][0.39269908169872414`] == 
        0.22999999999999998`}, {0.26, 0.22999999999999998`}, {
       0.39269908169872414`, {0.39269908169872414`, 6.283185307179586}}, {
        RGBColor[0.545098066329956, 0., 1.], "Line"}]}, {
     EquationTrekker`TrekParameters -> {}, 
      PlotRange -> {{-1., 1.}, {-1.02, 1.}}, "CanvasSize" -> {400, 404}}]], 
   ",", 
   GraphicsBox[{{{}, {}, 
      {RGBColor[0.7137255072593689, 0., 1.], 
       LineBox[{{0.11499999999999999`, 0.10999999999999999`}, {
        0.1150414079591088, 0.10995667721108053`}, {0.11508279959766518`, 
        0.10991333883471954`}, {0.11516555022194003`, 0.10982663091941328`}, {
        0.11524823551707533`, 0.10973986070353811`}, {0.11533085543616449`, 
        0.10965302823631339`}, {0.116153448897391, 0.10878129035780473`}, {
        0.11696945324233085`, 0.10790338195623539`}, {0.11777882237516184`, 
        0.107019352624261}, {0.11858151038341215`, 0.10612925250927363`}, {
        0.1241282718889222, 0.0995849680919736}, {0.12931431363749993`, 
        0.09275128545476288}, {0.13412457144617596`, 0.08564807070178344}, {
        0.13854506429034527`, 0.07829596325271528}, {0.14256294622597995`, 
        0.07071632833604559}, {0.14857598176592157`, 0.05701026568061077}, {
        0.1532747738085413, 0.0427999380368068}, {0.1566177795808793, 
        0.02821101502701317}, {0.15857542160398838`, 0.01337255061048041}, {
        0.159130383970067, -0.0015842008281603537`}, {
        0.1582777570806617, -0.01652693864830429}, {
        0.15483379603836162`, -0.03676249782364437}, {
        0.14881383721845323`, -0.056386426788164475`}, {
        0.14031801922213438`, -0.07507224120130021}, {
        0.1294876909833527, -0.09250905842171375}, {
        0.11650304004811497`, -0.10840677802768414`}, {
        0.10158009711570418`, -0.12250090460979501`}, {
        0.08496713865526745, -0.13455695076796292`}, {
        0.06388780638299582, -0.14575093620585589`}, {
        0.041371424032652135`, -0.15366649649660538`}, {
        0.01792446073610296, -0.15812558337564336`}, {-0.005925683252153517, \
-0.15902789789007127`}, {-0.029642538397071462`, -0.15635314358948624`}, \
{-0.052692633463976464`, -0.15016148497009793`}, {-0.074557494817965, \
-0.14059219301179915`}, {-0.0947453087067529, -0.12786051320073596`}, \
{-0.11280198379721562`, -0.11225282354296413`}, {-0.12832136517965417`, \
-0.0941201931910099}, {-0.14095437017457393`, -0.07387048559424521}, \
{-0.1504168403442862, -0.05195918436097638}, {-0.15649593318212662`, \
-0.028879147868474894`}, {-0.15911900178218505`, -0.0024749199318016978`}, \
{-0.15731838147358004`, 0.023998119616940587`}, {-0.15114412695336854`, 
        0.04980398462515984}, {-0.14076788900525236`, 
        0.07422524037702584}, {-0.1264781386539961, 
        0.09658294739232963}, {-0.10867214898291509`, 
        0.11625553662002631`}, {-0.08784494661014859, 
        0.1326960868980184}, {-0.06457555247389067, 
        0.14544753193870769`}, {-0.037962754673081064`, 
        0.15454389802878854`}, {-0.010164251059252496`, 0.1588133362345973}, {
        0.017951716993040275`, 0.15812249763859135`}, {0.04152339000391482, 
        0.15362550734968858`}, {0.06415089214889974, 
        0.14563533818173624`}}]}}, 
     {RGBColor[0.7137255072593689, 0., 1.], PointSize[0.02], 
      PointBox[{0.11499999999999999`, 0.10999999999999999`}], 
      ArrowBox[{{0.04152339000391482, 0.15362550734968858`}, {
       0.06415089214889974, 0.14563533818173624`}}]}, {{}, {}, 
      {RGBColor[1., 0., 0.5647059082984924], 
       LineBox[{{0.71, 0.7150000000000001}, {0.7101339490430286, 
        0.7148669378063706}, {0.7102678731486683, 0.7147338505185524}, {
        0.7105356714757685, 0.7144676257638869}, {0.7108033700157079, 
        0.7142013006698597}, {0.7110709687308905, 0.7139348752738723}, {
        0.7137414574521556, 0.7112651127618523}, {0.7164019222912265, 
        0.7085853614576317}, {0.7190523260404229, 0.7058956588385803}, {
        0.721692631477634, 0.7031960426786209}, {0.74753219477811, 
        0.6756630471279}, {0.772322047246825, 0.6471812599279064}, {
        0.7960273851878317, 0.6177906846003}, {0.8186149182180483, 
        0.587532589491736}, {0.8400529282404817, 0.5564494639456024}, {
        0.8781762840314213, 0.4940964913281238}, {0.9116798264465087, 
        0.42914427480633976`}, {0.9403873420368204, 0.361934463024375}, {
        0.9641477987546376, 0.2928206351146324}, {0.9828362008002268, 
        0.22216637702167458`}, {0.9963542340819457, 0.15034337737164574`}, {
        1.0065570565094422`, 0.04655917295081535}, {
        1.0059785560528125`, -0.05772372318450639}, {
        0.9946249020444565, -0.1613883376323493}, {
        0.9726177065625832, -0.2633243042623199}, {
        0.9401926931589012, -0.362439775740286}, {
        0.8976971713539708, -0.4576731140113541}, {
        0.845586314916852, -0.5480042646163984}, {
        0.7758836541265227, -0.6429070250674929}, {
        0.6955857414863632, -0.7290304261019648}, {
        0.6057891031750519, -0.805198389312948}, {
        0.5077199771706472, -0.8703707868139705}, {
        0.40271756823332316`, -0.923657642128575}, {
        0.2922157601603316, -0.9643312849491192}, {
        0.17772353496923227`, -0.9918362872297019}, {
        0.03907369255611305, -1.0068754234305735`}, {-0.10032467266817645`, \
-1.0026264713230189`}, {-0.23780118041391077`, -0.9791708168282393}, \
{-0.3707222751943823, -0.9369577858552983}, {-0.4965416688137767, \
-0.876796026418725}, {-0.6128491185987242, -0.7998380229537201}, \
{-0.7174165933109741, -0.707558011637949}, {-0.8082409582163242, \
-0.6017237449662171}, {-0.8850392628643715, -0.48169535918588924`}, \
{-0.9441382689751967, -0.3520338747890064}, {-0.9843560956582177, \
-0.21533230361202432`}, {-1.004888453815844, -0.07432444747775253}, \
{-1.0053247307246205`, 0.06816977334823945}, {-0.9856562014683645, 
        0.20930071377351128`}, {-0.9462762035380774, 
        0.34624599201381817`}, {-0.8879722706613787, 
        0.47626693249163365`}, {-0.8119103835053739, 
        0.5967633347404022}, {-0.7196116519885277, 
        0.7053254730544596}, {-0.6129218956627119, 
        0.7997822869496505}, {-0.4808761685413255, 
        0.885484656500662}, {-0.3370937261213459, 
        0.9495750600903514}, {-0.18508385850858194`, 
        0.9904892476278581}, {-0.028556659280979155`, 1.0072286288091707`}, {
        0.1286675214719647, 0.9993846464581307}, {0.23023538884249803`, 
        0.9809774028818843}, {0.3072519038624728, 0.9596464295780869}, {
        0.3823357574568333, 0.9322791260781419}}]}}, 
     {RGBColor[1., 0., 0.5647059082984924], PointSize[0.02], 
      PointBox[{0.71, 0.7150000000000001}], 
      ArrowBox[{{0.3072519038624728, 0.9596464295780869}, {0.3823357574568333,
        0.9322791260781419}}]}, {{}, {}, 
      {RGBColor[0., 0.43921568989753723`, 1.], LineBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAKFyPwvUo3D/iehSuR+HaPxFK4iN3
Ktw/a0x/xbPf2j8h0pNu+CvcPx/mVMcf3to/xqux1vou3D8kM9if99raP+xC
QOT8Mdw/98UQIs/X2j8p7TWX/jTcP2HECE6m1No/GBTaFfxS3D8i2WKG+7Ta
P6LGMgfWcNw/jXVnOS+V2j/hIPBFjI7cP+Bj1Y5Bddo/CxLHrB6s3D9Z4b+u
MlXaP6cfgu5Vvd0/GJLKVgkf2T+ALdCTdMHeP2LsjwPQ3dc/at85GAi43z9n
x7oxFJLWPyLhAvJRUOA/owBv82c81T/g82nEcL3gPy9VEb5h3dM/HNDC9dR0
4T/0/+HZ/zjRPzjS2PSVEeI/WLcvb6z0zD8yiXifxJLiP7ldz80pS8c/DMDC
0Jv34j8rOS/BG37BP+tNbqiBP+M/gRqpyrgstz/ULPhvCGrjP+8rGkC6c6Y/
I7dW5llz4z+bF9PN6tOXvzYKVKUFQOM/64QHfT8Rt7/BxX+rq9DiP2Ao+MvL
8sO/CZg+LKcm4j9Oi5y3xB7Mv9aUAUcKROE/3d0I14f50b/uBoWSlyvgPx8+
9p2hq9W/XbzYAHPB3T8L3Qy5KRrZv36m18EMZto/LaauW5uc3L+xAu/3eKHW
P7uPrC8Ord+/SrUcurqC0j8ZYo1jph/hv8vnrbh4NMw/LAhZRYwk4r+B/W8Q
HPPCP4bA2UMp4eK/5J4GEX/Msj+65pnljVLjv0QVW9sABGO/xY8aYvZ2478j
9JwFYfqzvwfPmqrRTeO/rVJy0eGCw79nV+vt/9fiv2okWGMSu8y/x2RPPFQX
4r8sk4+FkcDSvzlk/OnLDuG/dXmS9xzZ1r8kSw99A4Xfvz5pmXzmltq/GAHU
TTtv3L+shZ2LEevdv6+1BHWA6Ni/IbgTkzJk4L8a+JHI1P7Uvw1lGC/AkeG/
57bwIcPB0L+w9CgVuIjiv8mo8Sniyce//4cxuwEq478DmN+PikS7vzb0T4Sz
cuO/mJVydQrdmb/9KbhhfWHjv1y+Ps3S56w/i/hv5K724r9PMZuXIo7BPw7D
Y801NOK/WEKVpyiRyz+KIuMilR3hv1nGMCxfitI/hCYN6alv3780RuYgdPbW
P/neSNKYQty/rSu7J1LG2j9gIOuAAqDYv6eW4FbYJt4/vFeV0gSX1L9TIeTE
/YTgP2xrnX5nONC/kJ8hBN2x4T+WI66arCzHv6HfTromleI/UNpgIFYQu79P
69m4KSvjP4Oia50dW52/ZksSLHZx4z/xLT+HmAKpP+M6Ur3nZuM/qpim7DEb
wD8rdgJONwvjPygHbvFl6cc/oz/qEC+G4j+1LLd7t3XPP3RN1YoczuE/xnkd
Og==
        "]]}}, 
     {RGBColor[0., 0.43921568989753723`, 1.], PointSize[0.02], 
      PointBox[{0.43999999999999995`, 0.42000000000000004`}], 
      ArrowBox[{{0.18681024826587955`, 0.5788798647281407}, {
       0.24577992955014386`, 0.5564100944124406}}]}, {{}, {}, 
      {RGBColor[0.545098066329956, 0., 1.], 
       LineBox[{{0.26, 0.22999999999999998`}, {0.260061221943056, 
        0.22993075544291236`}, {0.2601224254445424, 0.22986149458962601`}, {
        0.2602447955557019, 0.22972294030047993`}, {0.26036709186588775`, 
        0.22958432086583638`}, {0.26048931434041744`, 0.22944563632500428`}, {
        0.2617074706892217, 0.22805521854647343`}, {0.2629182053356877, 
        0.2266583336917028}, {0.26412148408857683`, 0.22525502120876742`}, {
        0.26531727282494916`, 0.2238453208930722}, {0.2753444713225623, 
        0.21138923124285458`}, {0.28478738946175153`, 0.19848457229001826`}, {
        0.2936259961513746, 0.18515873473756608`}, {0.30184153350065784`, 
        0.17143999346194275`}, {0.309416568258818, 0.15735745944815688`}, {
        0.3215000242496308, 0.13091110436178968`}, {0.33132784410555227`, 
        0.10354631067270151`}, {0.3388311008307107, 0.07545503388356196}, {
        0.3439571441696346, 0.04683436931313478}, {0.34667001048308904`, 
        0.017885118308271667`}, {
        0.34695066585338563`, -0.011189612807450712`}, {
        0.3432211517122419, -0.05195388481543211}, {
        0.33471892881513887`, -0.09199569821475954}, {
        0.32156220497587773`, -0.13075825033957103`}, {
        0.3039339353437331, -0.1677025191114761}, {
        0.2820792541388738, -0.20231476964145576`}, {
        0.2563020673904824, -0.2341136938878891}, {
        0.22696082404572013`, -0.26265710634281647`}, {
        0.18960166850915466`, -0.2907768518484316}, {
        0.14880226208536704`, -0.31362056121712195`}, {
        0.10530289504382886`, -0.33077374295838835`}, {
        0.059892846860078335`, -0.3419251597796288}, {
        0.01339606583664442, -0.3468724730795759}, {-0.033343781453890664`, \
-0.3455259159894218}, {-0.07947861807743087, -0.33790992119653074`}, \
{-0.12417134478619841`, -0.3241626781660055}, {-0.16661102889710572`, \
-0.30453362545289153`}, {-0.20602761832744246`, -0.27937892488725347`}, \
{-0.2452328466206601, -0.2456843779619433}, {-0.27899946118651286`, \
-0.2065411948913663}, {-0.3065786004684062, -0.16281746956581372`}, \
{-0.3273586300318148, -0.11548288022050145`}, {-0.34087870333878206`, \
-0.0655871835593079}, {-0.34683898222973514`, -0.014236935103866427`}, \
{-0.3451072828964692, 0.03742905155927098}, {-0.33572201020790304`, 
        0.08826496035930965}, {-0.3186781677411069, 
        0.1376379219794183}, {-0.29441928604657275`, 
        0.18389468989699934`}, {-0.2634945987070482, 
        0.22598798690539734`}, {-0.22660425667411518`, 
        0.26296479884342805`}, {-0.18458347639378164`, 
        0.2939879514931489}, {-0.13838363011080704`, 
        0.31835506451016865`}, {-0.08905070630014095, 
        0.3355144537794934}, {-0.0377016279434247, 0.3450776217608864}, {
        0.018778933416400623`, 0.3466227503362245}, {0.07476197991623075, 
        0.3389847005159456}, {0.1142765970396734, 0.3277816953012594}, {
        0.15219142449331172`, 0.3119899857475838}}]}}, 
     {RGBColor[0.545098066329956, 0., 1.], PointSize[0.02], 
      PointBox[{0.26, 0.22999999999999998`}], 
      ArrowBox[{{0.1142765970396734, 0.3277816953012594}, {
       0.15219142449331172`, 0.3119899857475838}}]}},
    AspectRatio->1.01,
    Axes->True,
    ImageSize->{400, 400},
    PlotRange->{{-1., 1.}, {-1.02, 1.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{459, 497},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->331879057]
}, Open  ]],

Cell[TextData[{
 "The returned list has only two elements, an ",
 Cell[BoxData[
  ButtonBox["EquationTrekkerState",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekkerState"]], 
  "InlineFormula"],
 " object and a graphic. The graphic displays the treks that were generated \
while the window was open. The ",
 Cell[BoxData[
  ButtonBox["EquationTrekkerState",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekkerState"]], 
  "InlineFormula"],
 " object contains all of the information required to reopen the window with \
the same treks as it had when it was closed, allowing you to save interesting \
cases to be explored later. Its output forms are abbreviated, showing the \
equations, variables, and a list of the treks generated, each of which \
displays only its initial condition."
}], "Text",
 CellID->26695],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EquationTrekkerState",
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/EquationTrekkerState"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["eqns", "TI"], 
      StyleBox[",", "TI"], 
      StyleBox[" ", "TI"], 
      StyleBox["y", "TI"], 
      StyleBox[",", "TI"], 
      StyleBox[" ", "TI"], "{", 
      StyleBox["x", "TI"], ",", " ", 
      StyleBox["xmin", "TI"], ",", " ", 
      StyleBox["xmax", "TI"], "}", 
      StyleBox[",", "TI"], 
      StyleBox[" ", "TI"], 
      StyleBox["treks", "TI"], 
      StyleBox[",", "TI"], 
      RowBox[{
       StyleBox["<", "MR"], 
       StyleBox["data", "TI"], 
       StyleBox[">", "MR"]}]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "A data object which can be reused to open an ",
     ButtonBox["EquationTrekker",
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"],
     " window with a list ",
     StyleBox["treks", "TI"],
     " representing treks that were generated. The data is not shown in \
output forms by default."
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["Trek", "MR"], 
     StyleBox["[", "MR"], 
     RowBox[{
      StyleBox["condition", "TI"], 
      StyleBox[",", "MR"], 
      RowBox[{
       StyleBox["<", "MR"], 
       StyleBox["data", "TI"], 
       StyleBox[">", "MR"]}]}], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "A data object which represents a single trek. In output forms, only the \
",
     StyleBox["condition", "TI"],
     "s which were chosen to generate the trek are shown."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["EquationTrekker",
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"], 
     StyleBox["[", "MR"], 
     StyleBox["state", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "Open up an equation trekker window with the treks saved in the ",
     ButtonBox["EquationTrekkerState",
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/EquationTrekkerState"],
     " object ",
     StyleBox["state", "TI"],
     "."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->26809],

Cell["EquationTrekker state objects.", "Caption",
 CellID->7603],

Cell[TextData[{
 "This reopens the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " window in the state it had been in when the window was closed to generate \
the above results."
}], "MathCaption",
 CellID->20487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{"First", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->10419],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"EquationTrekkerState", "[", 
     RowBox[{"\<\"\\\"\\!\\({y[x] + \\*\\nSuperscriptBox[\\\"y\\\", \\\"\
\[Prime]\[Prime]\\\",\\nMultilineFunction->None][x] \[Equal] 0, y, {x, \
\\n\\*FractionBox[\\(\[Pi]\\), \\(8\\)], 2\\\\ \[Pi]}}\\)\\\"\"\>", 
      ",", "\<\"\\\"\\!\\({}\\)\\\"\"\>", ",", 
      TagBox[
       TagBox[GridBox[{
          {
           InterpretationBox[
            StyleBox[
             RowBox[{"TrekData", "[", 
              
              RowBox[{"\<\"\\\"\\!\\({y[0.39269908169872414`] \[Equal] \
0.11499999999999999`, \\*\\nSuperscriptBox[\\\"y\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None][0.39269908169872414`] \[Equal] \
0.10999999999999999`}\\)\\\"\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
             FontColor->RGBColor[0.7137255072593689, 0., 1.]],
            
            TrekData[{
             y[0.39269908169872414`] == 0.11499999999999999`, 
              Derivative[1][y][0.39269908169872414`] == 
              0.10999999999999999`}, {0.11499999999999999`, 
             0.10999999999999999`}, {
             0.39269908169872414`, {0.39269908169872414`, 
              6.283185307179586}}, {
              RGBColor[0.7137255072593689, 0., 1.], "Line"}]]},
          {
           InterpretationBox[
            StyleBox[
             RowBox[{"TrekData", "[", 
              
              RowBox[{"\<\"\\\"\\!\\({y[0.39269908169872414`] \[Equal] 0.71`, \
\\*\\nSuperscriptBox[\\\"y\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None][0.39269908169872414`] \[Equal] \
0.7150000000000001`}\\)\\\"\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
             FontColor->RGBColor[1., 0., 0.5647059082984924]],
            
            TrekData[{
             y[0.39269908169872414`] == 0.71, 
              Derivative[1][y][0.39269908169872414`] == 0.7150000000000001}, {
             0.71, 0.7150000000000001}, {
             0.39269908169872414`, {0.39269908169872414`, 
              6.283185307179586}}, {
              RGBColor[1., 0., 0.5647059082984924], "Line"}]]},
          {
           InterpretationBox[
            StyleBox[
             RowBox[{"TrekData", "[", 
              
              RowBox[{"\<\"\\\"\\!\\({y[0.39269908169872414`] \[Equal] \
0.43999999999999995`, \\*\\nSuperscriptBox[\\\"y\\\", \
\\\"\[Prime]\\\",\\nMultilineFunction->None][0.39269908169872414`] \[Equal] \
0.42000000000000004`}\\)\\\"\"\>", ",", " ", "\<\"<>\"\>"}], "]"}],
             FontColor->RGBColor[0., 0.43921568989753723`, 1.]],
            
            TrekData[{
             y[0.39269908169872414`] == 0.43999999999999995`, 
              Derivative[1][y][0.39269908169872414`] == 
              0.42000000000000004`}, {0.43999999999999995`, 
             0.42000000000000004`}, {
             0.39269908169872414`, {0.39269908169872414`, 
              6.283185307179586}}, {
              RGBColor[0., 0.43921568989753723`, 1.], "Line"}]]}
         },
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Column],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]], ",", "\<\" <>\"\>"}], "]"}],
    EquationTrekker`EquationTrekkerState[{$CellContext`y[$CellContext`x] + 
       Derivative[2][$CellContext`y][$CellContext`x] == 
      0, $CellContext`y, {$CellContext`x, Rational[1, 8] Pi, 2 Pi}}, {}, {
      EquationTrekker`TrekData[{$CellContext`y[0.39269908169872414`] == 
        0.11499999999999999`, 
        Derivative[1][$CellContext`y][0.39269908169872414`] == 
        0.10999999999999999`}, {0.11499999999999999`, 0.10999999999999999`}, {
       0.39269908169872414`, {0.39269908169872414`, 6.283185307179586}}, {
        RGBColor[0.7137255072593689, 0., 1.], "Line"}], 
      EquationTrekker`TrekData[{$CellContext`y[0.39269908169872414`] == 0.71, 
        Derivative[1][$CellContext`y][0.39269908169872414`] == 
        0.7150000000000001}, {0.71, 0.7150000000000001}, {
       0.39269908169872414`, {0.39269908169872414`, 6.283185307179586}}, {
        RGBColor[1., 0., 0.5647059082984924], "Line"}], 
      EquationTrekker`TrekData[{$CellContext`y[0.39269908169872414`] == 
        0.43999999999999995`, 
        Derivative[1][$CellContext`y][0.39269908169872414`] == 
        0.42000000000000004`}, {0.43999999999999995`, 0.42000000000000004`}, {
       0.39269908169872414`, {0.39269908169872414`, 6.283185307179586}}, {
        RGBColor[0., 0.43921568989753723`, 1.], "Line"}]}, {
     EquationTrekker`TrekParameters -> {}, 
      PlotRange -> {{-1., 1.}, {-1.02, 1.}}, "CanvasSize" -> {400, 404}}]], 
   ",", 
   GraphicsBox[{{{}, {}, 
      {RGBColor[0.7137255072593689, 0., 1.], 
       LineBox[{{0.11499999999999999`, 0.10999999999999999`}, {
        0.1150414079591088, 0.10995667721108053`}, {0.11508279959766518`, 
        0.10991333883471954`}, {0.11516555022194003`, 0.10982663091941328`}, {
        0.11524823551707533`, 0.10973986070353811`}, {0.11533085543616449`, 
        0.10965302823631339`}, {0.116153448897391, 0.10878129035780473`}, {
        0.11696945324233085`, 0.10790338195623539`}, {0.11777882237516184`, 
        0.107019352624261}, {0.11858151038341215`, 0.10612925250927363`}, {
        0.1241282718889222, 0.0995849680919736}, {0.12931431363749993`, 
        0.09275128545476288}, {0.13412457144617596`, 0.08564807070178344}, {
        0.13854506429034527`, 0.07829596325271528}, {0.14256294622597995`, 
        0.07071632833604559}, {0.14857598176592157`, 0.05701026568061077}, {
        0.1532747738085413, 0.0427999380368068}, {0.1566177795808793, 
        0.02821101502701317}, {0.15857542160398838`, 0.01337255061048041}, {
        0.159130383970067, -0.0015842008281603537`}, {
        0.1582777570806617, -0.01652693864830429}, {
        0.15483379603836162`, -0.03676249782364437}, {
        0.14881383721845323`, -0.056386426788164475`}, {
        0.14031801922213438`, -0.07507224120130021}, {
        0.1294876909833527, -0.09250905842171375}, {
        0.11650304004811497`, -0.10840677802768414`}, {
        0.10158009711570418`, -0.12250090460979501`}, {
        0.08496713865526745, -0.13455695076796292`}, {
        0.06388780638299582, -0.14575093620585589`}, {
        0.041371424032652135`, -0.15366649649660538`}, {
        0.01792446073610296, -0.15812558337564336`}, {-0.005925683252153517, \
-0.15902789789007127`}, {-0.029642538397071462`, -0.15635314358948624`}, \
{-0.052692633463976464`, -0.15016148497009793`}, {-0.074557494817965, \
-0.14059219301179915`}, {-0.0947453087067529, -0.12786051320073596`}, \
{-0.11280198379721562`, -0.11225282354296413`}, {-0.12832136517965417`, \
-0.0941201931910099}, {-0.14095437017457393`, -0.07387048559424521}, \
{-0.1504168403442862, -0.05195918436097638}, {-0.15649593318212662`, \
-0.028879147868474894`}, {-0.15911900178218505`, -0.0024749199318016978`}, \
{-0.15731838147358004`, 0.023998119616940587`}, {-0.15114412695336854`, 
        0.04980398462515984}, {-0.14076788900525236`, 
        0.07422524037702584}, {-0.1264781386539961, 
        0.09658294739232963}, {-0.10867214898291509`, 
        0.11625553662002631`}, {-0.08784494661014859, 
        0.1326960868980184}, {-0.06457555247389067, 
        0.14544753193870769`}, {-0.037962754673081064`, 
        0.15454389802878854`}, {-0.010164251059252496`, 0.1588133362345973}, {
        0.017951716993040275`, 0.15812249763859135`}, {0.04152339000391482, 
        0.15362550734968858`}, {0.06415089214889974, 
        0.14563533818173624`}}]}}, 
     {RGBColor[0.7137255072593689, 0., 1.], PointSize[0.02], 
      PointBox[{0.11499999999999999`, 0.10999999999999999`}], 
      ArrowBox[{{0.04152339000391482, 0.15362550734968858`}, {
       0.06415089214889974, 0.14563533818173624`}}]}, {{}, {}, 
      {RGBColor[1., 0., 0.5647059082984924], 
       LineBox[{{0.71, 0.7150000000000001}, {0.7101339490430286, 
        0.7148669378063706}, {0.7102678731486683, 0.7147338505185524}, {
        0.7105356714757685, 0.7144676257638869}, {0.7108033700157079, 
        0.7142013006698597}, {0.7110709687308905, 0.7139348752738723}, {
        0.7137414574521556, 0.7112651127618523}, {0.7164019222912265, 
        0.7085853614576317}, {0.7190523260404229, 0.7058956588385803}, {
        0.721692631477634, 0.7031960426786209}, {0.74753219477811, 
        0.6756630471279}, {0.772322047246825, 0.6471812599279064}, {
        0.7960273851878317, 0.6177906846003}, {0.8186149182180483, 
        0.587532589491736}, {0.8400529282404817, 0.5564494639456024}, {
        0.8781762840314213, 0.4940964913281238}, {0.9116798264465087, 
        0.42914427480633976`}, {0.9403873420368204, 0.361934463024375}, {
        0.9641477987546376, 0.2928206351146324}, {0.9828362008002268, 
        0.22216637702167458`}, {0.9963542340819457, 0.15034337737164574`}, {
        1.0065570565094422`, 0.04655917295081535}, {
        1.0059785560528125`, -0.05772372318450639}, {
        0.9946249020444565, -0.1613883376323493}, {
        0.9726177065625832, -0.2633243042623199}, {
        0.9401926931589012, -0.362439775740286}, {
        0.8976971713539708, -0.4576731140113541}, {
        0.845586314916852, -0.5480042646163984}, {
        0.7758836541265227, -0.6429070250674929}, {
        0.6955857414863632, -0.7290304261019648}, {
        0.6057891031750519, -0.805198389312948}, {
        0.5077199771706472, -0.8703707868139705}, {
        0.40271756823332316`, -0.923657642128575}, {
        0.2922157601603316, -0.9643312849491192}, {
        0.17772353496923227`, -0.9918362872297019}, {
        0.03907369255611305, -1.0068754234305735`}, {-0.10032467266817645`, \
-1.0026264713230189`}, {-0.23780118041391077`, -0.9791708168282393}, \
{-0.3707222751943823, -0.9369577858552983}, {-0.4965416688137767, \
-0.876796026418725}, {-0.6128491185987242, -0.7998380229537201}, \
{-0.7174165933109741, -0.707558011637949}, {-0.8082409582163242, \
-0.6017237449662171}, {-0.8850392628643715, -0.48169535918588924`}, \
{-0.9441382689751967, -0.3520338747890064}, {-0.9843560956582177, \
-0.21533230361202432`}, {-1.004888453815844, -0.07432444747775253}, \
{-1.0053247307246205`, 0.06816977334823945}, {-0.9856562014683645, 
        0.20930071377351128`}, {-0.9462762035380774, 
        0.34624599201381817`}, {-0.8879722706613787, 
        0.47626693249163365`}, {-0.8119103835053739, 
        0.5967633347404022}, {-0.7196116519885277, 
        0.7053254730544596}, {-0.6129218956627119, 
        0.7997822869496505}, {-0.4808761685413255, 
        0.885484656500662}, {-0.3370937261213459, 
        0.9495750600903514}, {-0.18508385850858194`, 
        0.9904892476278581}, {-0.028556659280979155`, 1.0072286288091707`}, {
        0.1286675214719647, 0.9993846464581307}, {0.23023538884249803`, 
        0.9809774028818843}, {0.3072519038624728, 0.9596464295780869}, {
        0.3823357574568333, 0.9322791260781419}}]}}, 
     {RGBColor[1., 0., 0.5647059082984924], PointSize[0.02], 
      PointBox[{0.71, 0.7150000000000001}], 
      ArrowBox[{{0.3072519038624728, 0.9596464295780869}, {0.3823357574568333,
        0.9322791260781419}}]}, {{}, {}, 
      {RGBColor[0., 0.43921568989753723`, 1.], LineBox[CompressedData["
1:eJwBAQT++yFib1JlAgAAAD8AAAACAAAAKFyPwvUo3D/iehSuR+HaPxFK4iN3
Ktw/a0x/xbPf2j8h0pNu+CvcPx/mVMcf3to/xqux1vou3D8kM9if99raP+xC
QOT8Mdw/98UQIs/X2j8p7TWX/jTcP2HECE6m1No/GBTaFfxS3D8i2WKG+7Ta
P6LGMgfWcNw/jXVnOS+V2j/hIPBFjI7cP+Bj1Y5Bddo/CxLHrB6s3D9Z4b+u
MlXaP6cfgu5Vvd0/GJLKVgkf2T+ALdCTdMHeP2LsjwPQ3dc/at85GAi43z9n
x7oxFJLWPyLhAvJRUOA/owBv82c81T/g82nEcL3gPy9VEb5h3dM/HNDC9dR0
4T/0/+HZ/zjRPzjS2PSVEeI/WLcvb6z0zD8yiXifxJLiP7ldz80pS8c/DMDC
0Jv34j8rOS/BG37BP+tNbqiBP+M/gRqpyrgstz/ULPhvCGrjP+8rGkC6c6Y/
I7dW5llz4z+bF9PN6tOXvzYKVKUFQOM/64QHfT8Rt7/BxX+rq9DiP2Ao+MvL
8sO/CZg+LKcm4j9Oi5y3xB7Mv9aUAUcKROE/3d0I14f50b/uBoWSlyvgPx8+
9p2hq9W/XbzYAHPB3T8L3Qy5KRrZv36m18EMZto/LaauW5uc3L+xAu/3eKHW
P7uPrC8Ord+/SrUcurqC0j8ZYo1jph/hv8vnrbh4NMw/LAhZRYwk4r+B/W8Q
HPPCP4bA2UMp4eK/5J4GEX/Msj+65pnljVLjv0QVW9sABGO/xY8aYvZ2478j
9JwFYfqzvwfPmqrRTeO/rVJy0eGCw79nV+vt/9fiv2okWGMSu8y/x2RPPFQX
4r8sk4+FkcDSvzlk/OnLDuG/dXmS9xzZ1r8kSw99A4Xfvz5pmXzmltq/GAHU
TTtv3L+shZ2LEevdv6+1BHWA6Ni/IbgTkzJk4L8a+JHI1P7Uvw1lGC/AkeG/
57bwIcPB0L+w9CgVuIjiv8mo8Sniyce//4cxuwEq478DmN+PikS7vzb0T4Sz
cuO/mJVydQrdmb/9KbhhfWHjv1y+Ps3S56w/i/hv5K724r9PMZuXIo7BPw7D
Y801NOK/WEKVpyiRyz+KIuMilR3hv1nGMCxfitI/hCYN6alv3780RuYgdPbW
P/neSNKYQty/rSu7J1LG2j9gIOuAAqDYv6eW4FbYJt4/vFeV0gSX1L9TIeTE
/YTgP2xrnX5nONC/kJ8hBN2x4T+WI66arCzHv6HfTromleI/UNpgIFYQu79P
69m4KSvjP4Oia50dW52/ZksSLHZx4z/xLT+HmAKpP+M6Ur3nZuM/qpim7DEb
wD8rdgJONwvjPygHbvFl6cc/oz/qEC+G4j+1LLd7t3XPP3RN1YoczuE/xnkd
Og==
        "]]}}, 
     {RGBColor[0., 0.43921568989753723`, 1.], PointSize[0.02], 
      PointBox[{0.43999999999999995`, 0.42000000000000004`}], 
      ArrowBox[{{0.18681024826587955`, 0.5788798647281407}, {
       0.24577992955014386`, 0.5564100944124406}}]}},
    AspectRatio->1.01,
    Axes->True,
    ImageSize->{400, 400},
    PlotRange->{{-1., 1.}, {-1.02, 1.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{459, 481},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->190739054]
}, Open  ]],

Cell["\<\
To get the result shown just above, once the window was opened, the delete \
key was pressed, deleting the selected trek, and then the window was closed, \
generating a new state.\
\>", "Text",
 CellID->15999],

Cell[TextData[{
 "Because of the need to choose conditions in two dimensions, the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/guide/EquationTrekkerPackage"]], 
  "InlineFormula"],
 " is limited to one or two first-order equations or a single second-order \
equation. A system of two first-order equations looks very much like the \
example above; in fact second-order equations are converted to first order \
equations. A single first-order equation is somewhat different in that when \
you click on a point, you are in effect choosing the starting value of the \
independent variable, whereas with two equations, the value of the \
independent variable is taken to be zero (this can be modified through the \
graphical interface).",
 " ",
 "For example, when the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " is invoked with"
}], "Text",
 CellID->16370],

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"z", "'"}], "[", "t", "]"}], " \[NonBreakingSpace]", "+", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"15", " ", 
         RowBox[{
          RowBox[{"z", "[", "t", "]"}], "^", "2"}]}], " \[NonBreakingSpace]", 
        "-", " ", "t"}], ")"}]}]}], " \[NonBreakingSpace]", "\[Equal]", "0"}],
    ",", " ", "z", ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->3322],

Cell["\<\
a window looking like the screen shot below can be generated.\
\>", "Text",
 CellID->23467],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
 Evaluatable->False,
 ImageSize->{567, 463},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[8]:=",
 CellID->4199]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parameters", "Section",
 CellID->2357],

Cell[TextData[{
 "The ability to specify multiple initial conditions is remarkably useful, \
but the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " goes a step further in allowing you to investigate the solutions of \
differential equations.",
 " ",
 "Using the ",
 Cell[BoxData[
  ButtonBox["TrekParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/TrekParameters"]], 
  "InlineFormula"],
 " option, you can give the equation with symbolic parameters, which are \
controlled through the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " window interface."
}], "Text",
 CellID->11639],

Cell["\<\
Including a nonlinear term makes a somewhat more interesting equation to \
investigate than the simple harmonic oscillator.\
\>", "Text",
 CellID->22942],

Cell[TextData[{
 "This opens an ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " window for a nonlinear perturbation of the simple harmonic oscillator.",
 " ",
 "Sliders are included in the window, which allow you to control the values \
of \[Alpha] and \[Omega]."
}], "MathCaption",
 CellID->31642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
     RowBox[{"x", "[", "t", "]"}]}], " ", "\[Equal]", " ", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Omega]", " ", 
       RowBox[{"x", "[", "t", "]"}]}], "]"}]}]}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"TrekParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Rule]", "3"}], ",", " ", 
      RowBox[{"\[Omega]", "\[Rule]", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->3780],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{537, 524},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->329319113]
}, Open  ]],

Cell["\<\
When you move the sliders (or modify the text values and press Enter), the \
new solutions are calculated immediately and the window is updated, allowing \
you to rapidly get an idea of how the parameters affect the solutions of the \
equation.\
\>", "Text",
 CellID->3559],

Cell["\<\
This opens up the same window. The results shown are arrived at by changing \
the parameter values in the window to \[Alpha] = 5 and \[Omega] = 1.5. It is \
apparent that a new separatrix has formed.\
\>", "MathCaption",
 CellID->1020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{"First", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->16851],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{544, 524},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->23772778]
}, Open  ]],

Cell["\<\
You can specify the range of possible values as well as the starting value \
when you specify a parameter.\
\>", "Text",
 CellID->8339],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     RowBox[{"name", "->", "value"}], "MR"], Cell["\<\
Parameter name will start with value and have range [0, 2 value] (or [-1, 1] \
if value is 0).\
\>", "TableText"]},
   {
    StyleBox[
     RowBox[{"name", "->", 
      RowBox[{"{", 
       RowBox[{"value", ",", " ", 
        RowBox[{"{", 
         RowBox[{"vmin", ",", " ", "vmax"}], "}"}]}], "}"}]}], "MR"], 
    Cell["\<\
Parameter name will start with value and have range [vmin, vmax]\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->17555],

Cell["Parameter specifications.", "Caption",
 CellID->29030],

Cell["\<\
This allows the parameter \[Omega] to be specified in the range [0, 20]. For \
higher frequencies, a somewhat complicated set of orbits and separatrices \
exist. The result shown below was chosen by choosing \[Omega] = 13.\
\>", "MathCaption",
 CellID->16039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
     RowBox[{"x", "[", "t", "]"}]}], " ", "\[Equal]", " ", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Omega]", " ", 
       RowBox[{"x", "[", "t", "]"}]}], "]"}]}]}], ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"TrekParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Rule]", "3"}], ",", "  ", 
      RowBox[{"\[Omega]", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "20"}], "}"}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->16676],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzsvQuYnmV5Lvp35j/M5AAROQxYbZRWU6oYbJdNXas1bVd13NY2FW0DnoK1
dmi1Rks1dskVte6GChKlXY1Lu50AYsTGBqyuRKEMLLGjbF1D8TB0oUSUxSgu
HGIwk5DDs+/nvZ/D+30ZVK7dfa3u6+pcYfj/+b//+973OZ/fF1xw0cTvvfaC
iy783QtWPvcNF2ycuPB3/3jlc173Bvxp+Mc6naGV+O9dYx28lk6H//nPk/Bf
vuW7/66/h+Oq8r91/+o/+Wzrk+F/gStvxu8uPhiy/3cf8cp/rD7B704P/+/Z
hb9R/jaN30P2yeL3+OFX/Ogr/9+Pj3/75F/LJ1374Df/Fa3p3z75/+sn/sG/
pjV1RmudNi/7tsk1m+U9W2TbnNxfPvg/yrU36u/ejHwFH+LfVvkAru0s178u
iTvslltWyrMn5GJcsUkuxWtcpx88r9zjBv09wMer5Dm8DV7join5bGdZuT/v
NCk718i5+nxK6QU5uFHegcvLY8bLvT5VPtkgb8RKy8vyC9/BN/H9zlJ9r+yL
N+tkArfo4y9DuMkJ+kkff8BO18r543IBXuCt3vtny70/6ffGB+Vif49vF5A5
RPFdfLEzUt5jibaW8uzhaZnB3vCtzhDgUr6/Wn59r3yz7OIZ5Ul7ypX4Gr6s
L0daTxqU9/r1TkeftKS8x36wq1zJDvl73HlWvmpaFliqnnROeRI3AvgAL9g1
/uGpQGGB+/Au+RT+UpDpK7AV9fwJeKhq5wLn3rRMr5Pf6sjQGnnWDvlw4gl3
UWxyH1gkIKR00q/Wpe91XavLuj7on4AmsLTOkH59OOmC68He7Jt8/lZ590p5
0ogswSqwFts3dgTsKxyGylW4Hrc0JJkt0hnZLG9dLc/Aqqfk5t2yZ72ch5ss
yEL5dBjfwR6AO1szbrBeXpdYxpoMUrqHp5c9XF3tLrGAV1gNGMC+iTvjPa6y
dczLPKC3UV4/K7N4PBaEt9hY+XafrASg4Gkr5BxsbcgpGv/fIBdskjf3DHfX
cQOdoeo5+IJhBXQAECj3LDUOyJVf5Vxj9FL23MVugQD8w4ueYxb3UDr0Z8yv
lV8BAI0+sAuAtXzZYQFABb6UV7DeLXJJUPSees0D3B8kNyZrsFssHjvXZ3WN
Zudwe6B7hZyEF3g75GvCpYop3c/Z1X5IhMlPwIFBftgxg0tyN1jHuDwPayqr
A4TeusRXPSEX5n22yXsB+Ia0wXN0BT3fFZYJFHaG9spefe67QWn6csgxYVRc
JEQPXAWoYinYu9KN7uPxZR9XOj0DCcGVAzwJBIGtgDfBjoCSPnvYMYDH5Vqx
CUA8ZcikbDcTe4lfD3SkDMHnwCjwSqgPsOqnytmvkt/DC/wBAgJL5bUjlLJY
Af4KAIDNsSxsRtf/42X92yuuVd4ZqjCJx+Af1oeHFbh1gQlQJW6AS4crms7V
4mqDfE3zytOUX0Af/tTYrV1PLr5ULoOweoVsKCsZAlMPXO5h6SpnuhWdq/7Q
vTwu9zLARgBsKT8zMgO8FjwrC0BGvBl4Vznk0moWnysslzndYMdBB5BL8/gK
1qwM4L5Rd/KQbF6QrQdl7pj4ahYgEvS+LovebLsqOB78lpzb0c28GRcWoaBq
w+5GnUnx26+ks/PLGWVvk+U+oDNAhHvDKo1mu0aze7F2lfEuxebxOXZoz5k/
pkvGwncflr5JLuUCLBzfG5MzgLqy67QSZo/Kqv2y4YB+a+OCrPye7HrYdky5
AngFh80BTLgFIbscG10qy7HpVXIW4IK/YZNADTAGJGL34AmVfKNOf8Cu65vT
y463Ggb24bJxlaKXKueRvyjBaQpgJXiG7tOhtwBNkRIsKa6sdLDjYd0IN7Xm
IVn7kKKxfLfQyCjuJ/5DSMwckdX7ZfqISxNAcvz7AiowDsQ3gG2AEjIIT8ML
PJAUtZT0zH8UvNg+9BQQjB2p5bTUJQioQkxbjZVnX14ICNcDVjSraKpB1AAs
A6cV02WUXNg6WCqlC9gYf1IKH66gozKGeMQuAAHsyD4HcQAoe49K2mXcPi5x
DaO7ByGQw7uAPMgAtIRb953Spg7rP7yIpz5WTlEoFFAMg+bwtZACsFZnADsQ
FNCWa8XGTDsoTE4rMHmXmNYyuzPsCdBPyndABTCGnDKogCtqKTXAe6KLwhev
EyKAACCyEBIMsFhLiISuATj0vWNAwQMg0cbug8lAX2sLZeEFAMzdqBQiJRAG
sIlMrpfnjgBGoCKQMv4KaAJxeA3ADPmOTUInLC4zzlObQGHRN3x8lYoHfwpt
BnJTWTnkvIpb47fZ8niFxQFAeLL+1ayio4Z22+fe8l73PeL77vBH4zn1Nfqd
YsGAyTp9vOMPXqwvXBe6HEJHQdHVX4OgCfxgFXirPByyDe8BDNsBdkd/pUDj
1AoakBRQFUFZaq+AOGCvACYAE14Us7VcC/yDcvXlyb4j0L7yOaUScGq8wd1h
9Q3NDB4AJySvkTNULhRM9LD9bYds87qXvu6zR7xD1FAy8toBpTllD5gbXO5e
HXd3KblVdoKui2Ap70HxxiHD9n4acIr3/enCup0H9R+2gg1Rz20qiiB3Qq7X
nZLm4YXh89TaGxf8+n5rpwUy8NH09ngacYctDgqNnyQnf0u+Fdjog8vIh/ih
p5I7fCdla+zdZK3MA1RKlUudakyr1fJKcTbk77FjXRl3NlU+15fL/D0+V+lF
DQ+KxU5sc/hZTioqmwverPZbKKNHxVi+BL32erjDuttRWfr7ZUd8dh9bpSwW
9YUvMLvrlGq3Sce0uyCLADuqY3wb2xx1SjVZwV1OH3EZFesDcW456JQIjbaK
vEoferbscux7+ldq8SGXZVxeQFev0/sMVxyg+6YdjE82HUwkmyTDYk2aFxgP
8CEkKk2dlE4Dxy/0GPwk/e6ZxX/En5yTC/V1/qKwFL4DSqCOp90PYR3eHzQs
6EDtD7cPrxtn8ML8noAAPwcvcuVGwdgmSEVfrhCTdjOFfI+LNy8zOWIWEOAB
glpFe6BQS3eNkz5IgRChwaEflisGWDk+459gQ5ujW3Y7CnGFfQIo2HDZqoU7
3BqqYNIH81ucpjwMUps6mBYIKAYv3K+bMS+B+wF5GEWb17GgFJN6H/vbUC7p
jLX2XyhIJTtkGbinc6JT1OrCAaQEPKvctwcgAk6ALtRgffcFUIRyLbEDOYYd
hofdxSvABP8AA0ogiDVIbNd3ZU+dwgB9RiBIF9TrHsPYjmeonKWtD5hDFiYE
gG6T1rQBsB1gkZuaLK9196e3dv/EsitAi9QDoKsWom7ZXAgCPIFbQ2IavbX9
InI2rTj8A+mDIYB09/7eQ4u+PHC42ie9NnEDF3AusqBPnyR8M4A2MLiKdgi1
OtYCjIJcgWf96xmtnZU82DBpV90bjyjIuu8rChdsNcM0/3JnACrgm5wC64KU
axIXuwOKfEdl950tZeWgfOC0pt7HOi1upAD+mUXXuLdI27nQTqCrNQ+lnjUZ
vxC8T68veZu01FzRnxtXH4zlQgNTanVOEpOhwK7e9amtVZ3pcAFwZwMu1Cwq
FYjZ1LFcVcrwUYPbXsAxY2KB7/KYH8tV9oNG8APjPeCWPN1e4U+Sq46k+zYE
CBVI2hVhu+IK3UPYZKZdSeEgOlAxwAJawwdAfcZIaJE211vCGD0sVgW8nAk+
1aga7zWtEul88u2MRlwLrIedVtc7raqMCatkLXX301r7+ymnVbri+IpFRx9W
6k2Yp39PyoGMACupd2Y4k5sbcZ8mDjqdNxV0MdZAd60s/itw1bC3iHxZnErj
cn6f3zKfkxFEYiJkzeqCFSw/sABKUw47u7XPZzqPYmO5K3gHWLVSjkvPGei+
DRpBYJymTzuQGjjwZDh6k+/UYub0PnAVdoBNwVrGvmCY4DU21OYog2vY+eZ/
HXSv0SLwQZmL74gyRVyG9Hl/oAamBF5gg4WH+mCY0JuUmsTLGw2bO81nphcJ
CsO6I2Bu/n7gQlS5Or2H5MA6QGdlH0MgpdWt9f48ofV9x4Dje5bRNvJyn3wz
U8JOWKTBu9P5k3I1yAbAVBvoxEWhmda1cV2JL9DwAs0AsmqMl+xAIwc0rdG9
T3Rk+5hcOyl38YoKto8pawtNRBgC0ceqtaUFeuJx0AKcTAIWfuwCBEAsWXSl
Qfz+9XLLWtmzWWYW5MjxWaZ7scAp2AgqXvdvkFtx3TkOUaOQsspeDT5NYHCN
Fzn8aAka/EAeDVtvXbE2xOXEYJfcs1o+BojgyZvkC1jCvBxq5K3wwVoNWBwx
fG6U27bIHfry6dKU/Y8Ew6OxPo3TmxSTvRvUinkeJLTKHOdutX0quRn4eZrt
5t5xuUHXYvpWHsDadMURgZmTA6tkF36TavExvhQ4AzU+iC/py8e36Mk0zVHF
mNoARTr0sJyANbilw738sa32oPlfjPcD1mBL2NkAAYP7anNzHRlrauPhqb4u
LFt34jadQz0iKXiPv3r0QPbb9Yyk4PvAHf6Ef3iBj39cUl7Oum0/gByC+TVW
bHOwN3gnLM8+UBESBHvFjo/kbgcgfUqQQhM31xaz2tRQ2ZRGkUthyMhjnsf0
oQuByaB1s6W2ypdB8rx7o7IG5KYv3W69CzykL5c6/kG9CpWhCmrYfIe7T2uH
UKWPDznhlufD7st7xkbpb64sjHFW5aTDCYU+/kQTiI4bSJXxYWgRQITaf4Wc
BMR3nb4aeN4md3KfFu1eJzdhU9x3Vgt5RufBkiF1Gkha9kjwg9i90oD7MQ8A
+3o9d48HU3Xa/ah5lBYs/9mwADTkPmRrvMZ0BTUko7AjchYsFchAgGS+rPMN
/mlYqrS4fHWzIBO1W7pOASv2ldVwdZCHxonLTXIdWCk78btQRLcUTWE72GRA
JzykI9i3vl9a8Y7u26P5h/C5Qo+8F7TFJw8YdYTNubFwAl4shD4BQHY8zAdK
+OaED7aulL7PWeCzQyoQ+szwQApAkzIn/90KOgytiqdXcLMVjguz489w/iXn
Bv9aNEluw/LF9YpRvOKcMZnQH9ghLix/cG9pBgJdfGfDEJwQ9vketzH4F6h0
IfkgCbEuvBh1jJlkD0utlmGQFx8ARQAIDBnCFPI8lqbV9GW5fef15eo6RkHN
uaKSUOqxnFFR9bRLVeVpAqQBAcV2gVCfOgEQCQ6ClrEEIhnK4zVHTIL2HbKm
x0acHnFffXlWuW9wbiDPszn7gHu1X/m9CbnYrMP/lbvtATasNYCE0NDtY5wj
DeunV5SslOqx2/0mv0ad4w1nlPLYEOgDaKU62OwR73ZsCnfAffU+lrmQu4wD
vNbiph1yt7786UUxDYPYbHLnTbfK6j0C7RCS4g5qZ3F8Jpx7FX6VgkmHWAiW
oy9VQw8VNp+QadMO7f0xwhRyX9TlPwSAYHsWtcRnsPGUPojHmqMZCTvRpIJh
qPOdsqeN5WqaVFLCaJDjUGMrFsVcytqBU6lZJj2DmJkhndNaOygQ7REKsEdH
5GqAxyJH2LdxO/EyHfbPkPHw8xp4AS2CA1VHVXvoRVwf3AqJTBro4V7riqWM
fcxFnJ7Rz8QWUGEUFxrXsNNtUWR7Xyt935DiCgdaZHgP7OBb2FfJPA+woanD
Db5SCXuC0Ypb2CVI0inh+356ZWqX/ApsDHorjGcDubjfloMWX3J7K7yqwJdx
NyNa2Bc5TVTOH4BVoV5BubbhN8zBz/64dC6T1VfJ9H3SeZzTtOGp8OlgSjXF
TrAjYANKNErgk2FtQAsnDlkyEvygeXO8Z4wqve2MGFSQ6IE0CR8oV6gmz2RE
hNussWP6RJh2kOS8YlNT21RYZqwa6wfPgGBXyIfAj1498SXZ/BmZfcDimumr
7N2n4MDHC4dl6huy9lrZfTdz7xX+ST90a5QPhlv0NObSAlZBWGBWtRJw0Ewf
y6JgTcKcYOgaZqXH185l/ULn2wVKf1T2D9hBNFHTDHmmvso9Wkb/sCr/dSWh
ARYAfB7XohTSJPQCtlPQXL43f1A3v2GPwmbVB2Tr54UcTejw05lvu80FCK25
plDOGSZ1vmwWrVePuQdDuQHqgYmY8JkI+zHqq0AnG7T0ybKxAIxHsvtRL4Mf
WnH3J1wySoofhpgJmZRtZYcaKwJTASwwFX/cV2X0fprviki3XQIaWz4nQU9e
z7VHacSk/gMKLHwvNR/oArv3zLHsNy3fr+hI4TLmNG6SkBUaMLABAfxzC3xQ
xxVSLpIuXsU1yFeNWkgBrFQiPBgFCkoZowZ7SoumDSc3KNZjLcMAxa5iwqev
BtCMf9RlLECzcUqCorqQKfgTboEXA1vZg+Z5h+VvdoByESzP2wg1EnDcqeFr
A7vYEPf7ygIR5rJZXAVwWA2FZz9nrGqLttwGLRCy/BvpYZU0JR0xD3Zfc01Z
gem5hxSv+J17X/l+FRDu0R/Wz5UfaMHgFT4HOPCPH9DuppyAUIIoAgOY9TLq
8IdcUhky5vQ6QXotmjzjIUSo4fwC+67m1KIqTjNlzKkBXHgB85xFguG1Quln
1eGqgLdLqyNYX8QbjqMMsn5yN8gf2kOkqq41SqB0BNmsuy75ZhhyAtBVaFo1
QhG0KoG99uMB6BYAAwyZqwCONpOuiSN6WipTT2xSCRgCOwfSv1VBKKsAosYK
cARsJmUnpUrUneGHOrdQo2kNoM1smCVGq2OtvY20uGTge1PvNiLYCbvRirL0
qm4FG73+VJcYZufxedD4JilJFbC6GXckY3S45w1cm1t5RpWRpxFP7ZV7Duh7
AMtFphzC3tTOHFmUKknNud+UeNwvgNGsiLhLZWjuF/LC4GPVp1MuZbjftNmJ
ZcbJc7/QBiyaYuFDY78RtQj7eWaVnMX9pgY+zfcFQyB9h/Sew28yicDIDfeB
1UM0LG9h3uocPyMTN1Q74zeyYgIXNyhj2+2qOvKJoATIjMQ8pASkY3JlRpwp
FZkxEVcD+F1cic4rFsU99GfoTKg9kNFYa59cNSh8ohTnZbTF/FBqE+wSQIDg
x15AqGD9ZS26JjRoEQBYxm/cnfK810z+lWzeIGv/VDZ8R+bsWd9WOZAQAVfg
O/NRw9CmFTAGTdukldU1rUShIQhFa51q+LCIOGhluBkFKdUA9KfsWaAX40Ni
b7NmFoqF49pUNf2011wp9gGn6vPD+n7HbMUXRj3c+0FZmKV06/neAT+ViYyA
0BYxAvJ6+AG+9WoZv1w23SZTV8rWF8rqe6P6M/U370hTJjm3SW8aTTjd6cx2
btVjR1u1rb2oTzZNRLi+vHwb1sdKeXbQ3aC21eYjNnZai/Y8t3MHYAjbGf9A
dFCWNWco7XQdlqYvRlu0x6j7Lpk8R0bOks55skbhwfgeqQv0C8ajXd+KLb1N
JgBDsxxul2lA86DnI03Dp5wGaE3HWdfFHof2KS16IZ+lB2oVosV7iQAdXsx4
NWmfbo8UTQYTH5x9X0BYcwserWhSLMT5+gOLUixzNczMQMiBpQfOT2bP9ir+
S1meNEpP9BOyA9T2vVKRBoIDfMC6VvMJ7OB2gAIUGP0zwvVG2QUu5/3fL1tA
qnE/s7KUv20HX3KeWdqSB6EbzJ8jTFm/kV7VpNdveB3C0UadQo/Vk1KqrVUe
JFSL7mCUxzKowAEt7x3y4cVzGwB2Q0KAlE1ynuxUO7atgiZAbfqh36Ja3u9u
mX2+rEqKA4RBv/o+vA28wSW4sOcyAziA2LBuC7A3aBQPAasDcXg0KQVANs4n
bQKIsK/0ZeH4Puuf4VzTU5zzut7MtpNTQvfu1gzf+Qa/lxFX8hXj+zpLRBAC
clYBbX66vJkZmJCdTblAQZqQTF4LG8v2Q15MTcr7A2wAXn5+iWyEskle7WiT
xlb81TADGn0t2+osPrlPeVn9PnqKADg+xz+AutvijFNsB0eojMz/Zb1zVMYu
Cd0tJavEXC+5G6b6/0w4DurKDtYqRE2EygVYuLD4mIMBDLmaHVF1eqrhQqN2
CT8QAihR5eeo7w/Ep7Js2CkV7/Xz4RY8gs5+TVYqrwf87D3xQSLUl4xVf1p2
40+QFvh3nkZPZ4Zb67B4zDf0fecylwKRxzDNavWaMkfT1H2zw41oYVrAbOLr
VNCExXsuq2FFs7RaIGGWRam02eu6oapOONUo9Avma5zs+DbJZN0G3zbtLCV2
Vls6FTT4rA/LtotggUjlHYH0kpoT2ktdDuAWkLLGHYAzmF71GKEIDWbcwKgc
DbG9JWEDmgVzKCwjPgvrPeJUPUbwoFvxV40EFjk6yiIl/mzQlsr3FuJTRW7Q
fGnZDkh1RWlJlBJjBi2eUPFv2tZ4BPNZBr20+Yl3QA9yCv9W/GUFN2qKhEvC
ceBwqKrLeQ0AY9eMOqXia3d7h4ve89VsOh1ySjeZbNmQ+xRe+p6whX1mfO29
cQ0vYECbnAkleEp0VrjrfkRApYSkAZ12BdE3K1iytTUoE3rpBKduk7mkxMzX
tLXKCb6DBVatcscgpRvJ+0FdBgFCUaVe7Z9BEL6NfgIhCAUNNZ0QADjtflaZ
EjZ42GYmS3g93gCluZ7MEHifXbO2AVAkuXC/S8JGLBCeH5Eldc3SvQnBHpQ4
o8TgakDQKh8mFqzCPjnZ8jKhS0wLc32w84yCljv3/RJdI++mXWv77zkVQvZl
VjZl44h/H+8PevWkwv+FLCEKCjSrm5+nVxheo9k8fJ9WxbDDD1SXGRh8bpHm
st/+eKVp2ObZpsJvVDAEh+8VJUs2PnSCny0yGPxsfhZhyFBv7KmH3YLsIOnB
jiAmgyQozSjJO+tmzL7p+edqbod/jItNLg5alDxwSrydkGhTYtsiH7QosTxP
axAYcxaNGt9pUPTuBdXfGqc99TheZsVZuwvUKi2i2+J/FKi+pHwbV9EWYnYN
hjrhurvF2209zVhK4LoPxoUG5SoAKrjKbZpb1oI0Le+EtMMW1/68rEiqhIZu
yNrUURYhPOjejsVRQ05aN21YXPStAL/12vS8E1AEueKtd++6Li92Up/1Mfyh
l2M5rmJQMniD39DkpR8A6rtY5qTRzp0J415U+sHQBJ0b969v6fGsDiCEN/03
93i4T0I1uSstRUpDeJL2+TKHPMj8dq+zVMoHHI0so1ck7xK+vdnpoaWAje95
XdGAftBcIQ1A2uQprwXMoSVVo0cM3awhfg75aV4eKbfOOzL7YX0/pf+4I2eC
fjkAoq7Z1Yh5Dd2YUsCwUWdxPQ/ire30AUPi/EkaDRjQdbF1JzczPgX7Bn8C
vEma+L14zh9Qa9w3fUpKGaDrw9VUCbMxQcy0kewu6z+u/r++ZN00VJJFHZVO
h6IjLTut+b3oUOrMVtACrZJCraqP0GKULWmRtS9ls5QGJXkCTrJ7M8XYoE2T
h70WzzolzJhmKbTfBUzAw5AZ8H0W7Vg5zhqipRkepnmcSbegPZPz/D6sI7OC
CbWsUyN3h+0iXjtHfsj6//KrU0Yw9EJKsszeODhzPx6VYtwRbItnA2mQO3iB
pY22MMk9pUVIKKcW6bfo49QWjEiHYFyoMMCS4AZZcg8wCu5lfe9JLb58rPOh
WdoFFoPgFamKLDoxscOoqIZHSDSOKjAqgjI3nRE8Z/VMXaeiBtVkLsYqH8Je
HFqUirAps1dq+0bftysfmNUDVZ4jI4QMVwj2M2lHSMCiafBW1vORStY+lBYK
YyqEMH1hffnlCioM1UhxTKIjV3uKWA8NRZ11j03aqTku6BkiSrN0VrUY8S/z
PMM2JKzATkYrJT+JjdaWS+KkXR1C/Zt8A5iCtQ5GjWDiiBBqa8noLZLSzzQu
zyOENsmlNlumhlDYcCZ9omqEXY14AVNmVd2tnlV5p9l93duNeEojNp3Z/Z6/
B00pHAmn1Ge1FzYb8y3SHml3kj3RefZudgsWGd6D0QN2A41ZPDuiFOA4pWRC
DSbpSk7SIcdFXIAcNyZnRD/zMLVfQu48WUwCRQ3vakZq645ZVlBAoAOYxAZT
uJqf5K7TSibUWEojQZ30ehcOV/aqUQGhyOhqQGEQcQAp2hTgABEt2o02BP7j
d8jd/A71Q8YTM2r22NZ6o9d5pK5Ryakky+x6o7POlyoYRhUtXV6faBL1HNZl
U5pyNDLLKpLNio9da3XaxE4Ih+jYvKdRhUWISciq5JvIqVhegE+FbIcBoS8Z
ZwA0QFpgW8ABr4/rdyP10WNzLvd4i1oYvGtaGHxq1jkQjlnLcrx8YwZyuV3n
M6lq+IV8s+rCIadBqyMnbUc9kZS4A8wVhZr1rUbFK6EGG3fzZyT208di8Sdl
isMKPihxXgcW+w6rD5c5HEBHyrWPa8GJPXcZVSU2IB3pnRic0uIbcuwBOwmn
rIBkzDR7/NrVmLRGIkLSgFdQIYMmnajtsVoJ0jKt4qzHYnZuKqzGjKqQPkFm
DOaRl7sAGCQc/oHk+I20jRbvSAThmQcVfr9dHzrDfDSuOGxl7y0skbqEzlQz
9m7dzQkdAIGxOIMOH117ngydGGwfMq/AoyChcbza9xALpWPOxsfMsrfupgcc
l2WKA1auu1K50+4zfJLTAjRCZIcqjdBv8RzXl9mzkE1m5dSyKWv8YTfYnAbL
jsoCB/XYLKiu3eXZZnd+MWGUEgsmKmgu+9fomRr8QT4Ww+wZZPezvHNKGyC1
m4E7gTQwT5h4TL+mTSdnOh2Y7cA1pgfKuju6l/wKo86EQEvKDEfM1vItnEi2
Wd6KXcFlgfZTG3JIgTHMIUAVtD1y1oBL+HxskEnOsrpOroO9J7HeLutFWC9L
uZBpalaDQ4ODFvTl4l2zaYEStyl/2TsS8leKCGvYAFnxTaik3qH3B6hwahV+
h22k1Zc2H8hs5ugarOERXh3Ums5Qio4mq8IgPLLum1UZkLCUJFjkyLvVQSBd
wJA0PC/amVvRBZ8Dv8Wkax1XzM8Tyrx/yxpSjWtdL8zJ1DV0DO1TbvyO/l5S
1x4zaiClZIYGwSnOk2YvlJ2OQmZig5CUN9xjIUuYO5CXqo9PbO1h0T33YaeA
XahUgGL4XUW29bHRu33uC8QC+IuwznoPvoexv5I8S98tMkH4YUXMF3OP2avA
8jfvu4hsksXgwmc40eHcuaz86+qvYe40oDBMw3exPbIjGdQNlj5LOtggMcEy
A14EQQolwwkiIBjsFA+xyJvFh71zyvAaTqXhNXKyUiaK7JZb6j1HlYtFydqV
sG1twD1rDVe15x4JDRyJdWsEpx0taPdiM4M+PQF3TT6xRg7Nc2JhleniOjJC
S9mH51ILgJAABPBOxLgbXJ48SBhEvYR4EpAw+O3yaVTJSjOWm3UuJzukzY4i
FIiMgnT9NaAbTXyCWyGj1KYs1YDQg9rVrCAoW/nCJv2Hn3t3KwCOLHjXM0jF
ZGHYko2agLQtDVMR066rsRIS6cnRrg7ehZLTntkaDiHlpPjdEGlmiZRG84QD
y/0SDuDwGg4jWBPDoIyzhGpvx/VYU/3AjNy5rUCA8jGoBB98bLV+wFXctlG+
XJiCkBpE9i+4RKV+eFJWIxl5ZWgFlTv8fESutkYp01lhSxFKUQvHwSE1lEbJ
Q3xuVNyy1NRgDglhkpY9MzC2DT5DhWW4VEbv6lqioPNKIxYY9UAlu1bJrRvk
hvECqbLKpQGpm9ZpRRR+bpmSbwE1c7JzZUVTIU+8ci2yrW0/NOrCLOrR7nVp
21qEVl1XOyJnGbRerL+XzMn90YMQJidecw4W4ZV2P+EFFdGAF1mecTuuCIrS
dmS1dBGFJ35lzya5r8QrihXQB0QAvwPqyyikAMgagoTXQ/PygnH5tbXyzNXy
9b0K07t3OATz/mZrR7af+Nt2e7OyM6vDOSNAZhhviti7ySUqGiKR9UV3JOz6
oY/EO4SGWjzdtjAK/EYSfpcZWzC+0o7fEXavlnGIqQp2EAIXj8hnt5kFlXzH
p4MnHyhsRylvMJzZLLjwNRPyTnVh5HPTCsavfkQJ1mCY0WjGn6K6ifxLcW70
zyKQhG/alGHFbTlY8WvUbTGJ2SEUX2TU2uhO78ecVykDsCDhec/sxCYUte7A
oUgKZOabUGtb6YAq3OWAaleh+OaO/tu2Zlhu3IyN7Fgv/7w74DYMpfehFYVL
uUdQ203rEq4mB0G2n7lKnrxSFkwOdi/aKFdcql8F2RKyaWFwh6wQBzRZeIK3
Nnl6j8ddI7MOQRgR6WoSCqEalR6b5FKtmyFUf8Ow+dVqilzMM2h03jDaynun
xCV0NVZYEWjwd79Fo4QubGOrQegHjRbo4vM3azv05avk8ELCFgrl1g3VTgFl
cDgAZnEfwPbBWf3Ty9bLFVvtqu6ds/KEMf0iRMTZzhuWG+AVu+9WixaqBC+i
N8y8O5Ol3o7p1RhFMSRMARxOHbbqdML0BQUmACJHQkNiTsjFO+Tvwf7QyKzd
o+MqbnXjd9ijMHv1ZfGmBmoZVkRLVWI+QlJt1MGZLn4EuH5tiqg0uMJEvHd3
tVtYcCYbljhc79gin75QTlsh8/N+FWTqrjcocRfcD4HQqfkzL0C5z2ruvHvW
1oRHa9F7zuWIyYXTMqOJYMKyNAuOwLzhdGUp8+TwlnPQ2GvI0K+UMa2r9h9f
9UhIqjy6TE74SyNQKAEYp8fFAC06ENJt0ILkMH/tWN+AJLj/6pHC/VaHNaV2
YEBSazkB7CvfpBTKK963TSbOV763bB4kLoQroIoXjMel9Uy/GnRqEaTh1v7a
UpTwDG1Eg9jg+Xyur3Q+a10D5xTOac/LGdwS5YbZm3KHeQpcA2GoljLhlJqb
scfgbNEEjmZ1CV+5ep3Bb4jwg0r6XhWLvGeXS0tSLuCyf295P+rww5/WPUeu
3UH4dWEYgSqvO1u1F73BgDl+oNVA2Yz/gmWswod7yAqciBXWmbwqA7fcqYs2
NhNWnX+q4Jjd1oRjzKXBDycl8p7r5RaL5nAN77tDOu+SN93icEwrmvsFEC+S
9UA/OIqSSd6/tgnBW82l9IxH8C4hSLnXgOB//SVjZF4Bjb7rRUpu5k0DZvdb
IEqAD8CSdJj6KOzfho/C8QMSMjKr/gm/6O5mcWYDfpljIPzqWS2s0TRZEfFJ
8jJMjZP/yhgZeuUcGfGs9tAnZAelV0BM/12x2rwbaAmzdywyGXo6qjV3vkTt
Ro96b5TLfkedaYMzQPSx1RX14H4PltCFZWrS/iK00rb0OcV31J2y3b2yH9Yy
a2goS9Y+1LAqe1GTYF0thF856cOmZovLoX7oeCnjWHGftr7mNCPouZf9V8M1
vZWx42F2z7TFPGjbSEjDlHYBs80vkj/b7J9fv0ue/x/0EoMZaNFokzCDrwyy
S5hl/UxoDgi7hBm8YPPAIjYL8w5+BniKxYWsBdl2yLMCMcvdZrCrRVPDLaao
G9xYK0x40D8mLbMbT1+WqFs/atDwwxqqMS4z4LZzA+ksJRolIIhmbiph2AUM
AbZfOFudPIuszsuJIybRuB9AmIah11ZOOe0RbiB1y0GEhjA7m9fHnJnGhJmc
QZL9zzEZxTiXlMeAuZS+H7VuaghmfSFtsHAF9esPuk5i/2vCLyoJ8UPrpUF3
f/pjcsnj5bteUZN0UvLxeF1g2QVsATsAC1Y0oQtZ9tFxJTKrCrq3xL+CYlSf
HCoz3S0jndFVQi47Jgi5rCMj5MCf5pO5feAxAZs8ErGlmFWw9aD+W7DJpT0O
TJGwbmpYZiUEpSDUTfQxcgLbKUbPd1ptKKHJghT+UO6U3fXlvc9SaN78F2Bh
2tLMSMLAuGdXRZOgJ4MS+RYun5b6r3V6gOz7y3Vyy3rfJT43fBCqIHC7H+kR
YrihKdod5dlXXM/AadCrSXk+vzUnpM9+v4mSRwTEHbY6PBzGDmMThOvzjHst
O2ZcXsfE2UtkllN43KSG2QfUj0lsZ+aUld/ythPlHacY4GHZ3Lp1eYvKCF/y
r8pJwhfMC/i+ZZPv76pJ+d1fVp/Q4Ju6ifCF8X3bxvLeIpS3Sme7TN51fIWs
TXOJ6CHlZFjckP2UBb0WdZPeYko5aHh1GY5oFQGt7EpMjRuRs9R2vL2CddY4
EdZQWewZxA/lssVyo9/X5up5Zw1+QDwgIXKoLMzLnw7Jbf/FcGCk7Pcfhnl4
7ZgkB4KQ56q9dwF1VUCdDpQRLSD4g2f9hP4ROBrxe5he67f4ocif3uYZ2Xib
LIDqPiZTc1VFmdm8bQ1PbwRUDim7WWed7smsfdI6rRPO2YakHP9+1p5UE4sI
cc6FEQ8nNSDe1mFMWxGSnDy7qO2kHb2sD5CG7h+WT76lSI0tthYF9z3TCeHU
aCUGDklAC4Z2NyANk9z68OZk/I2y+3PO17A6dz1N0WN8AcP0lvUV3NO+MEv+
gIxdq3DHz657ZPwGs1izd2GF86l5mDFdA2CfjknjpSy5RESs6vP7jSmqGRGx
85Jq6MaEM4NuxKSkaZlm9JzQDe9CiovpFoIGjeSDvwVRzAgL3pKOweNMHRiU
kwYt9r1ZPvnynBLXWzgkq14uO/5BVr9Kpr/sdPOLa+Rv1xX9RwinxUVIpJXK
Tvktdyhl8wdwXvEh2bvfn5h5nqjjL3osrIjDUk5acGmZMRJmJiebk4Gye5gF
MQ0oZ6Uon8UOkPiu2sI2o/2xFUbjWd2o4xBmZQzWk7AFMs5T4h5XrM6ngPju
3lHBPOU0IaCu+msrmG/9WzVQFaGfljV/4Hd9zYRsO69oR5t6scqlN2Ge2tHq
qXbKzAMJF5Xm20p7QsYcLUtAeYXtgDeBiu/5RHcoJYsAmH6NuVqWEz7q+VHP
c+ugrPIe9m8NdwhwBvENAmypyW9yuGbCPe0dk2bfUM2e/QFMfuf3QfZWmcWK
Q3nbCvP3u/H+u3tjr+0o9DAEiklzXg+p/aYLEyP9letlxrls7IUye49prPdt
kwufq0ZyeiomWYoFCU4zb/l+WUXc2PwmaKFSbmUUAERY9S8nlMC0Yq2e9ZFy
VWwDTHykfVagNsqmGv6wPlp8gJFxQSn/G6blkruHUHK8EVuRAyY2oFUsfk6N
AxZYfZWqfhZK297ZWZB3ASWZZ8rshdw/K38+lntWS+bzk4kTuni+KpX3tLaY
yFMrseOVX3fJyvX5pBH15iZt35+bFjg51LqknbZn1IqUD1PrJm4gmcaurXCT
HVrMIkfmMMpSrWao1L4ldlIDEzt1j27M1rDZwzV2aLDH+vqtCQdATljnlrUm
VkIT0AzOKSCNmkbYllYLa1iB4Jocr7ACF+26iYQWA90SUiX1BT0PiH3YjNC4
gZ0t15j0MuxAiK3daPumz8nID7HT9LnqeIdFJ/aoKSTBmVQd+T7r3qLzyLRJ
WzLwfXborDBeOGAet2JpCIYMtciczDGaaf5TjaHWmTj9sJqk6T+l3cuZDBGh
ltLV2+jTS9+F6zxLOqYFS5+C7NlkMfb7Zky3EF7wPG8Yr/DTzgvhw8//l4Kf
Mgt2AGzEz/x+GXmOQMPbM58wJrvXF63OZ2W8fqS6t7407XlIRq5WfW60A8Np
1z0VbrLri/eDMWX17l5zONmo18j6eGr6jCJR37Rm7asftiAL8LrGNBGR+MkT
LogfNkdwz5xlTPykPuu2nm8TGIKj6d+E/BVPjJj+hyT77La4bliTSRePwKMw
uN25TaZLkJr25mj4Dvih33DdBzV7HHNXhlf8uuwl1Vu2sxhf/IHtde0r9YYZ
uzYvcNTfM1XtPWb3yNqql24Ywm7LHRWWsnogail/SWsV/RSTjGdH9tqq98Me
s1pKYoknFSWWomqqI2fWWJqQi61KkNQUEQt7Ts5VjvoZ8+S47oyr8/rsVCG2
6mhFw+8A+9xTZ63w/mtTBczlPcTZHVsSW8uYm+YPpd87t8hFG20MFUwBGATs
AF3/doHpxh9Ya//5D4ujQqimHOVuI/ptWEotxOthqq2/pcISo875Oaxm67Nh
fi/6h/DD+oGTHGpWfUEt1LE50PoT84tYitiZqbDD4G+ut3W6TDWP82SnArPK
TU5HbDBq6a2Gpl3xy8+zd6xtwRmWoJRKCiKtXbOpiSWF70/ZvqhTXrZeYJ4R
S/Bf4CESS0DRxOV2JTD5uguK406opm2wpPUUmyS8xyWcVWrMqa+e76Oy0HaZ
3e7EUmSElXIKBIiljPcRS1EzJd5lLVo4qeXGDSzF/Albb1TrFagOhU+etZVm
4+zziBPXuWGPNgrm58njxE5Wl5rVANRcPJLYUPG3M6uMK9+kRDaW/t3PyLlP
1dAzHcNnrlY7Dai5fUYu+ks1Fwi/EfjwcHj4c/0uNfpwpwe9oyA507yICX9P
7MA2mDtQYQOGwooPVe8zH8/7ZS8fsRP5bfHyWmIncyjETmRMxDvMCprK6dY1
doAwm/nj86IbZ7RU8S7yUEe2m74LLDRyOSnhrAtmqu42Vn/UeCdiV4N4f0WV
XU6NQexA408M5Oc78s5lcvmlMujI77xQsQN7ACJt2/WOHci6FVbEK3fOalkJ
fU6uLq0F7jYjDTbJ70G3q7mKznaZr0+8S16JOm3zT3tOgxaNsc7dy0y+e91X
dIsSS9GrLdXUEctp1Vhq+6ZhLbjfHD3fERPocE5T22qIbjbr3Iy+KPPaeL+s
p0sL/P1Vx6RGIslb7WgVM/ewGICnSzryEx0ZBq6KYfeWTRqgmZqhVT3SWavG
nZLxgqLzM6+Ujz9TM9zDjn+zELhj1rQlpnbc7d4pV5SRBO4w80BeGTDZmOeT
PaDtXpTwjMyfLBDtxukhwknD5bYWvakxBQOCF8XJDVaXa+vIeFu7g6/dj8l1
QsSZfWd+77udotq+g0URYJA/vEWOzVt8XBUSpZ5VHcC9vX827w8Fv2tVte8/
+j09fVRRFngDG4Gl5h4wvNVxBnDfdb+iJc5gJK4HgtBi0DY3NXyxEm3Y9AWL
M0NL7b63wlf2i8YUAqNArpMdErnvrJvmujMfWuA6iPpu/MQ5gyXmQ2yVBHEP
THWFXNmVp0zqeRT351nijXPSM/v8GPvWEVh5r5BPP0H+VvurwtarLfEB66bA
afjr739KTv7rqkuPdSAV1g6tl0Nr5eAax9qNm7XAM7EW0TtCAwLNPCq+P7Qg
395bcccVWxWFgUXNRtORIreMwNkNJwu2+vWvlu0/Jvu/bjhsRx+AU6MR3h2M
t4OZQfIejMDJutoWdiBdQ9ttaxpU/yzJqeuUPI9xXrD+L0rHmOYnpbWSOGGI
33ju14x2vsq5DnZ6JkxFm2vJviA4YDvkw6AC3IRnuGuXofVHfc8rrix+Xnof
IDz1XttLLNs6t4PuGh2twOnyK7S0k5XhfVbO8YeNHcx1yrG95UCQcrbe0SnL
5ipr3pq1QsWCvLmaPJRVfnx/6Xp51Uq5e8av/+Tu4/DMwJPhecMlae3D1rzy
POXV6QsNzxnXIJ4hcI13efdVu1ym2qzE22RzlYvrR65NSp4KmpAqgW1v/Dtn
E9BG6fjYaXpho7urWQlxBi5L9A2//7F8j+cRKmq7+qsXueFPy6efJD+pNx4q
OvE0OT1Odq9q+nnuMLl2s8xACSfX2gkz2lWvv/psmeSaWF1m03EOy7Irqn6Q
qN+FVLrXT7EaKH7xlIO/KQvPkGNzcnirPLzBcR2xRMN1RLEiq2G2CGOKwDJw
Pb1L/tNak5nfmnNsDxXZfGJJ5sEeBTsXDC3b9L6MMkLdvufZiu8dj7WgJQQx
BAfzstudBU2Dw8yBsbMQ5zSmr8e4ELj5fHnWa+Q3oW2AXBbiWYVb3adAK534
zjwQ8R2zaaWK/VodRY1v9SCAZ0V14edd8qmvy9dHZamdKDwsPdY2mnyBv2ix
YELyh/Gw9ngqYLbr/YB4Op/60WU2pV37+lkZ3St9L3Ti4dwaXR+dlYOr8PQD
GnwHWx/+z/re8AxD6WtTFZ7/ebfZTlxd5qEoGT60Wf5mo0CCv2hEK/T5rZHT
Vhiu8Q+cCzxP7lZLl/FdMPWGSwySkPXveooMbe8w0okf2k6Rfz9QxSZ7wDBk
9+//o5x+rToifvbHXbLhVkmIcg4n5HRnSH9p7P+PZB1MX17fZSM+nz+0+TOG
7/TgiO/IvdT4hgOiczOJb9pA2TXFmmSd4V3jHyL/JfJSRX2/dY7wkOPf3i/K
072ap3VWnQqiEmns0qFlbRUxr9OJK8z3aYy5xlJJ1DOsj8mBgdpZhLO8c6VF
bAzrMLLeuTKxHg0shoe3jitr4wfc/YXdjnXo4sA6ZLsWkU2q60msgwLGrXlJ
rpqUvzidWB+G0Ibu1rpZUmBmNm32xIOa2QF7gx+2S/FBzfYi74MgLPoWsyzA
0or4bsH+06V/g3w0r2fP4geghXl9ZM+L/ZRnumWWnfTAMqigB9rFoAdV3v++
RQnv+QH0oVn/mj5wC21mdProszSQP1pH8KDECRyL8z0ERqGUgRIF/t/pME7E
9n2fNfRAgzJ0qhIAYZRxVE8/Jl08UY4Uy84qLg8vyD/tkLevkFsule/5hDz1
n97cSerISg1SxyvG5JsFg5AMO7c4dbxmwkjjCdTSnc7E5Srv7VSMQ3LxB1T3
g0xgrN8ypS5YEfSd4Y+dIx97RqmaI7VmLtEiX6WeQ4mjWyhk7NpmlGJqTtZ8
oroe4v4sPT2r0+kVCvl7+aBhyCb4yST+fiGUtkXiYlZaTE/lBo6rly0YHwky
4VQS8X7dxalkqVHdkP2fLThqRZBKhsuvNXIujIMn4eWgUEkcA6CPKZLKuAES
oqISjaxUMzdpJeAF82bikczoP6n7BPtskQrfBbaBU8nT5fA25xhKi8tXVZXM
b1thnTTmb0dumPDKqijaHdAeN/xf8hsduXFSvjsnu7fJpZ6DHwlf4C2bjGqg
OkAjpivv0doJ+OLY3VopUf3375T3dIHJQjmQKhYxafdHmC59oJDNduUKpZxd
xlLRP3G/rNxZXQ+/vEE5DKeIy5b+q+W5b5KX8k/0oJa1cD7sFGM6nRQzss/y
yhGiZ6XbLxhNlPqcjp0dbVmBpEKevjov+4xoih/R48nrPE1dJwnQ+mD5Z+4o
KwzC+qjppz/lprCUojMY/MPl7+NyQ2yK5ySQhuDeGxmV3sDB+EfN0kwyOjrr
0ubQK+Rw7SdC2lyxuupugbffiFBH/RKjiaAj9hTgBwLnD1bJ8G8o1s9bIdf+
maomo6HwM+6cNRqCyQkaMn17SAM7Sj7dQkOnrpPL+goCoyHop0YsJ3WhZVHu
btIQUz9JQ3v3N2kI1kmDhsIUMRr6PXnuuT6jlzS0vEVD1v0cfeWkofAYdExC
8ZGYt/uFFrW07/Zn5e8nGYX9bPn0j+XPXyFv9LOv9cTNUsmjZISrhgoljcvz
GnZs9vLbedFyq1FSoZjhEDmmJWDUgIgulS/ZuqzCpXUSDYgHIirmWPbgshkZ
4QfeidkzB58phyfl0HqXSPfNWG9Fj5T0ZUsJeP4QJu2XM07dC38Couh1q/GH
QkcvPVle+fjyLcoxejA/fWZ12h8IaWomqtrvKmS0VilBKemPTub+nZLu2eWU
wVVmR4fppQeblDTlrJeUZNH2mJZklDRcfr3AS4ytjuK35efOKaWS4pNIFqck
YGpxStLB5YWS9IQqOfNZRiM/nIKi33BQn9c0p2q7zOyOk7obFAP5cop8OD2f
X5Y95oGxLhE3t/xkRS2mmXmCEHjpdceepULl6AysWxDIkNJHT/ex0FOfFtbN
obVOJTBtGlRys0vz7LSlz0ufNqgEzu0IKITTu5f15PWvcUR1OtBHSRE7/qFJ
ES9+QpMi7thyHEVYvsUibbc6RQyXX2s+IY0Vqse7vboeJh2Jwjyf1TKwOmf6
uv9eTsbfKXE4rTK62WID3cVoogdERUamyADSQMSL1/xA2mhbwtRYG+UdNg3P
agM9D+dz46PrnzVb8NA+Ld9i1Q+sXz9LQPaYhWOz8T7XoImB5XEPrgIlqLd7
aK0snNwpdNGVg6W/7Oi0LKxMW6ZBE1+batLExzdqeNMh3oNqCLL4bzsA5yI5
Hppv4ml+XkAmH7uukhwMRHv8+J4mnWxa0aSTKGYwOsnYl3UKHxIjFfpI4ze4
BRyZIPs+KZnzDK+WK3zqw4DOAP4xA0TiYJ1Yp5Nn/tU51N6ah34wTdSaR18u
XZQ2nmv39olGFqn0/p1HoAVAh6cdMrGbtDBV66TsbGNk2mjh4S2QKAX/D5e6
g2N74RDzOcf1hW6zDkS3QSK2TfzDANnp6gg2SGdQ8P+SkzyiXSA3urAgdH/O
/U0dAFH2rRSwdy5q4C5xChguv85Z36SA65/mgG7Uag/f9h05aUep9V3SwjT7
6j4tu4lXVpgAr6uv8jqSnBpJfK79Ifh87g/Gn1UzWEaqjLIMitXq+IvLITmT
h4pXyxisRjJdO2ApwOVieNQYDePbsL8Vf8fmHH/FDVG5fsD2r75pQaH7IpPj
ZkMOAn87q3nRgT9b93s2qCNSkFh+/ckajWMqZi2mPStnr8ooZu+0FRbqYEGR
8/t+MYQWv6Q3/kb5x79WbF7ZL7Ws9Gv/7sly+9uDMxKn6XUsjlN4HcQpZTlw
qn5+0b8A4sk/AJcxEetR4XKFnGS4tDxzqT/SnrAh/aUTjaymm7W8kRUUDYjr
fC9+Lyc4NLDahb/NbCZkc494Pep9qwes6k6++FH5P8e0k8zw/PnJBh7hUDbw
CAlMVHaG9Ff3rePqWgKVX5xyu39BqyRKKLr8esJYMUPXKhoLrSyde0Arjz5d
7Hkg522nyk2lWOBAMWRAOSVilXjLWpXAm0lh4u21si7wBjH7KPCWXbWPBm/s
okra58myirJuwVtUM/tcCj353PAGQwtMOGJP3/lIeGPNCmxvw9sxV3yBt69N
UYQ+At7mphxvxMo7f0eb6iE8bQ+wxoGxvP72Gc8i9DxnBJQBU2bhUKgqKc1r
ccstUyW628DR2kYsZ7tXuxJHEJOBI7xmQemjxNF4C0dv/8E4sqssdn+kIOhB
VXEPajeVFzSLBhvV8olOu3qKXwtHpdrVZogWzddLXMGYPzDC6H9P48Dxc6BT
4Ywx/0fEmc1CIM7AaDdOJh0Nw/Nu4OzaHYvhTOQ4nOHn0eGMWgHWTMMPun7f
tFW+PeZR4e15Lby9reCtOFD447vwX39RzK5o/fWUH/LeLewfzK2QskoBan0V
SoilkxJWyS6ryozegVgdieG4abIn+OckBuvmUZcIWpj/Dm/yDpsDvlrmTGz1
hTKWLkYV3exldkv8kemCK3vVhkb+t/uLa1ICPxJlDFqw9D7iNqUMta7rtShn
eb0rkb+SzYzGPHPfv6vmpLYjd0pLBds5BU28L5/QDH4mWR13lzYtnNx6v7iN
/C9GYQ09vuFAgbeqgvJrjaezTR9Ej5AUPb5Obgrog/qcwlQfnOh/pyo3iihZ
pkJWR3b8MKratmZxqsqq3oqqdte9vNTpuWv4WiQss9BeMK4mdxDWI8qc/48o
69UyTsr6qX0rT39/NQPpXydl/dyilJPWvEV5y9mXaQGy5TWw1o8pC1JO6oEF
GNClaR+UYx23bgFaRbtGcEg5R2falGM6CTTDDKW9j/rYtl0fOupDm5tUc3c9
NeTzt8ljl+lcucTvD6GXho7qhe2HH61GGHGqsApM7vPnZUVDUz3xvjUr3v+/
fhBN/Gia61F62jbFPHDLPliD5Ecf9jM3GXXT+fjuow3BZfyRPLTE5NFZw6RP
spZje4lMW6WG9BuYhIfGypJFMTm4cpNhEj+w8s9bIV/5dFi4pRgz95ZeNrEI
cz6wCDfuOCzOPmie16YvaIFmYtHgWOTc6L2yF9jDNq+Qi18uvyRlUv/rvjF5
wge+/iNZiiNylk2H+CHW/KOKjo3I1XCDga2nynXvkH96dBGR+Fxl9sKJ+VTF
1sLKClvf3VthS7ueu44lq6ElllgXwp8bJ9UR2/5Gg+cAPjMYzbZcMKTxL2KI
TMefJ6/UInbHUFnPKHzjybussAsCt3eVpX41/LUotnp3yywDnjye0CdVxFk9
P4qN+KPFQPJ0D8/QWP9+Ysz6dogxTsfQUxxl+4UynRizfhLrZG3GuI/H2KHz
ZOEJFcaOTmmws4GxP6/Ow8uqPX4fjhIjmIY5KNf3bDAIHFpQzOG3YQ488zn3
zIm5Ka/mG42KaGIOGD6yoH7CvbsjOu/TRvADx3jkaumXaOWmL/gt+y0MxgRM
q1svsaR+TOoXD1QynoV9/QvFsyJ/UZ0fFTi0nAVxyCwcuG5IrlRJGTi06Pkj
4rCetTksD18uBx4jx/Y6Do/s0jh1A4esuDAcRjUeuS/r4Zh1uXFS3jpuf/qH
7YrDqLocwB66PhJRnc6aPyg4NPl5SMwzo80BYQrb6a5JraDVuBVX385bbbzN
sxSsv9g847ePLhHLUlCj3C7Tz5dVbIELjLp32saoTVmLLMSsd+08Wu7MnkV+
i5OkE6aZCS+w0OqqCZn+Y7ltVK4e9dU0sJpnjRIukZsMrL5JNd3DWxyrh7fJ
wxsqrB5eaGIVTvc/V3XV7LFOrMLMfd1q2/3bn28FE4bV10xoKV1glSXS3MlS
daeeY5+FhiQSmUI3z7CNV/Jo4nXSC+eP6/4hXuFEXS6bWNNPvEZXk/jJtoHX
H5JxnJd9UJNtj7zG51b5gM38t65JuY6T+gz6W+Xd5k93F8UvvZul8kH8C/xa
tyrvkDqC+M0qfsMvbJsFbMjPb9dswsOb9aXFUYBcTj213BIU533ZDTUc9QuG
32/vlVeUeAwE7ouXKH6hQg2/7IgM/K57ixYwJH5XmjhUscv6KhbZsFjB8Ltn
rePXZNttzeziDi/99loQt4YMv+zTJ6/qjrQfqp21t4mMrdqEsao2geNAWN9S
ZG3H61qI1zzLgfeOqZesRdAaBK1iWagnmOyNsz8of18rn7XaA0IejGyaITBr
85+jasUm73Yd09aRa5jWoFmnwvShdVopnZi+eKQx/YLNyXk/iM/G9AugFqar
5gtLdHo42NpOKb52h3YrB7ZZCG/YhrRe9XL7DMr4yYWIaHtxVEBi255pUbvg
5uFWdUFUydkEDWKbkxdI8+TmmOonXplCbm5XM0VFc9S/EdszTSxbh39Z3Qgw
Sus2RvzBepqU7eZdR40sedcKZEs3X/HTN/vk8ex6tZzDNZrw0jMa+XkUPVoN
kdq7R+2kCjWbjs5kRSw7jaw26XtzWsYW0GrVPA7/wSq5c7rUrRGjLxpRLk6M
3j6jDkdglKXuhlHWwPPnk7vVvbxnl/UdMahmGM2OZj5z/S3Ov8z6zvjgHD+p
+d5GX3o/TkYWL/ynzR2nbuGH5xcQr5mvadU1RlsYT2Wr8bpD/n6tnJ94hRSG
VIYZHCxLOd3GK/0vzepb3nP7XtlvsKcmTkoGt9psGlID56IQ87xv9OhYllYP
3DpSiPvYvEa/rdY9+tINx9HFybvcsr5R9az9Kx+9VAvdLTd4d9POGczPm24l
jlnmzjUuY/07f66a1KL46HrngAL8JuWlVrCqogeaWN67v/HU9qSbPjxw9gri
By+AWcba6s7oRtW7TZSMqvcRPwEWDMmphY2qd+IZf7IZKlzlhFwIB3U+zrzn
iZkLMSF8rNXPEhyMf1rZbJX8cRoQvwU029no/FacfMBGJrsqZ/sYtg9voh6m
GV11NrDmy7D9TzvUjA445ixE3vXGSXnjs6pMMIOOsZY+1GzUE7L7nV1LW67J
7vc/26xamz3uhEvORaLmAOatutBmzNzk2GY/C+3yrV/2DgfiOGaySBlg9DaZ
ICfHCW/4Ydz/UfQ28AjnBpandYrOs/UlLdSMQZATs0vJK6edf1nBFdWjXqsv
d9uEa+tyir5V4jfmYUEG6akcNp+8yKoKv6WISy97eEKta8PvjvXNDqWbt2ix
Tqwt+M3uCgX8wn6F37+eaOIXYph+EvALnbv6VYbfehYSrW724hO/KTNo44Ot
zbumVk1u3i7Rq0QH2HBb8ymnahC3AQVp9ilFJcwifUqQu8Rtoy+NuM1ZmsRt
THUz3Ob5ZIRfcixxm31HMQ/R8lBWFX9t4/T2fkyvklKNCM/JsxTWjePY5dmf
x0rc6dicY/e6Cau7Ggls1xNhcgIh7wrl28Buy8Lqx0kYwC7s57EXErsDGtb8
gQl23UfK7ApChOZV4jYnVpJLybunXRv5lVt9DgzXmCcQk1ZyuirXFO+JYZhY
tKazH56dpa3OQ5pLNoWsxrBO9CyusWGYR0glhrMz2KzU4F5W7NKETwxnl7LZ
H3Fys+5PdYpZ7Ad92jOf054Koaaz5honq35hcqrhNvSydalGFza/D7u5UaPT
trXAkq/aYLhlREN/8zOGO/gDg+zm97Mex59jeW3iNydlWW6+8O7jPlJ1Ejc6
h/NsqOiTtn1zH9+ROZswYxHda5td4Dmbml3gMXdRypF+1eTrVs++TVfw8+Td
X4qefZtkHH1NDSwzwJJYbvf0Z/7Y5ED0EFv+4P1+8ibf5xmuVjF5zHWAcTKE
dDlswbEdJwfw+nbmBlaXYbvbsrrK85YAa5S4MJ1/cY2hXXyKILFex/1PWyGf
fbuGPzL+efVIhfWcNM31nXWdLL+mVNiRCjg6NteX89BKJgTagXDMEyei95rn
6Ri2p/XEhl2B7W59ZnTMaGCJbHvmST1hfzjmmB43TYP7S64u3T/Dm73Z1WtD
o685YpXmy3N/PLU5P2/PdMhZ7zZt42te8WMVd3Cj6DnFtA3TiAb/0juqqC1V
9yeGnYUf0sIN43oCGc+HCPRahItzUyJuiR9ex9MTwvs2m4sQy750YviCUjoL
Ue2nG13bnICXU2q54ozAk2LD4n6EaRzAQD2NY3TCp9IUBL+e84SYcm1gurhW
1SzVmIRjz+FM4FxXcjYxzdF4iYmc9mYdG9/2eZLcZ/a5RSV14yw7oBnIrjAd
XaKG6dacFe3s3JvfH4XcfsWYwM76wm5N2eM3XgP3+M0nLiXW2MkPywl4ZOoe
H8Km1hgI8T1zVyMG8szVlmjgPrJDh3DL3nSL9hyS7pXFurbu+KiiJz5zfgzh
kKej8/P2edIcnpv4Ti+G+A4JXNBs/RDjcoGehFXjO06us3XHWUQesY4zkj3i
eQ/0hda/a/yj09WerIJ/PD1ONG+cF8DTXvIE8zxRnJ/jjcXF/AmTzalUjFgf
XnCMh43N9+3OzO82O1hW4P31HqUGfoFlBrjZlwfpzVpa/IUzxIhteFcwy/hz
7Q558TrrEece0ioj1MDad7I+hDDIORDmBzzgUU2+zymqvB9YubZW+hfJes5U
xA8jD40c7+gqt5PFD5qVRWdVZU2FZZLk5saE3pyyTCrlCdfr5RbbR0ZjTI+H
PrFo/UN+sm5bbvPzlFo2wypm6VhlO5zhf9qRuExPhvPfYg4mfihB4drChia+
YFTBtCp24Kb3mR0I7/ftv6dIXvwMpaobkztcf4ts/XKFGU4Kz/cxweA4uUxM
1RM96tlvrSzS6Ip9OcW3nv3WnNCndhYtgvYM67C/bd2czZGYa89RzLOx+X2e
iBv76ofXix+eY2GhZ6hR5oMMQ5E/IIayC6RgaHmcGCSuOd+3zcYvSD2LlHle
sFRM0cFFfzNRTgCziTxhE9lswtCg3HErHqHvJ+rIJE/by8/bmZM84ccgened
ja8jyna2epzSxrxk2Dw8JLjBZ3E6uM0mjRNV8cPzJxafTZqz4Nr2GrFUz4Gn
JW9YirmJZu/GdDFSQ87+Wt6CJStk1MB5v6qwjne1QbXNVOdZNaxXXPfx31V1
5idrtjCTOUO+b0s7oMl4LKxXmwrJ+z1fVtkJFFxLzi5dPNPTih/qCR9rqqmU
XbgiczLHg0fr2aTQfeP0Z+KsgxiMwWxO+7wy8njMfhOPIpAX0ksJ39pkhWmu
1ryatFWIJfh6JpsYl0vfnhQLFH7+z3W0Mqf89mMwka53TkeM8Tpc8cnnl5NJ
Cc+UoiOt+1K2tKctw7uYvr96z/HkiR/YHvZ+aNH3sNlsmoV1ibeiQ9uqqVSR
bOV4gsYEZh6sm+vM6JDZPBG5Z29fnhHLOCYnwQFbsCd0Hg2x1J56mfMhDUsQ
d/Qd2t12hB6UvlUZEUsArc36YrUoJ5HDrw9emtxttgPfj9RxeJ4nyfmXhG7a
Enxe+oKEQnr8xDYsx5GrS70f1xu2Qqd9Tqb5ZhHrssoJP32qMb8roNrwFCKZ
ZtH41rz5FaVn3NaZuXDr4NnncVpiC7aFTU4v6+4CT5B9nP5lPT6tE3MyhmOY
CilnmALavlZ21p6RzBWlVUZMEZNUTuUJg9BPUnTVj79YLv2wP/36XfLCXy2R
ONIRJ9YnnoA3m//MpwFJNtvX8r2tKbI5041VPHECDP4KxXXc/OPw44zGiR0I
urD8wpqDjZfz5lmOANTUp0HpVMXGHOaMtMZURYsDcbdhHFiNXD13mb6KaaKw
D7yWr+AI1jqfSx8poZRzOKIe4V1vqM5kAOPA9MbP269S9/rPrjK7Dkbf5heV
ycuEfuocrjdPLjT76ZDWiaiXZTWIrUnMOYmd2ODZndRM8EBsdas+0IyfQDPY
7HdqHh67On/MbQQY4uSBLbJto7yjgZGc6nv8/HJ6a1ZNHdKTZ8HU88kpmQ3y
rZo6NaQ58z/m6NbnsFbVkjFV6yPV+SR9GGarX6Wf/+yrVbWAKQh5uD5/8+KS
4yfkORMtIZ8YpnyE+WyzDi3i+IhzK33e58yvqd28xdaV8zoJ87RsCfOpw43z
vPL0XAB8q3ygAfOcRk6Yr5FnxQl9lHOEOUjfLArCPOb2SynhBE0YzD8/afk7
g3nkfwjjlAkxg9V0RUwnvOn8nOLThbvJWTL/4bWmy6FHrn9uqZ/xXoA2vfPs
HfgpzMBKqWs0Wm/Hhuw0hPDKFrOfdJ40syAxZ5rHFjUgCTDy7FyDJEAe51fw
7HFCMq1oQjLm6EoRdOlnfHevRugOR3ULvHy8X5jPKagNvy1nwFF7sPeyU4ZN
U7qDYE96gcJy7UY7FZvnUvzdU1TijPhdTbdSV2anB+PE6bcPQVroNUOXyyZC
LU9C4Xcn5a4RuRqGokvMmMXJHcwcUcBoTTuxsmq/n4ZDuo2oDATDtMw0oL1b
bmmcFhI0LuV4tThZt3Ui7CBiKVIOMrGZomNctOei9afQcX22REK6fbbptaVH
9apJ16KgWXaNb7jE849T8otPK9PUyNF5ElL7rBaeiEbNuO1Orf2Z9yyJxkBA
uEm1O2bd6qd1x1zfvBxi03ZiYX0Vv+qx3nnTQWv79nj0wy4zSOlR+WOn8daw
ZxVgwj4yWFLOmQhfLnVBnGrciH2knWnn/QH4V1uNhGab7ptp+2ZhrTfOSVUP
udN51QanGz2va22iwJ52xVZ567pywmw7zhGVBjblg/kv4ADyIzMMOeOe0G9l
YPpxHoRoPFErKWM+g1XdcaYDNGIQOl6DUoGLzlA5jC5tDlISz5DgnJf6JMtW
DLofp7ZImU63ws/KSfufJ1lGVkhKFQqoqZwoWc5VpSv28Y3k87aHlBRaoNHX
01I6nScX0cCz0sqEhD6PwMEPlOKVL1KlGFPRTe4TKnlOK6UdzyRMWskzSCIL
atF6rz/UoxZ1woDZ/HIEKkprvS1KG1FZQhIwBlRI8ja1UhYYPwIk1c+q4Ztz
L8IS2etZfpoz7ONiNDDhW0cjWHfLEzvV5oMi3LPJaKvt0bTOkeuB3AFdniK9
6X02A6sfBQ4A+8d+VW0M7jVltGXZQ17x6bfLtOXC7OSSiKFYxlhuaVRQt2Gd
VGS5rThR3mKax9yPIWRntP5M5cMu+ZT6RDVkaYgnZOPUailsgfue7PitT6Dr
hwctxd4A8f5MuS6zwYRkzqmMXsbzny/vfp96MTUUv75X8xg8/9y8s1Vex0co
ZO0Codg+FZEnJWRkl+ebKwVSHsRpp/ihbDCrM05b5em/ccIIDYgGtHikvPJ/
nIkVgyhrixikb5VEtCmg5Rg1kzLiDc4TocWiNj0TedCinDhh+q9fKY99jk28
6W27Xj/k+alqTCxrUS8hlef8EVLw28zftjnq39Zh1kkvSV9ewXwr/F7ACFRI
XGQOjTCKU07Ngq3PNmfKJqizH6fx6eULamGcYtfdUNtdavM1fOk8f53nAgJu
oDL8w18fX65Iuz7iEhZDDOht+I2cF9RjyQr00pXnlcw2oRd5NHtunlxVnM/j
TpttZ37jtFnDITZlGQjCLqePE3ZxBgSPkm7ALk+TJezAufSXpXmabD5z0ROR
wZCsRQaooNRZjg6RA9Pqx0kBUeVFyN0w3swxaDv9syvI0cF9wph8/DnF0ud5
pbhFRNJJg4RY2nHEbMZvrJ5NdtpJTZQts9FzUO7bC5+HarUBIc4J178SQtQa
rJndXZ2p1Tozuhs5PGH1AeFT1/QyQ0/4ZJd+RPqNJmizAT5n/Zw8/rnyxHU8
GbNAaWpG06zwhyjGDEqgL4gyvMc/vMBbQikrH0ILWMWIVetHhQl3BA1qmS9C
KbxxO5WYUPr1gkTAB1CCTY4XcOw5Od+gSZ0AsmJugOaJPSMjXqSrOKkCPzwf
lVK9He9mJkMxTvi1JlJXsrvAbxngBwb8+Js0UK+I+5zWoQCGgOBbNsklv6/Q
L5pZvSZwJ+6HF48zHvFs6+JyP+1r8zii0oP8B9uMcSUeP9kpo7o6L3C4wYsB
oCD4adARkjqNmDEHiLI4bZgZstCP5ksVyA2i60mKX8OitTy/erbus8haIO4w
o4Bd506TcwE9yHf8FXbH7cUQn3tAIyGz9yiL3viHyoln+50bOXpAadvtWo7m
2dVvNGsbsrfHTvmNiGjoRkaLQFqQ8wa7FxlePmU17YUm+tE5JqVDH8wZZ0DV
kYvjTuDaIGvNqyLv0brINeY5vYQWBJf53dxjyvOlzqt07664tByXRp9kfr98
6MNau8hkvE2dTllPKxVKe8MeFff4beejRWewxdtkV0OW5XxPcmlkBKAmNb5G
iL24QAiERU0pXu9v8e7WeUyteFJD2pMb+i26aldSGuc0c2qVh0VrhhlQMOpX
3me9qYxKgEl3f8gE4NPKN+kdxOkf/TiBXbyi2jo8o3ZvuMUli8u0yG+B//TU
nRpakQuTMiMTPMxdtE+Ag7NtuTByInAYkj/lVLdFW3EypPFLgdgAWu0md4BB
VzC5dL524YWlhBZPaeEZYQAYpNdrymlgei7i2U6vjVOIaOfkOTF5yo1NRTuo
n6c8S2u/Lc9CD3DCLCSXnuZdwUy1pcULhprXsvzZ7pizcWziXStLmHEOvufs
eJCaybM8Z6lI/x7tMuhMlvRznQYv1rMAijBiYfCzW4/l/gavdt1Q1lfV9VgK
H+vsaNljbRmW1fcFb/0481ZKYhzAIcR+W38vifhrAeizeJ4qg+b4vaisPy4n
3q5pzOzjwOFnlVIFXl1AClIIjgDUJONN0ctpvWrcefr8ZzteLNvE5+Q52WaZ
xjlTfI9F7qorcduyC2Cy+gFSVlTTMnHW+WLCqc/0GhdJLyiyNGbtntx6Rlj5
dZ1kHxzHukjOHQBoRls0pxKnDBpRb4nuZKfdJVLg0TiThl2pca4LD0x/hIq+
tlTKEz9DKjHuaVqPcPgd4yjLWvFwm6wubUjw9onlUHh1VVIP2+ZEWhjvShfU
znnaYZG6o/XMG0abSREQN52nO+U1TtCauMHPU7SZifcpVJR3hhaliJQE5meE
JiLvsF+JZicVWg2LqN1iwOG4ii3CIvODVncUZz6SQrKrlLom+5pNfk6pxFUv
5Im+Z8hshRr9uawFCK6YqyaAWBWNngEyBPCUiDlUxqlOvVbrz/3WkVSmGKr9
jkbspHZC2DRk8CNlaWcC95oTDvg+I65Pbe31pwpEod0hSbAd/NYTiKin696X
aj6xYhc2Z565nVNNCPmFYrIuOF2rLUtPVIqrBSO32l2fsQ5+yjmzBs+Qp7xr
VtzZCV9+urTtEcLcKp/be/zJghRGw5jaZKZNcUkpkJZzVAKYRPNs5hGDL+Gd
mTbiD8oOsp6I4X44R70U1vfoSIpaG5oaSt7ddqjaX/ZVjvgz7cSTgdOXSV3u
P/X9ovutbEw+L7l8pPV9q3OKjK5lE2XOYpwW1fdT8EwfRrrQaoHqc9sptWsY
MIAjRX6BHjzC2DrzOE8nHxhdak0tLPlxuUEjbDbLfo93ujzGsWd6rg2J0m5z
nGUffXkW045zuqWc3wNAty08QiBOtDedMiU3wzoEzUJWwf6GuBpyyICbF6LO
hClvffnFCiIRg2lIsfljzjsRvbL5M4wuchIoB7HjAzCFZXvCOiH2Umf/zKIw
yW6YyD2bLdF3mELCQ83ZuiA67dRPVkXkXJzw4OrppUsBG5g1NALxG+ABqKC4
gHsAbD5O22ZwqgWbPjNNbKSBxAvIrovumbaMD70CgCmf+ryY2xpVhcxEqV7i
pHW8B59DkuFFt8Ulbbg9qbxnRWjC6SJZ3zhbMs91bmu+kCQs/De4ZUxqyD5f
ADHEyXNdbB2eyqRWPixwhSyyTIidJyZjWEMBytutNeiET/BX5KANa0MOL1CQ
rqbr/AdmU/hxN1mRzloXcMeaa9RMxj+8ANQI59Sli0Mtz7qtK7Gihn8Q1Crl
JGI7T5aU1pZDcZKj1+/Ku21yjGWXSyRFX36pgk9Mt2eLh9HH2PcaVuRgr+zn
QVMAwTa502DTX5SWsj9j4LTFBIvLtphHw2dB6pg8LjqjC4CACSF7wGpnLAq1
9Kv5hHbnS9v+z7pdQq4lvwZ1/dqC9nM+CZxp1gytrDbUItYCGgRh2XOhtoyq
GOObPqKBl86DQqPcYjgwx3lyHrSaQtG69uQBk/BtjrSuzehniv6mxqn3zK4F
tjWyeonWL00BnGA8wPL0FixpvaW2o8bPCrqIBjXeR51LyjvLIhRY9sP/kNLX
C8nGnHVmJWo4hjxj8Tr3vgxAi4HCkPvQrmsestndTBZBOIy1nh417GbLhm9q
tGhTCsLz4G5SatGCa9epJlTHFoVeZnYi3g+A4U8gQcaz2x3ki9tN883KcT21
hp6v8S4gZHmvwmidEuZL2cZgsmlf3AvgGv++0iJEyRaX4ASdalB2VoCPLU7b
ho1NItqnXptSYH9RioOhaPn/kYrr8kTa1JRt2K30z806KXvs4hXEHf4Edo4V
mSVLWmt5R4OQ4uIRKbUtyLdwFSyTU0OslnZqcZJKoDohPLUmzyRaeF30StKL
4PXZUWy66bBPeggPpxGPSCoacZ5q9PKkx3RaC1InOKTApgC2ZcvhmJsuNXkW
ZwPyfWRajSc3VvKNdUHkSXpUbRhFnI8hUVsDjBgQU1IPzIm6e2QAF4/TTaT0
H4FYAAXjirrKghqRcEj7s9eimDYcGAfAd0F0gB6u0opLrgyWhkUquHvoX8vj
8D2ErcW7j5dQrOpZZljeNyZrlMe+ktBIL4wSCgTGp4LwzEshjWTWg7VHoF3Y
y1A72LxCYkkLUxHZa/ReEwKK6dBsRhnMtYBHjOeGWxBijR9PjaRLi3txyJlx
BD6z2KvV7+7zfC/fxxxlg1PIpOAuUk1qRMLpJSK1L2d2FqGUuf02J9lZSgfV
gdZY7NLWmgif7PsgfNKXJXwynnyi0e4kBAj+BMBmPXsLSlWUuR1P9bp0z3BZ
RutLGo9VC4bfb9v8sCesrouQmzyUcomDovg90NZKebZGg2cryIUHuEUuAWsa
j2dNyaktfqOFn5F97iH7A0kZIBOTxtTrmYli7AF7ZCof76Cv8LoNq6VGFW5L
ERaZeSRFt+diMF0DcEEaaJ5rqfOkrTZ40qKShFj4/CQgSB7TAPIVaDitdbS+
oJKW0Jc1BMNjZPOBQTD98jaHnuxY3FDPyk79VVOF8uKS1s6Xta5nrio7zP18
qTZ3J92NOI7qfrMBx8nwBzqFasY7pEIXskYEFjnIDmIeroldIQ+YP1D224/c
YQQNaR9skDeCWWG+4jfIEfpwCDAeAmj/OWHa8DRZD0COzhl2bY4+2Tna7NZh
pzOQCCQ3DU3QKKGXUZil/r7OyXZTEnYa8A4IVL4SoRnThgx/WX0buVfzQ3h9
qypigJ2cL7c8Tj5C98BOJxgxupuucxr96Wp6DV2AYafP+nyo3qx8Fey9Rs4F
oLVO538UCL+0fMbmW3GVbFQbp1UZfNPCJXyzDpBwguoDFOhDWXWoz501ugXJ
2fs6n9sJuCaVUqamDRwRDwb2M19m+jVm2Vk+KKL9ll/rOqU+Uz4Of+cN8n9H
rSI8SGzLvpHete5Zq8uZwa4rxmGowCr5ZsBP+17LA8LwO2FRrudc94Rf2mYn
++7M5hhtvY9aAYrE6IrxCP+IX88gsu2lHf3OXjJ+3uqqHY7MrWXtwcXr5CY2
yL9SbgVQInMLmOkMMn4vve6yzyVRQivaJPwkVmdS4eyVbybc9PycGcYBpHSC
A8KEXEZcTnWsNDg78Uo6g0CHtNoxW+lm47/gR7N6B053DUimNCTkM4vZbWGC
EIAOsZjLwDnBrHBKGqwM/gpTDdNyP6DIyTGn+Yj/zDaBqXCF3Zc1q059hbdX
OW9zhKDHU9zuITRfVq6OqBMcsJoOo9/+Efg4ZL1VScAshErHn0AtejRtdChb
Z96g9d5PAW//ndK0XXeSdhP3kr7eiOOWKtqkCiPJrJ/nlI5R+eBHGHPhrBrS
I6gQF0Gz4rVOQmTdeh1PYRWKZS5kjc2EqSEIL2TSz+9gPwktaEZHIVohBubi
nJiYP/MI/J3VLKQywLUxHST5bdip1CDVb0EuKvHMRxlpXb/UqZQhk+Ms1uEW
lbLaHfoRkIb5CMaBIHrJl9WltVOw+3LVU+Tv4lk90CR0ET6H3aKV3fSKIN14
JJbpmJgNQMet8z8TtoOYXyrFDKBpZT2mgCkwA/IG0Kd0RMYlq+UZkBuWo3Uu
SD0/JtdmxKIVAa3kXHtmR1SoGYXa1N6wnuK08kZNA643rUN7FXoecIWewz/G
s2wa1kOKb9U+jCIAvmCin//cPT+x8LFBgSpsTavmLvmfJVtdQ0hx6jj/UXzU
SQW9qtrYej9lHg7xKjkLBhF4HZJzIaIdTFZk/D5mgBv8ctbwyS14RfckpZfP
/4gqizYHR3SFJlSeosHCLLtf0im18JbPqXzBI8EgesUQruaTsheb9oD2J3E+
T7/A72fkutOI+RKN7cK7WfuQliODBPtOkSsrisyKY1b4AYCE6svL1YCzRR0C
cjatsW8c/V6fIUYOjtpnQjKrpUmJWb3fb1GeRXOmmnMtEnIhAUxvkYKopFj/
UM+FiKqlPqQjGBjSEjzMxnHz70JDUgfwJLScdDQiV79By0luY134gN0u6w9o
7ob9R7BeDP+5a3J5TFWyqvj7KojmlGLyStSWigdMGYFLr4vyBTytbVEF2dmV
ltU0YaGYtztocRz1LqADeILYQFEwNH2yWA/AATQ6l+m3o+LBKmvYO/udkOrg
6Ib32o6TMLqk52uT2jOHEF22jamPeM+wj1XgZ06ZFXULpRQegNlt5xZpJdz4
9/OKfpnueAYrLdiHW0Oc8Vit+nWb23oWbL1Z80SahalmOeyBSRLVnjTgwFlY
rp5DvnikH8Y2iEwhaFPCIwJPXQ0oQmmxarNAfhQfQ+3QEsJrYNPG08a8Adpa
ntcfijh1+kz1+8gLVrzGvoowVWnPgy8J710POzRtqqZnQvAPuAD4GS3YLXtY
z8pD4DuljKHzCu4zfClSNdN/pGr2Mbg+PMLBsXk+t9l37f6AXkVLWo0UfiJE
hubVbA7Xt73+b5nzQ52v6qYFb33QPfpgkCOgaYAyJxDWk1kqORsa06ZYsapU
vU3ZDhkBsmUH0pikdNWuUJsLdkyovizLFF2hW2TbJrm0AcOcj0EY1l2htHP5
jKxxDBu54W0AxmzZsRmg4ERsD2AAZPACwFvmtGu0aadVFK02H1KN3mt0M6tk
heBQWdz2hsgLGcvl+8wa86QNmCQwANN/HHNeNh/wBOflukgTDhBhtIFrjky7
x4HNJkheNk1+ml3v1cDhzdK4d/kZuXc7meqgwgTLBkktb1HYEt+VaaygUD3O
Ez+W/Tms71WvxNSLRmYG9zauLbZFl4YGiB6kX9OQamiPk5q84njdzrcqePBP
avWQZqJfRrxvu9wT2usIaGSzau85IAHyVmFAGRW9nw6zkGncQXbqDhzvlW84
BBpY4n+fqGdrZeyBcjU1Gp+TOXDuM+qZjTe4zwt47ziZg3w0qdU0F3TkzLVy
vtbxMibHeg3uHvAbYw6EQ6MAgU3yBSAfwjvPdk78n+bYNmyF/jRLL3wv7F3j
UqMV9jMm3vJzK93I+0FcAAOaSV7mzzf7iLiP+R/GDXVNFoQDuIFQeWVhAbi4
HPAHjbdZ3gNKgGkB/sBbtpgDTNT79cQq1p+sWhT3qa/aVUrhYTVOuUh7Lajf
qurCg6NGs1ooKFZwP7Y8pmP37rZvZUWHYSH8GaWMmFxqM4W+XSDwu+V+PBsA
/wAKnbXm3YwHaQaYfRB9Bfhhrzh3zxMo87nUNmnXpzYJv4fM4XUAQS3kPrwC
AGFFhSFFCwIkF4MzQXt0LzrtSDApIPOZIQ9Z4yB6nrmeN8T9v7Z8GvxfxMNe
WEEW94uIxpMNItphrHQ/5jszu9H6p/aZaki7mqSNP7Ut9RMd041KUUiwxpz9
7Bw3S0luauA4PeOCY+DHKvgKletLUvoflX1G9Zl40ipqg1bX55/RloH5AsNF
7/04X5vVkFAagivD5mJNqFqry3znUs4iAaZJBZl7oL3EXrPMi6WO4fX0JBKj
KefIi9MyDaO/I0PAKyvuaHexf5G8Tlvg/goCkY8SLz+0idBhLRe4j2DXLCcA
KKYO62c8evGMFh1Qu0ELQCkENfaw1xV/qeQLLleYMJcbeSaboW8TkL5h5VPW
+5kYdk/ziOna6DFu2PkZPS+4HGX9MJ0h0DJAAyvS/HbP+swCQlpXZhWu8o4t
rOggTxS3qh+xv8ileFWalaZkBRD0LMDkNRVF6mhlge5nCBRTeEF1J7aGrQBS
67WovdTmlT0sqavMQSSMCuIFmekMpwfj8JEKLuoFmb9UJILCyeirVU2H/UKr
abTC69vmYBdiZ50hLWcaxGmbZcvew3J/BRF6QKQdWqDUl6w+IbfgkevKkavu
2Ucl+um+yhXyIaWcmFBpcmzYKQnv065rVaJ3ITwAGtAXBAe5MnXPqK3yCIRG
qAfckPCDRKy96+HoeDWbbU7r+2/GvwWPM2U9CaHAIxsid2sMSG4FPcBQ0pOx
R50qWb1k+876s4Hvm+WsbgWH3Fu0HqQL34Ychi8y0pA2h+fK3CZwHm1EaKoY
ywm2/3PNBq5216dTxkczprDCqdok5Om+foBY8cj9ZLaMeM9O81Nb+6GOA93i
+2QFsDOE4fIWNn+6AGtbNWk+6/S4g6xu/E7ZQSl87IVtzw37uV9Rr3y64dbP
+zBPLSrOY04PlqV0qM8qkxV7DMnaNvBzgmN2oq4tBx5AeeqbemWB46mMi2nU
orBek5owfZJqN9mBF5tv4+OMFvxNKkWMfNT3Z/RXqGUJ6Q+bUILpdHA5IG/z
EzyXnXZN12HCi5J32VbOnTVqs9q4gjK2WUXlUOHOGwroIztAQPiM1YeauKKM
0GjVkDrMOqvD9rakWodqBOretBks9tHFGq1+1TOgxG9WtIK/gDXF94jzo8Fr
UaxBcjIOAJm4Ta6BRYV/2rHsOkstR+38fiB3249zHlu4xGZtam+RaHq+41pV
YntApMudWhvTR1Ka1BE2KWXwzC108rxP48OB04VVRNR5WOXj0hcH6alhSZhU
kB0QlxDtI77GdVWsbFDHG4FC8KGe8VEytHoOAIhZ7WifS3PQZsh/t4JGBIqD
VRmhhJ4CKcCLwx/zlKbscXtqa19cH62lqHZvnFWuAU/3q7MiJM7fs7q5nnGh
W2HULtRtGqMdmlKVD5gAMtM5od0nGRlcWBnA587LPpub4DM/PgXQ6DSYgJPN
3SZc/risHKBjrFxKrhY3tB5VrTO9QGtd6MngTaN7ICuRCSHWHCtEaNMCxxS0
ZAxbbw0nvbbTUT4addqw+ULBZ5AZqqu7LSp8nMOCTedeJXBUYQeIOWyjY4H+
VD33BlABeMpKu3A6g6EeTMgM8PfIYmPfVnXm8u69NPPs2fTh0+ajn6ARtaf5
2q1+q9+ipxIdVXFf/o4XlikmneWcoNqqw185goSiqaOzUrSmgX4bGArki62D
mEDEsKtj5lhz2ohcA8e7DHXsXFQege1OO5cxE4WLsW9YbUC/Slefb7a9EYvO
aNhTHXNsGfNMg3zBqD480s06sdszcSlvaH1gyyGROAdmJiqLybXgCKC386By
Q1BAVnOE21HtrpqDVGeF5rwuYxD5j3IDt2aeZtxwCHiZip4c7BC0qDuo/S+a
WNwztZdScykoqvwGHgFSx0gYOjpa1von5eqcNma1sX71cRB/mt3twBrtFv0E
rVBAu/aBMn447JxmsVeuLaUtY+7RTwYI0lGv15ZwPJH0Jm+OKRCEm3Yi0DoG
TxJP+Le+OLcsRoP+g2pQ3V72lx4Jl8oGb0CY0bfVzlMsWbRVcgIb8ycAH4B4
rKzyjYR3TDY9wb7tFoJ1bBz2+dymqQ4Z17j96i4oYTTaklw0VgBn1ennOE5s
/llAkfGboMZ6fRA2QLLmdxjvxntwY0fOxD9cDZlMXGWPjXmPJS9RiK78WihD
Q5nxCI8QO1OP8OnObVx255kOR6Nt3gFMAAmPf2AIw5rMrtLKPN1N+KVY+ZuM
W7VOSqO3ZYWj2APAT+1C/Yq9jKvDtjM7qxqwZ1ZyW0xCZAZR35s8CHo8e9Ed
JPVbVaO8HoKKm8DCIbfmvLqqT7FdY4F7YbE81ggsUPxPyMW4AGSEKxnbiOp1
cZORz8OzQcwgxonSN8KwlZ/dELMb2r3N/64Ffa/nu7Bx2twO+TC2AEFkea2Y
f9rAxY+VPZSv9WD5AP5gSXys9DSwNR6MgumEf1AIaEjXbHNNj+lmUtq1e5R3
FIsR/7C5mfhWUmK7G4ynleB5wATgjy1hBSAqKBHsxWnAK5VzP+X040b1GO/5
WMe6+faLdxnjQ+g68DXkrIaK92tI0uf5HtX3C7HWiFqZPgGJaGu/DBnsnfe8
HivXyFa6qBImaLG3mL1snViL9cMObfJOGXIt/vnpvM2o0jC7sUUibtmA1lC1
EopoFoixG8r7eRYYX8iIgXlwy30FeOJ8RBvbHXBRYZ6RlbWUKotWD6hFZGf0
0MsAQ1Ww44ovKbeLT0Q1ptpklDpb5BLIc5hRIJkxOQNL77Y4in1neOyKfbqZ
kX3qPGARi/edsdpQVzziEAAN7AoJzww9qCa04pxxCbOw02qivKccMvcVUlHm
rfQxw7mnQS1ccAdQUVhLGunBpkDGeDFk99nL9it/8jGXCeU5o/QCsDeeHr1Q
smKg7cgLHbfXpJ/Qu7geJihwBmABZKxArjvFsWaQMVjN/AO8gtRWr9JnC5xv
pzDlbv+i3CXyWlLmvWMvGefDrkC8ujfP6y6wfMz2mnFli3wctSKJpFPb6eId
OgAJAENZpC4StXvq3mWOe3wYOq7id+9+u8Ay/8Q1bX3Kfs8E+ClFettu7r6a
T8cqN+wV+AbvYZM8Z5QKaOBUhScHValXYtTc85WaxBi0dsLpaPh8cwklgnAX
7cgZ4TwqAAU7ZuXURFHdIduNC0rmtnG+CGOLhUpHsCtqcQABhhP2zkycXleu
6Lyz3C/nF3r9+SwMZ2yaNz7uhM12FLvrWDbrarQFlYLlUdYqUcasLa2GZIVO
RIto5egdrCf4kNONZby/7xFRYhgUChEF9YNFcnJE7Tsz7sVsArgcgAH1Q/1r
X4h+XnDTubTFF48xSrmgPo1uhNwLuYLn07LGDoAGrmu+6FpdNykV120s6LJ1
QnOZ9Raxo6O+077Dbt330xeqYt6RT4Yco67FBqlKYhLyAnMRRU7dDzp2nXJK
tUPapirn2KvP6i8IC4BpUVnZWyjDK7FPOt1evx029hLfq1kMwev4vKpCCO05
0tppv+KV+bCdgEFOOog6aw2RA83WMx+YkTLbxai5RIjLUXW1lhrYHfQcdz23
gjKRVBD1mcNRd1gqA9XnJv1mtN8qNB6uqw3qaUGjvjMShcc6j+p7xXHsxOZY
hBSFdtUeDnoL2GNMXI24NKuVOu8Sk3BWA+k++KUWIzR+kWvWqaDwneWJ1qwW
h5rQ4I8MQRVrACjsFou5MHayecFozyJ3WS8e5+sYbjkDXS2yoYJAfL6m3jHl
JDSjU7W8lykTo2pYBxCr9ElSArd2DW/oIDZOOW5+ngb8n6OVGbSLI8siJV9H
P8f0LjU1oOwMouXhfKpPtzum+5/xUw1GY/9SXJrVxSUAA6RcAkDwp/RtWKeW
E3pAA2qCeN0a3nYdH9afTc4lbWO5+ACIgSKvogFxDkLC43Lj94Og7xVyDgh5
TNbgt0o02gj4yhafvcLTkwl5QKWhwWkbJwwoj0qM0t9D2KotG94ct9MZ0l8j
EORM92rYknGSIu2tCvmI25WskWGekEoU2tT0e2aTKBMZu1Fqceq5H1h2WVZs
pM67bTffhDrT6HD0udu0T8/GmkUUefCbLVs7cI63WFf0vutWywaxM+CafppO
hHpoT+fh8zqHn9c58N7Ogwtl9zoTD4Rx6UH55aKX/7mo8zuPStrTzIDTisBS
sADWTtGs8h7J2dp+GcDe1wB4iRYAr5BVIa2rzE7CYtKlG2RA8jwewtnWUbO6
AHeTadtRkxrmfVoeBx+ceeS3Ood/pXNge+f713UOXdg58ozO92Z1q51yGFan
390nw/sMQhMlpu/xaNW3aSnivXG853cWTFcxs844P+QUgwpALrjYcDdiuNlp
9VW60+IFlPNLO0txJbvwi7RYYBcCfoO0IM+wK6OjlHqmnWUe2//Nh7WeumAP
WzvyrM7+GVVSD6opzVpqbAqibD41WakyVfz4CeEzuHVIs0E9RXxOJ/Ceq7vw
aU6qc/RsE88NOZb06jNyV5XlSVsBVIG7gmbwID+P4rPQV2BzEEFUmA2nR8I5
24xmY43YTE/32e3sm19y5FewR4jpOJvJ4v21VJjxLrRBPfOb+adpj+fi/vvw
fCwEW/U8+y1YVDmHHT/F4+xc2dptWdsIKRt/AkCwGxpmEFXDzp2mF5lliJ1w
fqNRIOTL1pId1y13Olh6nAhuvL2k2pP6+6RIANMkHfkjzyQYtT3vhIE8rpbV
e4AILNJ3VLJZnavsLttMGntu95u4UmedWmVOnMvYzpRTp8SeVC4fUprb4DSX
OsVqK4ibnOUxZDL0fiwCAMdztJ6MM0+Y0QEhsLAML8ANMTjtV+Vlz5GXLzM5
cBBwxyYtG/CEsrurXbpYf3RQL9MGkfG7xnbP3eFhoJPMG1GPKR1RkrGIHauE
nqKNFvJJjQlczq1aZV/L1sb3gBF8FS+AKhI+dsPI5ox68BbZ5NNfKm+AxNws
7y5YO7vaV1gOxlt4v0XPcjsX6DMbzysxbOXQTpAlgCGNhHpCyjA5AN+mHTkK
RGRIn+fEFj0T9o3yKIdQdmqOmYsaczpkqsfIw/9JLsdOXiR/SOloe7nGpM07
oBTwTKwBLyAMUzvgVV19qtEJCBBsARTkefdv0vWz+DAklVmOnsWjbABa8TUm
CVVTx7rNrnRJ+BX7dt84ViGDpXflKa6vS5y6U8ZzdvF0wH1Sk8T3LzfIqJ8S
O7f1xR0V1prk9IrvLtaCdQGS3o9ulRvKqy7LvsnBzGZz0N+hNi2LE2EbeGdP
6/vB0XiirmjEV6D1tVjRaHV//bzAfMAVAg0M0wFEJ8pqPVTtzAIvCtGKIj9Z
QVLv3asgGXdlrrBog4GvwuCy3OUQkP+T8svaG3Rm6Y2snkSYf8qfxEE/YQck
7UdlJTcFRvf8sO5Jn+b5lYPEqz2NpQfNp5UCmAH3wdQ0LFMQq+6RPjl5gxoS
jIMP3O/aabPtT6ggrA/qlaexrKP5tH9wqGFjSo+tTBMDHiPaanculoHF47He
VfVZHYYbd48xuBVl/HfHgX3i+umzdsLhCQ6lcbWrz9JOtzPLPn7onU5znFg+
aKh8k22C/s1zFv0mTxZSgVNImXJYfnbRa1nHw3J0j3L8oCspBfz5eaVe+DjH
SbW3Zyx6L/217t8++bdP/l9/Yin3/6e9a9lxI1mudFUWq9mkKN3phyyx1c3W
XMCGAAPzuBhIMgwIxt3YA4ztjf0N9h9oZ28MX3gWXgjWll9j+HO08rbMqopg
RZ08ycwii3rMXEFQKjIj4x2RkVXsZvV3n5FMf1z51Cv/Cyv4xPwQzP+p2mhz
ezF0ZSKf5dEPyf3UzNWv8nqf8vFoxDHSJf5Y1q7kz/NfIVRfjLYnc9b2Wu3X
h9f/PZf5tYyvYf0ysj4H+Ing/bDjug8b4TXAL4XaVQTvVUCrFcz/rpHqv6u6
D6iyOiILGbddYNamTLNRMNqgbWbqviYrzA6k4OnldrBIk8noAHsGVJ3gTQFv
ZfBUmlzwciJFAXzPDuR7A+tO9mUyoj7o1Qd9axBJWr+8h1nUB2Hn0c35TGE9
sXNrCbN2zXDJItplHs8iZQeViVlfvWuic/t3uZeGo6tIWeOi9DSYfaYacL4s
/moaC0OLyXVE1OVdvAyRlNKO6nNOJGD6hPKRy4I+vQjsPg/qt70jNudJLQvK
OI4s3D7MHhhvFr6uuvrH6m96HGjV02rIPexILXYyH6uVoRxKy0DE4pn3CLBm
lBbnsKy4v8eUj1cG3IuWRFg7keHZH6k/CefLmNl/qvMGsW4Bbt+PiyV6/Pzz
/LDzArFWFGsBWGgftOrKky6t29DT0PZ8ts+zNV+7Ku5j7Axz4qOAF5N7xsMs
fAdwCbDNEbW9lSKL2H5Mv+NNhZ4key16Dxit3995eEiJcu7tQA0wRofn6JiW
w9psedfrl7B+Si8OOVuohxM9WjfzejbV+tbbVgJrTbeZjf7QG+O86t+tFL4V
eFF1+cxuplkinXnVdRG7boKcQ1bmu8rerdVyz4+C5LnARmN+07fHRu79m9ew
fgnr38P6HGA5jTd/teO6DxvhNcDyXGBzFcH7LqDVCub/spFKngtspHZvpJeT
1+3Nb/USDPHKRn+/WmF2IAVPL7eDRRqJmY0D7BlQlU5mMwW8lcFTOoXQLQjd
AvieHcj3BtZdgB96U/sHhX0JWn+8h1m0JsLOo5vzmcJ6YOfOEmbtmuGSVfu1
06rV8SxSdlCZmNWlZ7ZRuf273EvD0VXOV72pTwU6PbTL+9z0YPFWYy/MLibB
EVGWd/ExxLaUdlSf88qXgOkTyncuC3rvIrAb8XD9oUiDUo4jDbcQ8kJLyI1/
Izd+T4Z0z2sd1TrHfeomfq2XG3/UnqH8SMsuxOJZ9ShCG2WUTsrz6Zgy8UyP
SaZ9xPCcjtTBhFNizJw+1amBWLcRKijXwpPjsKqPWCuKtQAstKXe5Yd2CtrZ
2D7N9ma2fmsnxD2L3VxOPBPwXXKfd5hF7yJU2ClipcA+hvaqI/kZbxfI27fg
PWC0fn7n4SEl5OT3hCgxxuDwTBzTUjM6yyleAsVTepDLRc/2RD+Wcgbo/ane
Jjf23U3G5i96QeN5bmjkBr41sJ7e9XhNZB5Kh50tVta7yt521WKfx00d10M3
9f4b/NTYXwOcelN/VXGt8Kbee4P/i7ip64nCTpZT39SVb6xyxG/s/WfqoYr0
xxt7uCfX3WVYX1K1vpxbOrutHnJrPyLSTNf3S7u1Y8T6GYtaqJ0/5b29xpoS
XrH7e3oM/DLv7+ciG6f5+dzew08Yh9zpw97+dd7pnwHMe3PtCZaeFB/zRu/b
AK0Wv+Nz//8a7vhpnua0tL5/bvd9ljnxe2P/3X2H9+Xe/4/x7ed18z/Wox/j
SYB2ltoH1OOxTwKmRsbUJwKjv7vffcvA9j/WHltwLeNrWL+E9e9hfQ7wE8Gz
7+7D2AivAX4p1K4ieN8FtFrBvHl3v51s6riMbjs2gVkjN/g1RrPUzkxqeoXZ
gRQ8vdwOFmkyGR1gz4CqE7wp4K0MnkqTC15OpCiA79mBfG9g3ck+1AO9+QCs
4Etgn8h3s6gHws6jm/OZwnpA3TkpYdauGS5ZRLvM41mk7KAyMaurV21U/p/8
BsK+bXYx5dFGmhoJpSf77CPIvtxLg2vAYqzGXphdTIIjIkth5e7JFLaFRzuq
zzmRgOnT3LRJznFZ0HsXshsjFE+DadWeELUEKNk4EnCrIC/U/rrqKhiroOne
LqQeaj3jfnSkmjqZj1W9UE6kZRRipVUBv9Ki9JovaOkxpeL5jXvRftoxDM/k
cNXwazOPuzEz+VTnA2I9I1R2lujx86PisCqPWCuKtWBWw10HdAN6ZtlezPZf
tl5rt8N9ih1bTnwS8FpyLzeOT7Eu93oRsbWVAnsV2o+O5Oe9slEL3gOGfT9v
8ZAScvIjHCXGGByeg+P4b0Z3YXdxCbtO6bUEiQb6rpSKrzeRettKYK3ONmfR
8npHm1f924zCt1XX6ekth90FswQ6Cu9OfXKSWFnvKnuLVYONcQN/q1H9tm+H
t3LDfqs38N36ZWR9DvATwbPv5MPYCK8BfinUriJ4rwJarWDevJPfTrbV+K30
XG+ln9giN/g1RuuVZmZS0yvMDqTg6eV2sEiTyegAewZUneBNAe8G1p3ApZHG
4hfA92xEvoVYg/FFrz4Aa/iS2Ofm3SzSRdh5dHM+U1hPqFu3ZuvP2jXDJYto
l3k8i5QdVCZm/alY2UbnW+12AzRKoIESZRavJ/vsk8vOaMT8kcnvHdXoZHSO
iDGF3+7u5CB72CoebQ8Lq8E5kYDp096I/WrCZUE/XlSmcnnYeEpMq7dyM3/r
yXdKOVj0TQmv66qrcKzCpvu+kHqp9Y571ZGq52QeeaMOoThPyzTEGpJh5yIh
p7ysuH9PL1caB7SrdhrD830XITyPE86PMfP9VOcJYq0o1iysSU8G/ww/7KRI
k4rlTJ87WnHlYaT1GHoS2k7Pdne29msvxe2F/WBOPBfwbXKneHrP43mnp2pm
xn019JRRQM/ivda9Bwz7bt7ioVZ4/vmdJsq2iMoSy+KP79tLoPWl+rJu5PX0
ap8FvJVnAW939d7mN3pCb4tzQyM38K2B63Fa8VtpNoCOdt8qIzujrMx3lb1X
q2FHeCYw+bmST6L8XFl7bMG1jN/D+iWsv4b1OcBPBK/3E/VBbITXAH8r1K4i
eK8CWq1g3v5E/c9V++mqdnTbsQ3Mn6sWv8Zo3dXMTGp6hdmBFDy93A4WaTIZ
HWDPgKoTvCngrQyeSpPLaPEK4Hd2IL8bWHeyT/lSrQ38oG8FIknv5+R2s0gX
YefRzflMYT2wc2cJs3bNcMki2mUeT/QD3UFlYtafipVNVG7/PiK22cWUR1s9
V3qyzj6CrMu9NLjESJl5od69MFSYREdEVt7FBJcxbBuPNvUIViqUgOnT3LxJ
7eCyoDcvqi5zsRL4u5ciA8o2jgzcLsirxpoSXtdVV9NYLU33eyEVUisc96gj
dc7JPPJGjUPZkpZriJVWD4Z5dExJeLancUBLahcxPLvDlcWv1zwSx8zuU50Z
iPUM4DoKnPpkhLqPWCuKtYhqi/ZZeRhpHYJ2NrY/sz2ZreHaCXGfYhfH+qmA
15L7u/F8amHN6cyM+2remJ7GW4TlzfLAt+A9YPR+kt7goVbI2e8FUYN4VMZy
cBz/Ye3FO80p/cVPBdrtHOi1UqqN3kvqbSuBtS7bbEWb641tXvXvNgrfVt39
tZ5H62UJ+xWux6mRjZ0hVta7yt5p1YIj3Md/msh9/Cddbe2wBdcyfg/rl7D+
GtbnAD8RPHsfD2MjvAb4W6F2FcF7FdBqBfPmPr6dbOqwjG47NgG5HVv8GqPx
SjszqekVZgdS8PRyO1ikyWR0gD0Dqk7wpoB3A+ulkcLiFcDvbCR+TvZlMqIe
6M0HfSsQSexp282iPgg7j27OZwrrAXXnpIRZu2a4ZBHtMo9nkbKDysSs33S9
/ajc/l3upYH21QgoPVlnn1xWpME5shirdy+qLiYZtfo72TL9jurDIizvYsNR
2cI28mhH9TonEoSsxHKPy4JevahMvfKw65iY/tSeETVvlOmUvBEbrYh2uK66
iGc1tfk2OfP9N028J8WBVjitfNzDjtRdJ/OxuhjKgLQcRKwhuTejs8uK+/v0
8uBetBzC2l2EsiPd67uY4VmdcJaMmf2nOlsQa0Wxzj1u/sl92HmRxh+xUFe0
6cqTDs+9tDjQ09F2ebazsyeA9lPc49gL5sRjAZ8md4mnsngN62mamXGfB07p
fdoX7LXjPWBw7z+B2T8D+HcAzxmVHl+UDO9Wfp+Kui6iusXy/pRRcQm7PmYU
pHWD8Vhov9G18+ItwDmDJ38Ks39etd3kDzB/LvP1WF8r9CRtnkj81N4/M6kJ
WGnQs3pnnRsauYFvBdbuDO/EWeJ+XEebMlnvZO6R6HtHrJbpty161stkNYP5
M4Db5/wTeSelP+PbX6/nxUnNn3PA0W9xzCO0MLvrf/4Z5n5T/+M6eOJJ7Iim
on8x6R7BNMKqFRaMhoetFp2asS9LijU92fbyQftkAv6L/F+9H7KpzrfueZzE
v/bXbDLRp817bJ/1Z2RfGdEa46P+599FzjOjj39ecC9ivUD66IWAHgP8hjBa
qv7nDxHPDNEI6ZdC8xLmcR96AmGVDeO//uc/PSuhVVoNHnp4+M2r7RvWrkbU
/14Bzldkj+ezAR6AyNz+58dG1zf66ac3au5zmV/L+B2sX8r8vYyvYH0O8FPB
+/ZAazU9kRcRf8H087CwgnIr7JMe4TXA34h2VzB/D/DLgJVvYJ73he1v7u+f
KsxOuVhGv+83JzbICa3fNLhv5K3fG/n01xsp/G+qVr4ao93VzExq+QuzAyl4
dnQ7WLTPZHSAPQOqTvCmgHcJ6072ZTIi3SnwLYlXUviuAnwLY4V9UbTsW2P7
n7OkOHgPWMgHYefxyflMYT2zc3MJs3bNcMki2mYezyJlB5WJeaPtyXrRqlhB
Go6ucr7q5TNPD/Ta4ig9NHr6eiwH2yLmG636agdGZ8T4y7vIGWJ1Spv6BjMY
JWD6hSoElwXj84JiMd4WfiSyzAKyYFaky6I1L45dY02J3o+rLsZZRT48HlQ2
rZfc045UTSfzKAvqFMqFtKqCWEOqCe5FSR9W3ONpdQKpD6kPabqjvNqrHV8V
IjU24QQasyqc6kRKqwvobZTugSfNYecK67zjWH5HgPLdROVLiwvtumwPaftG
e1Jol8YjADvNPFQ9fR8n96BjRgDesRgvKwue2gifMh7omb3Xrs8Bo/9e+52H
j9pQ6/R2oIxU/0H5PKZ3Z3SWU8R74pflWfvZtjfy2bY38tm2N/LZtjeV1n+b
5+gPvf/ODY3cwNcG1s6hHh/3ZRTsRYDKM4BLIyE7sazEa5kb/RNuG/2E20ZX
W2ts5BNs2/E7WL+U+XsZX8H6HOCngmc/4RbGRngN8DdC7Qrm7wF+GdDqBubN
J9w28k5SRreRFyib5pfxCkbjlXZmUtMrzA6k4OnldrBIk8noAHsGVJ3gTYkv
7Hph4Hyjb8M6/CnwLYmVUviuYN3JPuVPtTfwsm+Njb6RRr+8h1mki7Dz6OZ8
prCeULdOSpi1a4ZLFtEu83iiH+gOKhOz/lSsbKJTsYI0HF3lfNWrZ54e6KXF
UXpotPT1WA62Rcw3WuXUDozOEfGWd5EyxMqUNvUFZihKwPRp7vGksnBZMB4v
KFZ7N/ByyexTK88C0mAepEtTbPTzJDHs5qkC0fxx1UU1q7npEaCyaAXkvnXE
Pk7mkTfqEIr2tLqBWEPqxeE+TqsFKNuQGpCmPdpW+4/hmR+pmwmnypiZf6pT
Ji33tY5qZ/HQ437Y2cC6xTiWf6qjtW6i8nG/a2dk+zzb29lqr50U9zB2g6wf
C/gwuU8c08PxzNcYyMy47+w9ZQTQk3evZZ8Dhv2JNouHWuD9yO8xUTaq96BM
HdOvMzrLKeKt6kv1aN3IN08ExNb1tpXAWtlthqM/9LY4r/r3KoWvDWzvW4/7
Mgr2IkDlGcClkZCdRVbidWVv1cpthCcCk41+CmPTs8YWXMv4Haxfyvy9jK9g
fQ7wU8Hr/Q6aIDbCa4C/EWpXMH8P8MuAVjcwb38HzUae7G7kUwgbCctN1eLX
GO1h1MxManqF2YEUPL3cDhZpMhkdYM+AqhO8KfGFXXcGLgjdKfAtiZVS+K4I
X7uviHh12bfG9j9n1C/vYRatirDz6OZ8prCe2Lm1hFm7ZrhkEe0yj2fMHllQ
Jmb9qVjZRKdiBWmUYa1Bjky9sdc/i6M0KKgGy0E0OEeM+HnVVTmNVEbtiHjL
u0hxVKawbTzaUX3OiQQh67AKwGXBeLygWA/o7FciwSwgAcZ+ugSFVKo4NsdC
zo+rLrpZ1U2PAZVMayD3rpv454CTeRanyIX5NU1zxBpSMc4DEj6suJ/TKgFK
NKQCpOmM8mrfMTzjd7HBMznhNBkz4091uqTl/IzOIscHnkyHnResd4xjhbqO
m6hUPAb0FLS9nu3vbMXXbop7GztCJmXAn8m94um9zWqQlQj7IYRP6fu0WuDb
+Dlg9H7jjcFDXfC25HecKCHVflD+nt7DnCLesb5sv9bNffu5gY18bmAjnxvY
VFr1bcajV/QGOTc0cgNfG1j7gnp83JdRsBcBKs8ALgw1dk5ZideVvWkrtxGe
ErzQuH9RTaw1XgjPF/pNrN36pczfB9bnAD8VvN/vuO7DRngN8DdC7Qrm7wH+
NqDVDcz/dSNV85TghXSAMrrt2ITldmzxa4xmqZ2Z1PQKswMpeHq5HSzSZDI6
wJ4BVSd4U8C7MHgqTS54OZFiCnxLYqUUvitYd7IP9UBvLvtWeKE/BYb+eA+z
qAfCzqOb85nCekDdOSlh1q4ZLllEu8zjWaTsoDIxq6tXTVQSC+puR2kjTY2E
s6hnFkfJrpHZl325lwbXgMWY1jHdxSQ4IrLyLia4TGFbeLSj+pwTCZg+zS2c
5ByXBSMP6yeeAlPxTs15FuCM0Z3GWWsWx0btUevHVRevrHKme1ll0DrG/edI
FXUyH6t2oVxIqwKIlZb97X3Nq3uAwbyalt8o1ZC8xr1oP+0UhmdwuFr4NZln
4ZgZfKpzIZbDWgn90zB+7h7m/acUC2mhFW+i0nBP61llezDbd9k6rV0O9yl2
anmomvleS+7hxvEp1mXbg9T7NZszM+7rWcb08z7ZuAWfA0br53ceHlJCTn6E
o8RUz0E5OI7/ZnQXdhW465Rei0vE7RX2Xfmi6xWa+/eL9oaQveiqs81ZtLze
zeZV/xaj8LWMi6q73ei8n4+LAJVnBt6d+eQcsZKuK3t3VS5jvJ3/oG/nP1TW
CltwLeNrWL+E9d/C+hzgp4L3447rPmyE1wC/FGpXEbyvA1rdwPzfNFK1b+c/
yJPUD/J2/oM450PV4tcYbYFvZiY1vcLsQAqeXm4HizSZjA6wZ0DVCd4U8FYG
r14vBT+TsQD8AvieHcj3MrKOXlz2tSecWz+8h1m0IsLOo5vzmcJafufGEmbt
muGSRbTLPJ5od7qDysSs2b5b60Xj9u9yL40zbgeQQWOmjzn7CNJPB9GYV12t
0nxheEdEUd7531HZwlp7tD0szO9zIgHTp33D7dcHLgv66SKwu+Y+NbVsR9Hg
LEQilPR4iXysBWA9rroYZtUx3cuFqYXcq1rpWUw4whs12hexw+3Dc+URYM0o
Lc5hWXE/jikfz+VQHzA8d3cxwHVOqPZj5u6pqj9i3QI88/jUdOoJ/3Q9rIKn
ZSti3Xjc0852PX9sR2W7KFuRtWfhPsS+i3U+AS8ld2SHWfAOYOuXXVxCn2Sl
wHXaVZ7Ir77FngNG69d3Hh5KjTcMv2tD3ngiDM+xwyyzimKxuoF3kc/VS6XU
Cr231NtWAmudtdmINtY71NzQyA18K7Dt0moY7ZNF6FwbmJ0FVka9hba3S7XU
CDfjUn+SvdTVVv9SfpK91O9q6dYvYf01rM8BfiJ49nPrYWyE1wB/K9SuIniv
AlqtYN58br2UnzyS0ZXy4xTbscWvMRqvtDOTml5hdiAFTy+3g0WaTEYH2DOg
6gRvCng3sO5kH9IrgN/ZSPwK0Br5ojcf9K1AJLGfJOtm0ZoIO49uzmcK6wF1
56SEWbtmuGQR7TKPZ5Gyg8rErN/0pf2oLPWnPlNpqOdKT9bZJ5fV0VXOl0Va
TWNhaDG5joivvIuMIZJS2lF9zokETJ/mpkoyj8uCPr2oTLWKYi9FBpTtlDLM
kmyKVrmuujrH6mt6FBRSNbXqcVlc6Vd8J/OxmhjKoLT8Q6wheZfq39NLwr2M
lkNYO4vhuR6pNgnnxpi5fqpzBLFWSVj+GX3YyZDGnXse9UW7rjwZ0/oI7X9s
F2c7N1vjtV/iXsZeLydeCvgxuQs8pZf1nMzMuM/ip/c5O9n2W/MeMOxnzy0e
UsIbj989Mmsdl6Gn9OUlwB/fd2k92hAP1i25nkfNLb6Un0WXfMMsRvvrfW9e
9W8qCt8C/JjImrpfe4Ndj0BOGyvrXWVvxGqxMd5zV1/LU6jqa2uHLbiW8TWs
X0bW5wA/Ebwfdlz3YSO8BvilULuK4L0KaLWC+ebbleQ9d/V1+7S0Hd12bANy
Ozb4NUabKs3MpKZXmB1IwdPL7WCRJpPRAfYMqDrBmwLeyuCpNLng5USKAvie
Hcj3Btad7CsCfNGrD/rWIJK0fnkPs0gXYefRzflMYT2xc2sJs3bNcMki2mUe
zyJlB5WJWV+9a6Jz+3e5l4ajq0hZ46L0NJh9QRqgnPXuhaHCJDoi3vIuUriM
Ydt4tD0srAznRAKmT/s+2q8sXBb05kVg93lQv+mkPUlqWVDGcWTh9kFeuciC
vK6rruKxipvu/0Lqp9Y/7llHqqCTeeSNGoeyJi3nEIvn2iPAmlFanMOy4n4e
Uz5eC9I4oH21Axme++G649d4Hp9j5v6pzhnEugV4Vplo7/Hzz/HDzgnEWlGs
RVR/tNjKw0jrM/QctN1eXvm9zUS6wLCXsSfMiZcCfkzuFg+z8R3AJd2FJ5ye
o5kZ91XMMf2PNxXLm+WLb9d7wGi9/87DQ62Qs58JqEE8VmO5OqbleHVH314C
rVP6Mk2iYzxaN/N6UrVv9dvbXzbp7ks2v9EfemOcV/27lcK3BtY7F7uZZgfS
YWcEynxX2bu1WvK45wKHQu3pOpn8l4z1yh+aFdFENzQYE/imxf/4DDGbn2fY
gv9G5i2s37Y7l3EN8A8yXsN8YUZL7yGhP9nzPY/43cHXADuA5wD/LdX+AcD/
GqESg1FKXMfvucZvx0R81CoXaz6SEa2mXrqTEb8NGOkp/o+ddXrf8jqdyE+g
Trpvq23R2j/traf7xl8GN98I6ro93WxusF0fy99n9jjDKTMyt4gFoW530kjp
aa3fl8y+n9YJNZwPfR+v0mGeZXQuzL4QvtWGfQcregllSdUpBhcRuuwbmxmf
JXgKdZpG1mO5334KDi0q9xHjd43NwKy1chCTU8W6s4eLN8tqwD5Y+rYd7OU1
kQctqrm+R8e8y7m4zjWM0YBespncbmFSxW2LmVh4dPFsS6OrdaVfy7xv+ta5
IZHFfc5xe5r4vj7MZizTa01KSr9ewfM5zKfGxm91DmvNaKflBasCNbX25Nd6
WJFo32PtxNlYPp08302e7YOZbCWVokjSM5Z72J+ohxEvZr/23ctEfsPwxOvb
Yvu/otqwMzuOtceXNFMO0RVPR+35YngFqQBcXuy/OVZMtn9s8OjJihE4IJO0
2/yYGaW9pO2xNOoQn2fMNCC5Uo91KVorh8YL4h+aI3vOtwMzp9evfYKMwVMH
6eDt6JhMiZ1G/9TgsT6QdcTh3mvs84fdNVg+7/r7BD8G+s1gd6CRR/M07QyK
+uPAbnNA3iX2mSc6pYb0kTQ6jrIFWvuBRxFPr88zF+2ppdWo97zDZI19rmBP
D41mdhNPua1bulYezFSds/js+Qzro1D20M06EBnJT0v0KQ2Lj31PR0L7LkRO
282z/larCXveQ6vd0RohvAA6LHJrOo+ZNCeKe9+b/1AFM8Gjjhn62KOGlsUO
BOX5CvlOfFkwMrCmxmsX67P21bKrKMUYhWfUfqgtPvsdWmPvI/s/ZkXdG1ne
E+U17K5lKLeg9m1aea+qfkWr/70jnGNVFt9d+JFbAEYtoROf7Xur8VvgdFP1
O5qH1f4OJ/R832rz950lDSa+4Xnj6VQPv0/aW/9zujdO4XdmGhPtu7XJn/w/
nr0uPA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{544, 653},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->113045259]
}, Open  ]],

Cell["\<\
It would have been much more difficult to find these features without the \
interactivity.\
\>", "Text",
 CellID->14858],

Cell[TextData[{
 "You might notice that if you run this example and generate quite a few \
treks as shown above, it may take a while for the window to update when you \
do a parameter change.",
 " ",
 "This is not surprising, since ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " has to recompute each of the solutions over again, and the rapidly varying \
nonlinear term leads to a more difficult numerical problem to solve."
}], "Text",
 CellID->28903]
}, Open  ]],

Cell[CellGroupData[{

Cell["Poincar\[EAcute] Sections", "Section",
 CellID->17110],

Cell[TextData[{
 "The default behavior of the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " is to show a straightforward plot of the solution parametrized by the \
independent variable.",
 " ",
 "However, there are situations where such plots can get very confusing, \
particularly for non-autonomous equations (for which there is explicit \
dependence on the independent variable)"
}], "Text",
 CellID->17766],

Cell["\<\
A good example of this is Duffing's equation, a nonlinear model for \
vibrations of a driven clamped beam.\
\>", "Text",
 CellID->205],

Cell["\<\
This shows an example of treks generated by Duffing's equation.\
\>", "MathCaption",
 CellID->16575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
      RowBox[{"\[Gamma]", " ", 
       RowBox[{
        RowBox[{"x", "'"}], "[", " ", "t", "]"}]}], " ", "-", " ", 
      RowBox[{"x", "[", "t", "]"}], " ", "+", " ", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "^", "3"}]}], " ", "\[Equal]", " ", 
     RowBox[{"\[Epsilon]", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"\[Omega]", " ", "t"}], "]"}]}]}], "}"}], ",", " ", "x", ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TrekParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Gamma]", "\[Rule]", ".15"}], ",", " ", 
      RowBox[{"\[Epsilon]", "\[Rule]", ".3"}], ",", " ", 
      RowBox[{"\[Omega]", "\[Rule]", "1."}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->14370],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{567, 475},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->588078941]
}, Open  ]],

Cell["\<\
The orbits cross one another and it is hard to get much of an idea of what to \
expect for nearby points.\
\>", "Text",
 CellID->3963],

Cell[TextData[{
 "A common technique for visualizing the overall change is to see how the \
solution is evolving over periods of the driving function. One way to think \
of this is to consider the 3-dimensional space of (x, x', s), where s = ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["\[Omega]", "TR"], " ", 
     StyleBox["t", "TI"]}], ",", 
    RowBox[{"2", 
     StyleBox["\[Pi]", "TR"]}]}], "]"}]], "InlineFormula"],
 ". In this case, the solutions lie within a torus. One way of visualizing \
the overall evolution of the solution is to see how it changes each time it \
has wrapped around the s axis, effectively looking at just a single cross \
section of the torus. This is one common case of a more general technique \
known as a Poincar\[EAcute] section. The induced map is referred to as the \
Poincar\[EAcute] map."
}], "Text",
 CellID->2219],

Cell[TextData[{
 "This allows you to generate a Poincar\[EAcute] section for Duffing's \
equation. The output shown was generated by picking two initial conditions.",
 " ",
 "Note that the ",
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " option is passed through to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ": since it is computing the solution over quite a long time interval, it is \
appropriate to allow as many steps as are needed."
}], "MathCaption",
 CellID->31667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
      RowBox[{"\[Gamma]", " ", 
       RowBox[{
        RowBox[{"x", "'"}], "[", " ", "t", "]"}]}], " ", "-", " ", 
      RowBox[{"x", "[", "t", "]"}], " ", "+", " ", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "^", "3"}]}], " ", "\[Equal]", " ", 
     RowBox[{"\[Epsilon]", " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"\[Omega]", " ", "t"}], "]"}]}]}], "}"}], ",", " ", "x", ",", 
   " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", "1000", ",", " ", "10000"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TrekParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Gamma]", "\[Rule]", ".15"}], ",", " ", 
      RowBox[{"\[Epsilon]", "\[Rule]", ".3"}], ",", " ", 
      RowBox[{"\[Omega]", "\[Rule]", "1."}]}], "}"}]}], ",", " ", 
   RowBox[{"TrekGenerator", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"PoincareSection", ",", " ", 
      RowBox[{"\"\<SectionCondition\>\"", "\[Rule]", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"\[Omega]", " ", "t"}], ",", " ", 
         RowBox[{"2", " ", "\[Pi]"}]}], "]"}]}], ",", " ", 
      RowBox[{"\"\<SectionVariables\>\"", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"x", ",", " ", 
         RowBox[{"x", "'"}]}], "}"}]}], ",", 
      RowBox[{"MaxSteps", "\[Rule]", "\[Infinity]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->257],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{558, 478},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->101374129]
}, Open  ]],

Cell["\<\
The image above shows the so-called strange attractor for Duffing's equation, \
which demonstrates deterministic chaos for the starting parameter values. The \
attractive nature can be intuited from the way points from both initial \
conditions wind up on the same structure. Note that the minimum value of t \
for which points were shown was chosen to be quite large so that transients \
are allowed to decay. Often this is a good choice when investigating systems \
in this way.\
\>", "Text",
 CellID->7555],

Cell["\<\
To use the Poincar\[EAcute] section trek generator, you will have to define \
the properties of the section you wish to see with method options.\
\>", "Text",
 CellID->24515],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {"\"\<SectionCondition\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
An expression in the problem variables for which the section variables will \
be shown whenever the expression is zero.\
\>", "TableText"]},
   {"\"\<SectionVariables\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
A subset of two of the dependent variables (or their derivatives for second \
and higher order equations) which will be shown every time the section \
condition expression is zero.\
\>", "TableText"]},
   {"\"\<FilterFunction\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
A function to apply to the values of the section variables before plotting. \
This only affects the plot, not the selection of initial conditions.\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->21695],

Cell[TextData[{
 "Method options for the ",
 Cell[BoxData[
  ButtonBox["PoincareSection",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/PoincareSection"]], 
  "InlineFormula"],
 " trek generator."
}], "Caption",
 CellID->13635],

Cell[TextData[{
 "It is required that you specify some value for both ",
 StyleBox["\"", "MR"],
 Cell[BoxData["SectionCondition"], "InlineFormula"],
 StyleBox["\"", "MR"],
 " and ",
 StyleBox["\"", "MR"],
 Cell[BoxData["SectionVariables"], "InlineFormula"],
 StyleBox["\"", "MR"],
 ".",
 " ",
 "Additionally, you can also pass to the generator any options of",
 StyleBox[" ", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"], "MR"]], "InlineFormula"],
 " you would like to be used in the computation."
}], "Text",
 CellID->15677],

Cell[TextData[{
 "When the value of ",
 StyleBox["\"", "MR"],
 Cell[BoxData["SectionCondition"], "InlineFormula"],
 StyleBox["\"", "MR"],
 " is of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["\[Omega]", "TR"], " ", 
     StyleBox["t", "TI"]}], ",", "T"}], "]"}]], "InlineFormula"],
 ", where \[Omega] and T are constants (they can depend on trek parameters, \
just not on the independent variable t or any of the dependent variables), a \
special optimized code is used to handle this common case as in the example \
above."
}], "Text",
 CellID->12528],

Cell["\<\
This loads a package containing several examples of differential equations.\
\>", "MathCaption",
 CellID->23136],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "Needs", "[", "\"\<DifferentialEquations`NDSolveProblems`\>\"", "]"}], 
  ";"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->6700],

Cell["\<\
This gets the ABC (Arnold Beltrami Childress) flow system, which is used to \
model chaos in laminar flows of the three-dimensional Euler equations.\
\>", "MathCaption",
 CellID->2404],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"system", "=", 
   RowBox[{
   "GetNDSolveProblem", "[", "\"\<ArnoldBeltramiChildress\>\"", "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"eqns", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"system", "@", 
      RowBox[{"\"\<System\>\"", "[", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       SubscriptBox["Y", "2"], "[", "0", "]"}], " ", "\[Equal]", " ", "0"}]}],
     "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"dvars", " ", "=", " ", 
   RowBox[{"system", "@", 
    RowBox[{"\"\<DependentVariables\>\"", "[", "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"svars", " ", "=", " ", 
   RowBox[{"dvars", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"scond", " ", "=", " ", 
   RowBox[{"dvars", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\n", "eqns"}], "Input",
 CellLabel->"In[20]:=",
 CellID->18199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox[
        SubscriptBox["Y", "1"], "\[Prime]",
        MultilineFunction->None], "[", "T", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        FractionBox["3", "4"], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          SubscriptBox["Y", "2"], "[", "T", "]"}], "]"}]}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{
         SubscriptBox["Y", "3"], "[", "T", "]"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        SubscriptBox["Y", "2"], "\[Prime]",
        MultilineFunction->None], "[", "T", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{
         SubscriptBox["Y", "3"], "[", "T", "]"}], "]"}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{
         SubscriptBox["Y", "1"], "[", "T", "]"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        SubscriptBox["Y", "3"], "\[Prime]",
        MultilineFunction->None], "[", "T", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{
         SubscriptBox["Y", "1"], "[", "T", "]"}], "]"}], "+", 
       RowBox[{
        FractionBox["3", "4"], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          SubscriptBox["Y", "2"], "[", "T", "]"}], "]"}]}]}]}]}], "}"}], ",", 
   
   RowBox[{
    RowBox[{
     SubscriptBox["Y", "2"], "[", "0", "]"}], "\[Equal]", "0"}]}], 
  "}"}]], "Output",
 ImageSize->{534, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->1003842279]
}, Open  ]],

Cell[TextData[{
 "This starts the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " to compute a Poincar\[EAcute] section of the ABC flow. The section shows \
the variables ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", "1"], TraditionalForm]]],
 "versus ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", "3"], TraditionalForm]]],
 " when ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", "2"], TraditionalForm]]],
 "== 0.",
 " ",
 "Before plotting, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", "1"], TraditionalForm]]],
 "and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["Y", "3"], TraditionalForm]]],
 " are taken modulo 2\[Pi]."
}], "MathCaption",
 CellID->20528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{"eqns", ",", "dvars", ",", 
   RowBox[{"{", 
    RowBox[{"T", ",", "0", ",", "1000"}], "}"}], ",", 
   RowBox[{"TrekGenerator", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"PoincareSection", ",", " ", 
      RowBox[{"\"\<SectionCondition\>\"", "\[Rule]", "scond"}], ",", " ", 
      RowBox[{"\"\<SectionVariables\>\"", "\[Rule]", "svars"}], ",", " ", 
      RowBox[{"\"\<FilterFunction\>\"", "\[Rule]", 
       RowBox[{"Function", "[", 
        RowBox[{"Mod", "[", 
         RowBox[{"#", ",", " ", 
          RowBox[{"2", " ", "Pi"}]}], "]"}], "]"}]}], ",", " ", 
      RowBox[{"MaxSteps", "\[Rule]", "\[Infinity]"}]}], "}"}]}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"2", " ", "Pi"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->2507],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 681},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->245610449]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Defining your own trek generator", "Section",
 CellID->28226],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " has been set up in such a way that, with relatively little effort, you can \
define your own trek generator, which can then be used as a setting of the ",
 Cell[BoxData[
  ButtonBox["TrekGenerator",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"]], 
  "InlineFormula"],
 " option. The interface works through the construction of a trek generator \
object, which is initialized when the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " is started up and is expected to have methods defined with a particular \
argument structure."
}], "Text",
 CellID->28073],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["InitializeGenerator",
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/InitializeGenerator"], 
     StyleBox["[", "MR"], 
     StyleBox["gname", "TI"], ",", " ", 
     StyleBox["spec", "TI"], ",", " ", 
     StyleBox["dvars", "TI"], ",", " ", "{", 
     StyleBox["ivar", "TI"], ",", " ", 
     StyleBox["ivmin", "TI"], ",", " ", 
     StyleBox["ivmax", "TI"], "}", ",", " ", 
     StyleBox["opts", "TI"], 
     StyleBox["]", "MR"]}], Cell[TextData[{
     "Initialize the trek generator with name ",
     StyleBox["gname", "TI"],
     " with problem specification ",
     StyleBox["spec", "TI"],
     ", dependent variables ",
     StyleBox["dvars", "TI"],
     ", independent variable",
     StyleBox[" ivar", "TI"],
     " with default range [",
     StyleBox["ivmin", "TI"],
     ", ",
     StyleBox["ivmax", "TI"],
     "], and options ",
     StyleBox["opts", "TI"],
     "."
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InitializeGenerator",
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/InitializeGenerator"], 
     StyleBox["[", "MR"], 
     StyleBox["gname", "TI"], ",", " ", 
     StyleBox["spec", "TI"], ",", " ", 
     StyleBox["vars", "TI"], ",", " ", 
     StyleBox["opts", "TI"], 
     StyleBox["]", "TI"]}], Cell[TextData[{
     "Initialize the trek generator with name ",
     StyleBox["gname", "TI"],
     " with problem specification ",
     StyleBox["spec", "TI"],
     ", variables ",
     StyleBox["vars", "TI"],
     ", and options",
     StyleBox[" opts", "TI"],
     ". With this case, there is no independent variable, and the argument to \
",
     StyleBox[ButtonBox["EquationTrekker",
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"], 
      "InlineCode"],
     " should be given as ",
     StyleBox[ButtonBox["None",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/None"], "InlineCode"],
     "."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->2975],

Cell["Initializing a trek generator. ", "Caption",
 CellID->19434],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InitializeGenerator",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/InitializeGenerator"], "[", 
   RowBox[{
    StyleBox["gname", "TI"], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " should return an object of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["gname", "TI"], "[", 
   StyleBox["args", "TI"], "]"}]], "InlineFormula"],
 StyleBox[".", "MR"],
 " The arguments, ",
 StyleBox["args", "TI"],
 ", of the object can be used to store any data that may be used by the trek \
generator. This data may be in any convenient form because it is private to \
the particular instance of the trek generator ",
 StyleBox["gname", "TI"],
 ". Note:",
 " ",
 StyleBox["gname", "TI"],
 " must be a ",
 Cell[BoxData[
  ButtonBox["Symbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Symbol"]], "InlineFormula"],
 "."
}], "Text",
 CellID->12404],

Cell[TextData[{
 "It is recommended that you associate the rule for initializing a particular \
generator using ",
 Cell[BoxData[
  ButtonBox["InitializeGenerator",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/InitializeGenerator"]], 
  "InlineFormula"],
 " with the generator name itself using ",
 Cell[BoxData[
  ButtonBox["TagSet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"]], "InlineFormula"],
 " (i.e., ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["gname", "TI"], " ", "/:", " ", 
    RowBox[{
     ButtonBox["InitializeGenerator",
      BaseStyle->"Link",
      ButtonData->"paclet:EquationTrekker/ref/InitializeGenerator"], "[", 
     RowBox[{
      StyleBox["gname", "TI"], ",", " ", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], " ", ":=", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], ")"}]], "InlineFormula"],
 " This avoids any possible problems with symbol protection and/or \
unintentionally affecting the initialization for other generators."
}], "Text",
 CellID->30403],

Cell[TextData[{
 "Once the trek generator object, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["gobj", "TI"], " ", "=", " ", 
   RowBox[{
    StyleBox["gname", "TI"], "[", 
    StyleBox["args", "TI"], "]"}]}]], "InlineFormula"],
 ", has been defined, it is expected to have some methods defined.",
 " ",
 "This is the mechanism through which the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " determines the display format and gets the generated points."
}], "Text",
 CellID->23421],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["gobj", "TI"],
     StyleBox["@\"Variables\"[]", "MR"]
    }]], Cell[TextData[{
     "Return a list of variables used by the trek generator.",
     " ",
     "If there is an independent variable, it should be ",
     StyleBox["{", "MR"],
     StyleBox["ivar", "TI"],
     StyleBox[", ", "MR"],
     StyleBox["dvars", "TI"],
     StyleBox["}", "MR"],
     "."
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["gobj", "TI"],
     StyleBox["@\"Display\"[]", "MR"]
    }]], Cell["\<\
Return the equations or problem to show in the display area of the \
EquationTrekker window.\
\>", "TableText"]},
   {Cell[TextData[{
     StyleBox["gobj", "TI"],
     StyleBox["@\"DisplayMode\"[]", "MR"]
    }]], Cell[TextData[{
     "Return the default display mode for treks, either",
     StyleBox[" \"Line\"", "MR"],
     " or \"",
     StyleBox["Points\"", "MR"],
     ".",
     " ",
     "This is just a default since the setting can be changed at any time \
through the EquationTrekker window interface."
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["gobj", "TI"],
     StyleBox["@\"FormatTrek\"[", "MR"],
     StyleBox["iv0", "TI"],
     StyleBox[", ", "MR"],
     StyleBox["X0 ,", "TI"],
     StyleBox["{", "MR"],
     StyleBox["ivmin, ivmax", "TI"],
     StyleBox["}]", "MR"]
    }]], Cell[TextData[{
     "Given the values of the independent,",
     StyleBox[" iv0", "TI"],
     ", and dependent, ",
     StyleBox["X0", "TI"],
     ", variables that specify starting values for a trek, return a \
descriptive form trek specification.",
     " ",
     "Note, even if the independent variable is not used, the argument will \
be present when this method is called."
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["gobj", "TI"],
     StyleBox["@\"ChangeParameters\"[", "MR"],
     StyleBox["prules", "TI"],
     StyleBox["]", "MR"]
    }]], Cell[TextData[{
     "Return a new trek generator object that contains any new data that may \
be required to quickly generate points with modified parameter values given \
in the list of rules ",
     StyleBox["prules", "TI"],
     "."
    }], "TableText"]},
   {Cell[TextData[{
     StyleBox["gobj", "TI"],
     StyleBox["@\"GenerateTrek\"[", "MR"],
     StyleBox["X0", "TI"],
     StyleBox[", {", "MR"],
     StyleBox["iv0", "TI"],
     StyleBox[", ", "MR"],
     StyleBox["ivmin", "TI"],
     StyleBox[", ", "MR"],
     StyleBox["ivmax", "TI"],
     StyleBox["}]", "MR"]
    }]], Cell[TextData[{
     "Return the generated trek points for the trek starting from the point ",
     
     StyleBox["X0", "TI"],
     " = (",
     StyleBox["x0", "TI"],
     ", ",
     StyleBox["y0", "TI"],
     ") at independent variable value",
     StyleBox[" iv0", "TI"],
     ". Points should be generated over the independent variable range [",
     StyleBox["ivmin", "TI"],
     ",",
     StyleBox[" ivmax", "TI"],
     "]. Note: if there is no independent variable, this argument will still \
be present, though its value can be ignored. The points should be given a \
list of coordinates, ",
     StyleBox["{{", "MR"],
     StyleBox["x1", "TI"],
     StyleBox[", ", "MR"],
     StyleBox["y1", "TI"],
     StyleBox["}, {", "MR"],
     StyleBox["x2", "TI"],
     StyleBox[", ", "MR"],
     StyleBox["y2", "TI"],
     StyleBox["}, ...}", "MR"],
     ".",
     " ",
     "If the process of generating points changes the arguments of gobj, this \
method can return a list {",
     StyleBox["points", "TI"],
     ", ",
     StyleBox["newgobj", "TI"],
     "} containing a new trek generator object."
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->3085],

Cell["Methods for trek generator objects.", "Caption",
 CellID->3344],

Cell[TextData[{
 "All of the methods are necessary to have the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " display the modifiable items and problem specification in a reasonable \
way, but the essence of a particular trek generator will lie in how the ",
 StyleBox["\"GenerateTrek\"", "MR"],
 " method is defined."
}], "Text",
 CellID->1311],

Cell[TextData[{
 "The ideas behind setting up a trek generator are best illustrated by some \
examples. The two examples shown below have been kept simple for the purposes \
of illustration.",
 " ",
 "You can also see the definitions of the ",
 StyleBox["DifferentialEquation", "MR"],
 " and ",
 Cell[BoxData[
  ButtonBox["PoincareSection",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/PoincareSection"]], 
  "InlineFormula"],
 " generators in the package file EquationTrekker.m."
}], "Text",
 CellID->21022],

Cell[CellGroupData[{

Cell["Example: Nesting", "Subsection",
 CellID->6221],

Cell[TextData[{
 "This is a very simple generator that simply plots the result of applying ",
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 " to a specified function.",
 " ",
 "Even though the basic idea is simple, the idea of iteration is fundamental \
to most numerical methods, so a tremendous variety of methods and models can \
be visualized this way."
}], "Text",
 CellID->6183],

Cell[TextData[{
 "This declares the symbol ",
 StyleBox["Nesting", "MR"],
 " to be in the ",
 StyleBox["EquationTrekker`", "MR"],
 " context. If the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/guide/EquationTrekkerPackage"]], 
  "InlineFormula"],
 " package has been loaded, once this is entered, it is sufficient to just \
use ",
 StyleBox["Nesting", "MR"],
 " to specify this symbol.",
 " ",
 "See the ",
 ButtonBox["note on contexts",
  BaseStyle->"Link",
  ButtonData->"paclet:EquationTrekker/tutorial/EquationTrekker#4819"],
 " following this section for more detailed explanation."
}], "MathCaption",
 CellID->21397],

Cell[BoxData[
 RowBox[{"EquationTrekker`Nesting", ";"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->6601],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InitializeGenerator",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/InitializeGenerator"]], 
  "InlineFormula"],
 " is defined to be associated with ",
 StyleBox["Nesting", "MR"],
 ". All it does is return an object with the function and variables in it.",
 " ",
 "The function is repeated since once the parameter is set, it will keep the \
original and the one transformed by the parameter rules."
}], "MathCaption",
 CellID->8550],

Cell[BoxData[
 RowBox[{"Nesting", " ", "/:", 
  RowBox[{"InitializeGenerator", "[", 
   RowBox[{"Nesting", ",", " ", "f_", ",", " ", "dvars_", ",", " ", 
    RowBox[{"{", 
     RowBox[{"ivar_", ",", " ", "ivmin_", ",", " ", "ivmax_"}], "}"}], ",", 
    " ", "opts___"}], "]"}], " ", ":=", " ", "\[IndentingNewLine]", 
  RowBox[{"Nesting", "[", 
   RowBox[{"f", ",", " ", "f", ",", " ", 
    RowBox[{"{", 
     RowBox[{"ivar", ",", " ", "dvars"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[31]:=",
 CellID->28886],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Nesting", "[", 
    RowBox[{"forig_", ",", " ", "f_", ",", " ", "vars_"}], "]"}], "@", 
   RowBox[{"\"\<Variables\>\"", "[", "]"}]}], " ", ":=", " ", 
  "vars"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->12514],

Cell["\<\
Anything could be chosen as the appropriate thing to display. In this case, \
the obvious choice is the function being iterated.\
\>", "MathCaption",
 CellID->535],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Nesting", "[", 
     RowBox[{"forig_", ",", " ", "f_", ",", " ", "___"}], "]"}], "@", 
    RowBox[{"\"\<Display\>\"", "[", "]"}]}], " ", ":=", " ", "f"}], 
  ";"}]], "Input",
 CellLabel->"In[33]:=",
 CellID->17689],

Cell["\<\
Since the generator gives discrete iterations of function composition, it \
makes the most sense to show points, not lines, by default.\
\>", "MathCaption",
 CellID->22564],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Nesting", "[", 
     RowBox[{"forig_", ",", " ", "f_", ",", " ", "___"}], "]"}], "@", 
    RowBox[{"\"\<DisplayMode\>\"", "[", "]"}]}], " ", ":=", " ", 
   "\"\<Points\>\""}], ";"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->19196],

Cell[TextData[{
 "To keep the formatting simple, the method is defined to only show the \
starting point.",
 " ",
 "Another option would be to use something like ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldForm"], "MR"]], "InlineFormula"],
 StyleBox["[", "MR"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"], "MR"]], "InlineFormula"],
 StyleBox["[", "MR"],
 StyleBox["f, dv, n", "TI"],
 StyleBox["]", "MR"],
 "], where ",
 StyleBox["n", "TI"],
 " is the number of iterations."
}], "MathCaption",
 CellID->28153],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Nesting", "[", 
     RowBox[{"forig_", ",", " ", "f_", ",", " ", "___"}], "]"}], "@", 
    RowBox[{"\"\<FormatTrek\>\"", "[", 
     RowBox[{"iv_", ",", " ", "dv_", ",", "_"}], "]"}]}], " ", ":=", "dv"}], 
  ";"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->21540],

Cell[TextData[{
 "When the parameters are changed, a new data object that saves the function \
transformed by the parameter rules is saved.",
 " ",
 "This is the function that is actually given to ",
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->12077],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Nesting", "[", 
    RowBox[{"forig_", ",", " ", "f_", ",", " ", "vars_"}], "]"}], "@", 
   RowBox[{"\"\<ChangeParameters\>\"", "[", "prules_", "]"}]}], " ", ":=", 
  RowBox[{"Nesting", "[", 
   RowBox[{"forig", ",", " ", 
    RowBox[{"forig", " ", "/.", " ", "prules"}], ",", " ", "vars"}], 
   "]"}]}]], "Input",
 CellLabel->"In[36]:=",
 CellID->17571],

Cell[TextData[{
 "Finally, the all important definition for generating points decides on the \
number of iterations (some argument checking on the values of ",
 StyleBox["iv0", "TI"],
 ",",
 StyleBox[" ivmin", "TI"],
 ", and ",
 StyleBox["ivmax", "TI"],
 " would be appropriate here but have been left out for simplicity) and call \
",
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->25340],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Nesting", "[", 
    RowBox[{"forig_", ",", " ", "f_", ",", " ", "___"}], "]"}], "@", 
   RowBox[{"\"\<GenerateTrek\>\"", "[", 
    RowBox[{"X0_", ",", " ", 
     RowBox[{"{", 
      RowBox[{"iv0_", ",", " ", "ivmin_", ",", " ", "ivmax_"}], "}"}], ",", 
     " ", "___"}], "]"}]}], " ", ":=", " ", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", " ", "=", " ", 
      RowBox[{"Round", "[", 
       RowBox[{"ivmax", " ", "-", " ", "iv0"}], "]"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"NestList", "[", 
     RowBox[{"f", ",", " ", "X0", ",", " ", "n"}], "]"}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[37]:=",
 CellID->13425],

Cell[TextData[{
 "This defines a function that defines a variant of Euler's method for the \
pendulum equation that conserves a Hamiltonian, which is within order ",
 StyleBox["h", "TI"],
 " of the actual Hamiltonian for the pendulum equation."
}], "MathCaption",
 CellID->8321],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"EquationTrekker`myfun", "[", "h_", "]"}], "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", " ", "y_"}], "}"}], "]"}], " ", ":=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"xnew", " ", "=", " ", 
      RowBox[{"x", " ", "+", " ", 
       RowBox[{"h", " ", "y"}]}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"xnew", ",", " ", 
      RowBox[{"y", " ", "-", " ", 
       RowBox[{"h", " ", 
        RowBox[{"Sin", "[", "xnew", "]"}]}]}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[38]:=",
 CellID->18745],

Cell[TextData[{
 "This calls the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " to show the iterations of the function."
}], "MathCaption",
 CellID->7628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{"myfun", "[", "h", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"iteration", ",", " ", "0", ",", " ", "1000"}], "}"}], ",", " ", 
   RowBox[{"TrekGenerator", "\[Rule]", "Nesting"}], ",", " ", 
   RowBox[{"TrekParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"h", "\[Rule]", "0.9"}], "}"}]}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->13198],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{441, 637},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->210416485]
}, Open  ]],

Cell[TextData[{
 "The level curves of the Hamiltonian conserved by the method are quite \
apparent from the above graphic. By contrast, the usual explicit Euler method \
shows points that spiral outward since it is unconditionally unstable for the \
pendulum equation. If you vary ",
 StyleBox["h", "TI"],
 " to be closer to zero, the curves become more and more like the actual \
orbits for the pendulum equation and the fuzziness near the separatrix \
disappears."
}], "Text",
 CellID->30919]
}, Open  ]],

Cell[CellGroupData[{

Cell["A note on contexts", "Subsection",
 CellID->4819],

Cell[TextData[{
 "The GUIKit application, which the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " is built from, modifies the contexts of input symbols that are in contexts \
not explicitly on the context path (given by ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 ") to avoid conflicts between invocations that may occur simultaneously."
}], "Text",
 CellID->20471],

Cell[TextData[{
 "This shows the value of the ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " variable after the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " package has been loaded."
}], "MathCaption",
 CellID->23901],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellLabel->"In[2]:=",
 CellID->29350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"EquationTrekker`\"\>", ",", "\<\"GUIKit`\"\>", 
   ",", "\<\"JLink`\"\>", ",", "\<\"System`\"\>", ",", "\<\"Global`\"\>"}], 
  "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{364, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1742598806]
}, Open  ]],

Cell[TextData[{
 "Symbols in ",
 StyleBox["Global`", "MR"],
 " context will by given a private context.",
 " ",
 "Typically, if you just enter a new symbol name, it will be created in the \
context, so definitions you make without consideration of context may not be \
recognized when you run ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 ". To get around this problem, in the nesting example above, you can put ",
 Cell[BoxData["Nesting"], "InlineFormula"],
 " into ",
 Cell[BoxData["EquationTrekker`"], "InlineFormula"],
 " context, which was put on the context path when the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 " package was originally loaded."
}], "Text",
 CellID->27380],

Cell[TextData[{
 "A tidier way to do it is to make a package that contains your trek \
generator definitions (e.g., ",
 Cell[BoxData["Nesting`"], "InlineFormula"],
 "). When you load the package, its context will be put on the context path \
so the definitions will work properly.",
 " ",
 "This method is shown in the next example."
}], "Text",
 CellID->11021]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example: FindMinimum", "Subsection",
 CellID->31205],

Cell[TextData[{
 "A simple example that does not use an independent variable is a trek \
generator that simply shows the search points arrived at with ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMinimum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMinimum"], "MR"]], "InlineFormula"],
 StyleBox[",", "MR"],
 " starting from a selected starting point."
}], "Text",
 CellID->19242],

Cell[TextData[{
 "This defines a package which sets up a trek generator based on ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->7268],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"BeginPackage", "[", "\"\<FindMinimumTrek`\>\"", "]"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{"FindMinimumTrek", "/:", 
   RowBox[{"InitializeGenerator", "[", 
    RowBox[{"FindMinimumTrek", ",", "f_", ",", "vars_", ",", "opts___"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"dvars", "=", "dvarsin"}], "}"}], ",", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"Not", "[", 
         RowBox[{
          RowBox[{"ListQ", "[", "vars", "]"}], "&&", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Length", "[", "vars", "]"}], "\[Equal]", "2"}], ")"}]}], 
         "]"}], ",", 
        RowBox[{
         RowBox[{"Message", "[", 
          RowBox[{"FindMinimumTrek", "::", "only"}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"Throw", "[", "$Failed", "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"fmopts", "=", 
       RowBox[{"Sequence", "@@", 
        RowBox[{"Flatten", "[", 
         RowBox[{"{", 
          RowBox[{"FilterRules", "[", 
           RowBox[{
            RowBox[{"{", "opts", "}"}], ",", 
            RowBox[{"Options", "[", "FindMinimum", "]"}]}], "]"}], "}"}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"FindMinimumTrek", "[", 
       RowBox[{"{", 
        RowBox[{"f", ",", "f", ",", "vars", ",", "fmopts"}], "}"}], "]"}]}]}],
     "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FindMinimumTrek", "[", 
     RowBox[{"{", 
      RowBox[{"origf_", ",", "f_", ",", "vars_", ",", "fmopts_"}], "}"}], 
     "]"}], "[", 
    RowBox[{"\"\<Variables\>\"", "[", "]"}], "]"}], ":=", "vars"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FindMinimumTrek", "[", 
     RowBox[{"{", 
      RowBox[{"origf_", ",", "f_", ",", "vars_", ",", "fmopts_"}], "}"}], 
     "]"}], "[", 
    RowBox[{"\"\<Display\>\"", "[", "]"}], "]"}], ":=", "origf"}], 
  "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FindMinimumTrek", "[", 
     RowBox[{"{", 
      RowBox[{"origf_", ",", "f_", ",", "vars_", ",", "fmopts_"}], "}"}], 
     "]"}], "[", 
    RowBox[{"\"\<FormatTrek\>\"", "[", 
     RowBox[{"t0_", ",", "x0_", ",", "_"}], "]"}], "]"}], ":=", 
   RowBox[{"Thread", "[", 
    RowBox[{"{", 
     RowBox[{"vars", ",", "x0"}], "}"}], "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FindMinimumTrek", "[", 
     RowBox[{"{", 
      RowBox[{"origf_", ",", "f_", ",", "vars_", ",", "fmopts_"}], "}"}], 
     "]"}], "[", 
    RowBox[{"\"\<ChangeParameters\>\"", "[", "prules_", "]"}], "]"}], ":=", 
   RowBox[{"FindMinimumTrek", "[", 
    RowBox[{"{", 
     RowBox[{"origf", ",", 
      RowBox[{"origf", "/.", "prules"}], ",", "vars", ",", "fmopts"}], "}"}], 
    "]"}]}], "\n"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FindMinimumTrek", "[", 
     RowBox[{"{", 
      RowBox[{"origf_", ",", "f_", ",", "vars_", ",", "fmopts_"}], "}"}], 
     "]"}], "[", 
    RowBox[{"\"\<GenerateTrek\>\"", "[", 
     RowBox[{"x0_", ",", 
      RowBox[{"{", 
       RowBox[{"t0_", ",", "independMin_", ",", "independMax_"}], "}"}]}], 
     "]"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "points", "}"}], ",", 
     RowBox[{
      RowBox[{"points", "=", 
       RowBox[{"Reap", "[", 
        RowBox[{"FindMinimum", "[", 
         RowBox[{"f", ",", 
          RowBox[{"Evaluate", "[", 
           RowBox[{"Thread", "[", 
            RowBox[{"{", 
             RowBox[{"vars", ",", "x0"}], "}"}], "]"}], "]"}], ",", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"Sow", "[", "vars", "]"}]}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"points", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1"}], "]"}], "]"}]}]}], "]"}]}], "\n"}], "\n", 
 RowBox[{"EndPackage", "[", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->7752],

Cell[BoxData["\<\"FindMinimumTrek`\"\>"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->476154656]
}, Open  ]],

Cell[TextData[{
 "The most significant difference between this generator and the one of the \
previous example is that it does not use an independent variable. This is \
reflected in ",
 Cell[BoxData[
  ButtonBox["InitializeGenerator",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/InitializeGenerator"]], 
  "InlineFormula"],
 " in that the argument with independent variables is simply omitted. Aside \
from the ",
 StyleBox["\"Variables\"", "MR"],
 " method, where only the used variables are returned, the arguments for the \
other methods have the same structure: even though the independent variables \
are not used, some (meaningless) values are passed anyway.",
 " ",
 "This is done to optimize the overall operation of the ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 "."
}], "Text",
 CellID->15818],

Cell[TextData[{
 "The other thing worth noting in the previous definition is the way options \
are passed. ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " options are selected with ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FilterRules",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FilterRules"], "MR"]], "InlineFormula"],
 " and saved for use each time a trek is generated.",
 " ",
 "These options come from options given to ",
 Cell[BoxData[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
  "InlineFormula"],
 StyleBox[" ", "TR"],
 "when it is invoked."
}], "Text",
 CellID->24471],

Cell[TextData[{
 "This shows the search points for ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " for a family of functions like the Rosenbrock function."
}], "MathCaption",
 CellID->7342],

Cell[BoxData[
 RowBox[{"EquationTrekker", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", " ", "-", " ", "1"}], ")"}], "2"], " ", "+", " ", 
    RowBox[{"100", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"y", " ", "-", 
        RowBox[{"\[Gamma]", " ", 
         SuperscriptBox["x", "\[Alpha]"]}]}], ")"}], "2"]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "None", ",", "\[IndentingNewLine]", 
   " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"TrekGenerator", "\[Rule]", "FindMinimumTrek"}], ",", " ", 
   RowBox[{"TrekParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "10"}], "}"}]}], "}"}]}], ",", " ", 
      RowBox[{"\[Gamma]", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", " ", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "}"}]}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->2782]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interactive controls", "Section",
 CellID->26913],

Cell["\<\
The graphical interface controls for the equation trekker are generally \
self-explanatory. Below is a reference of the controls with brief usage \
description.\
\>", "Text",
 CellID->18514],

Cell["\<\
The trek toolbar appears across the top of the equation trekker window:\
\>", "Text",
 CellID->8067],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WL1LHEEUf3e7qzmT+/A8BZvkukCa5K9QGyH/wiGCFiHBWNmktUnKxHyY
IgElWFxALLQIBIKgAcVCSZUyhyhJELFJcc57Nzv7cW/W2Zs1Czu8ffPxe1/z
ZvZNNuZnph815menGvXxucaTmdmpp/Wxx3OC5eQA8vcBYLQOSLcFKZs2nB7/
oOYBNjnBER0DSIMD3w+PYKn5BRaWmlCh1oEXq5vwde+ARgSzK6HZjpy9/vkj
PF9cIKbP29rZg5WtXfj56wQGZc/x7zPiYd+EHLe73SRKoXxjAI72twXIGvw5
aSne4ocN+Ht+QQOrEgC/kY8jxhkAD9saPFveJKi1EFRBDkfdkYHvkFwWef4S
Y7plBU+si4amtwIdBZAX0e8To1+r1eqA/gsMGBbERRc6SDoMFZMwTy1NUTzx
5vG7Ty4e7qsxvNsWWrop8ckqL43Cyo1YRTwlIjzohHhbvTjMVaiOoohH8DVF
3bHVVYtBmr0yiuf0mjlRVPI6Da8qqsRYu2irrRa3y4+FHjVzowj3FGrJVvbY
yiTxux72I5cYAkMEACOKqqheawd4jBJvDbOykRKBX2OxE/QGu6d6HTFmIAGp
/cZobxmqzUFp4YsqnGS+Cz1lqXAsAYLyW2xV/+jpPdmmkZwM99pum3oJGno6
DWPJsRxNnZoDY8DCNmml1Kbr7nTQg7Wu9hGXrjn/UuwVkWMTOaZSaZOk5fHc
l+CdMiMHd3UoXnsMJUlJlnmfUQoy3ci3DE1T+o9JiMPXhlL4qDK9dPOxCvwN
h5Mm61OqXycQqbicfQ6JA+LDmfimoUGyuY+YSqU9rC1zyI2EIDfNphQa1tfL
JEm0GdTyN+BK7YMTl6jhjDdBKp25rZ7qt7Zf+WkQKZp710L6glqva8/6smIF
BGsW4RIDfiMfR2hLDAbwXbUAHxRLLrrCCfY9xHF8DcOumsNXiCB3CQrIJGU=
\
\>"], "Graphics",
 Evaluatable->False,
 ImageSize->{559, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[10]:=",
 CellID->21394],

Cell["\<\
The first four controls allow you to change the current mode. The last two \
allow you to select colors and display the current drawing mode.\
\>", "Text",
 CellID->692],

Cell[BoxData[GridBox[{
   {Cell["icon", "TableHeader"], Cell["mode", "TableHeader"], " "},
   {Cell[TextData[Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwiIOwAgOI/R/IhBHM
IIrh9NVrDDPW72MQZKiasZ6RoW/5TkaGg+cuMjJAADPDrpPnGJbtOsVw79lr
oKL///8zMrx894kRJMYIlgQp6li0leHDl28gaQYhiCIglxEsDpIHmg2WA2Fh
iDxICF2KBWIlkMmMhQXTw4KiBwj4EJrhwnRUT7T3iJUaHh4c3L4gLqkxgzIE
KL0jp2xw8geJg+SBeQV39gBJMhCX0RgBKOKXNQ==\
\>"], "Graphics",
     Evaluatable->False,
     ImageSize->{23, 23},
     ImageMargins->{{0, 0}, {0, 0}},
     ImageRegion->{{0, 1}, {0, 1}}]]], 
    RowBox[{"select", " ", "treks", " ", "mode"}], Cell[TextData[{
     "Mouse button selects treks. Multiple treks may be selected by dragging \
or using shift-click. Once treks are selected, you may\n\[Bullet] Delete them \
by using the delete key.\n\[Bullet] Move their starting position(s) by \
dragging.\n\[Bullet] Change their color using the color well tool ",
     Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwiICwAgOI/R/IhBIi
DPVzdwIZzGD6P1AQhAVAJOOo1DCTgkU2IwDMNsBJ\
\>"], "Graphics",
      Evaluatable->False,
      ImageSize->{20, 20},
      ImageMargins->{{0, 0}, {0, 0}},
      ImageRegion->{{0, 1}, {0, 1}}],
     ".\nControl-click or right-click creates treks. Dragging allows you to \
interactively change the position of the newly created trek."
    }], "TableText"]},
   {
    RowBox[{Cell[""], Cell[TextData[Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwiIOwAgOI/R/IhBHM
IIrh9NVrDDPW72MQZKiasZ6RoW/5TkaGg+cuMjJAADPDrpPnGJbtOsVw79lr
oKL///8zMrx894kRJMYIlgQp6li0leHDl28gaQYhiCIglxEsDpIHmg2WA2Fh
iDxIiIGBFUUKhCG2AllMIBYbWAziVJgKZmQDWNANYEI1gAXEYoazcGpjRtXG
BGKxwsVwamNB1caJVzErqmIOwv5gwuJ9JrgsO+GQZMFrABuyAaixBLGZFUUj
zFBWLIayEDIKixvQxDhxG8GMxzXchLQRtpkDtxHYAxAIuIjXgysm2XEbwYrH
w3jCiUxtbPAcgOYrYHEAyu3I+Rqc+UHiIHlgSYG7cABJMhBXzDACAAvl/M8=
\
\>"], "Graphics",
      Evaluatable->False,
      ImageSize->{23, 23},
      ImageMargins->{{0, 0}, {0, 0}},
      ImageRegion->{{0, 1}, {0, 1}}]]], Cell[""]}], 
    RowBox[{"create", " ", "treks", " ", "mode"}], Cell["\<\
Mouse button creates new treks.
Control-click or right-click selects treks.
Dragging the create treks button opens a menu that allows you to toggle the \
default drawing mode between lines and points. The last item on the toolbar \
indicates the current drawing mode.\
\>", "TableText"]},
   {Cell[TextData[Cell[BoxData[
     FormBox[Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwiIOwAgOI/R/IhBHM
IIrh9NVrDDPW72MQZKiasZ6RoW/5TkaGg+cuMjJAADPDrpPnGJbtOsVw79lr
oKL///8zMrx894kRJMYIlgQp6li0leHDl28gaQYhiCIglxEsDpIHmg2WA2Fh
iDxICF2KF0xCHAYTY8atnAdEglWz4FbEDSJZIX7BqQiPm7hAJBNIPztuRZxw
l+BRBLafhQHuXgYkwIGsjQVFG8x6FrgdnMiKWdEVg81jwxKSeOyAuQBNB/vg
10EV76MEMZjFRUw08qAqAuYdUNZAzgTgnAISB8kDsxXunASSZCAuTzICAH0W
oCw=\
\>"], "Graphics",
       Evaluatable->False,
       ImageSize->{23, 23},
       ImageMargins->{{0, 0}, {0, 0}},
       ImageRegion->{{0, 1}, {0, 1}}], TraditionalForm]]]]], 
    RowBox[{"zoom", " ", "mode"}], Cell["\<\
In zoom mode,
\[Bullet] Dragging the mouse shows a rectangle which will become the new \
range. The default behavior is to use a rectangle which preserves the aspect \
ratio of the current graph. Pressing the control key while dragging changes \
to a rectangle which can change the aspect ratio.
\[Bullet] Shift-drag shows a rectangle which the edges of the current plot \
region will be mapped to (zoom out).
\[Bullet] Control-drag (right drag) pans.
Dragging the zoom mode button opens a menu which allows you to select zoom to \
fit or scale to fit. Zoom to fit finds a plot range in which all of the \
trajectories fit, preserving aspect ratio. Scale to fit finds the smallest \
plot range in which all of the trajectories fit.\
\>", "TableText"]},
   {
    RowBox[{Cell[""], Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwiIOwAgOI/R/IhBHM
IIrh9NVrDDPW72MQZKiasZ6RoW/5TkaGg+cuMjJAADPDrpPnGJbtOsVw79lr
oKL///8zMrx894kRJMYIlgQp6li0leHDl28gaQYhiCIglxEsDpIHmg2WA2Fh
iDxIiDpS7GAS4h2YGCdu5WwgEqyaC7ciVhDJClKExyQSLWaGmoysHIQh4Yxp
FCtuo5hAJBNCIwu6oWA5NmQDWFAMAGJekBLq2kEz/5IY0kTFHlHpgESL0VIp
MDeBMgtytgDnHZA4SB6Y0XDnLZAkA3G5lBEADRm1Fw==\
\>"], "Graphics",
      Evaluatable->False,
      ImageSize->{23, 23},
      ImageMargins->{{0, 0}, {0, 0}},
      ImageRegion->{{0, 1}, {0, 1}}]}], 
    RowBox[{"pan", " ", "mode"}], Cell["\<\
Mouse buttons pans selected point to center. Dragging pans interactively.
Right-click or control-click zooms.\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, 
     AbsoluteThickness[0.5], {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {
     Scaled[0.1], 
     Scaled[0.2], {
      Scaled[0.7]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->27344],

Cell["Modes chosen from the trek toolbar.", "Caption",
 CellID->2980],

Cell[TextData[{
 "The parameter panel allows you to modify any parameters you have specified \
using the ",
 Cell[BoxData[
  ButtonBox["TrekParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/TrekParameters"]], 
  "InlineFormula"],
 " option."
}], "Text",
 CellID->12447],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1PE0EUf+xsW9r4FwCVxqsffwQaJBL8BzzVCsLBQJCoB4kHD/h9EBVb
IcaQcDFAINHERBEtopGgiSCBAIkHLygo5cMSDtSZ2W33o293x0ILMbvJzgzz
3u+9t2/evHkdasIt9bXnwi0NkXDoeHO4qb4hcj5U2dhMp0gRAHTTty8EbJyi
Q7XphsWFaUbcA91J3hFoi/VA650oXLx2F2TeErh0vR2ar97mHNUKew3vZHg8
OASR/guw/2kZlHWVECiNldDp0kclfFTTdoohTaD+1x+g8uMxODAUgvL+IIHy
viCdLu8NQvBJKQdSlQYQgWcj45BMrsH6+grlXV39TdtEYglmZ6dhZOQNM9UG
4eEIAnNzMxCPD/MP+w/YfSr75MRniL99BalUCo7y1llEhcq3sUF51n5xSV6j
2M7OKExNfYXlpW9ULGtFxCp8yT8J2NxMYmIfdtyDxZ/fYSWxQMWyVkSswre6
8gO2trYwsYMDvfBp/H1OYhFri1Wxw8MvoYs6gr0VvBURq/Ahvt1T8WPHPj8/
A6Oj8Wx2GZ6/G4emqUY4M3EaToxVEagaq6TT6T3NkgHNISbQ0NgE9HwZ4MCz
k3UE6iZr6XSEymBAlkVo8qk2piMGYtqYgTJvCU8fLO/o0pExl+1jXQdc6Xqh
jimI/cHinb3trC0qDJ0wusTSPbWfW6c9xAErqZ5jDxupcIJMU/4jDEkUBmVn
80MmlVKVAxNoYCEKwcjMXozPcmTCWsozzQlI5iNflkM8hi9P+xRzFgUd5so8
BtVpn3gsTfWh/Ome2MgkwngiOCcbZNHHK+hh8U8RNQVZ6fysjNfRw0gw2fKL
R0AeVgLj2ynPp5OI3rsWGcLO4z78C3fP2bnLyKyCjCFy9bOM+NkusvmsHzUX
1KwrZUaW+Vf7Dg0h5bQ5/nUNzd4BfVLWzNKnZ+wsPIgoDwi632xkNr99cjN7
30qPpG5S/ZwO4xXbGlqw2VsVEPIYvjSygHzR4JY0Aq5sp84UDSebcZKjf7Om
c3GBeS9jbj+UCW5vZoTVIwL1kmWtxec8Vh+XpolKc9p6hSxzhehqSe5eWLgX
Fu6FBbgXFu6Fhdr5WRdTsqMfyaQPdJk033T+20E9aew5JaQilhFMq/HssiyH
TQRvDqouO9ZO4mVzln7Zyin50mr9064w+uVMKEgF1IoFqLMuP0oz98Xb1mNT
KksiGrTNoJWZTtG/2ylBiB5zizu3uHOLO7e4c4s7Yy4LsC6qZMcAkknv6zKp
Ex27hMQqgt3AeBAMVjfczJx7PjNasqqwbticvV4bG6xqF1F5krpX9N+kk70d
0do/Bi1ukW8JCsJiRtSIncbia7vdqC8IPSpcv0DRX/Tj6Vk=\
\>"], "Graphics",
 Evaluatable->False,
 ImageSize->{163, 174},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[15]:=",
 CellID->12919],

Cell["\<\
Any parameter value can be modified either by using the slider or by typing \
the desired value into the text field and entering it. \
\>", "Text",
 CellID->1286],

Cell["\<\
The conditions panel typically reflects the starting position (and if \
applicable) the starting independent variable value.\
\>", "Text",
 CellID->17856],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWt1rHFUUP5mvTfOlLYIvCkHwv/BZReij4Jtug6bFqk3Mg1CqIoUW7IMg
Kj4IxRAofkFAKj6UCj4I9SOIbdXme5Nsk93NbnY32Ww3X55z53MnZ2ZnJjdN
W7sw99459845v3M/zvnN7h5NDx1/9Y300Im+dO9zg+lTx0/0vd377FuDKFLb
AGAUr5d7gdo72LSKUSgs/UOdolKo+hZ2dnYUj+AbGBn+rI2kbXTb5ukClfqo
S9xdYmTyhj9F5Sl474sfwYDl3C0oLU9DtXwbamvLsF4rQb22okF9fUWFRqOm
UgvovgJ36hWsy/jAFKe4lU2UkVGS0XVSlLqQ5bLXxYgzn38NT790FroAnhlC
q48ffRdOXhiBtdU8QitKtrowOwb95y7CCwMfw/B335NV/Ggw+sNleP7Nj+D1
D4fJckyrR6hUSFNPC/tzU78JD6/+cg0y0zcd++N//w6Xr1wRfdVyNqb9w6LU
hC5qiYEA3YFgNAvMr2LSC3k0mM8voLiAJd7al/BJFXeGGLG0OAvzmVswM3ld
PFouZmJi7RKl4cdq1/Yj3u7OiH6srOR1LHKaiRpbOOul4iLkBOp/zUHFWRZX
CGRzHnUvTKeOivcYlWJYStyrTcgVKJcLhDhvmEqxRdhLS5DPzcFCZtzCPhMX
ew+/NaLCTlt7V4Q8S0YXfQzWkUplWXjTbo3BpvCmkJ+H7NyE7ce970ZRR+zL
ink+sQW0twrihGTnJve0HoqDPTBoxEe8ulrSoVotWoixhY/jakBxOQuLC1NJ
EXc7OCkSeLb/o1Jgr62VdcS+YsHGFpAbJXFwl7IzSWFzmSA+ulqtqmNRsdBh
Cx9HyFDG4JLHsHLA6FYJXdVBVxXoKoguj+gyMtH5A1hz6K3X1w0sahYSbCGS
9fU1TGZFZBxZmUi40N9oNAws7lj2sYX2G406JvMK2s3Jt2/KMpP2WmxtbaJs
c3MTrw1xKVQKQLq412BjowE1BERPIAXbh7kgJnX1jwkDtre3LdPYwgHb21vY
MS4GIAOUTKvI9OlPLsGLZ76En8YmUSqYsLBvArwxvSh6T3/6FeRu35BN62bG
IJv5U2Dwk8n+8xdhcf4vupJYNWmzSqCFGVrxFMxOXFNh8ubPKrXQEElpEmhE
fPf2l/3fhXeLszRJEtb0fc+a2vncfkYJVqU6KepJyUo93II+HQzf0Bzj/ie8
WiQA0hn1qSBAu7kSh06Rh85g1Os8Ej9rC2JyiqXEK6OLkH2wB5SKmVHp/tAu
5V5QScH1OblSDcnpWvMoT27d8+SbkTcIdCQaHebfsZZMhe9Trcxp93EyM108
GLPQ7JXOyA7Ke98biC7RTYVKzdQqzTndgep7CeGCXcDQ1F3b0ZD4IHcEYKTP
Iwnxa4GnLsWOt+uOvbjA5xmvrDNknDcfvRLimsszwwKtwuzDhOsTBtorO8TI
OCqQ9kV+5ii5GULz7kYJwB9jACXM/hLJ3P9DVRLGfE/x/vvwNcFl6k9IVupL
u4Gs3E27vl5DHiCOiPtBurJILEiXh46bmoh8zJXx+VHiHKacxTKDdpzXhOjg
+pvDuy9Fa5JTl3/mgxY7dDWiO/daq7QdgQnf/54GEuQD8NTH+YNjQnT3AkmL
T5aQtLhv61YI8q0UuF/8+Lh+WBCM6lx7hL6YDnUxsDhZMqit10FPBrubgcjR
fC5PhMHWWvZJgd/DQG1nZOEx2nBaYmZ193gfOJl8qOoh8X4Qh4sDqTrRXXXT
G5+d3eTmyxd2rYCb+TwKoikWo4bieWDCSLFK7Zr7oYGTebzT/Eo4rhxVL/fD
wEA8N4O5RFLXo/3bJo5LHC8ajO6mmY3M0gtrbyu8H27a+2PAQhvknCF6OG+a
/53l6WffXx1Z7L2pNckiOm6u2wjzx0ruSzfdd753mQykkBrjTRRdYsA7pjjs
69zDIX0XzFano+9IjN1C1zmzd7R1BW3/ASltP7k=\
\>"], "Graphics",
 Evaluatable->False,
 ImageSize->{177, 95},
 ImageMargins->{{43, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"From In[23]:=",
 CellID->22607],

Cell[TextData[{
 "You can change any of the values by moving the trek position graphically or \
by typing in the desired position and entering it.\nThe ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["", Cell[GraphicsData["CompressedBitmap", "\<\
eJx1k81rE1EUxU8+Rl10Kbjtxv/CtYrQpeA2FGmL37W7UleCgi4EUXBXLIIo
CILUVangQqgfRWyrtk2aTJppMpNMZibJZDpNE899M9FW4+LeOfPe+d135715
I5mp8YtXMlMTo5nhM5OZ6+MTozeHT1+b5FAqAeC4xDBE9yj76Qhq5jrqtS00
3B34rRrafh2B76QRtJ0UwtBPiYJkD7uBx6eLBJEcC6RhGiuoVn5g5slLnLxw
ewg4NUXziZFbuHz/GVpNi+a2bytzqbCMsTuzOHfjIeZevRmSHmh+/XYeZ68+
wKV7czQLIuZi7pMqs/hhCfrWWt+88f0z5hcW1FSCXRtqtJj7qFauWgaSsKwS
C1SZ5T2OZMTLm6YclXIB2/o68tkVxSbg2vqhao5j0es4ZjpiqVi3bpdhKvan
uBJw7ELccYS5blVC/NYRIZOqEsl6BZZZREnf6JP5Q6Tn1SSSgh9TH6ypaoJX
rW0Yxc241X9JW0LsNfWlaVHMjlNVO2EUs4PXbDbrEhoaDTsmqZilGbtmoFzK
DSZbLVdCI+7EJJXi62qXKkZ+MOn7DQmNyYtJKmYp6XKXLe7vf8imhJCN32RD
kR5Ji6R+kPxzmEHQ5u8eBH6MUTG32y3+RDavgTEYC8OQWBjuxhiVygF/VI9u
8yCmQc9G2P5+R0Wn06G909lLRqdJxeJ7eyF84tFZyvXrL8k7hMUvm1yy2+3G
DBVnu919zmwoR0Jd2/6+TD96jvMzT/FuOauh1+vFGBWx1a2ympx+/IKYubMa
3cT8Mgz9q0L/urZjd2dR3v5Gs2TpSyAB5NuOorC5lEJ27X1KFGdlVLoQR3+B
xC8wePil\
\>"], "Graphics",
     Evaluatable->False,
     GeneratedCell->False,
     CellAutoOverwrite->False,
     ImageSize->{20, 20},
     ImageMargins->{{0, 0}, {0, 0}},
     ImageRegion->{{0, 1}, {0, 1}},
     GridBoxOptions->{
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.4], {
          Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}}]], 
   TraditionalForm]],
  GridBoxOptions->{
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.4], {
       Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{
   "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
    "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}}],
 " ",
 "button allows you to change the default value of the starting value of the \
independent variable for newly created treks."
}], "Text",
 CellID->26782],

Cell[TextData[{
 "When there is an independent variable, the independent range panel is \
displayed.\n",
 Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1rJEUUf9Nfs8H1oB4UveTiPyHiMVExeBK8xhh247drDsKyehEU9CCI
igdhMSwsfkFAVjwsK3gQdtUg7q66yeRjksxOpud7Mh87SSa+V1096WlfZ7p7
ukeEGajq6lev6v1+r6aq3ptkanr+9OzL0/NzM9Pjk2emXzs9N/PG+MSrZ1Ck
JgBgEcvkOFD7EJuyWoT8zl/UKR4KPb6Bw8NDxSH4Gi4sfJogaYJeE44uUKmP
usTbRUYWnfqDVL8Jb3/+AxhQyN2CUmENapXb0KgXoNkoQatR1qDVLKvQbjdU
agG9V+FOq4rPCg5Y5SbuZxNlZJRkVOZFrQtZLnNdaJz77Ct4+Nl34CTAo/No
9f6pt+ClDy5AfddEaMWIrW5vLMGpd8/Dk69/BAvffkdW8aPB4veX4PFXPoQX
318gyxFb3Vz9RfC68vNVSK/d7Fpd/vNXuHT5suirVTIBrZ6gOimmUi0t+VEY
meoJUZMQr4kFyJsIwzS3UZzHGl/toshp8M0QGjvZDdhK34L11HUxtFJMB2Qw
Juq7BUAbrN+n5pNQuWzqWOU0Cz62cFFKxSzkBPy/LaXiBgvwGOyWQ7UuJolL
kcT8ULCndU7BrdOsqC09W6ZQLURJ2eskrUClkieypmEZwhbRLu2AmduE7fSy
pL0elLbmwnzEQ/fmqDhWzNHJLeGs3DZOrlSs1fu3HzSWfbVaEC44IXQNagoX
5M0tyGyu2OQDcteZ9dI9SUote9vExrSoI72CYhnHFtDXPS92b2YzFXadOa73
xsZid7ekQ61WlCywhVPiIkKxkIHs9upALMSk98WGvV6v6EigLLFjC4hLSRwy
O5n1gXaa+yin5z0MlRkX3CMKPD2DpdJo1HSsqpIKtnA48oMKnpomnpchqXD3
4/NWsBQS5y7hrHVx1gTOKuI0EWc6Spx+Dt/eG6fVahpYNSQ6bCG6ZrOOV3wR
o69MlOi4G6/dbhtY3ZH2sYX22+0WBjZVtJuL3r4lS6fs9Tk42EfZ/v4+lj1R
FKoFIF28a7C314YGAqIRGI7G4AuKKq/8tmJAp9ORprGFCp3OAXYsCwWMhiMP
9q7B2Y8vwjPnvoAfl1Iotb/ougR4Yy0res9+8iXkbt+IOsRdX4JM+neBwR1Y
n3rvPGS3/qASxqqVQqgEWpihFU/CxspVFVI3f1KphYZISk4gjeD04s2ERnnW
/znPEhnPSdeV6BVfxZ+AjckYw76YnU93bM/JqCieyP/DvOzY3GY4fONK20Ll
L2D0yBxtLoV5wRUdDCs1Oz490VzbxukMJ/q5wNHY8JItLgEJgzfGlElMOsZg
T0aCPa5EKVCyERx2XDkSdw0FRzfMtCcMuuElO+6ja5TYjBKbUWIzSmziVX+A
uS4f6cYsTw8+2WOM7KkQF6QrblSZabmfurGo3TjMEVbLj+pS0HsmtBU9f0jv
HWywg+2hbhYWYn8sQhB+Inofu1zRG6x4OJjLTbh5Q9jqP4Heb01Zf/a35RsY
lYl4FsKbb5LlG0RnsLmP83dwu5wswPlhRRLWFdlnR3nJuOyN+1b41RvEhu7a
ZVIuuA1sXyhPSJd5+dYQPW4rwO/06E4LX6pRmBMePkrd+xzqA58Ok+y/qYwx
ePPOv2dGcNXxCv0n1t3jjlj5veIGQjHldFHvvJzsIUZ2F4vJH/bnYjQvXDtr
GVjs/4DEP3ZWDbk=\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{177, 71},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}], "Text",
 CellID->19756],

Cell[TextData[{
 "Entering values allows you to change the range of independent variable \
values for a selected trek.",
 " ",
 "Using the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["", Cell[GraphicsData["CompressedBitmap", "\<\
eJx1k81rE1EUxU8+Rl10Kbjtxv/CtYrQpeA2FGmL37W7UleCgi4EUXBXLIIo
CILUVangQqgfRWyrtk2aTJppMpNMZibJZDpNE899M9FW4+LeOfPe+d135715
I5mp8YtXMlMTo5nhM5OZ6+MTozeHT1+b5FAqAeC4xDBE9yj76Qhq5jrqtS00
3B34rRrafh2B76QRtJ0UwtBPiYJkD7uBx6eLBJEcC6RhGiuoVn5g5slLnLxw
ewg4NUXziZFbuHz/GVpNi+a2bytzqbCMsTuzOHfjIeZevRmSHmh+/XYeZ68+
wKV7czQLIuZi7pMqs/hhCfrWWt+88f0z5hcW1FSCXRtqtJj7qFauWgaSsKwS
C1SZ5T2OZMTLm6YclXIB2/o68tkVxSbg2vqhao5j0es4ZjpiqVi3bpdhKvan
uBJw7ELccYS5blVC/NYRIZOqEsl6BZZZREnf6JP5Q6Tn1SSSgh9TH6ypaoJX
rW0Yxc241X9JW0LsNfWlaVHMjlNVO2EUs4PXbDbrEhoaDTsmqZilGbtmoFzK
DSZbLVdCI+7EJJXi62qXKkZ+MOn7DQmNyYtJKmYp6XKXLe7vf8imhJCN32RD
kR5Ji6R+kPxzmEHQ5u8eBH6MUTG32y3+RDavgTEYC8OQWBjuxhiVygF/VI9u
8yCmQc9G2P5+R0Wn06G909lLRqdJxeJ7eyF84tFZyvXrL8k7hMUvm1yy2+3G
DBVnu919zmwoR0Jd2/6+TD96jvMzT/FuOauh1+vFGBWx1a2ympx+/IKYubMa
3cT8Mgz9q0L/urZjd2dR3v5Gs2TpSyAB5NuOorC5lEJ27X1KFGdlVLoQR3+B
xC8wePil\
\>"], "Graphics",
     Evaluatable->False,
     GeneratedCell->False,
     CellAutoOverwrite->False,
     ImageSize->{20, 20},
     ImageMargins->{{0, 0}, {0, 0}},
     ImageRegion->{{0, 1}, {0, 1}},
     GridBoxOptions->{
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.4], {
          Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}}]], 
   TraditionalForm]],
  GridBoxOptions->{
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.4], {
       Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{
   "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
    "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}}],
 " button allows you to change the default values for newly created treks."
}], "Text",
 CellID->22212]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EquationTrekker Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 31.0829000}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Equation Trekker Package Tutorial", "language" -> "en", "paclet" -> 
    "EquationTrekker Package", "status" -> "None", "summary" -> 
    "This package provides an interactive tool for investigating the \
solutions of differential equations as well as other types of equations that \
have solutions that can be viewed as paths or trajectories. Mathematica \
provides a general tool, NDSolve, for finding numerical solutions of \
differential equations. The ability to simply specify differentiation \
equations in mathematical form gives a great deal of convenience over FORTRAN \
and C++ solver packages. However, for low dimensional systems, an additional \
level of interactivity can be achieved with a graphical user interface. \
EquationTrekker allows you to give the equation, optionally with parameters, \
and then it opens a window that allows you to specify initial conditions \
simply by using the mouse. This loads the package.", "synonyms" -> {}, 
    "title" -> "EquationTrekker Package", "type" -> "Tutorial", "uri" -> 
    "EquationTrekker/tutorial/EquationTrekker"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1047, 24, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1672, 51, 56, 1, 70, "Title",
 CellID->20031],
Cell[1731, 54, 244, 5, 70, "Text",
 CellID->12958],
Cell[1978, 61, 908, 22, 70, "Text",
 CellID->11183],
Cell[2889, 85, 61, 1, 70, "MathCaption",
 CellID->1508],
Cell[2953, 88, 104, 3, 70, "Input",
 CellID->16186],
Cell[CellGroupData[{
Cell[3082, 95, 44, 1, 70, "Section",
 CellID->12997],
Cell[3129, 98, 966, 30, 70, "DefinitionBox",
 CellID->21299],
Cell[4098, 130, 128, 4, 70, "Caption",
 CellID->13224],
Cell[4229, 136, 302, 10, 70, "Text",
 CellID->29754],
Cell[4534, 148, 427, 14, 70, "Input",
 CellID->22308],
Cell[4964, 164, 124, 4, 70, "Text",
 CellID->8500],
Cell[5091, 170, 30239, 500, 70, "Graphics",
 Evaluatable->False,
 CellID->2186],
Cell[35333, 672, 2141, 56, 70, "Text",
 CellID->26667],
Cell[37477, 730, 567, 15, 70, "MathCaption",
 CellID->5578],
Cell[CellGroupData[{
Cell[38069, 749, 427, 14, 70, "Input",
 CellID->16150],
Cell[38499, 765, 17949, 324, 518, "Output",
 CellID->331879057]
}, Open  ]],
Cell[56463, 1092, 874, 20, 70, "Text",
 CellID->26695],
Cell[57340, 1114, 2210, 69, 70, "DefinitionBox",
 CellID->26809],
Cell[59553, 1185, 64, 1, 70, "Caption",
 CellID->7603],
Cell[59620, 1188, 323, 10, 70, "MathCaption",
 CellID->20487],
Cell[CellGroupData[{
Cell[59968, 1202, 139, 4, 70, "Input",
 CellID->10419],
Cell[60110, 1208, 13553, 250, 502, "Output",
 CellID->190739054]
}, Open  ]],
Cell[73678, 1461, 219, 5, 70, "Text",
 CellID->15999],
Cell[73900, 1468, 1032, 24, 70, "Text",
 CellID->16370],
Cell[74935, 1494, 586, 18, 70, "Input",
 CellID->3322],
Cell[75524, 1514, 101, 3, 70, "Text",
 CellID->23467],
Cell[75628, 1519, 30768, 508, 70, "Graphics",
 Evaluatable->False,
 CellID->4199]
}, Open  ]],
Cell[CellGroupData[{
Cell[106433, 2032, 44, 1, 70, "Section",
 CellID->2357],
Cell[106480, 2035, 828, 26, 70, "Text",
 CellID->11639],
Cell[107311, 2063, 163, 4, 70, "Text",
 CellID->22942],
Cell[107477, 2069, 408, 12, 70, "MathCaption",
 CellID->31642],
Cell[CellGroupData[{
Cell[107910, 2085, 969, 30, 47, "Input",
 CellID->3780],
Cell[108882, 2117, 25316, 419, 545, "Output",
 Evaluatable->False,
 CellID->329319113]
}, Open  ]],
Cell[134213, 2539, 283, 6, 70, "Text",
 CellID->3559],
Cell[134499, 2547, 245, 5, 70, "MathCaption",
 CellID->1020],
Cell[CellGroupData[{
Cell[134769, 2556, 139, 4, 28, "Input",
 CellID->16851],
Cell[134911, 2562, 24087, 399, 545, "Output",
 Evaluatable->False,
 CellID->23772778]
}, Open  ]],
Cell[159013, 2964, 145, 4, 70, "Text",
 CellID->8339],
Cell[159161, 2970, 546, 18, 70, "DefinitionBox",
 CellID->17555],
Cell[159710, 2990, 60, 1, 70, "Caption",
 CellID->29030],
Cell[159773, 2993, 269, 5, 70, "MathCaption",
 CellID->16039],
Cell[CellGroupData[{
Cell[160067, 3002, 1089, 35, 47, "Input",
 CellID->16676],
Cell[161159, 3039, 50912, 839, 674, "Output",
 Evaluatable->False,
 CellID->113045259]
}, Open  ]],
Cell[212086, 3881, 130, 4, 70, "Text",
 CellID->14858],
Cell[212219, 3887, 529, 13, 70, "Text",
 CellID->28903]
}, Open  ]],
Cell[CellGroupData[{
Cell[212785, 3905, 60, 1, 70, "Section",
 CellID->17110],
Cell[212848, 3908, 522, 14, 70, "Text",
 CellID->17766],
Cell[213373, 3924, 144, 4, 70, "Text",
 CellID->205],
Cell[213520, 3930, 110, 3, 70, "MathCaption",
 CellID->16575],
Cell[CellGroupData[{
Cell[213655, 3937, 1268, 37, 65, "Input",
 CellID->14370],
Cell[214926, 3976, 71457, 1175, 496, "Output",
 Evaluatable->False,
 CellID->588078941]
}, Open  ]],
Cell[286398, 5154, 144, 4, 70, "Text",
 CellID->3963],
Cell[286545, 5160, 964, 22, 70, "Text",
 CellID->2219],
Cell[287512, 5184, 627, 17, 70, "MathCaption",
 CellID->31667],
Cell[CellGroupData[{
Cell[288164, 5205, 1824, 52, 119, "Input",
 CellID->257],
Cell[289991, 5259, 22450, 372, 499, "Output",
 Evaluatable->False,
 CellID->101374129]
}, Open  ]],
Cell[312456, 5634, 519, 9, 70, "Text",
 CellID->7555],
Cell[312978, 5645, 184, 4, 70, "Text",
 CellID->24515],
Cell[313165, 5651, 1197, 30, 70, "DefinitionBox3Col",
 CellID->21695],
Cell[314365, 5683, 246, 9, 70, "Caption",
 CellID->13635],
Cell[314614, 5694, 599, 20, 70, "Text",
 CellID->15677],
Cell[315216, 5716, 669, 20, 70, "Text",
 CellID->12528],
Cell[315888, 5738, 122, 3, 70, "MathCaption",
 CellID->23136],
Cell[316013, 5743, 166, 6, 70, "Input",
 CellID->6700],
Cell[316182, 5751, 194, 4, 70, "MathCaption",
 CellID->2404],
Cell[CellGroupData[{
Cell[316401, 5759, 949, 31, 70, "Input",
 CellID->18199],
Cell[317353, 5792, 1629, 54, 81, "Output",
 CellID->1003842279]
}, Open  ]],
Cell[318997, 5849, 782, 32, 70, "MathCaption",
 CellID->20528],
Cell[CellGroupData[{
Cell[319804, 5885, 1017, 26, 83, "Input",
 CellID->2507],
Cell[320824, 5913, 29119, 481, 702, "Output",
 Evaluatable->False,
 CellID->245610449]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[349992, 6400, 67, 1, 70, "Section",
 CellID->28226],
Cell[350062, 6403, 879, 24, 70, "Text",
 CellID->28073],
Cell[350944, 6429, 2048, 63, 70, "DefinitionBox",
 CellID->2975],
Cell[352995, 6494, 66, 1, 70, "Caption",
 CellID->19434],
Cell[353064, 6497, 951, 31, 70, "Text",
 CellID->12404],
Cell[354018, 6530, 1027, 29, 70, "Text",
 CellID->30403],
Cell[355048, 6561, 589, 18, 70, "Text",
 CellID->23421],
Cell[355640, 6581, 3663, 114, 70, "DefinitionBox",
 CellID->3085],
Cell[359306, 6697, 69, 1, 70, "Caption",
 CellID->3344],
Cell[359378, 6700, 455, 12, 70, "Text",
 CellID->1311],
Cell[359836, 6714, 528, 15, 70, "Text",
 CellID->21022],
Cell[CellGroupData[{
Cell[360389, 6733, 53, 1, 70, "Subsection",
 CellID->6221],
Cell[360445, 6736, 458, 12, 70, "Text",
 CellID->6183],
Cell[360906, 6750, 688, 22, 70, "MathCaption",
 CellID->21397],
Cell[361597, 6774, 105, 3, 70, "Input",
 CellID->6601],
Cell[361705, 6779, 496, 13, 70, "MathCaption",
 CellID->8550],
Cell[362204, 6794, 514, 12, 70, "Input",
 CellID->28886],
Cell[362721, 6808, 259, 8, 70, "Input",
 CellID->12514],
Cell[362983, 6818, 173, 4, 70, "MathCaption",
 CellID->535],
Cell[363159, 6824, 274, 9, 70, "Input",
 CellID->17689],
Cell[363436, 6835, 182, 4, 70, "MathCaption",
 CellID->22564],
Cell[363621, 6841, 292, 9, 70, "Input",
 CellID->19196],
Cell[363916, 6852, 637, 23, 70, "MathCaption",
 CellID->28153],
Cell[364556, 6877, 323, 10, 70, "Input",
 CellID->21540],
Cell[364882, 6889, 358, 11, 70, "MathCaption",
 CellID->12077],
Cell[365243, 6902, 400, 11, 70, "Input",
 CellID->17571],
Cell[365646, 6915, 494, 16, 70, "MathCaption",
 CellID->25340],
Cell[366143, 6933, 760, 21, 70, "Input",
 CellID->13425],
Cell[366906, 6956, 278, 6, 70, "MathCaption",
 CellID->8321],
Cell[367187, 6964, 587, 18, 70, "Input",
 CellID->18745],
Cell[367777, 6984, 265, 9, 70, "MathCaption",
 CellID->7628],
Cell[CellGroupData[{
Cell[368067, 6997, 755, 22, 47, "Input",
 CellID->13198],
Cell[368825, 7021, 22849, 379, 658, "Output",
 Evaluatable->False,
 CellID->210416485]
}, Open  ]],
Cell[391689, 7403, 494, 10, 70, "Text",
 CellID->30919]
}, Open  ]],
Cell[CellGroupData[{
Cell[392220, 7418, 55, 1, 70, "Subsection",
 CellID->4819],
Cell[392278, 7421, 564, 15, 70, "Text",
 CellID->20471],
Cell[392845, 7438, 416, 14, 70, "MathCaption",
 CellID->23901],
Cell[CellGroupData[{
Cell[393286, 7456, 77, 2, 70, "Input",
 CellID->29350],
Cell[393366, 7460, 370, 11, 36, "Output",
 CellID->1742598806]
}, Open  ]],
Cell[393751, 7474, 905, 25, 70, "Text",
 CellID->27380],
Cell[394659, 7501, 361, 9, 70, "Text",
 CellID->11021]
}, Open  ]],
Cell[CellGroupData[{
Cell[395057, 7515, 58, 1, 70, "Subsection",
 CellID->31205],
Cell[395118, 7518, 395, 11, 70, "Text",
 CellID->19242],
Cell[395516, 7531, 247, 8, 70, "MathCaption",
 CellID->7268],
Cell[CellGroupData[{
Cell[395788, 7543, 3966, 117, 70, "Input",
 CellID->7752],
Cell[399757, 7662, 182, 5, 36, "Output",
 CellID->476154656]
}, Open  ]],
Cell[399954, 7670, 938, 24, 70, "Text",
 CellID->15818],
Cell[400895, 7696, 744, 24, 70, "Text",
 CellID->24471],
Cell[401642, 7722, 272, 8, 70, "MathCaption",
 CellID->7342],
Cell[401917, 7732, 1353, 43, 70, "Input",
 CellID->2782]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[403319, 7781, 55, 1, 70, "Section",
 CellID->26913],
Cell[403377, 7784, 200, 5, 70, "Text",
 CellID->18514],
Cell[403580, 7791, 110, 3, 70, "Text",
 CellID->8067],
Cell[403693, 7796, 1192, 24, 70, "Graphics",
 Evaluatable->False,
 CellID->21394],
Cell[404888, 7822, 179, 4, 70, "Text",
 CellID->692],
Cell[405070, 7828, 4997, 106, 70, "DefinitionBox3Col",
 CellID->27344],
Cell[410070, 7936, 69, 1, 70, "Caption",
 CellID->2980],
Cell[410142, 7939, 297, 10, 70, "Text",
 CellID->12447],
Cell[410442, 7951, 1608, 30, 70, "Graphics",
 Evaluatable->False,
 CellID->12919],
Cell[412053, 7983, 172, 4, 70, "Text",
 CellID->1286],
Cell[412228, 7989, 164, 4, 70, "Text",
 CellID->17856],
Cell[412395, 7995, 2209, 40, 70, "Graphics",
 Evaluatable->False,
 CellID->22607],
Cell[414607, 8037, 2384, 55, 70, "Text",
 CellID->26782],
Cell[416994, 8094, 2033, 39, 70, "Text",
 CellID->19756],
Cell[419030, 8135, 2315, 55, 70, "Text",
 CellID->22212]
}, Open  ]]
}, Open  ]],
Cell[421372, 8194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

