(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4782,        166]
NotebookOptionsPosition[      3214,        118]
NotebookOutlinePosition[      4297,        147]
CellTagsIndexPosition[      4254,        144]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EXPERIMENTAL PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Compile" :> Documentation`HelpLookup["paclet:ref/Compile"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Compile\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CompileEvaluate", "ObjectName",
 CellID->12472],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CompileEvaluate", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]compiles ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " and then evaluates the resulting compiled code. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24450]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"CompileEvaluate", "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " always evaluates to the same result as ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " alone, but is faster for certain types of expressions, particularly ones \
representing large numerical computations. "
}], "Notes",
 CellID->17241]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17929],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Compile",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Compile"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->8695]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CompileEvaluate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 38.3799618}", "context" -> 
    "Experimental`", "keywords" -> {"CompileEvaluate"}, "index" -> True, 
    "label" -> "Experimental Package Symbol", "language" -> "en", "paclet" -> 
    "Experimental Package", "status" -> "None", "summary" -> 
    "CompileEvaluate[expr] compiles expr and then evaluates the resulting \
compiled code. ", "synonyms" -> {}, "title" -> "CompileEvaluate", "type" -> 
    "Symbol", "uri" -> "Experimental/ref/CompileEvaluate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 553, 14, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1176, 41, 53, 1, 70, "ObjectName",
 CellID->12472],
Cell[1232, 44, 498, 15, 70, "Usage",
 CellID->24450]
}, Open  ]],
Cell[CellGroupData[{
Cell[1767, 64, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2245, 81, 375, 10, 70, "Notes",
 CellID->17241]
}, Closed]],
Cell[CellGroupData[{
Cell[2657, 96, 311, 9, 70, "SeeAlsoSection",
 CellID->17929],
Cell[2971, 107, 201, 6, 70, "SeeAlso",
 CellID->8695]
}, Open  ]],
Cell[3187, 116, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

