(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6734,        243]
NotebookOptionsPosition[      5145,        193]
NotebookOutlinePosition[      6193,        222]
CellTagsIndexPosition[      6150,        219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EXPERIMENTAL PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Implies" :> Documentation`HelpLookup["paclet:ref/Implies"], 
         "ImpliesRealQ" :> 
         Documentation`HelpLookup["paclet:Experimental/ref/ImpliesRealQ"], 
         "FullSimplify" :> 
         Documentation`HelpLookup["paclet:ref/FullSimplify"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Implies\"\>", 
      2->"\<\"ImpliesRealQ\"\>", 
      3->"\<\"FullSimplify\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ImpliesQ", "ObjectName",
 CellID->4982],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ImpliesQ", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["expr", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]tests whether the expression ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " implies ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18238]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ImpliesQ"], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if it cannot determine whether ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " implies ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ", using any of its built\[Hyphen]in transformation rules. "
}], "Notes",
 CellID->24122],

Cell[TextData[{
 "The related function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Implies",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Implies"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " remains unevaluated if it cannot immediately determine whether ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " implies ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17723]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12351],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Implies",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Implies"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImpliesRealQ",
    BaseStyle->"Link",
    ButtonData->"paclet:Experimental/ref/ImpliesRealQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6923]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImpliesQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 38.8487238}", "context" -> 
    "Experimental`", "keywords" -> {"ImpliesQ"}, "index" -> True, "label" -> 
    "Experimental Package Symbol", "language" -> "en", "paclet" -> 
    "Experimental Package", "status" -> "None", "summary" -> 
    "ImpliesQ[expr_1, expr_2] tests whether the expression expr_1 implies \
expr_2. ", "synonyms" -> {}, "title" -> "ImpliesQ", "type" -> "Symbol", "uri" -> 
    "Experimental/ref/ImpliesQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 808, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1431, 46, 45, 1, 70, "ObjectName",
 CellID->4982],
Cell[1479, 49, 819, 28, 70, "Usage",
 CellID->18238]
}, Open  ]],
Cell[CellGroupData[{
Cell[2335, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2813, 99, 535, 19, 70, "Notes",
 CellID->24122],
Cell[3351, 120, 679, 26, 70, "Notes",
 CellID->17723]
}, Closed]],
Cell[CellGroupData[{
Cell[4067, 151, 311, 9, 70, "SeeAlsoSection",
 CellID->12351],
Cell[4381, 162, 722, 26, 70, "SeeAlso",
 CellID->6923]
}, Open  ]],
Cell[5118, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

