(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13225,        436]
NotebookOptionsPosition[      8595,        315]
NotebookOutlinePosition[     10906,        361]
CellTagsIndexPosition[     10863,        358]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Finite Fields Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["Plus",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Plus"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["Times",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Times"]], "InlineFunctionSans"],
 ", ",
 Cell[TextData[ButtonBox["D",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/D"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " operators overloaded by the Finite Fields Package"
}], "GuideText",
 CellID->174809529],

Cell["\t", "GuideDelimiter",
 CellID->3682752],

Cell[TextData[{
 Cell[TextData[ButtonBox["GF",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/GF"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " represent a Galois field using its characteristic and irreducible \
polynomial coefficients"
}], "GuideText",
 CellID->203374175],

Cell["\t", "GuideDelimiter",
 CellID->1594617216],

Cell[TextData[{
 Cell[TextData[ButtonBox["SetFieldFormat",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/SetFieldFormat"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " set the output form of elements in a field"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["FunctionOfCode",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/FunctionOfCode"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["FunctionOfCoefficients",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/FunctionOfCoefficients"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1091878491],

Cell["\t", "GuideDelimiter",
 CellID->587179783],

Cell[TextData[{
 Cell[TextData[ButtonBox["Characteristic",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/Characteristic"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " prime characteristic of a field"
}], "GuideText",
 CellID->1043254916],

Cell[TextData[{
 Cell[TextData[ButtonBox["ExtensionDegree",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/ExtensionDegree"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " extension degree of a field over its base field"
}], "GuideText",
 CellID->1928879104],

Cell[TextData[{
 Cell[TextData[ButtonBox["FieldIrreducible",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/FieldIrreducible"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " univariate irreducible polynomial associated with a field"
}], "GuideText",
 CellID->257965816],

Cell[TextData[{
 Cell[TextData[ButtonBox["IrreduciblePolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/IrreduciblePolynomial"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " univariate irreducible polynomial of a given degree"
}], "GuideText",
 CellID->2009469866],

Cell["\t", "GuideDelimiterSubsection",
 CellID->1832205140],

Cell[CellGroupData[{

Cell["Element Manipulation", "GuideFunctionsSubsection",
 CellID->1103773647],

Cell[TextData[{
 Cell[TextData[ButtonBox["Successor",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/Successor"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " next element in a canonical ordering of a field's elements"
}], "GuideText",
 CellID->1159942343],

Cell[TextData[{
 Cell[TextData[ButtonBox["ReduceElement",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/ReduceElement"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " element of a field in reduced form"
}], "GuideText",
 CellID->294411335],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToElementCode",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/ToElementCode"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " non-negative integer associated with a specified element in a field"
}], "GuideText",
 CellID->368984657],

Cell[TextData[{
 Cell[TextData[ButtonBox["FromElementCode",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/FromElementCode"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " element of a given field associated with a specified integer"
}], "GuideText",
 CellID->1739841310],

Cell[TextData[{
 Cell[TextData[ButtonBox["PolynomialToElement",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/PolynomialToElement"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " field element corresponding to given polynomial coefficients"
}], "GuideText",
 CellID->1375559618],

Cell[TextData[{
 Cell[TextData[ButtonBox["ElementToPolynomial",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/ElementToPolynomial"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " univariate polynomial corresponding to a given field element"
}], "GuideText",
 CellID->1369039771],

Cell["\t", "GuideDelimiter",
 CellID->1311637239],

Cell[TextData[{
 Cell[TextData[ButtonBox["FieldExp",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/FieldExp"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " value of the exponential function associated with a field for a given \
integer"
}], "GuideText",
 CellID->567514444],

Cell[TextData[{
 Cell[TextData[ButtonBox["FieldInd",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/FieldInd"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " power to which the primitive element must be raised to get a specified \
element"
}], "GuideText",
 CellID->1240383981],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowerList",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/PowerList"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " data parts of nonzero elements of a field"
}], "GuideText",
 CellID->1509807238],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowerListToField",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/PowerListToField"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " field object based on a list of the type produced by ",
 Cell[TextData[ButtonBox["PowerList",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/PowerList"]], "InlineFunctionSans"]
}], "GuideText",
 CellID->663476114],

Cell["\t", "GuideDelimiter",
 CellID->1307952774],

Cell[TextData[{
 Cell[TextData[ButtonBox["PowerListQ",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/PowerListQ"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PerfectPowerQ",
  BaseStyle->"Link",
  ButtonData->"paclet:FiniteFields/ref/PerfectPowerQ"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->2053124241]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/tutorial/FiniteFields"]], "GuideTutorial",
 CellID->353465802]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "GuideMoreAbout",
 CellID->366502975],

Cell[TextData[ButtonBox["Numerical Evaluation and Precision",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NumericalEvaluationAndPrecision"]], "GuideMoreAbout",
 CellID->252299663],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "GuideMoreAbout",
 CellID->253915192]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Finite Fields Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 39.3487366}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Guide", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "Plus, Times, D -- operators overloaded by the Finite Fields Package, GF \
-- represent a Galois field using its characteristic and irreducible \
polynomial coefficients, SetFieldFormat -- set the output form of elements in \
a field, Characteristic -- prime characteristic of a field, ExtensionDegree \
-- extension degree of a field over its base field, FieldIrreducible -- \
univariate irreducible polynomial associated with a field, \
IrreduciblePolynomial -- univariate irreducible polynomial of a given degree, \
Successor -- next element in a canonical ordering of a field's elements, \
ReduceElement -- element of a field in reduced form, ToElementCode -- \
non-negative integer associated with a specified element in a field, \
FromElementCode -- element of a given field associated with a specified \
integer, PolynomialToElement -- field element corresponding to given \
polynomial coefficients, ElementToPolynomial -- univariate polynomial \
corresponding to a given field element, FieldExp -- value of the exponential \
function associated with a field for a given integer, FieldInd -- power to \
which the primitive element must be raised to get a specified element, \
PowerList -- data parts of nonzero elements of a field, PowerListToField -- \
field object based on a list of the type produced by PowerList", 
    "synonyms" -> {}, "title" -> "Finite Fields Package", "type" -> "Guide", 
    "uri" -> "FiniteFields/guide/FiniteFieldsPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 63, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[685, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[744, 31, 499, 16, 70, "GuideText",
 CellID->174809529],
Cell[1246, 49, 46, 1, 70, "GuideDelimiter",
 CellID->3682752],
Cell[1295, 52, 316, 9, 70, "GuideText",
 CellID->203374175],
Cell[1614, 63, 49, 1, 70, "GuideDelimiter",
 CellID->1594617216],
Cell[1666, 66, 295, 9, 70, "GuideText",
 CellID->1463276848],
Cell[1964, 77, 469, 13, 70, "InlineGuideFunctionListing",
 CellID->1091878491],
Cell[2436, 92, 48, 1, 70, "GuideDelimiter",
 CellID->587179783],
Cell[2487, 95, 284, 9, 70, "GuideText",
 CellID->1043254916],
Cell[2774, 106, 302, 9, 70, "GuideText",
 CellID->1928879104],
Cell[3079, 117, 313, 9, 70, "GuideText",
 CellID->257965816],
Cell[3395, 128, 318, 9, 70, "GuideText",
 CellID->2009469866],
Cell[3716, 139, 59, 1, 70, "GuideDelimiterSubsection",
 CellID->1832205140],
Cell[CellGroupData[{
Cell[3800, 144, 77, 1, 70, "GuideFunctionsSubsection",
 CellID->1103773647],
Cell[3880, 147, 298, 8, 70, "GuideText",
 CellID->1159942343],
Cell[4181, 157, 284, 9, 70, "GuideText",
 CellID->294411335],
Cell[4468, 168, 317, 9, 70, "GuideText",
 CellID->368984657],
Cell[4788, 179, 315, 9, 70, "GuideText",
 CellID->1739841310],
Cell[5106, 190, 323, 9, 70, "GuideText",
 CellID->1375559618],
Cell[5432, 201, 323, 9, 70, "GuideText",
 CellID->1369039771],
Cell[5758, 212, 49, 1, 70, "GuideDelimiter",
 CellID->1311637239],
Cell[5810, 215, 316, 9, 70, "GuideText",
 CellID->567514444],
Cell[6129, 226, 318, 9, 70, "GuideText",
 CellID->1240383981],
Cell[6450, 237, 281, 8, 70, "GuideText",
 CellID->1509807238],
Cell[6734, 247, 444, 12, 70, "GuideText",
 CellID->663476114],
Cell[7181, 261, 49, 1, 70, "GuideDelimiter",
 CellID->1307952774],
Cell[7233, 264, 440, 12, 70, "InlineGuideFunctionListing",
 CellID->2053124241]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7722, 282, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[7787, 285, 165, 3, 70, "GuideTutorial",
 CellID->353465802]
}, Open  ]],
Cell[CellGroupData[{
Cell[7989, 293, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[8054, 296, 156, 3, 70, "GuideMoreAbout",
 CellID->366502975],
Cell[8213, 301, 185, 4, 70, "GuideMoreAbout",
 CellID->252299663],
Cell[8401, 307, 152, 3, 70, "GuideMoreAbout",
 CellID->253915192]
}, Open  ]],
Cell[8568, 313, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

