(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7932,        280]
NotebookOptionsPosition[      6126,        222]
NotebookOutlinePosition[      7180,        251]
CellTagsIndexPosition[      7137,        248]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FINITE FIELDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finite Fields Package" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/tutorial/FiniteFields"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finite Fields Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FieldInd" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/FieldInd"], 
          "PowerList" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/PowerList"], 
          "PowerListQ" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/PowerListQ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FieldInd\"\>", 
       2->"\<\"PowerList\"\>", 3->"\<\"PowerListQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FieldExp", "ObjectName",
 CellID->30833],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FieldExp", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the value of the discrete exponential of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " associated with the field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19711]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " a primitive element of the field ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", the value of the discrete exponential function of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["p", "TI"], 
   StyleBox["n", "TI"]]], "InlineFormula"],
 ". In particular, ",
 Cell[BoxData[
  RowBox[{"FieldExp", "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", "1"}], "]"}]], "InlineFormula"],
 " gives the primitive element used."
}], "Notes",
 CellID->25760],

Cell[TextData[{
 Cell[BoxData["FieldExp"], "InlineFormula"],
 " is defined only if ",
 Cell[BoxData[
  ButtonBox["PowerListQ",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerListQ"]], "InlineFormula"],
 " has been set ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for the field."
}], "Notes",
 CellID->18896],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FieldExp", "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"-", "\[Infinity]"}]}], "]"}]], "InlineFormula"],
 " gives 0."
}], "Notes",
 CellID->4667]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2695],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FieldInd",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FieldInd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerList",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/PowerList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerListQ",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/PowerListQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21624]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7285],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/tutorial/FiniteFields"]], "Tutorials",
 CellID->12550]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FieldExp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 46.9583064}", "context" -> 
    "FiniteFields`", "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Symbol", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "FieldExp[f, n] gives the value of the discrete exponential of n \
associated with the field f.", "synonyms" -> {}, "title" -> "FieldExp", 
    "type" -> "Symbol", "uri" -> "FiniteFields/ref/FieldExp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1446, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2069, 63, 46, 1, 70, "ObjectName",
 CellID->30833],
Cell[2118, 66, 631, 20, 70, "Usage",
 CellID->19711]
}, Open  ]],
Cell[CellGroupData[{
Cell[2786, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3264, 108, 610, 22, 70, "Notes",
 CellID->25760],
Cell[3877, 132, 399, 14, 70, "Notes",
 CellID->18896],
Cell[4279, 148, 204, 8, 70, "Notes",
 CellID->4667]
}, Closed]],
Cell[CellGroupData[{
Cell[4520, 161, 310, 9, 70, "SeeAlsoSection",
 CellID->2695],
Cell[4833, 172, 741, 26, 70, "SeeAlso",
 CellID->21624]
}, Open  ]],
Cell[CellGroupData[{
Cell[5611, 203, 313, 9, 70, "TutorialsSection",
 CellID->7285],
Cell[5927, 214, 157, 3, 70, "Tutorials",
 CellID->12550]
}, Open  ]],
Cell[6099, 220, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

