(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6047,        202]
NotebookOptionsPosition[      4503,        154]
NotebookOutlinePosition[      5594,        184]
CellTagsIndexPosition[      5551,        181]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FINITE FIELDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finite Fields Package" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/tutorial/FiniteFields"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finite Fields Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GF" :> Documentation`HelpLookup["paclet:FiniteFields/ref/GF"], 
          "IrreduciblePolynomial" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/ref/IrreduciblePolynomial"], 
          "ElementToPolynomial" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/ref/ElementToPolynomial"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GF\"\>", 
       2->"\<\"IrreduciblePolynomial\"\>", 
       3->"\<\"ElementToPolynomial\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FieldIrreducible", "ObjectName",
 CellID->27384],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FieldIrreducible", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the irreducible polynomial in the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " associated with the field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19405]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32356],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IrreduciblePolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/IrreduciblePolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElementToPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/ElementToPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6072]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6540],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/tutorial/FiniteFields"]], "Tutorials",
 CellID->31111]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FieldIrreducible - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 47.3020652}", "context" -> 
    "FiniteFields`", "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Symbol", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "FieldIrreducible[f, s] gives the irreducible polynomial in the symbol s \
associated with the field f.", "synonyms" -> {}, "title" -> 
    "FieldIrreducible", "type" -> "Symbol", "uri" -> 
    "FiniteFields/ref/FieldIrreducible"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1511, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2134, 65, 54, 1, 70, "ObjectName",
 CellID->27384],
Cell[2191, 68, 639, 20, 70, "Usage",
 CellID->19405]
}, Open  ]],
Cell[CellGroupData[{
Cell[2867, 93, 311, 9, 70, "SeeAlsoSection",
 CellID->32356],
Cell[3181, 104, 770, 26, 70, "SeeAlso",
 CellID->6072]
}, Open  ]],
Cell[CellGroupData[{
Cell[3988, 135, 313, 9, 70, "TutorialsSection",
 CellID->6540],
Cell[4304, 146, 157, 3, 70, "Tutorials",
 CellID->31111]
}, Open  ]],
Cell[4476, 152, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

