(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     86739,       3046]
NotebookOptionsPosition[     74257,       2622]
NotebookOutlinePosition[     76992,       2678]
CellTagsIndexPosition[     76949,       2675]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FINITE FIELDS PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Characteristic" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/Characteristic"], 
         "ElementToPolynomial" :> 
         Documentation`HelpLookup[
          "paclet:FiniteFields/ref/ElementToPolynomial"], "ExtensionDegree" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/ExtensionDegree"], 
         "False" :> Documentation`HelpLookup["paclet:ref/False"], "FieldExp" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/FieldExp"], 
         "FieldInd" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/FieldInd"], 
         "FieldIrreducible" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/FieldIrreducible"],
          "FieldSize" :> Documentation`HelpLookup["paclet:ref/FieldSize"], 
         "FormatType" :> Documentation`HelpLookup["paclet:ref/FormatType"], 
         "FromElementCode" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/FromElementCode"], 
         "FullForm" :> Documentation`HelpLookup["paclet:ref/FullForm"], 
         "FunctionOfCode" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/FunctionOfCode"], 
         "FunctionOfCoefficients" :> 
         Documentation`HelpLookup[
          "paclet:FiniteFields/ref/FunctionOfCoefficients"], "GF" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/GF"], 
         "IrreduciblePolynomial" :> 
         Documentation`HelpLookup[
          "paclet:FiniteFields/ref/IrreduciblePolynomial"], 
         "PolynomialToElement" :> 
         Documentation`HelpLookup[
          "paclet:FiniteFields/ref/PolynomialToElement"], "PowerList" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/PowerList"], 
         "PowerListQ" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/PowerListQ"], 
         "PowerListToField" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/PowerListToField"],
          "ReduceElement" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/ReduceElement"], 
         "SetFieldFormat" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/SetFieldFormat"], 
         "Subscripted" :> Documentation`HelpLookup["paclet:ref/Subscripted"], 
         "Successor" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/Successor"], 
         "ToElementCode" :> 
         Documentation`HelpLookup["paclet:FiniteFields/ref/ToElementCode"], 
         "True" :> Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Characteristic\"\>", 
      2->"\<\"ElementToPolynomial\"\>", 3->"\<\"ExtensionDegree\"\>", 
      4->"\<\"False\"\>", 5->"\<\"FieldExp\"\>", 6->"\<\"FieldInd\"\>", 
      7->"\<\"FieldIrreducible\"\>", 8->"\<\"FieldSize\"\>", 
      9->"\<\"FormatType\"\>", 10->"\<\"FromElementCode\"\>", 
      11->"\<\"FullForm\"\>", 12->"\<\"FunctionOfCode\"\>", 
      13->"\<\"FunctionOfCoefficients\"\>", 14->"\<\"GF\"\>", 
      15->"\<\"IrreduciblePolynomial\"\>", 16->"\<\"PolynomialToElement\"\>", 
      17->"\<\"PowerList\"\>", 18->"\<\"PowerListQ\"\>", 
      19->"\<\"PowerListToField\"\>", 20->"\<\"ReduceElement\"\>", 
      21->"\<\"SetFieldFormat\"\>", 22->"\<\"Subscripted\"\>", 
      23->"\<\"Successor\"\>", 24->"\<\"ToElementCode\"\>", 
      25->"\<\"True\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Finite Fields Package", "Title",
 CellID->10681],

Cell[TextData[{
 "A field is an algebraic structure obeying the rules of ordinary arithmetic. \
In particular, a field has binary operations of addition and multiplication, \
both of which are commutative and associative. A field has two special \
elements, the additive identity ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 ", and multiplicative identity ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". This package adds rules to ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " so that arithmetic on field elements will be defined properly. It also \
provides low\[Hyphen]level utilities for working with finite fields and for \
formatting finite field elements. "
}], "Text",
 CellID->11901],

Cell[TextData[{
 "For any finite field there is a fixed prime number ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 ", called the characteristic of the field, such that the sum of ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 " of the ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 " field elements gives the ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 " field element. A finite field of characteristic ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 " has ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["p", "TI"], 
    StyleBox["d", "TI"]], TraditionalForm]], "InlineFormula"],
 " elements for some positive integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["d", "TI"], TraditionalForm]], "InlineFormula"],
 ", which we will loosely call the extension degree. This package represents \
field elements as polynomials in a single variable. The polynomials have \
degree at most ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d", "TI"], "-", "1"}], TraditionalForm]], "InlineFormula"],
 " and their coefficients are integers reduced mod ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->7671],

Cell[TextData[{
 "The internal form of a finite field element is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["GF",
     BaseStyle->"Link",
     ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
    RowBox[{
     StyleBox["p", "TI"], ",", 
     StyleBox["ilist", "TI"]}], "]"}], "[", 
   StyleBox["elist", "TI"], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  ButtonBox["GF",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/GF"]], "InlineFormula"],
 " stands for ",
 StyleBox["Galois field",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 " is the prime characteristic of the field, ",
 Cell[BoxData[
  StyleBox["ilist", "TI"]], "InlineFormula"],
 " is the coefficient list of the irreducible polynomial which defines \
multiplication in the field, and ",
 Cell[BoxData[
  StyleBox["elist", "TI"]], "InlineFormula"],
 " is the coefficient list of the polynomial representing the particular \
element. Because this form can be a bit clumsy, the package provides several \
shortcuts for entering finite field elements. "
}], "Text",
 CellID->2794],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GF",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
     StyleBox["p", "TI"], "]", "[", "{", 
     StyleBox["k", "TI"], "}", "]"}], Cell[TextData[{
     "the integer ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " in the field of integers mod ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GF",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
     StyleBox["p", "TI"], ",", "1", "]", "[", "{", 
     StyleBox["k", "TI"], "}", "]"}], Cell[TextData[{
     "another way of expressing the integer ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " in the field of integers mod ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GF",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
     StyleBox["p", "TI"], ",", "{", "0", ",", "1", "}", "]", "[", "{", 
     StyleBox["k", "TI"], "}", "]"}], Cell[TextData[{
     "the full form of the integer ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " in the field of integers mod ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GF",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["d", "TI"], "]"}], Cell[TextData[{
     "a field that is a degree ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " extension of a prime field isomorphic to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["Z", "TI"], 
       StyleBox["p", "TI"]]], "InlineFormula"],
     " (the integers mod ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "); an irreducible polynomial is selected automatically"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GF",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["ilist", "TI"], "]", "[", 
     StyleBox["elist", "TI"], "]"}], Cell[TextData[{
     "the full form of a finite field element, where ",
     Cell[BoxData[
      StyleBox["ilist", "TI"]], "InlineFormula"],
     " is a list of integers of length ",
     Cell[BoxData[
      RowBox[{
       StyleBox["d", "TI"], "+", "1"}]], "InlineFormula"],
     " representing the coefficients of an irreducible polynomial, and ",
     Cell[BoxData[
      StyleBox["elist", "TI"]], "InlineFormula"],
     " is a list of integers of length ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " giving the coefficients of the polynomial representation of the \
element"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->13281],

Cell["Ways to enter finite field elements. ", "Caption",
 CellID->17338],

Cell["This loads the package. ", "MathCaption",
 CellID->9575],

Cell[BoxData[
 RowBox[{"<<", "FiniteFields`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30826],

Cell["Add 4 and 5 mod 7. The default output form is subscripted. ", \
"MathCaption",
 CellID->21553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GF", "[", "7", "]"}], "[", 
   RowBox[{"{", "4", "}"}], "]"}], "+", 
  RowBox[{
   RowBox[{"GF", "[", "7", "]"}], "[", 
   RowBox[{"{", "5", "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19353],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", "2", "}"}], "7"],
  Subscripted[
   {2}[7]],
  Editable->False]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32763]
}, Open  ]],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of the expression. Note the automatic choice of irreducible polynomial. "
}], "MathCaption",
 CellID->21935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellID->609431793],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
    RowBox[{"GF", "[", 
     RowBox[{"7", ",", 
      RowBox[{"List", "[", 
       RowBox[{"0", ",", "1"}], "]"}]}], "]"}], "[", 
    RowBox[{"List", "[", "2", "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->16166]
}, Open  ]],

Cell[TextData[{
 "Here is multiplication in the field of ",
 StyleBox["3^4", "MR"],
 " ",
 StyleBox["==", "MR"],
 " ",
 StyleBox["81", "MR"],
 " elements. "
}], "MathCaption",
 CellID->5205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GF", "[", 
    RowBox[{"3", ",", "4"}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}], "]"}], " ", 
  RowBox[{
   RowBox[{"GF", "[", 
    RowBox[{"3", ",", "4"}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "0"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5853],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "0"}], "}"}], "3"],
  Subscripted[
   {1, 1, 2, 0}[3]],
  Editable->False]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->25084]
}, Open  ]],

Cell["\<\
Field objects are automatically reduced to a canonical form. \
\>", "MathCaption",
 CellID->8089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GF", "[", 
   RowBox[{"3", ",", "4"}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->30573],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], "3"],
  Subscripted[
   {0, 0, 0, 1}[3]],
  Editable->False]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->3047]
}, Open  ]],

Cell[TextData[{
 "Since ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " lists polynomials with the constant term first, the same is done for \
finite field elements. In this example, the left\[Hyphen]hand zero is \
essential to give the constant term, but the right\[Hyphen]hand zero in the \
input is unnecessary. "
}], "MathCaption",
 CellID->23126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GF", "[", 
   RowBox[{"3", ",", "4"}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1", ",", "0"}], "}"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1513],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], "3"],
  Subscripted[
   {0, 1, 0, 0}[3]],
  Editable->False]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->31887]
}, Open  ]],

Cell["\<\
It is nonsense to add elements of different finite fields, so this expression \
does not evaluate. \
\>", "MathCaption",
 CellID->30520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GF", "[", 
    RowBox[{"5", ",", "1"}], "]"}], "[", 
   RowBox[{"{", "1", "}"}], "]"}], "+", 
  RowBox[{
   RowBox[{"GF", "[", 
    RowBox[{"3", ",", "4"}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->31888],

Cell[BoxData[
 RowBox[{
  InterpretationBox[
   SubscriptBox[
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "0"}], "}"}], "3"],
   Subscripted[
    {1, 1, 1, 0}[3]],
   Editable->False], "+", 
  InterpretationBox[
   SubscriptBox[
    RowBox[{"{", "1", "}"}], "5"],
   Subscripted[
    {1}[5]],
   Editable->False]}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->11856]
}, Open  ]],

Cell["Integers are imported into finite fields. ", "MathCaption",
 CellID->3603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   RowBox[{"GF", "[", 
    RowBox[{"3", ",", "4"}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->7681],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0", ",", "0"}], "}"}], "3"],
  Subscripted[
   {2, 1, 0, 0}[3]],
  Editable->False]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->24844]
}, Open  ]],

Cell[TextData[{
 "Zero is special. This package makes the assumption that zero is zero, \
regardless of the field it is in. The main consequence of this is that a \
field zero is simplified to the integer ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 " automatically. Many functions in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " work better with this assumption. The assumption is not rigorously \
correct, but will not produce nonsensical output unless nonsensical input is \
given. "
}], "Text",
 CellID->7061],

Cell[TextData[{
 "Field zeros are simplified to the integer ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 " after arithmetic. "
}], "MathCaption",
 CellID->5633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"GF", "[", "7", "]"}], "[", 
     RowBox[{"{", "1", "}"}], "]"}], "+", 
    RowBox[{
     RowBox[{"GF", "[", "7", "]"}], "[", 
     RowBox[{"{", "6", "}"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"GF", "[", 
     RowBox[{"3", ",", "4"}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->18835],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->14155]
}, Open  ]],

Cell[TextData[{
 "The sum of the field zeros from different fields also simplifies to ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->21014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"GF", "[", "7", "]"}], "[", 
   RowBox[{"{", "0", "}"}], "]"}], "+", 
  RowBox[{
   RowBox[{"GF", "[", 
    RowBox[{"3", ",", "4"}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->595],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", "0", "}"}], "7"],
  Subscripted[
   {0}[7]],
  Editable->False]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->21989]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SetFieldFormat",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/SetFieldFormat"], "[", 
     StyleBox["f", "TI"], ",", 
     ButtonBox["FormatType",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FormatType"], "\[Rule]", "Subscripted", "]"}], 
    Cell[TextData[{
     "set the field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to have a ",
     Cell[BoxData[
      ButtonBox["Subscripted",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Subscripted"]], "InlineFormula"],
     " output (default)"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetFieldFormat",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/SetFieldFormat"], "[", 
     StyleBox["f", "TI"], ",", 
     ButtonBox["FormatType",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FormatType"], "\[Rule]", 
     ButtonBox["FullForm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FullForm"], "]"}], Cell[TextData[{
     "set the field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to have a ",
     Cell[BoxData[
      ButtonBox["FullForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
     " output"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetFieldFormat",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/SetFieldFormat"], "[", 
     StyleBox["f", "TI"], ",", 
     ButtonBox["FormatType",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FormatType"], "\[Rule]", 
     ButtonBox["FunctionOfCoefficients",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/FunctionOfCoefficients"], "[", 
     StyleBox["g", "TI"], "]", "]"}], Cell[TextData[{
     "set the field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to input and output a field element using ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " as the function name, with the arguments given by the coefficients of \
the polynomial representation of the field element"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SetFieldFormat",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/SetFieldFormat"], "[", 
     StyleBox["f", "TI"], ",", 
     ButtonBox["FormatType",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FormatType"], "\[Rule]", 
     ButtonBox["FunctionOfCode",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/FunctionOfCode"], "[", 
     StyleBox["g", "TI"], "]", "]"}], Cell[TextData[{
     "set the field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to input and output a field element using ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " as the function name, with the argument given by the integer code \
specifying the field element"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->16856],

Cell["Field element formatting. ", "Caption",
 CellID->24259],

Cell[TextData[{
 "One may always input or output the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of a finite field element, however the package provides some shortcuts. \
The elements of a prime field may be written ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["GF",
     BaseStyle->"Link",
     ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
    StyleBox["p", "TI"], "]"}], "[", 
   RowBox[{"{", 
    StyleBox["k", "TI"], "}"}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["GF",
     BaseStyle->"Link",
     ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
    RowBox[{
     StyleBox["p", "TI"], ",", "1"}], "]"}], "[", 
   RowBox[{"{", 
    StyleBox["k", "TI"], "}"}], "]"}]], "InlineFormula"],
 ", both of which are interpreted as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["GF",
     BaseStyle->"Link",
     ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
    RowBox[{
     StyleBox["p", "TI"], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "[", 
   RowBox[{"{", 
    StyleBox["k", "TI"], "}"}], "]"}]], "InlineFormula"],
 ". In general if ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["s", "TI"], "==", 
    SuperscriptBox[
     StyleBox["p", "TI"], 
     StyleBox["d", "TI"]]}], TraditionalForm]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 " prime and ",
 Cell[BoxData[
  FormBox[
   StyleBox["d", "TI"], TraditionalForm]], "InlineFormula"],
 " a positive integer, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
   RowBox[{
    StyleBox["p", "TI"], ",", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 ". The expression ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
   RowBox[{"3", ",", " ", "4"}], "]"}]], "InlineFormula"],
 " stands for a degree 4 extension of the integers mod 3, that is, a field \
with 81 elements. When this form is used, the package automatically selects \
an irreducible polynomial, with coefficients given by ",
 Cell[BoxData[
  StyleBox["ilist", "TI"]], "InlineFormula"],
 " and with the property that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["GF",
     BaseStyle->"Link",
     ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
    RowBox[{
     StyleBox["p", "TI"], ",", 
     StyleBox["ilist", "TI"]}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], "]"}]], "InlineFormula"],
 " is a ",
 StyleBox["primitive element",
  FontSlant->"Italic"],
 " of the field. It is possible to provide your own irreducible polynomial by \
giving it explicitly, as in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
   RowBox[{"3", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "2", ",", "1"}], "}"}]}],
    "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->26487],

Cell[TextData[{
 "The default ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " of a finite field element is a list of integers subscripted by the \
characteristic of the field. The length of the list is the degree of the \
field extension over the prime field. If you are working with only one \
representation of any field, then this will be sufficient to distinguish \
which field contains a given element. "
}], "Text",
 CellID->21164],

Cell[TextData[{
 "Since it is possible to have fields of the same size using different \
irreducible polynomials, it is useful to be able distinguish elements from \
these fields. It is also convenient to have a more compact way to type finite \
field elements. The function ",
 Cell[BoxData[
  ButtonBox["SetFieldFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/SetFieldFormat"]], "InlineFormula"],
 " establishes the input and output formats of field elements. You may always \
input field elements in the ways already described, or ask explicitly for the \
",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of the output. "
}], "Text",
 CellID->22027],

Cell[TextData[{
 "Note that a field head, such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
   RowBox[{"2", ",", "3"}], "]"}]], "InlineFormula"],
 " may be assigned to a symbol. The assignment ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f8", "TI"], "=", 
   RowBox[{
    ButtonBox["GF",
     BaseStyle->"Link",
     ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
    RowBox[{"2", ",", "3"}], "]"}]}]], "InlineFormula"],
 " allows you to refer to a specific field element using ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f8", "TI"], "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->15907],

Cell["Give a field with 9 elements a functional format. ", "MathCaption",
 CellID->11183],

Cell[BoxData[
 RowBox[{"SetFieldFormat", "[", 
  RowBox[{
   RowBox[{"GF", "[", "9", "]"}], ",", 
   RowBox[{"FormatType", "\[Rule]", 
    RowBox[{"FunctionOfCoefficients", "[", "f9", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->15426],

Cell["Here is some arithmetic with elements from this field. ", "MathCaption",
 CellID->24275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"example", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f9", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "+", 
     RowBox[{"f9", "[", "2", "]"}]}], ",", 
    SuperscriptBox[
     RowBox[{"f9", "[", 
      RowBox[{"1", ",", "2"}], "]"}], "3"], ",", 
    RowBox[{"2", " ", 
     RowBox[{"f9", "[", "2", "]"}]}], ",", 
    FractionBox[
     RowBox[{"f9", "[", "2", "]"}], 
     RowBox[{"f9", "[", 
      RowBox[{"2", ",", "2"}], "]"}]]}], "}"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->6769],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"f9", "[", 
     RowBox[{"0", ",", "2"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", 
     RowBox[{"2", ",", "1"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", "1", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", 
     RowBox[{"0", ",", "1"}], "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{247, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->4101]
}, Open  ]],

Cell["\<\
Represent each element as an integer in the range 0 to 8, rather than as a \
sequence of polynomial coefficients. \
\>", "MathCaption",
 CellID->22118],

Cell[BoxData[
 RowBox[{"SetFieldFormat", "[", 
  RowBox[{
   RowBox[{"GF", "[", "9", "]"}], ",", 
   RowBox[{"FormatType", "\[Rule]", 
    RowBox[{"FunctionOfCode", "[", "f9", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->434],

Cell["Here the arithmetic results are encoded. ", "MathCaption",
 CellID->26935],

Cell[CellGroupData[{

Cell[BoxData["example"], "Input",
 CellLabel->"In[14]:=",
 CellID->10458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"f9", "[", "6", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", "5", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", "1", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"f9", "[", "3", "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->29192]
}, Open  ]],

Cell["This restores the default formatting for this field. ", "MathCaption",
 CellID->3615],

Cell[BoxData[
 RowBox[{"SetFieldFormat", "[", 
  RowBox[{"GF", "[", "9", "]"}], "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->1823],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Characteristic",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/Characteristic"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the characteristic of field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ExtensionDegree",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/ExtensionDegree"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the degree of the extension of field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over its base field"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FieldSize",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FieldSize"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give the number of elements in field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FieldIrreducible",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/FieldIrreducible"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "give the irreducible polynomial which defines multiplication in the \
field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", expressed in terms of the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["IrreduciblePolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/IrreduciblePolynomial"], "[", 
     StyleBox["s", "TI"], ",", 
     StyleBox["p", "TI"], ",", 
     StyleBox["d", "TI"], "]"}], Cell[TextData[{
     "find an irreducible polynomial of degree ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " over the integers mod prime ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ", expressed in terms of the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->22485],

Cell["Field parameter functions. ", "Caption",
 CellID->4677],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  ButtonBox["Characteristic",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/Characteristic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ExtensionDegree",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/ExtensionDegree"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FieldSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FieldSize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FieldIrreducible",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldIrreducible"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["IrreduciblePolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/IrreduciblePolynomial"]], 
  "InlineFormula"],
 " give important parameters about a finite field. "
}], "Text",
 CellID->32300],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Characteristic",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/Characteristic"]], "InlineFormula"],
 " gives the prime characteristic of the field. "
}], "MathCaption",
 CellID->17925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"fld", "=", 
   RowBox[{"GF", "[", "81", "]"}]}], ";", 
  RowBox[{"Characteristic", "[", "fld", "]"}]}]], "Input",
 CellLabel->"In[16]:=",
 CellID->29756],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->25668]
}, Open  ]],

Cell[TextData[{
 "A field extension is a vector space over the base field. ",
 Cell[BoxData[
  ButtonBox["ExtensionDegree",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/ExtensionDegree"]], "InlineFormula"],
 " gives the dimension of this vector space. "
}], "MathCaption",
 CellID->27238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExtensionDegree", "[", "fld", "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->8528],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->10353]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FieldSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FieldSize"]], "InlineFormula"],
 " gives the number of elements in the field. "
}], "MathCaption",
 CellID->18419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FieldSize", "[", "fld", "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->29949],

Cell[BoxData["81"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->8249]
}, Open  ]],

Cell["Here is an identity. ", "MathCaption",
 CellID->18546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FieldSize", "[", "fld", "]"}], "\[Equal]", 
  SuperscriptBox[
   RowBox[{"Characteristic", "[", "fld", "]"}], 
   RowBox[{"ExtensionDegree", "[", "fld", "]"}]]}]], "Input",
 CellLabel->"In[19]:=",
 CellID->12752],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->27941]
}, Open  ]],

Cell["\<\
This gives the irreducible polynomial associated with a field. \
\>", "MathCaption",
 CellID->4111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FieldIrreducible", "[", 
  RowBox[{"fld", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->259],

Cell[BoxData[
 RowBox[{"2", "+", "x", "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->9733]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Successor",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/Successor"], "[", 
     StyleBox["elem", "TI"], "]"}], Cell["\<\
give the next element in a canonical ordering of the field elements (this \
function does not wrap, so the largest element has no successor)\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ReduceElement",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/ReduceElement"], "[", 
     StyleBox["elem", "TI"], "]"}], Cell[
    "give a field element in reduced form", "TableText"]},
   {
    RowBox[{
     ButtonBox["ToElementCode",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/ToElementCode"], "[", 
     StyleBox["elem", "TI"], "]"}], Cell["\<\
give a nonnegative integer less than the field size that encodes the field \
element\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["FromElementCode",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/FromElementCode"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["code", "TI"]}], "]"}], Cell[TextData[{
     "give the field element of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " corresponding to ",
     Cell[BoxData[
      StyleBox["code", "TI"]], "InlineFormula"],
     ", a nonnegative integer less than the field size"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialToElement",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/PolynomialToElement"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["poly", "TI"], "]"}], Cell[TextData[{
     "give the field element of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " corresponding to ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     ", a polynomial in one variable with integer\[Hyphen]valued \
coefficients"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ElementToPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/ElementToPolynomial"], "[", 
     StyleBox["elem", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "give a polynomial in the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " corresponding to the field element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->17339],

Cell["Field element manipulation functions. ", "Caption",
 CellID->10348],

Cell[TextData[{
 "The functions ",
 Cell[BoxData[
  ButtonBox["Successor",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/Successor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ReduceElement",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/ReduceElement"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ToElementCode",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/ToElementCode"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FromElementCode",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FromElementCode"]], "InlineFormula"],
 ",",
 " ",
 Cell[BoxData[
  ButtonBox["PolynomialToElement",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PolynomialToElement"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["ElementToPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/ElementToPolynomial"]], 
  "InlineFormula"],
 " are for working with finite field elements. "
}], "Text",
 CellID->21708],

Cell["This gives the element as a polynomial. ", "MathCaption",
 CellID->776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ElementToPolynomial", "[", 
  RowBox[{
   RowBox[{"fld", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "1", ",", "2"}], "}"}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->22060],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->10029]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PowerListQ",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/PowerListQ"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if a list representing the powers of a primitive element of the field \
is used to do field arithmetic, ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FieldExp",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/FieldExp"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give the value of the discrete exponential function associated with the \
field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " for integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FieldInd",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/FieldInd"], "[", 
     StyleBox["elem", "TI"], "]"}], Cell[TextData[{
     "give the value of the discrete logarithm function associated with the \
field for element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PowerList",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/PowerList"], "[", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "give a list of the data parts of the nonzero elements of the field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", generated by raising a primitive element of the field to integer \
powers 0, 1, 2, ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["FieldSize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FieldSize"], "[", 
       StyleBox["f", "TI"], "]", "-", "1"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PowerListToField",
      BaseStyle->"Link",
      ButtonData->"paclet:FiniteFields/ref/PowerListToField"], "[", 
     StyleBox["list", "TI"], "]"}], Cell["\<\
give the field associated with the specified list of element data parts, \
where the elements are generated by successive powers of a primitive element\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->18224],

Cell["Functions to support fast multiplication and division. ", "Caption",
 CellID->27414],

Cell[TextData[{
 "A finite field must have a prime power number of elements. If it has ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 " elements, where ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 " is a prime, then it is isomorphic to the integers mod ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 ". In this case the package does addition, subtraction, multiplication, and \
positive powers as usual over the integers and reduces the results using ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 ". For negative powers the package uses ",
 Cell[BoxData[
  ButtonBox["PowerMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerMod"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->31891],

Cell[TextData[{
 "If the field has ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["p", "TI"], 
    StyleBox["d", "TI"]], TraditionalForm]], "InlineFormula"],
 " elements, where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["d", "TI"], ">", "1"}], TraditionalForm]], "InlineFormula"],
 ", then it is isomorphic to the set of polynomials in some variable having \
degree less than ",
 Cell[BoxData[
  FormBox[
   StyleBox["d", "TI"], TraditionalForm]], "InlineFormula"],
 " and with coefficients in the integers mod ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 ". Addition is polynomial addition except that the coefficients are reduced \
modulo ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 ". For multiplication the product is also reduced modulo an irreducible \
(nonfactorable) polynomial over the integers modulo ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->14270],

Cell[TextData[{
 "Taking multiplicative inverses is equivalent to finding the extended \
greatest common divisor modulo ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula"],
 " with the irreducible polynomial. In other words, given the field element \
",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 " and the field\[CloseCurlyQuote]s irreducible polynomial ",
 Cell[BoxData[
  StyleBox["irred", "TI"]], "InlineFormula"],
 ", find polynomials ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b", "TI"], TraditionalForm]], "InlineFormula"],
 " such that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"], "[", 
   RowBox[{
    StyleBox["elem", "TI"], ",", 
    StyleBox["irred", "TI"], ",", 
    RowBox[{
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["p", "TI"]}]}], "]"}]], "InlineFormula"],
 " equals ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialMod"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["a", "TI"], " ", 
      StyleBox["elem", "TI"]}], " ", "+", " ", 
     RowBox[{
      StyleBox["b", "TI"], " ", 
      StyleBox["irred", "TI"]}]}], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 ". If the result of ",
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " is unity, then ",
 Cell[BoxData[
  FormBox[
   StyleBox["a", "TI"], TraditionalForm]], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16845],

Cell["\<\
There is a faster way to do multiplication and compute inverses, based on the \
fact that the multiplicative group of any finite field is cyclic. If you have \
a generator of the group along with a list of the positive powers of the \
generator in sequence, then multiplication and division can be reduced to \
adding and subtracting indices of the elements in the list. \
\>", "Text",
 CellID->4509],

Cell[TextData[{
 "The package supports this method of arithmetic by allowing you to either \
generate a field object from a list representing the powers of a primitive \
element (",
 Cell[BoxData[
  ButtonBox["PowerListToField",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerListToField"]], 
  "InlineFormula"],
 "), or generate a list representing the powers of a primitive element from a \
field object (",
 Cell[BoxData[
  ButtonBox["PowerList",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerList"]], "InlineFormula"],
 "). Setting ",
 Cell[BoxData[
  ButtonBox["PowerListQ",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerListQ"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " causes field arithmetic to use a list of primitive element powers, by \
defining the discrete exponential function ",
 Cell[BoxData[
  ButtonBox["FieldExp",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldExp"]], "InlineFormula"],
 " and the discrete logarithm function ",
 Cell[BoxData[
  ButtonBox["FieldInd",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldInd"]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  ButtonBox["FieldInd",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldInd"]], "InlineFormula"],
 " function is often called the index function for the field. The list of \
powers will depend on the choice of primitive element and on which \
irreducible polynomial is used for the field representation. Any element of \
the field for which ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FieldInd",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FieldInd"], "[", 
   StyleBox["elem", "TI"], "]"}]], "InlineFormula"],
 " is relatively prime to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["FieldSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FieldSize"], "[", 
    StyleBox["f", "TI"], "]"}], "-", "1"}]], "InlineFormula"],
 " is also a primitive element of the field. "
}], "Text",
 CellID->13857],

Cell[TextData[{
 "Field arithmetic using a list of primitive element powers has two \
disadvantages. It takes time to enter or compute the list, and the list can \
take considerable memory. In general, if you are doing only a few arithmetic \
operations, or if you are working in a large field, it is better not to \
create the list. Note that setting ",
 Cell[BoxData[
  ButtonBox["PowerListQ",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerListQ"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " disables this method of doing arithmetic in a particular field, but it \
does not destroy the computed values of ",
 Cell[BoxData[
  ButtonBox["FieldExp",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldExp"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FieldInd",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldInd"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13034],

Cell[TextData[{
 "This shows that 3 is a primitive element of the integers mod 7. The other \
primitive element is 5. Since ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
   RowBox[{"7", ",", "1"}], "]"}]], "InlineFormula"],
 " is a prime field, it is inefficient to use a list of primitive element \
powers for multiplication. "
}], "MathCaption",
 CellID->19202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerList", "[", 
  RowBox[{"GF", "[", 
   RowBox[{"7", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->12051],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "6", "}"}], ",", 
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", "5", "}"}]}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->16461]
}, Open  ]],

Cell[TextData[{
 "Although using a list of primitive element powers is an inefficient way to \
do ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
   RowBox[{"7", ",", "1"}], "]"}]], "InlineFormula"],
 " arithmetic, this enables the method anyway. "
}], "MathCaption",
 CellID->6460],

Cell[BoxData[
 RowBox[{
  RowBox[{"PowerListQ", "[", 
   RowBox[{"GF", "[", 
    RowBox[{"7", ",", "1"}], "]"}], "]"}], "=", "True"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->1454],

Cell[TextData[{
 "The position of ",
 StyleBox["{6}", "MR"],
 " in ",
 Cell[BoxData[
  ButtonBox["PowerList",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerList"]], "InlineFormula"],
 " is one greater than the index given by ",
 Cell[BoxData[
  ButtonBox["FieldInd",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldInd"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FieldInd", "[", 
  RowBox[{
   RowBox[{"GF", "[", 
    RowBox[{"7", ",", "1"}], "]"}], "[", 
   RowBox[{"{", "6", "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->1277],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->32592]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FieldExp",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldExp"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FieldInd",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldInd"]], "InlineFormula"],
 " are inverses. "
}], "MathCaption",
 CellID->24123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FieldExp", "[", 
  RowBox[{
   RowBox[{"GF", "[", 
    RowBox[{"7", ",", "1"}], "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->7918],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox[
   RowBox[{"{", "6", "}"}], "7"],
  Subscripted[
   {6}[7]],
  Editable->False]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->17045]
}, Open  ]],

Cell["\<\
These definitions for field index and field exponent are not part of the \
conventional definitions, but may be useful in some applications. \
\>", "MathCaption",
 CellID->2797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FieldInd", "[", "0", "]"}], ",", 
   RowBox[{"FieldExp", "[", 
    RowBox[{
     RowBox[{"GF", "[", 
      RowBox[{"7", ",", "1"}], "]"}], ",", 
     RowBox[{"-", "\[Infinity]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->2268],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "\[Infinity]"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->22927]
}, Open  ]],

Cell[TextData[{
 "Some books contain tables equivalent to the list given by ",
 Cell[BoxData[
  ButtonBox["PowerList",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerList"]], "InlineFormula"],
 ". The function ",
 Cell[BoxData[
  ButtonBox["PowerListToField",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerListToField"]], 
  "InlineFormula"],
 " allows such a list to be used to define a field. The argument of ",
 Cell[BoxData[
  ButtonBox["PowerListToField",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerListToField"]], 
  "InlineFormula"],
 " is a list of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["p", "TI"], 
     StyleBox["d", "TI"]], "-", "1"}], TraditionalForm]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox["d", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]tuples of integers. The first ",
 Cell[BoxData[
  FormBox[
   StyleBox["d", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]tuple is assumed to give the coefficients of the polynomial \
representation of the ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 " element of the field. This is used to determine whether the coefficients \
are listed constant\[Hyphen]term\[Hyphen]first or constant\[Hyphen]term\
\[Hyphen]last. The second ",
 Cell[BoxData[
  FormBox[
   StyleBox["d", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]tuple is assumed to represent a primitive element of the field. \
The succeeding ",
 Cell[BoxData[
  FormBox[
   StyleBox["d", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]tuples are assumed to represent successive powers of the second \
element. ",
 Cell[BoxData[
  ButtonBox["PowerListToField",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerListToField"]], 
  "InlineFormula"],
 " does some elementary error checking to verify that the input list is \
valid. If so, ",
 Cell[BoxData[
  ButtonBox["PowerListToField",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerListToField"]], 
  "InlineFormula"],
 " computes parameters of the field such as the characteristic and the \
irreducible polynomial. "
}], "Text",
 CellID->23438],

Cell["Here is a field of order 9. ", "MathCaption",
 CellID->8516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g9", "=", 
  RowBox[{"PowerListToField", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[27]:=",
 CellID->13586],

Cell[BoxData[
 RowBox[{"GF", "[", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->3379]
}, Open  ]],

Cell[TextData[{
 "Arithmetic works on fields defined using ",
 Cell[BoxData[
  ButtonBox["PowerListToField",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerListToField"]], 
  "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->14473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"g9", "[", 
     RowBox[{"{", "1", "}"}], "]"}], "+", 
    RowBox[{"g9", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"g9", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}], " ", 
    RowBox[{"g9", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], "]"}]}], ",", 
   FractionBox["1", 
    RowBox[{"g9", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], "]"}]], ",", 
   SuperscriptBox[
    RowBox[{"g9", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], "]"}], "2"]}], "}"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->22683],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1VlGOwiAQpWBbNdG6m93VT0+jXx6iMSb6Ydy43rgH6dKKpnkdhIHapLQD
w+PNAwZ25e14OJe3075cb6/l7/G0/1tvLlddpRIhRKXfYiX0f63/2reqa/0d
NaVq7Pbp2ROwC7CVLqTo40wdOIuBcGx80jfhqFY15VBtanp/UH6jp228kNuj
92dUb3Lsji0j+6MG0kuZxisl5jmz1CMe2mOiXRHzlg+EH8sf29+N7z8rIu2u
LGHGalYC7hVXzpCWfq9HGVtbhx8rDxrrkRN4Y3HVo/eVZKJgfm33Qw4cDdM5
xaAXD2bIjIGI7DhY6BsTaQa+Se2zO1zsXTOIatDrBePgosaydPlz8cIyEeZt
V5RfXtriWYYsEAVZULeDrv0dGQWewX5a4WqeDaIV3jow8yAKskCtsD9qxY0i
TCs6Vtea9lNsTtaGYc28sFDDsOhoJX1OXGXQqRvyj8V/Yb6IZ/MvLP5LJh+M
8n6DryylSP4BJPwx4g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{227, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->39205108]
}, Open  ]],

Cell["The field parameters are computed automatically. ", "MathCaption",
 CellID->10601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Characteristic", "[", "g9", "]"}], ",", 
   RowBox[{"ExtensionDegree", "[", "g9", "]"}], ",", 
   RowBox[{"FieldIrreducible", "[", 
    RowBox[{"g9", ",", "z"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->3828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "2", ",", 
   RowBox[{"2", "+", "z", "+", 
    SuperscriptBox["z", "2"]}]}], "}"}]], "Output",
 ImageSize->{107, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->6681]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FieldExp",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldExp"]], "InlineFormula"],
 " may be used to generate the list of elements corresponding to the original \
list. "
}], "MathCaption",
 CellID->17073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"FieldExp", "[", 
    RowBox[{"g9", ",", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->9431],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtuwjAMdQmFDQbdpt0e+ZrtaR9RoUnwMG1ifOH4MNZAmdCJU9ttJ3UC
JKI4sU/ik5M07Wu+Xry95+vlPJ+9rPLPxXL+NXv+WBVNLiFKvokoe6Kivi1q
u7//bYo/Ud+X7tC2DexLsDOwXVH0KMQZCTjXLeHE5pOecUzrNW4Jx7fTvqxQ
1aiMvuH8+r926YU5HqJvG0WzYx/ZvVOMD9hDXVhGD2xRF94rZVQ1LArHqB/x
0L5g+jmcYWRcK35s/gMlPvZ3BV/Lv4Qf478r/KCNp2Db+Lpdwdl+D/pVofR4
xxIzh9i5wOXGo3GnSN1R2s3FRUapzuU8VvOxNOuqeRrF9FAHP9xZ2IpReA5N
2Jx3XkNoLfumDJshAt52LYg4R+wfVGDhrQ3zx/4mWFMzd9ydMkRoM1/LOiAW
rgPbH8HC2GTXbj33eXVKzxzkj9/XyIwVVVKWhGdValO8elwiKs9l13O34rVz
a9ExfqdiWFIrokjnAOZyD7a0963xVyouEEXHhXUu0k7GeKua2HvFv1YPvvvi
LQMZGwiMWePHKi506mmay0Tg6qyeenPRrd4pYEkK+RuFad9nvBock9sD4+9K
f+47Ludfhf8Ywc866M/ly/n3KvjBVdp/Z/bVjaJGyQ9X+Ke+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{450, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->271196941]
}, Open  ]],

Cell["\<\
This gives the original list consisting of the data parts of the elements. \
\>", "MathCaption",
 CellID->6741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerList", "[", "g9", "]"}]], "Input",
 CellLabel->"In[31]:=",
 CellID->13519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{410, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->8402]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compatibility with Other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " Functions"
}], "Subsection",
 CellID->6436],

Cell[TextData[{
 "Most ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions are not, indeed cannot be, designed to work over arbitrary \
fields. For instance, it is nonsensical to integrate an expression containing \
a finite field object. At best, such functions will not do anything when \
given such an expression. "
}], "Text",
 CellID->21747],

Cell["\<\
You can generally expect these functions to treat the field object as an \
unknown symbol. Before using a function on an expression with finite field \
objects, it is wise to try some test cases first. The types of functions that \
might reasonably be expected to work are linear algebra and polynomial \
functions. \
\>", "Text",
 CellID->26038],

Cell[TextData[{
 "Set the format for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"], "[", "9", "]"}]], 
  "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13964],

Cell[BoxData[
 RowBox[{"SetFieldFormat", "[", 
  RowBox[{
   RowBox[{"GF", "[", "9", "]"}], ",", 
   RowBox[{"FormatType", "\[Rule]", 
    RowBox[{"FunctionOfCode", "[", "f9", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->2970],

Cell["Fractional powers do not work. ", "MathCaption",
 CellID->749],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox[
  RowBox[{"f9", "[", "1", "]"}]]], "Input",
 CellLabel->"In[33]:=",
 CellID->4593],

Cell[BoxData[
 SqrtBox[
  TagBox[
   RowBox[{"f9", "[", "1", "]"}],
   HoldForm]]], "Output",
 ImageSize->{56, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->5074]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " fails because it makes the assumption that it is working over the \
rationals. "
}], "MathCaption",
 CellID->20839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"f9", "[", "2", "]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      RowBox[{"f9", "[", "2", "]"}]}], ")"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->16590],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "2"], "+", 
  TagBox[
   RowBox[{"f9", "[", "2", "]"}],
   HoldForm]}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->4950]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " doesn\[CloseCurlyQuote]t work either. Use ",
 Cell[BoxData[
  ButtonBox["PolynomialExtendedGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialExtendedGCD"]], "InlineFormula"],
 " defined in the package instead. "
}], "MathCaption",
 CellID->28782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"f9", "[", "1", "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"f9", "[", "2", "]"}], " ", "x"}], "+", 
    RowBox[{"f9", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->15856],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->10990]
}, Open  ]],

Cell[TextData[{
 "Set the format for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
   RowBox[{"3", ",", " ", "4"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->4119],

Cell[BoxData[
 RowBox[{"SetFieldFormat", "[", 
  RowBox[{
   RowBox[{"GF", "[", 
    RowBox[{"3", ",", "4"}], "]"}], ",", 
   RowBox[{"FormatType", "\[Rule]", 
    RowBox[{"FunctionOfCoefficients", "[", "f81", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->13882],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialQuotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 " accept polynomials over a field. "
}], "MathCaption",
 CellID->29916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolynomialQuotient", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f81", "[", 
        RowBox[{"2", ",", "2"}], "]"}], " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{
       RowBox[{"f81", "[", "1", "]"}], " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"f81", "[", 
       RowBox[{"1", ",", "1", ",", "1"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f81", "[", "2", "]"}], " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"f81", "[", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "]"}]}], ",", "x"}], 
    "]"}], ",", 
   RowBox[{"PolynomialRemainder", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f81", "[", 
        RowBox[{"2", ",", "2"}], "]"}], " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{
       RowBox[{"f81", "[", "1", "]"}], " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"f81", "[", 
       RowBox[{"1", ",", "1", ",", "1"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f81", "[", "2", "]"}], " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"f81", "[", 
       RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "]"}]}], ",", "x"}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->24587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     TagBox[
      RowBox[{"f81", "[", 
       RowBox[{"1", ",", "1"}], "]"}],
      HoldForm]}], "+", 
    TagBox[
     RowBox[{"f81", "[", 
      RowBox[{"1", ",", "1", ",", "2", ",", "2"}], "]"}],
     HoldForm]}], ",", 
   TagBox[
    RowBox[{"f81", "[", 
     RowBox[{"1", ",", "0", ",", "2", ",", "2"}], "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{311, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->684]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " works on polynomials over the integers, not polynomials over a field. Also \
note that a polynomial over a field is not automatically sorted from lower \
power to higher power, because ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not treat ",
 Cell[BoxData[
  ButtonBox["GF",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/GF"]], "InlineFormula"],
 " objects as numbers. "
}], "MathCaption",
 CellID->25065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f81", "[", 
      RowBox[{"2", ",", "2"}], "]"}], " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{
     RowBox[{"f81", "[", "1", "]"}], " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"f81", "[", 
     RowBox[{"1", ",", "1", ",", "1"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"f81", "[", "2", "]"}], " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"f81", "[", 
     RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->25533],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   TagBox[
    RowBox[{"f81", "[", "1", "]"}],
    HoldForm]}], "+", 
  TagBox[
   RowBox[{"f81", "[", 
    RowBox[{"1", ",", "1", ",", "1"}], "]"}],
   HoldForm], "+", 
  RowBox[{
   SuperscriptBox["x", "4"], " ", 
   TagBox[
    RowBox[{"f81", "[", 
     RowBox[{"2", ",", "2"}], "]"}],
    HoldForm]}]}]], "Output",
 ImageSize->{241, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->15634]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Det",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Det"]], "InlineFormula"],
 " works on matrices of field elements. "
}], "MathCaption",
 CellID->26163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ffmatrix", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f81", "[", 
        RowBox[{"2", ",", "1", ",", "2"}], "]"}], ",", 
       RowBox[{"f81", "[", 
        RowBox[{"1", ",", "1", ",", "1"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f81", "[", 
        RowBox[{"1", ",", "2", ",", "1", ",", "2"}], "]"}], ",", 
       RowBox[{"f81", "[", "2", "]"}]}], "}"}]}], "}"}]}], ";", 
  RowBox[{"Det", "[", "ffmatrix", "]"}]}]], "Input",
 CellLabel->"In[39]:=",
 CellID->4813],

Cell[BoxData[
 TagBox[
  RowBox[{"f81", "[", 
   RowBox[{"0", ",", "0", ",", "2", ",", "1"}], "]"}],
  HoldForm]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->12658]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RowReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowReduce"]], "InlineFormula"],
 " works except that the 1 should be in the field. "
}], "MathCaption",
 CellID->11478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RowReduce", "[", "ffmatrix", "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->13216],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->28748]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Inverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inverse"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " also work with matrices of field elements. "
}], "MathCaption",
 CellID->17868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", "ffmatrix", "]"}], ".", "ffmatrix"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->25636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"f81", "[", "1", "]"}],
      HoldForm], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     TagBox[
      RowBox[{"f81", "[", "1", "]"}],
      HoldForm]}], "}"}]}], "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->3006]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Finite Fields Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 2.8337128}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Tutorial", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "A field is an algebraic structure obeying the rules of ordinary \
arithmetic. In particular, a field has binary operations of addition and \
multiplication, both of which are commutative and associative. A field has \
two special elements, the additive identity 0, and multiplicative identity 1. \
This package adds rules to Plus, Times, and Power so that arithmetic on field \
elements will be defined properly. It also provides low-level utilities for \
working with finite fields and for formatting finite field elements. For any \
finite field there is a fixed prime number p, called the characteristic of \
the field, such that the sum of p of the 1 field elements gives the 0 field \
element. A finite field of characteristic p has p^d elements for some \
positive integer d, which we will loosely call the extension degree. This \
package represents field elements as polynomials in a single variable. The \
polynomials have degree at most d-1 and their coefficients are integers \
reduced mod p. The internal form of a finite field element is \
GF[p,ilist][elist] where GF stands for Galois field, p is the prime \
characteristic of the field, ilist is the coefficient list of the irreducible \
polynomial which defines multiplication in the field, and elist is the \
coefficient list of the polynomial representing the particular element. \
Because this form can be a bit clumsy, the package provides several shortcuts \
for entering finite field elements. ", "synonyms" -> {}, "title" -> 
    "Finite Fields Package", "type" -> "Tutorial", "uri" -> 
    "FiniteFields/tutorial/FiniteFields"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3710, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4335, 95, 54, 1, 70, "Title",
 CellID->10681],
Cell[4392, 98, 1058, 29, 70, "Text",
 CellID->11901],
Cell[5453, 129, 1362, 42, 70, "Text",
 CellID->7671],
Cell[6818, 173, 1148, 35, 70, "Text",
 CellID->2794],
Cell[7969, 210, 3066, 92, 70, "DefinitionBox",
 CellID->13281],
Cell[11038, 304, 72, 1, 70, "Caption",
 CellID->17338],
Cell[11113, 307, 62, 1, 70, "MathCaption",
 CellID->9575],
Cell[11178, 310, 96, 3, 70, "Input",
 CellID->30826],
Cell[11277, 315, 100, 2, 70, "MathCaption",
 CellID->21553],
Cell[CellGroupData[{
Cell[11402, 321, 252, 9, 70, "Input",
 CellID->19353],
Cell[11657, 332, 267, 11, 36, "Output",
 CellID->32763]
}, Open  ]],
Cell[11939, 346, 263, 8, 70, "MathCaption",
 CellID->21935],
Cell[CellGroupData[{
Cell[12227, 358, 81, 2, 70, "Input",
 CellID->609431793],
Cell[12311, 362, 468, 17, 50, "Output",
 CellID->16166]
}, Open  ]],
Cell[12794, 382, 190, 9, 70, "MathCaption",
 CellID->5205],
Cell[CellGroupData[{
Cell[13009, 395, 381, 13, 70, "Input",
 CellID->5853],
Cell[13393, 410, 321, 12, 36, "Output",
 CellID->25084]
}, Open  ]],
Cell[13729, 425, 107, 3, 70, "MathCaption",
 CellID->8089],
Cell[CellGroupData[{
Cell[13861, 432, 226, 8, 70, "Input",
 CellID->30573],
Cell[14090, 442, 320, 12, 36, "Output",
 CellID->3047]
}, Open  ]],
Cell[14425, 457, 358, 9, 70, "MathCaption",
 CellID->23126],
Cell[CellGroupData[{
Cell[14808, 470, 202, 7, 70, "Input",
 CellID->1513],
Cell[15013, 479, 321, 12, 36, "Output",
 CellID->31887]
}, Open  ]],
Cell[15349, 494, 146, 4, 70, "MathCaption",
 CellID->30520],
Cell[CellGroupData[{
Cell[15520, 502, 337, 12, 70, "Input",
 CellID->31888],
Cell[15860, 516, 470, 19, 36, "Output",
 CellID->11856]
}, Open  ]],
Cell[16345, 538, 80, 1, 70, "MathCaption",
 CellID->3603],
Cell[CellGroupData[{
Cell[16450, 543, 219, 8, 70, "Input",
 CellID->7681],
Cell[16672, 553, 321, 12, 36, "Output",
 CellID->24844]
}, Open  ]],
Cell[17008, 568, 549, 13, 70, "Text",
 CellID->7061],
Cell[17560, 583, 186, 6, 70, "MathCaption",
 CellID->5633],
Cell[CellGroupData[{
Cell[17771, 593, 458, 16, 70, "Input",
 CellID->18835],
Cell[18232, 611, 199, 7, 36, "Output",
 CellID->14155]
}, Open  ]],
Cell[18446, 621, 196, 6, 70, "MathCaption",
 CellID->21014],
Cell[CellGroupData[{
Cell[18667, 631, 311, 11, 70, "Input",
 CellID->595],
Cell[18981, 644, 268, 11, 36, "Output",
 CellID->21989]
}, Open  ]],
Cell[19264, 658, 3141, 92, 70, "DefinitionBox",
 CellID->16856],
Cell[22408, 752, 61, 1, 70, "Caption",
 CellID->24259],
Cell[22472, 755, 3342, 113, 70, "Text",
 CellID->26487],
Cell[25817, 870, 518, 12, 70, "Text",
 CellID->21164],
Cell[26338, 884, 751, 18, 70, "Text",
 CellID->22027],
Cell[27092, 904, 741, 25, 70, "Text",
 CellID->15907],
Cell[27836, 931, 89, 1, 70, "MathCaption",
 CellID->11183],
Cell[27928, 934, 251, 7, 70, "Input",
 CellID->15426],
Cell[28182, 943, 94, 1, 70, "MathCaption",
 CellID->24275],
Cell[CellGroupData[{
Cell[28301, 948, 533, 18, 70, "Input",
 CellID->6769],
Cell[28837, 968, 526, 22, 36, "Output",
 CellID->4101]
}, Open  ]],
Cell[29378, 993, 161, 4, 70, "MathCaption",
 CellID->22118],
Cell[29542, 999, 241, 7, 70, "Input",
 CellID->434],
Cell[29786, 1008, 80, 1, 70, "MathCaption",
 CellID->26935],
Cell[CellGroupData[{
Cell[29891, 1013, 73, 2, 70, "Input",
 CellID->10458],
Cell[29967, 1017, 449, 19, 36, "Output",
 CellID->29192]
}, Open  ]],
Cell[30431, 1039, 91, 1, 70, "MathCaption",
 CellID->3615],
Cell[30525, 1042, 135, 4, 70, "Input",
 CellID->1823],
Cell[30663, 1048, 2310, 70, 70, "DefinitionBox",
 CellID->22485],
Cell[32976, 1120, 61, 1, 70, "Caption",
 CellID->4677],
Cell[33040, 1123, 870, 30, 70, "Text",
 CellID->32300],
Cell[33913, 1155, 244, 7, 70, "MathCaption",
 CellID->17925],
Cell[CellGroupData[{
Cell[34182, 1166, 188, 6, 70, "Input",
 CellID->29756],
Cell[34373, 1174, 155, 5, 36, "Output",
 CellID->25668]
}, Open  ]],
Cell[34543, 1182, 305, 8, 70, "MathCaption",
 CellID->27238],
Cell[CellGroupData[{
Cell[34873, 1194, 109, 3, 70, "Input",
 CellID->8528],
Cell[34985, 1199, 155, 5, 36, "Output",
 CellID->10353]
}, Open  ]],
Cell[35155, 1207, 219, 7, 70, "MathCaption",
 CellID->18419],
Cell[CellGroupData[{
Cell[35399, 1218, 104, 3, 70, "Input",
 CellID->29949],
Cell[35506, 1223, 155, 5, 36, "Output",
 CellID->8249]
}, Open  ]],
Cell[35676, 1231, 60, 1, 70, "MathCaption",
 CellID->18546],
Cell[CellGroupData[{
Cell[35761, 1236, 247, 7, 70, "Input",
 CellID->12752],
Cell[36011, 1245, 158, 5, 36, "Output",
 CellID->27941]
}, Open  ]],
Cell[36184, 1253, 109, 3, 70, "MathCaption",
 CellID->4111],
Cell[CellGroupData[{
Cell[36318, 1260, 132, 4, 70, "Input",
 CellID->259],
Cell[36453, 1266, 210, 7, 36, "Output",
 CellID->9733]
}, Open  ]],
Cell[36678, 1276, 2609, 77, 70, "DefinitionBox",
 CellID->17339],
Cell[39290, 1355, 73, 1, 70, "Caption",
 CellID->10348],
Cell[39366, 1358, 1033, 36, 70, "Text",
 CellID->21708],
Cell[40402, 1396, 77, 1, 70, "MathCaption",
 CellID->776],
Cell[CellGroupData[{
Cell[40504, 1401, 240, 8, 70, "Input",
 CellID->22060],
Cell[40747, 1411, 293, 10, 36, "Output",
 CellID->10029]
}, Open  ]],
Cell[41055, 1424, 2751, 81, 70, "DefinitionBox",
 CellID->18224],
Cell[43809, 1507, 90, 1, 70, "Caption",
 CellID->27414],
Cell[43902, 1510, 893, 26, 70, "Text",
 CellID->31891],
Cell[44798, 1538, 1052, 33, 70, "Text",
 CellID->14270],
Cell[45853, 1573, 1859, 64, 70, "Text",
 CellID->16845],
Cell[47715, 1639, 410, 7, 70, "Text",
 CellID->4509],
Cell[48128, 1648, 2141, 61, 70, "Text",
 CellID->13857],
Cell[50272, 1711, 1039, 28, 70, "Text",
 CellID->13034],
Cell[51314, 1741, 441, 12, 70, "MathCaption",
 CellID->19202],
Cell[CellGroupData[{
Cell[51780, 1757, 155, 5, 70, "Input",
 CellID->12051],
Cell[51938, 1764, 385, 13, 36, "Output",
 CellID->16461]
}, Open  ]],
Cell[52338, 1780, 358, 11, 70, "MathCaption",
 CellID->6460],
Cell[52699, 1793, 183, 6, 70, "Input",
 CellID->1454],
Cell[52885, 1801, 421, 15, 70, "MathCaption",
 CellID->17255],
Cell[CellGroupData[{
Cell[53331, 1820, 207, 7, 70, "Input",
 CellID->1277],
Cell[53541, 1829, 155, 5, 36, "Output",
 CellID->32592]
}, Open  ]],
Cell[53711, 1837, 343, 12, 70, "MathCaption",
 CellID->24123],
Cell[CellGroupData[{
Cell[54079, 1853, 178, 6, 70, "Input",
 CellID->7918],
Cell[54260, 1861, 268, 11, 36, "Output",
 CellID->17045]
}, Open  ]],
Cell[54543, 1875, 187, 4, 70, "MathCaption",
 CellID->2797],
Cell[CellGroupData[{
Cell[54755, 1883, 298, 10, 70, "Input",
 CellID->2268],
Cell[55056, 1895, 229, 8, 36, "Output",
 CellID->22927]
}, Open  ]],
Cell[55300, 1906, 2232, 65, 70, "Text",
 CellID->23438],
Cell[57535, 1973, 66, 1, 70, "MathCaption",
 CellID->8516],
Cell[CellGroupData[{
Cell[57626, 1978, 666, 22, 70, "Input",
 CellID->13586],
Cell[58295, 2002, 265, 9, 36, "Output",
 CellID->3379]
}, Open  ]],
Cell[58575, 2014, 253, 9, 70, "MathCaption",
 CellID->14473],
Cell[CellGroupData[{
Cell[58853, 2027, 704, 25, 44, "Input",
 CellID->22683],
Cell[59560, 2054, 720, 16, 36, "Output",
 Evaluatable->False,
 CellID->39205108]
}, Open  ]],
Cell[60295, 2073, 88, 1, 70, "MathCaption",
 CellID->10601],
Cell[CellGroupData[{
Cell[60408, 2078, 278, 8, 70, "Input",
 CellID->3828],
Cell[60689, 2088, 270, 9, 39, "Output",
 CellID->6681]
}, Open  ]],
Cell[60974, 2100, 270, 8, 70, "MathCaption",
 CellID->17073],
Cell[CellGroupData[{
Cell[61269, 2112, 241, 8, 28, "Input",
 CellID->9431],
Cell[61513, 2122, 871, 18, 36, "Output",
 Evaluatable->False,
 CellID->271196941]
}, Open  ]],
Cell[62399, 2143, 121, 3, 70, "MathCaption",
 CellID->6741],
Cell[CellGroupData[{
Cell[62545, 2150, 103, 3, 70, "Input",
 CellID->13519],
Cell[62651, 2155, 652, 23, 36, "Output",
 CellID->8402]
}, Open  ]],
Cell[CellGroupData[{
Cell[63340, 2183, 141, 6, 70, "Subsection",
 CellID->6436],
Cell[63484, 2191, 359, 9, 70, "Text",
 CellID->21747],
Cell[63846, 2202, 356, 7, 70, "Text",
 CellID->26038],
Cell[64205, 2211, 234, 10, 70, "MathCaption",
 CellID->13964],
Cell[64442, 2223, 242, 7, 70, "Input",
 CellID->2970],
Cell[64687, 2232, 68, 1, 70, "MathCaption",
 CellID->749],
Cell[CellGroupData[{
Cell[64780, 2237, 106, 4, 70, "Input",
 CellID->4593],
Cell[64889, 2243, 219, 9, 38, "Output",
 CellID->5074]
}, Open  ]],
Cell[65123, 2255, 249, 8, 70, "MathCaption",
 CellID->20839],
Cell[CellGroupData[{
Cell[65397, 2267, 324, 11, 70, "Input",
 CellID->16590],
Cell[65724, 2280, 254, 10, 36, "Output",
 CellID->4950]
}, Open  ]],
Cell[65993, 2293, 409, 12, 70, "MathCaption",
 CellID->28782],
Cell[CellGroupData[{
Cell[66427, 2309, 296, 10, 70, "Input",
 CellID->15856],
Cell[66726, 2321, 155, 5, 36, "Output",
 CellID->10990]
}, Open  ]],
Cell[66896, 2329, 259, 10, 70, "MathCaption",
 CellID->4119],
Cell[67158, 2341, 277, 8, 70, "Input",
 CellID->13882],
Cell[67438, 2351, 378, 12, 70, "MathCaption",
 CellID->29916],
Cell[CellGroupData[{
Cell[67841, 2367, 1321, 42, 70, "Input",
 CellID->24587],
Cell[69165, 2411, 579, 22, 39, "Output",
 CellID->684]
}, Open  ]],
Cell[69759, 2436, 585, 17, 70, "MathCaption",
 CellID->25065],
Cell[CellGroupData[{
Cell[70369, 2457, 615, 20, 70, "Input",
 CellID->25533],
Cell[70987, 2479, 516, 21, 36, "Output",
 CellID->15634]
}, Open  ]],
Cell[71518, 2503, 201, 7, 70, "MathCaption",
 CellID->26163],
Cell[CellGroupData[{
Cell[71744, 2514, 577, 18, 70, "Input",
 CellID->4813],
Cell[72324, 2534, 252, 9, 36, "Output",
 CellID->12658]
}, Open  ]],
Cell[72591, 2546, 224, 7, 70, "MathCaption",
 CellID->11478],
Cell[CellGroupData[{
Cell[72840, 2557, 109, 3, 70, "Input",
 CellID->13216],
Cell[72952, 2562, 299, 11, 36, "Output",
 CellID->28748]
}, Open  ]],
Cell[73266, 2576, 334, 12, 70, "MathCaption",
 CellID->17868],
Cell[CellGroupData[{
Cell[73625, 2592, 137, 4, 70, "Input",
 CellID->25636],
Cell[73765, 2598, 426, 17, 36, "Output",
 CellID->3006]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[74230, 2620, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

