(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11071,        364]
NotebookOptionsPosition[      7517,        270]
NotebookOutlinePosition[      9330,        309]
CellTagsIndexPosition[      9287,        306]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Fourier Series Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["NFourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NFourierTransform"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "numerical approximation to Fourier transform"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["NInverseFourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NInverseFourierTransform"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "numerical approximation to inverse Fourier transform"
}], "GuideText",
 CellID->1463276848],

Cell[TextData[{
 Cell[TextData[ButtonBox["NFourierSinTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NFourierSinTransform"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "numerical approximation to Fourier sine transform"
}], "GuideText",
 CellID->1602506930],

Cell[TextData[{
 Cell[TextData[ButtonBox["NFourierCosTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NFourierCosTransform"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 "  numerical approximation to Fourier cosine transform"
}], "GuideText",
 CellID->120894171],

Cell[TextData[{
 Cell[TextData[ButtonBox["NInverseFourierSinTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NInverseFourierSinTransform"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NInverseFourierCosTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NInverseFourierCosTransform"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1073016961],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["FourierCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/FourierCoefficient"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "coefficient in a Fourier exponential series expansion"
}], "GuideText",
 CellID->1831248882],

Cell[TextData[{
 Cell[TextData[ButtonBox["FourierSinCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/FourierSinCoefficient"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "coefficient in a Fourier sine series expansion"
}], "GuideText",
 CellID->64330970],

Cell[TextData[{
 Cell[TextData[ButtonBox["FourierCosCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/FourierCosCoefficient"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "coefficient in a Fourier cosine series expansion"
}], "GuideText",
 CellID->674243329],

Cell[TextData[{
 Cell[TextData[ButtonBox["NFourierCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NFourierCoefficient"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NFourierSinCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NFourierSinCoefficient"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NFourierCosCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NFourierCosCoefficient"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1336793167],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseFourierCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/InverseFourierCoefficient"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NInverseFourierCoefficient",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NInverseFourierCoefficient"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->261733647],

Cell["\t", "GuideDelimiter",
 CellID->1775879668],

Cell[TextData[{
 Cell[TextData[ButtonBox["FourierTrigSeries",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/FourierTrigSeries"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "Fourier trigonometric series expansion to a given order"
}], "GuideText",
 CellID->1026338349],

Cell[TextData[{
 Cell[TextData[ButtonBox["NFourierSeries",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NFourierSeries"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NFourierTrigSeries",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NFourierTrigSeries"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->508842855],

Cell["\t", "GuideDelimiter",
 CellID->2097102465],

Cell[TextData[{
 Cell[TextData[ButtonBox["DTFourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/DTFourierTransform"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " discrete time Fourier transform"
}], "GuideText",
 CellID->1499514691],

Cell[TextData[{
 Cell[TextData[ButtonBox["InverseDTFourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/InverseDTFourierTransform"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " inverse discrete time Fourier transform"
}], "GuideText",
 CellID->1622814092],

Cell[TextData[{
 Cell[TextData[ButtonBox["NDTFourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NDTFourierTransform"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["NInverseDTFourierTransform",
  BaseStyle->"Link",
  ButtonData->"paclet:FourierSeries/ref/NInverseDTFourierTransform"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->910896073]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "GuideTutorial",\

 CellID->57307975]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "GuideMoreAbout",
 CellID->1567025153],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fourier Series Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 3.1462208}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Guide", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NFourierTransform -- numerical approximation to Fourier transform, \
NInverseFourierTransform -- numerical approximation to inverse Fourier \
transform, NFourierSinTransform -- numerical approximation to Fourier sine \
transform, NFourierCosTransform -- numerical approximation to Fourier cosine \
transform, FourierCoefficient -- coefficient in a Fourier exponential series \
expansion, FourierSinCoefficient -- coefficient in a Fourier sine series \
expansion, FourierCosCoefficient -- coefficient in a Fourier cosine series \
expansion, FourierSeries -- Fourier exponential series expansion to a given \
order, FourierTrigSeries -- Fourier trigonometric series expansion to a given \
order, DTFourierTransform -- discrete time Fourier transform, \
InverseDTFourierTransform -- inverse discrete time Fourier transform", 
    "synonyms" -> {}, "title" -> "Fourier Series Package", "type" -> "Guide", 
    "uri" -> "FourierSeries/guide/FourierSeriesPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 64, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[686, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[745, 31, 308, 10, 70, "GuideText",
 CellID->203374175],
Cell[1056, 43, 331, 10, 70, "GuideText",
 CellID->1463276848],
Cell[1390, 55, 320, 10, 70, "GuideText",
 CellID->1602506930],
Cell[1713, 67, 317, 9, 70, "GuideText",
 CellID->120894171],
Cell[2033, 78, 507, 13, 70, "InlineGuideFunctionListing",
 CellID->1073016961],
Cell[2543, 93, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2594, 96, 320, 10, 70, "GuideText",
 CellID->1831248882],
Cell[2917, 108, 317, 10, 70, "GuideText",
 CellID->64330970],
Cell[3237, 120, 320, 10, 70, "GuideText",
 CellID->674243329],
Cell[3560, 132, 734, 20, 70, "InlineGuideFunctionListing",
 CellID->1336793167],
Cell[4297, 154, 500, 13, 70, "InlineGuideFunctionListing",
 CellID->261733647],
Cell[4800, 169, 49, 1, 70, "GuideDelimiter",
 CellID->1775879668],
Cell[4852, 172, 320, 10, 70, "GuideText",
 CellID->1026338349],
Cell[5175, 184, 462, 13, 70, "InlineGuideFunctionListing",
 CellID->508842855],
Cell[5640, 199, 49, 1, 70, "GuideDelimiter",
 CellID->2097102465],
Cell[5692, 202, 293, 9, 70, "GuideText",
 CellID->1499514691],
Cell[5988, 213, 315, 9, 70, "GuideText",
 CellID->1622814092],
Cell[6306, 224, 488, 13, 70, "InlineGuideFunctionListing",
 CellID->910896073]
}, Open  ]],
Cell[CellGroupData[{
Cell[6831, 242, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[6896, 245, 169, 4, 70, "GuideTutorial",
 CellID->57307975]
}, Open  ]],
Cell[CellGroupData[{
Cell[7102, 254, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[7167, 257, 155, 3, 70, "GuideMoreAbout",
 CellID->1567025153],
Cell[7325, 262, 150, 3, 70, "GuideMoreAbout",
 CellID->252299663]
}, Open  ]],
Cell[7490, 268, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

