(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15068,        540]
NotebookOptionsPosition[     11886,        433]
NotebookOutlinePosition[     13225,        470]
CellTagsIndexPosition[     13140,        465]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Fourier Series Package" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>",
       
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DTFourierTransform", "ObjectName",
 CellID->32261],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DTFourierTransform", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["\[Omega]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the discrete time Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as a function of ",
     Cell[BoxData[
      StyleBox["\[Omega]", "TR"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22860]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The discrete time Fourier transform of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["n", "TI"], "=", 
     RowBox[{"-", "\[Infinity]"}]}], "\[Infinity]"], 
   RowBox[{
    StyleBox["expr", "TI"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", 
      StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
      StyleBox["n", "TI"], " ", 
      StyleBox["\[Omega]", "TR"]}]]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2208],

Cell[TextData[{
 Cell[BoxData["DTFourierTransform"], "InlineFormula"],
 " returns a periodic function of ",
 Cell[BoxData[
  StyleBox["\[Omega]", "TR"]], "InlineFormula"],
 " with default period 1."
}], "Notes",
 CellID->8982],

Cell[TextData[{
 "Different choices for the definition of the discrete time Fourier transform \
can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22162],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the discrete time Fourier transform computed by ",
 Cell[BoxData["DTFourierTransform"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
     FractionBox[
      RowBox[{"1", "-", 
       StyleBox["a", "TI"]}], "2"]], " ", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["n", "TI"], "=", 
       RowBox[{"-", "\[Infinity]"}]}], "\[Infinity]"], 
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"2", " ", 
        StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
        StyleBox["b", "TI"], " ", 
        StyleBox["n", "TI"], " ", 
        StyleBox["\[Omega]", "TR"]}]]}]}]}], TraditionalForm]], 
  "InlineFormula"],
 ", a periodic function of ",
 Cell[BoxData[
  StyleBox["\[Omega]", "TR"]], "InlineFormula"],
 " with a default period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32506]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->531603241],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->15878102],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->265440469],

Cell["\<\
Use different definitions for calculating a discrete time Fourier transform:\
\>", "ExampleText",
 CellID->320560372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DTFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}], "^", "3"}]}], ",", " ", "n", 
   ",", "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->741030034],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    "\[Omega]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"LerchPhi", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
         "\[Omega]"}]], ",", "3", ",", 
       FractionBox["1", "2"]}], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]], 
     " ", 
     RowBox[{"LerchPhi", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]], 
       ",", "3", ",", 
       FractionBox["1", "2"]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{428, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19146536]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DTFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}], "^", "3"}]}], ",", " ", "n", 
   ",", "\[Omega]", ",", " ", 
   RowBox[{"FourierParameters", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->313783340],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"LerchPhi", "[", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        "\[Omega]"}]], ",", "3", ",", 
      FractionBox["1", "2"]}], "]"}], "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]], 
     " ", 
     RowBox[{"LerchPhi", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]], 
       ",", "3", ",", 
       FractionBox["1", "2"]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{378, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->649859520]
}, Open  ]],

Cell["Compare with the answer from a numerical approximation:", "ExampleText",
 CellID->67562546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DTFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}], "^", "3"}]}], ",", " ", "n", 
   ",", "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->361765068],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    "\[Omega]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"LerchPhi", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
         "\[Omega]"}]], ",", "3", ",", 
       FractionBox["1", "2"]}], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]], 
     " ", 
     RowBox[{"LerchPhi", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]], 
       ",", "3", ",", 
       FractionBox["1", "2"]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{428, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->21131740]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"\[Omega]", " ", "\[Rule]", " ", "0.9"}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->827463269],

Cell[BoxData[
 RowBox[{"0.21558299459634636`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.6634962333641163`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->150747756]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDTFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}], "^", "3"}]}], ",", " ", "n", 
   ",", "0.9"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->538446246],

Cell[BoxData[
 RowBox[{"0.21558299459635422`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.6634962333641419`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->4860940]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6878],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->11979]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DTFourierTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 3.3181002}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "DTFourierTransform[expr, n, \\[Omega]] gives the discrete time Fourier \
transform of expr as a function of \\[Omega], where expr is a function of n.",
     "synonyms" -> {}, "title" -> "DTFourierTransform", "type" -> "Symbol", 
    "uri" -> "FourierSeries/ref/DTFourierTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5304, 189, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->531603241]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12997, 458}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 632, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1255, 43, 56, 1, 70, "ObjectName",
 CellID->32261],
Cell[1314, 46, 862, 27, 70, "Usage",
 CellID->22860]
}, Open  ]],
Cell[CellGroupData[{
Cell[2213, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2691, 95, 600, 20, 70, "Notes",
 CellID->2208],
Cell[3294, 117, 226, 7, 70, "Notes",
 CellID->8982],
Cell[3523, 126, 304, 9, 70, "Notes",
 CellID->22162],
Cell[3830, 137, 1437, 47, 70, "Notes",
 CellID->32506]
}, Closed]],
Cell[CellGroupData[{
Cell[5304, 189, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->531603241],
Cell[CellGroupData[{
Cell[5689, 203, 147, 5, 70, "ExampleSection",
 CellID->15878102],
Cell[5839, 210, 138, 4, 70, "Input",
 CellID->265440469],
Cell[5980, 216, 127, 3, 70, "ExampleText",
 CellID->320560372],
Cell[CellGroupData[{
Cell[6132, 223, 288, 10, 28, "Input",
 CellID->741030034],
Cell[6423, 235, 1025, 31, 51, "Output",
 CellID->19146536]
}, Open  ]],
Cell[CellGroupData[{
Cell[7485, 271, 432, 14, 28, "Input",
 CellID->313783340],
Cell[7920, 287, 859, 26, 51, "Output",
 CellID->649859520]
}, Open  ]],
Cell[8794, 316, 97, 1, 70, "ExampleText",
 CellID->67562546],
Cell[CellGroupData[{
Cell[8916, 321, 288, 10, 70, "Input",
 CellID->361765068],
Cell[9207, 333, 1025, 31, 51, "Output",
 CellID->21131740]
}, Open  ]],
Cell[CellGroupData[{
Cell[10269, 369, 165, 5, 70, "Input",
 CellID->827463269],
Cell[10437, 376, 274, 7, 36, "Output",
 CellID->150747756]
}, Open  ]],
Cell[CellGroupData[{
Cell[10748, 388, 284, 10, 70, "Input",
 CellID->538446246],
Cell[11035, 400, 272, 7, 36, "Output",
 CellID->4860940]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11368, 414, 313, 9, 70, "TutorialsSection",
 CellID->6878],
Cell[11684, 425, 160, 3, 70, "Tutorials",
 CellID->11979]
}, Open  ]],
Cell[11859, 431, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

