(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20070,        715]
NotebookOptionsPosition[     16647,        600]
NotebookOutlinePosition[     18007,        637]
CellTagsIndexPosition[     17922,        632]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier Series Package" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierCoefficient"], 
          "FourierSinCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierSinCoefficient"], 
          "NFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCoefficient"], 
          "NFourierSinCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierSinCoefficient"], 
          "NFourierCosCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCosCoefficient"], 
          "InverseFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/InverseFourierCoefficient"], 
          "NInverseFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierCoefficient"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FourierCoefficient\"\>", 
       2->"\<\"FourierSinCoefficient\"\>", 3->"\<\"NFourierCoefficient\"\>", 
       4->"\<\"NFourierSinCoefficient\"\>", 
       5->"\<\"NFourierCosCoefficient\"\>", 
       6->"\<\"InverseFourierCoefficient\"\>", 
       7->"\<\"NInverseFourierCoefficient\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FourierCosCoefficient", "ObjectName",
 CellID->3293],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FourierCosCoefficient", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     "gives the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the Fourier cosine series expansion of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a periodic function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " with period ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21321]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], "th"]], "InlineFormula"],
 " coefficient in the Fourier cosine series expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{"2", 
   RowBox[{
    ButtonBox["Integrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Cos",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cos"], "[", 
       RowBox[{"2", 
        StyleBox["\[Pi]", "TR"], " ", 
        StyleBox["n", "TI"], " ", 
        StyleBox["t", "TI"]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["t", "TI"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], ">", "0"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", 
      FractionBox["1", "2"]}], "}"}]}], "]"}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "==", "0"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20785],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is numeric, it should be an explicit integer."
}], "Notes",
 CellID->26528],

Cell[TextData[{
 "Different choices for the definition of the Fourier cosine series expansion \
can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10443],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is assumed to have a period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 ", and the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], "th"]], "InlineFormula"],
 " coefficient computed by ",
 Cell[BoxData["FourierCosCoefficient"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["2", "TR"], 
    SuperscriptBox[
     StyleBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
     FractionBox[
      RowBox[{"1", "-", 
       StyleBox["a", "TI"]}], "2"]], " ", 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       RowBox[{
        ButtonBox["Cos",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Cos"], "[", 
        RowBox[{"2", 
         StyleBox["\[Pi]", "TR"], " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["n", "TI"], " ", 
         StyleBox["t", "TI"]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], ">", "0"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
     FractionBox[
      RowBox[{"1", "-", 
       StyleBox["a", "TI"]}], "2"]], " ", 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "==", "0"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31000],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["FourierCosCoefficient"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10555]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->51072247],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->77180040],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->618443208],

Cell["\<\
Use different definitions for calculating a coefficient in a Fourier cosine \
series:\
\>", "ExampleText",
 CellID->320560372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosCoefficient", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "t", "]"}], ",", " ", "t", ",", " ", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->353252039],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "n"]}], 
  RowBox[{
   SuperscriptBox["n", "2"], " ", 
   SuperscriptBox["\[Pi]", "2"]}]]], "Output",
 ImageSize->{70, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->65501613]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosCoefficient", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "t", "]"}], ",", "t", ",", "n", ",", "  ", 
   RowBox[{"FourierParameters", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->166428240],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "n"]}], 
  RowBox[{"4", " ", 
   SuperscriptBox["n", "2"], " ", 
   SuperscriptBox["\[Pi]", "2"]}]]], "Output",
 ImageSize->{70, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43875254]
}, Open  ]],

Cell["Compare with the answer from a numerical approximation:", "ExampleText",
 CellID->67562546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCosCoefficient", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "t", "]"}], ",", " ", "t", ",", " ", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21806543],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "n"]}], 
  RowBox[{
   SuperscriptBox["n", "2"], " ", 
   SuperscriptBox["\[Pi]", "2"]}]]], "Output",
 ImageSize->{70, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->184944042]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"n", "\[Rule]", " ", "7."}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->38016284],

Cell[BoxData[
 RowBox[{"-", "0.0041355585160137865`"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->441373798]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierCosCoefficient", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "t", "]"}], ",", " ", "t", ",", " ", "7"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->36656652],

Cell[BoxData[
 RowBox[{"-", "0.0041355585160137535`"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->498728907]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14631],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierSinCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierSinCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierSinCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierSinCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCosCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCosCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/InverseFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13640]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24671],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->9270]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FourierCosCoefficient - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 3.7243606}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "FourierCosCoefficient[expr, t, n] gives the n^th coefficient in the \
Fourier cosine series expansion of expr, where expr is a periodic function of \
t with period 1.", "synonyms" -> {}, "title" -> "FourierCosCoefficient", 
    "type" -> "Symbol", "uri" -> "FourierSeries/ref/FourierCosCoefficient"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10110, 343, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->51072247]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17779, 625}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2339, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2962, 82, 58, 1, 70, "ObjectName",
 CellID->3293],
Cell[3023, 85, 988, 32, 70, "Usage",
 CellID->21321]
}, Open  ]],
Cell[CellGroupData[{
Cell[4048, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4526, 139, 1499, 56, 70, "Notes",
 CellID->20785],
Cell[6028, 197, 159, 6, 70, "Notes",
 CellID->26528],
Cell[6190, 205, 304, 9, 70, "Notes",
 CellID->10443],
Cell[6497, 216, 2958, 100, 70, "Notes",
 CellID->31000],
Cell[9458, 318, 615, 20, 70, "Notes",
 CellID->10555]
}, Closed]],
Cell[CellGroupData[{
Cell[10110, 343, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->51072247],
Cell[CellGroupData[{
Cell[10494, 357, 147, 5, 70, "ExampleSection",
 CellID->77180040],
Cell[10644, 364, 138, 4, 70, "Input",
 CellID->618443208],
Cell[10785, 370, 136, 4, 70, "ExampleText",
 CellID->320560372],
Cell[CellGroupData[{
Cell[10946, 378, 194, 6, 28, "Input",
 CellID->353252039],
Cell[11143, 386, 367, 14, 54, "Output",
 CellID->65501613]
}, Open  ]],
Cell[CellGroupData[{
Cell[11547, 405, 304, 8, 28, "Input",
 CellID->166428240],
Cell[11854, 415, 377, 14, 54, "Output",
 CellID->43875254]
}, Open  ]],
Cell[12246, 432, 97, 1, 70, "ExampleText",
 CellID->67562546],
Cell[CellGroupData[{
Cell[12368, 437, 193, 6, 70, "Input",
 CellID->21806543],
Cell[12564, 445, 368, 14, 54, "Output",
 CellID->184944042]
}, Open  ]],
Cell[CellGroupData[{
Cell[12969, 464, 151, 5, 70, "Input",
 CellID->38016284],
Cell[13123, 471, 196, 6, 36, "Output",
 CellID->441373798]
}, Open  ]],
Cell[CellGroupData[{
Cell[13356, 482, 194, 6, 70, "Input",
 CellID->36656652],
Cell[13553, 490, 196, 6, 36, "Output",
 CellID->498728907]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13810, 503, 311, 9, 70, "SeeAlsoSection",
 CellID->14631],
Cell[14124, 514, 1968, 62, 70, "SeeAlso",
 CellID->13640]
}, Open  ]],
Cell[CellGroupData[{
Cell[16129, 581, 314, 9, 70, "TutorialsSection",
 CellID->24671],
Cell[16446, 592, 159, 3, 70, "Tutorials",
 CellID->9270]
}, Open  ]],
Cell[16620, 598, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

