(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26315,        707]
NotebookOptionsPosition[     23384,        609]
NotebookOutlinePosition[     24704,        646]
CellTagsIndexPosition[     24619,        641]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Fourier Series Package" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>",
       
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FourierSeries", "ObjectName",
 CellID->6329],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FourierSeries", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " Fourier exponential series expansion of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a periodic function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " with period 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1088]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The order ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " Fourier exponential series expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["k", "TI"], "=", 
     RowBox[{"-", 
      StyleBox["n", "TI"]}]}], 
    StyleBox["n", "TI"]], 
   RowBox[{
    SubscriptBox["F", 
     StyleBox["k", "TI"]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", 
      StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
      StyleBox["k", "TI"], " ", 
      StyleBox["t", "TI"]}]]}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox["F", 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["expr", "TI"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", 
       StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
       StyleBox["k", "TI"], " ", 
       StyleBox["t", "TI"]}]]}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", 
      FractionBox["1", "2"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28854],

Cell[TextData[{
 "Different choices for the period of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8613],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is assumed to have a period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 ", and the order ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " Fourier exponential series expansion computed by ",
 Cell[BoxData["FourierSeries"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["k", "TI"], "=", 
      RowBox[{"-", 
       StyleBox["n", "TI"]}]}], 
     StyleBox["n", "TI"]], 
    RowBox[{
     SubscriptBox["F", 
      StyleBox["k", "TI"]], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", 
       StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
       StyleBox["b", "TI"], " ", 
       StyleBox["k", "TI"], " ", 
       StyleBox["t", "TI"]}]]}]}], TraditionalForm]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox["F", 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["k", "TI"], " ", 
         StyleBox["t", "TI"]}]]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24979],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["FourierSeries"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18569]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->364547634],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->475358004],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->672109741],

Cell["\<\
Compute the exponential Fourier series for a periodic function with period 1:\
\
\>", "ExampleText",
 CellID->422210899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FourierSeries", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], "^", "2"}], ",", "t", ",", " ", "3"}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->252796276],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWVlPFEEQ7j0R8YDF4IHKqqCIGg0mRFB0VUQSJYrRGB8krIQEjEbDYZRo
fNO/4KNPPvjgX+CnjdPXzuw3NTs9924C09VdVV91dU1Pd9Vic3t97X1ze2O1
WX+42fy4vrG6VZ//sGl3lQqMFX4wxhaOMbtt2S3xx38/7T/ZxNZp+3/FZjus
nmXeW9JydhPo2ZD8dxVfFfo5zcmKIV5PRPmh1ixZpdUr+uQcvL0VsrcRW8Mc
2Yt+oWXD2ISeCqPxuHiOEL6m1lAglR2aidWOJnnLouOpovppe6sePdOKH+Og
GlKP9EQdtAxQ81A013MvJP88YWXw2gWhmkUAapEzPhMwgypIcT9zcjaiHEYM
vs/6Pd9niOu3z/jJDwr6bID1nLtHiykldyLI3AeeA+TKVAzQDhpLHhHNMDvg
IcCajiE768+VKm5N9I9YcpUH1PMwcM0EjN9W/f0R5aUVc65ebusK0KsB4zJG
H4DuFaBXA8alLbwpv/xrMP4a6DdAv4oh1St69/b2mPwtiRhtNBqKi4er851w
+B4b8kXVV8jcE47/ndYj+3/RZuxTzyWgXwaMV1ta3Hh9QD8JGH8RU158udl+
5fkx0eXEMGutidzi9U8rwe910aLPA4Oqv56y/vMp6a+p/jMp6Zer0Ovq5VrG
VaQUCS0e2rO3khgd6Bqgn8sV/WKm6O5TAJcfzRSdXv3Lufj9Qi6oVzJBxVUe
zwSVXt2SivHsfV1S8Z0P8kQmyLjSvDmWCTK92ojF/c9JvDdxPpN9J6znUX4k
Z/yxlPFx/VG+njK+c6rih4V9Cq2sntSpgLICrXPLFxlr3ReZD28nelDZpm/U
3Whbr0tnGNswm5CkbTVlm1tnt9gmo25AWejOJiCqGGrLnJXpHvcM7GaNQuxA
nwCazPtmZIeOdg9+SHs8e0YEe4a7xA4ZMUdDSDFiRXh0uWOXmpG+9ZYtZ//g
z1M5YvPbXJnQGYTZEwNzOAfMaqRVLilLFyLKPYb+TruZW+5hRLlJQQ8RftS+
oCoMiBbEv0j4mOJbMOSbJNcGs1KYJcRxUZGQ2eIOXJjbwvGG0MKb/pVHp7Vr
tdcU9ZcwqLY3FVHuq0DV+ZZNTnlO65jNp8/0dGWFzlvH0fi9ZbF3bAv06koX
VoFoPG/layZhfdJ2fNd3gDbzDtasbiaiRVqIUYMW9gOto82vsjQVU/6LoPG8
hVZhxcE/qrAudCMxTbuiifHxkZQ3WyGs5kwmqOuz1fldKinNeq8tMW9d57oh
n8TSJ/PfrlGOtgK0XPFB0DFhtWf78U16BvQKaQOe5y4Bjdl83DP5v2tCE+X1
ivZzWhltOL90+hYtU7THatR6yMo8Txt7TtI2p7ol72o2rbhMbn18Kr1WHnPW
55ikanl6Nmbrje9DN69z0Fz4rkOdexLNQWXyBuK43icSyWfAbnZVqMM4wF0J
rYpyN/bfS8Ve75yW1Ez1VyXKDQ2xn1vtX49nQL8TEH8J7W76acD4W6FFv6lN
K5sacFo1VDkbjDH8WudbUx3NFN3MI/nUGbOpvZl5gDfzq8VlU5cy80S31anq
KePTXuE7oa7buO8J3VQbKVnRbEuz/kB7c11ZrJLNaqnzrAS4Iy6KHUlk3qWv
9DngQ4BVaWbBT8bEjpOZlueYHcs/Ntt2S8vJEIfh/9VCQW7TzLAJv0T5pLiW
1fOf6P0GvJh5/SO4eFPmVlnhP1+ml5g=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{390, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->360612438]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16030719],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->379409168]
}, Open  ]],

Cell["Compare with a plot of the original function:", "ExampleText",
 CellID->102149367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"(", 
      RowBox[{"t", "-", 
       RowBox[{"Round", "[", "t", "]"}]}], ")"}], "]"}], "^", "2"}], ",", " ",
    
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3952088],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[4]=",
 CellID->184803329]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->666],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->7679]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FourierSeries - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 4.0212432}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "FourierSeries[expr, t, n] gives the order n Fourier exponential series \
expansion of expr, where expr is a periodic function of t with period 1.", 
    "synonyms" -> {}, "title" -> "FourierSeries", "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/FourierSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7430, 266, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->364547634]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24476, 634}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 632, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1255, 43, 50, 1, 70, "ObjectName",
 CellID->6329],
Cell[1308, 46, 859, 27, 70, "Usage",
 CellID->1088]
}, Open  ]],
Cell[CellGroupData[{
Cell[2204, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2682, 95, 1384, 50, 70, "Notes",
 CellID->28854],
Cell[4069, 147, 327, 11, 70, "Notes",
 CellID->8613],
Cell[4399, 160, 2384, 79, 70, "Notes",
 CellID->24979],
Cell[6786, 241, 607, 20, 70, "Notes",
 CellID->18569]
}, Closed]],
Cell[CellGroupData[{
Cell[7430, 266, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->364547634],
Cell[CellGroupData[{
Cell[7815, 280, 148, 5, 70, "ExampleSection",
 CellID->475358004],
Cell[7966, 287, 138, 4, 70, "Input",
 CellID->672109741],
Cell[8107, 293, 130, 4, 70, "ExampleText",
 CellID->422210899],
Cell[CellGroupData[{
Cell[8262, 301, 228, 8, 28, "Input",
 CellID->252796276],
Cell[8493, 311, 1952, 36, 93, "Output",
 Evaluatable->False,
 CellID->360612438]
}, Open  ]],
Cell[CellGroupData[{
Cell[10482, 352, 207, 7, 28, "Input",
 CellID->16030719],
Cell[10692, 361, 5738, 98, 170, "Output",
 Evaluatable->False,
 CellID->379409168]
}, Open  ]],
Cell[16445, 462, 88, 1, 70, "ExampleText",
 CellID->102149367],
Cell[CellGroupData[{
Cell[16558, 467, 361, 13, 28, "Input",
 CellID->3952088],
Cell[16922, 482, 5885, 101, 172, "Output",
 Evaluatable->False,
 CellID->184803329]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22868, 590, 312, 9, 70, "TutorialsSection",
 CellID->666],
Cell[23183, 601, 159, 3, 70, "Tutorials",
 CellID->7679]
}, Open  ]],
Cell[23357, 607, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

