(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28115,        745]
NotebookOptionsPosition[     25168,        648]
NotebookOutlinePosition[     26519,        685]
CellTagsIndexPosition[     26434,        680]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Fourier Series Package" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>",
       
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NFourierSeries", "ObjectName",
 CellID->1663],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NFourierSeries", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a numerical approximation to the order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " Fourier exponential series expansion of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a periodic function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " with period 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10615]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the order ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " Fourier exponential series expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["k", "TI"], "=", 
     RowBox[{"-", 
      StyleBox["n", "TI"]}]}], 
    StyleBox["n", "TI"]], 
   RowBox[{
    SubscriptBox["F", 
     StyleBox["k", "TI"]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", 
      StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
      StyleBox["k", "TI"], " ", 
      StyleBox["t", "TI"]}]]}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox["F", 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["expr", "TI"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", 
       StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
       StyleBox["k", "TI"], " ", 
       StyleBox["t", "TI"]}]]}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", 
      FractionBox["1", "2"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25897],

Cell[TextData[{
 "Different choices for the period of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18677],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is assumed to have a period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 ", and the order ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " Fourier exponential series expansion computed by ",
 Cell[BoxData["NFourierSeries"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["k", "TI"], "=", 
      RowBox[{"-", 
       StyleBox["n", "TI"]}]}], 
     StyleBox["n", "TI"]], 
    RowBox[{
     SubscriptBox["F", 
      StyleBox["k", "TI"]], 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", 
       StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
       StyleBox["b", "TI"], " ", 
       StyleBox["k", "TI"], " ", 
       StyleBox["t", "TI"]}]]}]}], TraditionalForm]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox["F", 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox[
     RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["k", "TI"], " ", 
         StyleBox["t", "TI"]}]]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2774],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NFourierSeries"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10134]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104442283],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->313832860],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->248551791],

Cell["Numerical approximation for an exponential Fourier series:", \
"ExampleText",
 CellID->11183098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NFourierSeries", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Cos", "[", "t", "]"}], "]"}], "+", 
     RowBox[{
      RowBox[{"Abs", "[", "t", "]"}], "/", "5"}]}], ",", "t", ",", " ", "4"}],
    "]"}], " ", "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->252796276],

Cell[BoxData[
 RowBox[{"0.8679867036057615`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.005811107722182851`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]]}], 
  "-", 
  RowBox[{"0.005811107722182851`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]]}], "-", 
  RowBox[{"0.0038281154187977053`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]]}], 
  "-", 
  RowBox[{"0.0038281154187977053`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]]}], "-", 
  RowBox[{"0.0005368829817693233`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "6"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]]}], 
  "-", 
  RowBox[{"0.0005368829817693233`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"6", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]]}], "-", 
  RowBox[{"0.0009669770125366225`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "8"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]]}], 
  "-", 
  RowBox[{"0.0009669770125366225`", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
    "8", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]]}]}]], "Output",
 ImageSize->{561, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->341556997]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->700431304],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->853861509]
}, Open  ]],

Cell["Compare with a plot of the original periodic function:", "ExampleText",
 CellID->2555068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Cos", "[", 
      RowBox[{"(", 
       RowBox[{"t", "-", 
        RowBox[{"Round", "[", "t", "]"}]}], ")"}], "]"}], "]"}], "+", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"t", "-", 
       RowBox[{"Round", "[", "t", "]"}]}], "]"}], "/", "5"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->220097367],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[4]=",
 CellID->557253883]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27553],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->19533]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NFourierSeries - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 12.1620766}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NFourierSeries[expr, t, n] gives a numerical approximation to the order \
n Fourier exponential series expansion of expr, where expr is a periodic \
function of t with period 1.", "synonyms" -> {}, "title" -> "NFourierSeries", 
    "type" -> "Symbol", "uri" -> "FourierSeries/ref/NFourierSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7502, 266, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->104442283]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26291, 673}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 632, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1255, 43, 51, 1, 70, "ObjectName",
 CellID->1663],
Cell[1309, 46, 889, 27, 70, "Usage",
 CellID->10615]
}, Open  ]],
Cell[CellGroupData[{
Cell[2235, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2713, 95, 1417, 50, 70, "Notes",
 CellID->25897],
Cell[4133, 147, 328, 11, 70, "Notes",
 CellID->18677],
Cell[4464, 160, 2386, 79, 70, "Notes",
 CellID->2774],
Cell[6853, 241, 612, 20, 70, "Notes",
 CellID->10134]
}, Closed]],
Cell[CellGroupData[{
Cell[7502, 266, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104442283],
Cell[CellGroupData[{
Cell[7887, 280, 148, 5, 70, "ExampleSection",
 CellID->313832860],
Cell[8038, 287, 138, 4, 70, "Input",
 CellID->248551791],
Cell[8179, 293, 102, 2, 70, "ExampleText",
 CellID->11183098],
Cell[CellGroupData[{
Cell[8306, 299, 337, 11, 28, "Input",
 CellID->252796276],
Cell[8646, 312, 1541, 39, 56, "Output",
 CellID->341556997]
}, Open  ]],
Cell[CellGroupData[{
Cell[10224, 356, 208, 7, 28, "Input",
 CellID->700431304],
Cell[10435, 365, 6556, 112, 160, "Output",
 Evaluatable->False,
 CellID->853861509]
}, Open  ]],
Cell[17006, 480, 95, 1, 70, "ExampleText",
 CellID->2555068],
Cell[CellGroupData[{
Cell[17126, 485, 517, 17, 28, "Input",
 CellID->220097367],
Cell[17646, 504, 6942, 118, 160, "Output",
 Evaluatable->False,
 CellID->557253883]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24649, 629, 314, 9, 70, "TutorialsSection",
 CellID->27553],
Cell[24966, 640, 160, 3, 70, "Tutorials",
 CellID->19533]
}, Open  ]],
Cell[25141, 646, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

