(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15729,        562]
NotebookOptionsPosition[     12596,        458]
NotebookOutlinePosition[     13981,        496]
CellTagsIndexPosition[     13896,        491]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier Series Package" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NFourierTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierTransform"], 
          "NInverseFourierTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierTransform"], 
          "NFourierCosTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCosTransform"], 
          "NInverseFourierSinTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierSinTransform"], 
          "NInverseFourierCosTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierCosTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NFourierTransform\"\>", 
       2->"\<\"NInverseFourierTransform\"\>", 
       3->"\<\"NFourierCosTransform\"\>", 
       4->"\<\"NInverseFourierSinTransform\"\>", 
       5->"\<\"NInverseFourierCosTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NFourierSinTransform", "ObjectName",
 CellID->24008],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NFourierSinTransform", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["\[Omega]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a numerical approximation to the Fourier sine \
transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData[
      StyleBox["\[Omega]", "TR"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14541]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the Fourier sine transform of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    FractionBox["2", 
     StyleBox["\[Pi]", "TR"]]], 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Sin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sin"], "[", 
       RowBox[{
        StyleBox["\[Omega]", "TR"], " ", 
        StyleBox["t", "TI"]}], 
       StyleBox["]", "TI"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["t", "TI"], ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]],
   "InlineFormula"],
 "."
}], "Notes",
 CellID->225],

Cell[TextData[{
 "Different choices for the definition of the Fourier cosine transform can be \
specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15536],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the Fourier cosine transform computed by ",
 Cell[BoxData["NFourierSinTransform"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"2", 
   SqrtBox[
    FractionBox[
     FormBox[
      StyleBox[
       RowBox[{"|", "b", "|"}], "TI"],
      TraditionalForm], 
     SuperscriptBox[
      StyleBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], "TR"], 
      RowBox[{"1", "-", 
       StyleBox["a", "TI"]}]]]], 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Sin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sin"], "[", 
       RowBox[{
        StyleBox["b", "TI"], " ", 
        StyleBox["\[Omega]", "TR"], " ", 
        StyleBox["t", "TI"]}], 
       StyleBox["]", "TI"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["t", "TI"], ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]}]],
   "InlineFormula"],
 "."
}], "Notes",
 CellID->11980],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " in the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " must be numeric."
}], "Notes",
 CellID->716],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NFourierSinTransform"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30470]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->50893236],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->744606645],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->486909322],

Cell["Numerical approximation for a Fourier sine transform:", "ExampleText",
 CellID->60323419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierSinTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"t", "+", "3"}], ")"}], " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", "t"}], ")"}]}]}], ",", " ", "t", ",", " ", "0.9"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13514770],

Cell[BoxData["1.6285992612716866`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108046721]
}, Open  ]],

Cell["Compare with the answer from symbolic evaluation:", "ExampleText",
 CellID->813151740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"t", "+", "3"}], ")"}], " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", "t"}], ")"}]}]}], ",", " ", "t", ",", " ", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->666270353],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "\[Omega]", " ", 
   RowBox[{"(", 
    RowBox[{"5", "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["\[Omega]", "2"]}]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["\[Omega]", "2"]}], ")"}], "2"]]], "Output",
 ImageSize->{108, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->363336609]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"\[Omega]", "\[Rule]", " ", "0.9"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13445192],

Cell[BoxData["1.6285992668382407`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->133427232]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6204],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10700]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15384],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->28747]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NFourierSinTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 18.4122366}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NFourierSinTransform[expr, t, \\[Omega]] gives a numerical approximation \
to the Fourier sine transform of expr evaluated at the numerical value \
\\[Omega], where expr is a function of n.", "synonyms" -> {}, "title" -> 
    "NFourierSinTransform", "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/NFourierSinTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7672, 267, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->50893236]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13754, 484}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1997, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2620, 75, 58, 1, 70, "ObjectName",
 CellID->24008],
Cell[2681, 78, 902, 28, 70, "Usage",
 CellID->14541]
}, Open  ]],
Cell[CellGroupData[{
Cell[3620, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4098, 128, 849, 31, 70, "Notes",
 CellID->225],
Cell[4950, 161, 297, 9, 70, "Notes",
 CellID->15536],
Cell[5250, 172, 1344, 50, 70, "Notes",
 CellID->11980],
Cell[6597, 224, 417, 16, 70, "Notes",
 CellID->716],
Cell[7017, 242, 618, 20, 70, "Notes",
 CellID->30470]
}, Closed]],
Cell[CellGroupData[{
Cell[7672, 267, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->50893236],
Cell[CellGroupData[{
Cell[8056, 281, 148, 5, 70, "ExampleSection",
 CellID->744606645],
Cell[8207, 288, 138, 4, 70, "Input",
 CellID->486909322],
Cell[8348, 294, 95, 1, 70, "ExampleText",
 CellID->60323419],
Cell[CellGroupData[{
Cell[8468, 299, 311, 11, 28, "Input",
 CellID->13514770],
Cell[8782, 312, 176, 5, 36, "Output",
 CellID->108046721]
}, Open  ]],
Cell[8973, 320, 92, 1, 70, "ExampleText",
 CellID->813151740],
Cell[CellGroupData[{
Cell[9090, 325, 316, 11, 70, "Input",
 CellID->666270353],
Cell[9409, 338, 476, 17, 83, "Output",
 CellID->363336609]
}, Open  ]],
Cell[CellGroupData[{
Cell[9922, 360, 159, 5, 70, "Input",
 CellID->13445192],
Cell[10084, 367, 176, 5, 36, "Output",
 CellID->133427232]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10321, 379, 310, 9, 70, "SeeAlsoSection",
 CellID->6204],
Cell[10634, 390, 1406, 44, 70, "SeeAlso",
 CellID->10700]
}, Open  ]],
Cell[CellGroupData[{
Cell[12077, 439, 314, 9, 70, "TutorialsSection",
 CellID->15384],
Cell[12394, 450, 160, 3, 70, "Tutorials",
 CellID->28747]
}, Open  ]],
Cell[12569, 456, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

