(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20208,        649]
NotebookOptionsPosition[     16870,        537]
NotebookOutlinePosition[     18226,        574]
CellTagsIndexPosition[     18141,        569]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier Series Package" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NInverseFourierTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierTransform"], 
          "NFourierSinTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierSinTransform"], 
          "NFourierCosTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCosTransform"], 
          "NInverseFourierSinTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierSinTransform"], 
          "NInverseFourierCosTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierCosTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NInverseFourierTransform\"\>", 
       2->"\<\"NFourierSinTransform\"\>", 3->"\<\"NFourierCosTransform\"\>", 
       4->"\<\"NInverseFourierSinTransform\"\>", 
       5->"\<\"NInverseFourierCosTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NFourierTransform", "ObjectName",
 CellID->5279],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"NFourierTransform", "["}], 
       StyleBox["expr", "TI"], ",", 
       StyleBox["t", "TI"], ",", 
       StyleBox["w", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a numerical approximation to the Fourier \
transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData[
      StyleBox["\[Omega]", "TR"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17776]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the Fourier transform of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    FractionBox["1", 
     StyleBox[
      RowBox[{"2", "\[Pi]"}], "TR"]]], 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", 
        StyleBox["\[Omega]", "TR"], " ", 
        StyleBox["t", "TI"]}]]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["t", "TI"], ",", 
       RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->25822],

Cell[TextData[{
 "Different choices for the definition of the Fourier transform can be \
specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6879],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the Fourier transform computed by ",
 Cell[BoxData["NFourierTransform"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    FractionBox[
     FormBox[
      StyleBox[
       RowBox[{"|", "b", "|"}], "TI"],
      TraditionalForm], 
     SuperscriptBox[
      StyleBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], "TR"], 
      RowBox[{"1", "-", 
       StyleBox["a", "TI"]}]]]], 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", 
        StyleBox["b", "TI"], " ", 
        StyleBox["\[Omega]", "TR"], " ", 
        StyleBox["t", "TI"]}]]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["t", "TI"], ",", 
       RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->32301],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " in the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " must be numeric."
}], "Notes",
 CellID->15812],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NFourierTransform"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5676]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->42458733],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->202588362],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->270029095],

Cell["Numerical Fourier transform for a box function:", "ExampleText",
 CellID->52835497],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "t_", "]"}], ":=", 
  RowBox[{
   RowBox[{"UnitStep", "[", 
    RowBox[{"1", "-", "t"}], "]"}], " ", 
   RowBox[{"UnitStep", "[", 
    RowBox[{"t", "+", "1"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155097842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"NFourierTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "t", "]"}], ",", "t", ",", " ", "\[Omega]"}], "]"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", " ", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->435792868],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->22614711]
}, Open  ]],

Cell["Compare with the answer from symbolic evaluation:", "ExampleText",
 CellID->1889310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierTransform", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", " ", "t", ",", " ", "0.7"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->32127759],

Cell[BoxData[
 RowBox[{"0.7343019234901191`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.2456981708697573`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->429964845]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"f", "[", "t", "]"}], ",", " ", "t", ",", " ", "\[Omega]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->197062079],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", 
   RowBox[{"Sin", "[", "\[Omega]", "]"}]}], "\[Omega]"]], "Output",
 ImageSize->{84, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->288541647]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"\[Omega]", " ", "\[Rule]", " ", "0.7"}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->11873721],

Cell[BoxData["0.7343019234901184`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->393141086]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24312],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10144]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3164],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->7357]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NFourierTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 18.5997414}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NFourierTransform[ expr, t, w] gives a numerical approximation to the \
Fourier transform of expr evaluated at the numerical value \\[Omega], where \
expr is a function of n.", "synonyms" -> {}, "title" -> "NFourierTransform", 
    "type" -> "Symbol", "uri" -> "FourierSeries/ref/NFourierTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7555, 261, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->42458733]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17999, 562}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1998, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2621, 74, 54, 1, 70, "ObjectName",
 CellID->5279],
Cell[2678, 77, 884, 28, 70, "Usage",
 CellID->17776]
}, Open  ]],
Cell[CellGroupData[{
Cell[3599, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4077, 127, 823, 29, 70, "Notes",
 CellID->25822],
Cell[4903, 158, 289, 9, 70, "Notes",
 CellID->6879],
Cell[5195, 169, 1284, 47, 70, "Notes",
 CellID->32301],
Cell[6482, 218, 419, 16, 70, "Notes",
 CellID->15812],
Cell[6904, 236, 614, 20, 70, "Notes",
 CellID->5676]
}, Closed]],
Cell[CellGroupData[{
Cell[7555, 261, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->42458733],
Cell[CellGroupData[{
Cell[7939, 275, 148, 5, 70, "ExampleSection",
 CellID->202588362],
Cell[8090, 282, 138, 4, 70, "Input",
 CellID->270029095],
Cell[8231, 288, 89, 1, 70, "ExampleText",
 CellID->52835497],
Cell[8323, 291, 267, 9, 70, "Input",
 CellID->155097842],
Cell[CellGroupData[{
Cell[8615, 304, 414, 12, 28, "Input",
 CellID->435792868],
Cell[9032, 318, 3997, 70, 165, "Output",
 Evaluatable->False,
 CellID->22614711]
}, Open  ]],
Cell[13044, 391, 90, 1, 70, "ExampleText",
 CellID->1889310],
Cell[CellGroupData[{
Cell[13159, 396, 189, 6, 70, "Input",
 CellID->32127759],
Cell[13351, 404, 278, 7, 36, "Output",
 CellID->429964845]
}, Open  ]],
Cell[CellGroupData[{
Cell[13666, 416, 194, 6, 70, "Input",
 CellID->197062079],
Cell[13863, 424, 286, 10, 76, "Output",
 CellID->288541647]
}, Open  ]],
Cell[CellGroupData[{
Cell[14186, 439, 164, 5, 70, "Input",
 CellID->11873721],
Cell[14353, 446, 176, 5, 36, "Output",
 CellID->393141086]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14590, 458, 311, 9, 70, "SeeAlsoSection",
 CellID->24312],
Cell[14904, 469, 1412, 44, 70, "SeeAlso",
 CellID->10144]
}, Open  ]],
Cell[CellGroupData[{
Cell[16353, 518, 313, 9, 70, "TutorialsSection",
 CellID->3164],
Cell[16669, 529, 159, 3, 70, "Tutorials",
 CellID->7357]
}, Open  ]],
Cell[16843, 535, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

