(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29759,        845]
NotebookOptionsPosition[     26670,        743]
NotebookOutlinePosition[     28045,        781]
CellTagsIndexPosition[     27960,        776]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Fourier Series Package" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>",
       
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NFourierTrigSeries", "ObjectName",
 CellID->14481],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"NFourierTrigSeries", "["}], 
       StyleBox["expr", "TI"], ",", 
       StyleBox["t", "TI"], ",", 
       StyleBox["k", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a numerical approximation to the order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " Fourier trigonometric series expansion of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a periodic function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " with period 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the order ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " Fourier exponential series expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], 
    SubscriptBox[
     StyleBox["c", "TI"], 
     StyleBox["0", "TR"]]}], "+", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["k", "TI"], "=", "1"}], 
     StyleBox["n", "TI"]], 
    RowBox[{
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["kCos", "TI"]], "[", 
     RowBox[{"2", 
      StyleBox["\[Pi]", "TR"], " ", 
      StyleBox["k", "TI"], " ", 
      StyleBox["t", "TI"]}], "]"}]}], "+", 
   RowBox[{
    SubscriptBox[
     StyleBox["d", "TI"], 
     StyleBox["k", "TI"]], " ", 
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     RowBox[{"2", 
      StyleBox["\[Pi]", "TR"], " ", 
      StyleBox["k", "TI"], " ", 
      StyleBox["t", "TI"]}], "]"}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9023],

Cell[TextData[{
 "The coefficient ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  RowBox[{"2", 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Cos",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cos"], "[", 
       RowBox[{"2", 
        StyleBox["\[Pi]", "TR"], " ", 
        StyleBox["k", "TI"], " ", 
        StyleBox["t", "TI"]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["t", "TI"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}]], "InlineFormula"],
 " and the coefficient ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["d", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  RowBox[{"2", 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Sin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sin"], "[", 
       RowBox[{"2", 
        StyleBox["\[Pi]", "TR"], " ", 
        StyleBox["k", "TI"], " ", 
        StyleBox["t", "TI"]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["t", "TI"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1727],

Cell[TextData[{
 "Different choices for the period of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1771],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is assumed to have a period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 ", and the order ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " Fourier exponential series expansion computed by ",
 Cell[BoxData["NFourierTrigSeries"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["0", "TR"]]}], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["k", "TI"], "=", "1"}], 
      StyleBox["n", "TI"]], 
     RowBox[{
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["k", "TI"]], " ", 
      RowBox[{
       ButtonBox["Cos",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cos"], "[", 
       RowBox[{"2", 
        StyleBox["\[Pi]", "TR"], " ", 
        StyleBox["b", "TI"], " ", 
        StyleBox["k", "TI"], " ", 
        StyleBox["t", "TI"]}], "]"}]}]}], "+", 
    RowBox[{
     SubscriptBox[
      StyleBox["d", "TI"], 
      StyleBox["k", "TI"]], " ", 
     RowBox[{
      ButtonBox["Sin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sin"], "[", 
      RowBox[{"2", 
       StyleBox["\[Pi]", "TR"], " ", 
       StyleBox["b", "TI"], " ", 
       StyleBox["k", "TI"], " ", 
       StyleBox["t", "TI"]}], "]"}]}]}], TraditionalForm]], "InlineFormula"],
 ". Here, the coefficient ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["2", "TR"], 
    StyleBox[
     RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
    " ", 
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       RowBox[{
        ButtonBox["Cos",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Cos"], "[", 
        RowBox[{"2", 
         StyleBox["\[Pi]", "TR"], " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["k", "TI"], " ", 
         StyleBox["t", "TI"]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 " and the coefficient ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["d", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["2", "TR"], 
    StyleBox[
     RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
    " ", 
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       RowBox[{
        ButtonBox["Sin",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Sin"], "[", 
        RowBox[{"2", 
         StyleBox["\[Pi]", "TR"], " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["k", "TI"], " ", 
         StyleBox["t", "TI"]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31313],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " in the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " must be numeric."
}], "Notes",
 CellID->10382],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NFourierTrigSeries"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6140]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->22519257],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->149610672],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->472161696],

Cell["Numerical approximation for a trigonometric Fourier series:", \
"ExampleText",
 CellID->560154485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NFourierTrigSeries", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Cos", "[", "t", "]"}], "]"}], ",", "t", ",", " ", "3"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->252796276],

Cell[BoxData[
 RowBox[{"0.8179867036057613`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.028906258012569415`", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}], "-", 
  RowBox[{"0.007656230837595408`", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"4", " ", "\[Pi]", " ", "t"}], "]"}]}], "+", 
  RowBox[{"0.0034293977538986456`", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}]}], "+", 
  RowBox[{"0.`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}], "+", 
  RowBox[{"0.`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"4", " ", "\[Pi]", " ", "t"}], "]"}]}], "+", 
  RowBox[{"0.`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}]}]}]], "Output",
 ImageSize->{418, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->485645104]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->564171855],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[3]=",
 CellID->113023937]
}, Open  ]],

Cell["Compare with a plot of the original periodic function:", "ExampleText",
 CellID->571403394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Cos", "[", 
     RowBox[{"(", 
      RowBox[{"t", "-", 
       RowBox[{"Round", "[", "t", "]"}]}], ")"}], "]"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->672269051],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[4]=",
 CellID->889072770]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24816],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->28488]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NFourierTrigSeries - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 18.9122494}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NFourierTrigSeries[ expr, t, k] gives a numerical approximation to the \
order n Fourier trigonometric series expansion of expr, where expr is a \
periodic function of t with period 1.", "synonyms" -> {}, "title" -> 
    "NFourierTrigSeries", "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/NFourierTrigSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11226, 406, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->22519257]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27817, 769}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 632, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1255, 43, 56, 1, 70, "ObjectName",
 CellID->14481],
Cell[1314, 46, 893, 27, 70, "Usage",
 CellID->15579]
}, Open  ]],
Cell[CellGroupData[{
Cell[2244, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2722, 95, 1136, 42, 70, "Notes",
 CellID->9023],
Cell[3861, 139, 1653, 61, 70, "Notes",
 CellID->1727],
Cell[5517, 202, 327, 11, 70, "Notes",
 CellID->1771],
Cell[5847, 215, 4302, 146, 70, "Notes",
 CellID->31313],
Cell[10152, 363, 419, 16, 70, "Notes",
 CellID->10382],
Cell[10574, 381, 615, 20, 70, "Notes",
 CellID->6140]
}, Closed]],
Cell[CellGroupData[{
Cell[11226, 406, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->22519257],
Cell[CellGroupData[{
Cell[11610, 420, 148, 5, 70, "ExampleSection",
 CellID->149610672],
Cell[11761, 427, 138, 4, 70, "Input",
 CellID->472161696],
Cell[11902, 433, 104, 2, 70, "ExampleText",
 CellID->560154485],
Cell[CellGroupData[{
Cell[12031, 439, 239, 8, 28, "Input",
 CellID->252796276],
Cell[12273, 449, 895, 24, 54, "Output",
 CellID->485645104]
}, Open  ]],
Cell[CellGroupData[{
Cell[13205, 478, 208, 7, 28, "Input",
 CellID->564171855],
Cell[13416, 487, 5913, 101, 168, "Output",
 Evaluatable->False,
 CellID->113023937]
}, Open  ]],
Cell[19344, 591, 97, 1, 70, "ExampleText",
 CellID->571403394],
Cell[CellGroupData[{
Cell[19466, 596, 366, 12, 28, "Input",
 CellID->672269051],
Cell[19835, 610, 6255, 107, 171, "Output",
 Evaluatable->False,
 CellID->889072770]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26151, 724, 314, 9, 70, "TutorialsSection",
 CellID->24816],
Cell[26468, 735, 160, 3, 70, "Tutorials",
 CellID->28488]
}, Open  ]],
Cell[26643, 741, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

