(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14399,        517]
NotebookOptionsPosition[     11219,        412]
NotebookOutlinePosition[     12663,        451]
CellTagsIndexPosition[     12578,        446]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Fourier Series Package" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>",
       
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NInverseDTFourierTransform", "ObjectName",
 CellID->20633],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NInverseDTFourierTransform", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["\[Omega]", "TR"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a numerical approximation to the inverse \
discrete time Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a periodic function of ",
     Cell[BoxData[
      StyleBox["\[Omega]", "TR"]], "InlineFormula"],
     " with period 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3241]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the inverse discrete time Fourier transform \
of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["expr", "TI"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], 
       StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
       StyleBox["n", "TI"], " ", 
       StyleBox["\[Omega]", "TR"]}]]}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["\[Omega]", "TR"], ",", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", 
      FractionBox["1", "2"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5745],

Cell[TextData[{
 "Different choices for the definition of the inverse discrete time Fourier \
transform can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18018],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ",",
 " ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is assumed to have a period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 ", and",
 " the inverse discrete time Fourier transform computed by ",
 Cell[BoxData["NInverseDTFourierTransform"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
     FractionBox[
      RowBox[{"1", "+", 
       StyleBox["a", "TI"]}], "2"]], " ", 
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["n", "TI"], " ", 
         StyleBox["\[Omega]", "TR"]}]]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["\[Omega]", "TR"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31015],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " in the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " must be numeric."
}], "Notes",
 CellID->22974],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NInverseDTFourierTransform"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19252]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->284728838],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->18279122],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->197018035],

Cell["\<\
Numerical value for a sequence with a given discrete time Fourier transform:\
\>", "ExampleText",
 CellID->237639266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NInverseDTFourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Omega]", "^", "2"}]}], "+", "\[Omega]"}], "]"}], ",", " ", 
   "\[Omega]", ",", " ", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610618673],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0015003672975328597`"}], "+", 
  RowBox[{"0.0325186723343171`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->531544098]
}, Open  ]],

Cell["Compare with the answer from symbolic evaluation:", "ExampleText",
 CellID->318142731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NInverseDTFourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Omega]", "^", "2"}]}], "+", "\[Omega]"}], "]"}], ",", " ", 
   "\[Omega]", ",", " ", "4"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4276327],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0015003672975328597`"}], "+", 
  RowBox[{"0.0325186723343171`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->271236606]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseDTFourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"\[Omega]", "^", "2"}]}], "+", "\[Omega]"}], "]"}], ",", " ", 
   "\[Omega]", ",", " ", "n"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->813149268],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "4"]}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", "+", 
        RowBox[{"2", " ", "n", " ", "\[Pi]"}]}], ")"}], "2"]}]], " ", 
   SqrtBox["\[Pi]"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", "n", "]"}], " ", 
      RowBox[{"Erf", "[", 
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]}], "]"}]}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "n", " ", 
      RowBox[{"Erfi", "[", 
       RowBox[{"\[Pi]", " ", 
        RowBox[{"Abs", "[", "n", "]"}]}], "]"}]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   RowBox[{"Abs", "[", "n", "]"}]}]]], "Output",
 ImageSize->{379, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->85368388]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", " ", 
  RowBox[{"{", 
   RowBox[{"n", "\[Rule]", " ", "4."}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->90814158],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0015003672975327854`"}], "+", 
  RowBox[{"0.0325186723343175`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->3863860]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->846],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->8956]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NInverseDTFourierTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 19.3966368}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NInverseDTFourierTransform[expr, \\[Omega], n] gives a numerical \
approximation to the inverse discrete time Fourier transform of expr \
evaluated at the integer n, where expr is a periodic function of \\[Omega] \
with period 1.", "synonyms" -> {}, "title" -> "NInverseDTFourierTransform", 
    "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/NInverseDTFourierTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6838, 241, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->284728838]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12435, 439}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 632, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1255, 43, 64, 1, 70, "ObjectName",
 CellID->20633],
Cell[1322, 46, 939, 28, 70, "Usage",
 CellID->3241]
}, Open  ]],
Cell[CellGroupData[{
Cell[2298, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2776, 96, 830, 28, 70, "Notes",
 CellID->5745],
Cell[3609, 126, 312, 9, 70, "Notes",
 CellID->18018],
Cell[3924, 137, 1828, 59, 70, "Notes",
 CellID->31015],
Cell[5755, 198, 419, 16, 70, "Notes",
 CellID->22974],
Cell[6177, 216, 624, 20, 70, "Notes",
 CellID->19252]
}, Closed]],
Cell[CellGroupData[{
Cell[6838, 241, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->284728838],
Cell[CellGroupData[{
Cell[7223, 255, 147, 5, 70, "ExampleSection",
 CellID->18279122],
Cell[7373, 262, 138, 4, 70, "Input",
 CellID->197018035],
Cell[7514, 268, 127, 3, 70, "ExampleText",
 CellID->237639266],
Cell[CellGroupData[{
Cell[7666, 275, 294, 9, 28, "Input",
 CellID->610618673],
Cell[7963, 286, 273, 8, 36, "Output",
 CellID->531544098]
}, Open  ]],
Cell[8251, 297, 92, 1, 70, "ExampleText",
 CellID->318142731],
Cell[CellGroupData[{
Cell[8368, 302, 292, 9, 70, "Input",
 CellID->4276327],
Cell[8663, 313, 273, 8, 36, "Output",
 CellID->271236606]
}, Open  ]],
Cell[CellGroupData[{
Cell[8973, 326, 293, 9, 70, "Input",
 CellID->813149268],
Cell[9269, 337, 906, 29, 62, "Output",
 CellID->85368388]
}, Open  ]],
Cell[CellGroupData[{
Cell[10212, 371, 156, 5, 70, "Input",
 CellID->90814158],
Cell[10371, 378, 271, 8, 36, "Output",
 CellID->3863860]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10703, 393, 312, 9, 70, "TutorialsSection",
 CellID->846],
Cell[11018, 404, 159, 3, 70, "Tutorials",
 CellID->8956]
}, Open  ]],
Cell[11192, 410, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

