(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7847,        267]
NotebookOptionsPosition[      5941,        209]
NotebookOutlinePosition[      7148,        240]
CellTagsIndexPosition[      7105,        237]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bias" :> 
          Documentation`HelpLookup["paclet:FunctionApproximations/ref/Bias"], 
          "Brake" :> Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/Brake"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Bias\"\>", 
       2->"\<\"Brake\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Derivatives", "ObjectName",
 CellID->18636],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Derivatives"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["MiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]],
       "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["GeneralMiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
      "InlineFormula"],
     " that specifies an expression that evaluates to a list containing the \
function and its first two derivatives."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22355]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"Derivatives", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["GeneralMiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
  "InlineFormula"],
 " computes derivatives using ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24767],

Cell[TextData[{
 "The option ",
 Cell[BoxData["Derivatives"], "InlineFormula"],
 " is useful when ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable to compute derivatives analytically, or when evaluating the \
function and its derivatives is computationally expensive, yet involves a \
significant amount of redundancy."
}], "Notes",
 CellID->23655]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1150],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bias",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/Bias"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Brake",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/Brake"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16941]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15574],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->4031]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Derivatives - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 26.8499526}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "Derivatives is an option to MiniMaxApproximation and \
GeneralMiniMaxApproximation that specifies an expression that evaluates to a \
list containing the function and its first two derivatives.", 
    "synonyms" -> {}, "title" -> "Derivatives", "type" -> "Symbol", "uri" -> 
    "FunctionApproximations/ref/Derivatives"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1363, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1986, 62, 49, 1, 70, "ObjectName",
 CellID->18636],
Cell[2038, 65, 852, 24, 70, "Usage",
 CellID->22355]
}, Open  ]],
Cell[CellGroupData[{
Cell[2927, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3405, 111, 749, 27, 70, "Notes",
 CellID->24767],
Cell[4157, 140, 364, 10, 70, "Notes",
 CellID->23655]
}, Closed]],
Cell[CellGroupData[{
Cell[4558, 155, 310, 9, 70, "SeeAlsoSection",
 CellID->1150],
Cell[4871, 166, 483, 17, 70, "SeeAlso",
 CellID->16941]
}, Open  ]],
Cell[CellGroupData[{
Cell[5391, 188, 314, 9, 70, "TutorialsSection",
 CellID->15574],
Cell[5708, 199, 191, 5, 70, "Tutorials",
 CellID->4031]
}, Open  ]],
Cell[5914, 207, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

