(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11715,        379]
NotebookOptionsPosition[      9512,        313]
NotebookOutlinePosition[     10793,        344]
CellTagsIndexPosition[     10750,        341]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PadeApproximant" :> 
          Documentation`HelpLookup["paclet:ref/PadeApproximant"], 
          "MiniMaxApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/MiniMaxApproximation"], 
          "GeneralMiniMaxApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"], 
          "RationalInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/RationalInterpolation"], 
          "GeneralRationalInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"PadeApproximant\"\>", 
       2->"\<\"MiniMaxApproximation\"\>", 
       3->"\<\"GeneralMiniMaxApproximation\"\>", 
       4->"\<\"RationalInterpolation\"\>", 
       5->"\<\"GeneralRationalInterpolation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/guide/\
FunctionApproximationsPackage"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EconomizedRationalApproximation", "ObjectName",
 CellID->1563],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EconomizedRationalApproximation", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["0", "TR"]], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the economized rational approximation to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " that is good over the interval ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", with numerator order ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and denominator order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21302]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["EconomizedRationalApproximation"], "InlineFormula"],
 " finds the Pad\[EAcute] approximant about the midpoint of the interval ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", and then perturbs the approximant with Chebyshev polynomials to reduce \
the leading coefficient in the error."
}], "Notes",
 CellID->502],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can find the economized rational approximant over the interval ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " only when it can evaluate power series at the midpoint of the interval."
}], "Notes",
 CellID->26928],

Cell[TextData[{
 Cell[BoxData["EconomizedRationalApproximation"], "InlineFormula"],
 " produces a ratio of ordinary polynomial expressions, not a special ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->30721]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2222],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadeApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadeApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MiniMaxApproximation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralMiniMaxApproximation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RationalInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralRationalInterpolation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->244873320]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24898],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->31447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->282745242],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"]], \
"MoreAbout",
 CellID->384204480]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EconomizedRationalApproximation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 27.0218320}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "EconomizedRationalApproximation[expr, {x, {x_0, x_1}, m, n}] gives the \
economized rational approximation to expr that is good over the interval x_0 \
to x_1, with numerator order m and denominator order n.", "synonyms" -> {}, 
    "title" -> "EconomizedRationalApproximation", "type" -> "Symbol", "uri" -> 
    "FunctionApproximations/ref/EconomizedRationalApproximation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2665, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3288, 91, 68, 1, 70, "ObjectName",
 CellID->1563],
Cell[3359, 94, 1421, 45, 70, "Usage",
 CellID->21302]
}, Open  ]],
Cell[CellGroupData[{
Cell[4817, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5295, 161, 511, 15, 70, "Notes",
 CellID->502],
Cell[5809, 178, 447, 15, 70, "Notes",
 CellID->26928],
Cell[6259, 195, 320, 9, 70, "Notes",
 CellID->30721]
}, Closed]],
Cell[CellGroupData[{
Cell[6616, 209, 310, 9, 70, "SeeAlsoSection",
 CellID->2222],
Cell[6929, 220, 1436, 46, 70, "SeeAlso",
 CellID->244873320]
}, Open  ]],
Cell[CellGroupData[{
Cell[8402, 271, 314, 9, 70, "TutorialsSection",
 CellID->24898],
Cell[8719, 282, 192, 5, 70, "Tutorials",
 CellID->31447]
}, Open  ]],
Cell[CellGroupData[{
Cell[8948, 292, 319, 9, 70, "MoreAboutSection",
 CellID->282745242],
Cell[9270, 303, 200, 5, 70, "MoreAbout",
 CellID->384204480]
}, Open  ]],
Cell[9485, 311, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

