(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13938,        434]
NotebookOptionsPosition[     11652,        368]
NotebookOutlinePosition[     13061,        401]
CellTagsIndexPosition[     13018,        398]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PadeApproximant" :> 
          Documentation`HelpLookup["paclet:ref/PadeApproximant"], 
          "GeneralMiniMaxApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"], 
          "EconomizedRationalApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/\
EconomizedRationalApproximation"], "RationalInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/RationalInterpolation"], 
          "GeneralRationalInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"PadeApproximant\"\>", 
       2->"\<\"GeneralMiniMaxApproximation\"\>", 
       3->"\<\"EconomizedRationalApproximation\"\>", 
       4->"\<\"RationalInterpolation\"\>", 
       5->"\<\"GeneralRationalInterpolation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MiniMaxApproximation", "ObjectName",
 CellID->17861],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MiniMaxApproximation", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["0", "TR"]], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]finds the rational polynomial function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with numerator order ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and denominator order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ", that gives a mini-max approximation to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on the interval ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MiniMaxApproximation", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["approx", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["0", "TR"]], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the mini-max approximation to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", starting the iterative algorithm with ",
     Cell[BoxData[
      StyleBox["approx", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14688]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MiniMaxApproximation"], "InlineFormula"],
 " minimizes the maximum value of the relative error between the \
approximation and ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13401],

Cell[TextData[{
 Cell[BoxData["MiniMaxApproximation"], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["abscissa", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["approximation", "TI"], ",", 
      StyleBox["maxerror", "TI"]}], "}"}]}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["abscissa", "TI"]], "InlineFormula"],
 " is a list of the abscissas where the relative error is a local maximum, ",
 Cell[BoxData[
  StyleBox["approximation", "TI"]], "InlineFormula"],
 " is the rational approximant, and ",
 Cell[BoxData[
  StyleBox["maxerror", "TI"]], "InlineFormula"],
 " is the global maximum of the relative error."
}], "Notes",
 CellID->9789],

Cell[TextData[{
 "When an approximation is given as the second argument of ",
 Cell[BoxData["MiniMaxApproximation"], "InlineFormula"],
 ", it must have the same form as the result returned by ",
 Cell[BoxData["MiniMaxApproximation"], "InlineFormula"],
 "."
}], "Notes",
 CellID->15255],

Cell["The following options can be given:", "Notes",
 CellID->16423],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bias",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Bias"], "0", Cell[
    "bias in the automatic choice of interpolation points", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Brake",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Brake"], 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], Cell[
    "braking to apply on iterative algorithm", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Derivatives",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Derivatives"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to use for derivatives", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], "20", Cell[
    "maximum number of iterations to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotFlag",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/PlotFlag"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to plot relative error", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PrintFlag",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/PrintFlag"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to print status information", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "precision to use in internal computations", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->5002]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31426],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadeApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadeApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralMiniMaxApproximation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EconomizedRationalApproximation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/EconomizedRationalApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RationalInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralRationalInterpolation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28617]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10585],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->24182]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MiniMaxApproximation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 34.6470272}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "MiniMaxApproximation[expr, {x, {x_0, x_1}, m, n}] finds the rational \
polynomial function of x, with numerator order m and denominator order n, \
that gives a mini-max approximation to expr on the interval x_0 to x_1. \
MiniMaxApproximation[expr, approx, {x, {x_0, x_1}, m, n}] finds the mini-max \
approximation to expr, starting the iterative algorithm with approx.", 
    "synonyms" -> {}, "title" -> "MiniMaxApproximation", "type" -> "Symbol", 
    "uri" -> "FunctionApproximations/ref/MiniMaxApproximation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2055, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2678, 75, 58, 1, 70, "ObjectName",
 CellID->17861],
Cell[2739, 78, 2398, 75, 70, "Usage",
 CellID->14688]
}, Open  ]],
Cell[CellGroupData[{
Cell[5174, 158, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5652, 175, 255, 8, 70, "Notes",
 CellID->13401],
Cell[5910, 185, 719, 22, 70, "Notes",
 CellID->9789],
Cell[6632, 209, 285, 7, 70, "Notes",
 CellID->15255],
Cell[6920, 218, 68, 1, 70, "Notes",
 CellID->16423],
Cell[6991, 221, 2262, 58, 70, "3ColumnTableMod",
 CellID->5002]
}, Closed]],
Cell[CellGroupData[{
Cell[9290, 284, 311, 9, 70, "SeeAlsoSection",
 CellID->31426],
Cell[9604, 295, 1460, 47, 70, "SeeAlso",
 CellID->28617]
}, Open  ]],
Cell[CellGroupData[{
Cell[11101, 347, 314, 9, 70, "TutorialsSection",
 CellID->10585],
Cell[11418, 358, 192, 5, 70, "Tutorials",
 CellID->24182]
}, Open  ]],
Cell[11625, 366, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

