(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     63301,       2010]
NotebookOptionsPosition[     54393,       1689]
NotebookOutlinePosition[     55966,       1729]
CellTagsIndexPosition[     55880,       1724]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interpolation" :> 
          Documentation`HelpLookup["paclet:ref/Interpolation"], "Integrate" :> 
          Documentation`HelpLookup["paclet:ref/Integrate"], "NIntegrate" :> 
          Documentation`HelpLookup["paclet:ref/NIntegrate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interpolation\"\>", 
       2->"\<\"Integrate\"\>", 3->"\<\"NIntegrate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/guide/\
FunctionApproximationsPackage"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NIntegrateInterpolatingFunction", "ObjectName",
 CellID->15004],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"NIntegrateInterpolatingFunction", "[", 
        RowBox[{
         StyleBox["f", "TI"], ",", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["x", "TI"], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["min", "TI"]], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["max", "TI"]]}], "}"}]}], "]"}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]gives a numerical approximation to an integral with ",
     Cell[BoxData[
      ButtonBox["InterpolatingFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
     " objects in the integrand."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NIntegrateInterpolatingFunction", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a numerical approximation to a multidimensional \
integral."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->8514]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["NIntegrateInterpolatingFunction"], "InlineFormula"],
 " uses the function ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ", but it breaks up the domain of integration into sections, where the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InterpolatingFunction",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/InterpolatingFunction"], " "}]], 
  "InlineFormula"],
 " objects are smooth."
}], "Notes",
 CellID->20799],

Cell[TextData[{
 "If the integrand ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " does not contain any ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects, ",
 Cell[BoxData["NIntegrateInterpolatingFunction"], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23210],

Cell[TextData[{
 "The arguments of the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects may themselves be univariate functions of the integration \
variables."
}], "Notes",
 CellID->25269],

Cell[TextData[{
 "If the integrand ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is simply an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object, it is better to use ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " because this gives a result that is exact for the polynomial approximation \
used in the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 StyleBox[" ", "MR"],
 "object. "
}], "Notes",
 CellID->19552],

Cell[TextData[{
 "Numerically integrating a multidimensional integral using ",
 Cell[BoxData["NIntegrateInterpolatingFunction"], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects containing a large number of nodes may take significantly longer \
than using ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32235],

Cell[TextData[{
 Cell[BoxData["NIntegrateInterpolatingFunction"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->471]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56455067],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->350815872],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->110708887],

Cell[TextData[{
 "A trapezoidal approximation to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->26758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sin", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
    RowBox[{"InterpolationOrder", "->", "1"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7372],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2295]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  RowBox[{"sin", "[", "x", "]"}]], "InlineFormula"],
 " is not smooth, ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " will generate a warning message:"
}], "ExampleText",
 CellID->17906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30014],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate. \\!\\(\\*ButtonBox[\\\
\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"NIntegrate::slwcon\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellID->13452],

Cell[BoxData["0.4593144927390843`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->20284]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData["NIntegrateInterpolatingFunction"], "InlineFormula"],
 " produces a slightly more accurate answer without any error messages:"
}], "ExampleText",
 CellID->29905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrateInterpolatingFunction", "[", 
  RowBox[{
   RowBox[{"sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25812],

Cell[BoxData["0.4593145488579763`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->28021]
}, Open  ]],

Cell[TextData[{
 "In this case the integrand is simply an interpolating function, so you can \
use ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " to check:"
}], "ExampleText",
 CellID->6341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->6575],

Cell[BoxData["0.4593145488579764`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->22290]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6611],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->130410152],

Cell[TextData[{
 Cell[BoxData["NIntegrateInterpolatingFunction"], "InlineFormula"],
 " threads element-wise over the first argument:"
}], "ExampleText",
 CellID->22167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"FunctionInterpolation", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26982],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrateInterpolatingFunction", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      SuperscriptBox["x", "2"], 
      RowBox[{"f", "[", "x", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5`", ",", "0.22324423409969193`"}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28793]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28050],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->37826296],

Cell["Complex-valued interpolation:", "ExampleText",
 CellID->19679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"FunctionInterpolation", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"I", " ", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18268],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31274]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrateInterpolatingFunction", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"f", "[", "x", "]"}], "2"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30884],

Cell[BoxData[
 RowBox[{"0.4546482741360449`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.708072734140496`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32629]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20335],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->195178745],

Cell["Multidimensional integrals:", "ExampleText",
 CellID->12460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"FunctionInterpolation", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24105],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21511]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrateInterpolatingFunction", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24992],

Cell[BoxData["0.23981162941976256`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27824]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27550],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->357881038],

Cell["\<\
The arguments of the interpolating function may themselves be univariate \
functions of the integration variables:\
\>", "ExampleText",
 CellID->7016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sin", "=", 
  RowBox[{"FunctionInterpolation", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8060],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "4"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19801]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrateInterpolatingFunction", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"sin", "[", 
     RowBox[{
      SuperscriptBox["y", "2"], ",", 
      SuperscriptBox["x", "2"]}], "]"}], "2"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->30759],

Cell[BoxData["1.2127784747598778`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29309]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8256],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->490023730],

Cell[TextData[{
 "A trapezoidal approximation to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", 
   RowBox[{"\[Pi]", " ", "x"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Pi]", " ", "x"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
    RowBox[{"InterpolationOrder", "->", "1"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10048],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1807],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->428404448]
}, Open  ]],

Cell[TextData[{
 "Accumulate the sampling points used by ",
 Cell[BoxData["NIntegrateInterpolatingFunction"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8491],

Cell[BoxData[
 RowBox[{
  RowBox[{"samplingPoints", "=", 
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"NIntegrateInterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", ":>", 
        RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}], 
    "\[LeftDoubleBracket]", 
    RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18760],

Cell[TextData[{
 "Plot the sampling points. The function is sampled at the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates in the order of the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->24382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"samplingPoints", ",", 
      RowBox[{"Range", "[", 
       RowBox[{"Length", "[", "samplingPoints", "]"}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "1", ",", ".1"}], "]"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4836],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnE1S2zAUx4W/EpoWCGWGTgs0wxWaA7BqV91lySbDdCYsOu1QDsCOTe/A
MbhGr8BJUn3YjniSHdnWxxNDZjCxJdvvr/f0/JOi5PvydvXj5/L2+mo5+3az
/L26vvoz+/rrhh5KdwghT/Tv7wdC36/pO/73tF7T//J2TrcJLUrZXsrqsKOE
vz2Vy3JRJl6sxpnmTPY2MShjhxJNGa9PvrBttikhJAfWnSg1CnC1T0qNTDmi
XkWtcwaumyo1kgabzSzKDO1wa+sInPlRfzfJA6e9bGZ+ZH7+7NDS6h56C1ND
2/u3ZZd2UC3JwX1t+r3q60X5v+qlsE1PpOOVlbrzqn3Ra0U+OQTXmvL9u7s7
JPsHYD9/tfrVagOr9+j2Xx3r/JxsNpsR/lqtVrAPve4/34dPQ1ieb9o1f3x8
JNWLNq3ikSk4V+9Rd+UHWtt5XI/o0fF4LLb39/elgnfaO2CLca5gl5pMHXBx
cfHw8CAiPMuyUsckGh1J9dQbCzFHR0fAKeNotCjP9l3goGexlkepq5B8pQZe
GqWmXclXavzRs8n7KHTwXp/JvmG9i6Tz+Twqf+xVOkSGptGFt/1ZCx9U9p6f
n4uYOURrr9zOotZ0OmVBkqYkIquz4+PjGjziiGpeizGTyJatzITNdn7W6PLy
EiEztfdNwUq0FC0rdfDA27oWfWHlpX6jSfy8pNfFtlnJsIlmXgheBTc/6TVy
m8t55XqrzgtvUa5SVi2bloSgLL1aPuJVZ+WAUrYLr8czyQj0S1TaxpKSPj7k
uT4XCheLBa1I2fKFaNtnm2dzRb55qDnDkEKOx3VjVG7XV/MHBT4c+uTZaZMM
Gp7/+j3hcPCfAS3Bs5Fw34BZalT8N0AHSv6z8+kBPv6zowsX7/Xo/agIzo5P
QnKaHQVhOMyO7f45y6bdPvnJjt3+eWlYlgnDSRY/Ay9qXqrT41481m9YSUUL
56xkNCJfm40TthBUC2q4Jqgh8w5DVmSEZ6z2ObRyd9MA9UqwrvcJS10t43g4
P9G4dq/Pff3zWfuI3r5Cn+TmW5sfpnOeYb2SnpuVa+5Jbxgh+Sc8N+3sh/Qc
rm70QHoOrfdKeg51BGE6uz04PKn5WQPsl8v8aOLUlYOOROLUIvOVYBB77OhH
gaAoObBsUJRH29NNJInVe8IDOitw5Sz71OSn1e3Tk0e7rdOTnc9osdCU20/U
8VHXcL19ZlvCURlC/3qluGb99Td3rc5RhOW77avTaqHefe2GAptna6o5KGfZ
2BEVhvmuoR0qdMtPrmkwTMsPp8Iwdg+nwoB2D6bCgN8ItkCBfvupfaoL2PpO
qA3H98v5s7iRTYooNcm8pQZeV/rAoYlHV6GGX5xqhrBTgDw2mJlwtPpQdsKh
ojs7BZy9scpSuMf1dpgL0VyNAybzvXrCP7XFFaP26C5C3dYoEGd+1VKhMhfV
T1voX4ECNGjMtmHZSU+BINjWegrE6Qd15V0zE+JUIK+vm0wmLDclSSS2CxKU
CQpGMGK78/qXXMonK+6+akZzONvblNYQW9+JyRDr6MVaiPX0Zqg4NJkxE65M
1ZeV4vBIGzPBli6/OJKJf+JVfTqKhcq7EJVenzpqlkdThOAbbZkx2EtVq1Ib
rDFEqbfZn858p88v8ftTT4b7L1RtE0vC3/0oc29aypIyLtbMu50z32g1YntC
mnPmqFEPBm7pxpdwzRxi32zlyzi1NHFmEqUazmEFCDJaPIrHeg1FsixWRKFA
ZUL2W7Qb2zFmKPHMF2SX53kkLS2spi1Ng53220isjmO0itPqBb8r2fkPxJfy
iQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->501367601]
}, Open  ]],

Cell[TextData[{
 "Accumulate the sampling points used by ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"samplingPoints", "=", 
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", ":>", 
        RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}], 
    "\[LeftDoubleBracket]", 
    RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1725],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Numerical integration converging \
too slowly; suspect one of the following: singularity, value of the \
integration being 0, oscillatory integrand, or insufficient WorkingPrecision. \
If your integrand is oscillatory try using the option Method->Oscillatory in \
NIntegrate.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/NIntegrate/slwcon\\\"]\\)\"\>"}]], "Message",\
 "MSG",
 CellID->5519]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ", the nonsmooth behavior of ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineFormula"],
 " near the points ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   FractionBox[
    StyleBox["n", "TI"], "10"]}]], "InlineFormula"],
 " produces an error message and requires many recursive steps to evaluate \
accurately:"
}], "ExampleText",
 CellID->4809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"samplingPoints", ",", 
      RowBox[{"Range", "[", 
       RowBox[{"Length", "[", "samplingPoints", "]"}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "1", ",", ".1"}], "]"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->16701],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlXduKFEkaTitPdei2z2u3047aiC19oeI2iCAiKuvVgngtgshAz8WyizsP
0OCFV/sMPob7EHuxrzBPUvtHfJl/RP0RUXmozKwetmHKiszIzP/4/YeIrPnr
p98ufvnbp99+/fzpztsvn/5x8evnf975y9+/0KH4WhRFv9N//zqM6Pucvun/
fp/P6V/385w+RzQhVqNYzVRHI/31ln0uxTn8qRk/e65UX0c1zqlDI885PT/6
s/pMzJkoSgV1x86MTNztJ2dG4hxx7+LO+VncN3ZmjAI016MoqUlHv7Tm4sqb
/qdZGrjVimalR6Xn2z1SWj7DT2Fck/b2smwiB5eSVDy3S72Xvp4V/5ZeKmV6
bB0vqfRdV47htbviLv/xHt3R48vLyysy3hbj9I9OtdL7t2/f6PPi4gJey8No
8ofg4zp9/nfBrpSVRRs3b978/v07c0PHf/z48fLlS5tjjbo5NIeDm5ub9Dke
j91oJKTjRCQ9vnPnTnG9PC/9Ji/lz5fIGCCvyMQTxhXz4ftmflRoVFxRxGoz
T6JKbkkJf2aulFLp5VEMmc9LhCkkF5UIYjSV0n3ce7qSyW06sywjXZKCA3oK
60GPc9gCXc+aVzrVEs14Lp+ARPga3CO1bSuKyhhu7qblP7ZnsY3RTSRqJOIZ
U2HtE3Feamkmzsfiemk9qWUdljcAF5SsWT7mnpJGfUWKZ0jKhbSq7DhjSvmE
vk/KQxrRHOdqTVNuz8L3JEkKSoxGbHrNUTlr5JWctBI+zyemjlUoerWcMz7K
YoEd2sfho+oTmtD4N8GMp0+fCitSlMSCMngOj+nxe15ejG4EL3wCvNheYmQv
7GHDnoXvZ2dnoEB4kNGarQlzdOr13bANN7McSUPqWA5RT0O27EIDmHHt2jVh
YQb/JHbxmB4rdSSjrKuzkaV3W+NsAwXyhyPl1twgT57noIWJkmjWxIu7siRJ
gxdhnVgPfdAsYuTLly8ehIrFfSBdHrM+BH4s1eDIsgJb/2wRhT7evHkT0LFf
53RrPuT15E0e28lJHMdgxnB5vcIe2meIKkIjIvDZ+bKI4MpbS2/LxYjnz5/T
vU9OTjy4Bu1vb28HdOTXGT2MD3n90riAnUS8e/dOomRT+Un9VnuwFWsbVA6Z
ZYl+PILkPnz4ENCPX1/0BD7k9aAJj/mL4Xa3FtXL4tioI/8Rcljqs6toAELw
I5BELq+vTUyOEpKG4H4hQjSPKeOalrO6zwlJTFzPJ7ktRNmu6+ft8rn0lP39
/SCvgjdP1G4cJbYEYsPcqRRdZiureKuuClL7YepTVmBJL3LW47FNjc3cyMeL
JxI3jiUSxdmcZb9CV0SHXHca8Tgu5yI1fbfvTp+QKSypZ5lWjadulsWeRQFV
U7oXYvf8/NzLrkCPn7gyZAm4juTiK323wZE+Hz58SE4oc2qhlYXnbwwhQ4np
Nyr5JbD28stfFAfKFKLdvb29Bw8esAiAdq66xMFM0GXlvEeCOvnYsDaF0n3o
MBtEvsQmmYItFiEBysO8YuEviuNYeKGMtv5MFjJE3cAUyFuHFSv0r1TgRYNt
L6BwWuPGBqkJaQFda0JnASk0cevWLRKFwd2mXW59dGe5xoRiSe6Hh4eQ3Z9c
x/fCCickLupLHXQtPX2/5O3bt/A8ojCvuKLB+kBq11OKJc3NkeveXszglMEN
AHAyrsg7lwdyVvgDNCDyjuT4+Bgzzs7OpEQaSGhTVJw2eixUv1Va6Ybvr1+/
bmxsHB0dUTQD3yZQgG+M8adxKXNzD+AXCaa4dz38applaI9OTce9Xteo6Vjn
W1MX1zF89uzZ7u6utpUMjQs7tqrj7XBHUqF7H7nNq8yDMdZa6RkxeFyEa63t
aZZlroQODg6m0+nnz5/rS4F7MQvYoThXSzhRKjK+YqVjZ2eHJSMsNuMxB4Ou
bYTHMJNoRE+KYjxLnZK53ioICinY6ZvCKm2BUxqT3woTZSypyoA29TicQUmq
e1xXzmyuIdRYyTQTmRVxqzmPUTmpS2WfRsv+UPRlQtlKKL8MRuMBZSJrvhxy
YRebo+esbXtrSeXhFkjogh/zNRyeQ2lJKIW0wzPKoaquWTv5JEXsKXdaqH/l
SmGteLes4vDWQ6HSg/1ln27EHhdKYEKZpMayhPVAd+9HfkWRGtmf9vplFHn2
orWS75KMxlsPhcoSRvOU/ubl32W5WtcyMvbjvdCikVT3spVjff00VJmQ6Ck1
QSxkWSB9FWsyRkb+GIpDfXq23HNZR3JqWMsaY1Q5at1WZgAaUU3Wz0hvIqwe
bxtbiiKkE2605drk0l2ZXp+UGvuukQbX8NKz2IggvwlXD3Z+jDDtqR667siE
sM72xHl/WKdqp9Fo5FqPp3YiE7TXOyBULe1NzrfmGt/mi1Xh3bt3Ee2Hkl5c
iCgykbZtxNUV7IYo4d16qqibSmtTVZUtTcaolHEckir2+tnRsx+ZtO6GF0WK
rpdycGNXTb7KwVs5m6yFl9ZCeYk3oV3I/ZrGwI5lYldMybJqBZzT9Bs3btA8
XvIKZQzeHJWzOUZ02SHO/aVBLOZ22CNb1T6P3F1XS77MnbyTMzAlUs3nfs1F
JG95IHvX7SXFnYBVJZRwdyAYyUw/AbtF+Q4kGvJRzDqsuUjkTfvtZnTVnuMB
rSchd4JsakUtYL6peTRSb5EhhNY7hO0pnK7KiQbkfpPxJBSQ6IviHx0+zv7Q
6uNIZaxdopZ3V+XaefeumBS7Iji+5qx3cgAy70CEmgmLkP4lJVTVjVyjBKbs
ppza27m8ToUyXilhyLB1zNJbqJjwCWSkFLGQXDtk3BEWtSpCescLXUeOlYYn
Vq+3wp6hB+L6k1mNa4eAmMXZD5425qeLsNVLl3dhvYYy/tlshnoH+5qDdXOk
12Rr7MJbxjnWdqttzKy8cN+9ME+Zx3RdRWhqN93NEaJ6ma8cCWbEB1uUa2x6
57NAItgqr9I43aC+dwh0k1nnpSWQMI1Gpd2hrmAkI5fbXDN3Nkr64oTXch3u
sRqHPsPu7q7Al246U03HqBs4LkTOexE1YoOKkv3sE+yEuwn3gqKy6ETvx2hS
pQV2DKA4540BBwcHaZqqDsaQ/KKqa4OAdmcLFofS03hcWnpgYEfCgBmM6X6Q
I6FLeP/+/YLztCHe6fcrZsBy9PFYoe/fv0ejz/cOV7cVnD9XNTlAXnpUnueE
7fQJspriXT95J2RssAHWd35+vpQ7g+6Znk9MFTnjmjtYC1wZTNCWlTN20x+s
TtXd0sq0tYzZnwg2tra24jh+8eLFZfN+eY/8ZUTjZKKQD2SSiU2iobrWYg1p
vlrn1f9M4q8IRLAy0kBxvuk70fZefh/Gtqv5hl9H0+MxGSaQndwOqgewV+3Y
1YiT2zvpcE7JZSywt51EtL/hxWIjlD5lYe3ar5oPvDWYEMLldh0QR+sVqzql
BJquDXL+4rzZ3d7DIRkgnnI4eBukoU5V2VX1ykwTiTRe1wrjPE00K6pN1xF0
dpFDKgSz5GUUBCL94h/OXV2JpEQ1uTIiAyWz0ZRu0GovgfM+ajvOu40W/E4s
5SDKXrUnk1ri4vyq72HCqkxe2tTfuon52usm6H4z1l+/ft30qFbdHQI+TQeo
ifd0yOOS9407qenTjx8/knHMZjMkSV5v6IYf/14V0zPoeqcrPAEYpVAQnoD+
1dzjCc3WsnRcSO31ajpX6Mh4hwKxrjuZ2i7GjOtIckiBaM5142+IeqZO0xlQ
yvlAsYuhF86Uxra3t9X9a72n2pK3YmkwKvNnigQFcvT9bhc6TsZG7I6TtLIG
+8szXv8gWyA1jbCdxc5bB+EsjJlz9xdNWmFKxnGXF3hWjWq1OEsYK8lYpiKu
Nu8bmZ0JBgOH7mJruSXIFmAzeekNjfhCzSl/9cVk5crH1tLDnhReUOLkwcEB
FzMVvS+cpey24IFXAO34pdbXSVgEJQRY6+nSv3r1qsDLengIXSFfZy9VfKBB
SoJZNXfS44THZAYy1je18wacZdydgq55ZwRFzI7krvP8hLdj7e/vpy3sux5P
8FDem9nBL4GgSlGVj6V/Ky/qRzftEJejJIFKVTag+OJufuHhTeNCnx1XsQMy
3tnZwRQn6kNDFG2KS2Qc746rNj3+WUndgv0QNwvUSzQglOJFhzXvWizGnG2S
YMuVoFrdoJTjGgHa5dr2RMEKLKtSX60+cFU3Qvb8YGWEmAGqB+RKZVpEWL1V
Be7QFaJIBR9VuNwhHyrm8eJJUyuHPk3nRvGxei9t1X3foGBxDayV/2b2KjTx
d3p62pK7Ad4J2BBcp2Xut6CrhhJQUZyEgFyxHea15b1OJx08Gy0h36W/IpZ2
lhUGPWTd+ib9kHI0jNKl3eRZyz0n8IZQ1F8PHFS9fv2a2Nzb21uZS0hO7lMw
Uahel61ELOaoA85Fh65mrG7Hv4nCXCVCBDU1Xr4P2/S9WNmn48wy8LRuuKXo
XDaXPH6yYleuACB05UzF2HXvijsfh4eHhHG3b99egY+FX5406wK8FkPPKNcO
++5Utcz9C5hSoleawL5vUgXKwsF7N/VkDyzDji6DPaYnhxry5OSEhD+dTrvq
bPTCRyai7dASt/c6KduV63hNNILoEop5g3Bi3n9AqjFv3F9PHj16RCgHH1gL
D06vsViw8P5qUZf7FO/du1dYQTd8YC+W4ibz2EM3lCPDNlhQne/WiRASB2XF
slonBbHA0FwnS68X1+CBJPEnT560W1Oq8xyZ60npgJZlv/XeDX62klFKMmJb
Ud1wKSfMMrkVPKKpjvvhAB3ox48fK2zQ7yR5qbfeOZErTWvsjC78KnIVssKm
8BvcbSNKl7QDG/FXp0MGBAnvOhiGdkjRVGl1pAhEBZKQf9ToWbTMPZfSLLvm
lEq3lKRdD5oV92F6t9zRt3hpKk3Qz+uRpJLh6GdbiHTvjiC/FfXWquPV6Da3
44LymYKRuIYdXw3KlQUmJbWJ6vyUVlSzC9dhT7kLXsroR9bI+fliJnV1uot9
8J9WoGH//WPRXyNF1MGjVrpeyNVUHVHPx/rYUyw7bvJtiao1jXZ1DfIfqkMo
06vJew92zT26IgjJXwvpmvd2+UUfnJfoGcXY9j8Et6Ki9ayXrI7MQFL2rtPT
077fvwVOLc9E1xMh61Eu89HwSseSDlkym81wEyrIhn7j2fQ1wra8mKkr/chd
HkP3sXlfAEeben0NcIZcIWRvg+QrMf9gU80upKYytfuYZGuD094umxW/3ERp
yrq9twHdsfl/7A3tm1ezdvh/p9rXrfi3Phtd+x+ELEPs\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->193242657]
}, Open  ]],

Cell["\<\
Increasing the order of the interpolation will produce a smoother function:\
\>", "ExampleText",
 CellID->8324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Pi]", " ", "x"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
    RowBox[{"InterpolationOrder", "->", "3"}]}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->25807],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->12725]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->22301],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->309161991]
}, Open  ]],

Cell[TextData[{
 "With a smoother function, fewer function evaluations are needed by ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3969],

Cell[BoxData[
 RowBox[{
  RowBox[{"samplingPoints", "=", 
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", ":>", 
        RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}], 
    "\[LeftDoubleBracket]", 
    RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}], ";"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->12488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"samplingPoints", ",", 
      RowBox[{"Range", "[", 
       RowBox[{"Length", "[", "samplingPoints", "]"}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "1", ",", ".1"}], "]"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->21164],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->96381060]
}, Open  ]],

Cell[TextData[{
 "If the interpolation is smooth enough, ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " will require fewer function evaluations than ",
 Cell[BoxData["NIntegrateInterpolatingFunction"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Pi]", " ", "x"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
    RowBox[{"InterpolationOrder", "->", "5"}]}], "]"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->7534],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->27770]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"samplingPoints", "=", 
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"EvaluationMonitor", ":>", 
        RowBox[{"Sow", "[", "x", "]"}]}]}], "]"}], "]"}], 
    "\[LeftDoubleBracket]", 
    RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}], ";"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->2851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"samplingPoints", ",", 
      RowBox[{"Range", "[", 
       RowBox[{"Length", "[", "samplingPoints", "]"}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "1", ",", ".1"}], "]"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->13997],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0], PointBox[{0.496021340023711, 22.}], 
   PointBox[{0.996021340023711, 23.}], PointBox[{0.476544961484666, 21.}], 
   PointBox[{0.938541681642712, 25.}], PointBox[{0.976544961484666, 24.}], 
   PointBox[{0.319907603290446, 18.}], PointBox[{0.25, 17.}], 
   PointBox[{0.438541681642712, 20.}], PointBox[{0.384617327526421, 19.}], 
   PointBox[{0.561458318357288, 31.}], PointBox[{0.615382672473579, 30.}], 
   PointBox[{0.503978659976289, 33.}], PointBox[{0.523455038515334, 32.}], 
   PointBox[{0.819907603290446, 27.}], PointBox[{0.884617327526421, 26.}], 
   PointBox[{0.680092396709554, 29.}], PointBox[{0.75, 28.}], 
   PointBox[{0.5, 6.}], PointBox[{0.360184793419108, 5.}], 
   PointBox[{0.769234655052842, 8.}], PointBox[{0.639815206580892, 7.}], 
   PointBox[{0.0469100770306681, 2.}], PointBox[{0.00795731995257876, 1.}], 
   PointBox[{0.230765344947159, 4.}], PointBox[{0.122916636714575, 3.}], 
   PointBox[{0.0614583183572877, 14.}], PointBox[{0.023455038515334, 13.}], 
   PointBox[{0.180092396709554, 16.}], PointBox[{0.115382672473579, 15.}], 
   PointBox[{0.953089922969332, 10.}], PointBox[{0.877083363285425, 9.}], 
   PointBox[{0.00397865997628938, 12.}], PointBox[{0.992042680047421, 11.}]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  GridLines->{{0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.}, None},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->23724]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29511],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->303231627],

Cell[TextData[{
 "Multidimensional interpolating functions with a large number of nodes may \
take much longer to integrate using ",
 Cell[BoxData["NIntegrateInterpolatingFunction"], "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20067],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"N", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", 
           RowBox[{"Sin", "[", 
            RowBox[{"x", " ", "y"}], "]"}]}], "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "\[Pi]", ",", 
          FractionBox["\[Pi]", "100"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "0", ",", "\[Pi]", ",", 
          FractionBox["\[Pi]", "100"]}], "}"}]}], "]"}], ",", "1"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30265],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ", only one integral is evaluated, but the nonsmooth behavior generates many \
recursive steps:"
}], "ExampleText",
 CellID->20840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3379],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.782`", " ", "Second"}], ",", "4.550523909121721`"}], 
  "}"}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24955]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData["NIntegrateInterpolatingFunction"], "InlineFormula"],
 ", the integral is broken up into ",
 Cell[BoxData[
  SuperscriptBox["10", "4"]], "InlineFormula"],
 " integrals over a smaller domain, where the integrand is smooth:"
}], "ExampleText",
 CellID->16028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrateInterpolatingFunction", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], "2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1661],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8.859000000000002`", " ", "Second"}], ",", "4.550523869160729`"}],
   "}"}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2432]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26395],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27151]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16344],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->11830]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->105018408],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"]], \
"MoreAbout",
 CellID->45937234]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NIntegrateInterpolatingFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 34.9439098}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "NIntegrateInterpolatingFunction[f, {x, x_min, x_max}]] gives a numerical \
approximation to an integral with InterpolatingFunction objects in the \
integrand. NIntegrateInterpolatingFunction[f, {x, x_min, x_max}, {y, y_min, \
y_max}, ...] gives a numerical approximation to a multidimensional integral.",
     "synonyms" -> {}, "title" -> "NIntegrateInterpolatingFunction", "type" -> 
    "Symbol", "uri" -> 
    "FunctionApproximations/ref/NIntegrateInterpolatingFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8156, 265, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->56455067]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55738, 1717}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2081, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2704, 78, 69, 1, 70, "ObjectName",
 CellID->15004],
Cell[2776, 81, 1852, 56, 70, "Usage",
 CellID->8514]
}, Open  ]],
Cell[CellGroupData[{
Cell[4665, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5143, 159, 535, 16, 70, "Notes",
 CellID->20799],
Cell[5681, 177, 545, 18, 70, "Notes",
 CellID->23210],
Cell[6229, 197, 306, 9, 70, "Notes",
 CellID->25269],
Cell[6538, 208, 732, 23, 70, "Notes",
 CellID->19552],
Cell[7273, 233, 567, 16, 70, "Notes",
 CellID->32235],
Cell[7843, 251, 276, 9, 70, "Notes",
 CellID->471]
}, Closed]],
Cell[CellGroupData[{
Cell[8156, 265, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->56455067],
Cell[CellGroupData[{
Cell[8540, 279, 148, 5, 70, "ExampleSection",
 CellID->350815872],
Cell[8691, 286, 147, 4, 70, "Input",
 CellID->110708887],
Cell[8841, 292, 186, 7, 70, "ExampleText",
 CellID->26758],
Cell[CellGroupData[{
Cell[9052, 303, 423, 13, 28, "Input",
 CellID->7372],
Cell[9478, 318, 355, 13, 36, "Output",
 CellID->2295]
}, Open  ]],
Cell[9848, 334, 310, 11, 70, "ExampleText",
 CellID->17906],
Cell[CellGroupData[{
Cell[10183, 349, 215, 7, 70, "Input",
 CellID->30014],
Cell[10401, 358, 559, 10, 70, "Message",
 CellID->13452],
Cell[10963, 370, 172, 5, 36, "Output",
 CellID->20284]
}, Open  ]],
Cell[11150, 378, 202, 5, 70, "ExampleText",
 CellID->29905],
Cell[CellGroupData[{
Cell[11377, 387, 236, 7, 70, "Input",
 CellID->25812],
Cell[11616, 396, 172, 5, 36, "Output",
 CellID->28021]
}, Open  ]],
Cell[11803, 404, 270, 9, 70, "ExampleText",
 CellID->6341],
Cell[CellGroupData[{
Cell[12098, 417, 213, 7, 70, "Input",
 CellID->6575],
Cell[12314, 426, 172, 5, 36, "Output",
 CellID->22290]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12535, 437, 215, 7, 70, "ExampleSection",
 CellID->6611],
Cell[12753, 446, 147, 4, 70, "Input",
 CellID->130410152],
Cell[12903, 452, 168, 4, 70, "ExampleText",
 CellID->22167],
Cell[CellGroupData[{
Cell[13096, 460, 253, 8, 70, "Input",
 CellID->26982],
Cell[13352, 470, 355, 13, 36, "Output",
 CellID->5783]
}, Open  ]],
Cell[CellGroupData[{
Cell[13744, 488, 335, 11, 70, "Input",
 CellID->23387],
Cell[14082, 501, 222, 7, 36, "Output",
 CellID->28793]
}, Open  ]],
Cell[14319, 511, 121, 3, 70, "ExampleDelimiter",
 CellID->28050],
Cell[14443, 516, 146, 4, 70, "Input",
 CellID->37826296],
Cell[14592, 522, 68, 1, 70, "ExampleText",
 CellID->19679],
Cell[CellGroupData[{
Cell[14685, 527, 279, 9, 70, "Input",
 CellID->18268],
Cell[14967, 538, 356, 13, 36, "Output",
 CellID->31274]
}, Open  ]],
Cell[CellGroupData[{
Cell[15360, 556, 260, 8, 70, "Input",
 CellID->30884],
Cell[15623, 566, 268, 7, 36, "Output",
 CellID->32629]
}, Open  ]],
Cell[15906, 576, 121, 3, 70, "ExampleDelimiter",
 CellID->20335],
Cell[16030, 581, 147, 4, 70, "Input",
 CellID->195178745],
Cell[16180, 587, 66, 1, 70, "ExampleText",
 CellID->12460],
Cell[CellGroupData[{
Cell[16271, 592, 350, 11, 70, "Input",
 CellID->24105],
Cell[16624, 605, 435, 16, 36, "Output",
 CellID->21511]
}, Open  ]],
Cell[CellGroupData[{
Cell[17096, 626, 328, 10, 70, "Input",
 CellID->24992],
Cell[17427, 638, 173, 5, 36, "Output",
 CellID->27824]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17649, 649, 239, 7, 70, "ExampleSection",
 CellID->27550],
Cell[17891, 658, 147, 4, 70, "Input",
 CellID->357881038],
Cell[18041, 664, 160, 4, 70, "ExampleText",
 CellID->7016],
Cell[CellGroupData[{
Cell[18226, 672, 351, 11, 70, "Input",
 CellID->8060],
Cell[18580, 685, 435, 16, 36, "Output",
 CellID->19801]
}, Open  ]],
Cell[CellGroupData[{
Cell[19052, 706, 413, 13, 70, "Input",
 CellID->30759],
Cell[19468, 721, 172, 5, 36, "Output",
 CellID->29309]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19689, 732, 232, 7, 70, "ExampleSection",
 CellID->8256],
Cell[19924, 741, 147, 4, 70, "Input",
 CellID->490023730],
Cell[20074, 747, 259, 10, 70, "ExampleText",
 CellID->19140],
Cell[CellGroupData[{
Cell[20358, 761, 456, 14, 70, "Input",
 CellID->10048],
Cell[20817, 777, 356, 13, 36, "Output",
 CellID->31655]
}, Open  ]],
Cell[CellGroupData[{
Cell[21210, 795, 206, 7, 70, "Input",
 CellID->1807],
Cell[21419, 804, 2482, 45, 70, "Output",
 Evaluatable->False,
 CellID->428404448]
}, Open  ]],
Cell[23916, 852, 166, 5, 70, "ExampleText",
 CellID->8491],
Cell[24085, 859, 529, 15, 70, "Input",
 CellID->18760],
Cell[24617, 876, 281, 9, 70, "ExampleText",
 CellID->24382],
Cell[CellGroupData[{
Cell[24923, 889, 484, 16, 70, "Input",
 CellID->4836],
Cell[25410, 907, 2047, 38, 70, "Output",
 Evaluatable->False,
 CellID->501367601]
}, Open  ]],
Cell[27472, 948, 222, 8, 70, "ExampleText",
 CellID->30270],
Cell[CellGroupData[{
Cell[27719, 960, 507, 15, 70, "Input",
 CellID->1725],
Cell[28229, 977, 625, 11, 70, "Message",
 CellID->5519]
}, Open  ]],
Cell[28869, 991, 518, 18, 70, "ExampleText",
 CellID->4809],
Cell[CellGroupData[{
Cell[29412, 1013, 485, 16, 70, "Input",
 CellID->16701],
Cell[29900, 1031, 5564, 95, 70, "Output",
 Evaluatable->False,
 CellID->193242657]
}, Open  ]],
Cell[35479, 1129, 121, 3, 70, "ExampleText",
 CellID->8324],
Cell[CellGroupData[{
Cell[35625, 1136, 456, 14, 70, "Input",
 CellID->25807],
Cell[36084, 1152, 356, 13, 36, "Output",
 CellID->12725]
}, Open  ]],
Cell[CellGroupData[{
Cell[36477, 1170, 207, 7, 70, "Input",
 CellID->22301],
Cell[36687, 1179, 2937, 52, 70, "Output",
 Evaluatable->False,
 CellID->309161991]
}, Open  ]],
Cell[39639, 1234, 249, 8, 70, "ExampleText",
 CellID->3969],
Cell[39891, 1244, 509, 15, 70, "Input",
 CellID->12488],
Cell[CellGroupData[{
Cell[40425, 1263, 486, 16, 70, "Input",
 CellID->21164],
Cell[40914, 1281, 3913, 68, 70, "Output",
 Evaluatable->False,
 CellID->96381060]
}, Open  ]],
Cell[44842, 1352, 341, 10, 70, "ExampleText",
 CellID->24124],
Cell[CellGroupData[{
Cell[45208, 1366, 456, 14, 70, "Input",
 CellID->7534],
Cell[45667, 1382, 357, 13, 36, "Output",
 CellID->27770]
}, Open  ]],
Cell[46039, 1398, 508, 15, 70, "Input",
 CellID->2851],
Cell[CellGroupData[{
Cell[46572, 1417, 486, 16, 70, "Input",
 CellID->13997],
Cell[47061, 1435, 1632, 30, 164, "Output",
 CellID->23724]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48742, 1471, 226, 7, 70, "ExampleSection",
 CellID->29511],
Cell[48971, 1480, 147, 4, 70, "Input",
 CellID->303231627],
Cell[49121, 1486, 380, 11, 70, "ExampleText",
 CellID->20067],
Cell[49504, 1499, 701, 21, 70, "Input",
 CellID->30265],
Cell[50208, 1522, 281, 9, 70, "ExampleText",
 CellID->20840],
Cell[CellGroupData[{
Cell[50514, 1535, 381, 13, 70, "Input",
 CellID->3379],
Cell[50898, 1550, 254, 9, 36, "Output",
 CellID->24955]
}, Open  ]],
Cell[51167, 1562, 298, 8, 70, "ExampleText",
 CellID->16028],
Cell[CellGroupData[{
Cell[51490, 1574, 402, 13, 70, "Input",
 CellID->1661],
Cell[51895, 1589, 265, 9, 36, "Output",
 CellID->2432]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52221, 1605, 311, 9, 70, "SeeAlsoSection",
 CellID->26395],
Cell[52535, 1616, 712, 26, 70, "SeeAlso",
 CellID->27151]
}, Open  ]],
Cell[CellGroupData[{
Cell[53284, 1647, 314, 9, 70, "TutorialsSection",
 CellID->16344],
Cell[53601, 1658, 192, 5, 70, "Tutorials",
 CellID->11830]
}, Open  ]],
Cell[CellGroupData[{
Cell[53830, 1668, 319, 9, 70, "MoreAboutSection",
 CellID->105018408],
Cell[54152, 1679, 199, 5, 70, "MoreAbout",
 CellID->45937234]
}, Open  ]],
Cell[54366, 1687, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

