(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8993,        304]
NotebookOptionsPosition[      7069,        245]
NotebookOutlinePosition[      8240,        275]
CellTagsIndexPosition[      8197,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrderStarInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarInterpolation"], 
          "OrderStarLegend" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarLegend"], 
          "OrderStarZeros" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarZeros"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OrderStarInterpolation\"\>", 
       2->"\<\"OrderStarLegend\"\>", 
       3->"\<\"OrderStarZeros\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OrderStarPoles", "ObjectName",
 CellID->8885],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["OrderStarPoles"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["OrderStarPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
      "InlineFormula"],
     " that specifies whether poles of an approximant and the function to be \
approximated should be displayed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30301]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A valid setting is a list of two elements. Each element may be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " or a list of points. The default setting is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], ",", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9847],

Cell["\<\
The first element specifies whether poles of the approximant are displayed. \
The second element specifies whether poles of the function to be approximated \
are displayed.\
\>", "Notes",
 CellID->32606],

Cell[TextData[{
 "With a setting of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OrderStarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
  "InlineFormula"],
 " will use ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " to find poles. In some cases, ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " will be unable to find all of the poles. By giving a list of points \
instead of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", these points in addition to the poles found by ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " will be displayed."
}], "Notes",
 CellID->3187]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19351],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarZeros",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarZeros"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19140]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14535],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->10309]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OrderStarPoles - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 36.1158148}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "OrderStarPoles is an option to OrderStarPlot that specifies whether \
poles of an approximant and the function to be approximated should be \
displayed. ", "synonyms" -> {}, "title" -> "OrderStarPoles", "type" -> 
    "Symbol", "uri" -> "FunctionApproximations/ref/OrderStarPoles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1639, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2262, 68, 51, 1, 70, "ObjectName",
 CellID->8885],
Cell[2316, 71, 611, 17, 70, "Usage",
 CellID->30301]
}, Open  ]],
Cell[CellGroupData[{
Cell[2964, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3442, 110, 640, 23, 70, "Notes",
 CellID->9847],
Cell[4085, 135, 213, 5, 70, "Notes",
 CellID->32606],
Cell[4301, 142, 1010, 35, 70, "Notes",
 CellID->3187]
}, Closed]],
Cell[CellGroupData[{
Cell[5348, 182, 311, 9, 70, "SeeAlsoSection",
 CellID->19351],
Cell[5662, 193, 819, 26, 70, "SeeAlso",
 CellID->19140]
}, Open  ]],
Cell[CellGroupData[{
Cell[6518, 224, 314, 9, 70, "TutorialsSection",
 CellID->14535],
Cell[6835, 235, 192, 5, 70, "Tutorials",
 CellID->10309]
}, Open  ]],
Cell[7042, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

