(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7902,        270]
NotebookOptionsPosition[      5955,        210]
NotebookOutlinePosition[      7150,        241]
CellTagsIndexPosition[      7107,        238]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotFlag" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/PlotFlag"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PlotFlag\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrintFlag", "ObjectName",
 CellID->4414],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PrintFlag"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["MiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]],
       "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["GeneralMiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
      "InlineFormula"],
     " that specifies whether data from the successive iterates in the \
approximation algorithm are to be shown."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9314]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". The default setting is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25824],

Cell[TextData[{
 "The ",
 Cell[BoxData["PrintFlag"], "InlineFormula"],
 " option is useful when trying to determine what went wrong when the \
algorithm used by ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GeneralMiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
  "InlineFormula"],
 " fails."
}], "Notes",
 CellID->29334],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"PrintFlag", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", two types of lists are printed. The first type consists of a list of the \
changes in the locations of the extrema. The second type consists of a list \
of a pair of numbers indicating the location of the extrema and the value of \
the relative error at that extrema."
}], "Notes",
 CellID->25874]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7487],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["PlotFlag",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/PlotFlag"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->28297]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24372],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->20159]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrintFlag - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 42.8659876}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "PrintFlag is an option to MiniMaxApproximation and \
GeneralMiniMaxApproximation that specifies whether data from the successive \
iterates in the approximation algorithm are to be shown.", "synonyms" -> {}, 
    "title" -> "PrintFlag", "type" -> "Symbol", "uri" -> 
    "FunctionApproximations/ref/PrintFlag"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1256, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1879, 60, 46, 1, 70, "ObjectName",
 CellID->4414],
Cell[1928, 63, 845, 24, 70, "Usage",
 CellID->9314]
}, Open  ]],
Cell[CellGroupData[{
Cell[2810, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3288, 109, 450, 18, 70, "Notes",
 CellID->25824],
Cell[3741, 129, 569, 19, 70, "Notes",
 CellID->29334],
Cell[4313, 150, 485, 12, 70, "Notes",
 CellID->25874]
}, Closed]],
Cell[CellGroupData[{
Cell[4835, 167, 310, 9, 70, "SeeAlsoSection",
 CellID->7487],
Cell[5148, 178, 219, 6, 70, "SeeAlso",
 CellID->28297]
}, Open  ]],
Cell[CellGroupData[{
Cell[5404, 189, 314, 9, 70, "TutorialsSection",
 CellID->24372],
Cell[5721, 200, 192, 5, 70, "Tutorials",
 CellID->20159]
}, Open  ]],
Cell[5928, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

