(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12684,        400]
NotebookOptionsPosition[     10366,        333]
NotebookOutlinePosition[     11806,        367]
CellTagsIndexPosition[     11763,        364]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PadeApproximant" :> 
          Documentation`HelpLookup["paclet:ref/PadeApproximant"], 
          "GeneralRationalInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"], 
          "EconomizedRationalApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/\
EconomizedRationalApproximation"], "MiniMaxApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/MiniMaxApproximation"], 
          "GeneralMiniMaxApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]}, \
#, 2]& , Evaluator -> Automatic], {1->"\<\"PadeApproximant\"\>", 
       2->"\<\"GeneralRationalInterpolation\"\>", 
       3->"\<\"EconomizedRationalApproximation\"\>", 
       4->"\<\"MiniMaxApproximation\"\>", 
       5->"\<\"GeneralMiniMaxApproximation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/guide/\
FunctionApproximationsPackage"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RationalInterpolation", "ObjectName",
 CellID->30833],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RationalInterpolation", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           RowBox[{
            StyleBox["n", "TI"], "+", 
            StyleBox["m", "TI"], "+", "1"}]]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the rational interpolant to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with numerator order ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and denominator order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     " are the abscissas of the interpolation points."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RationalInterpolation", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["0", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the rational interpolant with the interpolation \
points chosen automatically on the interval ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19711]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->25760],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "precision to use in internal computations", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bias",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Bias"], "0", Cell[
    "bias in the automatic choice of interpolation points", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->18896]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13694],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadeApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadeApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralRationalInterpolation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EconomizedRationalApproximation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/EconomizedRationalApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MiniMaxApproximation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralMiniMaxApproximation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->190100664]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4667],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->7285]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->75905168],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"]], \
"MoreAbout",
 CellID->50390482]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RationalInterpolation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 43.0222416}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "RationalInterpolation[expr, {x, m, n}, {x_1, x_2, ..., x n + m + 1}] \
gives the rational interpolant to expr with numerator order m and denominator \
order n, where x_1, x_2, ... are the abscissas of the interpolation points. \
RationalInterpolation[expr, {x, m, n}, {x, x_0, x_1}] gives the rational \
interpolant with the interpolation points chosen automatically on the \
interval x_0 to x_1.", "synonyms" -> {}, "title" -> "RationalInterpolation", 
    "type" -> "Symbol", "uri" -> 
    "FunctionApproximations/ref/RationalInterpolation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2686, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3309, 91, 59, 1, 70, "ObjectName",
 CellID->30833],
Cell[3371, 94, 2644, 84, 70, "Usage",
 CellID->19711]
}, Open  ]],
Cell[CellGroupData[{
Cell[6052, 183, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6530, 200, 68, 1, 70, "Notes",
 CellID->25760],
Cell[6601, 203, 809, 20, 70, "3ColumnTableMod",
 CellID->18896]
}, Closed]],
Cell[CellGroupData[{
Cell[7447, 228, 311, 9, 70, "SeeAlsoSection",
 CellID->13694],
Cell[7761, 239, 1462, 47, 70, "SeeAlso",
 CellID->190100664]
}, Open  ]],
Cell[CellGroupData[{
Cell[9260, 291, 313, 9, 70, "TutorialsSection",
 CellID->4667],
Cell[9576, 302, 191, 5, 70, "Tutorials",
 CellID->7285]
}, Open  ]],
Cell[CellGroupData[{
Cell[9804, 312, 318, 9, 70, "MoreAboutSection",
 CellID->75905168],
Cell[10125, 323, 199, 5, 70, "MoreAbout",
 CellID->50390482]
}, Open  ]],
Cell[10339, 331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

