(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   5350368,      90972]
NotebookOptionsPosition[   5330001,      90255]
NotebookOutlinePosition[   5331749,      90297]
CellTagsIndexPosition[   5331706,      90294]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AspectRatio" :> 
         Documentation`HelpLookup["paclet:ref/AspectRatio"], "Axes" :> 
         Documentation`HelpLookup["paclet:ref/Axes"], "AxesOrigin" :> 
         Documentation`HelpLookup["paclet:ref/AxesOrigin"], "ClippingStyle" :> 
         Documentation`HelpLookup["paclet:ref/ClippingStyle"], 
         "ColorFunction" :> 
         Documentation`HelpLookup["paclet:ref/ColorFunction"], 
         "EconomizedRationalApproximation" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/EconomizedRationalApproximation"]\
, "FrameTicks" :> Documentation`HelpLookup["paclet:ref/FrameTicks"], 
         "GeneralMiniMaxApproximation" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"], 
         "GeneralRationalInterpolation" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"], 
         "InterpolateRoot" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/InterpolateRoot"], 
         "InterpolatingFunction" :> 
         Documentation`HelpLookup["paclet:ref/InterpolatingFunction"], 
         "MaxRecursion" :> 
         Documentation`HelpLookup["paclet:ref/MaxRecursion"], 
         "MiniMaxApproximation" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/MiniMaxApproximation"], 
         "NIntegrateInterpolatingFunction" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/NIntegrateInterpolatingFunction"]\
, "OrderStarInterpolation" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/OrderStarInterpolation"], 
         "OrderStarKind" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/OrderStarKind"], 
         "OrderStarLegend" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/OrderStarLegend"], 
         "OrderStarPlot" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/OrderStarPlot"], 
         "OrderStarPoles" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/OrderStarPoles"], 
         "OrderStarSymbolSize" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/OrderStarSymbolSize"], 
         "OrderStarSymbolThickness" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/OrderStarSymbolThickness"], 
         "OrderStarZeros" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/OrderStarZeros"], "PlotPoints" :> 
         Documentation`HelpLookup["paclet:ref/PlotPoints"], "PlotRange" :> 
         Documentation`HelpLookup["paclet:ref/PlotRange"], 
         "RationalInterpolation" :> 
         Documentation`HelpLookup[
          "paclet:FunctionApproximations/ref/RationalInterpolation"], "Re" :> 
         Documentation`HelpLookup["paclet:ref/Re"], "Ticks" :> 
         Documentation`HelpLookup["paclet:ref/Ticks"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"AspectRatio\"\>", 2->"\<\"Axes\"\>", 
      3->"\<\"AxesOrigin\"\>", 4->"\<\"ClippingStyle\"\>", 
      5->"\<\"ColorFunction\"\>", 
      6->"\<\"EconomizedRationalApproximation\"\>", 7->"\<\"FrameTicks\"\>", 
      8->"\<\"GeneralMiniMaxApproximation\"\>", 
      9->"\<\"GeneralRationalInterpolation\"\>", 
      10->"\<\"InterpolateRoot\"\>", 11->"\<\"InterpolatingFunction\"\>", 
      12->"\<\"MaxRecursion\"\>", 13->"\<\"MiniMaxApproximation\"\>", 
      14->"\<\"NIntegrateInterpolatingFunction\"\>", 
      15->"\<\"OrderStarInterpolation\"\>", 16->"\<\"OrderStarKind\"\>", 
      17->"\<\"OrderStarLegend\"\>", 18->"\<\"OrderStarPlot\"\>", 
      19->"\<\"OrderStarPoles\"\>", 20->"\<\"OrderStarSymbolSize\"\>", 
      21->"\<\"OrderStarSymbolThickness\"\>", 22->"\<\"OrderStarZeros\"\>", 
      23->"\<\"PlotPoints\"\>", 24->"\<\"PlotRange\"\>", 
      25->"\<\"RationalInterpolation\"\>", 26->"\<\"Re\"\>", 
      27->"\<\"Ticks\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Function Approximations Package", "Title",
 CellID->509267359],

Cell["This loads the package:", "MathCaption",
 CellID->836781195],

Cell[BoxData[
 RowBox[{"<<", "FunctionApproximations`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2058623809],

Cell[CellGroupData[{

Cell["\<\
Economized Rational Approximations using Pad\[EAcute] Approximations\
\>", "Section",
 CellID->726712236],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["EconomizedRationalApproximation",
      BaseStyle->"Link",
      ButtonData->
       "paclet:FunctionApproximations/ref/EconomizedRationalApproximation"], 
     "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["xmin", "TI"], ",", 
          StyleBox["xmax", "TI"]}], "}"}], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the economized rational approximation to ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " that is good in the range ",
     Cell[BoxData[
      StyleBox["xmin", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["xmax", "TI"]], "InlineFormula"],
     " and has degree ",
     Cell[BoxData[
      RowBox[{"(", 
       StyleBox["m", "TI"], ",", 
       StyleBox["k", "TI"], ")"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->13149],

Cell["Economized rational approximations. ", "Caption",
 CellID->30066],

Cell["\<\
A Pad\[EAcute] approximation is very accurate near the center of expansion, \
but the error increases rapidly as you get farther away. If one is willing to \
sacrifice some of the goodness of fit near the center of expansion it is \
possible to obtain a better fit over the entire interval under consideration. \
This is what the other types of approximation do. \
\>", "Text",
 CellID->10203],

Cell[TextData[{
 "With an economized rational approximation, the idea is to start with a Pad\
\[EAcute] approximation and perturb it with a Chebyshev polynomial in such a \
way as to reduce the leading coefficient in the error. This perturbation does \
cause the vanished terms to reappear. However, the magnitude of the error \
does not increase very much near the center of expansion and this small \
increase is compensated for by a decrease in the error farther away. With ",
 Cell[BoxData[
  ButtonBox["EconomizedRationalApproximation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/EconomizedRationalApproximation"]], 
  "InlineFormula"],
 " you specify the interval over which the approximation is to work rather \
than the center of expansion. In the limit as the length of the interval goes \
to zero, the economized rational approximation approaches the Pad\[EAcute] \
approximation. "
}], "Text",
 CellID->12755],

Cell[TextData[{
 "Here is the economized rational approximation of degree ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"2", ",", "4"}], ")"}]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " over the interval ",
 Cell[BoxData[
  RowBox[{"0", "\[LessEqual]", 
   StyleBox["x", "TI"], "\[LessEqual]", "2"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->20157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"era", "=", 
  RowBox[{"EconomizedRationalApproximation", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", "2", ",", "4"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->11323],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    FractionBox[
     RowBox[{"679583", " ", "\[ExponentialE]"}], "691200"], "+", 
    FractionBox[
     RowBox[{"4679", " ", "\[ExponentialE]", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "14400"], "+", 
    RowBox[{
     FractionBox["23", "720"], " ", "\[ExponentialE]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    FractionBox["679583", "691200"], "-", 
    FractionBox[
     RowBox[{"9479", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}]}], "14400"], "+", 
    RowBox[{
     FractionBox["143", "720"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "2"]}], "-", 
    RowBox[{
     FractionBox["1", "30"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "3"]}], "+", 
    RowBox[{
     FractionBox["1", "360"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}], "4"]}]}], ")"}]}]], "Output",
 ImageSize->{446, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->9161]
}, Open  ]],

Cell["\<\
This gives the difference between the true function and the economized \
rational approximation. In general you may even get a small nonvanishing \
constant term. \
\>", "MathCaption",
 CellID->7469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"era", "-", 
    SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->677],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"\[ExponentialE]", " ", 
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}]}], "679583"], "+", 
   FractionBox[
    RowBox[{"1589567", " ", "\[ExponentialE]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "2"]}], "923666107778"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "3"],
    SeriesData[$CellContext`x, 1, {}, 1, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {
   Rational[1, 679583] E, Rational[1589567, 923666107778] E}, 1, 3, 1],
  Editable->False]], "Output",
 ImageSize->{254, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->18636]
}, Open  ]],

Cell["\<\
The error has been spread out when compared to the Pad\[EAcute] approximation \
plotted above. \
\>", "MathCaption",
 CellID->17444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"era", "-", 
    SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->9374],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->786685096]
}, Open  ]],

Cell[TextData[{
 "Even though the error at the endpoint ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", "2"}]], "InlineFormula"],
 " is not particularly small, it is considerably smaller than what ",
 Cell[BoxData[
  ButtonBox["PadeApproximant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PadeApproximant"]], "InlineFormula"],
 " gives. "
}], "MathCaption",
 CellID->11686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"pd", "-", 
     SuperscriptBox["\[ExponentialE]", "x"]}], 
    RowBox[{"era", "-", 
     SuperscriptBox["\[ExponentialE]", "x"]}]], "/.", "\[InvisibleSpace]", 
   RowBox[{"x", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1062],

Cell[BoxData["7.535120171246252`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->24767]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Rational Interpolation and Mini-max Approximations", "Section",
 CellID->21562],

Cell[TextData[{
 "A degree ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], ")"}]], "InlineFormula"],
 " rational function is the ratio of a degree ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " polynomial to a degree ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " polynomial. Because rational functions only use the elementary arithmetic \
operations, they are very easy to evaluate numerically. The polynomial in the \
denominator allows you to approximate functions that have rational \
singularities. For these reasons a rational function is frequently useful in \
numerical work to approximate a given function. "
}], "Text",
 CellID->9354],

Cell[TextData[{
 "There are various methods to perform this approximation. The methods differ \
in how they interpret the notion of the goodness of the approximation. Each \
method is useful for certain classes of problems. You can use this package to \
compute general rational interpolations and minimax approximations. The \
function ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadeApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadeApproximant"], "MR"]], "InlineFormula"],
 " contains functionality that performs Pad\[EAcute] approximations."
}], "Text",
 CellID->10302],

Cell[TextData[{
 "There is a related class of approximation questions that involves the \
interpolation or fitting of a set of data points by an approximating \
function. In this type of situation you should use the built\[Hyphen]in \
functions ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InterpolatingPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingPolynomial"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Interpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
 ". For more information, see ",
 ButtonBox["Numerical Operations on Data",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalOperationsOnDataOverview"],
 ". "
}], "Text",
 CellID->16234],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["RationalInterpolation",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"],
       "[", 
      RowBox[{
       StyleBox["f", "TI"], ",", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["m", "TI"], ",", 
         StyleBox["k", "TI"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          RowBox[{
           StyleBox["m", "TI"], "+", 
           StyleBox["k", "TI"], "+", 
           StyleBox["1", "TR"]}]]}]}]}], "]"}], "}"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a rational interpolation of degree ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], ")"}]], "InlineFormula"],
     " to the points ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["i", "TI"]], ",", 
        RowBox[{
         StyleBox["f", "TI"], 
         RowBox[{"(", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["i", "TI"]], ")"}]}]}], ")"}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RationalInterpolation",
      BaseStyle->"Link",
      ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"], 
     "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["xmin", "TI"], ",", 
        StyleBox["xmax", "TI"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a rational interpolation with the points ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " chosen automatically"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->21115],

Cell["Rational interpolations. ", "Caption",
 CellID->4410],

Cell[TextData[{
 "One way to approximate a given function by a rational function is to choose \
a set of values for the independent variable and then construct a rational \
function that agrees with the given function at this set of values. This is \
what is done by ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->10263],

Cell[TextData[{
 "There are two ways of using ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 ". If you just specify a range in the independent variable, then the set of \
values is chosen automatically in a way that ensures a reasonable \
approximation for the degree of approximation you have chosen. You can also \
give an explicit list of the set of values to be used. Note that in this case \
if you ask for a degree ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], ")"}]], "InlineFormula"],
 "\[Hyphen]approximation, you must specify a list of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "+", 
   StyleBox["k", "TI"], "+", "1"}]], "InlineFormula"],
 " values for the independent variable. "
}], "Text",
 CellID->31074],

Cell[TextData[{
 "This gives a rational interpolation of degree ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"2", ",", "4"}], ")"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " at 7 equally spaced points between 0 and 2. "
}], "MathCaption",
 CellID->14881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ri1", "=", 
  RowBox[{"RationalInterpolation", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2", ",", "4"}], "}"}], ",", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "2", ",", 
      FractionBox["1", "3"]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[36]:=",
 CellID->12948],

Cell[BoxData[
 FractionBox[
  RowBox[{"1.`", "\[InvisibleSpace]", "+", 
   RowBox[{"0.37996150599461664`", " ", "x"}], "+", 
   RowBox[{"0.04695275726362258`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.6200285166941677`", " ", "x"}], "+", 
   RowBox[{"0.16691391444546624`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.023405766183683795`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0014527901993865817`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 ImageSize->{368, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->262446158]
}, Open  ]],

Cell["\<\
This plots the difference between the function and its approximation. Note \
that the error tends to get larger near the endpoints. \
\>", "MathCaption",
 CellID->18424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ri1", "-", 
    SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21301],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->322917805]
}, Open  ]],

Cell[TextData[{
 "Here ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically chooses the interpolation points. "
}], "MathCaption",
 CellID->30293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ri2", "=", 
  RowBox[{"RationalInterpolation", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25896],

Cell[BoxData[
 FractionBox[
  RowBox[{"1.000000157557967`", "\[InvisibleSpace]", "+", 
   RowBox[{"0.37982664361202656`", " ", "x"}], "+", 
   RowBox[{"0.04686932158124196`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.6201657303898894`", " ", "x"}], "+", 
   RowBox[{"0.16697788163228702`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.023411894979059007`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0014519160958491979`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 ImageSize->{368, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->894969568]
}, Open  ]],

Cell["\<\
The interpolation points are somewhat more bunched at the ends of the \
interval. This usually results in a smaller maximum error. \
\>", "MathCaption",
 CellID->4901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ri2", "-", 
    SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->18455],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->51917239]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "number of digits of precision to use", "TableText"]},
   {
    ButtonBox["Bias",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Bias"], "0", Cell[
    "bias in the automatic choice of interpolation points", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->22014],

Cell["Options for rational approximations.", "Caption",
 CellID->2007],

Cell[TextData[{
 "When you specify a range of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " values for ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 ", the interpolation points are chosen automatically. The option ",
 Cell[BoxData[
  ButtonBox["Bias",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Bias"]], "InlineFormula"],
 " allows you to bias the interpolation points to the right or to the left. \
Values for ",
 Cell[BoxData[
  ButtonBox["Bias",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Bias"]], "InlineFormula"],
 " must be numbers between ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " and ",
 Cell[BoxData["1"], "InlineFormula"],
 ". A positive value causes the points to be biased to the right. The default \
is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Bias",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/Bias"], "->", "0"}]], 
  "InlineFormula"],
 ", which causes the points to be symmetrically distributed. "
}], "Text",
 CellID->6673],

Cell["\<\
When you bias the distribution of the points to the right, you get smaller \
errors there and larger errors to the left. \
\>", "MathCaption",
 CellID->5699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ri3", "=", 
  RowBox[{"RationalInterpolation", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
    RowBox[{"Bias", "\[Rule]", ".25"}]}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->19066],

Cell[BoxData[
 FractionBox[
  RowBox[{"1.0000006809167992`", "\[InvisibleSpace]", "+", 
   RowBox[{"0.38618559511570055`", " ", "x"}], "+", 
   RowBox[{"0.04915261155140756`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.6137919183711082`", " ", "x"}], "+", 
   RowBox[{"0.16282048937825463`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.022340360550064987`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0013435969424497357`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 ImageSize->{354, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->173923340]
}, Open  ]],

Cell["This shows the influence of the bias. ", "MathCaption",
 CellID->18985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"ri3", "-", 
    SuperscriptBox["\[ExponentialE]", "x"]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->30524],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->169574077]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 ", you get a rational function that agrees with the given function at a set \
of points. This guarantees that the rational function is, in one sense, close \
to the given function. A stronger requirement for a good rational \
approximation would be to require that the rational function be close to the \
given function over the entire interval. This type of rational approximation \
is produced by ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 ". This approximation is so named because it minimizes the maximum value of \
the relative error between the approximation and the given function. This \
means that minimax approximation ",
 Cell[BoxData[
  RowBox[{
   StyleBox["r", "TI"], 
   RowBox[{"(", 
    StyleBox["x", "TI"], ")"}]}]], "InlineFormula"],
 " to a given function ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], 
   RowBox[{"(", 
    StyleBox["x", "TI"], ")"}]}]], "InlineFormula"],
 " is the rational function of the given degree that minimizes the maximum \
value of the quantity ",
 Cell[BoxData[
  RowBox[{"\[VerticalSeparator]", "1", "-", 
   StyleBox["r", "TI"], 
   RowBox[{"(", 
    StyleBox["x", "TI"], ")"}], "/", 
   StyleBox["f", "TI"], 
   RowBox[{"(", 
    StyleBox["x", "TI"], ")"}], "\[VerticalSeparator]"}]], "InlineFormula"],
 " over the interval under consideration. Note that the term minimax \
approximation is also sometimes used for the rational function that minimizes \
the absolute error rather than the relative error used here. "
}], "Text",
 CellID->27629],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     RowBox[{
      ButtonBox["MiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"], 
      "[", 
      StyleBox["f", "TI"], ",", "{", 
      StyleBox["x", "TI"], ",", "{", 
      StyleBox["xmin", "TI"], ",", 
      StyleBox["xmax", "TI"], "}", ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["k", "TI"], "}", "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the minimax approximation to ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " of degree ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], ")"}]], "InlineFormula"],
     " on the interval from ",
     Cell[BoxData[
      StyleBox["xmin", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["xmax", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["MiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"], 
      "[", 
      StyleBox["f", "TI"], ",", 
      StyleBox["approx", "TI"], ",", "{", 
      StyleBox["x", "TI"], ",", "{", 
      StyleBox["xmin", "TI"], ",", 
      StyleBox["xmax", "TI"], "}", ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["k", "TI"], "}", "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the minimax approximation starting the iterative algorithm with ",
     Cell[BoxData[
      StyleBox["approx", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1118],

Cell["The minimax approximation. ", "Caption",
 CellID->30111],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " works using an iterative scheme. The first step is to construct a rational \
approximation using ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 ". This first approximation is then used to generate a better approximation \
using a scheme based on Remes\[CloseCurlyQuote]s algorithm. Generating the \
new approximation consists of adjusting the choice of the interpolation \
points in a way that ensures that the relative error will diminish. "
}], "Text",
 CellID->27602],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " returns a list with two parts: a list of the points at which the maximum \
error occurs and a list consisting of the rational approximation and the \
value of the maximum error. This extra information is provided not so much \
for the user\[CloseCurlyQuote]s information, but to provide the capability of \
restarting the procedure without having to start back at the beginning. This \
is useful because the algorithm is iterative, and if convergence does not \
occur before ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 " is reached, the incomplete answer is returned along with a warning. "
}], "Text",
 CellID->32322],

Cell["\<\
This gives a list containing the points where the maximum error occurs and \
the desired interpolation, along with the value of the error. \
\>", "MathCaption",
 CellID->12042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mmlist", "=", 
  RowBox[{"MiniMaxApproximation", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", "2", ",", "4"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->20187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.`", ",", "0.10634864876572474`", ",", "0.40091530825859106`", ",", 
     "0.8166361480260741`", ",", "1.2626977933225796`", ",", 
     "1.6497494564750643`", ",", "1.9091204969576991`", ",", "2.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1.0000002060521063`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.38088147329931`", " ", "x"}], "+", 
        RowBox[{"0.04723949252622763`", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"0.619109229762164`", " ", "x"}], "+", 
        RowBox[{"0.16628287942691594`", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"0.023230448862141338`", " ", 
         SuperscriptBox["x", "3"]}], "+", 
        RowBox[{"0.001433248923476686`", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}], ",", 
     RowBox[{"-", "2.060521062738397`*^-7"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{516, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->62906295]
}, Open  ]],

Cell["This extracts the rational approximation. ", "MathCaption",
 CellID->14497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mmfunc", "=", 
  RowBox[{"mmlist", "\[LeftDoubleBracket]", 
   RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->9188],

Cell[BoxData[
 FractionBox[
  RowBox[{"1.0000002060521063`", "\[InvisibleSpace]", "+", 
   RowBox[{"0.38088147329931`", " ", "x"}], "+", 
   RowBox[{"0.04723949252622763`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.619109229762164`", " ", "x"}], "+", 
   RowBox[{"0.16628287942691594`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.023230448862141338`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.001433248923476686`", " ", 
    SuperscriptBox["x", "4"]}]}]]], "Output",
 ImageSize->{368, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->232520968]
}, Open  ]],

Cell[TextData[{
 "Here is a plot of the relative error in the approximation over the interval \
",
 Cell[BoxData[
  RowBox[{"0", "\[LessEqual]", 
   StyleBox["x", "TI"], "\[LessEqual]", "2"}]], "InlineFormula"],
 ". Reducing the error at any one of the extrema will force the error to \
increase at one of the others. "
}], "MathCaption",
 CellID->30838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    FractionBox["mmfunc", 
     SuperscriptBox["\[ExponentialE]", "x"]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->7613],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->265931851]
}, Open  ]],

Cell[TextData[{
 "Because ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " tries to minimize the maximum of the ",
 StyleBox["relative",
  FontSlant->"Italic"],
 " error, it is not possible to find a minimax approximation to a function \
that has a zero in the interval in question. The rational approximation would \
have to be ",
 StyleBox["exactly",
  FontSlant->"Italic"],
 " zero at the zero of the function, or the relative error would be infinite. \
It is still possible to deal with such functions, but the zero must be \
divided out of the function and then multiplied back into the rational \
function. "
}], "Text",
 CellID->22831],

Cell[TextData[{
 "At ",
 Cell[BoxData[
  FractionBox["\[Pi]", "2"]], "InlineFormula"],
 " the relative error is infinite. "
}], "MathCaption",
 CellID->8550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MiniMaxApproximation", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "2", ",", "4"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->7596],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiniMaxApproximation", "::", "\<\"van\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Failed to locate the extrema in \
\\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\(20\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" \
iterations. The function \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(Cos[x]\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" may be vanishing \
on the interval \\\\\\\"\\\", \\\"MSG\\\"]\\)\\!\\({1, \
2}\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" or the WorkingPrecision may be \
insufficient to get convergence.\\\\\\\"\\\", \\\"MSG\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellLabel->"During evaluation of In[11]:=",
 CellID->267414114],

Cell[BoxData[
 RowBox[{"MiniMaxApproximation", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "2", ",", "4"}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->81202438]
}, Open  ]],

Cell[TextData[{
 "Dividing by ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["x", "TI"], "-", 
    RowBox[{
     ButtonBox["Pi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pi"], "/", "2"}]}], ")"}]], "InlineFormula"],
 " cancels the zero and there is now no problem computing the approximation. \
"
}], "MathCaption",
 CellID->26029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MiniMaxApproximation", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"x", "-", 
      FractionBox["\[Pi]", "2"]}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", "2", ",", "4"}], "}"}]}], "]"}], 
  "\[LeftDoubleBracket]", 
  RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->4117],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "0.6364826405160753`"}], "-", 
    RowBox[{"0.2841959634558956`", " ", "x"}], "+", 
    RowBox[{"0.09045955273664566`", " ", 
     SuperscriptBox["x", "2"]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"0.19136117483310378`", " ", "x"}], "+", 
    RowBox[{"0.07710218647205018`", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"0.010305850310329349`", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"0.0016404683269485236`", " ", 
     SuperscriptBox["x", "4"]}]}], ")"}]}]], "Output",
 ImageSize->{391, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->58559116]
}, Open  ]],

Cell[TextData[{
 "Multiplying the approximation by ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["x", "TI"], "-", 
    RowBox[{
     ButtonBox["Pi",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Pi"], "/", "2"}]}], ")"}]], "InlineFormula"],
 " then gives the minimax approximation to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cos"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->23906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mmacos", "=", 
  RowBox[{"%", " ", 
   RowBox[{"N", "[", 
    RowBox[{"x", "-", 
     FractionBox["\[Pi]", "2"]}], "]"}]}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->21321],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1.5707963267948966`"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "0.6364826405160753`"}], "-", 
      RowBox[{"0.2841959634558956`", " ", "x"}], "+", 
      RowBox[{"0.09045955273664566`", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"0.19136117483310378`", " ", "x"}], "+", 
    RowBox[{"0.07710218647205018`", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"0.010305850310329349`", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"0.0016404683269485236`", " ", 
     SuperscriptBox["x", "4"]}]}], ")"}]}]], "Output",
 ImageSize->{391, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->36265498]
}, Open  ]],

Cell["This plots the relative error. ", "MathCaption",
 CellID->1225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    FractionBox["mmacos", 
     RowBox[{"Cos", "[", "x", "]"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->29738],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->13071404]
}, Open  ]],

Cell[TextData[{
 "There are several ways in which ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " can fail. In these cases, you will usually get a message indicating what \
probably went wrong and what you can do to avoid the problem. For example, if \
you ask for a minimax approximation of degree ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], ")"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " will look for a rational minimax approximation such that the relative \
error oscillates in sign and the extreme values are achieved ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "+", 
   StyleBox["k", "TI"], "+", "2"}]], "InlineFormula"],
 " times. Sometimes the extreme values occur more times. It may be possible \
to design a more robust algorithm to deal with this problem, but in practice \
it is usually quite simple just to ask for a minimax approximation with \
different degree. "
}], "Text",
 CellID->15881],

Cell["\<\
When you try to compute this approximation you get a warning. Notice that \
there is not a single error, but a list of errors corresponding to the \
abscissas in the first part. \
\>", "MathCaption",
 CellID->25239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MiniMaxApproximation", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"x", "-", 
     FractionBox["\[Pi]", "2"]}]], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "2", ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->8107],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiniMaxApproximation", "::", "\<\"extalt\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"The extrema of the error do not \
alternate in sign.  It may be that MiniMaxApproximation has lost track of the \
extrema by going too fast. If so try increasing the values in the option \
Brake. It may be that the WorkingPrecision is insufficient. Otherwise there \
is an extra extreme value of the error, and MiniMaxApproximation cannot deal \
with this problem.\\\\\\\"\\\", \\\"MSG\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[15]:=",
 CellID->11515729],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "1.0912051971648304`", ",", "1.3303090610317356`", ",", 
     "1.6246664208589445`", ",", "1.8540080484138919`", ",", "2.`"}], "}"}], 
   ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "0.6343420065076449`"}], "-", 
     RowBox[{"0.32443741337713117`", " ", "x"}], "+", 
     RowBox[{"0.10328269957446742`", " ", 
      SuperscriptBox["x", "2"]}]}], 
    RowBox[{"1.`", "\[InvisibleSpace]", "-", 
     RowBox[{"0.14113212898037397`", " ", "x"}], "+", 
     RowBox[{"0.04491243791787559`", " ", 
      SuperscriptBox["x", "2"]}]}]], ",", 
   RowBox[{"{", 
    RowBox[{"4.0830020819893065`*^-7", ",", 
     RowBox[{"-", "3.640061645437953`*^-7"}], ",", "2.532758285322956`*^-7", 
     ",", 
     RowBox[{"-", "1.228623061066969`*^-7"}], ",", "2.1919101644840566`*^-8", 
     ",", "3.256175651333848`*^-8"}], "}"}]}], "}"}]], "Output",
 ImageSize->{442, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->120140048]
}, Open  ]],

Cell["This extracts the approximation and cancels the factor. ", "MathCaption",
 CellID->154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"badmma", "=", 
  RowBox[{
   RowBox[{"%", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], " ", 
   RowBox[{"N", "[", 
    RowBox[{"x", "-", 
     FractionBox["\[Pi]", "2"]}], "]"}]}]}]], "Input",
 CellLabel->"In[16]:=",
 CellID->6685],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1.5707963267948966`"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "0.6343420065076449`"}], "-", 
     RowBox[{"0.32443741337713117`", " ", "x"}], "+", 
     RowBox[{"0.10328269957446742`", " ", 
      SuperscriptBox["x", "2"]}]}], ")"}]}], 
  RowBox[{"1.`", "\[InvisibleSpace]", "-", 
   RowBox[{"0.14113212898037397`", " ", "x"}], "+", 
   RowBox[{"0.04491243791787559`", " ", 
    SuperscriptBox["x", "2"]}]}]]], "Output",
 ImageSize->{335, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->316469719]
}, Open  ]],

Cell["\<\
Notice that the relative error has seven local extrema rather than the \
expected six. \
\>", "MathCaption",
 CellID->26393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    FractionBox["badmma", 
     RowBox[{"Cos", "[", "x", "]"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->15249],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 86},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->368803119]
}, Open  ]],

Cell["\<\
After changing the degree of the requested approximation, you no longer have \
the problem. \
\>", "MathCaption",
 CellID->28008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MiniMaxApproximation", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], 
     RowBox[{"x", "-", 
      FractionBox["\[Pi]", "2"]}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", "2", ",", "3"}], "}"}]}], "]"}], 
  "\[LeftDoubleBracket]", 
  RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->31934],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "0.6348762159335185`"}], "-", 
   RowBox[{"0.3176914894262772`", " ", "x"}], "+", 
   RowBox[{"0.10245244569201396`", " ", 
    SuperscriptBox["x", "2"]}]}], 
  RowBox[{"1", "-", 
   RowBox[{"0.14896308471407893`", " ", "x"}], "+", 
   RowBox[{"0.04777268882735507`", " ", 
    SuperscriptBox["x", "2"]}], "-", 
   RowBox[{"0.0007147502537103787`", " ", 
    SuperscriptBox["x", "3"]}]}]]], "Output",
 ImageSize->{283, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->56655912]
}, Open  ]],

Cell["\<\
Another thing that can happen is that the initial rational interpolation can \
have a zero in the denominator somewhere in the interval. In such cases it is \
usually easiest to ask for a minimax approximation of different degree. \
Occasionally, however, this approach does not solve the problem. \
\>", "Text",
 CellID->8672],

Cell["\<\
A trick that will sometimes work is to start with an approximation that is \
valid over a shorter interval. Because the minimax approximation will usually \
change continuously as you lengthen the interval, you can use the \
approximation for the shorter interval as a starting point for an \
approximation on a slightly longer interval. By slowly stretching the \
interval, you may be able to eventually get a minimax approximation that is \
valid over the interval you desire. \
\>", "Text",
 CellID->5707],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " has several options that give the user control over how it works and two \
options that help in diagnosing failures. "
}], "Text",
 CellID->21496],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "number of digits of precision to use", "TableText"]},
   {
    ButtonBox["Bias",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Bias"], "0", Cell[
    "bias in the automatic choice of interpolation points", "TableText"]},
   {
    ButtonBox["Brake",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Brake"], 
    RowBox[{"{", "5", ",", "5", "}"}], Cell[
    "braking to apply on iterative algorithm", "TableText"]},
   {
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], "20", Cell[
    "maximum number of iterates after braking has ended", "TableText"]},
   {
    ButtonBox["Derivatives",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Derivatives"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies a function to use for the derivatives", "TableText"]},
   {
    ButtonBox["PrintFlag",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/PrintFlag"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to print information about the relative error at each step in the \
iteration\
\>", "TableText"]},
   {
    ButtonBox["PlotFlag",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/PlotFlag"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to plot the relative error at each step in the iteration\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->17942],

Cell["Options for minimax approximations.", "Caption",
 CellID->14972],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " works by first finding a rational interpolation to the given function and \
then perturbing the coefficients until the error is equi\[Hyphen]oscillatory. \
The option ",
 Cell[BoxData[
  ButtonBox["Bias",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Bias"]], "InlineFormula"],
 " is used to control the initial rational approximation in exactly the same \
way it is used in ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->22650],

Cell[TextData[{
 "As ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " proceeds, it alternately locates the extrema of the relative error and \
then perturbs the coefficients in an effort to equalize the magnitudes of the \
extrema. If the extrema move only a small amount from one iteration to the \
next, their previous positions can be used as starting values in locating \
their new positions. If they move too much from one iteration to the next, ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " gets lost. The way ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " knows it is lost is if the extrema do not alternate in sign, two extrema \
are the same, or their abscissas are not in sorted order. "
}], "Text",
 CellID->15008],

Cell[TextData[{
 "The way to prevent ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " from getting lost is to set the option ",
 Cell[BoxData[
  ButtonBox["Brake",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Brake"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Brake",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Brake"]], "InlineFormula"],
 " acts as a braking mechanism on the changes from one iteration to the next, \
but its influence eventually dies off to the point where there is no braking \
effect. When the algorithm has almost converged, there is no need to provide \
braking, because the changes are very small. "
}], "Text",
 CellID->5819],

Cell[TextData[{
 "A value for ",
 Cell[BoxData[
  ButtonBox["Brake",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Brake"]], "InlineFormula"],
 " must be a list of two positive integers. The first integer specifies how \
many iterations are to be affected by the braking, and the second integer \
specifies how much braking force is to be applied to the first iteration. ",
 Cell[BoxData[
  ButtonBox["Brake",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Brake"]], "InlineFormula"],
 " is much more important for minimax approximations of high degree, because \
in this case, the abscissas of the extrema are very close together. "
}], "Text",
 CellID->5621],

Cell[TextData[{
 "To perform its iterative scheme, ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " must know the first two derivatives of the function being approximated. If \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot compute the derivatives analytically, you must specify them \
explicitly. A related situation is when the derivatives can be found, but \
calculating them involves a lot of work, much of which is redundant. For \
example, in trying to find a minimax approximation to ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " needs to evaluate ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " to find the value of the function, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " needs to evaluate ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " to find the value of the first derivative, and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " needs to evaluate ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " to find the value of the second derivative. A much simpler way would be \
for the user to specify a function that returns a list of these three values \
for each value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". This is the purpose of the option ",
 Cell[BoxData[
  ButtonBox["Derivatives",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Derivatives"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->19483],

Cell[TextData[{
 "There are two things to be aware of when you use this option. First, the \
function should not be allowed to evaluate until ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is actually a number, or the whole purpose of using the option will be \
defeated. "
}], "Text",
 CellID->727],

Cell[TextData[{
 "This prevents ",
 StyleBox["derivs", "MR"],
 " from evaluating unless ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a number. "
}], "MathCaption",
 CellID->13573],

Cell[BoxData[
 RowBox[{
  RowBox[{"derivs", "[", 
   RowBox[{"x_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"exp", "=", 
      SuperscriptBox["\[ExponentialE]", "x"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"exp", ",", "exp", ",", "exp"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[19]:=",
 CellID->13705],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " works with our definition for the derivatives. "
}], "MathCaption",
 CellID->24644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MiniMaxApproximation", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "2", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"Derivatives", "\[Rule]", 
    RowBox[{"derivs", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->18158],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "0.8123042914372025`"}], ",", 
     RowBox[{"-", "0.31241459440211694`"}], ",", "0.31241459440223107`", ",", 
     "0.81230429143741`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"0.9999999962330653`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.49978562382661434`", " ", "x"}], "+", 
       RowBox[{"0.08159269632524041`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "-", 
       RowBox[{"0.4997856257092587`", " ", "x"}], "+", 
       RowBox[{"0.08159269663258746`", " ", 
        SuperscriptBox["x", "2"]}]}]], ",", 
     RowBox[{"-", "0.00008679786398612661`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{363, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->431547571]
}, Open  ]],

Cell[TextData[{
 "To prevent infinite iteration, ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " has the option ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 ". If convergence does not occur before the number of iterations after the \
braking stops reaches ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 ", a warning is returned along with the current approximation. If the \
problem is simply slow convergence, you can restart the iteration from the \
current approximation by inserting the approximation that was returned as the \
second argument to ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 ". You may find it useful to begin the new iteration with different options. \
"
}], "Text",
 CellID->3644],

Cell[TextData[{
 "To get an example of a poor approximation, you can choose a small value of \
",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 ", a large bias, and no braking. "
}], "MathCaption",
 CellID->2491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"approx", "=", 
  RowBox[{"MiniMaxApproximation", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "2", ",", "2"}], "}"}], 
    ",", 
    RowBox[{"Brake", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], ",", 
    RowBox[{"MaxIterations", "\[Rule]", "2"}], ",", 
    RowBox[{"Bias", "\[Rule]", ".4"}]}], "]"}]}]], "Input",
 CellLabel->"In[21]:=",
 CellID->27934],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiniMaxApproximation", "::", "\<\"conv\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Warning: convergence was not \
complete.\\\\\\\"\\\", \\\"MSG\\\"]\\)\"\>"}]], "Message", "MSG",
 CellLabel->"During evaluation of In[21]:=",
 CellID->316966572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "0.8278198033487165`"}], ",", 
     RowBox[{"-", "0.33048088024148503`"}], ",", "0.42113414852590725`", ",", 
     "0.8847420999710436`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"0.9999726685696249`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.4985267091703717`", " ", "x"}], "+", 
       RowBox[{"0.08097205283241146`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "-", 
       RowBox[{"0.5009857081969005`", " ", "x"}], "+", 
       RowBox[{"0.08208101052946801`", " ", 
        SuperscriptBox["x", "2"]}]}]], ",", 
     RowBox[{"-", "0.00006923106415658196`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{365, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->7778084]
}, Open  ]],

Cell["\<\
The result of the previous approximation attempt is used as the starting \
point of the new iteration by inserting it as a second argument. \
\>", "MathCaption",
 CellID->20224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MiniMaxApproximation", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], ",", "approx", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "2", ",", "2"}], "}"}], 
   ",", 
   RowBox[{"Brake", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->4986],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.`"}], ",", 
     RowBox[{"-", "0.8123042956925292`"}], ",", 
     RowBox[{"-", "0.3124146082571955`"}], ",", "0.31241456652088206`", ",", 
     "0.8123043534945539`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox[
      RowBox[{"0.9999999962232217`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.4997856225433662`", " ", "x"}], "+", 
       RowBox[{"0.08159269575041789`", " ", 
        SuperscriptBox["x", "2"]}]}], 
      RowBox[{"1", "-", 
       RowBox[{"0.4997856270113097`", " ", "x"}], "+", 
       RowBox[{"0.08159269724251202`", " ", 
        SuperscriptBox["x", "2"]}]}]], ",", 
     RowBox[{"-", "0.00008679785560271042`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{363, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->405975559]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PrintFlag",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/PrintFlag"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PlotFlag",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/PlotFlag"]], 
  "InlineFormula"],
 " are options to ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " that are useful for diagnosing the reason for failure. Setting either of \
these options will have no effect on the calculations. If ",
 Cell[BoxData[
  ButtonBox["PlotFlag",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/PlotFlag"]], 
  "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"], "MR"]], "InlineFormula"],
 StyleBox[",", "MR"],
 " a plot of the relative error in each iterated rational approximation will \
be generated. If these plots change dramatically from one iteration to the \
next, you should probably increase the braking. If ",
 Cell[BoxData[
  ButtonBox["PrintFlag",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/PrintFlag"]], 
  "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", two things will happen. First, as the extrema are being located for the \
first time, lists of the changes in the approximations to the abscissas will \
be printed out. The numbers in these lists should rapidly decrease once they \
get reasonably small. After the extrema are located for the first time, lists \
of ordered pairs are printed consisting of abscissas of the extrema of the \
relative error and the value of the relative error at each of those \
abscissas. "
}], "Text",
 CellID->13331],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GeneralRationalInterpolation",
      BaseStyle->"Link",
      ButtonData->
       "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"], "[",
      
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["x", "TI"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["y", "TI"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], "}"}], ",", 
      StyleBox["x", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         RowBox[{"n", "+", "k", "+", 
          StyleBox["1", "TR"]}]]}], "}"}]}], 
     StyleBox["]",
      GridElementStyleOptions -> {ColumnAlignments -> Left}]}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a rational interpolation of degree ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], ")"}]], "InlineFormula"],
     " to a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " whose graph is given parametrically as a function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["GeneralRationalInterpolation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"], 
      "[", "{", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["y", "TI"]], "}", ",", "{", 
      StyleBox["t", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["k", "TI"], "}", ",", 
      StyleBox["x", "TI"], ",", "{", 
      StyleBox["t", "TI"], ",", 
      StyleBox["tmin", "TI"], ",", 
      StyleBox["tmax", "TI"], "}", "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a rational interpolation with the points ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " chosen automatically"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->21901],

Cell["General rational interpolations. ", "Caption",
 CellID->30753],

Cell[TextData[{
 "There are certain approximation problems in which you will want to use ",
 Cell[BoxData[
  ButtonBox["GeneralRationalInterpolation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"]], 
  "InlineFormula"],
 " instead of ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 ". For example, you should use ",
 Cell[BoxData[
  ButtonBox["GeneralRationalInterpolation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"]], 
  "InlineFormula"],
 " if you want to find a rational interpolating function to the ",
 StyleBox["inverse",
  FontSlant->"Italic"],
 " of a function that can only be evaluated by using ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ". In such a case, ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 " would be very slow. "
}], "Text",
 CellID->26955],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeneralRationalInterpolation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"]], 
  "InlineFormula"],
 " lets you do more general approximation problems by allowing the function \
that is to be approximated to be given parametrically. For example, the graph \
of the function ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], 
   RowBox[{"(", 
    StyleBox["x", "TI"], ")"}], "=", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox[
      StyleBox["x", "TI"], "2"]}]]}]], "InlineFormula"],
 " is just the upper half of the unit circle. This can also be described \
parametrically as ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"cos", 
    StyleBox["t", "TI"], ",", "sin", 
    StyleBox["t", "TI"]}], ")"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  RowBox[{"0", "\[LessEqual]", 
   StyleBox["t", "TI"], "\[LessEqual]", "\[Pi]"}]], "InlineFormula"],
 ". Thus you can compute an approximation to ",
 Cell[BoxData[
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox[
     StyleBox["x", "TI"], "2"]}]]], "InlineFormula"],
 " by specifying the function as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     ButtonBox["Cos",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cos"], "[", 
     StyleBox["t", "TI"], "]"}], ",", " ", 
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     StyleBox["t", "TI"], "]"}]}], "}"}]], "InlineFormula"],
 " "
}], "Text",
 CellID->326],

Cell[TextData[{
 "In the general case, when you specify the functions in ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["x", "TI"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["y", "TI"]]}], "}"}]], "InlineFormula"],
 ", the expressions ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["y", "TI"]]], "InlineFormula"],
 " are functions of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ". The function that is interpolated is the one whose graph is given \
parametrically by ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["x", "TI"]], 
    RowBox[{"(", 
     StyleBox["t", "TI"], ")"}], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["y", "TI"]], 
    RowBox[{"(", 
     StyleBox["t", "TI"], ")"}]}], ")"}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["tmin", "TI"], "\[LessEqual]", 
   StyleBox["t", "TI"], "\[LessEqual]", 
   StyleBox["tmax", "TI"]}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21596],

Cell[TextData[{
 "Note that you must always specify a symbol for the independent variable; \
using the parametric variable as the independent variable would be incorrect. \
",
 Cell[BoxData[
  ButtonBox["GeneralRationalInterpolation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"]], 
  "InlineFormula"],
 " takes the same options as ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->12728],

Cell["\<\
This gives an approximation to the function whose graph is the upper half \
circle. \
\>", "MathCaption",
 CellID->24251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gri1", "=", 
  RowBox[{"GeneralRationalInterpolation", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], ",", 
      RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "2", ",", "4"}], "}"}], ",", "x", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"i", " ", "\[Pi]"}], "6"], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "6"}], "}"}]}], "]"}]}], "]"}]}]], "Input",\

 CellLabel->"In[23]:=",
 CellID->28061],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"0.9999999999999999`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.6407156042244626`*^-17", " ", "x"}], "-", 
    RowBox[{"0.9999999999999999`", " ", 
     SuperscriptBox["x", "2"]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"2.4037033579794546`*^-16", " ", "x"}], "-", 
    RowBox[{"0.4705142439600349`", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"1.7693583314217538`*^-16", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"0.2615365636088426`", " ", 
     SuperscriptBox["x", "4"]}]}], ")"}]}]], "Output",
 ImageSize->{424, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->371525233]
}, Open  ]],

Cell["The error is quite large near the endpoints. ", "MathCaption",
 CellID->19480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"gri1", "-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->17153],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->249598677]
}, Open  ]],

Cell["\<\
You don\[CloseCurlyQuote]t need to specify the interpolation points \
explicitly. \
\>", "MathCaption",
 CellID->7491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gri2", "=", 
  RowBox[{"GeneralRationalInterpolation", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], ",", 
      RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "2", ",", "4"}], "}"}], ",", "x", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[25]:=",
 CellID->17252],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"0.9999999999999998`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.1673350326109832`*^-17", " ", "x"}], "-", 
    RowBox[{"0.9922198938554383`", " ", 
     SuperscriptBox["x", "2"]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"1.0458057635833247`*^-16", " ", "x"}], "-", 
    RowBox[{"0.41320504871203684`", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"4.8930853434600716`*^-17", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"0.35185873773556553`", " ", 
     SuperscriptBox["x", "4"]}]}], ")"}]}]], "Output",
 ImageSize->{431, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->55808814]
}, Open  ]],

Cell[TextData[{
 "As is the case with ",
 Cell[BoxData[
  ButtonBox["RationalInterpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFormula"],
 ", the error is often smaller if the interpolation points are not given \
explicitly. The points chosen automatically tend to be better distributed. "
}], "MathCaption",
 CellID->5726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"gri2", "-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->26269],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->84625963]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     RowBox[{
      ButtonBox["GeneralMiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"], "[",
       "{", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["y", "TI"]], "}", ",", "{", 
      StyleBox["t", "TI"], ",", "{", 
      StyleBox["tmin", "TI"], ",", 
      StyleBox["tmax", "TI"], "}", ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["k", "TI"], "}", ",", 
      StyleBox["x", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the rational approximation of degree ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], ")"}]], "InlineFormula"],
     " to a function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " whose graph is given parametrically as a function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["GeneralMiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"], "[",
       "{", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["y", "TI"]], "}", ",", 
      StyleBox["approx", "TI"], ",", "{", 
      StyleBox["t", "TI"], ",", "{", 
      StyleBox["tmin", "TI"], ",", 
      StyleBox["tmax", "TI"], "}", ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["k", "TI"], "}", ",", 
      StyleBox["x", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the minimax approximation starting the iterative algorithm with ",
     Cell[BoxData[
      StyleBox["approx", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["GeneralMiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"], "[",
       "{", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["y", "TI"]], ",", 
      StyleBox["g", "TI"], "}", ",", "{", 
      StyleBox["t", "TI"], ",", "{", 
      StyleBox["tmin", "TI"], ",", 
      StyleBox["tmax", "TI"], "}", ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["k", "TI"], "}", ",", 
      StyleBox["x", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the rational approximation computing the error using a factor ",
     Cell[BoxData[
      RowBox[{
       StyleBox["g", "TI"], 
       RowBox[{"(", 
        StyleBox["t", "TI"], ")"}]}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->6130],

Cell["General minimax approximations. ", "Caption",
 CellID->5721],

Cell[TextData[{
 "The function that is to be approximated is specified in ",
 Cell[BoxData[
  ButtonBox["GeneralMiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
  "InlineFormula"],
 " in the same way as it is in ",
 Cell[BoxData[
  ButtonBox["GeneralRationalInterpolation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"]], 
  "InlineFormula"],
 ". The options for ",
 Cell[BoxData[
  ButtonBox["GeneralMiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
  "InlineFormula"],
 " are the same as for ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->31667],

Cell[TextData[{
 "This gives a degree ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{"2", ",", "4"}], ")"}]], "InlineFormula"],
 " minimax approximation to the inverse of ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gmma1", "=", 
  RowBox[{"GeneralMiniMaxApproximation", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "t"], ",", "t"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", "2", ",", "4"}], "}"}], ",", 
    "x"}], "]"}]}]], "Input",
 CellLabel->"In[27]:=",
 CellID->15017],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "1.04716016518393`", ",", "1.1813107377565732`", ",", 
     "1.3793050470159398`", ",", "1.6031080469522478`", ",", 
     "1.80714757373683`", ",", "1.9491940550069808`", ",", "2.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2.0823977916379657`"}], "+", 
        RowBox[{"1.2738087749527407`", " ", "x"}], "+", 
        RowBox[{"0.8236002441776232`", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"1.731869303837488`", " ", "x"}], "+", 
        RowBox[{"0.24591757015970903`", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"0.0030965712047703164`", " ", 
         SuperscriptBox["x", "3"]}], "+", 
        RowBox[{"0.000058428236489592907`", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}], ",", 
     RowBox[{"-", "6.746838861625006`*^-8"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{530, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->32607592]
}, Open  ]],

Cell[TextData[{
 "Since there is an easy way to evaluate the inverse of ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 ", it is also possible to use ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " for this problem. The only difference between the solutions is in the \
abscissas of the extrema. "
}], "MathCaption",
 CellID->17011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MiniMaxApproximation", "[", 
  RowBox[{
   RowBox[{"Log", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"\[ExponentialE]", ",", 
       SuperscriptBox["\[ExponentialE]", "2"]}], "}"}], ",", "2", ",", "4"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->27725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "2.7182818284590446`", ",", "2.8495473730262146`", ",", 
     "3.2586426306697125`", ",", "3.9721402170723`", ",", 
     "4.968450628857994`", ",", "6.093042666126032`", ",", 
     "7.023025127101972`", ",", "7.38905609893065`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2.082397791683321`"}], "+", 
        RowBox[{"1.2738087749317641`", " ", "x"}], "+", 
        RowBox[{"0.8236002442416257`", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"1.7318693039165578`", " ", "x"}], "+", 
        RowBox[{"0.24591757018192337`", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"0.003096571205226037`", " ", 
         SuperscriptBox["x", "3"]}], "+", 
        RowBox[{"0.00005842823650092103`", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}], ",", 
     RowBox[{"-", "6.746838847759367`*^-8"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{530, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->148366928]
}, Open  ]],

Cell["This extracts the minimax approximation. ", "MathCaption",
 CellID->3162],

Cell[BoxData[
 RowBox[{
  RowBox[{"log", "=", 
   RowBox[{"gmma1", "\[LeftDoubleBracket]", 
    RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}], ";"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->2050],

Cell[TextData[{
 "Here is a plot of the relative error in the approximation over the interval \
",
 Cell[BoxData[
  RowBox[{
   StyleBox["e", "TI"], "\[LessEqual]", 
   StyleBox["x", "TI"], "\[LessEqual]", 
   SuperscriptBox[
    StyleBox["e", "TI"], "2"]}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    FractionBox["log", 
     RowBox[{"Log", "[", "x", "]"}]]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "\[ExponentialE]", ",", 
     SuperscriptBox["\[ExponentialE]", "2"]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[30]:=",
 CellID->1215],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->6504377]
}, Open  ]],

Cell[TextData[{
 "If you use the option ",
 Cell[BoxData[
  ButtonBox["Derivatives",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Derivatives"]], 
  "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["GeneralMiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
  "InlineFormula"],
 ", you must specify a list of derivatives for both parts of the \
parametrically defined function. "
}], "Text",
 CellID->12455],

Cell[TextData[{
 "This prevents ",
 StyleBox["gderivs", "MR"],
 " from acting on symbols. "
}], "MathCaption",
 CellID->24711],

Cell[BoxData[
 RowBox[{
  RowBox[{"gderivs", "[", 
   RowBox[{"t_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"exp", "=", 
      SuperscriptBox["\[ExponentialE]", "t"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"exp", ",", "exp", ",", "exp"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "0"}], "}"}]}], "}"}]}], "]"}]}]], "Input",\

 CellLabel->"In[31]:=",
 CellID->6221],

Cell["We get the same result again. ", "MathCaption",
 CellID->31680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeneralMiniMaxApproximation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "t"], ",", "t"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "2", ",", "4"}], "}"}], ",", "x", 
   ",", 
   RowBox[{"Derivatives", "\[Rule]", 
    RowBox[{"gderivs", "[", "t", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->20037],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "1.04716016518393`", ",", "1.1813107377565732`", ",", 
     "1.3793050470159398`", ",", "1.6031080469522478`", ",", 
     "1.80714757373683`", ",", "1.9491940550069808`", ",", "2.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2.0823977916379657`"}], "+", 
        RowBox[{"1.2738087749527407`", " ", "x"}], "+", 
        RowBox[{"0.8236002441776232`", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"1.731869303837488`", " ", "x"}], "+", 
        RowBox[{"0.24591757015970903`", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"0.0030965712047703164`", " ", 
         SuperscriptBox["x", "3"]}], "+", 
        RowBox[{"0.000058428236489592907`", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}], ",", 
     RowBox[{"-", "6.746838861625006`*^-8"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{530, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->7268957]
}, Open  ]],

Cell[TextData[{
 "Another situation in which ",
 Cell[BoxData[
  ButtonBox["GeneralMiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
  "InlineFormula"],
 " is useful is when you want to do an approximation and measure its goodness \
of fit using the absolute error instead of the relative error that is used by \
default. If you want to use a different metric for the error, you can specify \
it as the third part of the parametrically defined function. If the function \
is given as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], 
    RowBox[{"(", 
     StyleBox["t", "TI"], ")"}], ",", 
    StyleBox["y", "TI"], 
    RowBox[{"(", 
     StyleBox["t", "TI"], ")"}], ",", 
    StyleBox["g", "TI"], 
    RowBox[{"(", 
     StyleBox["t", "TI"], ")"}]}], "}"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], 
   RowBox[{"(", 
    StyleBox["x", "TI"], ")"}]}]], "InlineFormula"],
 " is the rational minimax approximation to the function that relates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   RowBox[{"(", 
    StyleBox["t", "TI"], ")"}]}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], 
   RowBox[{"(", 
    StyleBox["t", "TI"], ")"}]}]], "InlineFormula"],
 ", then the error that is minimized is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     StyleBox["y", "TI"], 
     RowBox[{"(", 
      StyleBox["t", "TI"], ")"}], "-", 
     StyleBox["h", "TI"], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["x", "TI"], 
       RowBox[{"(", 
        StyleBox["t", "TI"], ")"}]}], ")"}]}], ")"}], "/", 
   StyleBox["g", "TI"], 
   RowBox[{"(", 
    StyleBox["t", "TI"], ")"}]}]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], 
   RowBox[{"(", 
    StyleBox["t", "TI"], ")"}]}]], "InlineFormula"],
 " is not specified, it is taken to be the same as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], 
   RowBox[{"(", 
    StyleBox["t", "TI"], ")"}]}]], "InlineFormula"],
 ", and it is the maximum relative error that is minimized. If you want to \
minimize the absolute error, simply use the constant ",
 Cell[BoxData["1"], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], 
   RowBox[{"(", 
    StyleBox["t", "TI"], ")"}]}]], "InlineFormula"],
 ", which is the default. "
}], "Text",
 CellID->2807],

Cell[TextData[{
 "This gives a rational minimax approximation to the inverse of ",
 Cell[BoxData[
  ButtonBox["Exp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Exp"]], "InlineFormula"],
 " with the maximum absolute error minimized. "
}], "MathCaption",
 CellID->23535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gmma2", "=", 
  RowBox[{"GeneralMiniMaxApproximation", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "t"], ",", "t", ",", "1"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", "2", ",", "4"}], "}"}], ",", 
    "x"}], "]"}]}]], "Input",
 CellLabel->"In[33]:=",
 CellID->23666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "1.0526677905960118`", ",", "1.1981457107165072`", ",", 
     "1.403433639673279`", ",", "1.6253046633781272`", ",", 
     "1.8204578920681977`", ",", "1.9531088438427406`", ",", "2.`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2.0701764032705663`"}], "+", 
        RowBox[{"1.2791576409948977`", " ", "x"}], "+", 
        RowBox[{"0.8066839312039912`", " ", 
         SuperscriptBox["x", "2"]}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"1.710829203148898`", " ", "x"}], "+", 
        RowBox[{"0.24006056468456533`", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        RowBox[{"0.002977183547459611`", " ", 
         SuperscriptBox["x", "3"]}], "+", 
        RowBox[{"0.00005546132273089315`", " ", 
         SuperscriptBox["x", "4"]}]}], ")"}]}], ",", 
     RowBox[{"-", "9.77379378322259`*^-8"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{530, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->381160974]
}, Open  ]],

Cell["This extracts the approximation. ", "MathCaption",
 CellID->1882],

Cell[BoxData[
 RowBox[{
  RowBox[{"log", "=", 
   RowBox[{"gmma2", "\[LeftDoubleBracket]", 
    RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}], ";"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->24049],

Cell[TextData[{
 "Now the ",
 StyleBox["absolute",
  FontSlant->"Italic"],
 " error is equi\[Hyphen]oscillatory. "
}], "MathCaption",
 CellID->3106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"log", "-", 
    RowBox[{"Log", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "\[ExponentialE]", ",", 
     SuperscriptBox["\[ExponentialE]", "2"]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->2594],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->241829124]
}, Open  ]],

Cell[TextData[{
 "If you get an approximation for which the error is unacceptably large, \
there are several things you can do. If you increase the degree of the \
numerator and/or the denominator, the minimax error will usually decrease; it \
cannot increase. Even shifting a degree from the numerator to the denominator \
or vice versa can affect the size of the error. If the interval for which the \
approximation is to be valid is very long, it is probably a good idea to look \
at the asymptotic behavior of the function and choose degrees for the \
numerator and denominator that give the correct asymptotic behavior. For \
example, to get an approximation to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["tan", 
    RowBox[{"-", "1"}]], 
   RowBox[{"(", 
    StyleBox["x", "TI"], ")"}]}]], "InlineFormula"],
 " for large ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", the degrees of the numerator and denominator should be the same, since \
for large ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " the function has a nearly constant value of ",
 Cell[BoxData[
  FractionBox["\[Pi]", "2"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->22070],

Cell["\<\
Another way to decrease the error is to shorten the interval for which the \
approximation is to be valid. Often it is better to have several \
low\[Hyphen]degree approximations to cover a long interval than a single high\
\[Hyphen]degree approximation. The extra storage required is not that much, \
and each of the simpler approximations will evaluate faster. \
\>", "Text",
 CellID->23259],

Cell[TextData[{
 "To get an optimal minimax approximation you need to take into account the \
numerical behavior of the final approximation. It is usually a good idea to \
define the function so that the variable appearing in the approximation has \
values near the origin. Thus, instead of finding a minimax approximation to \
",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " on the interval ",
 Cell[BoxData[
  RowBox[{"999", "\[LessEqual]", 
   StyleBox["x", "TI"], "\[LessEqual]", "1001"}]], "InlineFormula"],
 " it would be better to find a minimax approximation to ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["e", "TI"], 
   RowBox[{
    StyleBox["t", "TI"], "+", "1000"}]]], "InlineFormula"],
 " on the interval ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"-", "1"}], "\[LessEqual]", 
   StyleBox["t", "TI"], "\[LessEqual]", "1"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->30033],

Cell[TextData[{
 "In cases where you want to avoid all potential problems associated with \
loss of digits due to subtractive cancellation, you may even want to do some \
shifting of the variable after the approximation is found. For example, the \
rational minimax approximation of degree ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"7", ",", "7"}], ")"}], TraditionalForm]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["x", "TI"]], TraditionalForm]], "InlineFormula"],
 " on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "\[LessEqual]", 
    StyleBox["x", "TI"], "\[LessEqual]", "1"}], TraditionalForm]], 
  "InlineFormula"],
 " has positive coefficients in the numerator and coefficients with \
alternating signs in the denominator. The relative error in the approximation \
is only about ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"-", "20"}]], TraditionalForm]], "InlineFormula"],
 ", but using the approximation in the given form could result in a larger \
relative error, since a few bits could be lost due to cancellation near the \
endpoints: cancellation occurs in the numerator near ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineFormula"],
 " and in the denominator near ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". By replacing the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " in the numerator by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["s", "TI"], "-", "1"}], TraditionalForm]], "InlineFormula"],
 " and the ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " in the denominator by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "-", 
    StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
 ", all coefficients in both the numerator and the denominator become \
positive, and the values of ",
 Cell[BoxData[
  FormBox[
   StyleBox["s", "TI"], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula"],
 " will be between ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula"],
 "; no cancellation can occur. Of course all of this must be done to much \
higher precision to ensure that the coefficients themselves are correct to \
the required precision. "
}], "Text",
 CellID->22956],

Cell[TextData[{
 "It is very important to also consider the zeros of the function and its \
asymptotic behavior. The simplicity of the resulting minimax approximation is \
",
 StyleBox["greatly",
  FontSlant->"Italic"],
 " affected by the extent to which you can trivially make the function look \
like a constant function. As an example, to find a minimax approximation to \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Gamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Gamma"], "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], ",", " ", 
    StyleBox["x", "TI"], ",", " ", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"]}], "]"}]], "InlineFormula"],
 " on the interval ",
 Cell[BoxData[
  RowBox[{"1", "\[LessEqual]", 
   StyleBox["x", "TI"], "\[LessEqual]", "3"}]], "InlineFormula"],
 ", you can consider the function ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Gamma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Gamma"], "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", " ", 
     StyleBox["x", "TI"], ",", " ", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"]}], "]"}], " ", 
   RowBox[{
    ButtonBox["Exp",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exp"], "[", 
    StyleBox["x", "TI"], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["x", "TI"], " ", "+", " ", 
     RowBox[{"4", "/", "7"}]}], ")"}]}]], "InlineFormula"],
 " (",
 StyleBox["cf.",
  FontSlant->"Italic"],
 " Abramowitz and Stegun, ",
 StyleBox["Handbook of Mathematical Functions",
  FontSlant->"Italic"],
 ", 6.5.31; the 4/7 was chosen empirically). This function only varies a few \
percent over the interval in question; it will be ",
 StyleBox["much",
  FontSlant->"Italic"],
 " easier to find a minimax approximation to this function than to the \
original function. "
}], "Text",
 CellID->19093],

Cell["\<\
If you are attempting to minimize the maximum relative error, and there are \
zeros of the function in the interval in question, you will have to divide \
out the zeros first. If singularities occur in the interval they will have to \
be eliminated also, either by multiplying by a zero or subtracting them away. \
\
\>", "Text",
 CellID->12891]
}, Open  ]],

Cell[CellGroupData[{

Cell["Finding Roots using Interpolation", "Section",
 CellID->26390],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " is useful for finding a root of a function. It is fairly robust and will \
almost always find a root if it is given a sufficiently close starting value \
and the root is simple (or if it is multiple and the option ",
 Cell[BoxData["DampingFactor"], "InlineFormula"],
 " is appropriately set). To achieve this robustness ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " makes compromises and is not particularly conservative about the number of \
function evaluations it uses. There are cases, however, where you know that \
the function is very well behaved, but evaluating it is extremely expensive, \
particularly for very high precision. In such cases ",
 Cell[BoxData[
  ButtonBox["InterpolateRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"]], 
  "InlineFormula"],
 " may be more efficient. "
}], "Text",
 CellID->23712],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpolateRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"]], 
  "InlineFormula"],
 " looks at previous evaluations of the function, say ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["f", "TI"], 
    RowBox[{"(", 
     StyleBox["a", "TI"], ")"}]}], "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["b", "TI"], ",", 
    StyleBox["f", "TI"], 
    RowBox[{"(", 
     StyleBox["b", "TI"], ")"}]}], "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    StyleBox["f", "TI"], 
    RowBox[{"(", 
     StyleBox["c", "TI"], ")"}]}], "}"}]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["d", "TI"], ",", 
    StyleBox["f", "TI"], 
    RowBox[{"(", 
     StyleBox["d", "TI"], ")"}]}], "}"}]], "InlineFormula"],
 " and forms the interpolating polynomial which passes through the points ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["f", "TI"], 
    RowBox[{"(", 
     StyleBox["a", "TI"], ")"}], ",", 
    StyleBox["a", "TI"]}], "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["f", "TI"], 
    RowBox[{"(", 
     StyleBox["b", "TI"], ")"}], ",", 
    StyleBox["b", "TI"]}], "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["f", "TI"], 
    RowBox[{"(", 
     StyleBox["c", "TI"], ")"}], ",", 
    StyleBox["c", "TI"]}], "}"}]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["f", "TI"], 
    RowBox[{"(", 
     StyleBox["d", "TI"], ")"}], ",", 
    StyleBox["d", "TI"]}], "}"}]], "InlineFormula"],
 ". The algorithm gets the next approximation for the root of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " by evaluating the interpolating polynomial at ",
 Cell[BoxData["0"], "InlineFormula"],
 ". It turns out that using all of the previous data is not the best \
strategy. While the convergence rate increases with the use of additional \
data points, the rate is never greater than quadratic. Further, the more data \
points used, the less robust the algorithm becomes. ",
 Cell[BoxData[
  ButtonBox["InterpolateRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"]], 
  "InlineFormula"],
 " uses only the previous four data points since there is almost no benefit \
to using more. "
}], "Text",
 CellID->31332],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["InterpolateRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", "]"}], Cell[TextData[{
     "find a root of the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " near the starting points ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InterpolateRoot",
      BaseStyle->"Link",
      ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"], "[", 
     StyleBox["eqn", "TI"], ",", "{", 
     StyleBox["x", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "}", "]"}], Cell[TextData[{
     "find a root of the equation ",
     Cell[BoxData[
      StyleBox["eqn", "TI"]], "InlineFormula"],
     " near the starting points ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->29852],

Cell[TextData[{
 "Root finding with ",
 StyleBox[ButtonBox["InterpolateRoot",
  BaseStyle->"Link",
  ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"], "MR"],
 ". "
}], "Caption",
 CellID->24409],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    ""},
   {
    ButtonBox["AccuracyGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AccuracyGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the desired accuracy in the root being sought", "TableText"]},
   {
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], "15", Cell[
    "maximum number of function evaluations before giving up", "TableText"]},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], "40", Cell[
    "the maximum precision to use in the arithmetic calculations", 
     "TableText"]},
   {Cell[TextData[{
     StyleBox["ShowProgress", "MR"],
     " "
    }]], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to print intermediate results and other information as the algorithm \
progresses\
\>", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->22313],

Cell[TextData[{
 "Options for ",
 StyleBox[ButtonBox["InterpolateRoot",
  BaseStyle->"Link",
  ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"], "MR"],
 StyleBox[".", "MR"]
}], "Caption",
 CellID->15126],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " choice for ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " means that the ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " will be chosen to be ",
 Cell[BoxData["20"], "InlineFormula"],
 " digits less than the ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 ". It should be noted that ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " as used in ",
 Cell[BoxData[
  ButtonBox["InterpolateRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"]], 
  "InlineFormula"],
 " is different from ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " is a much more general function that works for systems of equations. \
Trying to justify an accuracy in the value of the root itself is too \
difficult. ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " merely stops when the value of the function is sufficiently small. ",
 Cell[BoxData[
  ButtonBox["InterpolateRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"]], 
  "InlineFormula"],
 " is much more specialized. It only works for a single function of a single \
variable at simple roots and assumes that the function is very well behaved. \
In such cases it is quite easy to justify an accuracy in the value of the \
root itself. "
}], "Text",
 CellID->4836],

Cell[TextData[{
 "Set up a function whose root we wish to find, with a counter ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " to determine the number of evaluations. "
}], "MathCaption",
 CellID->24879],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "?", "NumberQ"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "++"}], ";", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], "-", "2"}]}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29532],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to find ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", "2", "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->30262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "0"}], ";", 
  RowBox[{"FindRoot", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "800"}], ",", 
    RowBox[{"AccuracyGoal", "\[Rule]", "795"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "0.693147180559945309417232121458176568075500134360255254120680009493393621\
969694715605863326996418687542001481020570685733685520235758130557032670751635\
075961930727570828371435190307038623891673471123350115364497955239120475172681\
574932065155524734139525882950453007095326366642654104239157814952043740430385\
500801944170641671518644712839968171784546957026271631064546150257207402481637\
773389638550695260668341137273873722928956493547025762652098859693201965058554\
764703306793654432547632744951250406069438147104689946506220167720424524529612\
687946546193165174681392672504103802546259656869144192871608293803172714367782\
654877566485085674077648451464439940461422603193096735402574446070308096085047\
486638523138181676751438667476647890881437141985494231519973548803751658612753\
529166100071053558249879414729509292973882031`800."}], "}"}]], "Output",
 ImageSize->{585, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22571795]
}, Open  ]],

Cell["\<\
Here is the number of function evaluations to get the result. \
\>", "MathCaption",
 CellID->29830],

Cell[CellGroupData[{

Cell[BoxData["n"], "Input",
 CellLabel->"In[4]:=",
 CellID->18638],

Cell[BoxData["16"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->87936410]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolateRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"], "MR"]], 
  "InlineFormula"],
 " requires fewer function evaluations to get the same result. "
}], "MathCaption",
 CellID->10790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "0"}], ";", 
  RowBox[{"InterpolateRoot", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "800"}], ",", 
    RowBox[{"AccuracyGoal", "\[Rule]", "795"}]}], "]"}], ";", "n"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->12398],

Cell[BoxData["13"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->409403821]
}, Open  ]],

Cell["\<\
You can observe how the approximations converge to the root. \
\>", "MathCaption",
 CellID->18462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterpolateRoot", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "x"], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ShowProgress", "\[Rule]", "True"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "40"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->20446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0.58197670686932642438500200510901155855`20.954589770191003"}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->192777718],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20.954589770191003`", ",", "0", ",", 
   RowBox[{
   "-", "0.12246396352039524099846310239210750572`19.976047975799403"}]}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->145948546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", 
   "0.7019353037882764014443370764723386735105371836014051284533`41.\
021139875759246"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->26741411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "20.954589770191003`", ",", "20.06655010556824`", ",", 
   "0.0130121629575404389120930392357057520880042512`30."}], "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->20403865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", 
   "0.6932065772065263165289985793726367988579177096082928094744`41.\
021139875759246"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->140062285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "20.954589770191003`", ",", "20.06655010556824`", ",", 
   "0.000062480788747713548804773112636400519915488182`30."}], "}"}]], "Print",\

 CellLabel->"During evaluation of In[6]:=",
 CellID->30109011],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6", ",", 
   "0.6931471932603933841618726058237298702382541087571278295653`41.\
06655010556824"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->156793321],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "21", ",", "20.06655010556824`", ",", 
   "1.2644348369358488803846038760130247574333`30.*^-8"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->187726003],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "12", ",", 
   "0.693147180559945119457822446955902592223035705048596912974127511037665983\
47698`60.06655010556823"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->307537352],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40", ",", "20.06655010556824`", ",", 
   RowBox[{"-", "1.899537670481520869100141495998121913971535`30.*^-16"}]}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->76376051],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "24", ",", 
   "0.693147180559945309417232121457862571571181173372490767437846871819737444\
89757`60.06655010556823"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->388113195]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "0.69314718055994530941723212145786257157`23.84082546104514"}], 
  "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->304833906]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Approximating Integrals with Interpolating Functions in the Integrand\
\>", "Section",
 CellID->9848],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " uses algorithms that assume that the integrand is smooth to at least \
several orders. ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects typically do not satisfy this assumption; they are continuous, but \
only piecewise smooth. The algorithms used by ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " converge very slowly when applied to ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects, especially in several dimensions. ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " allows the domain of integration to be broken up into several pieces and \
the integral evaluated over each piece. If the pieces of the domain \
correspond to the pieces over which the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " is smooth, ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " will converge much more rapidly. ",
 Cell[BoxData[
  ButtonBox["NIntegrateInterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/NIntegrateInterpolatingFunction"]], 
  "InlineFormula"],
 " automatically breaks up the domain of integration. "
}], "Text",
 CellID->10908],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     RowBox[{
      ButtonBox["NIntegrateInterpolatingFunction",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/NIntegrateInterpolatingFunction"], 
      "[", 
      StyleBox["expr", "TI"], ",", "{", 
      StyleBox["x", "TI"], ",", 
      StyleBox["xmin", "TI"], ",", 
      StyleBox["xmax", "TI"], "}", "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find a numerical approximation to an integral with ",
     ButtonBox["InterpolatingFunction",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InterpolatingFunction"],
     " objects in the integrand"
    }], "TableText"]},
   {
    RowBox[{
     StyleBox[
      ButtonBox["NIntegrateInterpolatingFunction",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/NIntegrateInterpolatingFunction"],
      GridElementStyleOptions -> {ColumnAlignments -> Left}], 
     StyleBox["[",
      GridElementStyleOptions -> {ColumnAlignments -> Left}], 
     RowBox[{
      StyleBox[
       StyleBox["expr", "TI"],
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox[",",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      RowBox[{
       StyleBox["{",
        GridElementStyleOptions -> {ColumnAlignments -> Left}], 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["xmin", "TI"], ",", 
        StyleBox["xmax", "TI"]}], 
       StyleBox["}",
        GridElementStyleOptions -> {ColumnAlignments -> Left}]}], 
      StyleBox[",",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      RowBox[{
       StyleBox["{",
        GridElementStyleOptions -> {ColumnAlignments -> Left}], 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        StyleBox["ymin", "TI"], ",", 
        StyleBox["ymax", "TI"]}], 
       StyleBox["}",
        GridElementStyleOptions -> {ColumnAlignments -> Left}]}], 
      StyleBox[",",
       GridElementStyleOptions -> {ColumnAlignments -> Left}], 
      StyleBox[
       StyleBox["\[Ellipsis]", "TR"],
       GridElementStyleOptions -> {ColumnAlignments -> Left}]}], 
     StyleBox["]",
      GridElementStyleOptions -> {ColumnAlignments -> Left}]}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find a numerical approximation to a multidimensional integral with ",
     Cell[BoxData[
      ButtonBox["InterpolatingFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
     " objects in the integrand"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->26405],

Cell[TextData[{
 "Numerical approximations to integrals with ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " objects in the integrand. "
}], "Caption",
 CellID->14561],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrateInterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/NIntegrateInterpolatingFunction"]], 
  "InlineFormula"],
 " uses the function ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ", but it breaks up the domain into sections where the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object is smooth. "
}], "Text",
 CellID->18199],

Cell[TextData[{
 "This creates an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object approximating an oscillatory function in two dimensions. "
}], "MathCaption",
 CellID->17698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sin", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"x", " ", "y"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "4", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "0", ",", "4", ",", "0.5"}], "}"}]}], "]"}], ",", 
     "1"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4570],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "4.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "4.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23998489]
}, Open  ]],

Cell["\<\
This list gives the time used to evaluate the integral plus the result of the \
integral. \
\>", "MathCaption",
 CellID->25366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrateInterpolatingFunction", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"sin", "[", 
      RowBox[{
       SuperscriptBox["y", "2"], ",", 
       SuperscriptBox["x", "2"]}], "]"}], "2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.125`", " ", "Second"}], ",", "1.223322754741601`"}], 
  "}"}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->182106621]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " produces almost exactly the same result, but takes much longer because the \
convergence is poor if the domain is not properly broken up. "
}], "MathCaption",
 CellID->15085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"sin", "[", 
      RowBox[{
       SuperscriptBox["y", "2"], ",", 
       SuperscriptBox["x", "2"]}], "]"}], "2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2904],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"slwcon\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Numerical integration converging \
too slowly; suspect one of the following: singularity, value of the \
integration being 0, highly oscillatory integrand, or insufficient \
WorkingPrecision.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/NIntegrate/slwcon\\\"]\\)\"\>"}]], "Message",\
 "MSG",
 CellLabel->"During evaluation of In[4]:=",
 CellID->340929016],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3.937`", " ", "Second"}], ",", "1.2233225062829973`"}], 
  "}"}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->621059398]
}, Open  ]],

Cell[TextData[{
 "If you simply need to find the integral of an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object (as opposed to a function of one), it is better to use ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " because this gives you the result which is exact for the polynomial \
approximation used in the ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object. "
}], "Text",
 CellID->23778]
}, Open  ]],

Cell[CellGroupData[{

Cell["Order Star Plots", "Section",
 CellID->30001],

Cell["\<\
Analysis of the stability of numerical methods for solving differential \
equations is a considerably more difficult task than finding the order of \
approximation. This difficulty is reflected in the fact that there are many \
different ways of defining stability. This package assists in the \
determination of stability regions for numerical methods. \
\>", "Text",
 CellID->16129],

Cell["\<\
Stability regions are important because they reflect the rate at which errors \
are propagated in the approximate solution. Just as there are absolute and \
relative errors in numerical analysis, there are also absolute and relative \
measures of stability. This package renders order stars, which are useful in \
examining the relative stability of a method. Furthermore, by specifying the \
comparison function to be identically 1, you can also draw regions of \
absolute stability. \
\>", "Text",
 CellID->5944],

Cell["\<\
A given numerical method for a problem can be recast into the framework of \
approximation theory. The goal is then to study how well this approximant \
behaves when compared with the solution. There is a kind of paradox here, for \
if the solution were known then you would have no need to resort to a \
numerical approximation. However, you want to establish a framework which \
applies to any problem in a given class. Since generically analytic solutions \
to problems cannot be found, it is common to study how a numerical method \
behaves when it is applied to a linearized system. In the area of ordinary \
differential equations, for example, you might be interested in solutions to \
the system of equations: \
\>", "Text",
 CellID->21520],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox["y", "\[Prime]"], "(", "t", ")"}], "=", 
   RowBox[{"f", "(", 
    RowBox[{
     RowBox[{"y", "(", "t", ")"}], ",", "t"}], ")"}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->22981],

Cell[TextData[{
 "for a generally nonlinear ",
 Cell[BoxData[
  StyleBox["f", "TBI"]], "InlineFormula"],
 ". It is common to replace this system by a scalar linear problem that you \
can solve, namely, "
}], "Text",
 CellID->11740],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]"], "(", "t", ")"}], "=", 
    RowBox[{"\[Lambda]", " ", 
     RowBox[{"y", "(", "t", ")"}]}]}], ",", "  ", 
   RowBox[{
    RowBox[{"y", "(", 
     SubscriptBox["t", "0"], ")"}], "=", 
    SubscriptBox["y", "0"], " "}]}], TraditionalForm]], "DisplayMath",
 CellID->29732],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  StyleBox["\[Lambda]", "TR"]], "InlineFormula"],
 " is considered to be a complex constant and you have fixed an initial \
condition so that the equation is uniquely determined. Stability analysis is \
now a study of how well a numerical solution behaves when applied to the \
simplified differential equation (",
 ButtonBox["1",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/tutorial/FunctionApproximations#29732"],
 "). Equation (",
 ButtonBox["1",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/tutorial/FunctionApproximations#29732"],
 ") is often referred to as the scalar linear test problem, or Dahlquist\
\[CloseCurlyQuote]s equation. "
}], "Text",
 CellID->17177],

Cell["\<\
The discussion which follows concentrates on how to use the package. You \
should keep in mind that although the focus is on the behavior of an \
approximant, our underlying interest is in the numerical method from which \
the approximant arose when applied to some problem. For more information on \
this correspondence, stability analysis, and the theory of order stars, see \
the references at the end of this section. \
\>", "Text",
 CellID->29825],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["OrderStarPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"], "[", 
     StyleBox["r", "TI"], ",", 
     StyleBox["f", "TI"], "]"}], Cell[TextData[{
     "draw the order star depicting the region where ",
     Cell[BoxData[
      RowBox[{"\[VerticalSeparator]", 
       RowBox[{
        StyleBox["r", "TI"], "/", 
        StyleBox["f", "TI"]}], "\[VerticalSeparator]", 
       RowBox[{"<", "1"}]}]], "InlineFormula"],
     ", for the functions ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["OrderStarPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"], "[", 
     StyleBox["r", "TI"], ",", 
     StyleBox["f", "TI"], ",", 
     StyleBox["z", "TI"], "]"}], Cell[TextData[{
     "draw the region in the complex ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     "\[Hyphen]plane where ",
     Cell[BoxData[
      RowBox[{"\[VerticalSeparator]", 
       RowBox[{
        StyleBox["r", "TI"], "/", 
        StyleBox["f", "TI"]}], "\[VerticalSeparator]", 
       RowBox[{"<", "1"}]}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are functions of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["OrderStarPlot",
      BaseStyle->"Link",
      ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"], "[", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["f", "TI"], ",", 
      RowBox[{
       ButtonBox["OrderStarKind",
        BaseStyle->"Link",
        ButtonData->"paclet:FunctionApproximations/ref/OrderStarKind"], "->", 
       "Second"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "draw the order star depicting the region where ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        ButtonBox["Re",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Re"], 
        RowBox[{"(", 
         RowBox[{
          StyleBox["r", "TI"], "-", 
          StyleBox["f", "TI"]}], ")"}]}], "<", "0"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->14944],

Cell["Drawing order stars. ", "Caption",
 CellID->31662],

Cell["\<\
Pad\[EAcute] approximations are rational polynomial approximants where all \
parameters are chosen to maximize order at some local expansion point. \
Certain numerical methods such as Runge\[Hyphen]Kutta methods are related to \
Pad\[EAcute] approximants to the exponential.\
\>", "Text",
 CellID->23409],

Cell[TextData[{
 "This constructs a Pad\[EAcute] approximant to ",
 Cell[BoxData[
  RowBox[{"exp", 
   RowBox[{"(", 
    StyleBox["z", "TI"], ")"}]}]], "InlineFormula"],
 ". The function for doing this is loaded automatically. This approximant \
corresponds to the forward Euler method. "
}], "MathCaption",
 CellID->14843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"approx", "=", 
  RowBox[{"PadeApproximant", "[", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "z"], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9592],

Cell[BoxData[
 RowBox[{"1", "+", "z"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1369676568]
}, Open  ]],

Cell["\<\
This is the relative stability region, or order star of the first kind, for \
the forward Euler method. The pole of the approximant is highlighted. \
\>", "MathCaption",
 CellID->862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderStarPlot", "[", 
  RowBox[{"approx", ",", 
   SuperscriptBox["\[ExponentialE]", "z"]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7933],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxk3Xn8p1VZ/3EQckFTM/Sn5IahuZeJpqbelqXmluESmRCRLW64pOaCG+GG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    "], {{
      {GrayLevel[1.], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxMnXd80LXz/wsd0L0otKWluxVaEFpAEVAU98KFIIoiQ1mK4setuFFUEJQl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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtnHfcz9X7xz8ZZd26b+77tu59W589bqTQkqhItEuREZKRyMosIysllVVJ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          "],
          VertexColors->None]}]}, 
      {GrayLevel[0.5], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxMnXWc10UTx393cAXXXRx3BxfSZQGKSYiEgIpiB7aIolIqIIqAiYGFKCKN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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtnXfcz9X7xz82Zd3cg9yb+OyptEgUyYzIymjIlpQyQklG0qBSEi2jUPKt
jIRKQpuEoqlBaagQ8nu+ev3+uB73OZ/rnOtc57zP+7yvc6275NoRnYeXDQQC
HSoGAuX5uzUeCMSigcCenEDgi/xAIBwKBJ5NUS8KBO6oFggsiwQCb6cDgRxw
hbR5g7ajM4FAdim/Ae/S/yBwEvznwEj6Jqm3pzwfGu9QjtDnM/ru5befKKdo
0xncVcDr1EdBrya0soDNtL8eHhbQfg/tbwc/gPb303ZXSSCwivrLQNValIEU
bXfT5yfRps334BK070j5SmAZ9eXAC7mBwJO0f5q2V1E/k/o6+pyd4Ddo7KGe
LGBu9L0VGET9m7xA4LtwINCaNZiXHQisof1d8HonkGJtiuF3MvhzWZ/HiwOB
Poy3EdpjwNcBVxfYRP1ALBCoQd961FtAO0b9Ksa6kfZngf+T35rT/3hNxqA+
kv5VaVsN+BH6N8LjUNq/Do3j4BrA7yDG/wv8R7SflDEvpcA4ymOBJbnmYSLl
CcC31Dszxh/BQKAxfb5ifZdUDQR2Ur4H/Nm0bQQ0hPaT8PMJvI1ijK8YPwt+
B7AWqxl/CetXhTb/ws8mPXPm/gLta2RBn+fzG/TOod6d/j2BN2m/FvpDob2L
9qsov8FvZaoHAv347W3KB4C/we0G/qD/efTvRd9rgE3gXqPPQNp+Cn659hfj
T4e3A+CfA/8scBH1NczxAPy+zXq9AX9raV+HvnWBJ+BtCWN20v6gXgiuMu2n
UL4b+J3yNaxPTsrPUM+usfYc9N7UmlJfzP75grXYF/PeOMUa5jL/POAyxjuX
3ybQ/w7gIM/yedbkeXgrYf/cxP45i/Z/wHs2/BXT/uFC9ie0lwOz6Xsd+Czw
lZOBQFlwrzL+GfS9nPGeBb8EmoOgNxB4nPK+OoHAvbQ/RPvytO1An4nw3gZ6
u5nvXmA6+J9ED3w78G/x/DeCH818ypTjPaN9HegPhX4Qnvoz31J+2wAv01mj
08ylAfwOYrx2rE+Utv9CYwrrdTd9VkG/CvPvCe4gv71E35UCyhHohem/TTwx
/uVAAbS+h0ZNaDcCv5T+Afp3oP99wE+UDwI1KX/Ceq8GH6XPubQdCf9ToZfD
b5freeuMYi1uhueFrHVPrS9zO8ia3c56f8sca4PPBq6t4z63gr8OfqLwV0vv
B7jvoHc/tB+Hpxas1Vx+W0a5Gb81Z+yfwJ/PXFvBQ1nq5YBW9L+fNXmXtXie
+Zyv84UD9XF4nwecpG9/3q/3GOtaIAx+P9AK+mOg9xB7Ma3zDX5u0J4Elws/
Yxl7CPOZx3zyGHMI9T8Z4wfGniqe6N8UuAD6FwJTWI/3oLcQXv4CbmHul8DP
o/T9gPajtV+g9xj0avDbS4y3EljA3niNb8AK8Mt1flPeAH47uBepJ+D9bvgp
S70ccCPtT/JbD+jnQ38kbVtQX0nbl4AmlH+px7yYS3XwfcA3gOf5rEWSPndq
/0PjBcpv8Vs2vBXwvIbB/1BgLs/yMaAqYy0GOjL2T+CfCfmM1tm8lzV6nr6L
gSPQC0LvGHObQP0Q+6VxbfYAfXsBzaA1l/a3gosz5lHW6mvaLIPXF+Le+6fg
8SvWdgv8dmB/DGAO0+C/E/2/hva3wCv6HtF/PeP9yPzas/btgDbQuwII0fdX
aJRhPhOhF4ffpRG/63ez366mXI82I8A1hX4z5noRMFnvOzwuhL8FwAXs9XzG
K2Ku+5jTcfBR5lwMLyXAU+AehGYYWr8xXlnGm0SbCvByH/AEvBzm+c+E9r1A
D/itQfvrKa9iDm0Y+17GG6r9yG8zKG+H5mc63xhzPWO9Cs3W0DofnmfQ/0lg
IX0XxH321ajL94K2O4DzwW2jzw/wUgJPY+FlImOcBe4RxpiZ6zPrQurfsibD
WfsWtD/IeJv5bQPl9Yz3LnO7jf5lWP9JPPMP4G1N3Hs3iz6bqb8NtGcuc3P8
LfwJGhXr+JtYEdxO1u9y5tIVfIKxfoDeT7n+RtQF/xhzep71OZ85Lwr5ndS7
uBFoz/j50KvH+7EPGmWoB4BDzKUT9Y9Yi4+g3yXXPNwI7ipoLKd+CvxpcP8C
U2jfi/rnjLc35W9Rffh/gPKDwGbG/ofn0yPpb7y+7T3gqUpj6tCbCa6oPvNm
vA+BXvAznjOiIrQrAd2LPachzP8Z5rebvTiC+f+l8xv8SPDNoHk/Y83S95Pn
UxN+r4T2PdD7Ptsy0CBwA4EFjDeXMW6k/8XMaTO8bwHOpn4YekMoTwQuAdcc
mFbTbb4GP5t6dX1beb43Qutn9sDsqpbRHtL5zpjNwD8Efw9S/4b6RdQfpD6c
+nzqQeq3UB+s/UK9lPpw6jdQ3x/2uzmYelPG+pLf9lJ+i/Fvoj5cMgRzqcJ8
T8LrCWAwc70d/HhwdwBtWY86zO8laL1B/7X0X84YrVi7S7UG8DoYaEO5Lb8t
Y7ydPI85tA3QpwNtH6XPIuoPgt/Kfrtdc6Lcl/05TrIQ+HngS2l/reRd6tez
PrsZf26pvzFroL9a76TOMupPU94Av03gNVfvM+2fpP3ltL+L3+6Hfmfoj4De
09CbpbOJ+mDqC6lvoX0QGpfCeysgRLkJ65end5f6V+DPhaemtG0CzZ6SlXj+
B7P9TZ7DWN9E/ezyaLOB/svhJ8zYf9HmcfoWMZ++0HsC/AnwJ4HWrGdL3qft
UX/T9S2/AthHPUOfC2mbYbzb2N+3A5NZy/Y608EVQq8P9ObRZjb1g/p+U3+E
eh3qdYG74G0XeywNr19A/3F4uRv4lPpO5v81a9UNuID6noi/9atp/wXjz5I8
zthp4D7qedC7VLJYrmXbHfzWsNQy7lvUh7Gmh8GPo76Dsf4Hvrzkdeb4KeU1
MZ/1beF/JuULGL87/D4Gv1eHLNNKln0R+m/CS7WUz6bGwDHKx4GW0LqE9doF
vfXQ+Bl67Yp8dkim/U+Wpf+X4B+Ap3MY/1zJmPTdxPM4n+dRF3qPg6tM/1bg
LgUagD8b2FXoO9CtzPUW4E7WIgXNvdC7jz7VKJ/JHM8D9wVjDoaf5vA/JOM5
iPcy0KsHrfn0aQpvFwF9OY++o15I31gD9hD9P6P9DMZrRv/9PNsvgSPUu/HO
n+LdD8LfhDw/w8a0/4j2d4O/iPZVqJ+RMC/PwuMmxvuQ+V3K/Noyv/Phpye/
TWDsN/itP+Mf1h2R9knGf0trBf4s+B/AeVhN3/aoZYOtjFcKrlhzoHwJNKbA
y326EzD/KTpf4OUz8Pn0H0L/spTfZ/yWjHUZNAZBbwX0ltH/PaAQ/JM6E4ss
QzxOOQaNw7SfAz7MXD7kt58pHwaO6u4FvifP+jfW83lwN/Db0lzfwWpQvpjf
DjLWdupB+j8f8l0sDX8h6i9R70o9U+C9WJzwt197Mpv+OTpPGH8x/J8D7mPa
Tyn0O94Kfi9LWXbRmdaatpVokw3uU/rcw1pMBa7k/PqA9R8m+Y4xVsDLB8BO
3s2PeZ4/Qu8p9tMkaE0EDtF2OefnF6zVvrTv1lOZw8e6GwJ58FsO/kbwvMpC
4yfaL+N5lTD2EfDNwHfkt4uoH4DfBM+zpeQFaP0IXAJv+cynPbgN8Lcj32t2
h87qkGXjSbT/h3JLfmtPuTs0Lme8B6J+t7/nezkD3I8889q0n0GbA+C6Un+V
tp3geazugjHLphPAf8fYB4A+jH8F83ladyd93+H3ADS7sD7ToXEr5aIC7wW9
I3o3tCcOsd93Qe+iuv7mdYKfCtQX6V2AnzGMd7vkG9buSXj6Avr7gN9Y3460
GSJdA/SKGG8E879aug9+ewXaP8NTX3D9Gvvdu4ffcqHdjPXpBa3+1E/R9lLo
d4C3a5hjJc6fp4CqkvWgNwncVvocY7530eZe6H/GHCrTNsLzKq/nx3xbMVYn
+nxJ2/slj7B/KzNGfspjaiydCU0lDzD+etbjB9r3gf41QG/2yn5o9pc8yPP/
mfIAxotQfyXku/Q51CdQvxv8AmjfSX0O9OZF/S71pc9UxvpI5zv4+8B3k3wF
3A7+IDzOY24nWL+N4CvmWDafSv9vSiyjV6F+PvXvwL2e67mmdObkec736Dxi
jFOsxz363jBW04T3YoI17sla9AC68bxeh+eV8HoSaM63ZwVjbqftNuBz6M/n
mS9K+YzW2Txc30tofwvNI7R9G5rraDuR/k9Qf436Qtaiud5P1vIG9sDdzOVn
ftvOu9GPNezP2P2AqeyNzYxfBlxv6I2l/xDGOMT8TrLnzuT5vM/zew58Q8ZI
QXuQ3tmUZQrJEjfCzxm0PxNIFHlNpAuRDku6K+lE+tG2f8p7q3EFxgN3G/Xn
qN/G+JN0vjPG6/C3mjV5I2UZQbKB7nDbdd9MWXdyH/U/9G2H/030PcV8NlPu
Sv8zqTfl+TzC+jzEfJYw/mo9X8rHmc+vzHc0v70Of/Og8TzlNeBf0bsLDOLZ
XQL9ilo/6g9TH8F8XmLslSnfHUeDT4Errzsi6zODNtfCf39gAGtzI/BewjoJ
6SLeATbq/GS8/2ls6rfxrn2S8F3mxrN5T9lvRbR/Hfrt4X8H89khHUG+7xg7
wL/D+JWYX2vq5zL+mYyfYfxZjL+e9otok51jnd9QeBnHeCtYy7f47bDulhE/
q108z/qMdQk8fMTZEYBGJ+nWaFOBei3e59d194x4rbNZ3zx9q2n/Tn3LlBvg
/X/Qf4mx1jGHR+HnQvAbwB8C35S+k9PWLd0PjcPU70lZd3IF/P9KPch4z+t7
DGykbRQecossg7SGdlfm/3ot30k+ATeWOd3D2g5gDepGvGe1V2+Afhb9b4b+
QvrfCH49uLvoP1/yPn36hX3m6qy9F3qb4fca3XfYD3/wjn5MvR/10VX9ztZg
LufQpyVtk8wpQv1W8MdYq3upfw+t26gHGO809O+nvAQeSgqtI2jB+H/Rphr4
+vzWkvoZcctKDaifl7bOWrrqefB7AfXW8PAMz3IB9SOU50CzHc+iiD4DKX/N
/j0Kb5ug3xx6FaEXB1csfQD8DafN87SfDH9H4f0sfutCOVGbb4hkw5R1v1MZ
oxn9y0sHr7OX/hN0PvBMX+X9u5d6L+pngb8Y/DX65tP+D347g/71qPeGvzrQ
bw/9b+DnYvB/gq8Kvkj6RcbPA98WfHPWrAXtW/BbF9bzccYvZb6Vqf/GeHcw
37up3wMcpfxgtnVP7dhzFXKtg4pDa0LEsu0caE5mrLuALfSvznjfgzsgmwHz
H8QYj8D7o0A5zs6y7KEr4O8U+62s1gYa/2OsV9I+e6+jz0H4qyUbQ4ltDvtp
uytoXdVS3pcntJeAqtBrBb0junvRfwv9K7K++1jbqvDYEPqbwC8BvxZ+wuzP
3cznb+p1wXcC35D2P7HW4+F/qnhnfmNpOx4ea9F3B+27Qvsq4A94Xc0Yr1F+
JmLdypnw9yr0ZvNbdfhtTp/vofeDdB7QmgjNc3X/h96wGnxniqxrlE5EuhDp
HHtCqwH83Fzf39TF1JtQf5n6JMZswlpcSn0P9bW8E2+xPr1o05Xyb+zBDZQ3
AnG938C+kGX+/2R9+D0EbxWhMRD+BgBvSTaPWzYZy/gvhCyTShYdRr0u7X/j
t49qWqdwU9p7WHt3P/X90oXS/hLaz6T92xHbbGSruZDxF0tW0Ttd6m92X9b2
Sfr0g94E9kMnaF1PmwbMdbC+L/SvAFzBWkfp/wvjnQm/Q+F1MPANz/9Hnv9k
5rtK95XG1vlJ19eNNfkX+qeBpfBSQTaFkO+IuhsmqFeOWEaSbKRv/Db6toH+
XsYbBQ/lwZWLuG1b8F3AtWKMr6FdJddn0RPwVLfEZ1JvxopIn6a5MeZX8PcO
bZrD+3LtT52HwO88u0r8No21mCV5nvbjkMFfDVlGkmw0Qvps6pUYrx7jvQQP
v0r3DQ83Md7wEn9rtuh7W+xvTim0l6Vs+9hJ/c2U71S6S5Ut9l45j/7dc7xn
XtNZIp2L3sV8362apGyb0R3rFuYzKmndsO7wu6D/KfP7Pt80Xob/VcBinS3S
qTPf7bRpDe4V5nsgY5uSbEnrpL9L+w6iu4fueKOkn4Veozzr6E9T/1dnEmtf
B+hG+6vTfreag380ZJudbHVX8Qw/gfZ2oFGu9/jj4JumrDvtz/odom1j3Q/h
PcgYh2OWKSVL1su37kcynWQ56YB2Ja1jk27tF+mEM9ZhSnf5Evz/Cv3aCcv+
s8HfCW/H6d+E/fZrsc+KHfqGFPrM2AP+94h1hR2BHyhfxDN4k7V/lzFOZKwT
li74BPR/p/5TxLLLV9Jxw2uW7hsl1om/Jnsgv5XkW+YujpiG+o5hPX6VLS9i
2fNzftvP+H9R7yb9JzAE/taFbJuQzuUN8I1kcyqyzulu2j6Ztq75B3j6mPLH
PJ9v8n0neCxqG6Nsiw8w/lfgj0Ws2+wpeUCyIe0/pv0DPI9t4D6gvjnHe+LD
kHUAuvtLB6Sz/mTEumud+R+wlrOoT+L5TgSKoV9B9wf4PcTznwnuOb1v9P2V
OZ4ZsQ1Mtq/HwX/G2lwBjx2zrQMfGPM3Rd+S73j+70p/GPNd5k14GKVvBfhz
wN8nnQjPpgZrVAX6O1mTl6E9FPwj0DsbHr+H3yNBn7VvyGYZsg5Euo/p9Pkf
7Ufx21zaN5Q8Sn2Q7DnUG1DfBe+fAmNzfKfbmLKOV7rd+2tZlzIu7ndROpUB
tN0LjQ3M78Ni605uA/9QvnUoBRHLwJJ9h8qGQvtT8PN3geewBNwA5jOY8lBg
lfRZKdvqZQMbQv/XoHeCb8Xb1P9H31UJr6XG2EL5F51XlDcVWDd/SDrTfOvo
32O89+m/P986k6OyT+ibxdz+KPC3aknEvOmbtZBnUz9lW6J0MqPAv6s7MLxl
6PMp/d8L+u7xIs/r9ZT3pPbiCfDTGW8G8E+xv7m6O99M/cti36FLoXcl7Uvp
P7S+baldM74ryqb6kL7X0slRrwqcgvcVzGcTY1UFfyVtayWsC9Ed8je9v2mf
tdLhvCxdNf1nMZ/ngNERy5ySNf9hzUbRNsJvf+rsh6drqPcGxrFfNlC/St87
YAX4zsB2cNtkn8iyzqORzirdwXOtw+1AuaPkZdqeQZv34S2o7xPyzZYC63KG
hWxLkE5Hurdb0h5bOrirJevFrAvoTj2X9jm6kzO/cYzRFfxf4Ovz/LqArw+t
Y9rj7O2BzPdmyv0Y72zaVue3ZdIN0CZUYp1wmHqK9WsKb1MZcwq413RnkO6E
9blCvgqMN4uzbg/t75IuA3wj8AvB38DaZcHDmYU+g77jeZwCPxv8HNnPpa9i
/Kd1tpfYF6BjyGe3fAL2U98X91kqnb/Oqg/A31DsM+tD6qPpf1WudQj/+YJo
v+fbJ2Qk/Ie0vwu9h3TXmMtvOSW+cwynPAL4AlwT1uPLuG3wsr3/Rv8azK26
3pEs+4TEeFbxlM+CetJp0TcLfGPe7UXQuAteJgMDcv1NqgzuNurdZB/WM2I9
4jyPQsbKacA9gHpO0rKz7lzfxC3TSZaTTkHv5ldx86J39D7Gu0IyE/yXB06A
u5A1fJPyGYx3Xsg2AdkCsgotiw9MW1aQTB6UPZbnuUi2Y8n49H8sbNuH7ujb
ddeDRl9w+3SGghsnnQa0V1GfELaOQ7qNefnW7YxijG3Z1vHMiPsbqm/n09Tv
DVsHI93Lc9RTtB2Ttmx0F31mi3/a16H9UvC9KE8Cf5jxg9V9Vz8d8V7RnX2B
bDOs38o82+g3hK3jk27vZeqN0/+v06D/Y8C10Ptd572+fzofw74z6678Iu37
6D4CPg98BvzMuH005JshHfJ54Jqofy3PcRr46Vozxr8K/kZINmbMhxhrNjBc
3xL4Pam7YaHv5qeAFtm+o6doewf1beAepX0N5jKf5zdfd2No3h/2nVR30Uv4
bTXlZyO25VWlf5mEbZqyZdaQvg18hj5LaDudPt3g9SQ0G9H2an57EfxtkjnZ
H1HguM7WtG1l8iG6TbJR0r4rz7HHe0p+iNo22lPfb8b6N2XfD9nUXtJZB70Y
5ViJfQe2yieq1D4ET8LruezpFzkvO7E+NSQ7pH02SkfUg/GGp2zrn0l9sGyN
wK5i+1TpW/Om7gvF/uacqfMtad1fV9mwpK+kvgDexnHGLZRtHBind6cs70TC
OgfpGrKk8wG3RT5QpbaB14afvmnr2nRn/Fv3G+kspHtljAoJ35F0N6ol+x+4
+yKWRXSGrI/7zq27tmQg6YakE5EuRDqi16WriPldXyp5nL6rIpYtypZYdjgj
bF8vyRDS9ZRlvR/Lts6nUL4xrF+a8hO1LDtPTPquJRl6PPw0lj1P9mDZfOWf
JR0J7dvx/L7V+a93SmdngW2nIeqt821DvVW6KumAsm1j+wja7XkeI1m/0dxP
2skWrXeoxD5a0n1koL+ovnUgf+r+JplAvlLMaZxknbRtddL5jY3Zx06+df/Z
6HWXhkbvbMtYurs+rDOzxHfYoWnfyXUX3633R7ZPyaN1rJOYov2KvNCj1DqJ
W0KWwSR7ac0uB/+ufORYqzf1vYlYZyRdkXTwI+UfBByo4zvtGPj7hDn/xHqW
47fOEcsUkiXOknyWtIwq2VTf+OtpP0U2SOazK8+yRXPoXZNvGaMl9XvhIVDi
NWtGuSlQQP9yrOk08Jug1536s8DD0C9ivOsYbw38nsvz/wd6VeQPUeK7YwH4
3vV9h+wi2Vb3M2gl4OcHym11ZlWzzqudvhXS4ej8l48I5QfS1qXotzvBXyD7
MH33MV6E/mGgEfUg8DFruxUYD6098NA24m+Mvi0Vge7U68PPCPjpBv//o+8e
6VRZ23dlAwxZ5ytdb7LQd6V82veo7zuTdL37I353pfPtGrGMJtlMOpMVEd/p
dZfXnvwjbZuvbL26A19J/Rv5qNSyD+Z1IesMpCuQjCZbZTJlX0/ZLFuA+y7m
s/Jffe9pfzu/fSJdMfwdjfsOqbtjJea7NWEbh2wbb1E/lrCMK9n2SIGfjXT4
0t3rGTWRvjlj34jyPIPj4I/JR6imdf5/0jYqe5Z8ZfjtT9neotYlyOf0D+q/
x617OM2Yl0o2gP/b4b+MZHrKX0R8FknG/kHvAzSXUD+u85/1DwDHxVuB7+q7
wW/N8Z1duor+EftaSWfRnPLKiO8mJ4stG43I2HdCMlKezlbW9xfp73imv4K/
h/qvtA8U2NczG55SRfb5/BH8SH57Afw/9D+X/lfx272sb2PZfKO+g+nu9S/4
ERHrRKUL1Z3/Mtavdcq+F0/xvNbC7xzqtWQ/h98aIdvEZAsrU+i7VXXth2zf
sSZGrIOU7vEW6L1M/x/pX4b+cfqcE/EZqbNRPmFbmcv51J+kvKLY36YFEevC
9Y3aL1/AlH0Vauk+QttHqdeG3jnQey5iHaN0izrDmlCfSJtfii2j6N26gvkP
zPc7pndFPl/y9dI7I92efObkKycd3+30HZ227HNA33hw38asSzxFfSq4iyPW
vcqmd0nKOmPpimVDejpim4tsLVoT6XJrSedT3zrdjnp/wj5rLofeCzyL2fIX
4qy7Szp4eL0V+LGOfXq2h+yjJN8k+QTJlt+eMZ7Ntk1/Hu/v48CX3Ley+L4/
RnkusLyCf9NeGRSxLlx75lFwjwDjKrjNbMoPAXmU2wAPU54TdFltvmG8x2J+
986Av6ng7gEOlWP7lQcXss+TfJ10h8mVfT3uudzJmqbYf2ngb8afy5yn03da
0H07AvdSnhF0+U5ga8Q6RekS5SN1lLH/lg8f52U2a9IB+i+GfVetKBslffsA
g3gd5gH9KfcLuvw+EIVWOON3ebn8d8DNAlYx1gHgPsozgx5bv02hfDewppzn
+CDlB4JuqzVazFyXAHcwvxt5npPgpx30vyixz+gw2g7VGpZBtgEmU74LmFrO
NDtQrguMqMQeBNpTzgXOoLyb53cr5VuA3shKs8qa9p1R+75pjDWyvyfsC/s0
49dkrXfyDFbI/4t6nYhlAH37r2f9PolYByjdX99s69afl44k2zr2MYx1O3Af
Y20A/m3Ee0W9J+VewDjKY4PG/Q5MpDwBqM9cugK12ZsX6owvsk3zRnADgBRz
vw4YQnkwcG0Zr8kNlK8HTgfcZgTl4UGv1TH1Udugn53ajKJ8MxAu6zW5k/Kk
oMfWmt6hb2PQvImn6nGfUTqbGut+Ce6moGmLxr8x2xxlawyBP0H9H+BPnl1d
9tcT9B0KflSBZfQ29K0FtODZ1ATaUs4GFlG+BWhHOSfoZ6ffLqecFXTb/eyX
1ioHXV4GNKVcETgIr6uBuHhjzfvDXwIIUv+D+kDmfi5wIfXyeudoexVwBeXa
QY8tnlpRrhE07bHAZZSrB12+HGhGuRKQX95jNqL8G/SbQBt0YCP1N/TMqvB+
AvUpNwBuoJwGWlKuqj1K4++gcQHlckHzUgpcSrla0GOpTQvZwoNu+zJwMeXK
QIfy5qE55Sp6huX92yXa+0G31W8XUa4Q9NpozjHKf8NvkrX5V+8z9b8aufwe
EKH+ZyOXHw/YNtA5al8O2Qh6gO+uNQd3HtBLezvo8mDgFc6mrlHHEujOtyVi
nbN0zfLRlWw4L+67tWTEA0HbFGRLkE5pD/ibY9a9rwR/Ne9DN+it4l0dW2Tf
DfnEyBdGPhxJ+vbgt1flu6z7huwZ8oGjPLembRXvxX23l81iAeM9CbTU2QCk
KP/DfDezHrOBJPXjjVzWHgpTP9LIa6E9lKZ+gvrRMu6zhPpiPSPOm2ZAE8oB
7QHejZnAeZTLaI+U9W+NKZ9q5LMgVNZnw+lGbqszIkP9ZCPjNMb51MsGvTdE
Q7qsamHbTqTTkm54e9iygXTE01K2ccu2/XqRYw+2Ru1LrhiEopjvULo73cb3
roT3c13a3375uH4N/ivgM9ZuVJZ9jT6O2vdLPkcR6TrpM76aYxyu5lk0ok07
xRc0YI2i1kFK96gYAfleX5eyL7Z8sDsyl7OApyr5zC6C1pq0ZSH58A2SPzbw
PXtnuGJCIpbRJZtLxzaG8nzNP88yrmTvF/ltWrZl8Acl+4L/Mc/fyCbQfl13
nELHLCmW4BLwLxQ6pmBE1Hdo3Z3bwO+j9P9SNps86zRWR3zn0F1DOsDv4P0C
5vtgnmMi+kifKP0i+Kdy7RsfyfjbKB/53fJN0p6lfTnV9azg+TBrtYJnthd8
lZh9vSqA76pnrT3EWfFBZc4FyiVBl58AOlGuB+yo5DXsFvQZo7NFfa7U2aR3
vrLb1Ga+9XSfl/8kMBZexkTtm6gYiSvjvnPpriUf3Kv1bQIereIzS2fZeiBT
xWfa1yH7OMu3WXfudfC+NmbbtGIGOtO2AGhS2TzcwVjjJWPUtE1OsToTotad
KmZHuswa8kfMsU5zEeW/4fdqcE9Tryh9SMS2q9PyF4T2Kp030B4CLJX9Rvdt
2j9L+w7S9yUtG63keX8m/Rb4K2X/gd/PJf9oPas6RqYL5eKg13YwMEC8weO8
UseorAT3ks67yh5zasQ6OOne5GP+KfR2SqZjfsOZ3xlp+wzKV1AxQrJ1/kr7
z2vZ5vmrfOOS1sUd5B3aJn1ByLEsTwL1aNs241ims6B3BNyUpHWJ0nFLt3p5
xrGB0rEqlmBAwnd7xRTsTvlOqLugfO5q0z4bKJdjHgKsx1OSMaE1lnqjhH2c
5dssH6v5KfsEyRdIMXFVZE8IWfcknWBb6vcx5oIC3wFqyfYCfzuhH6V9Ten7
qX9CPVJkX4zlYds25ZPxDGM9BYTkK5ZrX5Hl0pFm22dkt2wH9J9M/3bw8HvK
MYWKJWyq+1zQNlnZYuVDVhl+lodsK7wH/nalfMfQ3UI+sLItfih//lLbGCtI
lua30QX2Qdmjb7WeabZ9lpek7OMp385qrP9G2u6lTTPGalXHsT/PQK9dqWOA
NsXswynfzV/p3zJjny75cm3T/pbumPp6aI2jzciodW7StenMnMHYb7M+X+XZ
Z1261nay8RRY59oNXs6O+WyqAU+3yncRWJrjGI0d0u/E7Pv0kHyS6Ts5YV30
HsbMhvZNOiMbOGZRupayEduepXOpxHiT6X9bgX16ftPdIGZd3FH4uVC+M7SZ
km2bjnzvS1L2PZYP/lngR0LzJejXBf8hfT8AvpSvU7Z9M/tGrPuRj2Za9/2g
fam7yOeK+v6gY8d6U3+R8gpgZyW/c8sliwFPV/JvL1B+XjJoJf/2GLQPw0PV
Ot7jIyP2gZHvy7vZthUu1n4vtM2wUcQ2HdlytOfqR2zDke1GMrzW6jt4WpDt
NZNt+8eIfTdk4x5P+Xnob2St90ifRX1CyLFD+gbpbK+cti1NZ3xJ1D5o8j1b
D3/lo44hVOygYn4fjtpHVL6h0xTDKtsO9O+WbVw+DVHb2GRbk49nN3CHgz4r
RsLTyqRjohQLtZk2HWQ7oM1zeb7ThuWLmnAsRWPa16C+lGeyj2dRgfr51J9K
OPaiNfV/mPu8kO/SioEYpvsZ7evVsQwvX0PFZCgWQz6Hf9N+Lu0vLXYMQGfw
XZJeG/m8zAmZZ/HaCR6HJR1zoFiD0fS/ifruhHVrY4D5lFux35Yx3pOMN5r1
rBa3r+IAoArzex96i6HViTGWJxwjqtjQ5Xq/ko5BUOzBeOkn4L0rNKryLMaw
JhvhZ3jSY8+uaVnxFtrvLLHMmJGtUfoc+J3LfI6mrMOX7l5znMxYd8f8LsvH
b3bUMYCK/VOM6AnazgV2SL6AvyngakLvAsU2gu/E2FcmvTeLWJ9/aPuwfNLl
m5dtX7oOScfayaculnDMsmKVFRN6QcIx5Yoll0+SfFlvBxYV2af14oRjihVL
rBhd2Wpugv6cYttsFoZ9Zumsks+XdEXyAZTvn3RG18Qd86NYH/nkSjf9IjRX
FFhH/UbIz0TP4iHWL0D9tHSI8jXme1Zd/j1Jf6sVoyzftU0J+57Khy0hWQz4
lvlF5LPKfN+Ap8/yfAbH4T1NPV7kGP3rwK+mvl26qmzr/ofR5r0s2wBGB33H
191ed27pIj9I2JYsneT/mEsTfuuW75iRF6g3pt4539/A3kHfYXR3kc7jhL7/
MctqT3MmlUKrfsJ3W+k8BwZ9J9ddXHfwKO0T8Bcrcsy/dNVx5nddvnXWM+l7
HzCA+tlZ9m3uEXdslXycHwb3iM576lVlc6Y8LeG7tmSKNrJvQq8f9SO0r6iz
m/G+yLEPWb5sdyG/W8dqWjc2OOKzXzoyncVTEo4N0Zl8KmYbumznikk7I2Yb
mmxnPVjj41Hb0GU7b0P9GOUh0Lyd96c1vx2mPkg6vwa2weXGbUOT7Uwxb2PY
i9fAX4Nq3pM/gxtI+6sa2AZ7I/Xekp8KfSan6N896djA/2LQqK9P2DdaPpSK
VZ2YsC+9YlZzYo7hU+yefKarypYPvU9zrDOuTr0h9V051tnmUn404Vim2tLv
yJaWsi/Mfz5NjHdnwrEDihnpkbEMoG+/YmDmRu1DIN+BWby/5WQLBf9+kX3c
qkPvDOpnU68MvU6SVRnzYKF9yJ6F3+rUO+Y7hvEi6F8AZHJtw96i85f37+ds
23SOgKsdcuzZAd757dKvxOzL8nmWv8WNk7Y96Jv8Z9Q5GZSLQWdMF/lGsN71
We9Vigmh3pt6cQP7kMiXOJq0LUQ+xe9R3gZcz9hf6wyifU/a12vgmIR28jfS
GVjgmMEXaXst+GYN7JMzGl4vS9p2K58I+U63TNoWLB/q3foWJO2LPAl+G+o+
AL+hIvtQ7QX3edK2aMXgvit7oOSdUvscN4s5RlmxycoZIN+J7xnjzxz7UByJ
2kdRvomKWR+Vso1atmn5ZIdp+x3P96sCx+DVjdtmKFuhYjYbRW3jl21fNoVf
ovZBlu+xYngCCccQK3a4On3GJywTShaUj8AIyn0kozVwjN0rQd9RdDeZD7xG
+dWgyx8C3SUrxB17XMx6XU15DP2zGiJXUl9H27XSGVTxnes5ys8Ceypax6C7
VWHQdxXdsZYGrYOQ7kEy0VOUFwat21gMPCPZKeiyaEg3mhe0rlQ60ovYe28x
38+Y70LWbI10RUHzKh4+UvxAwrkvlNNhXURKIvZDbfsY3xGxz7V8reVjekfI
PsXyJa7N8/8R2h2TtjWW4XnM110raN26dDBbwe3T8yi0z1QL9v+QqGXnrSW2
NcqmLFuybI6SNb+S/3q2Zc6r6duXZ9Cf/dKP53Fp2jbppcxlCfAO/NyctCyg
HBJByl8Dp6ifDTwQd8yGYjUWM8cVaftUy5daPgRtIs5JolwkTzDmt+C+AbbW
sk+AbMUPR6yrks24JfQKoJ8N7R2ysSUcU65YcsWc3yX/7KR9N7fqfY44Rlyx
4Uuh/7fehaRj06qzXmsZa13KvmL/AA2TvvPoriOf/5Kk73S6y8mHUHeN1TF/
K3XnaC9ZSzqOAvu01wLXGZ7LsXYzpR+k7+Ckc00cBX895RuSjrX5Fh5/pu8j
GccqRKgnYvbpkS+PcsgoV8Z1SceeKGdGw5h1QtIFKUZcvkd9mGNuiX2QzgHf
A3ydBo45axDzHUd3mztoP4z2wYh9r+WjJNvr3oRlKdlgf4CfhzP2BS+Fn13g
PktYdlLMSQB6HaB3rL5j1AaztmOY4885zjExRt+epGXlF6Tfp1w3ad8h+agt
ojyUNmvkiwK8H3PMuWLN5VOYn7DPqHxFG7KmLeW7S/t0kc+kM2PW6UiX0xv+
QrInJq17kc4sRvlA0rEbIeAa2n4Uti/nNqBizDF2iq3rQn0Q69EgYl8B+YzI
FndexL65sslNS9vmKVunfAhvkC087dgU+Sz0g9/B0BwF/zcohkq+Q5IJqA+j
/kLaPpvy1ZQPXKnO6qRjLcZLhqd8dtKxFROol6NvR/g7AX8dpSNj/u2p/0W9
LfXqigUFOpU6BjQX2hnqq6XPkPwb951Ddw3J2JIF26etq5FMuE/xpXHHwi7W
nT3sd0rvUlGWY2P66U6f5xiZLzKOcVNs23Olzn2xNO1cGcqBobO1O/h36viM
VazQexHHQipm6ATrcTJhX/397N+foHdP1LL6O6XWRV6QtC+VdJLyVWwlHVWO
fRb/O7sS9iXQGSZfi6fizsUjn4vB0BuaceyxYlCfijkHgGL/P2M/LaK+WWd2
OdYKHn+O2EdVvqmKudRdTTkElDtAdzbJFm2TlsUkY+hutkX6wHK+o30NvhNr
PqrIMa5HwSVpMz3PPno76bsjaV8l6UAVWyUbo2yLirHKYe2y037Xhxdbloum
natGMp2etWRkycZ65ord+QVYkOUYHsVGzo5Yd6AYyaNaq5Bj3Q/Q5lHW4l9+
a8F6NC+1L/DnEdve5BN8jLYtoNemwDrTD5P22ZGvzpWy14P7DXgqyzF7o5jb
F2HnxlpL+0fgNRzx3q3FHnhD9zvajGesm5VzgLWZnHKsr3ywx1Iel3LuIsX0
6ls+POazUd/0x6AXjXjv6wxTrqdfo45tUc4n5fb6MWpdhnJ8bWK8kTHH2o8p
te71G2BYjnWw5ZhL+aTPHvkgKPfJPxH7lisHyqf0X6g51XUMrHJD/R61bkQ5
ouqEfWbrrM7Jci6tv6SPKXZOrWWiDayv6TV6Tue5ZOAsx+go9npg0rr1rsU+
6w4mHAukM28auKlJ58LSne5Y0O+E3gXlCJkBbnrSudLkk/FA0j7Z8sWWT690
852g17PAOvqZ8h2n/yWltjkf0vdRZ3Spc6jpLrM54lga3WlWhhwjrthw5QB5
gLbPJRw7qXdYsm3nmGOrJOMuTToGaAht1zP+VeCeClv2UEx0Wfl2pR1b1KHY
vrS30ufOQvvUvgNuC9CQtU3LH47ynxHHfisn1PfQ6pz2t1/ffOmmFYOg2APp
qM/l2VRSjokc52xYFrKPqnxTu0B/pr7XPJ/6Rc5Z04G2HTP2zZAP7U3MbRk8
j6hpneRNccdIKjbyXvmwST/Mb+fw/F6hzblh36F1d1YM0OykfTrky6GcO82l
b8g4VlPfvGppx2QqFlM+rtKFK4ZDsRvSiX9JOYc+40ocU1EYdc4r5bpSTKh8
txIRy+7y4Zqju3vUvsDKibRB55v0hzzPW4H34Tedtu7keuB++SZmnOsuuwZn
K/3/Df3/WcucBrM2Q1LOzaKcTutpOyjmd3VkqWNdFQOi2A/FvOruWDZpXyDd
IcuGHGOq2FL5GFcN+06mu5h8JuWb3lXfjEL7qC/U3Tds25ZysMzXXTds3f3b
yk8RcQyyYo+vy7YtqW/C307ZlGQbUs4W5WqRjWizYrdjzuUjn8s+sn3y21rZ
30p8FiunnHLJ6Uy+Svo12t9V1z7AyoWhHCbKXaKcGJJdysT8bZUM05axpoYd
uyid8LW0Xxx1bhXJmEXwX5y07UM6eJ2dx0O+u+sMrQcuP2lbinTysqX+zX6q
WGCb6n74+VI2vWL7nD0m/7yov+U6o8cknaNLubmUg+FSaP/CbxXl2856nw2u
ITCLd7Mf58MVOruBcVnO+SRZoSzz+b26ZQblAhwad24v5QS8nLbFMevmlFMp
rvcjal8UyazHwB2P+dsoGk+ALx+zbKQcIbL9vh11LgvZgNtDbwbrNV+6Uvpf
Qds5cfta6w6r2Lo07ffnOMZuT8gxvIrdfa/IZ9cTYcdq6Axrx9r8EXMsrHxG
rwT/DPi9rEVv+dvqbhWzr4O+wa2lL4DHRfCyBDibcoOMcx/oty70Xxp27rFr
6F8ErjDjXB3KedUhYZ8x+YopJjcke4F8Vkqcw6yNdINJx/7LRiJdxNyUeZdO
4gntr5T3rmKyT6UtY0u21jveU/7CYft2Xsv4V+s+kPBcRtC/G/UXGa8Xa3tT
kX1zz6P9ZVn20e1N214J+0buVT4E2j4bte1TNp2usneELcv2pd6DenegHe0/
4bd6tD9LfXKco1C62dKYdYnS0Q4LWwaX7L1W8jG0N0edu2Md7dsyn3Zp34UU
o1GfZ9tA/nh1HHP6gOKJMs7VeVYN5y6ZnHGuSOUw2Zh0TjnlklNOGelqJZNL
FpfOdhtt74g5F9xkxTdKf5xyrgO9s6/R9lVgVZa/IRsov5G0bCof0yWUn0/6
WySZaAvld5LW/SmH2jTo7446N0UI+Iu1+Tvh2HDlSJBu5XTQulTpWD5lPouT
Xgv5JJVhrmXjjq2UDbMe5Xz56FPvQ32N1g74X5Zj1muzVrXSvisN1h7X2ZZx
rIB0qLr7v5m0bkk6gLd1VoQde6+YqD/g7UjCvvKKeVauUeUcUa4R5RyVbX2d
ZOQs29jXU54V9tmunHjSbevOrbu2dNyybSxLWFcvG0ch88uH3roc5wyTb+Ts
lH2r5CPZV99KoGepbeyKpWmY8bulmBrlBjkZ8l1LOUJaUT+Xei60OxU4l8qJ
kHWbyqnSM2qfEfmKvAZ0ZqwrU86dpz69KG8LOrehcvSkM/ahle+s7jA3Uh4Q
t+1APobXgO+dse1LMlse/XtFfddRDtHm0o0lnSv2mRzfFS9MW9eiO6N8YZWD
UbkX5RMrX8xHgP7Z9snsnrIPjHxf5PMv3cfXQLjYOhDZqg4AiWLbrGQLG5jw
3U42Mfk63x+3bkM+z8od9V8Oq1LnkPqEcjztXA7KCTqH/f5SwrKHfMifhbdn
gHk1LUOeEXXMsmKVlTNNsdZb4s51q5jrUsolce9FvZOKbd4Wd65dxThLF/p0
zHcf6UTHhhxjodgKzSlI20Zxv7v6pvzM3O4OOZdpE/AHJb+HnBuoMfUKUcd8
K9ZbORsLJV/GLWvonXiF+faP+exRzp0fQs7ZplxtyjFwOuQcaMp9phy+cfrG
4tb1KqdWFej/Frevss4s6cInhayrk078QMLfQH37pGMcHLUOS7or5Tj8MeSc
msqlqZgE+bZ3Dlm3Ix936a5epn3fUuuwdkcck6lYTO2BQyHnEFPuMMVgK7ZT
OT+V61MxnufHHWOt2Grl7LpQ3+qw7waKwZFsdm3CuWoko50Tdwy8Yt9lc/hN
71vIuYskI0k33Szj3HPSUR8G/0vKspFkhptivuPobqMcsd9JHkzaNiGdmmw1
+gbo7JfNRroGnak6S6VzGEB5YMa5BJWDaqRsS7S5paZt0JOZ/2Nx566TjCFb
n3Ti0oXL5pcTdg4k5T6STecTcB9nnJtWOT1iEefA/LrYOUll+z8Sca5e+QBc
HLePhXwrlAO2Ztg5WpWbVTahP1L2OZCvQTPgvLhtCLIdKEfOTsUuxZwbRzl1
k4z1eciyuWxsii08L+PcXooxLAg7J5xywSmGYjx926b8bVUMkWwjkqkkS8lG
oty100LWlSqHrWRJfQP17ZNM+Qx98yOOnVXOauWm3hB1LlXlqFYuvvflw1bB
OfmK4tapSJcSrsieijuHrnLnyue2StI5HJS7QTl4lZtUMrxkd+UofVzfyqTv
3sop+aRsYbqDZNkHpF3cNmbZlnVH+Rx8KuOzVd/I1nHnPFauY9nAvgB/Tsay
sb5RuvssjzkWVHegWox1KOFcIIqh/DBsnaR0kYqhvg5aHcLOtfEhz7xAd5Go
c43pG6LchFkp+6IoR6FsyZfF7Qsom3ID8E8kbFu+Hnz9sHMaKpehbHbt446h
UOyEchD2kz9G2L7JusP3iTvHsHILKydiL9m/4o59UM5E6dp0h9HdRTq3r2QP
ijs2QDkb68Bbk4xjX+rnOvf12qhjUZUDW7lblLNFuVqUw0WxfNuTts0opu97
9luHkHMf9IfGRMor044F0DdAtrnLQvYtko1OsQI/pJxbWDEDeXHrzKQr0x5R
LuUZIcfuKKfykJjvdLrLKWeycq8oZ4tytSgHi3THtWPmXTrkQ9JFpuyroBhw
2QaUw0S5S2QjUKxE07BzTShmQrlalENGuWOUs0W+YWcmnJtRPmLKjb4+6lzF
ypGu3Iw1UvYlUo7G4rBzNipXo2yiyjV8Z9i5m5RzWLkT8iL21VYOBflyfRD0
3pdPV5L2P8ft+6gcVzp7+8Scm1tnsHIvVQjZF0M5mO5I22YjW81BxRfQ/qKY
fW3kM/AgY18ac24rxcxOCTumRLEkykmsXKt1Y/Z1Us7Vd5lLuahzwVUu9l1l
WMS+MrqzXEzbE0HHMs+h/jbl52L21ZeOcGPcOZOUK0kxWooVUx+1VczY5qR1
YtKF6Y6yDn7XZJy7TDnJ1zHedeCXZVsmXw3u1YxleeUcXwz+oaRtEYrpmsVY
88BfVmqfbuU6uUT+LcXOeVKO+bwbcW5B3akejjumVbGsynE1S9/mkGNHFcP7
LfzelnYsSBfpC1LOgZtV7BzYFSh/HHGuNuVsvznkGBzF3shHsBL4nRHnvpXO
ZXrYdz7d9RQj+z5rG0s7N5ZywF9GuVXatiDdYRRrOSJpX5N+/PYV9TuTtsVI
ZzYr6TNGZ4tiVFcknCNcucHlA/Eu7aslbWuXTPQw67Ey4VwLijGRrfXKmG2v
srnq7qacp8p1qjucYm/7hhw7pBjcntAeHLcvi+7MC2h/YcqxscqRKt3em1Hn
fpSOT76nWkOtnXxQpVvaFbdvo3RMU+l/fsyx3coB2obyI2HH8iuH8TuU3086
dlA2X9liGsec61o2mZhs1XH7pkimly9RvYRtHfIpkm34v5iwarYRS7dcHLVv
k3TM8sVUDg3lzpBPpnIT1Q07N61yFP0l/RrQvppjUJULrEHUsrFygmlvtUg7
tlx7bFHGOaeVa1o5smtLlxh17LxyRD6rsyzjXKLy0bsh5JhhxQorZ6NyRb0S
dq4i5Yz6vZFjAhQLIJ992e4/S9vXUDZ82aYVs6xYZdmopasMpZ0LQDpL5Va4
K+LYQuVYWJJxjmrlppbN4+2MY3QVmyuds3KlKQeKcp8oZ9pNIce4KbZNPnzK
hfJTyrKscqIo9uN4wrF4igHZmXLOVuVqVU5Q2cZL0s5dJRu5fNGkU5AuQT5p
Z4G/P+PcsPJR7C79adi5Z2SzUK6pQynL0so59WjUOT2Vy1M5rCvFnINVuVf1
zisWrnLIsUqKiTvayDEWiq1QDEEZ8G9FnAtWPhcB6psi1qXKJ0O+jafjtp3L
x1F3Od3RdDfTnW469RkZ34WVg72b/NfS/jbrjJJvkHQW0lXIR6i8bLspx+4p
Z2c56oVp51LR/yCQ7kI6DekypMP4Nu2cScqV1Jf53h5yjLhiw6XzOjPlb6q+
pdIBLwDfL2nfOOVwki+SYs6nF9snaS31bgnbmmWDOirf6bhtG/KZz6M+PWXf
e+1xybYvxuzbIxn3VNQ2ENk+pBOX75ByFCg3gXyIJFu1iTv2SDLWN2kFaZh3
5fD8CNofpuw7Lp8RxRb3jtjWoRjj/wNfv8+S
          "],
          VertexColors->None]}]}}, {{}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[CompressedData["
1:eJwV2nf8l9MbBvBPiBJKJCXaikpbUUpZUSTSIE0NtCfFz6xQyZYdEcpKQ0S2
UpGVFikZyaiQFfV7X39cr+uc+9zjnOfzPOfc5/5+K/cect7gIoVCYVGJQmHA
MYXC28cVCqvqFwqfwacwr3ahUKluoVARvjy2UPinVqHwb8NC4Qy6r9J9DbrV
KRQOb1QozDfekd4CfGeDQuECunfgjvhkekeS32f8KNxK//J64vKzF9neMFis
r/j+pmahcCKfm/EY9lfAaKjPz5V4O/sHtYvAkeLuhRuRdTLWGc5P7MSFudBG
jJvxLXATnEx/DjRl+wK+1PhB+HexD9d+TPtX/rrTLal9Eb4YusF35lTfPL/F
G+m/Z3yFtSyHV9keSGegdY1jPxd/bl2r4U36n9P/h/xuqGlsE3wN38BmOJP9
Mbg1X5Xo3J/njkv6HUpBeWNHQAV4whzamv9M/Ic5bBB3J/4KlyH7D1fzDDvR
qY6Hkp0q/hC8D7+viXW9ODfAjcZHk72EF0Jvfqqz64MXin9BxvDFxj7CA/BZ
7P/j7186u6CSdmU4EirCUVAFHjOPy+iuNv/PoRXdzezLkb1kbIb+ZPJJcEvW
qb8ENrH93jOrTPcQczlV3DbmUUm/KlxAVgW/zs9x5IvxaLIDrWcM/oTsYv66
513W/hTOpH8PP+2178WjxalFdxSu7ZnWgmPhdVgMP9GfRLcy3VPy/pKdIE5v
c3vSc3yZ74XwEvzJR1myk/g7DPel34HdbPZ38tNfvx+8yb4u2Rt4MH+DYFV8
0VltvfPpXMLXIv1XYAzdl/O+kz8U+9jCx2R76O2Gb8j/w0fnu+SrKq4O1aAG
zPCcLxdvrXmugdax4bs82UJjj+tPJb8VpsDB+u/D12y3mFMDPg+1rtPE3Nv4
UmN74Q/YroAPxH+LryHWMhTWmN88vBavg7f4WM3XLvbToI6xb+E7GMPX97ht
fkd8Kl9V6TzArgo+WJzScJSxilAJnjKfdubzNP6b/UZz+CvvDN4Du+Fo6+tM
pwYeTu808Yfhovy+LdaN4oyHK/WvgFfp9eWjJJvG4vbM88+eYqwz9NB/kY/u
eC5ezLYdP5PFOoXdJHwqngsn8PEiHmi8NN5J/wjtJ7R/47M33UO0e+Be0BO2
ekYNze8HvJn+cuPL4ENx3mF7tLGr2NanezWe7zlcQFbGs3kDX8lmHIyF2fqX
4Fl5D/HZ7F/nZ752L/Ofh3vjrtbVBRbx10e/Rp4bdBL3ruwfee+MPwSnsz8N
3uVrX/0RfJ/Oz0g8GzdnPws3w5/CJ3AvNPMsVvD3HpsP8t7x+y18DQW2m/N7
WcsemAbHi1kXfwhnGzsH6mnXhwZwGx/1+bwdf0K3B7894TKxXhP/Urw488Lv
4OnwKHT1nLpAZ+iUPdNadsIv+j/DQ3yfn/Xi8/Aq9p/BRL5vgpJ0D4KS1t+Z
v1J5h7Knmd8q+NF8tunfQX44/x35eIbds3ApuwGwxFg9/ffwcHGG5Xyg+5o4
a/3u/fINW1t/vJj9hdmn8SXGx5O9wce5bHeLv1feabJ96I8km6c9Au9P/4/s
w9rl6fxuTjvhLe1ycKCxFviA7GEwE47hf5v4tbRrw7HQhs6v4u2AZXyemd8Z
Xy3OM7isuM/izuRvw73iPYOfhQ7aE+jVpTMRv05vbPbo7Ncwh88XYIY45fWn
4i/Y3Yq/xA3pNoCRns8IGJ3nx8eLZP3jK+87FNffH9ZrT2a7Dk/J+SP+y36T
V+Aua78zvwscmncGvqXzq/U2yvdjjm34LGr84zxP/Am7jwNxP+RrVOYAL8EC
WC9mfT4uZF8v7xZ+B7rApfrP4X54APSHjny8yddL2gthAfS17m78XJT9XPwu
Ylc1l874CGMHZu9KHiXeBv5qm9cY7StgJX+N2H2Ex/B7BczTn5t3jU0JPvaH
NvzcqV+e/J78RvCn2JWy77M5WHu7de6AbVAqv3neZ7afGW+svy+d4/F++Ey+
9st5anzfMN1PA7qf8Dk2eQ+8DAvhC3EbZ89k3whfjN+FbjBI/3l8GR4Il0Nn
Pt7i6xXtRfAy9LOG7jnLs2/nmxC7mmfTFVcwdpB2TfK7kkPxV8e8joOr823x
1yT5Fx7H71X5DZKfJtfMu5w9FUroj8N3ifc1vgNvwncmp2G7yBpfhXv5vQfu
hjLir4Hv6PzmXWqS/MpcmuLV5J/DKvHWsK9B9j/xFolzDb6O/G/4C6qQVYU9
1rIbVmi/QH8OXJi8lZ96/N6C38mZz6ZAZ6Dx3ubRBy6BuXkH4D3zWQLvwhX8
LcVjcD82m9lfmb3Zs3mU7rf675B/g8/g/3TokL1ZfwOfX8EV5vA82Rj8HP6S
7ADzKUenmv58/avEuBr+094Ne6Aav33E6Q29YIn51iQ/Gmokl4X3yA43Vg6a
Jvcla4Ir4ypQCaYnn8GPRNfcO4pdFrc0/yPMoa241xg7E/8Pn4UPEHs0P6cl
n4Cp9Jqa6zB+6rHbY+wuOoWcp/pd6HTNe8t+GPtX8HDcEzfNmYlPyPfO/iJY
5vd+TH8pnmUulxo/w7wGJO/m7zl+r/csr4MTxTqLrC1MofuwuMdkP9X/WrsU
/ozOVO1V+MnkhMZn4oF4K/kPcJX+p9nfxSml/Yh5lNAumTuBtVWA8vAf3efz
3I3tMb8XtAvs9pDvzlmmPxEOyj4n9tHGHs75B9vNt6I1tGR7VPacvJN8/Gyt
d+a7gIPIOiTPznnLz63mOAHv5ucf/nfBv9nXcjaTP0zePfPFPXH16PFX0vjT
fAxOfpG7RPI14wfg//RPjR9cQn8dFId/9E9JjDyH3G3o/4sf1B9IPgie0l+S
XCrfAn5S/zrYFXu4le4D4u+nfT8uFnu8D94XzrW2ongH2wI+R78I3mPte+P2
uW/iKfz8hf+Ga2EmvJtcOfkafkL/GvgT/oDJ9KflG8k+jHfj+3IfxP/C2fzu
wmvproG/tP9i09qa/sZ/619gvTuN3ad/OfkM7cezB3qWj+FH4bLs9can0+1C
/gjujDcZ2wg3G/8zd5C8j+R/JhdKzkJeDm7X/ynztIaa9M/O3c7czklOSP8I
OhXgvuTeuWNkf+SrtPbf3r9/kovDv7ALNrL72Xhz+kvZbeDzq5z5+m34vS3n
Pqw0NgWXxX/g49jUgUfoTssekOctxoF537Tv53ci3o+PbWSH5I4C08gbk92H
f8ldNWci/I+fZdmn8PKcPdmbrfFm7VvgJljDfhJejeuzeT93puRyeY+Tb+cO
jLcnp8g+Rec37V9hB7yZugD/VYy9Zu0zzeFB8gfgfjgs93P4MfdmsbtmX8i3
nufO7iL9C5OXsj+R/u+4dnKQ5M5QMzl38r7kGvSfyHkAu+Flfh/HQ/Ax1j8Y
n5McGtpl/4X34Oe8i3nW0IbvM/K+5iyA9uL9kpw393z9lTBarJJ59/kcbnwL
2bDUbPQPIj9azCLm+rZ4S635LXygfpGc9fidjMFH5B8ZH5UcFIqwH8rP9/wN
wQX9A8ir81fIs8ydgf4SOCB7HXyX+0ByhIzDSv0P4Yx8z/n+ja0nXwfz+XqC
78fhn+x3eVfwvtljcj7njoFX5twT83H2Z6TWQf8UY4Pp35O6knndm9/NWN+8
v3iU5/MMvdnwtt/xjeQvyW2Ty6R+Qq9Xag7J39g24OMOvD15NhwFpZIr5Nyl
1wSfZh2n5w6ZXCP1hvxOuJjxMflWcp4nr7S2/vCTuK+S/Zi6Ur4R+Cm1E/o/
505sbl8lx7OOYtZTPPdtY99nPPuTft+sG8/I8xF3aepXqS/hu2NnjnfhTvR+
YfONeMtyp4Xx5rACl0p9R/ty6EfvUjwASpIvN36b9u25v2tXMP8WfB6Jj8h7
xV/LnCn4aXgqdw/r2J56QWpMxpbz+Zt1rMDXWNdx7P+HW2af4fdv+AOm8f8n
7kpvMB4EA1OjIG9At2H2ImvfBOfydwK9R7WninNecmh+O+Dz4yd3QHwZ2R/a
DeEz+h+nZofP5XdjahNsS+QulLzAXA/DDa2hAfzJ1/18nETWAppDrawpdSi4
kN1ldIaSD4Hi1vRB1sr2EHbXpmaaPdTYv/BP9hHy9snP6X1Ibwd/N9F7M/WS
1GDwuOQKuVPk3PQcX8w3QPcJuB2+Ms/b8EZ8fPLz1JL4vdLaxqYmm9pC7tPJ
FfW35J5B/2T6pfCn+S7NZUnqQLA3+ffmtAXez28Oy+DEnElsm+Hz+WnEfydx
3k1tFr/Pdpz2WGjA5xf6o8gbandNrpl7kOf/F/v/0WmsfxVuhK/GXZK38Lva
+Fu5G8D0nBfweWTmOtQzeDN1H/w2HoSH5D6R/RGPhtL5/fUPwT2SYyYHzZ0n
ZzNf08U5OXVLaAmnpH4GdegPzPOC3z3ndtmX+Tkbt835xb597iP4HPy8OY0w
vtRzGI7fx19mP8nzZ/8+TOXrNriH7zvw7XBfckXx2pK1we3yDuGz8F3G74Rm
5tgx7wfZ+fhBfEHOHLw5eSa8nvpB7r/iLIey2keZx+Gpe6fG4Jn2hT5QLrV1
PruxuxjuyLPBY+l3xzcb+8H8b0reRbZFuz3M5Oc8tlXyLeFxyadyz00/uVPm
Bxfrn5f8i/49/N2bvyOkBgcPpD6uf1G+AXNpws81uGnyafy38Qrsn9fvlrw2
v5X2/7TPSH1We13u6NAYuie3xD3w8bgj3yfxMUOs5ngf+nvDQ9Az5y5em5ok
vzs9p6vpD6e3MDWvvIv61+ROTvcEshOTnydf8Ly34Ab4C3b3musGel/BSO0R
UIvf1Tl3+Lk1tUDts8hX5vlnP05dP7U+PmvAcv6OzX0D18I1jf1L5xh8KD4k
uX/qtFlD8uvUJPl6Mnkw9NYf51n1wpOM/0j/FjyIbKt2C7FPgifZ3KFfOt8q
X1vxu+x/zHNKfmDsMe1Xjb0GzVKbNJ/lOQPgXPOrm3sS35/hh1IDxA8n1+Jn
GdRLXslXXVyRvEX2T/MYpP9e7r30P4DG+cahiPExuX/ClXCxfm3yp5Mr4L2i
k2eaO5P5NOHrqbzT0J/8yNQo8u3yXRRv5/vu3PHhgdwX6d+f79NY15w92YeT
24tzZPal7E+Jn9889YTcc7Pf6R9l/DZcCRfNfZ78ergBxupfi6+Bisb3yT1H
exaUTf6hPwnvDfvAlalr4f3Mo4/4c7SLwhSYDMXYfZ59Dn7Nu5l6Td7xrN+8
Czlvcl/wzv2gPcGaxmevzjnP5+/aN4hxfL6l5BZ8LoLaZNPp1MHtU1ck6wBD
+T7WPIbhp4y9kjus/iJcgA1ifJ7cVcwXtOdAhdQQxSma8xs/jB9JLTh5AL2H
kp/lnee/j1jn5JmIfTb+LvU4GGBuVVJbZPNs7unJ88jqJkfk48PUovT3gzmp
FaROggfweWm+ezgx916yHXg5rIBlyXvF+QC3xG2S5yTvSm6ZHABPSm6afDLv
sv4a8pHWXEz7Rf6aG++DF+Oiea9yNucbSU0G3s3fbIzvY45zcXF2+6d+mDs2
9CUrkvuV9n3mcT80g+ap5cFHydOzt+cuYa2/ZW/nt6E53J3fWqw+7Nfi4cZe
hLnZT41VpnNu7liphfDzF1xOdm3ujNrX4c75OwdZl5wvuTfwdRb9TqlD+S03
JGdPzZB+ieTH8ID+ruzpdJ7MfsyulTW1zt874GA+zskZl7pgzn7+Tsi5n3w8
55f+OXRO0z7Duk7Hp4bhtNSWxF3A70a8JHfl3NHgxpyTYg+HpuI3Se6amop1
jDA+J3fHzJHeQXh/vlbnN4M2+mdmT4UFqQ+b2wm4GD4R749LJL9i0yz3V/7+
yn0YvhSvePZu/Adff8JvsBN+h8PE32QeZVOTo3cTbKNbM+8+fAIfp45tfl9C
/+QXyWlgJNyYfFecg3LXM/dTUy/AN5rrT/lOyXfm7gs98l6S90wOlX1C/Gfo
7MpZL0bzrAdawEnJ6VJTSq6W/S7nEf4tdVa2tch/1L+TfCs+Vv8b7W+heuo/
ORvMpSaukfcjNWU+F7MfjV/HV6RenbtH6hPaH/rNVkFF+l+mnox7eb9+Md4k
dSTcOM8nOWbyfz6r0qkGt+R+jCvHlo8jcIXkFLkX4SNhKv2R/L7KfgR+DY/C
ffAlsCZnBdvPksfQ/0L/8JzrOdOzNvY/07vI+suTf69/B/l3uJz+Zu0yeJP+
7dpf48Ny987eyG6m/orUV+E6v8Fh+Z6yr+c8zx2ZzTbYDiPJnyGfDTv0Nxq/
Tvv67J14Kx8NPYMfUwPPOZH9GLbkjmD+9ay7kv7JYlTGv3inJtCbCGX46kLv
UHyI+R0KE+ivT02J7SD9IrAX3JTalviP0907eWPuRDCY37VkB3uHhuuPyDln
bnX1h+J6eH3uaWzX5W7HthZ5O3xs6kfkt6YOpn928kE6V5hjbX6vTN6U+xCd
B/HZ9FZprzC3T6GnWL2gB/SkfzD7Hvgb66yX+3zyBvxtaltsO6aGxc++dK4W
Z2xyflxUfzr5m8av5v8VsgP4Oj3nZ+6sZNfy0c6zui61tJxJ9MvRfyw1YfYz
8KPQy9jjuHvqu9ADnoPT+Tg+OVLuA+bUIXl0avDGLoKK+kfmHgsP5/6KH8IV
UtdJPpP3D1bRnZ4cF3eDBcarpzZrPsPMY6P+puQJYr1APg5v1v86zyP5c/Yx
6z4Ttuj3z/eMx2Yt/HfMfUv/d+0O2uenJpR8Gq/3zPtmD8vdIveM1LzhGL5m
4impEeHJ+AncPDWs1If5elR7iFizxWmkXyp5UL4Z/ff5nmG8uv5jeGl+N/Iu
4h6H98o3kb+Z8FseppvDo/AYvC7OYqhBp2/eAfEuwaXxj9nzs/8lV4FhYj6l
PwuezhrYNCX/Iu8/H6Xhe7HvFuut3OlSMxPvbvJu+B58bO4fbKvCSex+TZ6b
s9maisL1bIby+Qx+Fg7OOWWe7bNP0b0NnqLfDz+J++NudPbCRfKskkPDzbAq
50xi0nuc/QyoIH4/snV4PYxKbS7vbN7R3B2y/9Jvpr8Zl6F7KPxkXfdY1zs5
F/L+sJ1G3h3fh2vn717iVU8ek/MCn4z35W8/uIHNMD6fw8/DIblHpRac99p4
49Sr6NfUn5U9gs9r8jeT7KXJgxOLTX22+xjfRr45fw/Iu2JdM+FJeJPeG5lP
no3fsYx59Mv/vOAbsu/Br6mLwmj+ntUfg5/Dh7ErCy2MtYRf8/cVPnfk7yt4
g/f3fuMPpFZDfxS/dfIM9Y/DT+NZua/A1OSnuFXuS8mTre9Z7eHJC7OnJn+x
huPIntbeaQ6zcu4k18udG57WfwqK5z4lfjH8derreeeNn5T9OL8Xm5e0fydf
mb/35bcVezabqvn9+B6afS17WXJ/fuYkd0xdRP/7fNvwE70fyLbCB/ofwsv8
j+SvFd/jjW/LHp86GlmN/E0Jb/JclqZmCJWTJ0Ox1AzNsXjqXamhwvP5/VN7
JKuSmkP2zuQvqa/gL+E5MeuTr6H/Q+xSJ4HBsJDNhpzLOTPZNM/dHrfPs0vd
LPdUY+d53ufDOGN16FyFZ+XumGeKLzTP5/J7wPv8XqXfVtxOeTf1O2ePpdsB
ZiSP5msE2RfxT7YezzWXF6Fa9s+8d3TeyLec7xpapeaVuhx8Cg+bw/Hm8ghu
AdfnbotvSO4k5rPJlbJf0GmRuhnf55JNxB1waXF/8VwmmPNEuC7fa/4GkNpH
6o75nsSpyL6u/hrttVADWrPbiU/B+7MtAaOSG8A89k30y7C/RX+L/sdizksu
pr8y+YD4H+Fr8fU5w6Ahvf1TgzT/y+FSqCbuQPxHzjbzmJXacnKrrBfPxwug
LUyhdxa+Ffcz9kpyhORZqRGI2xYm8tNanNa4NH+X5V6vf72xG2BS8jXYlv1X
/3zzutk8z8vfTJLj0e3KrlHOALK94afciY39iPfFS9i/l5xCuzXd2jk7xKtp
vF7qP9n/YUD+xy95W/aR7HlsXjC+ODk//hfW8b/St9DU2GH69xqbLPaJ+ifA
Ava1yObjEvyPp39jcvPU4/R75x6cmm3uiOQ/iFMdnvd+vQBzYLb+26kXp8aV
84HtD+Rbc78nWyvOuuRi7MvkLgGtUvvNHRd/Z6w1PiX3YPGa5ZyFt63rLbgp
OX9qO6l5wOXZW1Kjs64P9HemBpkaHGwXrxXdHXhY6lBwV+7dZH2y5+hXpd/K
s6uWew60zLmQ7wOWGt+a/D95NbtjclZB/dQw4sOc2+q3g1esbxG8mruKOT1M
Nh0eyT5Gfzcfl+U3zN86sj48n88FcGjqejkLcu/JHPJMUjPO37nYvZR8Pt8E
3E1njtiX5J6nf0DOaHpbxTwaXhR/LsyDZ3K/Tj2IztbUavNeZR/NHMnWJ/eH
w9mXg7JwBJSH4nS3GzsVd0rN1vOYpv9Iznu+bk6+ah634EG5x5n/QLwytYbs
xcbG4ylsJqf2kjOC7AK+O0FHmJTzi86FbJvk3CSrnjMj93/8My6Bl2UfhDp5
bsmZUicUt1bes7zH5vZL6hj5H8ucvdrbUydgM9f469lH8H+wPnuFd6VZ7qL6
04wdjpvn92GzkH3t1HXgM3EmpGaPJ+YubI4HGh8s7hAYBDWteWjuu3yUz/90
6TemUwOPxy/hhdAOptK7PbUv6G9sOtk87fnQBS6ErqkP8FXM2H7wKOzQn0je
UvtGPCHfJvxjHS3NaRfean6T8x3lbpb8gf/x1nNr7qfsJ+TvENk7oSc/D7Lv
lftH9pHUJf3Gi5Nvpn6UPR9O52N28hWy4tb2cu4NyRX1/w+Aa+9V
          "]],
         "1"],
        Annotation[#, 1, 
         "Tooltip"]& ]}, {}, {}}}], {{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, 
    InsetBox[
     GraphicsBox[
      {GrayLevel[1], EdgeForm[{GrayLevel[0], Thickness[0.05]}], 
       PolygonBox[{{-0.7, -0.7}, {0.7, -0.7}, {0.7, 0.7}, {-0.7, 0.7}}]},
      PlotRange->{{-1.05, 1.05}, {-1.05, 1.05}}], {-1., 0.}, Automatic, 
     Scaled[{0.05, 0.05}]]}},
  AspectRatio->Automatic,
  Axes->True,
  AxesOrigin->{0, 0},
  DisplayFunction:>$DisplayFunction,
  Frame->True,
  FrameTicks->None,
  Method->{"AxesInFront" -> True},
  PlotRange->{{-2.15, 1.15}, {-1., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 ImageSize->{184, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1677787906]
}, Open  ]],

Cell["\<\
This is the absolute stability region for the forward Euler method, obtained \
as a relative comparison with 1. \
\>", "MathCaption",
 CellID->14433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderStarPlot", "[", 
  RowBox[{"approx", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16964],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJx03Xn898d87/9YiqaKajilithKtUqr1rZvVW1TQjW2HCVN1VK1Ozj02HdB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    "], {{
      {GrayLevel[1.], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxMnXWYl8XXxr8Lu7DdwQa7xLJFSSMiCvoTAwuxkRYbQSlBMREVuxBQ7EBA
wMIAuyVMVBTsRgUVA0Xe++O59/L941wTz8yZM2fOzJw5E0/rUacPHtckkUgc
0j6RaCr3jRaJxDpBfrNE4rauicTsjolEs6JE4k75r5C/ufzXy3+7/O3l36Nb
ItFPcH2rROJYuccIFst/j9Is2yWR+Lql8BYmEpOEey9BL/mbC6bIf0FOInG+
YKL89yn9jk6JxLSSROK4ykTib+G+SNAsKZHYVdBbsH9DIrGf4PmMROLMskTi
DMGz8hflJxL75iUSAwX9hXtPQbXgZuHcrUsicarwzakX/mLhFVxdl0hcJXhB
eZsLbx+XkSdaXswWbtGzq/K3K0gkpsp/sfDkdFYdRdty+YepXnNVrw/lf0b+
bfK/I/8L8v8h/6PVyq+0Xyn/TMXfqfj3Ff9TbSKxMyuR2D0tkchQPXqprKaC
HiorRTBZZc1S+i5qizVV4r38lwnekP8Kua1VlyNVlzeFd2dmInGW0j+l8Mcq
ay/BDNXpHMGewjlcsENpzlCaS5W3h3CuE54Z8hfL/7T8H7bVR+XbKZ6kqv67
mRdvCVIkFMmCt+Vv1iTC98q/QfCB4B677wvutvue4D7Bh063UPCRw7NF+xtq
304qr7pdItFW8EBuInG/vm10uuUVicRJ4s8m+Zfp20T5zxA8pPgBKj9X0FVw
vGCMoIvd0YJd7I4SZAv6C/YUZNndQ/Cw8EwQvr3kz2kSOEmX6e/9BMsqgp5F
ghni4TmCv+R/TbBD8LdgrSCJTiNYkxTuTrmrk8L9R7BO0KRJpHtD/qZNIvyu
/KlymwveSQoX/r6ZFPwm3evGQXnrBWlNIg88zpCb3iT4m2Xa4W+260ob8J08
D6l/PChYmR1tRVryU79c8wC+55hn5eWJxC1Kf4Lka2xBpKEtOpuvIwVPCVc/
ye94QSZ9Te4ZgmMlVxsk03MlVyfJf6LgXvmPlzuG8aIq5HWxYJHg6pzwTxPs
2V38F5zQWn1F4fWCdwW3Kc1q9dEl8g+W/1DBO4noJwsZMxLRP8F3fyL67T2C
u8GpetQVBL6ZousiwWDBD4rbLLgrEePOvc4zxTjAO8m473XcRsFHLmeTwyeJ
D0mSpbdd3vuC9+iPGkS3CrYIVtn9SbDS7o+CWwVvCd4ULLD7huBJf/9BcJvg
bae7xd/XNQ263zOPnlH4F8HPgg81tnyk9puREfX5wDQtNO0fuk64G1y3DU43
vzSROEXwhvIeK/k/RrBEuHqovU8UnCDoJhjrvke7fWxeTKkIP22UrnZO7iD5
1VhXqzG5RnCoxqActW22oJ/aN09uLu0tf7HcIsFe8j+jvDdpjHhJ49lvKnub
YHBm1DMtKcansWq/4xk35f9O5X5bEfPD30r7l2CI0o9Su89W+54hmKKxcLjc
vSSf+ZLVAXInCnLk7y/3TMFqlfuqoExz1hW9RLv8J9cor/BMFhwunCsV11zj
/0Uau/5UOX8IDlP8INFypmhIEQ2nSx7GCZKTQnahl7kFHuXR35KCT/lJEU5W
3iaCnvL3EI7ugg3i/48qo4lo/jM72i2Hvi34RP6CpMj/e3b4P1VctWi7Wzxv
I75NFY5fsiPtOLXnaYJt2SEHGYwLSSG70AJe5Ig4+JsmnuwhfkxICxmhzKyk
kI/MpMiPvBBHuEjl1qjcL9TW+fLfpzluk/y3SxbfsexmeEzdXbBOtK0VXCE4
sHkicZ7gXMEguzMEB9g9R7CXYLJgkmCA3YmC/f39bMHPaoetgoVqp/7+fqag
UHJUIDigMnAsFNwnGCiYJjjLsFiwSDDV7v2CKXbJs69guvPs4zyk3c/l821v
56Gc//k74XsFGwQfCI4WLUcJLhU9Byt8geB8weGCSwSzBEcILnX4y+zwHym4
UW34tcJfCX4Rjp8FlRpLB+vbTMFFglPUHgsEtwhOE9wmuFVwkMuB14cJLnae
Q53vQsEhdqHpyZ7q+5LzPtJfHlG5Dwueygze3+c6TbR7j2CIaQfv8cr3qeR5
uXS2H9Tvpmqsvtv5PjQv4OlHDt9j3rwvWKFyD1P+XtWB63HBY6YVd4XpxX3U
9OI+4vKfcB7a4wHBErfPUoenOY72XlwR6S8x7u8F3wk+E39/lc77nODZZuH/
RfCM3Z8FV4sfXyjd54LbRe+v0qM+UL9ZIpyfaS54UnhW12peUNxc9eVqt+ER
ltllpgkZX+4wsv+gw9TpW8E3rhvu16b9E8HHrgPuJsss7kbz5jvnv0e67t2C
9XUhyxvN94eN7yvBQ3a/dNlfCD63rDxkms53nocsH484fLJl7WbBdPX7aYJl
LaM+4PjM+b80XtrgU9dhqb8T7mSdYoTgJOObLxgnuN1yXKr+3UJwgtcAyPrJ
1tdPdbiP5Z7w7oLxjMdJMbaC90TrtuOcrq+/N5aDHoae28u4ybOH4AzBBMH/
BFMFU8gnGf9IbXsWc5LWGzsl5+skDyM0Bn4rWKC++Yn66MEaG/8ST/oZBzTt
KTjTePsLJjo8QDDJ4TuSQkd8x/ojc3D3JqF3oofBs0Fq2wMEHdH/NFdkCN7I
Cx1xN0Ef64iMu32bhB6Jfkz+jub3cMFdSaEvomPeaZey0fV7C3pZTwXfrtZ3
u1kHR8/tah0cXbWLdfAk09vNumxP16GZcfT2uqKXv6WZRujeS3gmmxd7m9+E
GxqC//sItqiv/VQROvJMuZMqQjc/QHPAKvXPEsG8pNDLV1um0MXXWrbW+hvy
+4a/UQZrlfssc8jCW6aDONY9U9TGkwU3uZ2Iu8dydIfliHZlLXSX2/wu83W8
3Tvc3vc43Q+ifbNgrmUU+uZ57KZ81gQL7ELrX9mxLkH20izHyHWm5RVZy7Kc
Ec62nBHOM0/hcbr7CflzLH+ky/V3whnGR7p89wHydywMP/rHOulJN4nvf2dH
W91vPtJWixw+1fWhHt2tS6JHfqs+cqzGjRvVR36Tv6P8Z8rfSfhHZkVbL9Ya
cIz8owRPewzeKuhbGDrGHYLd5b9K399tGmPJ9YLrLOO413pdeKPgBq8X5ziM
LnuTw6P8/XrTOE8w1/rvfIfHOo48Jwlu9reTBbc4PF5wp+AOwQT6mMNnCO52
+Gy1+b1yJwkmNgn/Pe6T0HuN4FTBrYIFgjP9nfynCW7zt1cEfwm2CxpU/+ME
Q1lPiG/lapMyQTPxNknQS7rHLvo2WjBK0FVwvGCM4HX6MOOE4BKNZ7MERyq+
m2Cs0xV0E26NaWOkJ7/mtH8znujbCMFwQWfjHimoExwrOEZQa/doQY3dowT1
ppd07QXDXIdOxgHeDsbNty6mlzpgtLrdvDjd/CZ8inl2i8PvCN4WvCD4XfCb
4GXz7E/BS3b/ELxol3TPO+02t996wbtuv/ccvsNxlLFKbXq5IF2y+Kp585fb
80WXf41dcLeSrD8n92p4qPmtg6C7xq4+aqsfOmrOlB6VojTJgl9dT+rxluv3
puANy8T7pgkZ+cBhZGqDw4yt4yw7fc0vwntYLpHTfnaR393tkq6P8yGPMyUX
F+UEza3aJhJVgjdyYyw/2X2it9uA8K7OR7hQ48Qlqt+bksnpWUHbfYIHpaM8
KBwzFDdTMEFtu4fgHPHyx4xIM+D/9ZU3ssOPDWdP9w3q0N/fCV/ndoXv/ZoG
zvGCnoKTBCcKfhc9vwle0rxZpr7xo/wPyL/N8b9J7/1T7h+CH0THjTnhH9Yk
vpP/5byII91O+bfbT/q7pR9+LL32nhbS1ysjPWUNLJYcFEUf/d39ln6A3NEH
CCOPHdwnkKPO7hPIEy597mfx6gHx4sFUxUlvbqJyklqEXHd0v0Fuat3nrm4T
9EHbcwWup+o4obX0W/n3VJqLlf9n1r1yTxLOkwXXarx9XOF/FL+P1vNvyp8p
WV2ksi9rEXmnyV0mN13xd2eHm2E//KDchPKOrw78+aLrAuXZig1X7sw2Qc97
mRF3mtKd2SJcwks0F/wkd4vb6NPSCOMfVx3pSHNei0hzbosA0ozOiT5c53GI
Pl3v8YkxbBePWzuUvptofEc0vy3IbPpf/8GfIUhnvhH0bRp9rDEOt5+/MS6k
yU1tGn2S74QZJ4hrLigqjPTg7SM4TXCqoIdl8wRBd7uMv70EJ1t2ewtOcXhX
5yNcLJy/ZUTf2Y3x0Xih9XSH14qGJLkY+tc0CXen3NVNwmUOaGa8vU13X+NL
tdvHdejjdAnPE8wnKc4HvXPEyzvE+3ZNAy9jN7xO9nf6YpLrSf4mrj9hxjbS
NW0aY1xTf1/XJNwk83q868b4C03QzviY4nLedn1SjKuny6Cu0AtNj6ofXqu+
dHVWzOXwCN7c4vGVMq9RuhcEz9OP7D4nuMrus4JrBS863fWClwUvCa6zy7eb
BK8LXhPcIHjF6eY47lXBXMFqp6N+dzYNPYc583LB7KYxZ1L2lU1jvrzaYebI
axweaToov7vWpI+onldkxVx6rdON8HfCzM9XuIwbTcsrjsPO+DRh9elTktXu
gt7J4T9Z0MvuSYJdBKMFowSd7Y4UvKa8rwrOlox2UXiM03Xy9xHJUZ9nXV5f
jVG7CS5QfJbWVZmC/lVBH7Q8ZV7gYmf9XPrjaVqPL9GYcJnjsLleahfb6mDh
mim4SPCi8F2r9MXSZzpormkv6FQeusiVrvcotxN8HG2+EP5Oedcrb59WYZNt
InxJgrVNw00I1jQNd6fbE/cfQZnGpGtUr04FISu/C36zfPzh8POO22b5wv21
adjUmglnSnLwALvvVvOM79iC5zcNOigfHbl5cuTBjky+ZEHHgohHZ8au3DQ5
6oAdmu+Ekdk/TRMyut1hZOIvhy/LCvlkfmUcwq6NPft0yyy2wHF2sWefZpd0
pzgttu0x7gPwF13zJocZ7252nRgH5/ob4+I8h5HTv00TfWiHw6+b34S7qj7H
W+bAt8486mmdBR1/nnlGW53oMok72TSS72aPB4wR3YRrrPH2EJwoOMFt09t9
oio5ZO5QQVvBEYLDBW3sDhG0tnuY24Z8PQXtBEcJjhRU2yV/jeBof2vqtJRP
29c4H3sI4G2VHHsJrUzL6nrxRZBZH3sRbVw+exRtTRcy1c5lIlO1LhM5q3Y9
kMe65PhWLxgqONbhY0wf6yv0YNYoN9hF777eLvoZ667XnG6u5yHWIjfZ5ds8
j8d8u9X6L/NDncukvFzJc45gfV6sKxgXLnO9D3Mb9Nb3XoJD5J/WEG1Ev2il
/nit4nsIpiu+e0GMb0caB+PHTervw9XfP9f4c5f8E+T/sSr6KPWHFvptg/lB
n2mfHOEP2VP7f2Ml/ps9VuLO9/h3veA6j4O411qm+D4PvqerjDT1acEfgncF
11guLhNcajmaJbjYcnmTYI6gu2VzrGWR8e9C84a0M/1trvOMcb4bnW+evzGW
32BaR/v7DZZLyr/Ecn2J6UBGZ5s++iTzAeM9/ZI5YBfz6DjL0E73Vb41sVxD
+5q04OefHlPpe6RL8nfCvyjNWkEH5FbuOkHH5Oj/lEPZ/xMP31b8VZabKwSX
W14vN6093Tbwfm+lv9K0/aZ8bwmGW+6udP430oJ+6Nsm/5uCYfJ/Uhx68F3S
JW/WWiBJa+dPpaN9In26oLl0YOyqKYnEV4IvBY8KvhV8I3jE7teCh+2SrlB5
Bwr2ETzofF8IihXeT7CvoMgu6S7RnDhL8KLWkMud9nPBUsFngk8Fzwt+E2wT
PGf3V8ETgh8EmwWP2/1e8Jjd7wQTNI6MF9ypNdwy4wbvCn+nPi8IfncZ1aIl
T31nrOj5Uf3oB8HurWLv6F7vH70jfFXi01rNLZVyr1Y9hgnOEiwWLBJMFzwg
WCI4rlmkuUpwpW332OxLBPubL5cL92zBy8I/9P+lPUowW3CZYJrxUQa2qBHt
wx411WXeL7hLOu1x0mkXyt9Z6/ROglFa2x1rfFcIjqY84z3GcYSfNV9/ETxj
92fBU4Ktgi3mU4PS1guSVHYHudsV92dK+NsL/kgJl3TnNMT3V8xf8tUJZrqd
aIeXnJ98nTXWXafxbd+CaGfS1jYLWmrkthO8nPJfmdBVrbi21F360Z2C/8nf
SvmrBD9qvH1GeuUraquXsqI+4CAPdQU3eJuoLi/qe0f5b1T8q6b5BruUeb1d
6L0yJfgFn66w+7TgRdfjd4d/No2rzL+fBFdZjsn/pOBHy/FKfyd8ufPD+9l2
wdFU/X1zWqS91uUhv9eZLsIDC4L+OSnRrtglnxJc47T0p+/TouxLBVc7Dppm
uV/Rny4xfU+YdnjcxnIDvlWWnWdcxqGCiwQXWq7PEZztvj7d8jvQLn1lpGRz
hGCO5HMwMuH856kNzxVM8ThCWmT8bNakassntAY/TOGLnedgwQWC8wWVpuMQ
wYHCPUgwvTL62Nmm40DKEJwrGGR3hvNcaFwHGR/pDvB36lPVLGiljIvNJ+T4
NcZx5hDB/mqjj8TfbfKv0loiV7BWcU8q/KPgB8ETdjcLHrf7veAF5mnGcvIK
tgh+Eqy0S/6L3G8Yj19kLneetcw3iksgs/L/JdgueNnun4KX7JLnVdNLuteZ
81yHNcmBYyfzZn3gXCf/6uSII12rZtEG8KKleUc7VNg9yDxbLlhm3uEuNU8f
EjxoHj/sMHx/xOFz/X25ZWKF4FG392MOX+i4RywLj/vbJYInBU80i3G0cb/0
bJfPuPxMecQzLm/TWPqroK4y7P3H2OY/yzjAe6lgpfE+p7zPCq5Tux7ZLMZm
vh9hl/IPtwuOtv52uPsP7hBBa7vwscxyiTyW2kXuGKeOdP5y85V0Lfydfsa4
O7xZzEGvZYWfcey8tuKj4NncGOMY95lPGPOOcZjxmPnmWNdjlevZzmkpm3H8
OKerc1ryt3eZx7kes9wOT0k+tlp2GcuoJ/LSVWP7jRqbDhDU9JSOIX1jT+kg
7eWv7Rn0tpXbRjCtbdiVsUNjGyttGbbmtKywmWBrbrSd42Lnvkz1PDcr7Nsd
hWOE8CdVhj5+q/OMU9yFmtPPyYt10s22o7Bemu/wS7bPXm/77LUON9rHr7V+
v8B4m2WFvRlbOTZz0jxv28wtToedDbs8tvB3TS82+5u8nhzrtdwJXts1rkXH
eZ13oteaC7wuZS3LOp/1/2iv/U76f2vBk51uvcuh7BuddozXpWNd3vumq9E2
j9tom8fFvv2L9Iqzs8Iujm0M21WK18BjXIdXTBPlYHfDroXNa43XSPD3N/Pm
Ba+X5vob9rK1Xrs22v4I93Y54MIW9o/tgNhDsTvvaPKf3Q1+Y1fGvtxoh8Yl
HXa9HU3+y7/aa7YdXsO9bjvc25YpykRuCFPXN72ua7T3vWm8rzr/P8YB3u1e
Pzbufb3idNjzdjb5zx6JS72x+TU1Txv3eJDB382nF//fmnOucbF2ndPkv7Ur
4ca9opdN0xznaVzTkg57JzZ37O3YmvE32p63uX2wy//penQ3jY22zyamFXvT
SMtfe9NNHuzWvzX5b98Al2835Ye99XSNmdnqm+mC4erjM6Qf7q/x4K+UsPON
MF5sf9gKh7sfYMvdzeXR9ru4D+zqb8hfV/N1jGWFMHYe7MO7W9753t39YBen
a7RlU7/xTovt+y32ggQDcsJ2jU08S/Fpon19R42DGluayJ/fSXNzUdAK7xr3
G3GRwQnGt4f7826maaS/d/Z3bPSZ7us9LBf0Y/ob/YD1DfoHOg7rm0rPvaxp
WF+xrmJtg8s67A/pUAXNYg2FfskYTP7PpRN9JsivUv/UPNZMsLZFjBe9zVPW
RuBmPmeNVOH55yTTBU2fY3MQ3FwVa8Fyz2OsA0s9R7H+w2Wtg27bxvMe68Uy
z3Ws+fhOHRrt+I12fdzGPY3GfYxGuzY2ZOyw2EGxh2JvvNzhRtsr4Wf9/aqm
/+0NUMYdlg/avNFu3mhHx8Xm3GgfPN04sL1i28bugv0FW05OVvgvdZnENdrC
cRvt1sc4/62W3dNME/gabeTHWe6xZ9LHGE8bbfSEXzRd1zX9b9+6cR8bt975
21sWwdfg8FB/J8z+eY1p/aeH5Foy/K1k+G/5twsObKv+mhN77RMy/tsXp7yv
9P0zQTelyc+KemO7brRlN9q2LzM/oJe+QZ/YrUZjtfSAtWVhl4X39I/fNDbM
zgp77bvCPaGb2lDr7tXqX59pjDioOpH4uFnYJPIEd0ifXiCYL3haesbP1jlG
q79uyZasCQo7S/4Ft5QkEv3Z51Qd7xLNG1Olk3PGVvBRarjZgk/lL5RbINgg
fxbnxzlrmhrfCZ+hfjNBcK/6/ibF56UFrk9SI1++YJn8nws+EzycHf7lgqGi
7UeFfxAUi64iwQLRNrO7dFzB3a1Vx9TAAd7Hs4Me8ExTmWcJlqjcJalRHmnX
q98+qHTbxbcPUoPeDMHC1KgbtJ+TGjQtTY09WfZjzxOcmxp+aJthl3RnO+0D
gkmC+wT3CianBl7C39WpD6mc9dCWGjQtFkwVLBLcL3g/NWhJF7yXGm5aWqSD
9k1Oi7vReTaa7ikOU95Zxk3a6aZrid1PzYul5jfh0dg8BDdVxtm+EsUVp8aZ
xHzaLDXO9xXR3qlxzg+3IDXO/+GSjnOLpM0VPKa2WyF4RmvPLar7dPWLdMWn
aq3wmOSzf8s4v5iDrKTGWdIs2kOwn3kK7fvahWcD7VI/8g0Q9E+NfHsK9kiN
86fgyEiNM6nZ/s55yVzn26Ax+ANBQ6s420hdqRtnG1ukRv3f0vc3uZ/TKmxY
p6i/vSJ9ebbk7jLBIsneZPFskmCh+Hat4q4RPKj4TZpHvsPWJTyXKG6W4D7F
V0h+ywX3SIY3Kk3L1P/OquKvSI2znGVyS1PjLCcuNLVSvirBAyVRP+raTzDR
snYP7Sicu7vuN4uu+YLVou0OzrYK+qbG+dPy1CiDc6WUSXgf8xV5PNP47hac
Yfeu1Fg7fiv4plmsOb9m7moWa1HcL5vFGhT3i2axzvzG6T5nvkKGOCvaLNzC
5rEu/c54WYt+7zD5S5pHHmyrnNXmLHZO8zg7ztnwk6QHTZJc7UnbNo/z5QM8
3u3tcL7zEYauFs0DL2UPNF5o2ddhytvPYdauPwp+8Jp2s+nDlsOZtS2sN0VD
W8GvWh8NF7+HCW4Uz3+oV3pBNmd1mwV90L7K+X5Cz2gWdFC/Tc2CbtI94TI3
e235k+nAjsmYTtrl5hF8XWYXvi61C+4H7GKf3qQ+uFGwoDZsn+CAriX+Dt5h
nINtFnZReLS/eQHPDnC4tHmc7yd8gep9vuBWzXfncQen+X/ntvEj2/PbaL0i
eEF951Px4wP1ixrF/66+9ZtgYKs4A9iueZyt/qQ+/L+Yx8S1bR7y+IHHSMZT
xmnmnAmWzTsFTyrvDMnDHfLP0zg/V/Cays0qj/MtnHOZpj4yWPCu+80G473b
uN8zPlzGatqK8ts0j3bAbd085Lqcvmo40Hxp2TzO33MnoKp5nOnnbH6r5nFe
f7Drw/lx7gqA4yDnB+8Qp2vj74QrjI90lcZHGYnCOIsOv+g/FcZHXyx1u9H3
ytxuBe0kR+LDC5nRx1oaN7LV2jQi35WuB/JX5TKRx1au08a00B+eYf/FY8YU
j8UTPX7Ms10MG1hf6Ry7CWpTwk5Xj506JWxwDSkRPtz2U+yp822bI//glLB9
Y8M7LCVsiIQPddyFKbHnts55brJtDvviNZL11uLRV+xzSTaGCM6TrB5WH+lv
8X4Xdr1XvO/1iu1/c007uOYYH+mu93fsgtfZxaY4xLRD31DbrLF5781dJcHZ
8h/rOOzfx9mOTDpsi+1TghfnpMS+C/s5BwhmOA53ub/dqrnoGMn5A/J/kxZ8
O0IwSHCu0x4oOM/hJPH+27SwXR/j8rGXH20Xe3kTpflOaS6T/xDz9QJBF83X
XTXvfKB55yCFzzfeg/2dcG/OogpO1rj3iOryjeDr5NjvfNE22k3CXZ0ScvOd
oCVrJMG3yeGWp0Q+3LKUyI9bKvhMeV8WtJN/gcq5RbBGZT0suvYQfW+rX68U
j58UtIC3qkud4Iu0sKm1ZR0lGKt2P1JwgWRghen41nZivrdOCRtzK9aNKWFj
xq1MCV0Z+sGFTZm0pMMGzXfqw73e3bvF3d4rNecfJdoe0Lz/mG3V33l/kX6D
Ds4eLd+g5SK7jybHPi4uvHxcdXpM8LD8/dMjL/uUp8g/VNBO0Ezlpgi6q9xr
FR4geDEt9j8pB/viBnRKwfPJsXe7yjbyC20XZ3/yUfODdhiWEvsfyCh7v9ji
scGzt/y46Z7lOMKzXQ54LzVu8uztsQFdGFl80HKM3LAPyn5pP4/j4wV7q8/e
onHqgsLQTQ4WHGQdBfdA6y64g9BnsiNNS+ugjEd7W3/i+wHWX4nbi7FK4993
yvOtIKH2eVBz3m7S7z5Piz5EG38l/5eCI+XvlM6FOsljWoxTQ92P6+zSn7Ik
h3drrfRyscYP9iQF24VzD+Xrlx79DHkZ4jEs17QMsD490PrXNK25fhWerW2j
fo1rjkF2Z7g+uKxR9rd7tvXfM62vgXeSx+K9zHvCBS4HHs1UH7pI8LD60XjN
hyMFd2eEHryvaWrh8va3ToyLbl5sl3R14met4HT5R1QEzbRTtueDRr38DLdx
G4/1Q9yXjnC4wWPiUPf5QR7/KjzWHOQx4iCPbWV2Sfe16vGVoEjyv6f6yh6C
/VNin6aT3I6Ck9XvjxFclBF7O8R1EKwtj32/4wVjUsJ/o8e4hyyvW4V7i6Cl
8I9MiX1N9g9H2GVfcbhd+swbwrlOcInKGm187IuOskt+9pQon3GfPaXOKUEr
+0m7pES46/+j6/Xy8HcTPCf5elbwm2RsjeJXCy7OiDqNMC1dnG+0xynkbrDL
G2ZeU95I5+ls+gjv4nyEEy4TWo6uDz/7W+xpdXHaCzx+0J/Z7+rq8hkXmacP
8fh4iNuyg2mEjirTRbr/1cQZY85ZnJcTOtti9dNUuWmcueEcstaUGZypl76d
KTdLsCAj3Gz7c+TmCvorzd8tI74/emBO5CEN56r/TZcTafHfp/h1Gq9byP9q
ksqoj/TzsuMsUi+NS89jY1BcEWtb7BL2P6y8g1pGGP9+OXFvaWRG4Csxznfb
Bq3zlbd3u8CZmxU4yNs+N+5YU8bT2XEHivxfCE9tD+XpIH1BaXooX3dB8yzf
M5D/OaXvKrebYL+8eEOC8H3S9zZoPO0s//7C80htxJOGuF0ENfLXqf92kb9z
bpRZ6nI7tIt0pOF+QH27uCOQXR7f2uWF29H+TvbXGH8Hl0sc37aIlqdKAk+h
aG6vcuoEB2VEXIPxU8eegunCs6I2wvjhVaH53KFILmfbuZcu+RmrNHmq70K1
4yOKH6dx+3DFjRI8rvRj5I4WjMuItCc4far699LOcY49tzzSdBfOnrWR93LR
fL/wLRYMV/zXaoeFnSPcXeXeqfKWyD8mP9zRcu+UzCyUf5j8t+dHWbfJ/VJ5
7+kceBa1CLzrsiLt/caPu9DxI5RvpOBo1X1DbdThStEzXTwaLv8BqstOyckT
Sj8wP+4F4d9T3feh4jjrzzn/g5T2YMFC1XFWQYTxk/Zxp2efr4fl6lnneSY/
0jxp/JtF/2LRv6JF8PhR83ljYdAGb6EXuhtpxM9dAOSui2WStMe7Lp3Ujo8J
z5n5AeA9Iz/iHnU87gqX1aMm+P5AixgPGBfmq9wdov9Xxf0td0C15ii1S1eF
56mc+YI5KvfDwohbJ9qe03y7v+B/4lOaZLKD4veS/yyV10X+tUrTV3iOU99u
S9uo3tN7RbrdFD9U8W1ahM5yM31Q+C+Q7ve45vI7VHaeZOmfFsGTtNzwv8s7
APq+qWfcxwC4m8G9EnCAay/O4LSOcK/MiFvQLvSiBU5DWeDbafz7SIZ/b6+x
U3knVwZd58vfSfWbKLp3UfoC1W1vxW/DliWeD5Q/LS/ecDmAMVH+JxS/J3c5
lOZp+ffhDor8VXWac+XPy4t3PQ5V3Qdxj0Q4W8k9WDRcofT7yp+uNHPbBd/h
+ZTK4N8FwjNEdKZ3iPdgHpJ/u2ieKX9v8a2PYKRwPyd66pR+dm7cxwXXMOEf
Vxg4idtdPNurMtLBU+57cNeD93rgCfyG//RnvrVQ+j/lnsAbQRrrDhCeH0Tb
FaJ/kPxniubnasPfIT/cA+3PKY/xbqvybxZ8L9i7WaQ5wHkr5A4UvJUTbxf9
3CLeL3pV5e6t+FfkthW9v7T47zt+xkbw/2x/YXXI8NEZ4W6zH9z/M/7qyojf
4TeSoOsl1f2a7KDt6uxIS57ydhEH3Zzv6q/wnozpWeESfjUneLPd/PlENAxQ
fH5muHsJXsuJOWtXwXl5Ece3rsLTrjLycifo8dpIR5pu6ivdBX0Z04vDfV/x
15ZHedyxKq8N/lymsmZUBZ3w9o+S6NeZKveCvMDJXNlP7h6CFxS/oTrCzTIj
Dn8rpdlYHXXLVfyJkqchLUN2mSse9HzxnWRwkfrFQy3izQnenpjDvdecCOM/
S+uqzeo/w0rifaVvNf+NkL+kIs60XIO9rCzy8mYFYc7KcE7mOfufl3uqvj3N
XYuySAf+G9l3kbuFNKLzV7m/CI7LDDvND4Ld5O/cJtJMlX/f+vCT72D1x4Pq
Iu0TzsvbOj/4Ozr5C8YFHr5TxsLMoOtZ0wZNT8l/UEmMy0/KPz0R+0AzBJvU
bvUVEQ9t6PyrysPWfDxvEZXHPeYnTQd5fxKftgjalsRdYtJMS4oyn3O5qzRW
/K40Z3NOW2PhdvF5ckn0k+d8Xmir8dyTFe7Pxgm98HNGZrxD9JT9kyVLk2oD
L28NPWGe5LQJmtoob1ZhvPfyaEa4f9q/3X7egblR9fpa/hvkXqo1/amib5ni
PxaOTwQPivaP5G5qG+9tEcc30jD3f6a8n4vmo8vDz1sSE8oiTZ/cWB987DXC
dsX90Tb48VV5lLs345nWpnPYL6+OMThX7u0q646SiBsnPH+JZzOU5s+2UXfw
PJ0ZdIPr4YK4N/eVcf6UGfWkjti/OMu+IDnu8WzwXZ7kzPD3SY43e3i75xHF
pxdGGD/v+ODnbZnfnYY4XMKbM2Ns/d3xlAeveVdqUU7IIbK02XKOrO7mMHYA
1pSbHQ+NH5nOU00zZ++zOc+ruqdaNn6ynNDn4e1YrSnmqH9/Kx4dy56L8YCD
8WKj/cTh552lXaVT9K6JMeEDzUVblPfUkmgv1nU3Cedn+vap4IimmlerIoz/
Y7mbBEWq4/zyiOe+9iHWu9CnPmkR6Uizyf4nsuM76aYUxl4s39jP7NQy8pCe
tQfllsod0i70WnRa3vbjPALv+/FOEt94K+ly+0nzV1bsfbLvSZngfDI74t7z
nuj79jdXWV1yAmffrIjj20NKswG+CL5Qu/SsCT1sqcLPFoSeh463rEXoZejC
6Lvo2dg/GXOXK/7E/HhncJnTwO9eNTEu497TOtJ92CLKo6xvNFbf3znKeldy
fpxwTsqNvWHoedgu6R+Rv0PLyE/eDcb1KHqX3I2uI/r4idb/4cNHjv+qNPzw
7AjzGb7iHuG1wKaaoAE5/1JyslVycnpJ9KPXLFfcrXvV/lMcxj+yIfzcSWGe
WuP1O3PZa+6DG5yXPsj6fk2jPKeEzQI5LNSY9oNkflxJyPs6p1lrP2mYx9/w
ONOb8zmM21n/pcOmcKXi3yqP77wnuFk4TyuJtMTfIj53TwkbBOv/jbVBU2Pc
apeLnKw3D9+hndDH6Mst4w1K5BNZxd8vK87SEIaeV8oiz7Ls4OtQ85bxBD9j
Dvs37xjnWy3C7rskO/xvOv4R1fdhQS1yKHe54NHCqOfrpvOS8qgb9bpK89qV
FXEHnH0icGFzAPdbxgk9wyxv0EdZ3JW+TmPP9T1jXO5SErpwrvSU0yWnM3qF
Ds0eOHvhEzPDfdz+QXXxjibhO8viG3vlvM3EG03t5U4viPyk/0tl/CG4UHz4
Te7vgutFz8rc+EY8+UnfRe4L1YHnDPkvZR0vOEn+V7BDYEPJijNmhH9R3UeI
lgb5P1GaO8rirShowX3UeK6sjbyv+B2pRxzfU3X50mUghzuqQ96g62/BsqwY
X3+pjjGWM63PKe3faoutivtZcF1uuIQXKP2P9tMXXlDa57GPoLfIfbaUB8zU
H2sjHlz/VEe5jP3POf3LwvNrdZTLeA///jI9nxdEOIM3AeRuF7TJjrg/Hb/d
ftKDDzryc4P3tMGdWYH7N9frU7mfVYc+DC/gyeM5cWed++3cW3+ecHXMsa8r
brWgUv6l1RHG/7Pa4jXeecsIfuPPyI18PzpvYW7kXa+yChoiL3dYLq2JdPCQ
MeRH8/AdfX+3NOap1ywD4OesHmf2eKeB83tvCy6WP7Uy/DPyYs55x3nTKwMP
uv13wv09Oon612O1kYY5irdT15QGjdCyxfRA7xrXkTH2a2SA+NwIM95Cy7dK
/45k8/Ly4FtRUvDuE/n3kHsb6y/5D8sPGkgPzaSfXR7pzhQfNlXHGuem3PAz
xuJ+7Hja6xPLKjjA9W5+1Ok740R+trmt5+ZGHtI3VAb90D6xJuJpd+aNr1wv
xl3ws4YC/5vm7QGt1LdsW2MN86vl8x6lv7s87vR0kM7dRe5EzZP7FUQcd3x2
KYv4yzIi/S72d5TbSTBL/plaI7QkXUHkJw04VrSO+LOwFSjcoSz2J88sivzE
MXYyht6luBXV8e7tgaKtb0n4ef/2GfX3bko/SP77RMO95XFWHXwdTcMexUEP
uP/nsogHB3h5S/cs8bCC9xyUZkRNrAFZK78peEswODvmww3mD2PEh5bnM2rC
z1oPd4PjmYNSykKfWWtcvKEwknN0lJ0ZawvWGK3kX5UT8acgk6K5aVm8wQE9
r1XHmvTCuqCL9QhzQpOymCPIt9Z5/32voyzmo5LCiKfco0oD59LscJPth3fw
jLP9j5kn8BmXcB/xZ1fR005pTi6KOn7k+laXRfx04a+RWys4R/7TisLfryCA
b//euReeurL/vtc5fb3cBsFM+Xd3euLRNTZ6LL2sJuQT+UdmV1lucQnflBlv
LTzNWKTxYVCbGKOJo69tdL8b1DbSMG7jPmP/gIKgg32bb2vDDz3UmXr24V1X
0dOaN0kUP74oaCYfbvtG+ovDz/dO8neXf1JR5GvjvMgqcnt5Rrjd7W8ojjQn
KP3TdZGnJ3eGOdtjPkPDneVxt7iP43vbrXaaEvMHm3+l4qrc1+hzlfYPrg1/
t4IoA3zcU76oMtKPFQ1nSH84t1fY6drXxLjMOM38XO85+l6le0j9pVR9IkXr
0/IeicSRGlf6iM/LsdHI7SpYjI1XaW+tjviXRMOD7SLvF2qjs0RPLuuX3Ei7
xOkfEhyk+BKN88eURx7SH1Ic6SqV/hiNJ2vYn1C6+xW3qF3Qf1pHrTuwq0h3
WtguvlHfRfY3zQy6wXlZc8mRcJYJx0juqmnuKJd/aSLwlmArk//ILonEwA6x
pzBLcZe0CFv9leXx/gzv3DycF+7xOfG++Uz5lytunvJdI3rObxFvyfCmDO/M
nCn6r2LOaPHfOpl5prwy0rBeLlK5M5R3tOp+kPT8Q7pHvitaRL4VwnOL8F/X
OWiCnlmmbbryDtG3fZTm0hYRD428t36p/alFgQs80MLbO5c5jDtW9KQWBB/6
i54ZLYIv8KSzaOnSPdoBvi40b5Fb/JXJYVe+Rd/vVp6F0lUXCdorbn/ah7Wz
4r8Tz3fHlWw8KX+F/J8J/wP6/qCgc3XkaaiON4nGCN/7ZZGHdwr7yp2Lrqj6
VnWIvZvHsHOAU/4XpZ+MVXmvCv8TrcOWi024QWmHC/+uSreb6rF798B9heLG
Kf3JmVFGX9O2QvkeE/yVH/e0CG/Pjzj8a3i7ArtJSZx5/Id30PFnIEwRbvz+
j+MHqZwGlZvBura9xsZekYf+8bBlviIvvu+vunzWzviVd1+5K1lDigdPyV0l
OCEz5oEkryO4s/Eo6we5R1eH/6iskK/zLYfwlf1H8oBjpfGwzwfd0LxI48Bh
4s1fLpN0lxWFTvGW9QpknTeYxkhmriiPd5YIT9CYnKm8R8k/Tf6Rcicp7Zf6
/oVglMIdhb+DYLr8n4v/XwomiK7DBMMlE0e7X/GOVH+7UwRn5UX/w0/cVZWR
dqTiT1K/Pkb+Vmqj7sL3Rbcoe7BwDhPOI1vE23Mrledw+Qvzw71Ldd9L7XKk
5GOQ8IwsDtqr0AkrI99QxR+uNff5SlfJnpHqldM6yrtEY9qs2nib6l8aTefF
iptZG29LnS7ezmwX9lHeq+Jtqil5wTvCe+YE/4gnzNk50h+XHXuVjMMvMocW
Rhg/aScZD2kvdvpxrYPXo92feVuL8Zy+Dr8Jjxcf7jKtp7cKHRdc56he36vO
E+F/i8DBHuizeYGfejxaG23I/u9Q9cHjxbex+t5VPP9EPB9OHvFwhNyJeYEX
/OjPx4kXQ6vjvOQryvux8h7F3ldNjBnsXUITtBH/rL7fxjl8hW9uEfk4Y3mn
4jb0jHTg29omzl9uLox0pOlXEvnQcy6Ue1GLeOMLWb3QfsbsCz1uXySar4Iu
+W9Q/2ndOsIXSu5vaRH/iLhBNL8kmurkv5j/QFCW0vcSLVu6RbhYaeZ2jn73
kNLupj5+LbxQ+uPkVitvD82fa3kPkf5SHG5bxU9RPVJbRzr4PctterJk70Lh
bKc0V4m2wtbB37OKg9/sBx2gceXA7vEeG28YzfC4Td8/1/PLofp+mGCy0mzm
Hq1w/omtvjho3KZ880XztZ2DX/ARvv6iuryoej2pb1ncExNd49vFnJtUEOGE
3Muqw0/8PNFZwBoyJ/aV2Gd6UG2yiDf+e8Ye0zLxdjRyr7y3sOetNHOFf7Ha
aJFgkL4dWBNuV/SW1vHtwLJIt7A67ApX1Ya9gDDn4Q7W9+WieYzqOrZ75OOM
Aecb0Juw62ADWi6ejBZN0+T/sFm82T4V+4hoO1XlniI4S+EheeHyr5ClVZHm
58zQv8CJjko9xgiOyIz3fdmr4J3VFWWBl3fgoZM6sha+WngGKP419GrRcAh6
dkn882AEb8oo/Xi5wwWHiJ9DGJNrIjxPaYbJ3TUz6nqI60u+kc7Lmofw8owo
c5HLpQzyYMPBDoDd6p78+N9Bf8EENeXl9RHGf3hG+O/kPwBOQxzuAKdZbjyV
tjOA9+78iFvq+ILCeA8f3naW3nu/6jCpLP7Dgsu5AvZY2Fthj4h3kE+Ap8zd
FWrHstjTebQs/PCYePZ64PX9RZFvguTkJLknCnZLi7QnOO841jeOH18Z+2Tk
o135F8wA1WVWZbQjsjm7ddBEuoPFt9PLYt8KfXS82+U3tem22giz38K+C/sy
83ICJ/Wi/Amm4fSCoI27NseqPY+pCZqAk0zbneLdTeLbHdzrZZ4UXAgvVPb0
spDZD6pCbt9Xux+v72MEExW+oTryXpoRMgfP+WfBZMsh/M/NDnxfZwSO6cZD
vrnOO9Ft08ibM12XE03nPsI9VO5xZXGWj/4x0ekni5ZJghnwXm19rtxPSaO4
qTURfiAnvvPPCHg6znVnLYoMI7+MC/yPgf2FJ+WupL+I9qc1Xp3L2CL+9Be+
87ALJcI93/5LayP9UuF5Vu5zgt+U9wv2VstC53+mOPKAj/8dPOs03yvN82Wh
l/4k/8tl8V8F4l8oi38rfO00/XIi7kXB9uxI91JZ/IPhy5Io9wvHgWc9c3dp
jD/Yd5sWxDfifzR+8HxiOvsK/2Hi4VLV8xmFP1G7Xy/3H7VX0+LYO2xSHMA+
HPjY0/vK+4n7au74SOP51fJfVRbuN1mRb05ZzAszK+MbZ1G+ML/478Pc0ihr
X7X1VPqx5qdrFD61NGj5VWneE32LaCOtrZaIxsU1EWaPmr1q9rW/13j/g+As
1ufcXyqLMzCn1Aa++wviG2XwbXNJ8BN+H1wabU+705b4X82ONSfrzFHKe1t1
+Flv3ih3TnWcgcK90fLMv2weRoYz4xwvsstZ3lXZ8Y1/3DRtFWmIu8F52VNC
xoe6v/PPo9urY31xeauQT8Z80gxzXxjufkH69eL9KZqDjlB4fG3kzS0JeqGb
f1QdXBzfWWfz/Q7j5987D5nmAeLr1aRnTM2McZAxkPOKS+S/OTvcB8rijsxf
kpPlZfGGKm9ILS2LO2K8KcVbq/++KyVYXBb/HeCsMmnuzAh3mf3cuVlsnLhL
7P+zKsrinOTf4sljjGHyv9Mu5jzGHsZe6GQMh0+jzasDSyM9/8AZXxD1pI6M
T+RlbqX85aaBtiFN37SoP3xY6jGDMflVpV/UJuyJFwvfA+L5Z5K306tjvdCo
m7P+QDe+SuvlJa0jjB/79Kay2KfgPVjyoQN/oriPBedkhkv4lcwY/z72GMi6
BfyswdM5G9wz3sJlfmS+ZH7H3Wj/rznhvz4z1g7kn6qyNirf1z3jvdxRpnVl
Sejg0ExcC+ls3yjNwaynsAFIt3y7LM4t/Us/+zMaKz6VvwYeKs0jSr9S7dtX
dRysNn5ddVzaJdbkrMcp82GX+7zcF6BfNB0hfu4q9wzOrSludOc4ozaxZXzH
f0Sr4An8OVrfn+gZeTj/xDko3sP9TN8/Nz2crYE27tANaxXxnK0FSNf4/TOn
51wkeDhvxnklzi1x9oizUfg5v8SYwdixRfU6uSr4gT17uuMZTy6qDdsEa4z1
nJXrHGuSjcXRf+gH7D9z1549aPYJ2S8kjneLOe/IWcRdciINe4i4ze1n34D3
n9k74Owi6Tnj+O8apXOsUzhfzJ4f6/TGOvTKifOq2a4L9l7SsOe3V02cQ4ZG
bCrQTxvNLwiaoIe+CP30QWw2q8vCboMN472ysJPUtA7/CpW1Xvx5R/53RHN3
6Xgv18V97z41cee7ICvsPdjZGvHh75gbfITXjNf3lAaeiszA8VJd5Gd+mOq2
+Kx9IvGd6n+o8k6RzExW/D62464vC1sua+Rx7mvVrSP+YdG5n+L2FSRlBu3v
m372xT4oi702bDXEU1f6En0MvbS+VaRh7wydapzHB/CBt6ok1haEK+Uvahn/
B+H/CS2lT1ZURJi16jB05qz/7ClLxfvlgoPRd1mzqG3f7RnpvuGMm/I90TTc
XcqDnyU58S4sd/E5U8j/SPgXyXvK9z79qjrsVGXl8R0aSNNDaY6pjnJZS24U
b0dUx3qUNTv5kOFfNJ8O95qavpLn/sJZTfw7vG5mncxaDto6mc5Hq4LOwqw4
/1Lr8zDHV8S5K85c8aY8Z755R4e4+vI4I/p66/BzZubI7rH+ZO2JPvZJu9DP
urUOGUJ+eCO3s3nyhep9RecY98BRZzyUw1v2nAc+RPkPFQwpDj88xy6Ke4jj
e5RGemiE5jEVUYdZ4tVR1fFeOmfVOxgn/DxWMKs4+HqM/dgPhrqt5zKPK/3A
7LCTYS/jrP4CxQ9X/AGcSxHP6xX/Z0l8b+802HPIu6/S1CiutjrOCaMHjSwP
Xaje8eTFxgXOQdkxNh/G+QbRsEb0DKyO861/tomzxZwhflX+farjLC02yy8a
wm75hOL3ro6ztLuXBh7G+8dbBV5wPq00/6uOM7YLa4Kem7LDxkodsAdOU59d
2jP2lZCp4yxX2P4qysP2CPCfP/7xx7/+8H+VEW6F/ZztPRAdrChkuczyPNQ4
4fNZov8t0V+QGTZ/zq5hnz/Kfs6wsc+FPRgasXN2Mp0DOQvfM+LXcb6lZ4wV
pCUN9GPvP8Y4+R8WePknFriJbzwvd5TTXIYuSr8uCb3vBuuNrMHwcw+Su/Dc
e+fO+2LJwLK2cR65HrsE5+rk/72b5lvp3Nvl30d0DewZ6ZDx4y2f3H8a5TtQ
yCw4uZf2QHn8P49/5422PNMHcY+3n/vC3CnmDvJUyfehFWEDPKQi/CdnRX7+
wVeUFS44i7Oi7DEu6yHOFQqmioblon9R27ADNeLCJlkjd7jfF+jAHYe2sYf1
q3h+iep1b2acAfzT5wA5g8ZZNPbwNyh9EvoY/6OrDj/pcQnPKom3rG8vj/es
sdlf3DP03pNrg7764jgjyRnCH5U3tzD+07ciI/JB/9tFccYLOr/PCj0d3h7s
+3zcE+OO2CjfOyOO//yBh//3nec059sdaf9hvrvNveyDK4In8Ba+HOz/jC5Q
He8RDe8Wx7uI5wvKGRsrIsxbl+fbz3uJzJfn2w/wjiJvJ86Se3FF7OWdJt1s
QM+Y72Y6nn8GMV/OchreUONfIZyluVTuJRVxvgX/ZRXxlibfZzsNOMjLGpw3
pojnbSnediIv7zvN9v9HeMPtSv9nj3NK/B9ppmmg7Jn+XxJ8Gv//eDXE99zh
2WH2t8gJ+UP29q4IvsHD11S/1Z1iLl7BnoWgieaIOs6l0lcUXyN3JXZY+QvK
Is252eGSh70ezhce5jaap/Y8gn8hse5kj0ppflC73Cv/Qvk/lb9ceO4oD7kj
3eEV8X4O+/fQDz7+e0M8Zykp5zGXRdwRjofHl5rnyCE46UfQgPyTplQyXi54
TPTfpjZt6Bz3DPpK32il+J7qZ3eID3cKWjOXy613Gtb908vDRpGkciaWx/+j
HlC/W9AzzsyDnzsG+NNyIs1Ytcs0uWeVe90kXJOZc5V3lfxTyiOO9R3rPe6l
Xqy8k+Q/OSPiyMudVfJNct7BuYEXnHerb95VG+E+FZGOe1Wcr4eeFcJ/aF3Q
jw0D3ZizMpyT4bwMfvRkdOlZxKfE2bWs6rgDgk3l7PKwvWCbx15/ge3HRYKH
SsIljA2ZMkvN5xtaRRngbyxvusaGb0oCJzYb9lnAif1/vNolVzy/oSTO6V0q
eEEyMKAiwvhxZ1nPP68y0nCWjzN9lzgeHkwxH+DfVPOKPVj2aNknXqb5N6U6
5mv24dnf593wd4vCz5kB3LvsZ8xmPqDvXFMSea8uiTjG983S394uCD/jPDZx
bOPYyi/NCfmeYJnEzzle5Hee5ZMxep7j+WdqanWUw/9WuC/BXQn2jNgnZj1L
+c1Mf6r9/6ZvEem5i7G0POiDNlzCJVlBEzp3S6X/sFWc4WEewW6wo23Y4Yi7
z/FTpIdc0DPsCZydIJ7zK5wt4hwS55NY18Nb1t3sjUMne9h841wT7xS/3i78
nFnCvcd+yqRs8J9eGWfiOQ8PfUtNP3PL7e7X2CpIj52QdQN1Qd/AXWw/9FEH
zhtypoN2pJ0v8VjB+8WsWy7zuMEc8Zrf0mXNgd6PjnSVZKt1RfANHrb2+Ike
1dJrE/Ro9Gn0eN5CaVcRb6AcJZ691yn2vq6WbA/tGbo38tu/Ivoa+Smvp++H
rm8b91XBxT8sWKeAr8bzfq39PzQPt5393U03NI/gfhl320rivum7xsm9L/zc
P+1RH/jR/yepz72t9N09PjGOTDJd4D1WPJ9dG37wHy38xwheb+s4p/mCcy3M
s5rHi9pFPP/AfSAj4nnzq5fc3oL91EZDhONwwbslsQ8MPni1a0XQQP89VN/X
ibb2il+dE3xjHIA+0jFOEjfA8a/KXSHYqyLuq+5qPIwNpIH36Ap851/Y8KCD
+cDeBXsY7AtgK8PPXsbt0s9vq4mzsdj9Zkrm3kr8t8e2k73C2oh/TjL5en7c
8+GOz2m5ccaX87l8w17WPCfWIKTBTntqbuDmzO1d3CetiTzYbe93mmtsZ6Pc
K8vCPozdeD37/fLXZYa9mG/3siZoE37SQNfFzostGlszdubrVc51NZF/dnXU
hb1C7uzwH8DFSf+tK/KaxB0f7glzd4N7nPi5M9SlPuQSOUR+37O8IZ+11gPv
Ujv2l5xtKwk83ClqvLdUb5zc96rxGo31GH7ugVE+6z3WemPqYk0IfW3bhP+T
jAjjZ514TWbIGHJHvS4XfF0c9SPMWT/wgZf10eWOp+71beIb8eDoVfGf/Pay
bL/vfkp/Qt7QpT5OCvd/9vPv5rMq4v/N0yvi7SF0MGz0xD+QCP2LPMgjcVMd
37Zd4EE3G+y8rC9y5ebQpzLDJfw7ewGiOUv+bzLDzbQ/w370a1y+bZW/Vnp7
tvzPZ8T+eq5xZhs/8aVq0zz5D8yI8qkD596XuT7UZXKT+Pch/2/biu5REf++
/B4dqcL/ds+OePRV9FT0V/71Sdwkx/PfddK/nYj/xM2oiH/FcWYdP+Xw/Uyn
ebomdF3Wa3dJn7yvbdxTu9f03Gf3HPtn2A+e4vqo56CM+Nc5POf/2g/43+dL
/C/0KY6/T+PSvcL/ofBf7v+D84/ySslzS8Fk9v8Lg9fwuYAxW7AReZabJvia
Odp+7kLlFUYYP+f83rcsjUWXFGxQuKo+0rC2Yh12ktdi6JXooFOzoy13lEe5
zSriXiv3rnAJfyV/W/WXFvJfy1jaOnRbxtts0ZBSEfezUpwef0V9hLkTxzmG
5sbzscbg0T2jb3P/EZyciaX8v8v/W8P97fUgLt+2KP4meGTaLhb+ooq4i5Zn
Xr1gPMUVkZ57giXGz3mOAvPz0vpIQ707NUQa7lyCgzR/ZMadM8ri/gjrVMpi
rXp3VfD1sJLYM/rId/cOLw1+os/XFQZN0MN30v3L87xoS9ox1/l3Sh5+qYl2
Zw+Xtk13vTgb/EZ1nDcu5Y5IB81nxfFeLW9G81b0Dxq3v8yJsYp3KpNKTE9u
7ElgQ72oIVzsqOz5kZaxiP1YzhKwJ8u5SfZuudd5ouagatG6KSfGVeK4/5gi
viXXx7+sT7cNlj3eVfVxBoq7d9wZ5R4qdr+ja+LuOXfQ2W/YLzf2WR7cRTpf
hzgzeFtV2HOx5aJLc7+NtwI+9p4MezEX+9wU55R4d+Lh2pg3Bviu6fREnD3N
FO9vzAx9ARddIr+bXJU1ulWc62C9zXqX+9+cIeQO+HDJ9jDB6zXxBn0Za0rh
e0/h9YIjc2MP8MrMGCuOyo29duzwnI/ljABnBz5sHfaRAfrWvkci0Uayfkqb
WHvOzwy9/X3s9oIi5kbhniBZKWF+76r5W7CoKs5Dgvt4pa/tqHr1Uh9Sum68
uVEb90E4X8TZolPz4v+ZjHGMS/vyHp7g3CrfiS2Iuz+juHOqck/hjT3V9ezM
eEt0X+nH5wr3mvy47/p568i3Sm3Ur0PcI6mQv3yXuN9zeJvYGzpA9e0q3n6i
NLNaxZ4QZ9h5qxlbKXMo9tIXquJcQHZ27P986v2gsZLV0uK4I/BzXeg13DlC
3pF7ztTvrrL6ton145t1cR8JOtnf4jwl8nSD1hTNxesPc+J9gY1y782OMxvc
r+We7E7xsLnSrSasfjRV7TJf33twRlT+69rGWQ50NfY0OdPFea5xKmN5TuzL
js6Mfw7jDtS4/ZdwPtpdayzuVpTEOc5T9f2EznEmlfOoP1WFPoZexh1r+gb3
VFe3Djs7/WS4+JBSHLbYn+pCd+PeFvdzx7k+W6tCj0MH7MmZStF8vWjeT+n3
RY+pCVsQdiDmweMU/rJdnON5QN+XCLpIbj6sCh0NXY+9Rd7uZ2/0Fd/lwqZU
kBN7Aryrz1lA7ASEB2vd0a9TrJUrOTuo+AT6hpydonea3MtUzqWCIxX/iGgo
zAmbFrjTjX91fui11LGb5G6H3DOVt1nLsFVhpyIfdOD/lf+QClbmxL04znx/
rbJ7lsY+Afd2edeF84vsCbCPNq8g3ioZrHHpUMEloilL3/KF45/MmGeZZ7AT
7s97lZmhn+wQjr8Fm9QWY9Qm25RuhMo8UXUpaxV72Mw7HYX7p5w4m8q51NGc
Ly2IvXHO5Lwh/7qCOMeS5rGcOXqu8h6mfE1Ecw1vXOTHft+j1nPQX7aq7/7M
Pw1bhTz8KOjA/K68nbNDPubo+42CT6viPSK+39089rPYy/pJOJ9TfbuWxPua
y6v+O+/2brvYy39d5fdU33pLcY/lxP+WsgXH54aMI/OcQ8iXvLVVu5/QNuZH
5kbmtTdaxztHjyjvq3nBJ3TIv0TnWv4nlxfjPvtAUzLjnBR9jDNUvTWe9ekV
b0uc4jmE813cr+GuDfde2F/8S7gvUvor1CaXC1a1jnMAs+FlRtyt4U5NkdK2
zbNc69tB4s2BgllVoYdCF7poi7r4N++xvFVSE+dvOSf5c33oGegMnAHkvAJn
Feir7J8xr3XLjjmub2b8J5d/5D4nnAnh3CnaPi6Kd6D4ztuhzIkr6yOMvtFJ
bbIlJ/Rn9A7kj7NCnBnivCLj9LSCGAP3Ufou2TEmNq+P8ewewVcag+d2iLsF
jJlbBV0z4y0V5h/se22Vvg26aU7otn0yw5bLWTbejOcMC2fgOIOVkh13M3ZT
3h2cfeI+RU7ohOtU1okqK4WyNNZ9qX7yeFG8DcK7INjDP1Xel9hPkNzekBsu
b2OWqa412fH/py1qh9uFZw/kWf7b5O/He8jK+6Lyts2KO0ncTeJuFvfduOvG
veNVql9yXdh8GiQj9Zy7yoo719wH5wzPzuq4t8nbI1+Izs81Jt/MfbG2cYcT
uw12wC1F8fbIHPYss+INtxvlr8+Ktxy5Bwst3MFE/rh/dYrXOMjO3mrqjrwf
khvzwCrF383dC9XzbJW7TPwZURh7/5yV48wh/6cnLfMFZ04XVsVZuhLVqbgu
ZOgQ5T84O+55XcoZ9uLYA12jNrymLvrb2+lqf8GvybFPzR419s8DGkK2Gb92
qN5J6qe91KcPaoiyKbezaNpL+EdmhV5K3/1fItK0b4j4n4vCJoLdg7mEvQz2
NL5Q/V7OCR7dIPw7NIc+oj44VfX9p3281bTU9j/sWlfnhp0L/3i19emCZarz
3aWBj72RvpKrdzSXnN8y7tBxf453PGYI767MT4zpyvey5tFenIeV/zjBfPmH
ohuKnuuywv6CrRk7Le8McL6D/y78e/+8RdwN53tnf+st3kzpGntP3CXMyYz3
/XJUTo3GoutVh82q10bxZHFR3DN93Xdj2e/AVsfe+vuS3b1bxR477xwVq75f
ZMd+O/a7Qp8NwN7G+/xThHNb+3g77dt2cZ6AOnA/jrtx3CWfL57PE9QJT9eG
sKmtLY5ywYUduBjXeLkfi32XfyBgK+Y7//PEpviAbbM1Kq+d4Bnqylgv3r3H
u0ySqV80FtyQHfjAwf8DeG+H+7e8JcdZI/TEkwV7S8cbrTrMVZ1vrI+7CtxT
4JweZ/RqBTezDs2Nf7X/qDTXC/e+8h+utr5ddb+2Zej0T+fHenyl752w58yZ
156cDckK2yDjPbY+cKNHDJSsvqjyXxAcy31Sztbmhz6wQDJ5i+Bpyc4ftK3G
lv1E50tVcQ4WHf3A+jgP+xdnM1r5DSnx9p1W8b5V6+Iov0dO0IyexDoffZp/
uPN/d/6Nzn4+9hz29B8WDTvahW3yZ8nP1s7xVkSOaMwWDBU/vhFdXwtatom3
vC8pjjMJvIfHmfWLM+NcDOdmOBvzsvK9RF7Vcb702THyf6a824T7187xhscq
nyf5kHUBdzdyg0fordgXma9He96m76dIlt6TP1n+p0XTQfmxRhqvMndXmX/I
305l9RTfRqmsNipzacd4H4tzvjcr3fzSOG/K3TbOoM5jvc995aw4+zOiTZz/
GSL+Hya4pirsEuzpsn5H1+KMOGtbzjvfrrS3lca7IuhMIwSDJGMXqdxb1SaV
ovmX+njjC9sC7+xgQ2ip+C318RYZ7yjwngJvlKHjciaPM3jrc2PtxVmpSuG8
SvUaJ5wTlfcwQUZ22GVYy2KnWeL18bqMiHvD8XNZTwteyYiznV/xvkdJ2BdZ
D2NvXKO6rEaHYE1aETbFCei6hfHGDW9N9EPWBVkau3tlxH/p+Cfds1VxRvrf
9XZ16N/cd+Dc03s++9TgvI/x5nV97FWia2VxZkNp38yLf9yBc6LS7KnxbZjk
pHtxnMVeIJy3lIb9b2/bAHmHjjk/OTvePuTtSd6HvFB17FwT79v0k8yeJjxj
W0e+vWxX5J4P5xI4R/BgRdhHiQc/6x5slUcp35vt4+5fRV3YUrC7YGvBLoPe
s0m0rhRkCm6x/wP+5SF3lf0PiZ6toqcfd3CE82Xh/Fy09ZF/LefPSoI3/cyf
sRpnnlT87eojI+R/RP758u/CmYb0SDNKsMLlohP9mhV60QaFHxJ8rHL3zIu7
MXwDfnGa05xmmKALOrHgqfSw13PPm/97YMMnTJ5/+Cev4ENBXka00+P8i1Dw
hCBHsLvK25kVZ1+3qL6J7Ahvlb9JdoQzM2LerxFky3+v3OekA6wVH+aonvNK
401D3jgk/X3pkaY97wWzjnS5vFXDmwK8J7BN4dWC+wWLTRP0fG/axtsl/nq3
D22WK3hNsFDQIj3sBzuywoaQnhHxowV758V7BnxrpfgqwZr04CN84lwGY1yy
YLF49h13tgtiHw2eJWcE37bbT7t8I3+K/NfIvTE9+AJPvnd+zkVconCG4o+3
roQffYk3lF+VvPTKC/y0zcOCPwQ70gMn+zns/aBTHFkZd7+59w0NO92Of9v/
iPP+43j2/dj/g4bn/F4I+4B/Gz9p0jKCR/CnU0bQf7zbKisj2gsefywYLmjH
uCl403x4weVyno17WcjaRoUfFaRbrj+2bJ+s8bxOY+kDSluREW1Jus0amz9W
v+ir8fAshVP1LVtux4zwT5D/DfOZMYrxJ81jF20L/XfLvSk95Ayamymuuen8
xuF16RHXzO11k+s/2jxs7vg5rvs55sN9lp9Kxf1i+VyjuqwTVLSNu7QP+q46
7z3xPhpnvZapH9R1iHdwiOPML2fMytvGeTDu3v4mXE9bbp+yfzI8q4h9z3//
s2I5PdV9nXHhasvgdrfj745HJntIh+3eJexY6xX3nmCW3fXup3+mB07wLPM3
4p91mlFut01uO9624swT+1wFHmOQB2ThRbnjBM9bHqCB8p4xHvA9a/wX2l8i
eD09+jt9/Gu+C0rTY7/uBu6BlEaZ3BuAD1c7D2Md8vO686J7NeWMIefwK+J8
HXxmLHzGvG2ZEWVdbZl5zTz5yzRPNr2vOX2x60X8R+kh0+nuN3+Y5+UZEQ89
yO2S9JBV3nnZ7vGHsY03o4jrWh/7iNg+bk2POQWcjGWLnbdDRsj5G5aFp0zP
bh6viN/q9NS9m+KKTCuy9LNgkeu2zHL7qeR0q/pdZ95O0PjRRby6THw9WnGH
to/3o+4x/YxdnEvijBN1uNd4aLstNbHXuVnx1SqzrfsX/Yb+g3+y5tYP9X1D
VuB82/X6TPWeWBf/R+HuF3fA0K9b8V5EUdzxbO36rTVP4Xuu+fRRI/+V7u/8
wN8/I3QX0p9QGP9goexvXS5jLDL1lv1f2M88whzwl9uIeuR4fGCswM1Lj3Ie
zw+aN2vM+ic/yi92Odv490h97COeo7imLePsBfNF77z4z/S/58ZL4n0Z7n2/
ofquqw197M3aCJ+RFXePp+XFPW7GF8aZuwT3aT79qkO8o/yTwlvcR/I8FjEm
lKldn2gVZ29vZW9X8I7Kblkfe12Tc0P3O1Tlj0+LvSP2kNirehq9SONU59J4
55W9MPbE2G9gL5gzDEkaS37qEO8uX6B6JOXFvg52Me7ScI+mi/LvUhpviPUr
jTPB2FmKrOeMs9wyx99vOf3Nsv2C+yHzCPPYdvtfdPxkjxPbLPPM3YxfD7s/
InuM25xB5uwx55AXuQzmhVb8IyU//s+OvvWr4xc6DTSs8LsLvLcwmPdBWCfl
Rz/b6rZYL16+Wx93xrk/zvvVvGW9zWmg7W31tY3qV23UJsni07c5ocvytv4u
4l830XYu75xrDfBim9CD0IeY74aqb/5aGDZA3pPmvUHel+b7UU7Du5KLvBf2
m/rQtrI4c84bArwfMCwv7mU23nPl/AJnEdiL2u59KdYQnCXmHPEOQYfSeKN8
Bncu1EevFnycGWslbMO8aVlSH/vKZyvNeaK/j+h/SfTvqTQfZMZec2ld7LOz
375nRtCM/o9LHdD32KtkzxK7czPvl7Ine4xwthTfbmkT7+HxLh77m11FVyfB
9+zf1MX+I3uVP9XHOV32PVmLgYO3Oo8vjX1E/pM3t23sy/K+cQ+fmeDbBPW5
NkVxp567sOzncb/qdZV/TC/xUt+GiZ5WCt/eJnSevy2TCa1lzhWsUZpfa2J/
dGpu7Ft9Xxd7gq3qY297CntxdXEmgfcovu4YYy7j7QuWc+bKp90XkNlq61fj
LKf0n0UeD/KsM6Oz46fvH1EZd494B6ur80JnH49pk9JjrZFjnK2t85OX9QJz
OTpa54zQ48/xGPmtx8y37WeOSlIZ81SPuXmh32JD7dQs+mIr6yjoDOBEN2A+
zTf+p+ynr6HzfefxvLE+E93fi0znW+LTa2qDM4ri3Une2+Ktre4ZMfeDg/mf
OZi5YqP9xDMnFptvF6VHvZi/emWFjZb/Cu3QeFbaMe49o4eCk/47UmvM1RoT
z9ca8xq1baJdvLtHG4GTsaiN52LGnx4ZoZ81jtmV5i3jVUvHr7H/avurnAY9
9BuPXcxTX3tu+sp+xvnN6THuZwg+F3yWHrrTsw6XOA4/uhZ1+cJ4PvW3xvXs
p/a/5TTXOz/x29Pif+fHiR/pgh/SY66hfMbEP/PjHh865++WW/TN3z0O850x
9jWvMf9w/BjTT13Qbf5wfVlXkZb/kjO/s8Zmrt9NbTy2MN4H2DUv3tjDzom8
fO96QduPxvmV/V+67t9bvr6yjI13PX5w+v7meZ7zfeX4y13XDKfF/0la4P3B
/pWmEzvAXpy10Hx/L+8ANsQbhQ/WB0/oD7T19ZqPv6yKO3C3mkbwbNF8+3CH
eCv9O9OQbvdL+5Ez9Gn60XilXyc97f6Wca4VmzZvU5ykb+enx3+getsP/ew3
86YO/0OcUxN7+L9nxHpnRnqsm/iH1AWCsvTQ/dHx0Bl/V59rrvFtX42bB6fH
f6Zq1F/mOj1l8bbQDr811FFxZ6fHf5o4G7l3Wvyv9JyceKOIf2JyPp1zv5z/
RafgnBlnPPhP6l6CAYK0hvDzn9P2xvmX/IeaZvzQcrBpWCv4VdAxOd6S4t0Z
9iveVdwfguHJ4f9TcI38DcqXSv3S4t29Q7yv8ZbCvxlPT33v4TRt0gMPede5
rL+aSldyevBjt5spGCxYo7hfBB0U/4bcbYJhyUEn8dubxvlK3hrlXVHmvhSf
O3rT6cnbeCYGu99Fxo+fNek55jPj2UUOPyPZ6N8h3qS8UuHTBe8L18Uqq6Xq
eFfTGPvRe5gLrlX/OjAvvhU5Pf/S4p+J/B+RfyNy/557+Nz3x6YxzXJCH7ki
Pf5V9r37F32NNelpHhP4Z9cppgEZO1nwivwH2V9mHCcZT639tCnzF/rei5b7
0zwmfK5xeo1k8oaiGPdYQzKeM7ZgW0H2sangZ87iHzvcOec/O/S32Yr/JTn+
szbb5XJmlnMunK0F30XGyf9y9xD0Swv5vsP9aD+Xm5Ye/7Dl++7Gd7lxnuS6
0QdZr7Ju5f47a8pn3L/4b3B/7HlpsWe5ITfk8RzTQDnbVN+ugvMK41/EA5xn
s8uiTlnGAa3MO8yj6KjsUQ+2bKM3dRR8KZlqp7Fpf/WRGdkxJzDmM/bPcV9r
7zrsTIv/0PG/sH/sr6mP/NyF2eR4/iNWnh7pGR+I35EWfL61NMphX2OI0hyW
Hv8Yu9PylmZeltjP2m6V27pCkO/0P3LGu3Pcq37PfZl/7nEfh/s53N+5Xelu
S4//wjFnMoYy5m80PfyPj7x/p8W/4f5uGv2ZvtzRfbtTcvS9tR4H2idHfyaO
dGvdfxv7Nt/BvdH1fTY5/Py77hCPVZQ1SP4D4LXCN0l+5wgelEx+ZHr4byBn
HblLw9m8IaXhck7mR5815WxpT/XxN7QGO7tl5PvI+KEJOv+Ue0R6xPP/Sd7V
nt0Qb2vzBh93PtkbamgTZ38Pkv8Cfb9QUFMQ+/6c8eM87eSuGicEK6rifEiq
zwRyXpu3nHnHeWhlnNE4vyj2c05viD2dtwoCLzgbGiKe94h+lywfJ736qaKw
3TEWsf5i3GSM4+wf8spe8x5NY+93fEPgOKQhcLYTzkNN8yHGPd7l1orW68Sb
I0qDn5wR4F4ScwLvkIF3E2t0uX8nxfvk8Ic3yhnrmRfeTouzTvCGc9FjGseV
9OAfb8Kxj3KF+yDxhwuap8d/P+nf6LnoYM3SA+fVyfHPSf49eZTSfC9/U/lX
psT/KvlvJf/gK3Ie0kMH/qvk76S5uKNgXJvou/xzizrUuVz63Wbj5L+W3SQj
XXkfrTLwN3H8Ny6L/2MeqHo3FYzLDj0WfQybyzW8y1kY5wGZ54/zmIxegA0I
O1K67a603R6uP3XnDWneluZNadYErPtZFzAvoAcNM72k5z+Dc0TfaMHs4hiz
x3jcpu8c6v7DfwWPSo//EK732DnKMo6sb1P6aeLHWdw7yo53C3iXgLcLoO3o
9MDBvWPO2XPG/gTpUId0DFp3M37oH94Qcx//C0afOVHwkspJaI3bV3PrYOlx
QxrijBT7dPxX6fec8HMWkr1c9nH/p7HqvfbxhuE8rTHn1sbZLu5pceeEe3CM
V9elh779t+8hccfndPXx1cq7UHK8UjT2U38ZUhRrL/R1dPUT6+Jto3dVp9T6
+IdS4/mbez1PsTey2OnPENwg+DAtzpyyv8qeK/82IQ93e+ED/GTc4J+Qgy2T
CY/bxPGfuPfq4k7NmW4jcPLf2yPTAwd9hX0D5nf2EZiPsf/BV/jLf5cXSTZa
01acb0iP9mYcO9R+cI4VDwZ1jHSrtBZbKfiydZw/op3fbx56MboBOsJQt1c7
1+NIywb1OCY9+gHr0Y/dP/kfZHVJ/GMF+eHfd5xP410Z3rbgXQvWkh9ZbpsY
D/33RJeHbHxmeWQ9xZj+amHYj4qdBv2Hf2sy/zXycojxYJtmL4A3cMB9rOPr
fA91vtr9ffH7/Zzg+WFOQ51Gif5abDhK80dV3J/hPSTuQPEvP9LfbplAHvhH
93DL9rGuC3jq3MfRzY41fdBwlPsO/QJd5BTz9qr00C+pF/+m5f923O9M87qC
NcXk/Ni/bZod56PZh8Mekm5dif3EGt+vnSP6z1Idp9ZFHuT0TMsA914ZhybY
hoRug33gW96iEVRWxpqActtb7m607HFvg/sb3OMAP3vKk9Lif4vn5kQ89/p5
94Q7+6yZ5nqsuxEds1PYyEnPuymcl5tm/NjGsTf3tL1iYEb0MWjm29T0mOux
E2AvwP7AOujsnGgTzrNwNubIpnEvknpyT5J87B9g37vH7UffpN9jF0Cf2V04
+2YEj/bIiDykX+K8lD8gI+xu0NasLO7GZ+aGDYfxADs8+2ln2c8e9e62EaGf
TzP92KboY6xBsSPtatt456L4b9yU/Ngfm5P+31ptjuWEtS9rYNb+KV5rY5/H
rosNjX2T3TVOvqN+vlVysJfS9M6I9sdmgk2HOQPdcF566Ie8/8YbdrzVxjp6
QXqswfkPMHof+he6JeMqaxnu1aHfc39ugco4tyTuYvO2E2888T7V6ZbnNLvI
N/LemvcjVL+S/MB3rXGe4jTIP7rqraYhvSHknbXrfNOGTnhzeuiljPPYgNk3
Pz0t4m53/HX2U8ZG5ycvOO4w/gssn71dv3nOC/13mrabnZ782JNpY9YCNzvu
WdNzi3F+aj94OD/NOeqrmwRtNzv9AteRtcYdjv/ANN9pvl3rOpL+SLXpq+3j
beuz3BeQSfTkTdbDe1vWkGHuGV0hSEkKmwq2FfT/sY4/XjCpJN6b45059oKZ
16gXb1jznwTODjK2sl5ArxilPFc2hH7Hni3jA3oLuCiPO017uM+im9/ku3Tc
AaxuE3ft9s8Om15L2zN5X4X3F0jHvajLTfMg9EHBzOx4y5V03CnArvaE+1uv
9NDt0OtmmzZ08szCsFWzdssvjLPe/b32Yj2MXne2xvLpgl1Zy3G3XdCbMaQw
7PGs/Rg7p9SF/A0viPPdrBV5A5x/cvAGK3oXY/0rXj+96zVUc/ONsphLh5n/
Pd0X4VEz7+/R95nLqtJjjkgrjH0k1sDpGi/37xj/yEDXJQ3/g54munplhz2o
mfmArPJGIe1WmBS6HHoAOgDrJPzM3dV1cafrHbX7863i3cxXeOte37ulh468
D/pWRuTD9oldgPm4p9Nge0HPPUHQpCHGtQOM/17hm1cSb2i0VdxAwXrqkxtn
iDk/3Lkh7l+9o/lzoGBRQZx7nmrZAR/jP3QM8thwiseQi/PjPgTpsXszjqKr
rOa/pSXxbgD9uMR9kHU0615keafD6F3ElbuNzhU/ZtTF+THmBHRm7JbYMLFP
YjfEvsKczjzIOQ7mLOZG+tNYy22+ywIn+1+z3Ef2Lg2Zvlj4b7ZcD28Sugw6
zUteJzVYnp+qiDc7uLP/v9LIPys7+FjsNGPNf8qFfs6/cW7twtL4XyO8/kk6
8lMeG6ssZ/Rl/l/DeuKr5Pi3dXZm/I/pFdG2IivC6PGLsyLdtbWhV/If+VeV
/hVBf+Fojv4oGe0lHXKU4tLZg02Os+FLsiLMOeIH5c/kPH9N6J73Kjw0J/YM
2C/g/xEpnIlOjn928L8O/nXFGd6eSvNpSqQ/1uGx9YGvSUqcJb+PvWaFpyt+
muDD2vhvDP+P4Z85/LOF/0nwLxfeaOAfOIwVyRqTmrYJG+5tyvO20u4tXJ/J
/ylrDP71mhPnjPdQ/E72aP0/qjk5Yfdt1zT+R/G0/1vxpNoiqS7ewHlM7hzh
mJ8b9uvhjKtZceZ0QFbo7V/nBd85m873Yf52cE28w897/COllz2q8f9mlX2C
/Cvlv4N/u4nGW2uD5rsr4nw+dLKHBN17yr9CNNzF+Cb/qK7CJbi1Kv41xH9n
+C8NdwH7ZMfbwpyBZn+bcK+kGN97J0U/pj+/kxb2NPoiOgnryQ4eZxqcBvnc
gB0rPWy8yG0b+zc4PTLP+bWVPv92dl2UyTicoXV5umBgm9g7Qx9incyYPa00
0gyxPDNmoq+2/3+0dPw/ps46TMiia+PLsgFud7NsB2zQtjQoiIrdYL12ASqg
YqCoKIoNigXYhdiC3dhiK2KLCogIooh+94/7cPn9MdfEM3Fm5sw8M2dORP1n
Rpj0DQED8ENnYr87OMn7F2uJvvLOzJsS/0F4QqriLYl3bNYzd3Ps+WDTBNs7
8xvNP8/YYmeB/aO/3JOsDeHYear/dq2R+XKvV/kMWB/7G2dL7nCcFZGjohyy
VOjnQ8faZtsVW3kM6Qv7blXsvTWxV0BfYf/hv8k8/aIx+0f/i+1rTC/lfwfd
cbVw8N4cy28dHWPC3AHPqNjTqmOvZnyGyB8a/wLoZ29lmlb2VNBZoLHsG7SP
fdA1FLQS6CFjhD+nNNueb//4r/0Q3/iHkfeSqAeaCd9JZx7ZP1MjP3WcGvVA
L/2+s9vkLjU69nD0IaAL4STB1l5tW6dfZJuWNa7ZtLLvoiy01t81D/uiQ0P5
WqL+7uFoD572i6JfwHZx0JKAlzHrHrjEmevrqHOd1vWZKpuqeZnc7HBv1XOW
/LObrYsJ3Q6/aS2/IHgf1bdDBe+pmuspkee1ZPdpRfSROOVfTTYOsOezhrpH
v/4u9L/su4CBtxJ4nXnLgH7MeEFDhn4OnJx7/4o6gacW2Yc2697ZJ+jRtDu3
u/awFtsHyK+z3QL01UOTo67lsaaBhbVMnyepzpQkn38+inTeeXoHLm0debBX
uCjwZHGyz5MTm70PsycTxpYNdXwa9YDvrFVwnvf6e2INYp+bOYe/fYfAGc5g
vEXyHgotH7xArzC0uJsCdsaBex77BXQR3rt51+Ze9E/MK+MJzQgZPvTZjom3
Lt6kRpY4DR0CnAk4w/OeyHmfMzznjec0riO1R48q8T89JdZRv5hH7jhDYy2/
H2dS5pJ1umvsDZyjaI/3M9qHbs47FjTyGbH3ckdgXCfH2NbEvLD3Dov1TBwb
7shEgnN/xxxBG2+N+qn7zKiH+WTe3o3+gu/MxQsxF0Njz4Q+B76lBT1z69hD
+D4k8jwe/yN0pi2KMYKec4jGZqH+X7MqLA+KjpNxqaaNQOuCJjk117KzyD0e
ofxPKP/NFbatfFqWy0CL2ifKEIZeti7g7xP7JHtm39gncX0CJycIz1u62S40
73Hwr8C7skPUA30Gf4fAq3fyLW9PPsamd9Q/RGv/zjzDSf5dA4Z7Qx8juleA
GT2R6Mj9FB6kHMvJ/FwfOhAyvaaGx3ztp/1zSb754Qojnf2f96vzY+5/a3Ad
mapzrsYnU/35uMLtjwoc+l15dsq2vA+6J2ib8HHK/6z6Pl/5W7Uf7iZ83b/K
+l+RQ0JeiztH926+d4yKfjEOx0b9hJfGOIAnQ4ULhzfbHhl3kX6B59CK+8d+
zv3ssFjvhLmzcZfk+2aacrIddOUDkr0XHBZ7aTKyKS3mgf6zyW2h6w5aGnhD
mf2jHuauQft7fbXtvzxc6DUwJtPv26w36FGDsIsl91uW9+ApUSd3h6tifZGX
Mpzn54T+GPTYDIp1zZ1rXo5lRJH3BNaxsR5XCs4xzaYRpgYuARtnc+yoszag
PZwb66cwxo31yxkHeh93vAFbmRYDHQB6/pGRv0/gNnjI29iAyHN5hGckGU7K
kkZ8cITfzLdOBeCujDli7Dc0eRz4/wyOtUz+g6PsQUmmd9Ivzq6MwaDIMzDC
jAn3J+5RvDtw/4Xexfs1vDldg7dnE/xp8QZ3o/bxY+SOlZsT/nFyN4V/vNyt
2HvA3oLcL+XW7ztb7ub4foLcLeGT776+tlmFLtcbOjg/bcxFT5zcKXJ3oUdG
7nS5e9C508FvauhxQocRdskf7GtbVugixebVzm3WQ3BbwEJd86K+U+Xmhz9O
7vbwx8t9KneH3J285QXcwLu63P14Q+451f+s3A5q62b5c/paFx66cX4tt74b
5P3R2YguizdjDOjfCcp7XF/bEp8t//q+1qu3NMYOeN+KvIz3RwE38L4bYw1M
78QcEH8/YKT8B1EH4/dh+JR/O+qjzMdRH/3+JPw7wjEGE6L/E2Lc746xZ9w7
JrptYPmng3X8MCYdEg037SQkus/E/43vxDd1sG4gyqDXE71I0JUu1hhM62v9
pAugXZebHpVb6vd23tF586Msb5cPaT+dIneO3MLwz5V7OPzz5B6Tmyp3gdyj
cudH/Hy1c25f66I7Qefw4+QWaA96JMqR71p9v0YuR/DMlH+FXJrCiYnuH/3f
KtFzw1imJdpnLDMV/kz+53IZicYn4umJ/k68c6Ln5qP4dmfg+Bcx1uB4SqLn
FbxITbTP3HZKtE/55ETj6PvR3l1RPinR88O3YwX70X2t5+ZUdFPIfVdj3Wno
/DpK7q9W7ck9NNc6Z2Ylui5gyU60j/60BzQuZ8qdlWqZywuyzDeys+obLrcA
W4SJnm/mv1eiffCib6LxBrj6JHocifeO78R7JBqfKH9ExKlvjFyLXKvc4XLt
8W1Ek3GhNdI2BT7mI9fW6Lfqh9XHheX+FwxMdN/o07aJHlPGcptEjzXxtkTX
SV39Al7GeOvwyTcg0XNMXYdFGdo/KvpMn0ahM6/VelbROYTuId7jH1X6Bdwz
q8y7jDwjco33JlhPB/fKPZXnvVbr6Lsb/VRyZ8jdEz75joyxob1DlP8T5R+s
/Af2te0u7G/9L2BhvI9NdH/oxzExH8SPju/Ex8YY05+DWYu9rUccvaLQtKCJ
QQ9jLqCJHRf1MX79E43rjMuOiV4P4PttcifJnSx3q9yJEb9F7oSIz43vp8jN
lztVbpzcvEgjfnukjZe7MtoHL9CDiW7OR9ItRzyyyTp5JsR8D4o6gGmnaGeH
iAPH9hE/Nb73j3b6xzxPzXJbM5l71f2u+v9OpuEYEG2gbwwdZOj2uSNgpP2b
5Y7/f/3cLto7IfBvu/i+TcR3ijHLCJi2inGcFbj1vygDznaOujpHvtnxnfm8
IXzm+fpE4wrlb4w0cGFO+MzhTeEDyyDN+9petl1wTaLxmzV3VYw3OHJ1+Hy7
LtFrlTaujbzEb9W43SJ3hdyDsWecLfd47McXyo2XGyA3MNX3BMLcL6qEd13l
dq4yv0J6nMuH6FuuXJ7chCg3KFy2XI7c4PDJV4z+cZ19vpc7LfINjv/GSLld
5SbKDZUbJndGqtsgfnrkJT4pvg+P/W9nuV2iPyOirnOivlHR113i2+QoR5lC
uW8Ey7dy+Qp/Jf9ruQPU11U9rd/lUIUP6W1dC3v3tt24zTbjmvx2naVy5c0+
syILT79JXyZXqfAv8lfKdVH45xTHC1LdDm0zNuT9MsXjuDzFcBSlGi7GqyTV
Y/ZDisc4K8a3NNVpP8pVKPxTittgrKmPuspS/X0FOrdT7ZOP/+pucrvHeJVE
fbuGTznkrNAnjSzSBO2Xp5ZYP/RX6GeXe0BupeIPyz2k8DdyD8otkPtJ+/1H
nWzbq7fwd5n2wAs1nl9HOfL1UvoXSr8A2ymK3xf1LpO7B73ynfxGTz0fI3cs
d4fcnXJfyN0d+T6Xuyvin8V34l9GHdS7s9oaLnej2homf6jcDV2tKx1dmcgP
LkPXXbn1x1bQB+Ys8KUg8AW8y4/40MD9/P+HT0WBa0WB74wx414RuFgW8RHx
vSTmgO/gyB7hgzujw+8qtxfrUK5abu/wa+T2lauVq4t84NoquT0jTpkOurMk
yNUrvE+Uo0x3bFXoTL6si20GoSfoSd2dFsRaYl0+o/3nabntddaakGXcY1+Y
rPAnqdb//6n8O+TuTHXa7RGHL4YwvDErG62/iv0E2wHkoxz8pFn9zFPaQfAc
qHU3C7uCWd6PKJ8RbXwm97zm7Tm5vzV3JUr/njUglwPegPesDfAj1fEs8CPV
8cxOroP4r43WGwRs/dDnIHeaxuA11f2qXAet8dJOrvvHVPOwZARfzt2p3o/Y
n56UmyZ3kdwmlfurl+0DfF1mmwrI205Qv8bLXaX0+zhHl9v+wn2p3svYk+4P
n/3siVTvx9NiHBkH9td7U70/Uub7zLDloPBdqd5PT485mBDxaYE3e0d9e0b8
gsAt4vdEP6j34sCPfaM/e0e8rJPHYAU4q/B3qR73IoW/TXX8/MBj8Le8k/Oy
fn6J/jwZce4Aj0ddj0ac+wFrg7Xyc3x/Isb9kciH7S30O8Ob9K7w8Z2+tpH7
lfbd5XK/p5i2cww6oNON96yD1XJvK+9bfW3/FrxfQ94Ur4NfUxxfJ3yY0Gj5
TdYS39emeJ1RB/nWa27X9bKNi8/kfyqXUWUceThgXaq09+U6V/lus0eMdSH7
Y6rHK1/hr+R/LZen8PJUx78KPOBcX9DJ3ymT28l4vTzK8P3B+Ia/IL7dF+W/
jbSHYm7wF8acLQxYF2s8FsltV+u1cXfgwmeBQ+DU5+Hz7cvAP9pYFnmJfyLY
bo99eWet45NaTPMbhrxai3WoJEGD7agzdEfzOb8m93pH8zC/GnF4hl+JOHzD
L0c8Ocnl3pdbI/e03DNyv4X/rNyvcovjG/R08i6VWy23KL5BnyXtA7kO8FTD
by33r9wb8CvL/SO3JOKbAkbiHeGv7ug+JCa5HPGEJJejrlUdrbuI9tYGXM/J
rZN7Xu6Fjn7bekJuis7DJ2u/SdT4DIVXGf00ZX63ncO7stxx8MbIHRPxx1Xu
fPmPyF0tN1buMLlrwj8cOn+0SXvjkFHrY3s4Z8g/vY/t3mzQt5difP+QezHi
6wNG4jWlfjvdWq6fXCW8kHKPyU2Vu0DubNW3jeC/DLs6Sc7TNcm6rNA1he4n
5u1m5Eti/vBvlbtTZW+X+63a8ivwsYMLbUnGD8b+CX3fS+565WlPchrzU1Fq
GaMecvP0/Ta5lcpznfxr+9g21Pom00ChKd6ntHv72HZQe551PgFrU5L7zBgg
BwO/OjgID/2GwMHmJH8nXp1kfALXHlJ956vvv+W7zytj/quS7JOvV5LxA1zr
mWQ8I94jyf34N/DmBrkbA/9mRxz8mxXxt+P7nMA5/JvkdlDb28vNDVxnXG8L
HL0pxv119fcKzcPlGdZ3BX4Ca4LW/b/qwx41CiYZv1mjfZKM38R7B+zEr0ry
W8rYeKebFO8d/aIca3Tr8Fl/wwVXq9pukXtM7YyWu6baMg3ML+8n1wbOHiF3
vdyRckfJHSDXINcYa4B6oQlD80Z+AN74qYGP4N1FcnvL7SN3YJRjbi+U21Nu
L7lp4ZPv4si7b5JpsuRlnveTq5OrT7Ic1bvxvrMu3ry7By2XvN2ijhq52qi3
OuL7Rx0N0UZt1Ev7VZGPt6PWGNNLIh/tz4g+ABd7z3Vy18f+eG3E0+Q+TrQu
484Kfyj/I+6g7G2Jji+JcuDQVh39nTKp4Eqi802PNoH3fM3PeX1sU2uG/Evl
3lP4spgPYLo08h4Q6390jO92eZ4L9qareUPXeX577WkXKnxBH9vvmi7/c51/
shWuLzXPyvZyRwfOgYPHhA9OHRs+c/+G3Cy52XJPxLwyn29G2g2Mrdb7nnI3
Kfx2kvdN9tHX5a4L/Ho58Ji9860oR76Xksx3xrdX4jt76muBo9dF3qMDRtr8
X8RnBc4SfzTGANx8PMYIWF+N+qhrScAyK8aua+AE74rAwNtibbwb8m61KPAV
HGGtsA+yf7Dft0WcNdka8SPie8+Aiz2IdXxkpPUKWHvHuPNGMTjeHHvFW9/7
we+xtPN/sopjYowWByzgzpMxD6y/p8K/OMbriGjz6cgL7sAXWhBvW89EGvj1
bPjgPu8gA+JNBFvx17fZFjtrel38o1hjv8ZZ4Ebl2a5V61RnrTkKJ+nctbf+
RzcpfEu7YK9Q3nzrcK3LsQ7S53gnR6+i8rSr/o+xcabwOt07hna17lN01KOT
H12njXLLFZ6gPMVt1jF8hsK9FP5E4ckKj0GXneA8W+GT22zDZwr6p9usYx7b
pN+22R7nmQofrfC22KpXuJPCU1XPngrf3GIdtxMV7o8OO6WPVnhOi/l/0SWb
E/rYT1b6P+r7JOU5UuHfe1rH4v8UPk3plxRqLEv8dsf79bHoa1T6g0o/F14q
/QYmoANc6ber/tYC6/rNybJ+4fPlnyf3EvwWypPcZh0beys8jzdO5d9f4eda
/O56ksKrVP+xynOUwiMVHsbbocJ1CndW+DCFuyucp/ARCvdQuBDdnQrfpnq6
FVjPwest1nWAbNb6Fstn7aHwjQqXKbybwlco3EnhDxNsj32e3C5Kn6T0bzTn
9wuOb0Ie5pc860ueL7eKM4BcY5514GHPHTmvEdxBVfYX9PABQ3frf0TepWOL
ZV6wP40taOxKjFL6DKWnKn2kwucpvEpl+yucD/wKD1C4tsX6yoeCJ/RF4buw
zRB05DtjHojvqjyXKk+K6rw9wTCPl7sj/AlhHwHa9H1yy4IGTfyLBNOmiTeq
nqGar381Bt0ULlVfOhfZdg/2hrH1g07l0VnWn7xHlsfwgwTr9Zzezbo9P4px
Zdw+Dh+4PgkfuD4Nn358Fj796wle8baudVer8LUK35djmw/Yd7ifY4jGoo9c
R7lq5Rmtdk9Ru5WMQ3frdChQeBj6N5Tn86ibfnZV+i7Kf0OO/7ecuTn/bo0+
WfQt5tu+Hrb1sLvXqYP7B76sKHc4tYPtZfxUbh7qBOZdOFmu/P9i80HhEoVH
NpsXBt4V9EMmNVtP/j/K87LC09CR3sH10c5W9dqf0L2lslupzue7W/8g9tGx
l/6HXHoHjyPjl9bB40t8qw4ed+KdOxhe4qmqZ5naul9tdVb4c9YX/WLdaXwW
oB9O4Q+Up1Xp23QwXzkwbRdwUd8awZyq/KM0PqsVvlL5n9Ya3LGv9W+ie/PS
HOsmhjeUc8zvcY9ZqzzXKv8rhT7XsAdzD+N881vce+Clo134Hv9S/qearQNp
ncKPCOafVXb7gIW+7hA+Y9Cf9zne6+R26uAxIr5jfCf+h+rJa7He4I0Kv6A6
s4rMzwsvIjyJiRqHt5otU57XwbZEvpIbEHVndTCfPvp+0eXbqrpa8s37PYQ3
zg5Rjjc6uWOFR5/IvwT4S/zG3i/6yDv29tEP3s+3jfHG/sDaZtsgOC7yMie8
o/eN8s8FzyM8jMiovptnedJ8lf1YODMg17Sxv5tNH0OPKbavsI17fNRHeydG
m8CBTSvq583+JcE8VvvA11381r5DjOVrSn+lr20AD4zxyJbL6eA9hT2GtM9j
X2HMWNvEmY9PY60P+n/lGDPKMdakfRH70+D/95336sExxmeEP7SD3/x3ivkf
Fz5zld7VNtPRq76t+r+NXGq++QV2jDK8h9MHYBkf5Ygjg4ssLrK6p8V32oaW
jN3Q+Z1sPzU75Kmws4MMFrZ+4BWEnxEeyJd0hrgn9MbCkw1vNrqv39f54hTN
USeN7W4l5m+DZw7dwbORwVCeTTnmt0O2cYH2hGexa4D+dJ2Hz9ZZZYTuXwfl
WHcRuoqaemjvlju4i/VOp+Rbx/5ROdaBhO6jvzVnG+UWKT42x/q9Pg+d20n5
1ne0u9rZTa6uyPa10a/9smBL1px/gK6fGusk7gSPkvLP0rq/Xu4JnaP+bTKf
ZZPczin6P/MWITecd4uID+O9JOJnqi+T5Z7XvrGo3Pbd0Os4t9x5hsp1RxdP
svkoEzWeHSrMSzkNWpngeVvzPEJ5innr4D1D9f2ALirB2UXf5lbqfy83W/v9
Hj3Nd/QifIIa/w2q68os/8P5h70v+GfLTdO4vCQY5pWbr/uy7v5n8L/A5jw2
stFpkdJsGVTm6JoG8+2fq/DyastaFeZabqklZJeQX2gNGVL4KtFhhF4g+Kzh
t4a/OzPC8F0jG0RZeJWz9E/IxC5Ltnnw4e1Hpzpys9gkxc5KWtQPrxL6MdpD
Lh39E+ihQIcSupQIo48Cmb5eEUaPEbqTkCeFNxMeTfRgIO+Gjhv02+RFHuQ/
yiMPPJzIcMMXAz8HuobRlYDs8FPZlo9lTPbGHqv2wKldLMOGvUxktLB5iK1E
7B7urDz9lGei8nTWWKeo/HvKs5XCnbGBl2l5A/4t6L0/UX3/Vm1dLDdD4Uvr
LeOwDPs22NjI9r0xS+5Jymvex2sut+pi3mr2QmyIo7cXPQXY89glcBZ8wo4e
/2r2xKeqbF/8unTbQvs+27rpkZfijZp3dOSm6TfxghhbeGdHBm6Wyh0aOI2O
oAre0+BNkyvnnS3Z8TLwONlxyvyQ7Pj2IZOB3vU66NAKr5X7RPj+cR/LoWJX
E5t52NbcIPi/TvZaqk9x3t/hQ4ZunezyjdCv5a+Xq4bmLf9Xua68PcpfBa84
b4/JjndJMbzEG1JcH+VrUlyOeqtSXI66vtTeMERrL7/aax54vkn2eHyf7L49
q/BlcjPknpC7UG6a3ONyF0T8MbmpEX8yvl8k91yUuxx+V7mL5S6Reyq+Xxz7
Dm1+K/d85L1C7ljBNraHZfeZ7++SDRPzT17iGRrXdLnhgv+s3rb3g62fe7Te
fxG+/ZZtu1fPltmm1QrtHwvlbs62nDg6aHjT/QI6Rh/LQzNGT8PvHHOA/yy8
/SmeG+Z298APxnu3FOMH8VEpxg/ie8R35me/KMc875ni+WMeRsd34vukeJ5o
Y//Iyxw+rn4197BtnIMVb5brJneQXFPED0wxrhA/JL6Dx93zrUMLvVcHRH3k
e5J/gtxXWjO7Bu4D994pxjPg2CtgrI76NiR7rwfPnky23AN49kTEwbvHI74q
vi8KPMNfHPj9HPMca+PZiP8a358OfOX7C4H3+C/K/RH+S8nmdYXnFd5a1uGj
co8lu//rIy/jgr8h/k+vJFt2YEPU8XL05+X49pPGY4VcZbV5X88Kns9nVM+l
sQbQXcF+i/4K/h3IviITvUr/7U/LLEP1U4FlzY+TW6v0L0J2ax/9D3fVWntI
c3KCvu0Y8jDHcscIWa/B+oeUyb2qcg/UWifZ/FzLEGPPGP0+pwqvd1SeT/X9
YoXX1Lr9FQXWV3S03N5N3ovZh9l3p9dbVq0+5M9IX11jnQTVyAY2Cv8bbPOD
f+XVDZZxu6rB/wjKHqp8HxbYlm916AVHdzi0cvh9B3Af1PjVwOtfZX2I6NzC
Pun3DdY9ip587D+iFxE9nz9oX/++xDqyjyqxLsUn6aPgOQUZVOUf1+j4mQo/
Wm9bSlMUzldbSWprYJXzYG/hM+3z+6mOfUusi/zZets1xFZZjdZ3jf4vh1Tb
Tjo21LFfVtDiuz33+m/17WreLjTmL+tfd6LmK0/9/k7/putVtlRr8Bm1lYhe
DHTaqu71tZ5n9J5dW2/bZugn2SD3YIbPaos1vxnplmdDjpCzwTtq9yXBdIzq
WVVg/Qonyh3Y5DMEecarvoGa6+Wq62R9G5hnWx1/C5a9kYFF/51g213xv7FH
JviaCw0b8rDf5Vl+bXWBdTycIjdOdfZXnV+ozuO5TxYaB/eot77DoSqzTHP1
RYNhRRfhl2GfYx/tQyM0LheqnU80fi9onHM1d7tqzEZW2973dvmW+ftQd8b9
moxvnKsXIlOr9rpw7xbuHa622tTWIYovLbCN+9Fq827BdpTCHbmTyb1XYJ0F
2HtGl8EJyr9dodcQsgLYK8QOY1PIU9LWSv4F6F2p9nsV71bYK4Gf/3bBvBR5
Q8H6KPK3GbbFAa5h1/JZdDg0Wuf5GLX1sfyP5N6ttu7G2+QOA5dU/+3V1oO5
c57t9KA3olucJw9VO4ege02wzSy1PO/deZbfRY4XHQ7IPA8LeV70kQyJdHQU
DE6zzkD0UfSPfaZfpCMzjVx5/5AtR+cBegbfijwDoiz1Dg2Z5WlaKycIT44s
tnz1NpFnjfDnMaXXdbG8POnIzHM23THC/aM9YBgRcO4S/tCAGTnlnaIvyHNT
17goOzDg7Bvh8XEGrokz9pcNxjnkbNHNWRV9OVHjv0OhcR+5cPK/HX5tlIV/
vjr2ZPbn6uClp/1B0cf8yE8d2EpAJ1RGwEMe4B0Y4wqc6NREJh95/Bq13Udz
3jvX9dTFWb1z1LNZ9morp1N/RZRFZpK56hcwLI7w+Bj7rSP9R9445f5Q/Uvl
3pe7IMO6Ye4ttd4W7Gu+KDheKLBuKb6jt4p31H3iLXWecG2u3NQM2yhGBgeb
xU9qXpeqfK8i6+i7QO6yDOvjA/fR13e9cLm0m+kS3bR+m/P9trij/NfyHH5Z
a+LtQtvi6aB1nZhvXdVL8lwP75Hpiqfl2o4R+wB1kY5dX2xkY491BW1pXd9R
YFim8n/KMK4gh7ZH+DvEHIF/OwQu4e8Y6eDPtoEPZ0cZ0t/B3hl3wq4e520D
hwfHXDPH4AyyrMixVkUY/BkhmG4RzB/EPFwiuE7paBgZB+JvCU/fbLBtNfTF
X1ViO9EL1K/1OjOcrvIral0H89m3wDTOWbmen9tKLCP9tM4T0+NssTjOxcSR
c0YnIrIkyF3unWx5RPRp/RgyiZeGXBAyQciJEkaGFF076A9CZnKa4ntFeexM
7Co3Sm7PetvvPBh+f8VHxrepyreH3Gi5C+X2jPLXct6SO0Lube3Db5XZTtN1
kXak3BVyB8sdIjdD7kC5g+QuiPqo67KAl2/ny+0e7V0jd1i0cbbgGBEwvac9
/F25DsLtCYoPlBskd1r4g+Umyg2VGyZ3htyQiJ8e34mPlxsQ5dFD1SjXT/N1
QS/1We5N4clY/UPGICOhPKfI7Si3k9w4uf5R/l2ts3fkugiP3xFcb8v9q7PH
6arjtF7WG3GW8u0SfTgTvpmInxr1UdekgHe43OTwyXe1+j82xmJmjOWhcleG
P0bub7W5sbdtFXJuvSrZ5V6KfFfFGXlmxF+J74zxut6W9UXO97WY1+viTHxN
xIcLx4fl2d4cd6wFcg8l+961UO7hOJtfHnMOXN3lWpKtg+CBZN+Bke1H7zG6
DLhTkv5gsu9sD0Vd30TagjjjXxFwF2qMX9VetLXGs1ThEvY4wVwtf1Vv6025
Jsd6C/hfvKH5XFJmXQ3nyO0qN0ru3PB3kzsv/N0DX3vK9YrxGhPjfnng7MGB
1z0iH3jZHvEx0ddWuSlyI6O97qW2ozYYnhrBeZLwYXFX88OCB+DF2co3Iso0
Ks+n6mOC/sWD8px+VsBB3W2BB23R9rOxflhb9wUOTQ4e2TNiHaDvCp5adIWi
vwg9WPDo7hL2Z9CNVSC4ju1p23vFvUzrhM6Z3cs6gtEPjP7Pz4MPF325XwTf
LnpEPwue3HTlf0n5/6zwmoEvsCJwHd7B4sDpwoiD4wURHxHfS2Kd45fG3lQW
da3Qv+nHTOsy3TW+8+0Bwb5JbmOl9fYCF7zA3DHgM4Z/GV2/6AUmDflV7iDc
RdBfCp8xfUDnKvxtxBkveJCJoxMYXcLokMFGPPRk+KQ/Droy/HB8p03aQwcT
YwQs6NNhjBi/1YL9iUzzTdM2cMEfjU4p5gi9ZDvGXG3R/5re+T8dqxlR18Co
jzZ+7umzPuf8OfA7y30rHLtO/j76n07X3J2v8DTle1Pj81STbXWeDO5leV+b
G30YF/vi/NibiM+LvY94d62xX3mPUB8OLzdfL3tiQ5l96kQfc2boXL4j6mOf
viv2aPbg+wNPWQMPblkHckf2st1WbLYuiDT+RdiLwi4S9pHujPqo6+6oD1x/
KPLyT0NvGXzKO8T+CpzwFLPvw1sJDyb/gZyID400+DTP7WWbzdM0hlfJv7KX
beLNkH9ZL9vEe0j+Ark1Cl8kv1jjXNDV+3d+4HRbX61Z3pD0X3hMeR6V+115
Fssfq/wzu/jfA78y/MuDwgem/gEv/Mv3xjpmbQ+INMr00F7RLney5uQ21Xmr
3A+qv5fSesILqPS7lXaX3C9KPyDLe8mWPZfw2bHPnh371sHKc0aKzxn3yU2S
myx3f/hnyj0Q/llyD8lNkTsnxTQzyk6UezC+ny23IHzyYeNyns47V2rt3Rt5
JwUN5YCgV00p9xvClroID4s2eZ/YJWAZHvFJ8Z34FOQ25G6q8vlp/6h3etDa
iCNrf065dSvNiDahmUFbPDjoZPwDEuQ68L/MsT1UaPcHaO3s32RdOvzf/kxK
SPhLrpvCG5Ic59/wb5LLNyVbn+Ufcs3J9slXqXNfl3zTldnHNyntnyTv8Rvl
/51keudBAVNqndao9ogfNHaXq38z5O6vMt0Z+hb0NWjNjySb5sW/CLioi38F
9dEG/yraAb5boWnpbHpsvueKcR0Rc4UP/Rsea2i10F+RY4HOCx0XmZPHI45s
yWMRR9bk0Yh/ozX4dabtln4VOATufB0+OLI88IxvRwueI+SmVlmW5d74tixw
izh825yPob3Bo70ozsjwfT8V8ZUBI3H4uZ+NPvwW5Yj/GuWo65uABTz9Nnzw
+rvwF4YDx89NMQ0bGig0Uc7m+wZuQbPeJ+IXxXfi0MH3jDJTYlx3jfrwoQ1D
I4cuPDraIA368XnhQ1f+PuB4OMUyQPiPpFjW55EY92rN72r4pZIcPz/qfjjq
PS/ynhffzo+6afuCaB9Yq1TPqiTX1VXhlUmO1yS77jXwgIGP8kuUdpr2uQly
P9UYz14P3jfw7rWIbwzeOOKlyS77Y+AiPH9vxhpYEnHWD2nw7pUlO++KWG+v
RF2kwR8NL15VvsPUiw6umQ1+w2LNwWf3UqzPl6M8er0WwWPN3RFe6R7Cce3J
5clu5yfWYI7tH/MGvK/W/T5N1tnFvgBc8B5Cm+aOxd0LfS2EF8da5Hx5fpyP
z434wjiPEn8mynGGu6bWtppvzvVZeErkQ6cy+n/Qq/NcnPU4k0JH5x6I3h3u
BN1iT+Kc2hzxg2IPIn6U+vgvPAYFpstPi/LsH9zxLoh9BJ973hPhT4s95fzI
N0pjsBTemEyPE2MPn/jPSeaDhGeTuyW4CL6gTwidOeiKQYccuuXQxcN9rzHg
QycFYe6B3Asrk4133AO7RBydzeisQD8G5/WK+LZn5AVn94k2a8OBp+h7RK8P
+mrQaYMOFPZk2kNXB7pI0NGBbgn0QKFPe6+orzraoG+/UFZjeIXG8Kxq3xvK
Aw7uE2URb1Oez3SG36vabT8TPI8bAgfBP3RhomcTHRToHgQ/gQm6GfQ+aGis
M/gvn462GVd4MLGDhw4/dCSujLSnYn3iL4p1uyjKc69gjbLmdg0fWJtKrZeu
f55x/bGYv53ynH9E9O2nmFvmADhWxvp/Ovr2Q+A3+P5erfX+P5Zum+yL406N
nqEjYmxP1vdpWpunF1uXJboHsJF6gdIu5C1A6Vdl+Y0fPrW3yq0PELln3nXh
xeJtN6/C3+Hr4j0EWy2cK+ALQt8iuv7O0v/tEYUvTrP8GTJsyH9xNj0rdOGi
E5d0zouESd+q03/fSOe9GBi6J7pteI7g55kcOnXJj/5v9Dijw/mjCr8bnJTm
vl4kd4b61b1e61JuUrH1oyAfj/01aHfoh4d+xx40LfLzRo++9dc62M42tl2w
QYOfH2HeLQmjMw8dDeRHT8M7OYYbmK8K3r/bEuzvGeG38xyGJzCt2TpkueOg
SyUtwo+Wu8zSBM8BdfJuTl7yoPOTviO/h+we/sQYh1nxjXR0EaHfB90+a8oc
RuYYxzdkDNGnD8/P0ATz9MHbN0Th9DLrQYZfB75I+Fnhjeyivfkf9fsnpW9q
cnj3Tv/FuS8mqM4OzeZvuazJ4UubjCPMI3qx4BFNiDxVzeaJIZwSMMBbCI8M
6aM1p383uX7aQpczsKGfOTV4ltARgL9t9KUUPtYW4yh8OecHny38toQHJvgu
NiXqOSXuZtyn5mRZDyZy8PObjGOM6/gYa+QrmW9wBV6OE2q9lsYVuz7q4X53
dfwT0WO5VPfFM3TW6ixcuxPeihbr6GN8p0T+G7LM18RY3xC8wcD5cxfXzzrd
0gfmpKjEMICr4CI4eleK787gCndi7Hc8Enlu6+0zKOfPeyttX/nA4OHF5jT6
2S6SP09uWri5cvXIvuj+dFurddb31HqaqrLzBc8xtQ7fXmwbj1+HnCB6HrAj
ja4HeEAWZNkG+IHaqw/uY1uF8AYAS0G29UQ8lGXbDQ82mwcR/kPq+yrqxCeO
TcaHsv2dt8YrBMPFqusB9eW2gBm9lxfpn/CX+vt4lt9V0cXJWyxvtow9b8G/
tGktdLceTt5U8Xk7Rj4RmUfkefdUO9NzXJ55O6O7y6MLBP4c9IEsDzjJ31l1
prWZL/ZMtf+l5n6ffMN1W4zn3Bhn4ERfEXqLkHeHT3Rstu38sc/AJ8Ge81Wk
HZxu21grgneiU+A86wA+0LNbzAt6g/o4u84209m/k2PdXVLsvRD7GJvXYqSn
RB72e+6p3F3PlH9yk3WbQlPkO/ng48KGEnWwj14bPF6UvVB1n1ZsuxngYOfm
/+xCEYY+g816vrMfH1Jm/cn8l75CDqDEOp5pD32q3J3PU32nFjsf9t75jh5h
YCQPOlrxD4j8hA+K9FNq/S/gH4jMDGOD/c59hYP7y91Q7XeZ8xqse2Si/H/q
zH9bJL9Q7juNc3298/B2M1frYF6r9SVin5x1tK/ST6z1/5T94MLAD3Rrc6/m
nn+6/C8arUeVtwV0qZLO3Z8w6azfLd9InxP1HJLoutiT0MtBuUMif3LwY8Pr
zjsP7z0fhswa8mvIY95bbfnzp3Kt63i44HiSdxPBP6zRdndn1Tude/rD8ALk
Wp58P6W/VGv+2PYG89tSzwPCjfub/AbVkTu6XGuD69g56n9b/l2l1qUHHzr8
6IMT3N7QRtv6xQeGr9TvJSrf1uD631Ham9gR15qqazGvP3z+rH/eu1hr36l8
X+VLVtpJqrNfo/ndftDcJKnd7+X3UtnTkL9irej7dnJHK//EeoexS/+g3By1
+1WR4+TDVv1khbdX+Fb49YR76+M9Ch25NzV4rhgj+sd/4d0SvzVxruitcn3k
1sGLUmt9dbxFAW+/gBlYiX8b9VP2VM3X8fUue1y90z6IdOQseuVbboFvtAEN
+TSFt1F4Qr3HjXFn/s5UfIdG9wO+f+ztHpZrvNghcOO+YttOwU51hb4flOt3
eugfh4Tt1Hbk7tttI5D9nn8Aez58DfA3sMZ5l+OdEnlJdD5gvxlbWH9ofT2g
vPez7+TaTjYy+8Rpmzj6ddFzDo8Ecv3Agq0M7BHSJrZlFhTbrhf1kndS5Oc/
hL5wYF2vtu5V/G658jr3lTdQ9OU8q/Aq5R+l9Gl5juOvzTXfATyi2FiBv5F8
pMGHcKTS2xttW7UdWRPh0pnq5251ruu5XOMI43xyhuvAXktmpnUGnxlwwod+
VqP1HSEf0zvf8zkp+s4ZEJ/86BDuGLIbyK2c3GLZb+S+mX/KoqM1OfJsXlNq
+9ks81eAf+Apb6ZbNxo3Dswwno9W+IF680vv2Wieafy9WBtZ/rZnhEdqHHfT
2Gbrn5Ot9b1ec38LeoeUvrvSc5S+R6PrZO08VO96qPvB2rAvnWt9rbs3Wmfr
5DKXIT/7GPRJ9sbyFsszsEfDa3V70C3hL/sreMzmBR8W6ZzPCbMHohuQfOhI
HJnn/K8nW6akY/zjkLnqFeO2Y+A/uJoU+1LH+I/2izMwvDPbxbs5PEp/x/mT
syxnV+Sb5sYei1wwdrJGNtpWFudg8vN2gj4P9HqgD/MtpW2UOzLHMP4ZcOJv
iDDvfoR5G+yr8B/wkOkMeVyhyy7J8fl9Qpzh8U+Lcz7rn/m+scS254Fn/0z7
u0b4+lrTPuCfOVrz8b868y81FTmN/+bYeCfnPoWs6hUhr/q26j+i0fYTrtP3
6+XWogep1nVAT5kV6ZS9OdI4S8yu93+B/wz2EHdptE1E/ts3Rx5sTx+i9CGd
bTebMLazafNIueVphvHmgPNutXtXrdt8p955gHFKqdcha3BWqctTdmeN33C5
UYGLu8lfVeZ0wmek2989wnwj70r5S7v4H/FNkdcIOLxc4Xn1Hlvm/1a5EY3/
9Y/w3sBQ63GHb2mI8PxcjefsfJ8Hr4sxfENlDm30GMCbQDrnQ3So86/5LMX4
Pi9wnrE5NMZnqOqcqjpvzDdvITru4ffaW/GZOdZzD18WPrxZb6q/lc2Wd0DP
NPqlkclYn+908HOrfNt7wF4FtqLRSY1uZ9L4hh2IcVEOOY4LoLErfF626+ga
9YDzhGkTmRTkRdBjia03wsinICPULcLN+p/NEe4eXGIZE9Kx9VYo2NsVLsjy
vbIq7o//Rvhf7ibyezQ7b58mxwmTRhiemd8zLWeIjCH71h6xH64rc7/oL3fG
fnH/ekb4822Ry8xttN7/5dC91HbfLOuk6gGvs2A+RTAfCE7LrVIdU1Vfhdo9
N9s2JbAtAY9ce8B5EfLlOY4T5izfKe6wzAtjjo5xbI9TFpsUa5s8ztiYhueu
NerkG2H4qy9vdD3sY/Bgrgz9UcD1SbHj2BS4OfAKW6Po6eYOeKnSLpObKtxY
XOV4nw62gYYtNOgY5B0dYehGhJEPyRQeJvTQfqm2H6+wf5rGs7fgnK56PuXu
UGJ5ntczXQ91oqt5ptbHJQ3/3ecIP6hxX1TqOOG3My2TwD0RuKYHbOzzr4X8
4L26e62Xe6zY+Iq+dcaTvJdGv7g/tOVbHq275v35TNvDGZbjuR+g/EtLbLf2
hUyft14KWsgeTZYrQ6YsK8/fse9EuZeiLO/IrBPelp/JtB147Fx0zrMufsov
a/T4Dwr5OOBhHWDncI9YU/T9qVLfbaFb0AY4WYDd9mzXe1ix7cvRh/pct8fa
fLrK88gc/qjvP8DDl+XzRHLcF7ClPlBtPZrm9YDsLXJ82KnJiLUwsdxrhu/H
lTh8f8ihrY38y2N98I1ylMdWTYvWxVzhwREqN1ZuWbHf5J9Xn56LdcV7PbZt
eG/flGndtpM0L+UB22nZrjMz4NlQ5jj1w9e5Ot73D4s2fs20fV3y0y/+7Ulx
RqqNMLLZrDnWHvtJt3LvE7kZXpftzf/F+X5xR88tstvML2cJwuAF/x3+OcCe
VWL+a2TesL+axhuJYFiMrJbSOqu+Eo1HnsLPJ1qHL/1F7+u22a6Dvreqj0Vx
liMvZZ9T/t4ljhOGHtcxzofAkhuwzc5zGBg7xZmGfeAklT1Rbr3aOLLUbbMP
Iy/Dnga/ELZEsM2Rm+L5YB7B5beK/Y30jfAg59t2EX5OzAVzmB1h7kfsjewt
7Klp8b/ILLOeAPZW7vqTcy0nunOzaX/MEfS/lIAZHE0N+l5K0AXJk6J62rMM
+wvqy89Flv3dkGkf+V/61B57NXJqwI9MUGWe+4jMGjKo5GUfoOwfgc8//L/6
XlL9L0YbH+gM8D186HInlPg7+dFduzHm8SPlWanvv8itllsl91fU/We0xdwW
x/yi25Dxgs/w1yb/L8B5/vl9YgzRfUg+8pBGmP8OOmeoC70zB5S7TtKYh6yY
o90bfO/izoW81wzF16V5390z9nBoULRB/eivRI/lfUH3hSbJeqHc5VF2VZPz
c6bl+w3xryQOHYszL9/JB5zQU+cEHeO8yE/d6BHifIsuId4W+JfMDZo5NHTS
niwzPJMTTAuhHuggp5a6bdq9rNxtHBI0EsLoMGU81zT5/4ucITp8odeRzt63
SmukSN+yhJPfZlpeeVSz92HuDbvGuwZnkFFxDuH/w38IuTjoUqfn+E1lZOTn
X7T5vx3/bmxw0E90JUEbm5jjdwh05K+KMQTGXwOeQc0OgwP099roF7RZ7Ppw
Jpwpf1aMyZ9l7gt7HXL4pGNrCRkI8mNLcXJvzW27z4N/BDzcKfDXRfhn/TO7
6/+9OMt81vjHpZvWjQ1dbDoj97Eo9h/O3uAD52/sBEHjxFbQ9HKfaznTztda
eKfQ/MroLqYedA2js/bLJqftpXIzcnxmTS+0nAH3WGxLQbvlPWVZ5AcGaMHQ
W+E1YBzQuwrOQkN5Qv4x0J67a89RX14LXL41xuqObI8148w56jfGPd14B76x
FqDLXhTjjL1G6OD7dXQ6dFviyGRC44Mmhw4mxhB9TZS7OMb84qiHOpCXuDjC
tPt7k8/JwDUzYPs9znbAM6TZYc54f5cZzsfSnJe+QkO4M9tlyA9dYWakcxa7
MvqC3oorYi0zT6zhV0usiwF85bw0SbjxSbvnAb334DfynmNKLDvxaPxf4aOD
d+5L4fBTmZYP+l+J5YWI/6K5W5xpm0nJ+u9fhA2oYpcjL/x3/P8Jk8YZjL2f
tYaeRfQtXpJqPhbW4jrN735l/kY6ehgJoztxZonXLflu52wkt1Lt/5Pltcn5
8O0G6y1GH/LD2isWlho+7DkBI7x/HQXnhYLzs2Kfj9GzCh/ctzleK9yXHtW6
GKTx+Rjadon1tC7M9NkO+2Xwe+5Vbr2tH3Ry2jNx3sN/Os5j8OPTt838OTke
b3A+GTuuxa7z02KPN7IqD4fP2L8oGCYglxs6Yh+MtpYq/7vFjnOu31Lug2J/
W6Dw/iWWxXog0/vTyNjTNr/XxDgPbjbOgW/ocWbc0O2cHLLFgyPt3UhHJgx+
hE8VTu/ocIb8TiF/jPzXP2p/U7Hj70VZ6ilQf/NLncabHW+Q6GTYRf6IZsva
cx4gjmz+iAi/AG9JuuOE/yn0HsvdlDaWRrvLcvxmw3sN5+jd4/z/fuQBzonC
+Q/bnY9zxc7RFvsu++/q2BsYF9bddRq/UvXth0zLGYCr4CPyj9gXge7EWXVQ
/LuZY8b2+fC/iXFmTTPO1F0Z9TPm84SrJ8pNLHPfgIdzzkXlrv/vZL+18ga6
5a0V+tIWOhP0qR9jDf0Q6wU5Rb7Du4vjO7zB0K5WhX6eh4pNVz0m13sIdgb5
d6Bb+OdG6yWuK7de0JWp5mFY0WA+Buhx1+YZtiPqhAtKP7wudC02WFfYHQp/
UuB8L2ndrcizTPfRedbD/2UHt0N78Eijpx7d/Oiu/6nBbV3AXOebLxCewKOi
LHmGF7ku6uFtFh240OHRQUGd8AzDf/1z1F8ueMrKXOaTBsM8I9Yh/yD4jsby
timc6s3dUX0/Q+nHctZqtJ59/t/wd87AlnmheUAvU3hMoXWVXq7xnKpwseal
SO4Q5V+lcqsb/VbQPd1x3uuBd1Wkr2m0zlx4G+BzIAzvxN/51heDPP/gJtdD
HdgTRFaUN018xvxsjdWmfPNR3Rf0npkxbozBLzGnF+n/2L/F/PvH5lmn62b6
YaP1tPLGMk3fe3XTPCr8d67T0d0KnL81Wrfv0CaHeyp8eb5tFmUrz0Uq209l
52aYpr0+6NvYNbqwxfn+VtptyOfm2abM+qB776pv5+dYlgk7QWsbrG92ULnn
HrsMX5UabmAeXel39Q9KnEZ95Oc9incp9C3zjfv8Oar38GLfmScrPL1VuCw3
Kd53p8c4/5vvsUGugTPN1RGGd58xHBpzuDLmkblaE2MCPZbx5FyHf2zAA+/y
5YLzKOFGdZPzM9cztLdfITe52DgGLKcGX8rEYvPt9NW66iN3lr4dWWE/VXm2
UdrWdR7P99W/9+TOhiavMUnt4rSpPbWGWlxmbpnlhrFphozJVXmmOc8vs2wl
ce6PN8j9I5i7cB+ROz7H+nbHMG7Yd9P4/yP3hOJ/qZ2n+K8XmwcmLc+6HdCJ
hm0v7qHcR2dHnQcL3g80pwfVWQf01So/rtC0R/SwQJOcK1g2aSzq0/3mxtsY
719V0BLlTsyxfuqr0LuDvqNit/tTmt/LyM/7B/sR6xyZQWgvW9HvBN/DsEfL
XQzbg6RjfxC7hp0iz0kqV9noN46/VE9XhQcWuVzHPJ9fsE9M+MM0l+scZZ9S
ehflf7LQbyXU06/I8oHvN1jOkPY6By2oRN9L5V6L8UuPvryb4zDjmif8L1ee
Dekee+aI8V3a4PGckO06yqIeaBvQp6BNPVHo9McLrcOZNcX9o1R4Mlb41F14
Uq7w4Qr3KPEdHZ1+zwmGRRrjHaEdFfl9l3X1RLz/Jsb6wu8Q6cDEXDPv6Jc5
X/P0WoHlNz+J/RZ7euAg9raKeJvKsX4e5N4/j32Mf/2YHJ8H9kXHX751+eyv
8MX51s0Df/8Vgu/oQsvTjOjl99DfIy91rou81POt8l+q/IcwDrrLjNG87p9j
GUrgn5XmPR87PdzrJqLbV65OfcoFFzhnq2x7icedMV+ven6XOxm5e+UbL/+H
dOM3eaD/TNX67oWuqGLve5ti78P/O/B8V+UfKXcZcyVYSuUOzzHtvDLo5/AC
TSg2r1ENb876/n2669gY9WTx7iF3eaHT+MaeyJ5JnP2IN3b2RubzDbmkJp9n
ONsQRo4SufKteTvQnORqTDcJN7JLLDtzcp5tskPngt6FfbFMlcuANq05PV5j
9o3Kj9K3X1X/mgaIA5a5oTz/Yuz/8o3z+ADVvSLf7R2rso9qX7ik0noiC5us
K5J/Qp/4LyAvjow7b3SDsHlbZL6YZLUxTvVP6GweGdLgn0EOrl+OZeFok7Y5
n3dqMt8kPJPv1tsmG+9E83NMC4aedlml9Q4OzrEMFz5yXI9Bv8rznr9Yc3mm
wuMV/oD122RdyHwn/aNUj016jE+a6txWcP+rebxRc955CwyZtrnCORleTmC7
PdMywrtG37nXkIfzOOU6Rdk7Bf8d9ZYZSo30OzItI5vc9N88J8f8vqW+DI0x
206w/JDv8WXevsbmrsKN3O85D9TZTi82ZbEne0qT48gVspe912DZYXz2t0dU
993oOeCcmG47tJSFFte7wfnIwxi9n2edyfhL5X5R+Lxm62vjXvBpnWE4U/j+
bLZ5AuAHQDYDHgX4E7rwblDiOxbzf2rgwH1lrpc64QVID36AvVTnpZEPXD4l
8LmKPV8uQ/l2135yu+4IO+Z47sDvXuzvFdZh2T/HZcFn7pLo4iANfRzIeVPu
lwy/mfN2vo61FmsE3dprAv/Bwxzhw1DVm1liXWXgPHrGDtc8HFbqPmE3GX2N
0GDRsUUcG8rcS3if59xPG1kqe2Olfdrlvf6hUsMKnNhtzgw85N/Df2uzfd/A
V3D1t2LrNWMNnFzqeg8tdX1Z0Rf+Ib/F2ay10Wc1wqQTxp7jvYKtRXUcIThv
hlcQ/pM4b1KWM1Jipsdisx3wXJ+bOTNz/v+5wbo4uAf8FOGuud4fDw/dbCVN
vrtx1i6OvWJyi3WVoqf0w0b3jX6N1JxeqDltyLH+OWAZluD2KM/Ys+9SPzpg
Ryj/Ap0Pa3P8psCbBPst9Ou6+D8eqjrGsPY7G5/GBO61a5zbuBcJhhb53eXq
VeZc9WGs8jyR5j7QHv3o2dXtoCOF81ZF0AD/LjC8+2Z4z+8S57GdBVuG+lmT
47tnedAAaX9swFNS6O/IyJN+aMBWHuc6+gJ9gv0QOkZJ/HfoO/yYXXNMS8nQ
3K9VXetyfP7iHMY/jv9dVZzH+lRYny7zvbPgLs/xeXmy0tOKHefMy9mX+8LF
gn2Y7gOLMozvRTF3tYyb8h6f4T2MPW5QtvdZ5pE70dpi4+hw5TupwLjBPXFv
jcnxmt+dc3y/7hpwosPyrB7WY9lL9feU+7LI9+/KoK11KneY/OiBAfeo+2vl
rW2yjCV2+eqazPfNe01Rjt9sRhVbVyjxmibnR8cIvOHkh/92fYV18XaNue0S
44++4ZIY84Ym8+zSDj5x+He3irMlZ0Z0JeInZBgmxpN7BH5NjG1thPkOXYEz
LHSDn7Jd55Z+1AdsFY0+r8JbQphz5us5Pr9WRLhLqW0DsAeyf/WMfZX/Hfs4
Ov+XxjfSR8EXIfdYlfcb9h3KXhB7IOEq1de11HwuH+XZFgK6ztflWe85+r7R
x4Rept0VrtNaGpDvd7wP89w2ZT6O8pQpFLz99f35NNu6p27o2+h5Qic6ds8/
jjB1Yl8Y+i30eWjj5Oc9gjMqNl4Jo/cI3UbQl96ERpbr88w3ldbrTBybqKfL
JWXaJ87b959d/Bb9KDTGqAcdStyHyQM/P7qisAcxGZ0mxaalYn/+w3rzksGb
BizYbwXOu9VuG/SNdPOlEZ5Qar890mmPusbBh6cyO+Wb/gLc1M25C7jHRV+g
U0EThL6ObYHhwUeKPsXZ/BPrTOtujfFkzFoi3Bbp5IffHxoTfFJlgqm01N+/
arYuXfTowm+CLXb2YHScUA+8iOxbl8beeGqE2bfg74DnAx4P3oegXc2T35k7
tFyL0pfUOc49lrfzhtjb6Xf36Du2baBlYStn7zqfA6bn+a0Sfo6dNSZv1LlO
6ksDP/NsE3dpnFXAdcZiVoPPh+DRDoFLtaW27QG+coYkTyfowSUeA8YHvMXu
B/9f/G0ivG2kUw88AOcF7XJc8APAy8DbJfDw38dWMzDzvoZfG/Bzbqr/f31n
7ltT/IbKeQpbiumlzv97wDg74IQuCE8NPHLQgsAH6JZnQPdq9L/jPO2xh/VK
SHi50neRPXN9V/qyu+ZL++x+udZRDg2Nb9AwSINu9prOAOc3mucfWuOUoDce
l2saJDbCNmi9LCw2bZKzKe0mxVsB78W80fVX+wPlrtE/8yPh/9m55vU6qsHn
xXvV9t1Nlp2DVj0w020NkH+ZYLy81XlYh6xtdE6VC28OyLVOs6/Ul8ZWx9FX
ii429LChP/iiRvN+0I+p0ZeLG53OmKPvkHRsaC8vsD71UapndJPzsW8jL4lO
N/S5pWf6O3z147l/80ao+DC54bmmmVDukiiLXAnwIGsJTMSRMaFvjClnOdoG
vquU51zN1xiN1YuV1rFLPZwlcBcHzLwdnRVzcXqj55u5ZgxPjX0PWZaro90z
Yq9jf4PH54wIw1t/WuDMOPWlrcDfthM8Jyh9htr/OsLbyu9YYHvq2ChnT2ff
5tzLegV3wVvw8LSgPS6rtF588OWyRvvgDPgBzOylOPqA/AvlJgQ8tHliwDA+
0qFzciY6PfrbP/4v/DvWCwfGtRi+u3V/X9BmPmbm7coYB8ZgYuz53JW4J00v
81iR5+Eky3OgCxx5GPAMfOTdBH1+V0U98O3vku+98JYW2yrATsE39YaZMbu6
2brFqWs/1XmO2s1WuxsE53iVuTDXPK3wtqInirqGx96KXsBLcm1TO6nAeXso
fI/6tLDN6214wMAehWzvzIAf3WudY49tKLV9Ef6lTUprljtXOPh9neOEOftz
H8C+e6c6y9L/mGvdl9/nWgYfn/sbd7eHtSfMK7BtvOVVLss94pB6139wvR31
f1dnXu+aRvO8zVH+ukan1TY6/EGhdTvS5hi1dWuZddrNzHPaD5GOTj1066Gv
hn/XzPiX8f37yIP+QfjD70o0Pzhh5vCSWssW/JtrumCV3EGqb0pNQsJfudb1
uS7X5SkLDRO9YtyRT6pz+YQ8p/EN2uYWfnTa2VjnOqE7zip2XnRyUPfGgG1t
1M8etol9Qq4h1bT6TRGGvvN3hKHfEwbnqQvY0fExqMh9AP7Z1S7LWvuu2noY
6cdhLbY3hq2xdwTLamh+7NWFpjdBa8JBd4L+9U6D7RFDx76oyektueZ7IB0Z
TPz8yMP3rMiTofNwtsJr0k1rg+Y2ARpsoWlwpHE+rYjzar860zl5d9jsR/ij
HIehg1JHdtQDDRQ66auRTp2tzE2T44SLG02XXJ9unzg0yuxy02qhTR7C+0mf
hITFGpMptR6TVbnGTXDxKt596zzfHfKMm7WBq9Buh8XevlzfNxW4/DGZrgP5
UHQq1kQ92PK6u4/teQETZ1z2KPpREn15JcdwbvkO3NA/+e8yzow9+1thpL9c
ato19GzeHHh72JK3IOYF3amcbc5SW8/nGxfA5w2Bz+Atep9YRxemWRcUOgR5
KyFtWaTjfxnh/wnfNvFNdW8EPxvMl/Gl4v9CE8lyecqwRkn7J9ILyyOs9KRG
8/rzfsE7NbpN0WvaC/tlpf72ldK+brCs3PIGxwlTZ0KjeShof1PAMCvfeQZn
GD6+rVa7vbSu/1C4p/yCcsMNDwn8m9QLDye6SDs2WufnV5E+ONK5hySm+3ti
hNlvSGfPQf/sjnE36RB5uIcgI0A/eGv9sSDKp1svZkqjdWMC48aAk7Ghb/Tr
6CL3kXFdU+D8+el+42HsNo9bo8P5MZ7JMaYpESb9/dij0LmHjcjz8vwWjP5T
9KDukmx+uso4l7aUWg8X+kuPqrN/Zsg1DI/5Wht7HbiEDBl7P7T3nSMPes+Q
gRgW+a+P8uhJ4yxOW/Dv/ZnrPZH98KV84yU4yf79Z6QviXz8f1ZUW88j+Zbn
GzeY8600pxnq7+p070UZsY+hKxe8gh6Lzkf6fnOa7xDnxjh8Kv+TPMvxE0a+
v1hwvt5kutWJoct1cIxDc6nf0Rm7z6Icsv+fR3xQ5MNHFhPdk+fG3WVg1L9L
5B8cYXSe7hzj1s59q9RxeAfAHd7oCcNPAK/ClGaP7y5R34CAmfqGRJ3oqCU8
Lc22qLFJzXsr/EGds0wXOknh1CzzvD2ps9m5FZajPVb9PkbuoRq/8/DmiFwt
9yrOEtytnm60TldwrEL/93LkQ4Szb/QWfmiv26h/+6JG66QF5/m+qM5v/tDp
oddvB8+s9uHxOt++qnz3FNiH9sy7fV693+6xUcUbFG9awPJhwAMMixt9Z4Te
RN3wEnQrdL5JaZb1erLAcpPfNNs2DLQeYHuq0WeLVwXza3K/V9nOAPd15Mi4
vxPG7sCHvHvKvQk/hObnmlK/H/KmyD/4znTrOCaN98RE3T9W9zE/3DbFtnXP
P3rfbNdLnT+pvhV1zvOC2n++t/vZrjvUG/Kbck1vXCK3d7ppCZTlrgStin4w
hvdVGi7yrVCbP8ttW+Pxy5e7n3ePWtvdYixuZf9W+i+q8wTl+1z3sM/kBiv9
mQLT64Yo/9Bix18UjC/UWXcq74i8J+6qsl+rnW/7eH+9X7Df1zv0qyrv83Ve
c6WF9ll32FgapPhNvA8WGV+Yt6MbrGMa2in+c/XWib0x2+FlwtG9i9028jL0
qSD6NVRtD6kxnwq83OAVb0DcKblbbhnvj2LcWlptZwsbW5zNOaNzpxhVazrg
QtXzaK3ll+jjo5U+v7eX+e2bcTsHnYnKsy3vVkXmOQEmcPY74dg97QkJT6ie
60qNKx3V1vd5zossIfabeVfmTXn7eJulre8rbMuLd6gN/LNq/DZF2uJIB+YT
4k4xuKvhB0Zsro8tNUzIFlEvclhv1pkmkqL4M5W+D3AX6ME+L/8SwTO91jK3
nImRgbqt3nJPyD/dGuHVlfGNdwTdWV4Gx7BfpvSdBHdlqfMjN3VLzA9jAh8O
ZUh7BB2vpdY7zZkEf/sIT9Y6vUF5GtXW5aXWvQuuIHOG7BnyyPg3RBh927QP
za1bqfUbQ0O+tdm2lLCjVFfqfOQZrHkv6uv4Parjbtag2hqtcVtYbz2ZmzRO
Dyv8YJb3rcxC712c8QYgHwYPs8ZqIDSCWstLUhZZS+QmH4owutXhtYXPtkFt
NsmdU2N5dOovqDOdgnxbyV+psewj+F5O87+/ptD8pb8JhuxCv791UJ7ne+q/
Xeh9F5+9Nz/ao61m1TGt1WX+1Vp8rqf78IXSxgiGXTT3Oynev9D/haG8jfR1
2uDYx9ijTtacTuliOxvIx82vt+zhURXWX8/+mhw+e2x1qfWlE+YuQj3si8jV
zYuy87u6njWqe2Mv2ybELuFJ3XRXavUaqanznsW6btN//naFv1C4WXU11lvG
EVlU0pHv49zHeZSzHzbFewuO1kLzUNM+fLnoab0z3lU31yGXp7K3av4+05xk
Fxkm4Jyr8iuzjDvfZTmOXODjJe4LcpjE+1dZPp01c6jK7qhxKaftUo8lY5un
NbKkj8ca3Nwx8HMXjfdIuYU11nnEm+9uvFvrHj+8R0LC26pjrMb9LqVvEGx7
KX2OcHphJ6eBt38W2b8rcDilzTYIsT/YPep8Id3+nVH/e4JzH83pr8KdXI33
172tz/7UAvucF9BnjF7jbdJ99kOXPWef0fUO56TbJ46Oe/SXvag6j1S7NxY4
nTxbV/k8Aa78oraW9LZ++vmttpGGfoa92FeirafV3930fVSRaem71Zuuir87
dCbl2bOr8/M2emjAie7lK6rMx7Sw0N+od8v3vaJ+bDzyHZ6mo5V2jFxpV8vo
I4OPLD50d2TFob2PVZ2TkTstsqw/ugmQ999RZ5U3NK9b51oPCTYkuma4HmT+
0RVwpObwzcjzWa3zYGPireCjR05wYqnbHF/qPQedFfsIh/+nsu+q7LbQYAPO
tZydGjzG0IePVp73lWc75VlQ6Xapj7xHR/5jlOcj5emvPEvrnP5Yqc90zANn
nhubbMMQmHqEbCWwXa2+/9zVPEcHqNyBcmel214fdvtOznTaQZE+s8pz8LDy
31Lpb8eqrYlFTmPs0Vdzbxfr2Witt/+S1sIVxX6j4n0Ke2tL+trmGro60NmB
To+eTdbbwVv8B0X+Z1Zm+1yBPnfOFt/VuA304ZxT6/v8M/p+bq3j6L0BJvpz
DLzkRe4L9gfhq6Kv8Fzx3sW71xGq8/Eqh3n/4u1rt8DDkaXOR56beG+Se6vU
+UjnXQ37IeAtuHyvcP9I9etdfV8gN5L/i/wLa/0vQQ8JY/t8oc/jwJUW4wxf
A2sC3oZ92StLvU6+jL4w/vCrQhOBhkB9/Jeo6zXl3195XpV/VZX7SD7eELE1
yrskuHNC4C24fnjgGGdKzlK8jSKT/U6cqYgjK4fM2w4640zR/+W8CtOVlged
HF3e7MncvzsIprfqbaOEepDjpjyy0qQ3qZ18lXkzwvyrfoz7Arp3scNBPEP7
xoe9bZtlV63BrFbbujq+wHZioHPcVeS7MnQG6qdOzorYBaEcc4EO9KMj350B
I/fuPVRndqtteY3Q/6hC4TczfB7F7gn2TfA5m3Iu5W2ZN+YT4z+8Ju5B8ON0
KPS7R5d634v4576eFfuu8jyvf8KbLcafrYQX6XKH1tgdUmNa0vb6P+a02obd
aKWdWBFv2hqDWT3NU7BCdW4sMP8FtmP+KjCd+ORywwqc8GuQl7eCEu0JB6pv
6zK8lxwRc40M+hsxVm/F3DBf0G6bgn7Lf569nDsVtuag7WJv7qpW283FZu41
Cv8iuBcUGhbSoFnf2sVphCl3aL3pzNR/SITXaK+6otU8QgO6Wq8K9s6O4n+o
b9vkeh9G1wrf2KePir0afsEjYy/9WOvoo3g/Aj5gH1hqm8fsV+xPfasMA/3o
pjY/Uf2Dc73/8/7Keyx3XM7J3CuvLLXdkSGq83/Y2Sv1+ZQ3R9YL8n3HaQ5P
kluuuXpb628s+C2/X7n1AXAOZ1yXxNj+LhxY38d3l3cjPzoAP0eGq91t8PbG
G9xm/nWNw6cBJ/0ExnHyG5T3szbnW91qG8O83WH/aIzyXKI6X691mLe7FTW+
l9O3S9S3ZM78aZbZ5kz7XoL3S8667KHzhC+Nqv9J5X+8yP60TI8v73TMF7xd
hHk7eSzykWcX+ip3X5Vlm5FxRu7qW+R4ihzfW2P2by/v6z3abHP645C9XBly
l6+UWg6TO/V7gme7Nn9bE/KZ5EG+EzlN+IJ5vwEW3hrf6+L64O2inpcjH+0/
zVmSt6YyxwlTjr4s0L77NmdnzVGlcOd6wXmjXEGt92b2aP4h4Bo4d3iG3y4/
irLYtOTfwn7eInjrepvHcY8q95X/V3mx+/m1xry41uPG+N2iPL8xvnJPlzvt
Qmg2gnOQ2l2m9F2qLFuOTD1y9sjXM4evdbFdZ2w659caRuCAxoMMOjL2X9X5
PsNdBnoOd0Pug53Vz5+KLGMOXD8HbD3bbM8bW97zhYdPd/Nezd38kxjbgxt8
528Xvj0oPL271XveFloA/2j01CBnjox5tuq8XON5TVHQFaIsumWeiXzI6CKr
i7zzmWWWE94iA4+P7O7rgmXrNuf7sMm0ed6VgKeu3jQIdH6gNwe9H9SP3poH
EnxHgYcIug3wkRf6IGPwY7RTrzHcqsTn8G01Ps92Md0C/qY/gnYxqcK4CB6C
j78GrvJewPsW71nIIP8Sed4UzNsI5hVFllH+OfD2faVv3+byA+Tf09M2GNFb
vUusI8bhx5gX/BUR/qSL824d/Hq/R3gxdDq5l9W/gapzXl/n26nNNtTJhyz/
dzHO4MKbgQ+3VhkXP1O4V711Rh2a6/tTc9yhekQ6OpyQXUBXJ/ILNxa5HDyE
k0OPJ3rr+N498hwsGDp1910PfVHosMJGD+9IvEvxltRPebeWq+xkfgLiyDv1
kd9XblGq3394W+Ld517tb+0VLr+lPfSEPhBl0Fm1SLj5Z5vLDOF+I/eVwt2K
om9FfqfkXnhKgnXEcWb9U/0dXO81OLfK6e31PnPC+wltC7oW8G4TMKeVuQ3q
p462OPu2R5g60Qm1rtD3Tugx0GmgyTTHHZs79QvNtuUM/1tBrn145xjLlhjP
phK3wbmaOekR83VXscPo1xqCrFOJ671cfRja1e3hvxk0oturPM7A37ve48Y4
0+/Bsf80a/xuETzPK/+8KqczJtBHoZNyB3la/6YPhMNrK7x3UW5OpvV/oQcM
G3y71XrPZP9sEAyvVti2WaPCjwmnXysyTOAlYwI/OPtofvCD8x2ecORfoEnz
v+ausDTuC9hIo76i4AtaEvVcLtg+F2yvV5huCtzQTrknLQ34iROG7grfUkKR
dZmCQ4wLus8YZ9YGutT43iHyPNno/RsZjX+D74n0a5vMBzQ0wTLm3YMviDEH
TxgX8I784N5ttaZT5BQZlg8CtkSdYz/s+t8bET50owTkU7r6/M189I652y10
0SBreX2TcZAw6ZvlMOEz0XxeILdJa6is2HsC++QdVV4jwAitGpp1vsYzrdY0
BfbwQrV5Zxev+2SlP1htnW3naE9LbzM9LaHNuhe57/ylsf9T/8SRKpen9GKF
59CHGvvgytps18ceAn2ctpErZz+dXeR3Vf5t3J34zybqX91RbgfeiIKuDpz3
NRoWdMJRnm/obbhXsOSq7feQHdc4zG32PzGl1n2YWeS72oi4r32jct/W+RyY
Ljhf7eo7xHNqc0ov3z+o47FW11Omust7W74ZHlTKw1O6KeLwdn4b6belmUeX
tuDTnVHourmbtJUZZvoC3RdeHHhvrioyjI+kmx8QnkPkoo/O9jfSL9V8zujr
Pl1RaBi5H90l+G8q8r5UIDhLezsOLF8HPMAyMuCBvwNeZPiQ76qyrDbt9asx
Hf3jLOMbewT7OLRUaKH95G8Qjtyn8D2lLkNZ5Lj3rDIdFvoVvAzQnrE1Cc/W
Y/Wmj+I/GuFxwq/Tinxm/VXwrpFr0FzXQtvs5zvtsepLveL/S7ceRPQRMOeH
qU8VheZLbNL3X/v4G3XTBjoRgOf++v/gvT9gu7feccJJvLMX+u5F39CTh71y
9FBxxuBsMb/SdAnoE5w5SIcm3K52j+hnHuJctf9FT49pWdAyeB+BFvNO0GHg
MyYvMvHHYwe9xm0v0d71rcr+U+ExBb67S00PZDw3FpkeWlVovRnQEu8N+KFR
oxtwi6119GYtDxgfCDjhcWCNsb6+Fcwvtnr/2b7euMdbyTTh1HS5ROHVWo3t
b3WmVzC3yPIzv2siHVpEmebq1Z7+Nr/IdEroq3ynPHvC33Xmm0Hv7qdV1oUB
P1uq5nScxm2q4tcW2NYmdjZ5a5tQ5Pe2PwXj5L7/4Qf+qEzXBw8OdW0QDOco
T49q06aoD/rUKI3nxap/uPo2UfvVv63uyyZ8pU8qsm4rvnPe5l7E+Rl+D94O
mGPGDf1J6ENCB9PLqqev4P5a8bd5nyvymZwzHHeixXG+/Tb2WPDm6wj/onme
UGP7nLTzVfCXsFanMH6qf0KF+wBtDd3CwIh+YfbNs4v8n01GZq3dY12kvr/c
09+26ee9j32vROmv9HS9pcp/bTe/td1d432L+by+wLBgJ3Sl0ifW2J4ktAH4
xjgr8TbGnpSndbpQdT/Uato4/0DuMvCpTu1rPdTQ4oD3koCZ+zl18L97sNVw
LAsa/PzAk1e19m9T+Iss4yC4CJ1828BJ6G8/1Bke6AnfRZh/aQm6F/q5PPs4
+xow/YX+jqiTvJQHzzmzMdaMM+800GfRkcy/4opuHrfZBR4D7Gn+E3n4x60S
/I3tvoOnqb9dlH+/DNO7/4k8a5SnDnoBc94i2Ftsp/XnEpfj3v+r8hT3Na7z
7x0S/1/WxsbAZ9bOmlh3a5W/up91xD6ucHmrcYa8rCvedOBH2xhhaPW0Dw2f
ujbzqWU5D+83xB8vNQ0VnibmCt3WzNctvGv3dbyn0ns0mY+iodxhzl29mky3
3fK9Z6QPabIMPPLv8FHC34teh7Zs4zH6sZlv6IbQSbjD9Yp6CuB9yre9TvTa
FOVbFwRphNenWQ/D/Abfr9EJhg5B9IC9Ap1f4RkZlu96Pds8dD26Ov+kMtdR
GHXiaA/dGPAFozMOnuHTNCZ5+ZbNgW8UGTx4R2c0mp/113rz5MIrTLmh2JpS
/UPkd823HSP4J3sWe09gb4DXpWukN2vcm+pMm8A2C3yc8HC+3+S86NkDVvqJ
rgnkv4ANvmJkGrH/vDHDNEHkHBLi++jIA+z5oVcKuZJ5MVY7Rn8Z27Ry53k8
zfav92qyLgjo3Iwna3wzTT7o8vAKsJaQVeStHroAtEd4B1hffEOPWVN+nHvz
rS8PXZHwfXXOsS6RIR38jfSrkGfMtl75bYv9b4du/WiNfeRf1uk/e2aF9d+z
t+Kj//Au7Wcd2qz3+26F+7Vbh/0y4e1xbabHtgUMyI+jP6Qx3/rKuvFu0+62
8wMedIzxD+6UY900jSXuyyi1tRuyytwhlPa26p/U5nvkyEL/qzkvoH+2W/D0
9lTdfdqM3yMYnwLrrmKeq/PNB759ifmn4Z0mjW/Y6EE3y1Y51pUyHHmsIseR
iyA//FHw/3YLHuAtPMTIZewSvMTEd+V8UeD+DOIds6v/y8NUZ0mR5wPdhMCO
fsKNWR5LdD+CC+AEds+x64N9H2z6TIv6GCdkiRc12S4D4/VvlnVtkba4ybb0
Xkx3mLzjmz1/zB18KayX27MNI/rvKX9ZgfvKGCBzi26azgoXaPx30/iXaMym
Fxh2cArZY/TUpCj8mublnB7uG/x+twRf3/Oah93brc/ydeU5r4fHFJsEtAPP
PLb/FgXMXaN/8E1hI4Jv2JtAh1FhtnnUt6v0nfLKEsujwxsHX1xrkecZnUc7
KM9bynN9ifHmjRLfZ5H/LMm27hd0NmPXl/j9pT4jcj5k/ebG/gPPHfUjvz9c
+8sizeVTVdaPyZx9GmP+VMwF/IwPN5nXcZj+OctabE8XWQdkDZA5AB8fy3d/
uNtPZ8+R21d5izRGC5HL72qa6EXqx/NaL130rTzXekTQJ/Jsuv1hTeZRR98J
e/7T6bbhxh6IjtOdK83vgr5l3vN51+etf7TKfJptGwUp6vu7nI8zXY59Ep5z
9ADx72COJgVOskchv/BitvmfnxW83fqZLrNn7GPg7B4N1qlXVmPbjOgThpcA
PN4z8twU4TlJ7sfQkMujH/zDkHeYVOVz2KAS28LrEv1C/zD6iNE7DF/DScHb
8Ib68mG25TwOjfzYzqP9nQOGtTovDOctX/n2rrb/arp5GMFr+BjRo4Y+NXSv
oYdt1ybrVcNO9ZD4t2IjfVjADBy0sVp9/SHN+dHvgW7zpdnW2YJ9GuprjfpH
Rp3kI8z3VuiHPUx/gbbInopNkHT1f1vluSHTOov3izHE5h+2/7D9Rdq+kY6M
37rglUXfBLobsAXQK/LDz/945Dk/9hjKUt8a6O4ai1ezLUOGHnbkyHYr9VsZ
tsl4x9utxW95yP7gI6PBe9qeLc5HfcCEjfuFGp+rq22TBL3s6BhHr/uMer8x
TkmzbD36CtBbkCWcL2qx/Dv2DQ+Um5pmfXWXdLfOuj80j31azCcGvxj7GWFk
7pG9Rw8x/NTwW8NTvZPyLu3ueHWx9Q5zd1sgHO1abBrNpBrzkMBLMkD5P1D+
WdkeswNi3DrkezzZcwZW2q4S9syR6UdmH1n/LfoX+C+hSxUdpOiHPDDqYZzR
MX1ghE+rMY8WvFro3uNuCWzI8P+scXo5w3PAmM1PMO2Juyf5/gleZvi9+9d5
bLLTze/Md3iwe8AT1eAz4ErNUc9Wj1dCnft3UZp1E6LDB10+3TPsw1uOXfaM
LNNdeffmjYO3jtMzzeN6Wqbp9+hCgP/13kzrvGA/nJ3psuj/gX4GzxWwYusK
2gwyucjhfh10m7eF/7ParZsduXTo7MjHP5hnH7m297TG3pXbusT8ydAr4Vdn
310evOvg3lExtuDbypDXe7/UtE5owPDzP5htHv6tNM85LY4jC/hzyAN+mW8a
KLoxHmsMHRnKP0Dz/kGFbV7Afwc/FW+I78BH1G67GPxjb41zKfviYbE2gWVV
wAMOHBVrhHV9WPz331M9D6ue51RPTbH1hsOrBk5jbwbbL8uUlqq1fXm29YKg
8wHdD/y78uL8iV4S0sAf9oh9YkzQGdKQbzmy55CFVPjZPNvwpTz6hqvKXXeh
yi4q97ign+wG1fEAPM/8t5DzyTZ/3bLS+JdlmB58RbZpwl8HLY37K2uBdtHb
hl0j7Bv9xrthhftDmZX1pj2SjnwUNErok8g1AycyHdh5rI4zW58t/CHQxDSP
9X0SEjZQVv+Ovyt97+bu2jfO1Tsq/a9K39M/avS+Cp5+luVyc+ErqLQOqb4l
Hpe6WL/YZqzJd/vIpHOmRa8C8nB1ARt9rI2xBcaaOHOO5i6RbV77ushDndD1
1mV7b4d/eo3czEzrrWStMO+fK29Srsf6s3zfUxh/dPxs0fEAjqBjAF15V6pf
Z2f7/Mw+hy4E9CSgAwl9O+jdQcfe4NCzh06+gaHT73nha1IXtaVyT6if6/P8
r0D2Hz3G6AHYrAso/ikJEUY3DjaFwE/WyL7xjXTSTon0MzQXZ2T77rMu6uc/
taUu7Eqhh4g+MbbrhA8X5lt3EPqN0EOBDgp0t2EHk7Vzdb55tbbYxMXnf3FV
vvm8yIfMKfhWEP+UY2M/Z487Nv4vk7v43YZ3ocZijzs4fWW++SOuUXh77RNL
hGdXZVtGCFiYa2TLJys8QuG/9G86WPku4F+jsa6qs5wqcqXIl3JPXFPrOs5E
jlLhq7Ot0wndarTDPrCkyTLV7XEOfSDOoux1C+OcOVX9ukBuXkf7F24J51tn
GDiBTQxsY2BrAN0y5EPODns0UyP/YfonPNXL+U4TDhyMvbJC6x4bH/Ugz4y9
nPPV14N1Tjmuu+dlVIVphbzJVqiOD+VO6Oq8Z9Xb5gu2X86MMDrJTik0Xs6j
jlafS6kXOzy3lBg+YEOmBhw+OfK/qLp79NV/r6vfI6G5Q29H7xrydcikNFX5
fZJ4KXJr8uuh6UG31nn1EsUHak7Gq/6eGdaXcmGheeSwd4TdI+wfoTfrmEKv
saoClytR3omq58lW66GiX9i2AW7KTYqyhxb7O/qnoLHAa8dd/qtat7u81u+v
vEPwBnF2qW2T3FBiWzTYKCGOnQ7sLc1R+nFq8031f2Kh9ZxMjPpnN9n2APKG
vJ9z/4bvnzco3qJ4r8TmFPsLtqvYw2dH/oaADd4A5EqRL2XfRYaBvYgy1HFd
1PNyo3ny2FO7CR9uqrAeXHhA0O0DrwJ3RO6C3A2blGd2hW0+NCp8fYX1raLH
JwNd8MrTrvQ7K6x/HdoGdUDfuDba5f0OHzh4U8M+JP1Ffy96c7aOc/IppdY5
MilsMdBH6Dn49Jk9E11DyKmh8wc5BGQ8KAMNHx4E5HiQYSMfen3Q3zI58Ir/
3g0xbtC75jR5PJCHgH8Pnj7+MzfF/4hv8IDy5gAfKGHoY4w34w7v5cddzI+w
Or7PiTzvBi81PADIlyNnDj2vRvlqiywPh7z6xMAReCvRtYk+OPS5oUNxs/63
fOtyQ9cb+jiPiDy/Y0uCtyf5BwmvZvdyPmzDJ0Y+9qiL663fsqLIb7380xcp
T51cFXBHnlW1tvu+n/B+bKH3avR9sl+vj7bQdYke0LGRXqWxvqzeMv7QHqAN
QHO4rsB1o9fkAO0zh3a3Drp+2lMPifB0lbu03ncHdMYh84rsKrrC4Ml8XmWH
F9g2G3bZTu8tuHtZ7yDn5HFKb0OeSbBVRt+w4UZ+bKqh64W8yM/SDnDekWHe
U8YC/S3Ikx5YaLnXywIe+oIDPuiKB2hsr1e7BxX6fzo9YN5X6df2cvlltYbn
C/n3lBkW2pjexeWoH71P6EyFB5U704yAZ7MOc7k/0qwDjf3/MqWfqrk4oNj7
1zTmo9D4j+wHMh7l6bYph205bM1dVmr/6hLTmqBhQW/Cbtrp9baNxb50WoQ3
nwGjTvZM7MGxT93X1fmfq7QjP3vba9if6et9YQn6T/p5vjnDHB177JOc6wK3
s6odZqzuLzC9D3oZeryg3UC32UN7xj6ljtOnWdEvbOBdz16q8EfopddYN6S7
vpqo//oYN/KcW+6y7I3og782xpNvhNFVvpfa2LvQ9xDKUb4o0/YBr6m3bT50
CGHza7MNWN63lb6p1veXvaIsODIjcID7F3nQ7/SMxm1YoWkxzMvVUednlQ4z
P6Mqzevxeon1ZaJ/E15t9B7TJra33lFfk/qZHoZeRGwL8d+HnwjeG2in8FD8
lmV+CeiPvLWiWwx66sbge4VfhvcheGbqlb9OLgOaotZ9g1xjkenRvO1sr3YH
lFuGBv11UwXf+XLvKP6ocPgRuYYi2+iBhwz+MXhliENrWqzxebXJ9WPD54PI
M6zONurK5PpkGpaZ6b5T5au9VVku91qU5azEmQn9SjPjnYM3DnQKks456jHd
rdbKfVFs2VNkUJHtfERpq9usF7xHkfEMvXHUTR74kLfVv3H3Uo8H44q+SXSN
oqsJvXW0w70b+ectssbIY3M+ub6L+Q343w+I/m6RgX0tYJjZ6DrR77ok6qQv
7EFvRVvvQ2Pp638HY1of8zKrwHHCiXFWhD76f02dd3xVVfb2KYIiCYQUSEJy
cwshITflloSMIygWbNiwoM4ojqJib1jGroyi2LEDdkRFsKCIiAL2d6zYBR0d
C/Y69jrzPl+e5cffH+dz9tln77XL2WeXVZ6Fjg/fHJ0r9ox3x77xGdHZfqTn
vh019t5Uu74daFn04yGP3jplfUfkKGCF7B1nRPqfsy22jS8NNL8XHV34MDcE
bxn/z5T3uz9o9qyczUcX9E/qOqbB59uH2Aewb6/yesxa/JK+w1Kdfx+rsc9P
6ow/L/SQsE/CrxljmfWRdqEfwRmKs9Rzqvv4kW7z7CqPU+yw4W3i/wn+4Ym1
rjd1Rp6Czjny0MPLfA5kPGPfhW0HYxqdR8YtY5Z9I3qX6JkPGma56Q0xtl+O
8fxk9Df1fU798epA40myD3kp9iTUnTV+RMioXor9yc9a4zrardf5XsptApfv
NNX/tYH29cn+oTH2bOBIHD/CmJfgN5w7wrgQ06A3wntM7jz/brsN3gT228ga
wV7BF3FttXFTeO5ssG+qk2uMZwYeGVhk0DknaJL/7KDJeF9Lf6BxN6kPfFSw
VI4osyxilWg/PMjP4NeCzQ0eN36P91fcnfEfnRVjnnZMj7acqj3A/1Of9Coz
1h1rPDIx9oRXxL70DX2H/zEX6npdaSeOtL0d/qlvjjN+q9p1fb39IL2asG4n
Op7wudlfweturjOfDDnp7ei5N3pOzyctF9ypzHMeY4Vxgk4r3wL56UEatyd3
W54GpiJl4xcbnX/kUej0rvXHHvV5VOkPztlHRGWD9U0G19iPHroK6Cyw9q0T
8iL4FbTl1fjO4HFwBio2WScJfaQOjZmHkt4jvqB+2L3g+QzbcGwl0Nt5tdY2
u9hHc1YgnvNCfZnbNwecAY3N8WWWdSB7x3YKGX2Z2ra80s/4xN5V98uYa+Gr
5/wMRgh1YzwurDVdaKL7Sz8hy9466rRVlJ+Iur0jOjvnXDbf/9xoI9hm4KWt
1WGo/wNr9nH14fE5+51AZsh4QAaK/ODQMstEkF0gwwAHnvtJEX5Cec/Ieb1C
1toYZzTmbMpm3mZtYu2D7814JT+yC+Quh5VZFvNarfGGZpbYj8YOZcZ0xa4b
2SxjFRkDmI/gPdZF3QmPqXW74LUfpD7fTd9uQtJ2/HXRJz0D222tL7/BDtMP
rDfg+4GNxvkcLEf4P+C3gvOKjwX04pErIFMYqXC3rr9pjNykNXwYNmVq46SU
7fGwV+G83zvlM//xCaeFB4mtHmlWlXr8kJcxNCrldZF1iLWR8EKlOQldpHbz
YLAFwSYEvZFtU9atR8+nRt+6n+qzkdJ/r7T9Fd4w5TPuoe0+30Jvw6A5stwY
+mDXgN8PbXg7Lyj9i7rWS9kPAPwaeChPKO7/6eqh+BN0bhjdZj4L9pSTor3w
IuAlwI94tGj+As8H8F7X6GqfaUpS3n8XVcdOXRNTlu+zB2Pft0L5HtL1S9J8
lEntwUtJOC0yB3gq1JHz5NNK80zRfb1XvesIv2aV4lYXXR56qUc2eS1eVev6
3KfvtWe9y4Engo0C/YmvQGyHsQvFjqiP6ti30/2OzS62u+drDO9d7/02++7h
imtKeeyOSZrPBm/uFtX9a9WhUe/uzdiGmLyM8+GRnu/fGGPgVqX/tmhaE+t9
7uP8V6TslGVy8FK+T/o88mel/7VoO+KHVceD2l12WuM0o+dxKZ9XoQF/Dble
MejQ1nHR3peVr0en98DY6KVStr+7nT1PyvvcH1XOT0U/Y0+MXTF+XkqUr1TX
6JTjNon4kzVuz2o3T7G36lPR6Xf41iAO3iL72VEx5pFPQgNdsQ1HmjcE3wf9
k61S3jslRKOh08+jlObkdp9Xr8mYVwWfahUyzE731w1aC7pStkN8l/18p5+P
bzX/Eb7hplFvdMDS2BZrnDRhO6A+3i5lnPBzlPdjtX2Y3k9V+AOFyxXeW2km
Ji2zmae55VLRn9Df44oxBb/tWc2L/YvGFP+l3nlIv7Xq0K9ovF1wsKEDhjm2
w7skbQuMDfHOEe6ptL2Kfj5d9dpS92tYe1TmY106EzNeNe+NU/ya/v4X+A/g
X/IOG9ETFD9e5Q4sGjMam1Hise8rVb5tdO2nsiYgxyka2/Zk7Rl2bbUOPzq2
2IWiZ3tVzm2mvVvofd+i8X83Knhvyr60Vuv8UuwygieMTj98YTDX79V1YH/r
NLEnQLdnpPp2/25jRcxsdF70MdZlTtL1F8U/l/K8jj3p9AbL+JHvF5J+D67x
b5oPk10ug7SsBeNE/+1aPxMeqzr3Kfpdb92v6f7D9m7XoM//cEToHWFzgO0B
9iaHZ9yn9Oez2Lcq3FZmPsHAlHmgb4rmW0U//0v3Ke2O3zPl9NX4GE/4mTB6
fcxR6AFiO4sN7ZMlvu8e4T1SfmY8g+WATif6nC0aA9t1GPt4msr5SOVV6ptO
V/gT5h+FT1V4/ax18tEXRocYPdvTFf8+NpxV/g7YfdHeLxT3ZdFzwZnoSCpc
UWX+cGX8a6tV5uEq+3w9n6hvfka71wx0WhbH9+VMNF7XUwp3tFqfHl16xil3
1k3OTDtGmqG6b6Xra9VzeY3TkeZdlf9e0WXvlHR6zlm9dd8h6b0CmA1gN4Dh
sBP/StHPjPH74nvVh/0z/Kdu1ecX1Wc7/kmF/1swrZ8aHIcuC30/Ken+f0vv
/62rA9uUvPeF7AnvVzlLi56Xj2X90XWe+mmLrLGn4Uswdl6P8fOK8u3SafwT
1gTwbFgX8GFEGHyY+1SHVUnjpYzTXPcn5Rkx2FgJTyvPEdozn6E63Jw1ry+X
tr7wRPQ90HUp2MfMNIVTBcukpyqcLNhPz6kKNxTsi4gy/xXlQvsZ5kj2V2rT
eR32UTNK5V9edLpv1IdHpWwvdXW7eXDw387T+/OLtuugDHwpIUf6T8L9Qp/U
6v30DvsOQv5OWmTwFyt+RtG2Ih/gayVl/znw9nYP+usn7IMHHztDFX9uh8uo
4N8q2rYZmQyyGXh3Fw31txjT2+2nHeC9IUOnHOToH6kPpivvXWrvDIUv1rVa
ZeyOfazSPFNqrBoway5BZ0T9NrRgHwlf15uXBB/pu3rr2KEndbnmxudUt1no
TdVbjwodqksU/6ziL1d4ds5yemT0pcNsC4Kc4Lqc5d/IvvGDgb00fi9Wo78j
OrcET2hU2nyhTtWnumD57lDm7YJ1Tr7W/Nen3fgr+GdHhwn9JcogL7LRVvRD
CtYhXJyzvBxeQrXiyxT/BPy3TuOzYO/+H9Fcp914M2ehn6j4I9jL1luHA/2N
JTnzHeA5YMswssn2DD+JZrZgPFB0qMBMQY+oRd90D+X9ED/Wyvsy+pA11nfq
iPG8XsJ+hvAxVMjaXxS8dNoxOvrhB9FvKQTGa9r/A3l7qr5fqN7dej5N/9Fx
WcevUfoRBdtevKtwc8H2HD90Wv+ef6lRccMLrt/kjGkiX3tI6ZsKloktSvis
yDnxTsaRrq80bhbofruuLxS+X9fSpOXWf2cf3W5bLmTZ90f8CYo/UdfjrEEq
fy9dp6SMl0Uc6elPsKTPhw9faZxEcO1WRhmM1e/Vh3uIzq8Kn5fy3Hwq5xi1
e7ei8RMu1lpXkjVOyPHBa4YXTdzuRcd/ofAeneYpXK3+u7bLOJ176v1eRefJ
NHm/1Kx+OFlxpxRta7Sp5qXTFa4ud79wjkY3Hx255UnzZo9mTSz6Hboop6W8
n+H9ikhzhN4fqWtZ0jIY9trIs/HdhFwd2fyKoW4nbXxPdTysaJkU9E4Pmlsn
rQOH/hu8Q+oIngL7EfoYO8MzUs5zIXwDja9Di/5mT6gPHu90eYxj6jJVefdv
tC+6NxV/Qcp1OBSsFKV9rcP89N00Rg7qtNx0S/atug5L2TcXd/wLMc8dHnPd
+7UOX9TLczf+2JBjE3dExCP3+Thp2c91tFXXB0mfF7hzZthc5YzVdYjy3KY6
7tRkvtPIrP2lIT/6GF2FTvcbcirGLLKuW0Tv1qJxVcD+OjBl/C8wOYhDNrZI
7+/V9U3S5yDunIWQizHekXmxrjDHo1+AHyTqgm+lb/XvTOo0pvCOqs+BovNy
qfXFliTtB+Fg5OdFP3+t9Pt2GiNtU6WfXPQZNq3wPkXLiF9Rf09mD6T+u4k1
v+g+Wkfj8ICi5+0P9O9P6PRaUKO4czrcv4P1Xz8b5ZagW1s0jseIoV4LWQcn
qqz9OM+qrGEKTypa/r5Aac7kfFRivQbOBMPR49M/eGOndXP+jb0e54IS69Ky
d4Afjk7UmHrrRaEznssY54QzBz6KOHeAUwZeGfsWdJM2rbd+0v1gA+b8vLDR
/k42UP77FL9uznT7NRoTGT3YmxR3kcbi64pfqn9kF7XhX6XGzAYHHPuArPrq
ZWzNVLfts9ajJe9n6re/6PmrUuuJ4QMJXbEHlfY/Km+W2jVJZf9VY2xf3QeJ
zoOKn606/6XJ8Q8qzVL8zHc6PzpKo+utd3WP4nuqfqPCLxB39BdvUbnLgg4y
buyW0Z0Dy5+2grn/q9o0OGe+WInupbq2VLoW3bO6jlB4kWj0yrm8URljDUKj
j+L65ty/4GGBi/V30e+tuHVyfkZ/G99Jhyt+IfanGjMb6LmkwX6M8GFE/0MT
PDT0XHiPjtHLaut7bcbXWYu/Um/ZwubqyxE5P7+lPvyyzTz7ZQp/qzJuUV8d
rrZ/FfHwOzhPcpbk/+E/5zwPL4kzHue795V2TVvYyjSZn8IenvmF/5N587xW
62Kip4jfNfyvvV9ivlF11rwjcMAPrLeOTb3ihuf8fI3qNlzPp5Qat+f4JtvB
JfU+lTMtMACPazIO4OtK/0aX5VvwAsE4gMeO7zd8wL2tcDs8sQifJtrZTvtv
Wa/ad3h7YGeAWQAWAXM3PALsyJLIzLExVHh20v/Slbo2qvE3Zx18SOX/SXRv
RuauOiZyLjudcf7ny4wRcny9MUCQkyOLx27veuVtV97z4dEp/FqX3/XS98/l
rFuxAT5cog7YwRAGl6Mh6BPf2GE7PeyekJ/QH7MCZ4I+gee9St/80E7LYA+h
j0V/A6W/R2Uu0vW/tPeB3NkLvqPrST1fofF2v77nxlnrDv+pwfp/6P5dIBoX
5myj/l2Lxxbj6usW/7f8s6co399z9gW8nvpwXr1xFZ5W/OE565H8pPTLu/z/
Pq/4oxQ/X/F7Ku6BLtdzrObCY9ssl3hD6Y9Wmk2U/slKY6ODi4se4z+jbtgb
YHeAfQHzBXMEujLIEB6oN0bE1arPr2nPN3zfX9L+xneozDt1/aznC1WfqTnv
/T7p8H6FvQryed6j33e96nOW0qzbT/t/9c9tov+i+q2f6vtl1rx+5ANL623P
2M1eq966Zb1bbXtPXSco7Yyc5cjrKP5ihZ+u9z6e+9XwKDQXfRU0sUnANgEd
/1LOgEq/nsJH1bj/wOt4K2H+O/zr3bs8LzMnowcLRidYlLdpHnhIbbhV9Ju0
Nv3SZnyMNSnbMyPTQl8IP2HoDCG3Yf7DJrpTfTIwZ8yqcs3JK4JOBXG5P2xR
uMMvwrcNPHB862xb7fGIPgByG/R4kIuj7/N9YFMTBkuVvRb7g13qLd/ZX2N5
ZYvXxAmqf3XOmH7grSKTQx63VPcx6pe70MtW+H21fR77W9V5UM7YVB91WBaC
HAS9p8XUE11o9NmVvkfGcjXka/iDuCDtuLHgSCjN4i7PV5+q7W9nzR9AZnWf
rqp+1hVC3w5du09GWl6CrAS9qnt0zVP8an3DbVlD+hu3iO+CfnKX6jgy94dN
F3dkONhr1GV8btoj4/CaUut2LdI1X3Tmq25Lujy3bKd/p5/K/VR9NZp6Kn4b
/VMZ0R5StO7sN+rLu5RniupyPnyHpP3IXJsyZssl+r820PuRRb+bLBoH6Vqg
/thcY/KkTvsX/7PSdBftE/PpStMDq3+R3t+r6w3RukXj/7yk7S3geYwKvsdl
qtuqrHXM7k6ZB1i6rjFXsFPFRnX/Bu+D2QNvoXJP7rQuPD7lzo86g71CnZED
n642zkR3VvV/W3nPTVo3gb3hd63hcwL/JE22SV2kbzSrxe3dtGBf8vg1H1Ow
j238a6NvhHwX2S7l0EfYh4O5CO7fmB62oyYMxuIK3ZcHf5LypiXt54I2XR9t
3KHRZy3OWexBz0oamzfR4rUXORHy3jOT9rtBvhsiL/vWb1qdD4wZ3mFnDG4y
vkrBiL6gyXVAPgi/dJnCXT31n4l+S5vLRg8LjDx0sQ7Ud30q9qX3JAKLRGP5
53pjkSAzB3cWjFqwZ2/Qt5uXtW4Ae1ow9vDhCL1/Bh38b8LvZs8J7ScjvnWk
96/sXbtT5g8i17xf326BaJbzbwbvFfy5dtX3iC6X/TD1Tdm37EMpPxOeo/rc
nrUdGWe1dwueQ5jTjgXTGZ5A0vWBPj5pH4q8d4v+jy3GH9uiKvCyFZ6c9rfk
O/5TtD8sGNcBHinYDoSv13fYTHXbKGkbMGji85b3YAx0Kz6n7/VI1rzcWQrP
7rSt2kU6L8/oNrbmmuHGMYZHDX95k6T5nHc2WPaD3IfvuSzqszRtHdC1dU3Z
7o14aIEPR37iHox4xuaMGKvrZT1HMD9gcwEODnYXC+GlcN5W3tPQwdf91Abb
bfO/IFNekbbcdKrK/Vl5T1OaHuAOwSdR3g/hX+k7thftjwiMGHAxwMTAXps9
HngIc1PGzQGbhfucCF+k+fmIVuP5vJ4zX4/zHphpYAeAG/Bazmctzll7qoyj
k/YJQ12p+5fK+43SdChNveLnc17lPNzPWFK3x5n37KTrDz9hPrwapV+jvLem
jPkC/s9tih+u+HcU/6jG2GN58x3X1Te/LGt9lAuxxdD1v0HOd3Pk3aDBMj+w
A7FVYN7F5zVYQbQZrAJs28mDvX33MJdN3jPwe8a/L5rrab7fJO05aJ7qMwwZ
wCD7RgOLBEyRedFG8ArAh6IOYOkQNy/aDp8mHbyaOtGpKIQvuCbvsflHFsbc
yzwzosk+gS5PGj8TXFTO65PY76v9M+FjpL2vwgfBjRmnQ8Z3XKd1OtHRfDzt
/RZ7acbgJTEO54rGIaL1LPOt5oRr2o2FCl3KrNJ89ZH68Bq+qdLsynpb9H7p
aNbVonG5j1A5R+q6MOX/iDsYHd+lTQs6R+v9lE6XfUPG9WDOxg/dAUnbBtyS
8RzLnMr9xuiHS9RXb6h+Ryrd2znzr+H5vpkzvxhe8WXwwIsei3spPLhoun9F
9pe0nyj6vjL6/0rNN3NbPA7PUL2mdrq8S+GfF52nvsXnM2xD/jzM45jveGGr
9fgPS1q+xx0Z3/micYGuBSmfl/iu6Cjhh52648eM9i+I/scX8xFJ+0C7lrLg
k2rs9egy1ja4nncq7gX9k4trbAMNfjd2tWB4Dw48h+f1fIje39HDWDCEkd/N
C51x9v9gghym8Ds9/J504OAxPx4a6dljs79Gz+rwGudlX3207lN03TXAe90j
I564Y3QtVHwf9PMVvnuA0xPmvPBwrWn9Xj55wc3DboRzNTY7xB8eNHl/WISh
cVzQOafGeJwHlXhuJcz8zP2cCG+vsXxA1nrT2JTgdxD/OPhEJs1xvdxnVdGH
vB/YaL91tOXoKAtfdgMiHl40fHn46juJ/mTRTyvcVWc66PzgT+nJOBPhQ+np
2IN9Wu287IW4nxlhfNnj/2+THi6nNOrJOeao/9MPhDlT/N6nr2hs3Kz7XGQO
SnNTucPH9/Wdd+j3IlO4JdKsCvvLM0sdd3PE91SZ6Nciw+LeM2wd0cflGZtH
0pIHPh5jZnaMkxk19pV8RYQ5+3HuQ6eG+PcG+Cx7SaThPiPC6DpDhzHLvgT+
FzZ4F0cabNnxaXlijff/+FvZqMk+V3rrmlNj3eMrleZGxmh/28Ngazipv32F
wR9bWWo+F2F8dp2hb7dtt/1wk5+8jb09fqfEdydtv8hLOTcFfexuKAPb5etq
HKYs2nF19Mnv77BZxhYFOc/e/W17wDO+PHapcXjvKH9O0L8KeUeTzw7ltaYD
/a0S5gXSR2epXhWN1hXcsdm26shZhmTt7wRMVfaw2Dywj8WuCHsibJKwucEO
Yq3/vqTj2A8ntJbmsrangOeayZrveqHWgVTWmHibJcz74l+9TnPSDV3+JuBV
fZMy5j/nofFhz45dO2HOSsjuzi9Yfnd9pf3r4FsH7Ffqiwyrq8Z0OEcPyxv7
GNzjFSpnRNbj9h/If3SdMsg82sas+bTo+aMHj654J3sB5Flp6/TtEXp9X2ac
Bn7RjAZj8iKPJq4s4gv19rG8jeLHK99OBet/I1vCHwtt/Slnvj88fzCDwfWF
1l0N3iMi194zYbkOuH34jhiatk08Ohf4FUbvgvMQeIucieDFwL/gf/9Hk/HD
sUkan3RdqSd25c832GYcHvlmWfPJwbwD+w5M53EZ40qDKc29V2BMP5/zXpN9
5u/f5r1S6z+BjY8Pm+NVr78XLIN+I2e9NPTGVuUs+0fuD542uH7IdcH4At8L
/P+rwcXQPHjWAI9JcAcYo983+//FP+0j+u/20H+3e5XjTor/+oBy14dxsrLO
ezgwZq9NOw2YANxPjvTI5xjzew2wvB0/Isjc38pZJwndo4zKuBfdoHL/W8wX
jB/Ox0cXfEZGLnZc2F9wtuPO+Y6060R6xuO3MSYnKm9D1nK0bTLuC2RMAxV3
TMHlceYDB59zHzYP0GKO4TyBfS+yfuT+3MHQmzLS/CPog30OBjr501EHaGAH
yrji3IHexF0xxtCNQS+G+YF5jfkOf4Po3yDvYq+LTyp4bOiTb6e47XUdLJrb
whfStbvyzgw7M3S6Vmud+kuN+TCTdN9P11eK373GaeCZkBdaYDE9UGs6YPlu
H/HQJG7HCD8Z5b3Uw/YJ2Cmgd1kfYTCsemofdUKbeZ+USdnwUqC3bdDBpgRb
d2xDbgjdZOq2T43D8HwmRt4v4RvX25buiwFu01+jXbt2GTcBzITdFLenrs+V
5mql3yvauFfEE753gOm+p7zX1duGb7HihmKzHjYXpN0rytq7xmmo/431bg/h
t6pdV+q5VOn2V7hS4QfQR6z5I47wnf3/qDd1+72dtGtmjdORhnJ3i3py3z3C
vWsdBsNwUpV9J+MzmAsfyvioZG1hjcH/OPZcj+EfQt/l3WrLccE5uXGo8yI3
4T3p4MEsqvHzMwqnmvzdWNNJj49MyqisNe7NgbF/Y18ILxp6dUETu0fSvBj7
sspIz7iuqPXY5l4eYdKRhn0ccbwDf2lx9DvfCmzxfw6zv1rs2R6Pdu1a43WX
NZc+nhx9SNqhMSZ5TzowG7hPqDHu04SIJy99Sl/frfFwSb3fEY9cm35Dvvb7
Gn9VT9stYePE/uqzavuBxu8c2G/gbMJbww8z8ZyX8adM/HeD7Fe5JMLQ+F/Q
AbuCZ/AryE8acO3mVHgeYN/CmN07xh7/Gf/bvuXGZwLXCfv6SQnLVLD5HVtn
nzfgSI+ucRqwHXYe6mdkLqQbHfHcN4r4RuUb1mj8ZHQIRjXZ32cm4qG5req8
udK3ap+wWGecU/S/T+9v2QzxzPnIpVKxB4bf/Vml8dHm1vt78a+AIQFdfLFB
m7LBwN6wyeXCEz5NtMd1O/+V7DdrzMPnv+H/2arE+6yNYq81K+IZD5fW2LaP
9OS7NMIfxd4M3BL0CNBpQJdgnRFOg/0+7RgbbYQedJEpoyN0VdC5NOrzwQCX
c3nEI2tEPro4znZD4kyHPRvpsIuhLdBBvsz9yv9TT8LgNqELgSyNfQt9iV09
9vWb1jge+Rp7Lfgg8EDahvqZ8H+1Fn1TsM4Dax/x7OtyNZYpIk+sQCdJ4b5K
v7La+CKjoVPjdKTZPGF5LHJgcBSIv7e/5TzIrpH10E9b6Foy0DI6woyFgu7F
Gvuba6/x8/gSxxFmD0O9OqNuyJGQObPO9Um4nseWeR2YGOMfnAZkk+iTIKOi
XmB28P2oP7LRLeLbUQf6jv7C7m+x/qlNauyvh7hNIn7LxB8ybeI2jb4dEDgG
9DnlZWuML0H/tEdbOiJMX4HhRhrkpOBmt9QYi5u41oin/9qiD8nXEf2A7Jpv
hfwang79CvZK/0qnp6zv9E13bve+dgftkW5r8XqKbvK2Besnn6E0L+RtY9Rb
47mjyfgJVUr/Ud56kk3IKNXm5/XNvwB3RddLCm+Ss00g9oDIN1Ih4zhXNF9U
3mWi2YE/kbRxUJFHoceMTIp1HFsj1u/HlL5XwTZFFZrbtkzbbpE1tK3B6+hl
2td/UDCvol7lJLqss1OX9h77I33HIYqr1rWznluVt7fyvqG6fQXvRNcqhXNN
biNn87v0/EPCWNrrKN+lWduPLaq2/3iw3rfI2R4SW8hTkDu3WUdriZ5/UprF
1ZYLYl90v/K2q9w+KvftauPbgL2Ird98PX+v9LdV238yPpXBnWLs/S3tfyEP
X7HLz91K+7OupUp/i8qf22F87yew89L1DTjX1b7PAkeh2jxR9DCXis7jSlNa
7rbS5gfKzbvGZgl5BHskcAfYG9XmLEtDjvao+qBKdRivdMsTvuOfoEFpVnR4
/C1V/I7pwDdXvs911XAGgvff5Xf8j3UN/ievVfxPeePBoRdAWsY6/2Ztg8f6
tsqzXdqyjIfimfBOucDIq7HuCPGXsA9X/MMd3nui45wJPWd0LxoarI8Bve2D
zq+KH9RgfZNXNY5uzXq9XiWaA6vs55lvNTbGHmNwiwizTwaXgX0w/dke44c9
IfgO7PleVP7SKssdrhftui73NXvLlgbvEdkzNDV434DMHLk+cxLyulzQnKJ2
PdZhngT2u9Tns+AL5RvMDzohZ5su+GLIupFPMwbZ+8PvZv//j5xtt+A3wQME
PwJe3myl/zFv/eoJaeO7/a4/TxgbLPzMJNLGb2tIO4yOELKFsQXLF+DTb1Yw
r36tnKLBfC3SkmeB8vZMGC8BfIXTE/bnhy8//K4OT9uXUybtMPPGJ/q3cgXL
i/O6F3Ttx1jR+6yubZXm7ITj9kN/SnNbV8HydPZX1IF9VJG4guWWRyZ8R3ZZ
n/Z8wVzxnPpnf+X/vtLzB/HzKszX37hg3n5bo32+Nip8edr7DPYYV2kevRnZ
WW/7tcO33w7Rpky064SEffKx3z0zYf+U6Hy15a3Thj7bxjoD7pF1386sdd6t
BhjLgD4DOwe5xyYFyz6GobcaadZEfS6LModFPHt47DMY25erjje12J/OuIRl
k7SnocXtxoaauuOrD71Z9HIJo4f+O0YGOEPDkLWI5neivVr1fz3vZ3hC6zdY
Jwo9Q3QMyfOr2vdG3nsz1vwBDdaF+1Hh/g3WvfopdK3Y+9zP/Jo3LXhdAxus
C4eOw5q89RwYm4xXsAjxJ7hL1BM8OXTCwcJBvsncj4wzo/r0BQtAZc1WGT3V
9pmDLPPHjhQb0vVFfzm2Fewvdf83cyb8HN3fzPq/SKDPqbgf9H020HjZsGCb
LL51U4zbE5Xm8AZjIo1Ie7wyVg+JNIz3sxL224TPpomRhjWRvRJloi93o+bt
DQq2Ab621rSgg8wJ2RNrUx/NK327/NyIDkuH9zIni/7BDcZtgy558alUi36m
4r+oNT8WbFB4se922Ncj+NXJYZ4rmV/xF8g8mokzQrLBe31826BLhBzhmkb7
6MVmE50XfPbAowa/FRxXcNfPUXyvpPft0xTumfRZjfe9I83NKnNVyvpUb9O+
lPWXRmmtPztrOz7knJSFrHOp+uaBgu3ISpK2a8Km6UylXV7wM3pCA5K2lUam
he4S9tSnsX4V7JOA8ijr4P62RaU+rH13pq0rsSm65cOM/45uFTYTz4bcfNtW
+2QCexSZ2JCE5WK3qs7zOp2uWv21UvdpJebhJZLmE85VPV9S3nTS4xe6jGHq
sirazvkX2thxz8pbFwo9KOryRtQHu1542OAsz0GemTSfgHqTDrz6axTfN2le
Qkr3ZNJn7q/QOVE9rxSdO9r8TJg+K4l+W1zrMH2LDu8OWfP/ZzdYJ2CtL8ta
65SgT7Kn+nZywfoDV9Tb9wC+BPbT/PZpi/shX+Xvgb07ertftlh3d1iTdXHQ
w8EGFr4qPtHwpwcfF5wb6o7dEfXfRuWMK9gW7Ke0bQiRV8EPoO/ot29V3+Pa
TBc9rAsa3GfwG6ADnwE7uR0LtpUDp3B68NPmD/L3TAyybzd8uuHbDT24D3Me
T/gJxf4QW61tVLfrGtxXl+p/6qdvdk619Wvw84aODXZn+KPk+TX1/apO6yI+
Kpr/r9P7yZfBZW0w9sx1yju/wX7loH1t0MdmEF+i+BcFSw25KTJT0t4W6a9R
2w8ouA/RAf+kxXrg+FTl26HLsUvS35LveFzOun3IPibXuizsZZ5NeJyCAX6B
6rm9ztTrVtl+Djs9bOiwwdo17LDAEfylwXj16Py9kzJGFrbtxKPHiz4g8bzf
N20fF8xph1Q4rrHEWIS/Bh1s2fB5QTrwCLHdwqcAuIQ/Rxh7iL2ytomY2mGd
fvT5C9geNllWyLqO7Bd7942S9iGN3TuYxtDkjHNqndPjn2Uj+N6iebvSv9Ng
HSbO8uhL/txincnDlOaWgvHi31OZazqto4ut5NYF20tO5+yhfjxb9zLlHdTl
/ehU0f5B4+Rutb1C4cvb7L8VfedP8u6rLzTPfKfw38stY5+SDV/YSnN81rzc
kyssWwb7gjt6NugNbpy0L2Fs77Gbw6cwz7uIzjFZ29C9H+nRN8BXGzjm74Ue
AvHQ2yVnHHNkzsNUn8qCMZHf4nyv9Icge1SaSwvm5aPn/nzKuu74tcXeD341
c+HzMR/i/7U24jfNWVcV3uBM3Z8qOM9i9eV9ndaHPAbeftbyZfQ30UXgH53f
aZ+m+DO9SO8fVd5K8g7yOF00yPWg7Cd76lsl/B7cTOryQtSnWmv6Y8pbhU6R
8vRV3oWDbCdGHBgoF+n77KDxv57eXVbr8YDsBj1Z9HrRleXffT/+X/Qj0CtF
RwLcI7CJwChq1PfcOWt8APBVKAP67JXRnQEvAZ/n+DdnjN7R7HEMZsXhSdMA
J2V31WdWweXxvhhprlXcdQW343T9C7ML9gOK//ePmQNF/4qcbR4Yz/cPcpvu
0/2hTtuZY2POObYQ/84NonFjwf16nsrdrtt9xFni1tC5Xa1/YkjOeqLgiaEr
w54FDIxdsb0YYHumCQp/p3HSW3SuwlahynrEO1VZjoEuTH2r9WH2qbIuPz6h
DoJ3kTOPbpnyLm8zrRW6P6RrN4VfT1sPib4ciqy80thU+Cyub7LuKP5G6yL8
ZdryKGT181SXPqLTU3mf0r0+7/KRVUL7R6VZnbYeCXPJp2nLP4lHJ2NNvfnM
8BRHh5wa31MLdT1Me5ttdzK5yvYEG4SdAv7KU7WOR+6zMmQ/tfBddO2oMftM
le9r7dfRa1U4UeWyqAM8TPxKUd5D5V672JMs4Dyivrw95/phHwjO+TElrjd1
/KHcfmnxSYtvenwF41+YZ3Tw2Z+xV1rGmiZalw/yPHRHznMR80Fjq+cE+unT
6BN0vv6bs97XfxT3ddp9y3o8LGzK8AF7S5f9wPJtL4vvi5xtVs6yNmzQSM/e
AHnvDTnLfGdWm26PCtMmDJ1D26zPxD4DG8eaVssWB7faTgYbmee6bANJ/Oom
yws7yy3nB6caWTx2b5nACngvbVzLIQp/pvDnaY+ZWWk//1bu70z/H6y+7Sfa
13Z7T4Es/dqc5emM1w/THv/w4vmGJbpXao90n9IMZm5UPxdajev7TtplUy55
OO99W26bTvxDYNcJz3vD4Lej+0CZ7GEo5/0oK6e0i0X3k3rXnTqji45u4K85
6weiX80/cj778TbrpfEPcibhG15aGvqe9dbVpFzocxZG//TenHksC5KWhdKn
nG/xUQ3+AGdgZD/Io5pVl880z+yVsK0d8vIzqoyp9teEfYa8qjoMz/sZuwd4
yvBtwZtFFwE9hAWac0qVZo/+IYtrsp/ZSfq+w9v8/y9CXyttXLud855/mXub
R1rPAB2Dp5ucBp4n9wWRHpsYdM1p433qj3+Rn3M8cvsq+2egv5hP8F+8WPEb
Kv5m0Rla5TPzb4NsKzCqyvYCZaJ3i65j4CHwnyrvJuWu6yZVnq+mpx0/ptRx
R8U8Rlx1pOd83JzwGRl72nTCczY6Frthj637t/om+aLTXZR23dERPTdtOpTz
X/XhojbrHt+gcsYp3ytK82fOXm3GTgTrkTkd2d8PLdbTRUcXPWD0dNHR7UWb
uvyMr7CJCfuo2E9x++uap7LO1nyyv+Ln8C+pL6vznsuqlfdX9e8N5fZTNDhv
X0XYh2Fvho1YVmkOF517RGfLvHVW0Fe5U2kGKDy5v2224Muv5cnXW28GnZnB
yrugzTbjC6t8xuOcdKXG4KNdxg+AL5Ootf+jTbK2YcB+YaOs7XCwwRmt8BKF
55d6LscnOPP2FJU1PmF7u81jHK6VKVZ7DWH9Yn64J9YCbD6w2cBeI6d7Xtd+
yj+jyv3EWKCPiLtR94tUx9/UP3OUdx+9Gwkfo9w8zn0T5nP+ovdnd3lcdope
hcIH6N0a7I+6PC+xl9o7YX/L+P1uzfvfRMenKm89H+yisGFgTalAz7bTfKM7
4r+Ah4yuyQTwjqvMQ8W2EF4TOjHwC5ATpli78h6LzDlfxpyJXId1jHkVnhFz
Dz71VjbYtxd2xGCbg0ON37dhEQcWJbrbF+etv72L6vgC44P9W519hiDzRYbw
eNZyBGhAi7n0eaV9R3l6lxjvDL42fnevEr2Zup5Av0n99KLmhRNV1+eU/hn9
P5dU2VaZb8OeYlf8tiLfwhZH14qE8Wz/kfG3I90b2k9ekve7S9lHjDTeMHsP
MJXAU3pH/fp2p7H34I2h3w9/rKzG9mBgAoClyLcFqxD/8viWP6W/+VZgoIF1
9o7q+G7O631l2r7AsEHDlwrtB8e7VP3z97RxX+FzgVMDRs0OGjNP5vyMD2Hq
CN7YFarzlXnX9YS0+4O8H6pdl+e9du+tvkq32S/OUVVuB/iB7er/j9vsM2as
0o7M+3zBnvvz+Ka0gzM9uLVgaB+fNubTj2CU5Y1Vjf7TgoRxjN/KGKsIv6bw
aOZXGTcMW5YFVeY/fK4y1+02DtycrLHw4AO8qe+4Q7vTYXt0Ut72R9OYj3Q9
ofBlGT8nyv/QXUb//w7ROTdvnUbsLsCIBK9wuuJ2GunnTdQPm+qaqvxb6L5l
l+lObbKMBJw0zmJnpn3+ao7vQ1/hhwc/N4NjrH4a/QN/ivGIT00wE8FOBEsP
jCRwJvFRdK7K79dhP2yN5f6+H4nmBVnzjOAXsZfDPpUxP5v1rsN+uOHnYUcJ
T+/SjL8xNC7I+HuAafZKp21cyf8d2IbRV/QR4ddKbFN5RXxH4qZFGupyQoyZ
V9uNhwIWyij1zWhdf692voMjbyM4abV+3rnVfiUZ3y+mjf0ItjNYJqe12u4c
7JOTWm1Df3nSuvH4Wr+t2bry+IIHE+XsVuOCwNdfHbx9MCbWVR9OK7WMgjMD
54XPNU5mtnn/MFD1PbfLeoXgqfyj1XgnD6pfz2w1xhXzPbbVzPlLFX9yqzHV
Ni83Hg9+ncDFBFPqT6XGl9qg6GewLGnXjXr/gPKe3mqctiN1fzHn+l2i8i/V
9VraeD8jisb8qdT3vaLNmMybKG6WxnyL2jxbceO7ve9AV5d9Lvw68P7Jh6+S
AyqtE4ze7/axR2F/MkPl/KXN+5Qq0b+yzXjv37YZfwTsETBZ+iUs72DMUi/S
0+fzmv0Npijtyzmn4zu0xLfAHn1Ol/ec76a9r4XPCa5JV9CHx7+81Xz+uZzt
1JZ2lZPE1rnJ+2Tu6BuhawQOC/7OEiXGZwHvF/9Qbwd99syV7Ivi7HCDaO4i
mtkqx2UifuNW+4cm/xiFV+RMF50myiqNfXoy6vA3pZldtFwLzGnuyGnAjNmj
1bgxfx7sMxXnKXDBkHMg45gH1o7oL6h2W5JB/3HkdDmnS0R7aSPyk3GtlqGA
ybF34HKcW25eKnzUT5HBFf2M7nQi8s5Re3dVe1sV/yK4iF3+j2gDadDRPrbc
fTyl3DwmxvLxjMlq24pvWW7+DjQOKjfW1IZFj2/6+O34jvCuCQ8u97pO/w4v
N04EMiHkQfu1W96GzAk+Ed9hv3L/B/zn7G3g2SEPRm9iLdYG/E320WrL5Dbv
g/GDgT8MfG2s1vV6hfGBx0R4Y12b6XpD17g+fia8TR/rQ1CvI/uJznDPecyZ
qRHGr/+QvYHS/ito0A7GEHn2rP7Dn8CIaCf0GEfpOCcmRvj9B4ofOsL+Et4s
MS4imIhgk78R9KkPeGJghpGueoTfv17itRDsQ+pUNtRn0yLvmnxendRo/1MX
hp/HWmTu3T4X8Iz/x09L7YflvQr7VcHv4UXN1kUBq5e5iXnpA71/X9fYfr7z
vLC/z9yZOKdzVhgS5wXqQX3we7lxfIMatWWx3t+n6yRkfMNcLlignY1+9wi6
PQrf22Q/S9SR+oNltG+105AX/0ukQUf6vMA1BR/1KP1fE4rWj8XnGvXANybr
6tzgdYL7uqrZPmKWoFuh6/RB5r/Cjz87rmnV5g1+X2ts+u9LLFuGv4Wsjfui
CMMfgzeGD7hxqvfDovl5ide6s2LPMENj89isdZKpA7iz8GNPrHAYbFvq9VrE
ny060xot4xuquNpm22qBWUsaMG+RN96YsMyRf/CC6KuXa9w22oWex7nVrl8h
dKYYk480uZ7UF/8eYGmDRXxOYB2DSfzzYO+zwIxF37AkdBG7Gv0d+W5/anQf
djeGLXrUH34Ue3jKA6N4VrNxYufqG+1YNN/yiwbzFek/eEP3Rx9+02Sf9Pij
Z729u9VrLmXQrkfh8Q40TeSP+JNaEj6lkHvD10TG/Rxytk7z8eCfsu6y5rLu
3Bbr0VPq/6cr7F8M/hj+1+GRXjHQc9XnGp9zkQkpvKXuV2Xcb63lzkd+fL4g
X8c328mic3ezw/how+/y80rzRbn1r6gn/xS+1ag3fnxeUxm/ivY6PS2LxsYA
efS31fYZzzt8t+BjZk5v+0R7OspdWWH6+NGgLk9G/DXgEA5xvZ+MeuJjE/v+
VyuMc7tXufGr8I3GWlgT7aVu+McCf35us58Jz1AbL047HetPItY71nb6k3Wc
b4ae6Val9p33mq7xKutPUS4YA426XtB1grbrzw73en5TiX3QEr9lD68X9D+y
V+5Dom7dQXNH0ewY6Hriw4t8L0beeeyNqo1RCe8FHVn0Y5dEn9P/YNqC1wNW
Dzik7IHY/4Abf7Gux/r7fknMh+DFz4h4dIDAzwU7l3WINOhIkH5GhL8e7v+e
PXCZ/vuybucBYxc/SiNKTYv5diwsSs2ta1TP8phj18R8uybm3s0VHjXEcy/x
YO8ig2f8M9d2xXx7UdSfOsOrqwt+3Wda39fvtt0zdrTYA2NLC/8e+QEyrSnN
HrvwrL6L8cfej/5eFX3OOGbM9Sz1v3JH/C8XBR8QHiA+ZVbGmMTmGztryqUM
8iA7GxU0GSPY4/5Ya5vcn5irhjh8T9SHf+rnar+DN7UE7MAOx2ETCI8A/sAD
sdaw1rN3XVt3lXWtyn1TdDZVmi81Ns7E1k7X+aLxZ+15jqm23fbDacs17tWc
U2yzLgGY1Q8GTbDi3ms1Xhw+B5ZFPGefRyr8rfFR9mCsp+DJvdNqTDnq9UCs
g8hy0RFEnptnXVD4wbSxacDEQZ8TX3L4S8MHFnqtuYTn0sdF7xftkTr0vMMw
+8LAJwb4O8ShL0r5y2JtPUG0T+xy227W+e5WXU3DfA0fZtuctXbCg+335py0
9dPQU0PnjbF+juaTsgqHGfPPD/Y74tFHJC36zOiDoA/FmERWeUur5ZX4CsEf
CbZXVUr/qtIMLDW9V4POHsPsAwVfKJsNtq9EsJ7weUgYP6Hcb43wUaXG6d+s
lzHy+wZuP7jE2DZ8MNj6WvMiz6yB7k/8xB0NH0D75jEJ9zPfDn9zyL6GJiz/
AgPv85xx8MAKR8f36B7eW+J7Bj9rn+j9Zznr4k5JWocGG/Deer+IsgZY75e8
6AOv1vq1UOGT2P9qbFzeavnLlbqvEZ2ahP3csG/Fnzb+bSiLOPQ4wElEl2Ou
0n+ZMz/3VrVlLHK+SuvuQAMb6nP0zad3WVYETuGKVs/16PHgbwmfU/Cxnw6d
zw/A36t2vfdudL8w9nbqNIYaOhjjO4zFBpYF/xD9d7vK2kFp1s8bV22nDuO7
gaUBDkRHm3nA+Bt8OPoZ3cinQ38YOT9jHx0AsCF/bDU+5GuNHt8Lo7+XRp/v
Psy6VvAQ0IGa0+o9Ev8dPgL5x8CA/L7VOJAHtRmTgjrcpHp2FY1Fgm8o+gH+
MPMTGBPoZDKWX4jx3Ae/JE3Wq2ffjb8g9t7rV/i7bdXDff5Ojb87+lP0P3GM
OcYeugT4cX6r2fMQ9J4LmpkR9tWJ31vo3f47zYQxBU6vtj/AZ5psO4AMcEWz
+cn4VKpvtg1+TbP/3R9KvN+4M+be80pcHv5VD9MaNKzbZRQGWsetvK/fPxNp
mCOpJz5N2EMtjH3UTfqmT+r73sS8WeU9BXuiCzrMr4FXkwgeyfy4CCOnntnk
tNgvs296JPZO2zY6zP6TuXhqtcuDp3nTIPvaRvaBTh4yDnyXvBl1g5eZKZif
iZwfWSayfjCbuOMT8LaoB327tdreoLbP0rtLlG/7omXkP1f5nEx5d2ts3NNp
/apDVK/3VK+xg81Hub3VvJR51bafwXYG2cwLTfZ5io3TStXt6bg/32z8GfyJ
kGbzmKOejzBjD/9kv/t/446Ps4sH2O5nY8qqNS3oMB6fjzE5bqDD+DrGvuqF
ZpcPdgMY+fi3qWv2nT0L50Z88XHGfCHqRvqPddY+UmvBX4c4jnfIbno1e4yN
rDDG64MKv6R7RbPrz7yLLe5y9vlVxjtE55R9FNjQ6Pmyt4GfhP4ve6qi2vJQ
s+VN6+i+DJtk1adPs+O3rXDc8oiHt3Rnq/lLlP0A+yr2HM0O9yrx/cEIYxeF
Xi86vacmjSuCji/1g+6lFT6XYkNFGnQj+Af5P5iLWT/xhwsuD+cOfKQiM8Hf
En6A7sGGZbj1/MHNRz6EbOgz7Pq17h6oObB6qMOTe/o+OMLIuPABhpwrpbik
rkd7GYOqPXCoZvRy/MW6fyKaldhx6/55nelQTkW9418G8gFdlBbjDb6hvvrv
SJeB/ec3w+0PlPu3w8272E5nlh0ylqvuq7aeqftuau/4gaYLzf6i+VuX032p
e289v1hl7LTrWoyf9lSn8X8ZF32UL61rnXq3i/Ajvf54po0rNWd82GFcLOw8
Pu2wrQd2JB932JZkgr7DFhnLtfk/sSFhXqpQm35RWT1K3DepoA/uxdUtxr4A
Dwz7DWw2OcPm6n2OXaK8s1uMB3Kr7j90+N0novd5l/uNcndFxyPjsxZnLmy6
kRXPb7G8GCxs3l9RYezzpqLHONj/jUWPfXTgmS+YK+iTmqgnNlCE+5X6u/Fd
6edtM/4efIsVNX7G5vIrva9Wui91n1Ln9H17+mIsrNvTdCpibJww1BiPnwww
34W5knlygd7druuBdX2/Q9e7yGeHOjx9XZdPufTtHZGeeHh2YMNwRmb+o13M
o9g3bJ2xfcp6Ghc/dvkZWSi4sshDqfcQ1W1WT49XwjOj7tT5FRV3j/IcrPR3
657VnLx1m239D2pyPHblE4f4mTDnJPqb+YQ8xDMfvK18vbotd0MODQ2wAtD1
PLDJuov/0lh9s9N2++wlDlD8gsH2T0UafFRRx+qoJ7Lfjqzlv2ADY7+N7fZW
GY9PxsJLGhufaSw9qryPs7dqMw8X/QR0E+7v738OP7trfeyq7b1F/5c+xpcF
AxSM2az6rUXXkVX2V3Z4yO/Av+X9WaJzHt9feb/t5X+rT4yrdPwL/GdzlOYn
5gv9L0+pPi+oPkfHv9k3xl7fyAsd9ojn8b7M8qUjQ8b0bfy33/Wynit8w8+U
t7f+o0p976+VLqO2V0UYuRDY6Nh1tqrsnthf9XU7Cf+s+7rKu56uPTPGR8S+
ETvETxmzTW4nPvJ4j05Hs/qjSddhVd5DgQfEPpb2/RhthHavKKuvaA9td17i
6Gd8aveONNSFvD8z/vp6Lv2tznPy4kafNyaq7OcGOB7f6zdFevr1tyq/Zz91
HP7x6jxOGC9D4j+tG2o5Ofrz7/ZxPd/pY3uzqTEeKGvvjHUVoPMfXcfGv/5V
0KxTO0pHuszvYt5mLl9W6f0W+6d9KjzGdi1xvv9E3v0zxt5FB+Bvw8z3IQ/j
baeMx1wiY/0Z6kQ6MDfRpQWXl7zoqRJG75Z3DapPmeqzX9DeL9J8DJZOxrjT
/eu8xrC+TFPcTfpe51R5vfo8+pl2Utenezrui+hnnum/Z3Rf1midA/pxSKx1
zCFg34KNC/7t3xrNT+F8/WOMeb7pe4HFBn7UMcj3Y+78ItZO+gf+MeMZvujV
6s8LRG89hbdUX21V7Wf4NNDHF+oW2BVW+z+hLVVRJ/x30r7/DbR8Dl4efKSr
k7YrZd58Mu18/Gd9k7adQ68em65rInyf5ph9c37Gj2FJxnjk6Kfc0WIdlWXt
to1BpgMOJbZh2OwvUt69c8bC3E/pH1b/zBtie7OrIk1z1ngoYFNgS4HtGfYU
2J6BQYmtK7rDd2WtP4xd36xYQ8+qNn+E/fjd8Kpzpsv8NyHWSv6Rx6P/8wMd
Zr96mt6dnrGuFL430XVAz+HALvsNRVdqutI+WOf/9LDQ9UGHBZ+ue7RbVvZo
jddl9gP4TWVs0e/sjZfU2a/o8k7rJKGPVKl9YstI4+fz3z6FLZzqtpnu9+k6
oML0JgTN+xpdV+pJHsLYuQ8TjS1Vh40HO9+Tuv6t8XNa0NxCNDePeGhjs4LN
OXYry9RXB+ZsY0EfUd4jNdZpXVFpvVbsGq/L2rbxKt23zNn25VqN8526rTuI
fvrYnHXUz26wHSC4AZyR+Tf5B/dW+i26rTOLzcSEnPWTsRW8tN5YBNiUnhN1
+6f6/0ldVRljAi6P+mDbd3XW9n2jBvs9+iNLksZDZ34+Ve/H5+wfCvuw7XK2
EcM+eOucbYQ/qfA3fQJ+r+JG6TpDZf9lqHFkwJAB9/TGGHvYoGDTix3KUtHf
P/eHH8HrYz+8QdbYzeDtPKRwz4L7eonCk3Iex9j6zgk66Mj/I2s9eXSFmTfB
4zpfcaOVfmq9cYeGBhbrSng1GftLANeG+rKmX6n0m+dsh4QNM/mw+74RvfKc
+xcd8zE565ljMzwt/i9s7cF2x+7+7RbjZoKZCS9zeeANHq/xtQEYpir7lHb7
r8J31W7Uc6TtDedr/rmNebzSfm7wa4WfHdalm+K/O7Hd/rHwjXXmEGPkgY8H
DxVe6kSt49e2G6cP/sBTsaYxhn+O+ZNnZBkzM7ZdnR1hzubcZ0U8Zc6Nfxw/
QOAGIocCDx67RGwS+Tfnxn+3qcq+p858uYW6363rIPal+pfuUni+7v3Qxc/Y
jxD7Tvas56xr3znnZezXDF9u6JqgZ0I+aL2lvEsjPfvblZo3CiPtH35u9A91
GKf63KvwINVhJ7VhcZ351VsOcH2oy91Bk/CgqHNZ3BdF/d+MOlMucdDk/Htv
pCFfE3px3f5eRdWlc6R9aKNjx3oDL/3ZtNcZnt+Enq6E5tt7cj7nsA9Hj2//
WMffTHsNZxz/pjQj9C1L1A/rKG1Lu/2pomM4Kms9w38Hzc/UJ/XruQzo4+f5
0Iz3Wbwn3Selxk9iTIKnUan+Wabw+qUeJ09HH54eYeY/cJueqzN2U2PQoSz8
Fh2Wse+g77qso8wce36dabL/BNPjuSgLXdENs9YXBaeni70csi1sDzKWK/1b
37RbdC6uNr+IMYoslfWd78gZanKF52jm51LV4fKMfdZVxphm3CZFI6XrhIzb
siTaNURxY/kPB7sfVv6f9q2MeqIfR77RSvN6nB3gQ9Jm+vZT3YeKTp2uYzP2
H4A/MHw0oJ9I3IbKO7rCemzoL30S+xPqD48ZHh/8PeyYwb/GlvlhbETy1tnb
UPdRug5N2FYQzF/sCrsVd6z66GD4Ck3GizwezIFW6xihX/SK3m+WN87kcvbr
SrOsyj5JOgr2S8Kayp4N3bx/Vtn+GT0K9vjs+9nnY7+FH038pY0RvU3ypnV4
2us39NFvxa4Vm1ZsW0+KMHvY72N/uFD57s7b19lZTcaynKI6b4PuSt75/6bx
s0+X64QtCu2+i7NQq3Wq0Kea3mobA+wLjswaLxu7WnBzwf8FO3e06j9e8acp
/8tlxggDH2yG4i9o9xkQPXZkYr/j5xBGN/uMVutaoWe1WuGD85YZ36U8NyTM
K9y/2r6p8NWCjPHCoDNBtGcW7Wf+1Gq3tTreXxBpkMcRRh6NnfgVacuI+6qs
S3NeP35Uu7ZQuaeXGdOM+mM3hJ8qfIhOLbOM6rs4IwxXn22g/D+W+eyHnuXZ
6oe3srZPHhd9cF3Q2VxxJ+v7ThGtbbWPurDDPrzwv4V/zTOU/oZIT/9NRH6V
994YvWDy9VHaa5rsWxe/unyrs+N7Hal8R6WtzzI/Y1ksctiRacuW4K9frTy3
JozduhGYFarPaj1vpbJ2U1nDlWa+7gt0vY7u1BC//1OZ7WbAQARjZ7zWyekJ
y8B2Gm67uilV3u9/FWdY9JDRQcbHdLn+s5273O/YtEADe/CXgiZ4X9foPlvX
Y2W23SCMTtqWSWMT4EsIvWbsqLGhBldgTLuxBdqx2691HX7P/7ryNtW5Pujb
YFcxK2iCccA4fUzh/mr7LuzLlW973XfIu4wNOm2TgD3C80ozOW++yJjB/t58
6/+of1Yp7Ze659SXk9vtgxV87hvzxtBeDQag0qQV7lQfdHVZX+lo1WVK2npG
fZttGwCflnWYd6zFQ/XuFWSLovHJEPt7xtfzCtGfm7cvZvSkvg++B2dExgHn
xDrlfU3pP1P6j1S3v7QaA2EHlb+jrkuULq8+y9X6O+FfFX4xdWittj088kBw
BBkLyCvHqX3d6vdpCfP1bkuY79ej2r6r8Vu9kP28xlYvxf0LW6S8fQZvp7wH
dPuMMrbC/ws8kENjTuM8gg9FfDPglyGp+t6bt68QbPrxt4pd/6uKPyhvHSn0
kU9qt64MsnXsKJBTbz3c9rHgYA8FC03hJUNsn4O+CHLtZ0Rn/7xl+dN0Pztv
n6gbq2/G6DojbVk9ehfI6/G3gO8F1ou/iuYVCctNr1SbrtL14XDrYmG/ga4X
9vGH5W0jj13FfmFbcZnqMVfhlYONKU6+LVT3aeiPVJk3jr7T1NB5Qr8e3gw6
9vh5wgftpEHmj1Nf/Leia/NGq+e3fdQff1W5MxLWyTkj9HK+zthfWmaIbZKY
B+mLhiHGsk8Msf8qfFxNHGS5ND6lwJkg3eUxZ24v+q/GufIWtfG6vHU7kYFQ
5v6D/E1p6/AS7y3oQ3RIGC9XxZgBiwJfXPgWOwDZft6+xTgTcR5Clx4eyL6x
N8OnK36OD0VWqPQH5q078luzyyIN5cyI7wWuCb6v8MGbVp0HjTTew3lpf6O1
OCSttunCBmGK7sfkPT+Oz9i+nXpMUxsPzdsPJvmmR1703Fm30XXH/v3gtG3X
0QlDNwzdtZsztmvFD8LBKmuvvP/TZMhF4BsvUdz9ea9t+4DdpPC77AlU5yMU
fgq8I3xJNVpvn/0H+wbKx3ctfU0/n5J026gb/9OhsU+gPy6JPmF9Z63oo/Vo
lugfknddf1Eb78kbF4v94IzQNdpumHWJ0SnGny1+tfHRna92HZ8rM87LpFrT
fU5tPCBv/Z61PikTxkr5/y0ZDXY=
          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtnXm8z8X3xz9oIbtcF3Wvu9nuZ1+tkVSW7JVUCqEkJFulhBJl32WPChXZ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          "],
          VertexColors->None]}]}, 
      {GrayLevel[0.5], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxcnXWAl8UX7r8Luwu4bHeywNLdKopNSqogtvwwQMIuRNrEQAmVNFEUQRTF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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtnXmcz9X3xz8Vyb6NmUGzmbE0n2U+O5KtoiTZiSIpISqJLMmaIiopkpAi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          "],
          VertexColors->None]}]}}, {{}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[CompressedData["
1:eJwl23fc19P7B/A74SuVHSWrQqioJCujkFmIUmlSFA1EQ4l2aYmSlFQqEkpK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          "]],
         "1"],
        Annotation[#, 1, 
         "Tooltip"]& ]}, {}, {}}}], {{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, 
    InsetBox[
     GraphicsBox[
      {GrayLevel[1], EdgeForm[{GrayLevel[0], Thickness[0.05]}], 
       PolygonBox[{{-0.7, -0.7}, {0.7, -0.7}, {0.7, 0.7}, {-0.7, 0.7}}]},
      PlotRange->{{-1.05, 1.05}, {-1.05, 1.05}}], {-1., 0.}, Automatic, 
     Scaled[{0.05, 0.05}]]}},
  AspectRatio->Automatic,
  Axes->True,
  AxesOrigin->{0, 0},
  DisplayFunction:>$DisplayFunction,
  Frame->True,
  FrameTicks->None,
  Method->{"AxesInFront" -> True},
  PlotRange->{{-2.15, 1.15}, {-1., 1.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 ImageSize->{184, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->164794653]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["OrderStarInterpolation",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarInterpolation"], 
    Cell[TextData[{
     "specifies whether to display points where ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are equal"
    }], "TableText"]},
   {
    ButtonBox["OrderStarKind",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarKind"], Cell[
    TextData[{
     "specifies which kind (",
     Cell[BoxData[Cell["First", "InlineFormula"]], "InlineFormula"],
     " or ",
     Cell[BoxData["Second"], "InlineFormula"],
     ") of order star to draw"
    }], "TableText"]},
   {
    ButtonBox["OrderStarLegend",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarLegend"], 
    Cell["\<\
specifies whether to include a plot legend containing the various symbols \
used\
\>", "TableText"]},
   {
    ButtonBox["OrderStarPoles",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarPoles"], 
    Cell["\<\
specifies whether to indicate the poles of the approximant and/or the \
function\
\>", "TableText"]},
   {
    ButtonBox["OrderStarZeros",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarZeros"], 
    Cell["\<\
specifies whether to indicate the zeros of the approximant and/or the \
function\
\>", "TableText"]},
   {
    ButtonBox["OrderStarSymbolSize",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarSymbolSize"], 
    Cell["\<\
specifies the size of the symbols used to indicate zeros, poles, and \
interpolation points\
\>", "TableText"]},
   {
    ButtonBox["OrderStarSymbolThickness",
     BaseStyle->"Link",
     ButtonData->
      "paclet:FunctionApproximations/ref/OrderStarSymbolThickness"], 
    Cell["\<\
specifies the line thickness for the symbols used to indicate zeros, poles, \
and interpolation points\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->24105],

Cell[TextData[{
 "Options unique to ",
 Cell[BoxData[
  ButtonBox["OrderStarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->6423],

Cell[TextData[{
 "When you ask for certain features to be displayed and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is unable to find these features, you will obtain the message ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OrderStarPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"], "::", 
   "sols"}]], "InlineFormula"],
 " containing more specific information relating to the problem. ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " may also issue messages such as when inverse functions are being used. "
}], "Text",
 CellID->18919],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OrderStarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
  "InlineFormula"],
 " uses heuristics in order to determine what the independent variable is. \
You can save time in a very complicated expression by specifying the variable \
to use explicitly. If there is any ambiguity in the variable choice, then \
input returns unevaluated and an appropriate warning message is issued, since \
the function will not evaluate numerically."
}], "Text",
 CellID->14681],

Cell[TextData[{
 "This indicates the variable to use and highlights points where ",
 Cell[BoxData[
  RowBox[{"1", "+", 
   StyleBox["z", "TI"], "=", "exp", 
   RowBox[{"(", 
    StyleBox["z", "TI"], ")"}]}]], "InlineFormula"],
 ". This may not be possible in general if the relationship is nonalgebraic. \
"
}], "MathCaption",
 CellID->12622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OrderStarPlot", "[", 
  RowBox[{"approx", ",", 
   SuperscriptBox["\[ExponentialE]", "z"], ",", "z", ",", 
   RowBox[{"OrderStarInterpolation", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21188],

Cell[BoxData[
 GraphicsBox[{GraphicsComplexBox[CompressedData["
1:eJxk3Xn8p1VZ/3EQckFTM/Sn5IahuZeJpqbelqXmluESmRCRLW64pOaCG+GG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    "], {{
      {GrayLevel[1.], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxMnXd80LXz/wsd0L0otKWluxVaEFpAEVAU98KFIIoiQ1mK4setuFFUEJQl
iIq4994bBSdbFAXFgXuAKCA4fq+nr+Pn9497JO+8k8vlcrkkl1UxdNxRpzdP
SEg4ozYhIVHuV3KrBSdlJCTUJyckbEtKSPhDcJHgEcHDgosFj8b3qYI5gpsF
IwSzBbMEF0bchwTnCx4UPCBoSDa+7YIL4j//qhW+Se6v4EtLSNgqt73C9pR7
puAMwRsZjlOl8A7JjgN95wXu+wWLUxMStsjdRf8PiDzIf/9wiTs8aJwp2Edw
tuB/gr6Cc+K7j+AswXhBD+FKEbQQrBP+GxU2RHCy6MwXfKawBXWOs7tgpcKe
Euwh2CtwUIZ9BedGHgcGj6DvoOAv33sHLeR9cPCaf/sF7aR/QXndKXg3MyHh
EH1PiHjnKL9BgsMFm0XTT4LNCu+YbH7vECQImgSNgkRBd0E3wd+q/C5yOwua
CbpGvJ5K21KQKtgjeMB380jXNWi9W3CX4K9E49hV8Gei3U6CiRUJCVcJBucm
JGQGf+HNP4mmhbzvKJY8qI53kz876gZ+zC82nUmCrAgjfVV6QsJ6lfGTVPOY
/O8M/t0TNF1cKP4JBmYnJJyovCdnJSRcL7i6bULCXP0fhVw1SgbrExJ6VZi/
yNF90J1snv0pWKg4DyhOT8U5JeQdWR+ZZDy0gewc0SeYHzJ0b9BxTuDj+xrl
O0C03AKvhf8veB/yAe0LQtZx74CPyc6feBnCnZ7jNnGyYLrgJsFQwYz4vi/y
OzfyOzu+7xWeTwQfC+4Jd43g7nA/Sna5z036rz3h0mbu07+1kf7BCLsgygIf
Rwc/4Av6YL7iraIdJJs3I4PPd0Y5x0fdnBV1NSfSEe82pVkhWC64PXDwfYfg
g8D7iuBX9IVgV+W/Ve6bgjeS7d8i6KLwzoLjJE8vR9yNgiWShfcFE9R2XtX3
5sBF2bJSJJuC1+X/XfCbYGHg4/uu4NOHggWC1UHTaxEXXHfGf/6910VtVJBV
npDwkmTnRUF9QULCFZKl3vJvVnh5W8smMvGK4r4s+LvM9QMtGYJ1IZPUydqo
Y767JFt2/kkyj5IVNynF7WB88Bf+paT4Hzzlf2KK+dgixf8ak40jQe4Q0dNN
0Ez+YUnWkcjWldIpn6qd3UD+edJZakuVakcX1ohGtcPJ0Kd+435Bk/6drHIM
EVytsvyk9vu0YJHqIlNxrxCuKUnmXcsU03Gn4nZor3KXOT9kmvzR0+jrESHf
J8c/9PDJIf8zI+7waJMjQhbRC+hp9DX1kZri/JB3+Jqe4rpKS/G/ZcnmTXPB
ZOnX6wXNUlznxCVeG5WjtaCm8L+2ikxX5bj9759hHXBGtN9MlXW16OhI+5X/
A/kb5F8lt17uH4muQ+oSffBZktsY/eKnUed8f5Hk/vbR0AXERTesj7j0tZ+H
+0jIBPUKXuoTf0Lgz5Obm+z4reTmC0pUL20FG0XjvZLPGySfddJ1I6Mv+UXw
rPwPCwanuW+hz6a/pg+ujz6Zvpu+lz6Y/pmw9iGn7wreC/rfie+P4RH1EXru
7fhHf7VY8JZgSZLlMSH08VsRD/5Qjhz0RL7jLFXYAaqf/QWHZniswZijPvDD
M/T6asVfJTgkw3nRRxKPtga+bHSC/FnJpo98SdcxeA7P4ONd4tX14lVVhccm
8ITxSX/hPkbQJc/y+XbQXaC66NRKbT1k+534hz5cI/go9OSHyGzI87sR7674
z79LxedXk9yOpgevFoVLeSj3Y4rziKAxzW3qrfh/g74vE7ypOvxS8Ea0kZsC
x5uCdpKFUkGi4P3QDcjUPVFn0Er/8kl8L4o8t0U+O4KO16pFp+ALtYn7xKdO
auPjVP5Jau9t5H9J7f1dtaV3BOdlWr/Be/hO+/mAtkIbV1s8XbAo030KMgFd
6MK1QceC4BlpzlDc5zIsD0vkf1+wUv5xdU5L/zsncCCTN4e7U0YpKzJ7SlvL
CfJFPf0ZZWPcQ5+FnskWL9eIjycmeZxCX0dfxtgHXYWeWhu6iLEQ46Nh8S9H
aT/Wv5OSPN4CH/qrV4y50pI9zhoZ+X2ouCfI7YBsKu1H+h4sf++Im468irev
037F2wa1gw6CCaJ/z/hPW7s433Qy1jpN/rGC45M8Dhse9OUnedzM2HN9or/z
BJ/L3yr+fyF/QZK/v5S/dZK/v5K/TZK/N8hfmOTvr+UvSvJ3Y5SV/L5ReHGS
/10gnp9PHyTITfK4mbH5Rfq+UJAk2JZo/QkfHmqSjhQMrNTYQ+7tgoPlXyMe
7CG4XvKWEzj2CRlm3HF25HdoksfR+4cuRCciQ4xzGe/S3tKiPpBFwhjr0xbT
g+8fSq6Sky1j30Wb2hLtJCP4PlX19aP+vRZyCj7y2BZtjjZEO/8r5Ax9hqwi
w9+nOs7WkNG/I94/Ia/I8R9J/+kA2uv70U4Ko3zMJ+4SDQMFhwr+yrcOQYfv
FXKBrtsvdBu86BNhtEfqkrnKgVHHuAdEvR4c/1pFGHJzhHRHT8FtymvvwEHb
zguZol7R029q7JOk8GrV09+i6S218X0iLrp4Vmu1f8FshfeNMPT+vuFC652S
iQVtPX5hbIQeRy/cpPHIP+Ldj4pTJzoS6Lvkn1CiMZN0TkfhfLfc+qdE/nuq
1HbkP0b+1wrtv1565PM8f+Mn7rsRH/e98C+Xuyxwgnt5+D+s9JizMtPjTvyr
heds0bBQ/gs1jnqqyGNT/lfmG8+PGXbBc02m/y8NPNC1MOgZ2EntpavG7iXW
odDHXHkPlesg9UtPSg98oH5qdaO/J0o//Kx2cYnGot8r7neCOxV/pfCsZC4k
Xf1IO40VFJ4tfIsUf6XiH1Vg2pcEDZ8WOs4Y+XdRm/tFcS5XnE+FY4v8k+R/
SjBQeR4onGUNGl8o/MoClwke/aLwHwpNBzSA79PI9010tvxbFP5kkXlN+UaL
X/3ktlH4N7tKpwi+KJX8q56vUd0em+x2RP9K/3m8vqcIJgt+Uj2+K3m7Wv5B
EXY9sie52KH019J/y79d/knyvy33OrnHJVv/zwy8J+t7uuCmZLc3+mD62LOT
PddijvVWhJFmMO1fcIPgJMGNgmmMtwMH3ydGGPGGBR/mqYxD9T0j8psv2bhd
cHSG++6bQncUqB21ElQWWgfcFDSNTfac6lbBmHDnCU6R/rxZMFswOsJuIW6+
8xomOC3ZczDSfxF2D/Ta+GTPhZjrnJHsuRDzs3HhMv87M/7z7/QIA9f/gjfM
O88KF1wnBG+op1n5rvddVceXSaY/kH+x6vxZuc8JdlfZ78rw9yLR31BkP+EV
OZbn+xLtIlfPCs9pwvOE/K8Kz5Vq44/L35Bpl/DhSjunWmOm8L8i92XBURmW
Gfz9RVuy5Ly95Hh5gWl5PvKdU+Rv6ALH44FnvdrCH5L5yYpfjp5QvPeUb638
7eT/SP5itbVS+VfKf67GRI8ozVTRuVDttklt50iFV+h/peAH+e8Uvmcb/W+B
/M/I3yj/q2V2j1CcZfJ3l/9U5rmFLg9l2V/4H1T8nxS+q8LKhXO9/FWFpmGF
/O3ambY15Fthmt+Xv73ilMn/SaZpgaaXJBeV7Yznc4XXVDjOWvlfVPyXBHsr
3zNL7C9VuVLL/e9JhS+WzkkRP+eLP8kKH6r0LbNML3R3kv9w0fy1aG6RZVvO
Q4Ii4b9E7iOCI4Xn4QjfN8Mu328ozvgS46HsH8tdI5gm/w2SgVXyX5dpWVsV
8rZT73fKcNgHEU460h8t/4Pt7AfP4MBZL/8a0fir6uMqleXUEtMAPT8pPE1l
vEvh11eZ5sUZdh8N+q+T3N4qf/dsyyUydFWKefRCocdmjNNeCH7ivhj+H4Q/
OXg4SPneVmh88wqNs1Z19Haxefo2/Zd4nh708P+2iDNX7i2CbS0UVun0hEMT
/m5yjy93vIZsj0PQr4ydV0hndhF8k+q5BfMTbAXMmXsLeoUtYy/BnjHn30PQ
I2wufeIf8/Oe8S810vWMufqegeuiGtsd+oY9AfsDY+LH1E89KvhRsl+pcUBZ
ivv6lMhn9xTbgKrkVgp+SbZbIbhH6e4WrFPan5MdVi74Rn1Q17AJ3KH/8wUf
Ks4xkvHl4kGTwg+V/y35RyV7Xo7uHBrjL+YYzFd2jTD6jfah7+iXjhCf3kp1
/9Ip/tMn3KlxS2vhLBAsVN1dKp6fmO35/PDIA1tFd0G3sPvsFt+TsZ9jB0+1
3Wf3+LdNemyJcCxR2hbZxtMYfQK2Iewf2MmqU8wj7GI1Kf7GtlWb4u+d9nTG
eRNibMkY+oIIY1y4TjK5VnC02nNv0d9LcGTw9GjBUYKDVYffqj1c3dpj8X1i
jP6p2tAfu4gXBbaJHxhjy11UrmZprp+Jabb9YnvP6Cz5EKSoXT6p+nlC8EuZ
7eYHJf1nRz84aF2sOl0afd4E4bk4zWOBc2NMul/MD/YOmrD97SJ661Js58OF
F2eG/R+7WGNbx8FWuK/a4J256pdzbDfD3sUcraviNAkGZ9gm2zfyu0Pt+rjA
P1CyNKDI6y/nBS3wGnk8JnhH3sQfGHUzQHBs1Blu/6ingfGvMsJIjz1mcMhf
x5A1xiP1Mf7g3xLR+7ygj+B+1dt9gitE0y2qq7mCzirbnyrz88keb00Tv6cK
3hDPz0m2vZgxUA1zDMV7Idk2D2wVzDeYVzDXYp6xcxzPuJ45O/PzeTFvod0w
T8+LuMSbJDwHK/8OWZ7TYyNgTrauzvP8N+l31HZeEJyd6XkccbANYHs5MMO2
ylrR9rdoezHZY0Bswa/E+OO1+GY88np8MyZbGN+M0d6Ib8ZtO23PjOMWxfe5
gvuDF7eKN7Xqw1aW2VZHO0GuGVdim34p2WPQV+L7vWLjYbz3aMgu7WyJwt8X
DMiwnQ8cO9flLop44ELHodtWR7mxJzHPZC2HNZw9Y3zG2K1XjNtOj/+4jPt6
x3/+MRc7O8ZufWLcxhhwr3DBtXf8Pyvq8pxIs2/wgu+GkDXkjHUyxqOjo27P
i3istY2NfzvtMujQZ9RnjZFeeK/EZTgt4n0Y5cM2NlZ1WinYluq57F5RVmxD
2KqwFeWLf3mCskLP23sHD1hPYw1vt2TPy3sFP1oEz3auAfYI2q9TPtcKfkv1
3H7PwJUT5YdnzP2x62Fv2K42PinNY8iPIwyaMoOn0Jod6eDlR1Em0mdFGPGw
j3eRTs0ssF0Yey520PRIQ57YTD7V+PezRNs91iX6m7WzT+SuFTyXaT9rcWva
KK2gfa7X3fhPms8lt+sF7dXnj1P8VsyPM7w+uET/lyba5vOo4LFEj5dWxpiK
dcb3Ex3vYOE4tKPqrMxreMsVtiLRa4jgWJbotUhc/rEm+F6i0/+sdvyToJfy
3SA8Xwk6iZ5lqZ67vBN5zBXcwlxGcjKog/oHyUlb1XOxoJNoShXvlyrNLMVp
Kf8S+WeyVqmxzjDB0Ba2WVGOxwUzNM7/RmOkXhoHpSv+CsZQCj9S/cwRgn7q
a34UXYsTbcNPU5zlivOW/CtTTRfrn38Fje8Kjla6o0jfzuut70Y5saE9Enzc
EPk/wT/x7F3BdumtDxgbicYWgq9VxhaibavKuFn8qND8t6Pmv6tS/D9FsII1
H7lJgvflT5D7j9yVKf7Pv0bp0i6Cv1IsH8hNTtQ/coC87BF5kveNQvOm4I0E
ywdxiXeJyjRBNM0WPdP1b7FgkWCG4K34vinCSP+tdPeMRPPuvRTT9TfrUymm
N1HwvHBernp8v53l+EHBQ4me36UK9siwTZKwhxNtV4RnTybaloj7VKJtlQ8H
f5cIf7MW5sVM1e+P4mHvSpflfsEDyDRjvRaOtyzFtPDdMsdx4M1v4nmx0j5X
YNry/k+beyBo/Tbyf1owLXi2MMF1Pjvm3p00PlohPDeUu3++RnC1YHRbj/2P
jj6bsInRt0+KePPEw1sEQzNsQ14Ta0zZYRNmjQn78IexztRK+eQLHhPN56uu
Rou3N6m+/lRZdggOEg0b842fMQNlomzrw9b7ecjpw/Rhgqsybf9dHzzeHd0p
6CGaXqzRuERwhvLaW+3vJ401ZwvnGMGt0C44XTBfcLtglOAWwVzBWMFtEW+8
xhzlSntlim3k2M6xoZ8W6Yj3pHj1hOAswcjAMUdwarg3M04T3ClYwFhdPD9E
8KjKOzpoIe8z4v8d0JbvuRZzq3ERBq3YyLE3M9c4TeXPEyxQnMclq+eLn4sk
qx+qLa4WLFd77CG5GSsYI2gSnCIYIThK+X+t+E+Jhu76HiUYKegW7qmCiyWf
FwlKJJ9dI4z0uwe+0YK7lM9U6Ye7lVeScN4hOp5qZ52CfM0RdFT4+6r3Kcqr
hfwpggHl1q1zQm92Ea7hoQcbg0a+sat8r/r8TvCo8pquvB5RXrtF/tC9NPTu
PPSg5GibYD/hf1ZxnxF809btrSlw761y90YPqq/ZqPnIKtXvri3c/qGjc+gp
4vL9mPKdITyPlrpNdg1cHyt8jWBlqXUGNHUP3dE9eNk8XNIsCxpvTbT+6xG8
RLftEd/JEQauqdFeXxdsF41/CF6Tfze1nSdFzwbG8c0UT3CDYHXID3L2QcgM
36tCdu4I3Xt7fN8lHG9ojrNGePqJZ4cLxqtd1QvXic2Me43i7FDdHaq++Tfl
XaewWsEW+dvL3UXwh+JsE9SUWEeTN7RsSzCuDoLH1C4fFZwi2JrgMNLfo3SL
RMMnomGx/Ovl3yJ/K5UxX7BHiXXm3Ggj70eb4ntphNF+mituM0G94q8Wnh+E
J0H+eQq7RfCU/CcEn6YINie4HDWCbq2Mk36gKtvt9V3BMsnIUsE3kuerhWOi
4HbhOVm8mKZ41YIa8axa0LfMfcetoROWBV18r4gw+P57gnkGH/8R7r8FhUr7
h8IbmplfnVqK5+Ljn4KO8m9v4e935J8lmC3YnO3wBvkbNQa4Xnrhb+mB5yWP
zwmelkweKneSaJ5fYplcFv3b20ozM3AtEtwkmC7oIvgb2acNyP9XC3+/Jf+M
SLNrS9PFv8WRjn9vCm4MXF0FzQTNyUP5zxQ8UOK2sDR4Q3tZHrzpELJG/fyl
cv0pODbkg7DjkRPx6QPNX7qXuG2+F7LQtZXHENjnGUe8F/047XRJyMgemi/2
EAzMdZ0fJxjYzG1tRbQJ2uCqaDe7RJ6Dmrmdrow2VBdhx4XcgGNAM+sWaCG/
BpX1N9F5sOi8XzTfK3hB8nO2wv8nmFJivfJPjIe6hN7hu73iHqS0tYp/jeru
aqD0P52yU8ckhZ5oinFEs/+ja4g3Qvm0bvC6xwjhHC4YKZyFalcfqi+8XX2G
mkjCEMFJgmH6X628dlVenfkWDBXsGu7Jgnv1cY/gPsXpFGGknyuccwQnJljH
NQs6qhS3UtCp1PosOcaEndRWOqJryjweQRegS3rEf+phQK7XV0YJZqJ7BbOF
pytyJMI/a2udDd/Q1QsDB20L/Yie2hxjPdoVemiyCpYs+KvU479tkTfjwu0R
7/XAQfqvxacNgkMEX+S7nzgtw7Y/+mn65PdSzSsVJ2G8cC9S3V0sPpeIzraC
Pqrrfkp/uGBUoWV6kuAa9JDiP6ayfNn2v36XeqY+GOMyXjsx3KnB65viX7Vw
V3WyjQf5uzbwjlfYmYLrFT5O7umCa+WvlVsj2K/E8jtZcH3I+JT4RpavC1zH
xX++j1O6P6VLRxW4zqcHHaeE/FHnp6ssr6rs56rsneQ/RP4O8k9WvV0PlFqO
ZkR6eDYzvp+ulpwKeqrOP8t0fQ6NsUbX4Muw6JO7xLigMfJer77kM8HjdR4H
dI/2MTziEm+06OnVyTbpMdG39oixw27xPTbC6IPTYj7PPLZX1DPjxD1jDEfd
JwlnouBPlesKVf7lgsclzxfKvUBwX5nxzxPcInha5Tovxvd/ih87BL8r7Tui
e7H+zxDMRV+hRwRzwn1PUMs+L/aeSvZm6/td+oEWHuOD83zBTH2/jZ4W3Bzp
iNdebWQXwSL5Z0U64o0KusjzZunF2YK6XM8ZwHdBonk+M2gbHulnBv9nx/cp
kd/sqK858T0ycPP9P+nkTZq3TM70GG0U8+OYZ14smBDzoovi+6HI/8KYM10Y
/x6LuJfEHOtSwWUxx8K9POasl8S/pyLsihhzkeeYGGuODDp6ia6egiLBvmqL
0zQuvE19+2Wq2/WS4SntLDuFHSw/2BffbW8bY4nSf9dcY1NBaaLdHwS7Kv5W
xTlU8YcIz23yDxeeEdFv0+cO0Pj3WMHzGqMOiT6TvvPk6E/57is8Fcr3ZOEZ
Gn0s/4YHDvriwdJLJwh2l24aFmHEO0/zno2q9+ni/1PK50lB5wrJpehPEs7P
yjw2Z/31VEGRyl6i8NNU9jLpo3aCqmKPzU8NfrG+npPpteDp0F+veZ5wDlPa
F5R2pdKWK95P4sHP8EQ4RiTa1kG7uzXaQzulTVT881X2Mv37sbnT3Che3aPw
+az7JZqX/Hs66vDKmLOOCLoZ+zA2YvyTqbRvic8tlPYg8a19B699kd8yxhwt
bL/FTsW+Oey9n4bdClvZurBf7RCeuSpXftl/exl37rNbH98PRFzSsEeHMPZF
FolfhYJdCi2Phwv6CXI0f+qjvnh6he2u6yNfZPSwiMfayciYL66UTlghOCXF
snxoxHsk8iG/+aKxheCwVrbXrQ16MsOuh62RPSzsrWE/4M2ag9+Y5r0/GWET
JB77gH4Ne3hq2Gr/3denOdexSvtVntvcIUFHi3SNj2LfDuv97BnaGrZB8oQO
9iBhC8dOyZ4a9iKxJwnbL3Zw8vg+zkewjn+8cB4lWJxmOydpiTdPvLxF0FXy
NlfuAaGbxkiGRwtmqo56Cf9jGiM8KbncUzT3FjQq/vviy+/SZ18KWqhtpwgO
ZE1TsjdYsnGNwpMV1vX/tAH83dA/kucHmYe0tQ79O8a674T7Z8hT8xjjorNx
E1pa7/4TadDfhPE9VTy5QfBH6GjG8ttDF/8Z37cEXvDtIdp6CNqwB0a0PCz4
vK3bwRGCI0O39YvvzepPfhX8Ump9eaDgoNCbuAeHTj0g/l0cYYeEHuwu2E3w
iWTqY8HxBW5v5HNUosePSzt4DDky+ESaLfRjgk3K93jJyyBBN8nMTwr7UfC9
wvPUHj9W29xd7XEjNPJP4feIH3cLpopHJ4X+myZoK7zfNrdu/Uz1/Kmgrtxz
p5X/Zy61IuYy82NsvjLmtx/EN3vqsMdhh2OfGHYj7MTs7yMM2xh7yQjD5jo3
xu+M4z9ExkRzabnnz6sD7xqFj1F4ebn3s2EnJQ/2noGD7/mSscXiVbsK7y3E
jowdmr2a2KyxN49Xfa5RnM1tvLaGnQs71r5hw+O7UTzvIujYzmt0OfFvqL6f
k5yfmelzGNjOOcPygWhbKF5/WOK57PsxR/pe9HwnGF7hdVHsaPCDNUjKsHPv
IS682T9oIV63oBe7OGuY8Iuy7tx7x/fBEQauW2K+BR+ZU78bti/2c2Jrhhev
ZPrsCHvTWQ/G/oXtjfXhMfE9M/aKsj+UPaDsVQUHe1V3je8nxMPHBV+19b5U
aGXfK/vg9wyedA/c6FbW9cfHGG6d+L5W0DHX5xM4x8M6a88Y62HbY61+bNA0
PvARb4/4z79van1eiLNBT4uWpwRft/Ue2a5B04uZ3ieKza5e+RVJX72UaXso
4djtKQ82eng0L+bH8PFq4Z8ouKLGdoTl8W9UlJV9s+znZx//9kTv3U0IORse
PEMG2c/bFDRlxv7/HYne99oY/zgfwFpBp6T/zk1B0ylqr+eqXGNKnSeywPpJ
ZY7PAvXJ8Pp0dsgoOoP+m769i9J+qL5vj1LrmkLGGoKfJae9Ff5Pie0W2DLq
1faHSk43q13kssdP/eZ7gomV0p2Ks0VxXm/pfggcxdEv4qIzmoXdoSl0bmPY
M44KWhibJMR//qE3S4NW9GhJfB8e+PhGj4Ojc+imNwQLGYOJ/iM6eF8Ye3uH
tPf+3iq1wdtVrn3UN01R2a8R36aUelyGzQU7CvbRIR1sI4X2b5pb3zGmeyfi
3Rj2lDdiPEe6xTEuXBT/TmSfj/BkiVdt0GHCsaG5x4iLIx58+rq58xjX1nFa
K+xM+c9o6/1C1AnpiMf+cOqeveL0S9h6OoUdqHPYftaqjI0qc3W5wxh3Do14
jF8Zz+4v2vYT3K84H0vHnxjjNPoi8ofejhEX3d9JddtRMDjyGBq47pCemy84
KMt7T9mTxH5U2mpWyFwLyUh38fyaCrfPzPh3h9LMF4xQ/DHVwq02up++b2XP
GHb1LPe70A0t9IsFQV+idMNq/f9AsFRlXSI4VHzuKRofVNjj7G1T+ZYpfD/l
u6i16qS197n9Iv78UO99rwdHWeHxKsnMBwrfIJlZleW86I+Rx1Naen4wB9uj
4NFMy93w4G9j/Of7R+HprPL+JTzzq6S/RGtmlvcGr8/znrF+4snhgs9E22zh
myV4ONN4/olxyYWS2UdVhulKe2mZ99Kxj+4TyXGiytKePaqSr4OVV3N9N2tt
93bhf1B4HxD8XWAb6+ei4U/5++U7HnESIw143lYbfkfQUjR0EF0NTcbxnnDf
LTrOlB5ZrrivwEP5fy93GuJ/Jt03VOEnC04SDCGe8Ce0dv61eT5Hw//mGj/u
UmNafpWu/URl2ip/jvwnCN+Lbfw9QfB6pfexvir3tUq33wmi56Am53Gs/ANU
l7ny3yL+5ck9F50pWbpf/vzWnjcT/gx0yn1NcJbo/1Th6wRJ+h4n+rYrv9Pl
LlU+SwRZij9G39sUPlruBa1d3vPl3im+3CH4Q/9+Fk07CozjPoXdU+Hvn1r5
PzieE53HdTbvThftZwhaCtdw6Z3TKt3XTZLcDRKfq1XXr0t+BsjfjnGz0q5U
GZ9V2qHSV2Oxmyv+FuXTgTEavFb8wxS/ueJfl+ewr0X/K8pnTMR/UmFPCfop
zpfi6RPhHyH85yne+tbm2TvBt8cV/kSD00Df6Er3x6R7MtKyNsM3Nrd/KhwH
mvMCB3XxknCPZn1HaSeqjEeKzvwsxx0T8Wmbi9m7Lzxvtfb3v/tRlX8BY6bW
luHTKy3HC9QWxsn/TYbpfl1wjur0NfHhGOEvzHJbXxQ4t1cYR6bgY+H7RFAp
+X1dcvI8aZVXdY7TEH8f7LCl/rekzOFTM1xXY6K+kPcXBIOVdgDrXSrncwpf
WGm5Xcq+TbXNw1WGRtXJDNHwvsrwk2Rikv5/Jfx9JfvHqC2s0PcVwtWz2v42
meZfq+AhYSsj/Gbl9YXgPKUdIf5/LXxPqLwfVfr8APvtWe/fpPCN+r9N/l/l
35TrvRsFwvk8NgLR81P8ayP9v1xpL5FcPFRgGt/INT3vVPnfPqJz7xqnX6Dv
OwQbGe8pzWEKe0x9U8cC/yP8frn7KXxfZEltYS90g/iwp3hSJvr76Pu7PP8f
nGCX+PNF2+a2/n+CeHiz6PwhypOT73y/VLrb0Q2C3vJfh/22temoE+4BXTUu
VVmT1V7OFP9nqG6PUdx+rR2PdKRnz+qIGvt75Tk9/x9ivzf8E3yVa52wTHCZ
/o2SDE9UGVbF3BVdUZNjl3iXKk62cP0ePL9F9TRX8LG+31TaPkp7hMLXIkfQ
oLz21r91BbapLyv3P8L3kE7LEL5LmlumkK3h+u5Pu5Q+yZK/h9KlyX0vz3Ez
I/5RirN/V/97I9Iik8vaON6DmQ7j34hIlxVp2W8JDRP1fSB7F9gvjDyo3dyG
7lWbGNXKMoe8lar8X8t/QYbPfSCHrVVXQ5Rug2Co0s5UPS4rMU97ssegi/8R
Fzxt8r0e01f0LVN4hwbvoWf/fGON5QEelqLP1M7HK94w1mrEh0tKXD9LQ29D
yzdBz7fh5xxIv/jHeZDOra070BvDlNfZTe4fOra2Sx/xg2T/e8Gt+v5dZZ4T
Z4vmKX5b0X+zvqulb/5Q2mny36rwdhH+Y5XT30afg84X3RtF80VFxsd50nL0
kKBPme0h4MAmcqfq/a7WHmt1FP45wnt5ps83gXs6+xXFr7mBh/SXsO9S3y2r
7f77T7gvUr4tOS+k/zMi/i+qi55Kswc2UumhsciPyns6ulzwM/ZD8WmG4Ptm
0rWt/Y/wEuHfJBk9Q9/j8/yP8JOLHOdw0fa2yjJZ/t9Ull/zjZMx3nX04YJu
WeYjZ7U4ewtfZwVvJ6qs3zWZppkRTnlvUPhnKssl6GL5D+xq/8qIR5xd9P+v
XSwDf1dZp+6eZP25PHRsg3T7DNGawjhTcabLfy30i86b5K/JsDs9/OjPWyus
J9uJrrIm9/3XRrwv1V7Gst+/2GPO7cr/qkaPi7aIT9sEW/Nc9oxy64JTxcNT
qn0WZC/phKsbHe/yLIdxNmSW3JmC5ommZUbQw/iRcMaKjB1LS10Hy0XXCsG1
lW676BHa79LQW+gl9BTu2ET3J/DlStpBkXlJf3JKkeOPzjS910V9ocfwQ/+6
yIP92OWSz61Nrm/sp/Rt9Gtva078TZVp2KwyLmWeKB62KDGNJyhOqfxXy3+W
+PeO/k9Q/aXjV7xrW3sM+JNwPl/mb+z+I+UOE21TQpag6w79n18W/8SPUZXe
q7iDOzgqPR4g7NQIBwinPzwZm4DyHq7vk5V2BLLSxmuiLQVLhfPR1nbLWjvd
qYHzcaU7SemXMB5Q2LBKj8G2Vvgbf21rj5sZM/+t9viXYHVrxx0ecYZInsc3
OR7yzP9ZmaZlWNCzPPJAf1+tMt+tOMcr7V4dLXPI296So+P1/bri9JL7gHAO
UJr91Q8+LP8MxRmptrlOac8QPe8o3w5d/D20wWN9xvk1ir9A9TpW/nOF80vh
P1+yt07ycJTwnad6OVZuf8Ekhf/d1t/4UxX/CaW9JMf/B0S/Sx9NH0z/Svgx
Ef+YwEOcPbAVRV6rghe062Lsi12sr0qrrYPOZLzUxu6R4kPHWusk9ghdrXIc
ofKOb+0xO3MVxu23C/8HCr8Bnsg9q8H5Mu8hHmP8zoqzdRf3lcjZqQoblOJ1
l2Hyv57heczQGPshd4OKHG9YhBNnYfSr//bXnLcq9jfzGcJmJltvrYy63qeN
8x+RZbmeHO1uq9rkNPm3MD+qsf9V1p3lHyy4qdJhN0Y4Y39kg/E/8w90FXMY
wu6K8I0V5gF6969c6/o/5barNn/h2zzxYVWT6Xiz1O2NtkY88uyhPuoY/T9W
8F2F6Zuq8N2yTdv06Dug+fga/3tYPLhZOB5jDl7jsSLrF0mSt3Gqi2mSmR9r
3F99qPA+8j9a4Tka7mP/x/9IhcfVD7WyzvhY/pHC83MH+5uL5odj/rtnjeey
t6peqkVvTZPnafxjjnxYvuM+GGEXd7Q+Am95hed1zOkA0jFXLKvwPBAeVynu
AQ0Ob19k2rjXAbsn9uMXJD+b5P4qeJT5oOK/0OS5xCehj9hTvZfCThWe7qFn
0F8791vjMm5/j3mEYEyu8W0K/JSxd43L85h48lnYTsmDuda60B/oJnQIOuyU
0IfEXRfxAeZ5ryqvp0XPs02OCw7mePx7pJXphq4n5bbgrK/K1U+0d2pyPW3p
5Pk5c3PoXRI0H6s6el51dJDiJ7azfke3V+SaLsalIxTnM8V5QXG2Ck+jcJ4g
2diufmSdwp9R+AjF3S54Vv4c6ZsBitNbaU9TnGsV51P2KrRzn0E7/qHCcnqT
wm9o42/8jOtoD7SFX5TXVTG2P0H4Bjf536+CTRXWnytDF0NvZ/0fpDK2YYzN
HD/8W/T/9zaeI3+Vb/9d8m8X/u5KMyLHYcQryPMce2vE3xrh+HG3RZxT5f4j
eDnP9f5byNJa0XtWR8fD/ttcdfGmwi9Bp5X4u6vyPFG0lSqf8xT3zaaIp7DB
Eb455BNZ+p/ivNxk/n4bfFue475oaPRH1CmySJtdnWtdjB7uL7y90ctqa7tm
24/tcE+5e0V4nzb+5v+NrCWXOv0E5XmJoLTSe0/byT1TstZKfUqB4DSF7YHu
ERyvutg9/Ce0dj57Bv7ukp/1Kldrfb9d5njHM7aX2yAYmOl0uwce9ryS55Fy
L1P+lwsqmP/IXSU8W1ob39Qm4yRtz8j3UoUt07+f5P+CNeQm/xslXbeD8bR4
Ui+d2kFwRZnnuNtae557AefxNX+ZzvxWaXdXH9dN+K8UjqsEVYxx2pgW8P+i
ON2w7Spsaa7jviX+lwvPOsXfJ86T8f+NHO8XB8cJrIUpzlraSInL8Vnwp0m8
Wid/lvyDpD/KsPEwF5AMnKgx9i8hc7j3yj2zo+czzGVW5ln/PJJnuxT2JmxN
g0RjD/lfkXycWuq4pP1MefVG94nGS8r8n/ERtkDsOmcoziDFeZk5svxDhWds
g20HN6ldr1T4XIX3KrTsvSve/qNyvdHBtgXsQ1PLjCtd+S6qsC69stztljbb
R/nv3eR/6A7sUrPkTlHY2uDDt3K7cBZL/jzJXb5glHC8leuw53IsR8jTccLf
KfzI1aKykDGFj+po+xd58H/XiN9e4Xc3uT+CF6+KlkOV9vsi+88T/g2iYdcu
ro+TxJMVHUznH/TnFR43jlBe3yrNxDZO91qk/UbuBvp44f4q/EsVfnShv/F3
kzw+w/hSc4Fq1sYqvS5P2NMR3pMxmeAG1hfE55GiqbNoaKO6eHcX23noD9q2
dn+xn+Rn3xp/71/j7xL5+9ZYL36caB2J3uQ7RTQkV7uOsO9i531fNPzOOXT5
f85z2CsR/krE+UXhXYM29tX0am1aobO+yP4ejCuqHeffuMqzV5N59IpoOKfJ
dsMlKseaJtsDPlQdHyn8Z0sep+S6zV0uXj2f6//YCtCX6FN05nO5thdgK7is
g8fQjJ+xfT1Q6bbOWmOvoO195fVRk9NsFnQTdJEO/LDWNHaW/yXhOKvJdmp4
QxmI92W58e4bvCX/3qx5Kk07xrbyn9ja9nds7y2q/Y3/+QjHzon8DWrtOzSQ
0ePCP0w45wl/d/HtfNFwQYPjZWIbEUzIcnpwLlNeFynsYvqP1j7zzTnwnmGX
w49tDf3I/2cyjPtWxod5vgPt+AhHP+PnPjTcEyK8g9rIvU1epyAd6TlvPoez
55Xew9Au5mSUPV/xj+rqfnJ0teds/HueOmmy7R3ZfpZxL/zJte5hXtY12gLh
2ciG4NIspy8P/MgwNtDWrX22aGDwjfaOn3NGnHmFJu6eQpcNoE9QPsO6WJeh
x5AL6vH84MktUa4j1MbnSYaSle74Uo+rcuQ/UuU6oau/7xRdJ6ssv1V4PndS
zOmYnzF3AidjFf5jd3pVcjy5jfXATl3QQfKyTTT/zlqF0nZVuuO6Oh7zuqly
pyvu6wUeJzFGoj0tbOM29Ye+75Z/d+HZTWkHdXW8v9Xu/iryv3tE59Am59FD
ca5uMt62nA3pYBtXieCNNt7nXN7geRdzrk5yBwrnNW1M0zehx6CDsUjXbNvQ
GI9hRxtY6HDGJyeLvjuU5pdc67yvQ9dNEv6jm/w9tsC4L2d/kcaNfTra1rpj
F8+lmUdvDR2LTZQxKd/YTDfFWBDe8n9r6GFsVdcp3vW5Pi/E2gzzMPQI/Te6
pEa4j1W5LtL3X5Uu+8+ZtpkxX8dudh+8a2Mez2SMTBsI3hLeX/Oppa0cjzjs
/7ofHoonD7Sx/+1Mz32vafA8jrHhm509PgTHvYFnX+F5Qf5k1tIlb59W2H5y
lOIPFp1PMZ6UnCQUG/cDeQ5DJll/u6TBa3CHcX4hxtvz5R6j9CfLv0+j7RGU
7S6FD+zo/N4ULIqys87Hel9FnvnxZoQvDj8y0kL4D1B+54nPp6gNndfgdnW5
+qCHO7g/Olpx7pe/Sv69FGfvLu4bn1JYYVfnd2JH22uw1SxlDiQ4Ldfu8vDv
Xeh/y5XXA61MR0nEIZx1hC9bGQfzl/7K91nl0Vf+Yo2rdlWclipTYrnnuYns
Zyi3LQ87XpLGumfRdhXnO9YtVZZHCmwHwwbGvpMz5Y4XbFX8AYWW77PULn4T
L39vdPoflDZPaR9lTqqwPwUXMHeV+4/gIvlnqk+ZpbRtJRtHiIbZ3Ckj/xPi
y4nyt0r0f8ITUnwf0HTB3GTVQYnxsQaSm+3wnGynOynuM8F2f32Fbfs9REuq
eHudvveUP5P2TrutsPtsgdsoZaH9dqvxP8J7h38KY0XxaXih73RiTk7Yofm+
Q3NW0AmO44Int2abX/Dq2grnfyvjosCDnROaB0d52UfMfUnsj+1R5H+U5fls
x2GvBemGRdoZcmcGT+DBjPCPz7Ef3nDPzMVxfwt3tXDXTFOyy0n9NWX7/4SI
w/0cl8RdLpcV+hs/Z2aIc1y2/xM+WP4JVcZDeRvkdhT0yrLL93XiSX3494j5
17HYQ3J9bqFjxKnN9vlm9u9znw/+k9kzUuhv/JR9RPD/Z8lRTYP7AWi5LO4V
ubXJazPLY83qCvF8nwLf18y9zVdneb3oSvkPYu+B4jcTXFzhNTlk8+kC60vC
Xi7wvsPLgg/5bY3nmiy3A9rF4BzzBT5yBy739lwU/CTuxIh/VrQd2tE1EQ5d
uFdHnIFRZ9wdwblYeMdZVPaCU3bs3qfJPV3wBOssat/9xIvHy7238hHmiu2c
F2HQdptkKVl6sq/wHKO4/QXP6d9xgicE+eXeH/mk4CTRc6vK/LT8adIbXwj/
kY3+18CYU7geEM6Nhfa/zJhN/wcJXio3r1+VO0B66Ae15TXy/6r4X1Sbhn1Y
T2/luIe2sj6ClgNbuX+mL0H/00/zvV269AO5qwUfCM/oYn/jx10l6MHerVx/
4+dOto+KvN8Hd02R92+8V+478rjjbojoPVmwqNzzE+YpV7XxvSXfsW6S4fnw
X0HPPdHPQRdzoe/ibhP6tH+K/uvj6I92huH/R/n+U+hv/Jdz3l7++0T/T4X2
v8DakP79wNoK44EK6wt0BfqLb85JP1xkP+GjC30e6OpmPh/E992s6ZTZTzju
mAh/Otvx78r0eQDCGV+xV4j1IdaGjim2bCFX4wrtT0q0Ozb8jDvHhX9nf/BS
xD9DkJrl+OPCf32UhXJUyq0WXKi6PowxEneIiYfXiCcb5X9UZT+B/dWNlqHO
WY7DfUSbCx3ntUzPJZmL7qyH76O+uCMNHnJPGvfYkh/3fe0vGVsofOOF73jh
zq63fPZX3M2Cz5R2JHJa5Dz7srdH36dH/r8GncT9LeJj18C/W5aBf9yhhJ6r
D53GvQ3orvWh09Bl3C3G/HyL/F2yfNfA1sL/wvAzl/yDvT3yfyD/O6L5XcE+
2LMU/2eFP6zwacVuh78U+qw3bvskyxVxkLFNhY7zSIb3W/4ofwZ7Z0uMb3f6
uNqQxUj3U+D/MfzI5w0lvt+QOQXynEDbT/LdrHsJT1u5/TVefbPRd6MxD+J+
LeYOs2r9XS9ZW655+nLFuTvHc4s5EWdPuXsJSpn31fp73zyfu+6NzqR/Ef5X
lfayTI+5ljR63PWH/m8PXuWxnxJ6CqLNFbptvq9832OvGvviCx0O/Y1Z5jN3
SY0tN66dYX8Ezl+Ch+g67hrYFPxkvv971Fdthe+M47447o3D30MyP1mydnej
5Z6zNh2KPE9hL0WV/FO5A6LQdnnuWO5ba/s8390VXiP3StHzicbAHYt8Rx93
BHKmnfPsjYXGwznHf+W/0DqE/x3j3Ds2BvLFFsFcCRvEzrD6oIe4DYH/r9bm
P3VRqnqtLjLfyspMD3VHe/y10HNhXL5pm8yd+R6X5LDfCt2u4dOW4BVyzzd3
V84ocRzwdC10XmdmOWxzhBfSB2OfV5vdXWG1Re7HK8rsfzD6I+qFvgneUx+X
KP7d4v9Ljb5DsE7y8zJj0UzfCV4b9fVYiWVvvzyPsfsIKpTvG3X2L8vyvYLV
hb7bEJdvxlqcqagr9NivN2NH+a/I8h2J3M3TXXGKJattm7xOzziVsexy4UnO
dhzev+BOQs79jEjxnYrg5N5C7sMkL+4zZKzMWPND+dvlO/7HmY5fEzSQrjb8
3PGOn7sZOYtSHTSvKrVsYe+qKDSt0Ek+lRGHtTvqo6nQa2m4Z6hcFxdb5pC3
wbXGQ5lXlDo+a2rcKYCuY8x2abHDqVPuLCIv7o1kzQ08XeBvqf2sD3IutyLo
IS5+dDjrdsQdKTwdCs0veIXLN/X4RVv7CecsFf+445H9QIwBuKP1imLTTJva
S+PEbNXLTRXWEeiF2+R+VOo2iX7A7RH+GZKHnvK/k+Uw/nUJmdmn0PMvbL89
Q1+dX+F9Rewp2hN7hMInKu3EYssxMvx9W6dF3nD3Dv/qUsfBhtYnwpn3oQt7
Bf6e4cfOjMs/1jtOqnVa8mP+dHPIw1GFtrGOY36keIfI30Z0HVxoP/vZdlO9
3Ciany/47x/3942r8B5B9t7x/6aIQ7pDIy3h0ypsE+tc47SEs/bBuP+mbNt3
oINzpc9V2w897Psl7eH5tgNBJ3G5M4j5AusmuP3Dz/9jIi17k2cXec8z9fxR
1PW/9xuXe1/e5hrfrdunyOe8cBsl/zcWux/dm768wC596dFyjyzyOvj1+t+t
yPsBcLuH/z3eUenq7/Ul/rdrgc/8sP7KHtvycq/Rsg8XfEcETsYmFTE+AT/7
D7pGelz2LXJfKXF4h4L7bEnLnbZfFBsX96fhHhX+fYq8t4W+ibscGWO9m+F9
L4Rz7zH3O/KP+8F2aNyVz3xHtJ1b5D2b9ZlOd2iMu7gbkjsieT+C9PsEnzYF
fuL8UGoaVmR4THVMjIXg7T5BT5di85Syf6f4h8eYChyHB527Sx52q3Y85r7M
gZn37hV1hv2/f6a/8XM/D3TPyDecI3+Z3DnFDqcs3L1zlmBDzJ2ZwzN/nqx+
4BDV3/xW/k887ufhXNSoIr/fA56bi413X9HVV3B2kefv7ENiLvZp4GROOjHT
/8HDfT/g5H5I8P8vaDg76CHOjlKHd8j0ORb4z11DXxb7/NLIIvuhh31it4nm
2xlfVdjeibseOxDn4VSWi7GPFvsM4/BEu3uGnDeK9i7V5t2+dXHOMdHlJB/O
Aa0Jnk+LsW7/qEfyHx00/FZqf+tM1zNxPlX8qaJrmiAVu4rcQ0XPghhjHxtx
ykv8n/CNwnNcjNufUNx9BbNa+e77zexLY+4MnwTPSWYK8n134yrshypHv2r/
Z5/QVRGH/SMTi7wvkfseSfuB4l8nevoGfvYYYp9lnyH7WK6LfSMXCN/51b6f
+wLFv1DwTbn3pbCfCdycVyEsTZCe67vOueec/TtbYh/dxcJxUbX/QQtp2QfV
q52/8UPXFUEzeyHZG8l+yK86qr2Izhmi8y7Rf2exz9F+qfC9FT69le126Dps
dw8W23b3CGMY9u4KblKci0R7N/btyd9QbRzsYyGPCVH2s8ucx2XwqMb75p7P
93/omZnpPZgXF5ln2JbhG/b8nHaORxzCLo7wlrnmH3ebM1d9pMjzoP3a2c+8
lTMn8Ju9spzL4XzO84pzcJb9nNPZJ87YcL6GfVH/8jfPYdgynlX8a2r9jR+7
AuGk2115LSgyvkyl2yh4UeX6Ve5vzPHyXFfgxJZO+KaQN+Tu1/CzV4vwTexV
ED93q/ednZsiDnigd0HQT/63Bz2nV7tshP8lHn6h+HuJN+2F48xGz387yz+v
0f/q5T9L/otbua09F+1rfI39tNFOinN2o8e08Aj83J82vMrrNay/fS34SvC9
aOvezvT0DRvSQ1EXxCfOv+s7WQ7HzoRdgTojjPTgY/87/x+OtMcXeS8Z5xr+
3Xcm/535tpnQltmHdr/Ku2fckXtmF9WHaP5eZb9Q+G4RXMHcTfK8R6P35zbr
oP6u0eMR+gj2oZ2U6Xt29wo8uH3C/7nw95X/+wzf30Y4epX72fYRfCd/NXcP
tDWOB2sdzr1tjyj+TNHQXvgvVr5dlO9juf7fN9LuFXf8ore575eyrA+cfHMX
87PYrOW/V3iOJC53y4af8JLmCQnfFvub8DzVxWG0Z/kPLbZ/gfwbqxyH+NCw
d9CJ3aZf3PfCOhZ3v2DDgZbewYeD4m0g3psgHnGw7XBenvAVnLEt9htC7GHm
f7/As3+EE4c77ciXuwI2RPkp+4Pi00OCfuLP/hon79Lgfe+MrzgThT2N+1ze
UZyHs7xWQjh2V94++KrI9z1gY8XGNlhy2zzX4UexHq3+awNyozjLy70fmHWu
xBrb6XIlV98U2S7HfiTirBAUK3y16nGJ/F8qfK38K5H9HONYHnHY18t3kfwP
so9d7Wd8K9/Jc2jwv1uZaWDv1m5lzo+8jmScpLRXYSsu8v5j9h7j/7TItsft
xf4mvIfk6O0Olue35B7YaN5VljoO8cnn68irUfKwrsh3wh+nvN4u93t+2B+h
4QTRdnkbx4dPqyLfx9lzhS1V/kMZ57P3o9685U50cHIvOne6E4c73qln5ODV
DO/jPDDk4bEayxDywx2W3NXBPaLc3cF+C8YP7LPAz16LaWW+R4Y7ZKriPhnC
+cYPDtzaCP+Zt99Urs2is6/a+4viy2F5vp9xgaBjnt/06Sh4jDmCyrKnYH65
86wKPNzlQdhhcuuL/QYQ8TnbjZ83+/bT/zsEHVhrKzBOzgpVhA0QfTukyGcA
WMdEb6HLLmWsVet7qrnzmn3ljOvYg85d1gNCp+EODP934cf2+3OpxzbYA9k3
fkLoxhMCP/4+nPmq93pdcjvTAQ2cOcDPuQPikoY3R1hvhU7+/7veUeRxJjTh
Z93nRmz4gXNDvuUD2TiyzjzdyRv4dXG258HMh7EXcL8I/k/CboCNANvBymz/
I3x1tu+bxW6J2zb8rMnwzRrNGsUpkf9H1verrS/QFewhRoezhxg9c1DIG+7B
4Wd83yX0/E9Vbo+/Jtg9JPybyxx/oeI/me3wOxR/QrbLhQxw3hQaeEtiZ9mw
h2DHwG6CLYO3RPBjP6GcvHn3r/2kwjTvK76dpLAHyj1+gG8NgZ//D0Qc7Lfw
AR68k2284MRGgV2jLHDDT+wtlJ8y/jvXCzqw+SzLdjziLM72Hc7YQ0iPH1sQ
bn6Eo/9ZAxmb5XO+Cf/nXrylcTcN7wVdUef1vRaaj17dXnWktnBApsMPYw4Y
7XduhucrzFuYB6Uq/qvSj//o/2HssVAdruFcvsLXKbym3HcXc+aDN0rYn8Je
lL0y/S4Je02wCbdV/1DaYJvAMOU5VLBB6Tq185kRzo6cw56AHNskuR+ZO0e5
P3m66P9fW697Ds91f/JQlu92m5bg+8perfX+3P2xLzaJPu4KU17F0mPPVHls
v1nh70vPnJ3n+1KmCb5A5yltO6WbIPwL2H9S4j3n3A9zs8L2Fw3v1TkNd2lh
Z5tS5znvm5H/TQm+e4U7WLh3hXcViYMsLWJfovBfnmE878ZdLWNz/V7QkizT
MjXub6FOroz64qxxXY3nbpepHY1TmsNyvF+yrJP3TC7S91Dls07x/yf6vy3x
Gj1vHKO/qgSfKn4CZ8nFhwX5vk+Xu/VZG0FnsVaSyx6IOu/1BW6XfytzcPbQ
ZHl9lj2YbTp5H+amfOsn7tJdr/ANu/gsIO/LVIpHFdgFld9tdb47cVGdcXJv
Nu5tgR+7/7QoO+HzI84vwpmkejy9wGf0uJ+Us2/0XfRh9HHMWXfabDgDW5jj
s64LE3ynHfLBnab4X0/w+j+2A/Za/8w+4vbeU3OP4sxQuibV9bZi99ucS51S
bbycq20mug7P8dspnEUqFsxW+Cb22gvPOcLzDOvIdW5bV0U94sfle3SO9dRr
Cb4/cGGt924cnOO7BJEj7q/LF950dGG6ZIa3P9CRck8UpLG+lCY9I3+m/O3l
3hv+BrnnRtoe3BEfaXul+62quxv8XlW62kSaoEp5Py26noHOPI8JOBtWHzjS
As/bKuND7FVVvWcIT0pn8QHbAntRm7xfm3NenCkj/XXKLzXD9y59IsjKML09
wx6JjfQJ5blQ8G2ezzhytpEzjrMUlir4UeE5pd5vzF7E15U+O3DnyM2NckFn
ftCaozJlC6qZU6ged2TbJgxvsoI/3M8J77mD8e0s+7lrEzzZwfMfBS2w0cbd
US0zfH/U4PDDE9zU8KcHDw/XWP118WO19MwG+vMK2/5mFlhf8NYqb6ygGyaH
Dnk7/LzVgf+tOsfjXNqsBp9Nw+bH+V7sfrdV+ezfuVleI7irzvY67tyA95zp
WxxyxP2HfwvPEZzDZL+N/OX1fpuSc583N/jc5l/yH6w4NyrONvZut/ea+VuB
Y6bgizzfAcFbbJS3XDI7Uf618n8Sdy1x59KLcR/HKMUdmed3mm6RnB/EXEvf
pwnG5vm9p1NVR39nu/96VfkulA5ZrXLkcxagjc9bsd63uMbrL9zlRD7clTJB
aZvleN3hOsVJkv9/WX6H6r4Gv0W1vM7yzRrNgmzTtkH59pabITgwz28i8NY4
d4h9Lxn8TnAUejvb4fS5BzOmyfA7y18or8/pMwQvK88h+rdS4V9LNt6RLDwg
GB7vBH2eKt7K/TO+JyjOxYJX5R8q91G5IwS3yn+R4O80t1faLe39pmjztPct
aX7rtElQne53wQvkf1r1fYXgSsGfCuuUbp3wTIRdJVioeLMFXQXX8Nap3PvS
/L4J75fwdsnH3LkmOI53dcCb5rfda5V+s9rHb0Ca38btLBgoPAMEr8mf1OT9
lOylfDbynCjgHcK6wP+ivicJrm3utwoJ592iWzVevbLetsqEdNO6u+BI+Z+A
N4Iapfm1memYovC9BP+Qr3j1qvz9BIMExwleV/hX6dYX/dPdZpulu2wj5e4t
uF/+l6NOWqX53Td4ydtvvLncOvzclbeqzuNG3sAoh5ZkvwuMn3dwnxJtl0cd
nIy+Vvi7gonyXyXYJ83vC1dEWvDnpfkOnCeV5rJIf6DCeqX5bY9qfW9q5jLz
Rh9v9Q1Q2lzhOyBw/RHhvN83Q+6YSMv7frzzNzDZafHz3h91wdtCvCu0Nmjg
nnnunM9N89usZ8kdn+b3fv5Wm/tLcJz+T9F3xwj/MvjD23vfUY7g4S2qxyGq
x+dVjxcIflPbuImxt+IfLxiU6vv7ubufe/svTLOf92S3Ku2WRo9fPgl6oI34
OUHbx+Hn/n/u/ufef+64+jD8vD00L83v/hYKtgvfH41eZ+MNnNrgwx7i4Rsh
Y9i6Z9f57r7xde576Hd4g5e3eHlnh/sQuAthXa77JeL8kOe968RhvzRnjNgj
yD7fdOzs3A+Y5z7l3OizfuDcSr3tItwZSL4HZduWxr547Gkt6zzW4ew/fSVr
insrvEj18GSV7bepgZN+59Q6x6E/5U5eziZNy7X9EnszdtF3W3mv1spc9xO8
/8LbLvQbd0bfsUbuR3X+R9hdofcOUJ77Cw7KdJw7Q0+yxvR5sdec1rezjZX5
3UL2MYeu/D3GXIzFeBvqi6gj7kbEnsf6IX3waxEPG/ML+bYzb0v2+1G8c39I
jG35/lw8XFzvPThbYxyATsvK830h7BvcoDgr6m2n2Z7mN546CU4XHCzogOxK
Lp7u4D2ytwjPZMErCt8keA75pC0prEKQl265R/55A6u5vpem+d2opRE+Nclv
dtG+eGvpr9CrtM3nQhdeLfiuzjqFt9aej7BrBC+Ei36cIdqOF/1PtTKe2sB5
gNLNFexfZzrq0/z23IvNfDcz9ypzXo/7cTh/16zGd3UckBV26Tzbq78Qf96u
976nnhrHzelsu/icwP++4n+pON/t4vsz4PGl6ebzM9mOR5z95N5c5zb0nmjN
FO4Pc00fcd7LsozfHHLOPdHD2Rcf+9tZx2VvPPclbNvF+9C/lv+jetu9Llee
lwn2S3P+OTHey4vxHuO0A4Ifz6nsc1WG7HZeN6McBwSdp9f6ng7u6CDswDrv
HYKu/YK2/aIcjbEutm/oBM7Usf/42lyfK+C9Qd4JHKn574/iW7Lmxe1zTAPl
faDMNm7s2Ocp3afy38uZrlznAf5lYYPE9jhUeB4RnoXtTNcBUZZHw3aNLXpv
he1T5z0drGP2rbMtum+E4x/b1neX8Z7KVVV++/O1LK91s9+R9W7WKcvzvQY6
Svn+rHxbKJ+Pqj0eYiw0O9/vkvIWJPeYsx7JuiVjpd4xR+B+ec7/3JjrswGc
MaoLOzG0YivmzN7xgqm5pnHvoPMc5fuyxpZNJX53gbsSns/x3Ii5E/Oj2pqY
02X6rRbeW7k2xTbJbvLXZvmtX/aCMxceI5zbVJacMs9Te9R5rspbLT0i7f//
zrI9EFsgtoaHpAPaKH2dvifmem80+6IpD3uOt2c4z+6Rb/dqnz3DXsK8/sCo
r/trHec+uXkq3zvtbQPhXcBjlN+3Zc6bsvBeXbLK3beVx9Scw+IMFmNM1snR
tazX89bxgE5+7/gM+Vt18JtQZ8pf3MHvVf1U7PklNpz/KfyjDt63Sz67R9l/
ZX9yge2ZnB9jfyTn9qCVsmHjHae093axvJbXmhbGugeFLZZ9wmszrIvRw5wp
4zwZ3zW1th9g8+TuuoPqfNcre+ywqVepDi8Qr84X7FCct6u9d5D9hqxnjYw1
LNZNUwWTsmzb3hD27RzR1k5jy3Pkf0lpz61ze6KtnBdtPE9x9lHZF7by/rTz
oo2fWef39tgvzVuqZ4Z/bSvbgRry/J/w5zK8v2PnfknuXMFejK0YmyK2Reyl
uV19DxR3+mxRnAXYEDN9Fwh7qtlbfa1oqhQ8K5ylit9MOu0A1gerPc4oUPhf
8p9T5/ZIGzkn2jjy+GAHyyTnP07o6DMg2AaGJPiOfMYg42McUqY4MyT/d7az
jjk3dBrvh/KuKm+qsueOvXfsl2PNhHUE1hN4JxAaeSsQHsAj+PCLyvRzsf3T
I8+hYes6KejAroiNivMCjIEYM7FmdFqd/YydZmZ5vfdNxXu4xusNrDVUiuaj
xJN7kQ/5B9b7XH61/IPqfQfAuKg73oUnPW99Vymvx2usC2iP3BF1dIPvicqW
f4TSvtzKe3q4Z4s0rHlBE/dE/7CrZKWz95j8VmY7MvcTck8S92KsjrroG/WC
rEAH7zMuCT/0TK7yG7foK2xMJwZfVqstnC1IyfaceZhguGCj6B1Y47PJBUr3
TLHv35gRfCUeZxxPjHOOt7JWnuMzC7xp+1ax32bekW9ewIf2Ku84lXexyts7
xzRg56pX+Dn1PmtFPZwW9YLsMcbE3tJSNLQQzFHZf+lguzA24XdqvU7AGsER
CkuR7B3DGTKFbxHMFT1P1tl2c4Py+rzUe0bYd8PY9ckI3zPHbyZA1zC1iWfE
5xmCn9RGfhQcm2kcT4YMsy+FdZ1/79bW9xCVf0aW39xg/Iitt2OO757kHu25
Bd5vxF4j7mvirqaFuX6vAbyU8Urhy8zxnjr0BjY+2gVvyvP2MXa8ev1/ijrN
8nkF9omyR3S+4j1cZ/vwU9l+V4gxNm8L4cdu9GK217dY23ofO6L05wLWLpVv
Wo73ef4pPrbPcp1xdnZ4g8/Psq6JzZz3/vqJ1sPzbGt+gPV6Qa3KMi/b/7nD
FxsGdGJfwk4MbdiiOR/AHmz2ct9Y5nW4AcJdVOr7/bjPZaja6cmCp2KN5aBY
N/kjwTbHxYJD2FfM/SyitY3itm7rvY7bEmzjJh42qofqbKeaUeVzLLw9vXvc
JcD516XZjoPdm3VKdAs65gbhzxGN12XZTpcXNswhMZ5jLIf97OkoI2easEFy
h+m9dbYrYfvZHvRil/pabTm1s/ftUeePh+zxXjTvRqP7OBPAPmH2GIMDXNh/
1gZO7FS8T82ZJXQZZ5jvjbw2lnk9dFbYb7HL09emqOyLi72WytnrUxp8vpp7
QC4p8L1PrLWy5soa7sXia0WW6YEffUPfvhJnwTknvjVkHF6zl4YzmpwPbSl6
js7wG8aciWaPDnencY6B/dzs5eY9dvZ8I08NcUafM73TFG+qIFE0fygaVtd4
j+U/cltQDmwaefYzx39G4Xdn+R2N31RfmwU3Zvu97SuUz7FZvreMu8y4b4tx
MG9lg+cwhf/Z4De8DhafDqnzGs0uwlFX6zc1OSd+Xq3PjA/K8Vub+YIfS3wW
8BTBo8ihYHq23+2ehH0ty+v+zWu8X/P7Ep87HM45d5VvsuCfDN9huPOeMO4i
Ym8Q9xGxp4A9B+wrQLcdVec+/d1a+9F5rOkdGeH9VJZE6b0j2/hsQlOt3wHn
7bHz1S6Py/FZK9ZfWXu9L8t2Dvh4eNeEfx8+OqKN1694O481rNOjrPhvr/aa
Fm9dDMzxG3u52EmU/9fKa2ym7X/Yt5njHpRvfjK24mzxrh19BvjZtn4b6bZM
nzd9I857Dsvxm8D05fTbGkL++87SRvYUSUddWeCz5nkdfd58aPxXU0q4S7Td
KTgj0+fMwEEfeB+6NcdjIGwOvLW2Uxc+FrqRN5o6Rj/YX3gvUJpPclz/tbV+
U3WI2fMvTfCDMHjCOezdw364TfW4VXBSju8X/afK97y9K/mq29X3fXHG9+iO
PtN7VbXPQ3PfF2fNj+jo8+acC+/W0eewOT9/Wa7Py3O/Zm1Hn+djr+Ko2E/F
2hFjV9aPuDtkXEffG7KX9NT7qf+9xQSfuiS4Tg6OeunU1mOm4kyfk67u6LPS
B0UccPZXeJXCL1R4kfxb1O+WFNiWWKo8NovPiarvYvkXyn+O3JmCQYJ+YlhH
xT+txPYG7A7M/6el2a77daptjbPD9oWNYlnEeUw66tEm30/M3d9/CnYIzg38
i5S2GBuH4Po0vxU+C1tGst/0uDnwHxPhvONewTpCk9dLL09zXm8q/NugDXtI
rf7/JZn7vcR0gmdq2GN4e3tDqssyJeJvk/tsmmk4OcKxu/DG++Swf/KeyNTg
VaronS7/Lwo7Mc1xeAt+ivJcIl5t4ox42AOhDVvvijTb5M9v1He998Q9LTyP
CC7A3hDxXxP+/wWdfcK2OiNsqthyyRcb7NgIx+6KjXmR3G9TbWt6KOxNvBl7
Vgef5cKegV29nWA3bCph435G8JTgd6W9VmFHRPgrcg8THMq34MF0r0mxhsBa
QKOgm/i8Vu3iQ/WDp6YZPzx5JM1x4PPvwXf8fcIPT15Lt22SNa4/wvbFu9Lb
gibo2b3Jd/xxv19ausNPCNmbGrxiHeOR4G2KZH182OIZc/N+OW+uNAlP6y7e
V7UqzesI4MdG90LQ06g0vwTvbohw5LlM4YXpTtNFeD5ReT/gfsM6v4dOPqxF
vKT/uwrulH+BYFa6ZfjF4Pkb4UeecV+K8EmKd5bgJ/kXU4+CDoIr0m2HYr1g
eZQRHsLnmyLtjeFHJqF5XvCEdnSL4GLB3PDTpjhT3YjtU23w+zTb0PcOfs6L
8rL+eHjIB2sJ70Vd76Oyj27wnSxvRTve3tL0sqbTLc3rA6NDPrmj/w/BNu5j
T7ftm/UU3hjYIvg93gDYGt/YH48VDAh7ZP/4vjbCBjb3ugdrIax9HB9+2ia2
zGMizewoD2VBrljXwKZ6hP6VCto197kVzqywNrc61k16w3/h2xTv91yj7/PS
rAOxT/P2D+/+wP/NqeY5ttWjI290KeGss7yiNn6H5O3DMr8pBM7fk4wDXNix
50TdUC8766l9st832B68450o1rSw4/4YLrZb3uN6Jv7xlszT8Q2OOYGne7Tj
2wTvp9uO2Stkk7VC1tF4m+GpSM9bR6Sl7C+GbH0dbXl5yAnrzqxpLQ55mRby
NjXiw5Pb0ywP8PPmiAOezwMPMvywOrJzpZdeb+f3sZ4PO3RX8ewHydiAMq+p
va34PQPf7SFjG9JMP+FDQ0aRzzdD1pCn/SK8KM3vQzwZ5WyOLUD/Dky3HTcv
1u6v1Pe+6c6DtcbXBK8LFqSZhu5pfvcLGllLfFFxT0r3PIJ1wVcjDXOK3hE+
XjKwTuXcrjIeEfqtTvVSlO6+ZnCa58dLQ4ewHsW61L/rS+les2DtYiR7kNVf
jC/w/It9POzhGRTyiVyh6y8QJAsOCTysbZHvRWnWq9fKvU5wrGg4MsKPk39Q
yN/xydYTc0NvpIuGT+UOTHPfRF/7Ztj+8d8Qdb026uUowSVpxneX3HWR9mj1
QT1V12eqD/ooaN6Y6v6KtKcIpiS5rOA8Jd26eH2a3+RajZ5KNa6z0zw+QRev
Chm+POi7IfQeNDBOuDTCkU/eALs0/JRxQrQ78H0acnKg9Nu5kr2CUuOYEGW5
IdJCY3+V5QCV5WzWE0RbZ8EnIdfIN/32l4Kro4zPSdcuq7OeYTzB+uZnqS4b
/Qx9NX3vyjT3R+BYEnh4t+RxwROCl5v5vUrerRwjeRjd6Du3wHdW1HWO+qWr
GnwvdUq6+QNOxgiMFRg/MFYZE/4ilbewyffZ99f3pJCNMwMn9H4l2r+scz+K
DWBZ2CuS0z2e+Ub4Xwm6eGezQPhaNfnueXCcGbSx7k0Z94j6RjYYq0xPdx0U
hVxcE3x7J3hI/Z4b4ch7ddCJDYq1V9oIb4UPkDsxeDsg+Ey+jJ/PSPMY+sjg
A23hkKCNtayvg8foiB/S3C/Cf8anjIMZoxak2384bSD00r9r/WnWEdC8JNoy
tsePIxy9wf6oPdO9L4L9DW9G2W/U9wmhS9EltAXaxNh07y8A/93yHxvrg/9I
lp4Xj39s5j19CZx7zrAMfqP/96R5zsba/73yvyx3nOBH+YfEf/hRGTLAePWn
Zsb5gmC94j4gOCbd+p/xCuOZM/R9cLr3bLwUZYFm9pawj2FakvsIxmHo4RHh
Zzy2GzLWxXvYabPPhkw2E93LhGd/8DX5jjnWB5CLu4I/PdO9H4O1P/ZmQA/9
yFL5+wrq071H4ZXQv/T7CyPOYYGHt/zYy/ByxEPnHRky8HOUmzXMjYKXIh56
n3e0eXf8y5C9c0M+0V/gpt4+jvpFb12ZZj1BnRNOPdMfTAlcLRV/TaRlHxV3
pnMn+ZB8t3HeLmLuha5Dvx0XeW2M8QhjCHTgEumfd9QXfCb9sz7VMs/+BHQG
uoO+lTITn35hjPI9JN37ZODHmuAt9F4V8j9K/5tCxsZJr5ze6Puqb1fYbYLR
jIuDT/Boqr5vEPRIt35A7ucrr6EhD+zH+C14Rtv5n/B91tlnOhmz0Qcxbpug
8G0dNFYscP1NDn4xFns1ZOmq4C1r979FH4YOYI8QevOXaMtXRRzuV10W91Wi
pxjv9RO0jrkD8ztkgH6Rvm9syAP6sDbaeD/B5jSvx+M/Oto9/OwfaenHq5pb
bpCvk1SPJ+b7Hj/0On0xfTLj2vap3ofyUdAKnege/OgoxssHRHvk3M4PzUw3
45gOqU7PuKY+1d+rQ66Rk8PCD21roo4JK2tuPUH7Lm9uF3lnjoxuYx42V+Wd
E/KBTugV7aKyueubsn2Y7vEx7Z//7BOqTfa+JPYSsN4K8KYn73uiJ38Nvp0X
tEBbi9A92DHK042HMqdEv7B/6KczIt48hc+OOVGH4GVSpCEt9GKvXR790tus
bdNvJPodVfy8zbqZfQHSm9eleu8Oe3rY/7NY/5bI/1aiYWmqcbwvmWzexXdL
zIpwzp7MaivZiX1ExF+eahzstds7ZJ6+DN3XN824VkRc5i7sqWIfGXuRpmBT
SPXbeODhbTv6LGijLVc0d11RB9sDD+/ZAStT/XYdZfggyoTLO3nbI84HgZM3
73gPj7By8agu1XMu9oF8W+c6G5Vm+dsSvFsZfGBv06rgFXmAi7fzvuXsqWBY
hf8h08T9M/IjL/JeFeWjf6afRuZ37pfqEPuvkH/Ss+dqfZR9vxiDM3eARmhl
vwq2H2xAjNmQ94Eh/4xR6TMYUzBHb5PucTVj7Fbpbu8bIy1tFl16dMhk23T7
F4eNh7ERc8llIVeM2SayP7DR5zLXhF5Hf6ID0AWMM6/V/0mCHeXOp3/khW4e
EPoZ+xb757BdYMfAfoT+Yh/d8Wn/2ZewxfFm7QPSA5fG+I89b23T/J4sfUBx
+Bm3nh28mK38B6tfeKaV7QHMxdqFTA0IPcP67qpos98HTt65RR9DA2O/BVFG
+h3GRJfGHkH036DgW17oAvQAczHGQIzVGC+dG/HeTvV8gPEzewBPCh07U2ln
xNzs6uh3GKusiHbDmOHs8FO/zNV/iDHPW4ETvU0/Q3/D2GNHjO0IR44IZxy4
RLgPEOyTbltFJ9pLzGf3jrw6xviIsc31nA1vL/oKPP8mboPgDsWZjyyle05O
GLoY+81+wedloVPfjPyHBQ24J4d/c9hu6LOoo3/tCEm2MY6KNrhvzLmQZ2yG
w0O3wI8RQfOi+I8cTgn82DCxuYAH+wM2wpGR10kh2zvH/3xvD3pGRvxPQv8O
Cd4Mj7wuZT+YeDKvwPkMC3p2pHnP6hchj7jIJHszkdd/96/KTQ9diB5tmWZd
uir0FfpjRcRBb2xSXhsbfZ9HIucjBBMqrKdJiy5l/yh73X6R+1L42Z9GH3lC
qvUrZaAPoc8Bf1qkvTHVfci0qNeTBCdGnzo40q8KGw3zcWhOTfuvb8E/K3Q2
ONFz18Z+O/bavZrtvcXsK35I5XhF/cjfZd5/TPjzyaaVvbAvhJ+9oZRjg+J/
1eg9+/R1zOOhdVLsoyUf5HFI0F0ftA+O/MD5c9Qv8dEnpKFtXBfzffzIAHSw
9xoaJoX/mmTnR74L4/uPKNdLsb+P+eefUffM+5rneGyFfmA+mJRuOWUec3vI
KPv0EwVVGd4PfqTgqOZuO8wxmF9gO6PPq4y9yODEVocMoy+R69Eh2/hnxdyW
McNVgQ8b3JiQc9oRY8WtwQfmaui1noGDcGT+uuA/fOof+VcFPsZPjJuwF6CX
sR9cEXRRBvQ04bRf7GXoU+xnC8K+lxL2SXiIXiVsTdj9jg7cFYEHuyE6H338
fbQj5gsfhS5mvEcbQ/c/HXoDnUNfRhj5lwceynVfzI2wIa8BT7pt+C+ErCJ3
x0ZZGZdgu/hftPuvReNnsYcBd334H49w9lSskJx/Xud96U9EHP4ztmOezZ4T
xoafR99Nu7ohxj3g+DTwZOXYtsDcgTnEV2Fn+DL8hLNOznr53f/n3x2MR4qN
h/fvSLsu4rPGvy7m4Iwfvqnz+/MzY7zHfgn2nrMPnj3ew6IfQafxTirvufKW
K/aDAaG324ZOezPmOPQx9Duvqb3eoza+rsx7k6lf6r914GePOnvJP4mxDf6P
I1/mK4x/mH+xDlUf/oKIj/6ETvbKs1d/YIwfOQ/BOAw8jMt4z3ZtjM2ODNs2
svtNjPG6xtj82+AD9fC64LWoD9xXUz0exX0l1WMoxu/YzNEx6MupoXdujG9s
EqzrcB6Edcn3ot4588rZV87eHh0yyviKMSljUWimr7w8ypyucXWa4OVU96+s
ubBfOkf+7HSPK8h7YdCdFPoJGlbG+JDycQaIuuO9XfQ+9LBOuqHOMo0Ms/9o
Q/iRnQ0hP4kp5hdnoz6L+PxfofpN6uK75VbJn9LF97oNDn7Ay09CPtnLgT5h
3HN9smn5JMIZE8IDxq5Lhec14WlWbhsj45md4xrSMoa5O9JSFsaSx0ScN+Kd
Zt5PLukq3dJBvFa/3Fb+h+s9j+Y9b94a533vko7CV+/9bG3lH1DvfW68F44s
8H4475HvFmlWhIwwj/s85ne0ce4K5B5Jzl/PjnseuHfizhS/N86740OEv1sH
738bFbjBy/vyZ0Q8bOFrwx4+KM64c0cHtoFPwz4wT31+tnAdUKlyK02FoFJw
rKBKUJ3iu4u4D4K7ILD/1IQe464Q9rlytvQn4du3vfdIsx+VvbzsfZ0UuAak
+I6S/vHNnm32jbOXGnt+bbQ39pdWC77IcNzKoONoQXnQxxl8zuRzTp88agS1
kUd1fB8XYXUpvsODtNDPu83cJXM19IQ9Cnscbztzlwr09q5SGsFxubb5YQdk
TDw3xXUJvw8Uz9JUv0e2cvqfYsz8UszjmUtO6qQ8BPNLnM/PEe+WwIEszAsX
Obo9xW/B82b8XMntHEEbjU/mhIyQN3ur2XvN/upbIx1vx98WLum5x4P4N6e4
nMcE318Mun6OtZPf4ozVDWGDey3GHC9HOX5V+T4U/VcVeDzyUtikuG+Gt6+p
T+4m4N1E3lWcFP9fCBybghePF6pNFHrP+uSwHb4S8GvEezVo+TVsUq9F2Pzg
x7gUv7PNe90T5b8jwpD16wMXeSbTrtSmVyb73i3k5qpoM3sJ+ggmxxoM6y83
CE7g/IlgLn0WNgnBPH2PFowRtJO+LG3rPu0A6ZL9aNulqgfJfB9Bb7Wjvl18
nzt3uV/BHj7BU4JzlX5fwX7JtpO8m+h5P+f/wX+L4GbOnMe/8yLu/oLLA8eT
gnP03Tdwdc/13bTcOTAi7C+z4s6Nqrh/40bFO0kwhLmJ4GTBUMHUKOuJglGK
d0uiyz2aMsd3UY79YxJ9Dzln8W9N9HiccTnj85sCN3hHBo45ib67j3v7dpHO
vzX4N1YwLfKEptsFpwlOT/b9FkPijotTAwf8uC3SEY9xBLYfysU9p99m+f4B
5ijMGZhrIAe9BXsiJ6qfb3bxuSFkpFf8+9eO3/y/OW67WJ/+lfVj5hPJvqvn
m2Lf3bOJeW/8o81UxDhybOj7PULP7hmyhaxXxbgWma6OMR9trjLGn6dFup4p
/9kKoen0CIPW0W3dZpHzjTHvgo7zVM4HBPcjK9ke5zJvYH5ZHfOQHdGn0TdW
xXiYMfmlSvOE4HHBZSFTfF8SYY8Jzhc8GHnQN9JG6FvZi/yT6vMoycGUaDe0
mQsU76FIc45oPluwQ3y7UN8Px7+LBY8KHhFMiHz4vijCiDcp1nh3not6Idan
J8b6O2vu7Nt5SLC74KAGtSH1fbzZ/r7a3yL5v2hnvU9dbk627sf9LdlrHqT9
OdXr0KxH38n4L917bLphG4q1mG4R9/HIa0O69wvhZ7zHnIp5yeOBh/DzA8/j
jJUCz5Np3sNzf+CkX0KeoI/3ic+RDJ+d5bka8zrsPunqi9MEkyt8X+aUbN+3
yfzoqsi7INvzT+6e6h/8ujrmYxMjXmVbz03p854M+qGHvpR5PDK1Ns7Ycfau
X8wDmVdWhcxB6xFRVv7Rj8LL3wVNwt/Y1uf1vlFb27W971qmP+b/lmSvwT0W
a1es0T+a7nX6+8I/P81rZS+HPQqevxB1tD3de6Hg52/pXgNj3Yf07ANgrf+E
CN+5lkc4a+IPR91R52+k+1wwZT8o8sL2tFHu8/xPdf2QL/vBPk/3Hin2R/2V
7rPG3CHQL/zQsyPigPPwoJO53jFRD9TBFarDpZLRrqW2qd8TdnX2gbBXiTPj
nAG/K91rQcyv+cfa6+yIMyvouj94cnzw8/8xddZxXhfb/1+EpTY/2x1ssSyb
gNjd7b1euxUFxcZWUCkLFQUTvYrdgYJ1FVABSaXsxAAVFEREEfi9nrzO/vj+
MY+Z97xnzvTMmTMnJirNpZEX+XF0HdDXvHXOjjKAz32Bt0xwe/I9EXkXxRjQ
/5eqnrdp7I4vs0wk6XmTGqL4WxV/XJllqKn/Pt23jh/3XO6zN8T8g95+Y3yD
nzH3mGfwf8Dv8mO89/Lu2/7G/n28wb0c//nXRXkXK98Sua6d7S+V2y5hPdzo
yUFXwgfJvju0aO0f0mY7ybzv8ba3LPYOeFx+ib1kVXwzf6fJTU827w48Pe28
PCuirn/E/3eSve/8HOna+YH4flZj+4zcU3let5OiTZ1Upw+TjX9wx6GefHfu
bHyEtg1Q3z7V27bRRkddX4t1S3ntcvxTol4lWmfFcmOKvBaJo1/TBPNTwfss
2ev25ahHt87us4+SvW5fiX/dOzvuY7lUhT9Jdv70zobxuVxKZ//n38RqzRG5
jzO9j06NvitsTkoqkKsqDZp9vAeVBx2HPTJfY5IHXbHC5yv7CHsMuBf1To+7
Cv0FvlYW+UjHPaZj/KuIfe1fcaay37HOZgr2DHSEVfqMZf4dGefrEZGnKuLI
c7LuaycJN2tSe+5Q/3/T27YZuW8cHfnXxZi/m+y7KXXgbobOW+Ya93pk5crl
PkbOSnCO7RP2yTt7vtL3yEMgO4FMRL76aUxv6377M2C/J9ei8WyWm5FsPIL5
wdwfI3if9raNPvAVxowxaa61flX0pm4XfdY5cIVukW6HgEE9uiMrIZdXatwE
GKmBo6TGGJwReyB8P+MDNzwN3Czb+oWRQSjU+iposY7PUvl7NtlexFLdjZbI
7aJ1maP4eu0VaUqzPM3vXbx71Si+Wq5M8X1bzJMEPxK0qfr/QwPuFbRV6KzQ
W5uC7tE7vquUt4dcUZlpIw3xD10FvPHyPggNumfAvaLWugyQU0hptu037Lrx
HsfbcM+AsT74/aYHXaGd5nFb0Dra6TX8e0B1P1ptnCB88p4u6ju5M+Xukxso
N0jushrLj56q8Geq76dyf5VtpfUA60rVLbk29H92c33a35z/DF46aDNjgi5E
O/8K3kT6ZUPwcx9VbDoOus7oo7+DN7S3yry4wbJgK1XnrxtsHwm92sh2oGe7
f8I699GFCy32psAvW7Q+vlNf7VpqGfSNQadFrh16NXTpYuFqh8gd3NG6d8E9
oW2XgPfHv6L4f5BcgdyBcgd0tJw1MtboEkTOZz/uUtw1Ii3plqhei9OtgytP
bv9Ilx8w+Mb+XUmV9RHeG+PAGJTq32FRjzK5w+N7XhenY6zmhz9Bbm4XjyX/
PlG/fSy3vsw61O6Xe0CuJ3qiulj2akHk41+b+ml5T8vUz9a8ulNxs+R+U593
07/16vNylf2vqEdfxa3paR0F73dx+rvkPlSZi4W7fqdyZ0fc3XJzwqd+nDN3
1fusOSjwdfBo/g+IuUi+0+P75K6mqzYFbZUwdK272A9U1lHIFGSY5gqtDH3s
yAlh93aAvtu6WrfcGeH3RWZKec9rCpl+fbdGul6aKxfmWy/yqfpulmuBtzjD
dDP4jh9S3u1V7rnK+1+Feyk8SOHTIi2wTon6kh8+S/oSvWqsB3hMZ8Q6eTe+
N0UfMYb/dHGf0n8bw+cfuvHmxZhvjrR8oy9vfoznhhg38l+qdXmr9r1t0syv
/U7wS29GWEb9v77Ua5G6tPML48OXjc0rZJjg9d4QcchedNH4pitvUpnX+jvR
hn/i/+yu1lEEzR05tf+prLvUz0+rf4YpPFO49bpi81Owz8EPAV/EcbGnrK22
TBc8F7fEPsj+urfKvUTl7gFdosU8lPBP3hr/2+mp+Oypc/V/RoP1uU2I/eys
mKenxdzqFe9j0KPvj/9ns56Ud5rGdLn2nJEq63eVeyc2fBT+Va4r9BC15Tq5
4djXzTBM1tXYKJ/9/kP9/0DufaUZ39XziTlyZ/jMuzu6en4zX6Yp7f0q+xXk
LBQerfCDCs9XuLfCByg8UuH56sN/il3vk+KcuT3WBLDuCtjM/QeiTYPlDlHd
z22wvO24KJM6LdLesxD6YMJ045OCRnx3wGDdIK8J3zDypAfGeuUe/Jj2yovk
hsg9Hv7FEbeb3O74gr2r3PHonxHu1VXus7jzfyH3Ofur9uoPVL8fywyDfHvI
XSi3a8D6NNNyaMikTSq2fBp6FqHHoA9me7nz5HaS2znZ9IAf5X6AlhJxu0T9
gA3t6SLB+aCjaUEXxH/Kg0a1PPL/R3WboD6/tNx0he/lvou7/rdy38g9FLQf
yn8u4r6Wm1lnmtEHgYM+Fv00P8P0OGRRm9Fvpj3xpUrTh2jHDsmmKSyLMqBf
fBn91b/Ytum6ZJje8UPU6dko86ugSXwX+Z+JOPIPqbXtA+wRYCuBfoNmd06U
uWOy8aRWubZo047Rp9C5ess1JptG1kTdk003QVagV7LpZ43x7wCN5/5y+5SZ
Psf/hmTTzBoCFvTBTXIbO5qGiA8fEG/jvLvzPg79DPol9ERoeQs6mqbJmz/8
Abz7H468N3oOtG+sVBt/qbXcMe/s8BBBa4MfnXpC61mvdItTTasE7uaoB/Lp
fwMr1bJ9nTpZvg/eoaHxhsJ86aj4bXg3y7SsIfKh4Jot0XfQGj+Iup4a/cQ/
2pHUyeXxDxgdOrk9+PyDPxH+ZHgUL9NYXyq3qchznfpQNjxsPeKdmrdo3qp5
t0U+AL4iePBYY+lKmybXG90YmmMTy3x/Y05Cj+Re9bDcI3JPJZu2C732yWTT
Z/ku0RgWy2WX+Y60d751CW+vtr+cZjprf8FfJfh76f861fUPdMymW9YdGugZ
cp2VPjnT9F1of+BpN8c97ckoH/sM2GnALkaFyiyXy1O556sPzis2nsUdOz/w
Ke7cBYFPcd8uDByN+3dR4GL5maYLo9Nj244OQ98Ft4NuCB3x0dhr2Lcmxjpm
z3gi9gv6ArwNOuAVgbddFd8HxF7Id7+ATZsfDhgXRP9eEGVgW3OLXU3NwQno
rC0yHfTgqAv40L5RDvRL8L/roq7gf8PjGzxsRHwPT1gPTbcM3/vBX8Ftuf/j
0xfczaBxQzvn7subAbTPaeHzbvB2jAn/5qGjt8h3KewpY0sZvSXc924PWNim
wS4N7eauCS0euvj0gMf3R9F++nhJ9C99826kBdbCmI/Q0ReFz56KvRR0ymAH
ZnHEkR/aR0VH46RJ2mM311r/Kfb+sPXHOMPXwz0Auk1HnZvbNFsfJzqu4HWB
h+GzGGPmH3QQ8GzwbugiwOYbWglx9OnX6ofn0jyv0f8HTw48EcU6V7M1Vwfl
WF4WuVnkasfUqB/UhvvRJac6Lk31/eLj6A/Ogy90tnzeaB3bT8mfJbz6y2LT
Mh6P+hXpvv+ncJLyXNNiXwn6HnTQyUGzRV4ReSd4VD4PGiL0Q/hkkC2Ezwwd
jdDReHOH/5p4+Ge+SjE9DnoaskzobEQ/G/IFyGohbwAPDPCRKYDfF77wtZ2s
z5DwtCjn6Cjr06Bpkhe65vFB8+wQMIG/S5QLzfOHaMOOAf/ogDk44ilrifwz
5fbqbrrZrKCdQT+Ex3x6J9NiTw56ILJZJwd9FZ5w9BvCFwqPKGF4CO9JcRnA
vyzol8B5IMJvR53pE/jm0Gl5UoR/CpoDtIePog7wnTdGPaHNIrcyMOiNN0QY
eUzo2E/HOEITvTzootBIn414ZDqHBK0V2vIFAfO++AccvpGvgP/wmGgLYzQz
+gccA/mOc1Ms4wGM86KNQwIObSfvhRFGzg/Zib5B/4c+jEzH/ZEGeuy7Mf/Q
UXl+1A2YfwStFjotsqiNUTfkOZC1gyf/gMhD+gujjZQLnxFynsh40veXRpph
KZ67faIfLov4QRGGB/SX6ENo2g9GXujJfaK9T8T8HxbxO0RZzH/6aWbMJehH
l6RYjhfZhaExpsgiXx11mBrhtvCHRvyRUU/mDPo/KQM9jcvlv5pieS/Kej/G
BZ4yeF+Z8/CrICvSLqtEGB7a0ZGGMDraro/3fWSMkDWCbxM6OXy0pIUHk3GG
Dx6eLNLBlwXv5YpIT77lEf4u8lKHBREPHyp6vpEThFawIuCQfveAA78T7+LU
54aQC/g5ymTu7x9z9YIYa8LchefEfRhcBfkI+Jwfj3XBPEf2gb5H/uHQSAMf
0ZCYeytjLNAni6xKSYrlBQ6JuD+6b5UZ55txgQ8IeRLeI16PNMxP8v0e5ZRH
GuRNfo9/W/i9Iw1h+K2RG0EGbXKE4Y+l39BZAD9STYr128LjCI8z8sPgY6UR
B58rciTIqMNb/lqkoY3o/kKfOjrBXo00yDpRZ+TM2/UAwEMJ/yRlEYaXDP3U
6M7tH/3Putsr0m6MNENj/tMnB+reUdxL+3KJ+QORk4Qv/iDFXyNc7rQ881qz
ZuEbfiPqQL89GuuL9YdMVVLM892iDsiesa+eHeF3Ig1yVR9EXzHH2FPZWzkL
OCcIw5P8VtSZtsITil4JeLnh2ewce+mwWHes5bIUp6NP9ow8pMdPjnj4H4FD
/y8KOPQtfOOk2TPquWO0hXbtEPsD+8T2Ef47y/ZrsZ06LfTeQT9HD/9Aze1q
rYUmndfDGoRfCB+Y3sP2Eh4SzveZ0tyXbrta4xUeJ/dRqnX2YTuTO0letu2B
gSu8n2nddPAOwSNwep35BNBhQlnoVuWuQzx3nBKV+bBw8bNybN8VO6+8M/VR
fcbp39+Kn19kfc8zk637BFjoP1lZatsV2K3Afn1LrW3W9y22/tL6zlqnYf+o
Tmlai60nlffWadgRCz2AAwMm/VCXaT0r6JvaSXX4UXUYIhxmZq31RxZk284w
9tjgD8tQ2vQ6vxOfHP1KPacL/g2hs6+/4DzeYLup2Cf5T9go2VbxDyi+e677
Y0D0FTYM72q0HcOdFc7X3H4l13oJl6r/ThPcZ2ttS2msyv1VMK5vtb2Sb8tt
k+lB1e1r/T9FML+qtZ4b7EBgA+LUGB/6Z8t3nWkTx4QtFWzAYX8JG0jYdTq5
znBeSbNtQGwEYisQO8zYHYQPBl166HFDh9sFebbXdbjiB+bZNtVpabY3i51Z
aN/YoMbGFXao6fszov+pC/VEPw96ek6N8LfZtl2wEb4P8NYW29TCdgE2DLCf
8AE6DpWuMc1tpt7c90o1T6bn25bLTOG2M6qttxL7gdj7w/7f7uiKUT9PUx/u
pXB/hZflWicoNpjgvdspwzDpB2wpYGuBOt2sNlyRaRsM6PK8M9v2Fz7UmHTn
Ha7C+kLPLjbvFPp6P495yN2fcWdNvBv6Hfn3YYr1laDPYELgC+i1hl/iixS/
hyNPzdn/bJx9s+OcYv9iTwOn2jbgoBNhdpxlnI+vB85AfvTu/xy4yMnaS0+U
W6Ox+SPFMqfIkoC/g/OB47EX7R57GnD7Bv5zWeAt1BU9HqTh3Pk86guuDk4B
XtcuQ46/RUY3xXsxdQcf5o2bt+6xKZa95D/6mTJDR9OciGOPgz9kYYrxOvgO
wEXhPRgTeAt49+YU23WgLbzFg8ODy0NfpV+ghe4b/Y3uiE1RH8r4OfoQXBde
iN8j75oU8zzsHGfIbnGWcQ7/FufvM9F2cDx4KuBhQL8MOuHBKcHtqdO+Ue5Z
EQ+u+Fy0Az6ZdfLfj/GYF+0g/YeRhrolpVr+hzR/pZjXApwG2eH9Ak5dB+uA
Rld0zw720fm3JPqH9PUdHIeOtA+ibuRdxlkU/bwwYHJngf/ikGgjMhDI8yAH
8WWEkXNPTvW8BSdH3w64JmcW8LjvoI+Oc+ywiO8bMJlXHZX30+g34g6KePRX
7B3wmYeHRZ+grxudHfCQnBJp6GfuZ9zTuOthdwJd4ejiuSjiwefhP/kq6rlD
1JOyPo05R9msA9YDPEVHxFjD64zsAjIMyH+iT4x5Cg7PWKyPMH38R4wf85n4
neL/X9H/jDPjDS40KuBwr3kv5h530tUx/9r5cQhzd75ba/fmetWrzOWsi/nA
ugOn13a0RQ8MtrTRLcw+wJ0QPpzLY64zl9ZFPanDLlEu/C33Cf4tgn9kmeVo
uddxp7sowvQj+nvujXjkyU+QO7GDZeDAz8DNkBsdH2F4beC54Y7WP+rQN2Dd
G+MFf+zxAYu7OeuwvV5ro0+4R4LDsYdw/+MeCI8Q+dEDhfzI2ZGGsWYOTI+5
xx74S5SLbh/6t1f06+roW9Y49h7YV1mDm2McgbEhymL9sQ5ZL+D+6GaiXcx9
1gB74IJIs2fMNeKZb0+qb9P72G4za+rvmPPsGRsjzB7D3tQ/2ki5N8XcJH7X
SE9e1uNbMa/a597mmG/QEeh/1s4PUc9jou/pC/rhYfSY8S5VYl2m2I5Bd+jj
ik+FP6nS8sjMJeRGmUvwdXGusE5/iTow91aleN/v3cF6MNErST2xJwF/F+uL
dU67GjpYDybpPo807KGfRRr6gX0JfQrs1x9GmH2QPRN9N9CXFkZ4v8hLH1LW
qTEP6QPwc/i8WmJu3BLzh3XPPjUp7hHIaaBbCTsA3WLf2BBjTxg6EvQp6D/Q
iqBDQSM6PsLcFbaPNM2xVwF/u7hTQKOBPgMPGGVxZ6EuY2NMcZyD24c/Nsq6
Nb4Jj436E4aPbEzAmRhh8Afo6NANeMvhnIQWx5kODoW9KPCaLbyTMZ/Z6+Ch
ZG94PuJJ/0zEswey9qETsd7J/16d8R9oB4w9Zzy68h6KOuBPjPB7US72px7V
nHpE7uAeru/E6IsbFXeDXK8enkfAZB9jnwHP2CHwkeFRB86cETG3uecfKXdU
B69H6EErYzwfijGF1/242F+4J0JH444Gn/yx8e+qiIdOcmPAO7qD75TQbji3
/xth8rKfMa/2iTGdEO3FJuiRQYPoE/HAHBr5N3XfCmtqwKHO7CHQHO4OmPDb
HxP1uzj2U+6De0fbOYcHxrjQXvSEMAZ9Yy+8LmUrTeDaCN8b8eyXg9F7JpfU
w/IIR0d54CbgLk/GOI6MPmQvGRd9flLMZ2iY6LAiPecv7R0d/YA/KsKjIv6J
qOOoqOeiAs8P5gZnH3svZxDzk72dPRN5SeTKkZmERoGcOTQP9OOkplgXN7Ly
yMwfHTgJYfCTVyIv9BD87gGnZ4r1NSC7PibgoAcpLcU6qtB9At0FGg20L/KQ
FjlN0qZFeuhh0MigcaVHPPUiX2bkRV4f2XLkypGXL4owemOQ7T8h6pMd8eCW
6JuAdpQX8ZRPvpxIMxAduXL/VBqngjYKXtQj0gDz26gT9YHmQx2g5wAPuNB5
6lKsHwTZuMrwSXNJ1OHQSEM9oUEBuzDgQwsqDDhToq7Uc3T0W0u0vShlq74C
dBOAR+GXRBtpL2H+QxuBbgJNpDTC0EmgUZVGGJg9ok/b00E/QX4R+03QlKhv
edS5MtJTZ84aeHQ5I9C3URH9yViTnjFBHwI43jHRZ5XRJ+19dELMBfLy5tmr
g/FozjPkHKkDso7YRoNvGBoYtLeaqBt9Wxt1o138y425UBdjUBth0vw7+u2Q
7lv/MS6zUkxPA4eBngb8DTG+PWNug9fsHGnAOcmDDG1V1In6VER6+oHzk3OU
8xe8izXJelycYp5mzlnwEORvwZM/jjBn1uzAM6DZgsPRLw2xf3En4S7CWQqN
nvsFe3F9e7qoW6/wqSt46XGRj3Sc85z3nPsnBuzesWfVRhm8B1HndvwZPA+8
rjHgApN9ribyED8zyn0+6saZOCPit9jzin4AJwT/AC8B96NPFkR/bop+Abdh
LYI7sh7py9kRjw0y8LOdoqzvox/Ay+g39n/w8blRT/DHBVFWU8BhLPaM/qHc
faM+20Z4fqT/JOrDuIBvgz+B8+8ZacBpN0c9qU+HoEcABx1L0F2RwZ4XfUE/
PBlzoCHavTjmA3Rd7pb7x//FkQb9Orw/ccbxzrU0wqw/1iF48gGRjrMDPV3g
0P2iD5ZEP7TPM+5otOnT6M+DI8z/s6Is4IE/fhZpwCspi/V+ZcChT9IjDfHc
eZlX3HMPjTpQt4XxjzGClgAez32Ts+nrqCc4EvQa8oGrc7c8ItJ+E+n3i34B
/heRlzTci78L+NwPvopyv4t/3FmmR5p/Rx2ZM9tFHb+MOpwc6YGPzdWNGdov
Uh23LOL/yfCcB6fZkKdvuXPg9a+1Tm/0CG3KM62/VHn/QJdqhnkY/wi+xQb4
FJV+TaZ1dzdH/AmK/3eB+V97ZdjBAzuji+0DAgMeyH8XaW+It/D7lPbeAsPB
75dlm6V36A4yvcg2GnavUTx2RTOsK71XwPwh2zaYodWtibLGKb6t1jCweQp9
rkrhOZ1tdwAeU2hip+YnJZ0iVwNNVa46w/bfH8u3zV9s/36v8vtn2KYo/Iro
r0d3/W3Ck1oL/O8OhfsovH2G5djw0XGFzXdggAP2BV6W84/KdH/RV7vkmx+U
73zBH1Hj+oyUf1WmwzdU2+5xu70cfHieae/qaM9tpSoXvjxso1Q7DzZ2Voft
IPLNVtwutbYPs3Otw8+lWjc//FrYGYGXhz5+TXUeW20bbA/qXNhL9emvdLtk
2CYb8egfwM4aNh+w64pdFOyjwIOB7SdsU2Hn6cpi53s7zbZFDqq17Qloq4wb
NFvmKu8T0ISxY0kYe8HPC6fZU+G2LPt7RXhJtcOL5Q8vNp8zfDszEoaP7RLs
LWB3YabgH5BtPe/MOfIAq77QdkeOyrAOduw87Bx90t5H2NF5S+Gdam3j4nbB
HCtXUeW5Oa3IfTdU6a6WO4axK7Z/dIbXCPrtN6Xab4vwzdkOMz+PirTU4SLN
hR0V35jq8ghjVwN/p4hnzfUNODcU22YOMNqiLOY9PmlYUwfUuk/pT+Radsiw
7iXsB2JjAL79HGyCFtumR436ZVu15bFM29HAdjS2D5gT2NyAbytLaRPFtsWB
P1LxOyjNcH1fV+S1im0EbA1gHwHY1yvNbkpTp3GvrbPNCuw23BC2G8bq+7Za
z7sr1b/PxXsHui7QeYHuC+KejXhgjIF3XXnLNSa3K9+LqnOt6r+dyn8m03MO
+yS7KO8o1WtkkecxNkfeqrWtc/y3I4ztXL55b5omfzpvTMgzYS8nbKsSh11h
bApjW5gwepanBhxgYCt7aoRHY+NL7lHtAdXy+8K7nOk9AtuqyMVeo3oNK/I+
8k6UC0zgAQe722+p7CeybPsInavTom4fRl2hyWAT5Mawi0Q/0V/YJeS9lnfb
0R1skwW9gcgHbad9Iynf+/364Keern3pZX1PkvsXb2bq11SNR7cq2494sda2
GntUaPwqbGfr6ALzZPfNsE0JfPRv319gfYHYsXigwN/MOWRGiENu5XKFf8+0
3Yp+ed4rCT+aYb5weMLfKbBdmSvTDbtPwKfOf0a6m6s9t4dt4/oORdazo+tL
vcfFvMeGLTJkozRnxijPnSp7jP7fXGsY++dqTedYXrRac6yqzvZvyc98pn+I
4z86fzI1tzOKbS8X/8J06yydXGV7txelO98LsRYSir9GcZ3gd632d7rcV72S
ku5qSEp6I8t2orE/jL3hoVVuA+W/qn93ZflfdpXt/VyLfQT2BrmXBe+sLK/5
ofHmy9rnHfbP8qSkdeW2iY594dSgCXNeMQ+Zj38lfGY9pvCPgv9+rfVg/KS+
+kPzJFfpZ9U6flSe+XWxkYyNy7Ox1yH3uPJOjnMPusdwzZHr5HoI9j8Jl/dk
msvBLjHp/oV9ELmnFF5Fu6o854uQhWrVflOmtse5inwb+27X4DHettg+/MCX
qD7LMm0fijC2ouAlHhJh6oo/JOLhNSZM/bFhiC1D3rdxg2v9zn1OreOxbzi8
0PGvKf141nGB38aHq9/LCwyfulA3+JS7RXiAwucE/yNh8vUo8Jv63urbk2t9
xt5aZDvUz6qdI6oNt3PAIC+2ap5Rmqfl7lRdUvM8559R+i8Vd0uR896puPEZ
tl0yodi6hAjfofFLq7Nd6Yf0/WCa9cOUJmzbhLiXs5yff9hNfSjSPNRbOFxv
285h7gAHm4a8hfMm/ova1bnYttCmKU9vjWGDXJPgFucZB5iq+MOUJrnYaZ6j
vnJ3F5rXADjwGzzbYJ5C+AmPxkaQ/ndJd9+fE/1P2oxInxlh6nKw0h8k9whv
0AnjaA/TrsDjfk9yn7EPsB+UaY5laY7lIk+X7ThkS1er7r9VeZ8HBnbOyY+N
p7vlH5TqMikbm6pXq45XyY1XW5u1ry6VvyjPdmuwX8M5O0z/hxbaztA1WhM1
cqvLza/5XPCpttQYJm25M8/2kSiLdcy6xsb3udEPzNPvMj0H4c24QXE31tom
ID7frwqnvSDH34SRh0MuDts9jYW2qfVTuvdj9mXq+XXCaZCbQ7aPePZqbICz
F7Lv1RRbdgxeYM6fLXrA0/0+MDn2ljcybGuKdAuEy+2Ozd1Mn9Vj46zHNteS
kEFjDsCHylziTOBsQD4I/7IIXxphcOnhqtuoWuP34PCEweP/l2H7YfCkVGb4
rX5EZ6dZleH0rQnjh9jkuk/1mBtv+vBmkA9+FeCNDpj05fXRh5RPnTin0I9B
/43r6HJXRBibUStCb8YDhc6LPhXO9mlxvoPvA592XB/jBU/DsGr3Hf1CWZdG
26+p9r+lir9L8GvkitnTMm3vt6yz24seFnSwnFTrvWVn4T97qIwTa32XAj86
KeIPLLDug/zIVxl9hf6YyoCzRRdQhvX5MM7sxeAQ4IknCM6namOr/B8yzZNz
d4HrRxhZWurYobP3OMoFB8PmPLbnsSO5S4HDe4fcA/sisg/APjHgT8uw/kH0
MXBuj4nzmnObMLodsIEGXglOSDxzdUic4zdHmi04JnnTt+YnDXjpbRHPvCR8
U6S/NcLUAf0QzM/8CNPn8AlRL3REcL5w9rBvcxZdEmcN/U57wI23R3+9ztNO
+ZaBY3y5V8IbdGCObQlzxs6K8xc5qx2VdmnCNuyekXs+3TbisBWHHalPs/wP
23bJNdY1NVmwdtJe+lK99h3V5aoq49YDBfPSQtusxebt1VX+Rzz28Z4O+PCS
/TvHYwJc/sEP83mWw6RB1g57q0co3Vn6Pkr+oUozp9q6mrhPHRT/b+bdlbfk
MsPdUe4x+GqwHdZgu5XYrJyfZb+rypyi+JH1tgMGjgk+BC50jfxhchel2h74
wzlOc4TS396mNuj7S9Xh8irbACTt0EiPLeWHcmyPbWjAAad9RXmvq3c8tAH6
irvGR7RX6RMJw7tCriXV/+k3cGx8+nFx6BoBh/wX54VgjmlzeZyz1IuzdqLS
Pix3X5bb/3iVbSaC5xIG18Wu6YQG2zbFPvkkuTMV/0aO47Bzij31/SKMvbv9
c6w3Zob8g7DDqnBHwejU4H9L4d/vo7WW4/KpR1q6/YcifGSFzwz2OvSMYGv2
grA1i81ZeK5OV9/erfTZ6fbviXBLpW20Uzb3WWAi+/DvLKepU9sPrrb9qKtj
rjPnz1GaN/T/9SrXbZ3SHBz1P0B4x0eN2gM5T9WOrg3+hz6wlAbPsyeU78no
N/rviQj/Vu0wffxjD/ch9t+xDczdZRvtLZuEe2+W2yvH9aUvDoE/K9txyUoz
pco4Pfg8eD1h8CjG5ZUq244/TnV8vMn8Z8S9HOM1KcLDlaZJ82uD+v+8HJ9B
L8lvkX8zNozVby/n2L40dqancjdW+4bUG8/vo/DF9b4zV1T4XjperqLE8591
cL3yjZbbKd0+3wcL/sKEw8Rvo/7cpDrcq/Jei7KwZ32E6r6t8KGLBO8tlXVa
ve2bd1ffXBR1+G+DeRnZq8g3KuqZpfjB9e6fP7JcF3CfdMUPqnc/lKrOK5Hv
lOtd4PphOxo6EHQ8ZLK4Z2BnHRvr8AEuC15A/O8ivDjbtmS3SXY+6IDbI2tT
bXt2F6b5/kqecyLvtxHm/6ZIgz7rohKP3atVHmPqPznC4Mv4/LsrxzYjKffA
VOfrmusxxc4dMLfTefpblsuCd/FDzpEq7xuTYvyZe8SNlZuZ7r3psirjQVPh
9czxXgv+jF7DRmSaVFZKgf+h4xCbvug5rK8KX2l6yj2X4/UFvMtjj5qlvLvm
eZ69X+LvSQq/l2WfOXicYL6jufsK67HMPjrPsrWWVxf7HPmjzLq30Q2DzkVs
CVO/TjX+j54D9HO/1+h0J1V5LvehLXIvKNyQ8F7L3v1lwnrqRsT8ubXK/UKf
LC7wN+FT2AO1f76u/Cc2WA848C+Rfxk6hTWGj8t/Sq620raDb+HukW4bwmMi
jB3SmyPMXKdc9OMxNpTFu/P+Co/OMV2qr8q6qs3f86oNB3vEM9V/q4rdHr6B
iW1T9FTeoLhe6d7n7o39EBs2F+vfEP3bXO11P6CzcYdHao0/sOexDiuxV6q1
dk+Dz/Pr01xX6glND3uZDUG7goa1xS5kgeOh9Y0P3mbu+19k+ZzmjEbmC3uh
2EmEr/nRWuMsnVSvLyMt/5+LNNhehF5KHOmoJ/jNnlqbc5VnTq5p98iQIbcI
HzU81LwrQLOiftC+5mo8dlL9xur/kgKPK2P6lNp4FfM4yzg/vObwk4P7j4sw
ZT4a/YP/WIS5942LO8JnkZc7IPgmfOHgnPCG3xl455QM0yOQTSE8L+hg2DDH
xjn4Z32m/yO3Qr9yV6Q90KbZk9DLhywd9UM+bnmD+cXhFT8LPb3I/xX6jjah
1v0/qcDzm7mdrvmSJndlkfe/s/V/UJbjwJnyVf9B+jewyG8Pv8k/N91vN6uL
/H1mkWkl0EzgKdkj17gW+d9QmW/W2j7m/yKMjdKZgUMy5ug1nRnjvlBr9kOc
5tyBasvkBuMnpJ0ZOGf/Ur8N8UbUJWG4wAQ2YWx9TqoxTR96fpXa3wbdV/FX
q6yrivxG8qf8SeAIqQ4jf/tSuvdtfPr3cu5fSjtH7uIq9yH33Cc0Ty5Q3SoU
vkppFuj//ALjZPDD815ToHqenGf73sRB94SPHXuhb0SfLFYdF8ktFuyDBO/V
Bp+XtIc02GFnfwY/ODPu+dz3p+lI+aTWb2Od5DYoz2TV5RW5mdCxiE/2HveU
wnPTbI8au+zYpO6sc69UZdWyz5TYtupAcJUGywkgI3AScrZVxgG+UfwqncuD
c03n+2+VaX3LFP+r4s9V/H1VTl+t+O20vg7V/nK2YBZl22eNIOeAvAPyDyeo
Dy9v1V6S8Lpl/bKuoWdRF2gpx+VaJgOZEcp8UK6z0nwqnCQt/qFvKD/XMqSt
KrNFrjs6J6uch/Qd1N5C1bUEGlSV7ybYsB7CuVplvbgtWf5HPPSdK3JMH0kI
J1nRaNvDJbFfYisZOz2XRTrgkRcbvCtUzmr1ySX6l6W8PzXazjF9c3/0D31H
/aCjDqp23xFPXxOeIfjHC874Np954wqdnrb8pPg12EvL9ZkKjjuFfTjeFc7X
Wb+I/TXLumwXZ/l7osIvcM9NmLbAm9TTtZ4jyFg8E/Pz2t6WZUKOads6zx/e
rfCfjvDXGrcLNE/q1Qf/aG7WVthuNmd3a8DvrbiGCtt0J++TMQ8vVnsLVOdc
uQVKn5KwbA+2s7FLj33toRqvbRv8/bnyvZHtNLfFXQr8jbsY9zDm9IBUtxWd
vc8KTkOBdRI/V+jv+xV+JN19QNrnC/3vAXBO9eOSLPfTf9Od9lT6IdffhL9T
e89Xe5toT67lRfiHvtJHAibz/LHY09YozZlyqxPGDZELAT/kvsa5zvcpuZah
IT93u6oG3+9erfE98LEom3agw5i7Zl2D279aeQfI/ab8HbFBzHtgmmmZvCsx
Dy5Q3APQnKC1Fvg9e2Sm33x46+WdFzmTsQl/sw/xRsL7RYr2rm3z/O7BffxN
/TtfaafL3ZFwupHy38q0TNRUxd+a8Bt4dY3Tc3+nHbRng9Is0bw6Rzj85jzv
8aTlrRz746Shvf8t8HvMTfq3WOkbm7UvK32a8P9L1P99tFf9XWAZralKs7O+
X0tYngxc5paE35YPKjD96HuFD1VbTsv3uzrrlv+8O48T/PFyowX/s3LTiNCr
Bq6L/Dmy5+xrNyb876dyv3Hyvvmt+mRdpt9DLi6zbWfOJNbk7QnTCFeW24c+
xl5wW8L574g3TuiZ7B/jEv4eoX1iuNq5c4HveNwLuXcPyPf7CuWhl+eohM+y
N1TeGMYRXEx5H+zl7x7ga+wVSvdiwu9IvD3dqn7oV+I3Yfp7SozLPQWmi10a
dEZkiKCzfay+P1/jtVD5JsmNg/9a6fLyjTc/rXQvKv42xf+s+DfKLIs1hT1Q
/bqD8tfm+30AHQu8EfxZYPmr1/R9iPrnYeW5Xu6tXOuWpux5akc37pNqc3q+
7w/Yu0cfAOOSrnnyj/wfy82LMEnropPKGwatQuEzVOcLQ76Q84azBpreDLnr
FL6zwG8kpLmp2nwJ14E/qx4XofcLXVaKu0AuV+t9tPx91Z8XKM2sGsMCDnYA
gfmacJ5zqk3Hek391lV79hDN1WOUd5Lg/aQ+uSxkqpDDQybwiuh/5iM0jQeV
5upMn3vnZ/rs48yEfsq5eb76pFlwH0DGS+mfx6af3Gfo/ZD7EBxf9e5WYhv1
FynN0cW23T5L8V8j6yd3u/rpjt62qz5Peb5hDFOt0wpb73zDQwAvAbwCnPfY
WIdeuFT5l8h10Pfe6FeSPyPT8obTMy1zuIfiX09YhuyYAr+/fqjwIxGHTBl6
PCYIfm2WZRNnRJ8gj/ZepFlS7jKhT2K//dtM40sTEq7bs5m+40Jfgs60Xvvu
n3L3ZVhX6e4lxjMWVvsf8R9B24e2wlqK9H1T7ZMGvSLQhFsCP2cN3R48FehP
wqb9Ftv1gvOo3BeZrsvtUZ+HFXdpwnoyD9O8/TFh3Us9dYZ+kmn5wd1Ur3m8
zUPzTFgPDjpwLo+06GgaHf+Zt2s0VrtqHfXLN12SNxVonvAOQZvnveBYxXVS
nvOU92iFOyYss3i4yvq82P+g5UPT570Af+T/4efhe7bm2GFK/2mx83+ncd5G
/tlpvocx5tAxkrW2XpTbiG4urbUSuf+kWY8x79Zb3qyrHb441unIgP+9YG7I
NO9GlfLd3dtw0zW3H2l0eU9h/1X1WKh586PS/5Np3oFxgrkx02+Ug/Ms68i7
yL5Kv2u++ZUmKM0HEX9Egfm9Fij8WMLywMiaTi2z3Ows1hXrPM9yoq+Dg6me
HyntomrPT+YDMqqzI+9K1fOwBuMK3YUPpKsfNmUal8C/SW28R/Edm1zXyxS+
tNVn0Jn55pOgPXNzXNbHKuvhOLtYO2sUtxp+JrX/WNaf3CkJtx2es5czzd91
XI3vL/jHy01NMq/XCTXm03ha7bqmxPfaq1Tuy7nm++DOi8/9d2wP5wUe71/w
i/Du0xZwgXl01GGSyp2i8mciT6t05fmuH3XjreC8hN99SHtspCdM/hn0W5HD
+6Y5zzERf7XyTs512fB6DE6YF+QY9fOf6rdL9H2s+jivybgG9LEjwBtUj+OV
5kz9G8Ua7+F49jTkzarV9ssSXnP4rLujmLOaY1cnvIbIx9skezuwwWF4B0cf
EOcVb4+Uz/vZUZle15mC8x/B+au3v9mf2Bt5Tzla8a1N3quOUPiT3u6r61WX
ziWGy72U/+xjq3pq31cb7lW5R8gv6O1+fFhjd77S/48zWeEjSnw+D1X7htWY
hgMeDM6MLHyXKsd3ln81vHlye0L/jzByB0+oL48RPv+l9tQL5f5d4jOQuwr3
Z+6a4NDg0pelmcZ0dcA5U/XKbTQu+LHmeWbCtJ9hOl+WlVvOu1b1T1e6avYL
jeM9vA3LjVLfdlPctsmuH21AP9h/NEaH53vPQ07hyqjn5TXWnQqfZInGdE25
36qvVVl/KLy23Gk4O8Hf0B9IengOf6/1P/K+xdzQOj0sy/8vj/Tt/YIsxZSA
syH4DXj3gK9gfZ7fQoi7Sf1fUGL+EfhAKhLmD4GfARun8DbAA1Cl8PNpft8v
S/hNf5t885XA81Cj+qT2drpjMt3urDhPrkhsPVOYm7lpxinAMaD/wDMIHYM7
15O8F1T7bN8fPWGKf0f171fnMPf9zFrf8aYq/lSlu0N9drvcQNWnNuglyJMf
I3diwvxp+LwtQjPhrgZM9m/2dPbwr3LNe8Q3PHjoIxyh+EfVP0NKzAMFTyPl
cu+jDtwHuWfC83YC50+673ysf9b+czXOAw/kvkX+XtjJ5U8Kug3tnhRtHKS1
9azOwZEq7xTBnqw59E2pz67hcb68kjCfHXyh6Ds+Vu09Brq4+v4Crclk9cFo
xW/WGXeS6rxftIkz64WoD/32YtCOKPe2aq9j7gL8fy7SdMv3PYH4r1WvPsLN
PhPsfVTP+/U9QPUconL30bo7NM/4BzgH+sr+Vnv/Ctrck8pzVYnpR/9F30WN
+dLuV/g0hSf0sH1b4nfKMi0L/H8Qd8Map9k23qngieMd4YvcoMHp+yytgyzh
ou/o/4OCNaBmazkDAuaR6pvujcZHTgy8BJwE2draEs9ReAM5X37qYP/ECJex
pvV/n3TroNxe7iXB7JFumjVr7nbBPqHJdLRxPZyX8wq7hh3hCUuY/xAbOxfE
PZ17MXd12k87+8XdnHs393NoRacnTC8apv79gftwwvYSbpb7Ptf3saMT5iE/
Lttw6KuFGp9L1ScDa7wnUT77EjqdoalT73M0dgml2U0wpirulCy/VY2ONyve
hnbTuu7c4PaPKDc87qfLNGe+lXu6wu9BS+Jd5jXF/VFr/cvor1sX+OeMkFVE
ZvFDtTe/zmccbw63xhvNFXFXYB+rqrFejNFp1hsxMs16IZ5SXQr7mkZVWWc9
1+i4Zs+GVs++3aWH7013Z5u/oDp4CHkj4q2Ityf0V5AWHRHo1q4MOA/CtyU3
K833tFFpvidSDmngw4EmB57K+zx6bvkHnyT0Oe420PaeVfjdhPlu0T0JPriT
ypqter1fbt5Z8CT4RcH9TsnzHZc3Nc5p7hvoNjki2//3436nfDPKze+Lrg7w
X3SJsM+Cu6OL8mDejwp9dkKb5/yEng+ts51OuYfGaHe5FwRrt2rzGqK7Bb5K
+or9ELyevRu4+1ebdoA+lYvUVxfKrethnSc1oaPjMaVZnvB9gf0cuhv7G7Q1
9m7oYvA+fRK03N+0t/yVY55a+GVZS6yjdzXfbmwwXZY5Whnxw2Iec8beD01V
aZKV5oUCvy3xrsR7BHQ0cAd0Cj+d5bWHXAU0ZHiuPo46EM7MMk4AzRj6ZLnS
lck932D7Z7wpsW74z9ppg6ZeZH09lPNZvH0kKW6z+uap/ODPqjOP1j7VvuOh
xwWafZfAj5aV+F7671yfi9xptugTjb2J75611h2a3Mm0bHCWd1M9B3vEPDxQ
Y/1yoXGaborrXud74kr102bebrOCTzbGtElnwiXM/U7mWQEngvY+PtrCXIHf
DPisibXgbOqLRLZpk59He/M1BnlVpsPM4v2tyjaQmAvMCWgX8NTeq3X0Ypp5
l+/OMP5wjPrqHuqsNEcUWRZlcIF1MvKmxXsWfHjojSTuXP07R65but/TeKve
ohtHbdnMGwM4icL/KPyqwhuxFVbgcLPqNznNuoS3yK6km4+ed9uecr3ARfL8
73XFt2b6PzpR0VvK+xNvT+jjOTl0+7yUsBzDpDTTgKFlc74zb5DLgKb9XJz5
nPXwaqYEz2da8P0ShrbEeyz0TGyYkuaQbZxvRuRdwBqvs6wHsOGBIpxUbNkI
2g7t83747RT+Kds+9q8PVZptig3/26DbQ/vPUj0nZJiWzns4c4Y38TE6vw7U
+fVcgWlR0NzpQ9JyrtOP0PrGqoyx3BcTpoewT30SdA107MDrAf8HdD1oANA6
+PeS5vp3Cb9FsfchPwA+Bk2E+yf6kdDVCS2wKdU677lzt6Va5ys0yIZU39vB
L9n7mtTPjTXWlzpddZtWbv7vPTRnP241b8bbinur3O958JFRLvxp0Bl5nwAu
awReIdYsd3dkLtivz9A8HYAdwTzf27kjQSsARl3UH/60upCnqJOrR76i1jqg
oIlwL5tT6/NuWLbpq7fIvzXNdzfSDFb4x8jLet9PuMrHwrX2LjP9ibs5ffRD
3PdI/2C1/f9qfn5Z4HphtyxNa3Z9H9McFqis+eV+V4angfXJ2kT3FDqijlWf
TxMOsFp9NUtt3CycoiTP/MLczd6UK023fcLv2NfkOtR5nOApYs/pGvNnNm+2
GbbzxtvcDLk5af7fLXRZPFpnHm3iu0c8eUtUnwqVNU/xpQpXKbyIsNo/stC0
wus0P5M1P6sLXBa24AYlm//hoGrzMsEvjp0G3ojnZdjmw2iFP4BfMsM2Sg5V
2v9ojxhR6DOJuvJeU5rput6q5l0sfLWX9ujKoFF3iPYiQ/KI0v+g9E/UmQcW
PfZfq+yb4OXPsk2FR+R6lFkeYKnSfK00EzMs/4aOdGA8HHnpyw4x78fWmb+A
NPBvVGo8rhTsW+pMq6P+Zap3rer1SZrbhY2g+WrjcPVPF/VPXYHbPjfDffGV
8t+YZZyQ92bqsSzNPJ6MFXyej2VY3gN7Jv3C53yhzejORb6MM/uTDNtdPVE4
32bNq2vLjeutDXyPec88fkj9u1DzcGyD31H5x92Ve+s/ynON3ErBSdX+VFlo
ux7A/jjD4fnwJCbMP76NYJT2Nb/d71EW99mNPfwODL98Y6bryb7RSXXrWGH5
E96baduKNP+nr0mDjXps1WN7FJs6RapPodyuzH/5xeWWuVpVa5wNvWGE4SX+
U2nS8sz7jw5xdImhQxy9YisjzTeq681Zvne05yctuvtflLtd8R8ozcaEZTKW
gY9nmZ//fI3feQWWUbml2ut1O+U9XHPyEuEXQ+TyaswjB+/i+EK/m255/1W7
k3ivTXd94KX+JWgGv0e/LcqwfWXaThibq320D5QLRr3K/Vzfg1Xu2dW+75wb
PvYvswU7q8JvANjCJA57m/BIf1Tr9YD8EGF4s5GfWFpr2hG0///K7ZnuO8NJ
miN7RX7sk2L7j31ydq35uLgbzIkw7w7UCV643Brz0cFPx73sPMXvp/hvlPZb
uWPUxhPRp5duuJQJ/zffdxYZ/lD4KAv8dlio+A0a07w84wLsqezd7KvwWGbn
+czEpgD6+8C339bcHt1gnkpssy5T/Emp9r+LMDC+DzjwwX6fY1oNeyjpsB3X
KXgbkPktq3Ub0MN9SuBR4Dn44B3MAXSqEwYvYV58HfHYV/om2l4e/QC8M1Tu
67xDFXjdsFah/f6rzn3LeYTOR+6yLwTeuLDWd58jsx3+LstzBP2LzJM3dTb1
19m0oMz3RPgI4WncXjC3q/OdkXdc7ORiq3ZBwnRo8q8S/EW1Loe3RnjWeYs8
WXBqNAbD4KVUfzYL5jdplrX9Ks20L/bRJfF9mdZCs9ZRrwK/gVMm5U0s8v7D
GQrdgjOPfuJ962HBPTDdbVoU7eK++2vC+gkvF8wWbMUUWCci48fZTbv4f6Pa
cn6139+Yb/AdHJC+1YYuPmuCciYW+h/nD/oXOYNmJfweyDd7Nno32bfPQV+h
3JyEeddZL5yRj5SaD3Rqge0q7SXXJtct13zE8Bo3KLxY4Tc1VoMEY6DczITP
RvREcj5CT4YvE7rxDnKdFL61q+/C/GOdYXOF+z9rCv4d+KnhkXi12nzV8FRn
6nyZ1eg35n9Ubk+N4dXyJ1ebLx79k9D7eWOA5j+4xO8UpwvOcK2Xtb39Df4H
Hgg/EnTE9UFL3JCw/Buyb/Ay0l/0FbTJDRH/eL7lw0kHfYA3eN7fj1ZfPZHv
/2uL/Y7EvPtN9ZuX4/KwMU0c8/CNatOKqGddjduyJmG7xXMjfpTy1tSY/sA/
5KrbOloeGdlgvpHRQVaHu+TaWFvssV+pPnvGGxjvfuBw4G/LmrXfNBl3hqcA
H/wZHk/ekGkz/J3MBebHKJ1xvxf7nb+2zOci/fWd4PRqMtx3As8Gx769h988
ODu/0Trt2eLwpjhnoOsydujrp03ttFHoieyj7Kfs9fQrbYcXgvc6aAHQAbCR
Bw7KHkmaqugfZA2Qb1/Lmou+pK/g6Yc3BLlLeKvnZpkuAG8r85Q5+ksP4/BH
plkuifqAVx8W+ztrrZP68oh4a5xVbb2irNuPa8wbspk9udpjgx0C3huhRXB/
nq64aXI/QY9QHYpqzEsMP3hhje9Ad2pe36b+TCo0XzHx8CSP72FaHuc0PvQ8
+hGeZODAn0yezRqfzYr/Xv3d2OL0FdHv9Dl0LPoKG9Y1MW/ptzMEZ4DcH0p3
j9ZHicZ1bJ7HeF2si09Vt5RGt6dXmfEG4DLOvGuRLl959qzxGQa8+YpfFnOb
8dgFOFXmP2uXw8eHf/Rp7bu3VPq9ekB1nHnpvuceEGmX5JgXnzjgEA9Pfj/B
7lvj/HvpPLypzX3bHxokdHLFX5tv+tdTqfYPjzBvj5TJ+2PvLMdjn+VzwR+Z
b7pXa5Z9aF9fVPnffyIPdz7oitTlwKgPvAzs0a939lsdslpLwkd2K6ej7S1N
572pyOfCBZEeeT7odvAk7Moe1sO8dtdGXuDBP7xJriLb8mLIiiFTtmed9yH0
8Z4XdWDenh/8FZwZyJMNizpslN+zwDjo1fBUUId09xf2pB9MdTmkA+buga+e
oXrWZzkN9qbpL/oUHJNvaDDbpnptsEY4t2bEesFe+YPBKwhO/oLmylnV5seD
Fw/6FzSMM+UPlMtP9/9BkYa9vi7m0h+aq/Ma/Sb9ZrV5yuEn363Q8421P0L9
/LD6+cgC28H6q9jv1e9ofeykefJxmdfvR3KfKm9qrcumXGS1v4h9A3h1saew
jy+Ls6OpzOnvLbQD1wHPYf8Cd907fPBG+FXwz4lwhxp/kxa+QuY8OB50Uu6Q
3B+xPzcg1gL47jmBf2IL/tyAz/ieF/NnN83/69u8b9BnZwU98YQi14NyKWdA
4JTbKf2wNvOs0/aUwNfODZjU7bz4Bv4r6sO7SsxbhCwh6x25POTz9ojwDoK3
vdyFWd4n8Rl36PTQ6w9NWI/CuVnm7RmcZZ0KhAcGTzRy69BNiD88zbpBBkb8
MxWGA/7+jcb+qDyfJbwVgEsx3/7QOE/M9zdjxn/Oytka97lyX5cZ9nlR7gbN
q79z/Q2dhrLgu4ZH+6woF3kV6nYYZ0Su+Vv4B+2Rfeb1XK8dwqyBijy/k/FG
ht7MfrFH/SZ/SsJv9OwZB8SeNhe7oTn+B4z+AXOo8Ja63oaFntD+safBEzU4
6g/NiTA6B6jj2VHnv5R/fa6/uatxZ4OWgFwC8gncHZCTQK4BOjayeKThToed
uz+qLXu1Lr6xefdnluPXxd2SOyZ3W2AgIwGcN1pV91bTI5DLmhPn8i4hR4HM
xH2q873l5j2bqrRPt/k+j4wdMjO8xUAvgG4ArQC6BvCge5yldX+yzqkf87fO
s/b9ZlbsM8wv7rh7xzgxXvCTJxd5LjIPP1DfntDof7wBUS7yCPCJwOsIX1vH
UsucdZBbU229qMjZrY0+oX+QBUTWhrsV8xL43PXuz7Jszz2pllVDnu3/91/k
JR+yOqQD/u/gCVn210RZU1XHq5otc4JOVuqwPMs+aVZkmeaJnBu6I5CnJAz9
E/ruMVm+Y26hXwTM+4OHnDeOwZpfSc2WEcrL8nyEtrwze63cA6y7Soc5q2/K
Nx9hO28QPvyM8NzBZwY9FX7BMQnzPsEHCr8oeohuVt6Vef6GLxVeVnQ5YQ97
nxLn514GLyhyHPBxws+JbAtvagfW+F2tVDD2qTGtcDn4QI31UXzew2F4Tbsq
fFCN86FjgfTIO+8qfze5Tnnmx4UvF/1Ly8sN/8Y0y0zvHenhPYMfDj498Bv2
utygUSLPDC/wZM2Te4JnljqRl//nITfXan5CYCL7TB50NRGHbitgIRvMG8Ds
4KOCD+p47VW/9/b3e8HbB8/ecYpf2ds8TdC/8eFrOpH7Wb7TsScjawzcwarD
Yy1uw/XKt0uj+bFeqHQ/oGNpXoF1CXD+0AcHRT/clm++YHhneUt8J2EdPuBc
TUH3RnYcnQXoK3hN86JZ4Vflr8T2as7WN8h3Iy94OvqVgMXbFu9jvG/NVx82
5nntAb9fwIFXEp7JoRneS3eOOfl0hNlXkUvaTuEPlD49z/y48OLCRw++D1/H
Z1VOAw56lfqktrfTwWMNrzV6ZWgPdwHwOtrXHPcC2tdaYz0P76qf3ylzndoi
/vhU9yNzC/wQfmT4k6FBwXNM/6H3Bhxy15h75GuJvISB9Wmu38LbIv7nYsv8
QUuArxOeT/hb4c8lDtpCU+DA9BX8d28kbJOjMcaI+tNHfWO8FkBnyDMsdICh
54rxQMYKmauC4K/nGx577tO8qZ+X6vfSJ7P8Vsqdm7v3jjGGT8c4LuH9N9/f
8LLB03ZnqnXCAQdaLPwexMPzMUl7Zk6FaXvosXml2nf51fmmCUHnIG5yxD8U
tA/oHeMbbDsEGhL0GejdzV1cJ/JA9wbGS0ErgZYATQH6wpwch6EtYHed9wx4
z6B5wgNN36LjC55A+CFvi3jaQty4iB8fYfgGsZuJ7UZo2uzza+OsJN8tkZcw
sO4Pfr/bIn5csesAvW6o1uigZst8Apfy2Ct4g0M3Ae9w3Jm5r4JjPB/0M9q4
RbdGxKPngG/uswM17mvVp2vy/eb/RIwjtIjXY3w3aa+ckrWVro2vLt5yj32k
2nQtdMO8HPHofIMWgQ447r3cf8G1Ds7yfZg4ePgejr6lnwnDu/twkWHCi7Vc
63F/AZyX5fv9xEjD+zjyJ7yRdynYqhsgKddped9HLxrlohsNWhSyLry//ySY
/27wN/ZwGBfoXaRHn9r/4t7A/QFc//U839W5p3NfJ8xbNTLS0E45z3m/nhrx
7engmX5Qd/d3NF5TSvx/WqRZk+37DzjJz/nGscCv0N10f+AGr0X/Q7vBZzyg
/0AfeiPGhfa9HW3so718XYvvHxlZrj93H+pB2fA9vpvvMXow+pz+hGayLvA6
8BBs7/wVfYIuIWwHIgvP+wRhdNLgfxPxP2isv5f7ss54B3jKisBVwC345j9x
6AvCJszqLK/HF9WHX2VZFvXHbMubwueMTgjk8NELgb4A5MbBi/j/ZaSZVuA6
UK8fQ9a7Xf8EPjRqYH8R8JG/plx4tBZn+BtZbOLWRPzL8W7ImyDvgMODv/3C
4F8AR8J2zaos007nCM5Khf+T7LiVEY/PN/oWvuNuUuF+uDDwtJ/j/6+RBj0z
91abJsm+AE4N7Z12r422/x7hY7rZDvXvEf61xvTriVqjU+VuDhos7fot+hnY
lAE+hv4WvtHhAt44Kdp7mnDtAXJzVdcT1YcnVJm/Yjb6qLLN44EuK95O4CnF
HxFh/JHMpUzTifkHrRj+XOJ5ZxkZ6QkDm/oCl7kGvxJ89eyX7Jvwb58VfEzI
HlZnep/kTQGdLvC4wzcCf+uoKBfdTehtQWdLOx88Z/36WOfAp/xRUWf+3xxp
oLsvDPp/b/YiaH+5nl/fxjyn/fCtrO5kevGEGK8J0benxzjyDf6LLhb0pXwa
48ZYIjcHz8+6GF/kXpB/AQfOSlgehjj0dBJ/ShfLvsAnDe8VvNKEL4h8N0Ua
8pOHdwl0gt4Q8fDwIXvI2di1wPcoZODQ24aPHNwTwWsFnxV2tLBdit1SeK+I
vy7NtkyJX6g69KP/5HZNs/469Dmi+258uePHlVt3DfHIXsF7Bt0KmtVT5ebv
Gp5mGYa9GEfBHoj8jdL372TeL9IcrrX5Yrl5wogjHbaatthpqnY8cIZEfK80
27vfUnZXlz826nBGrsPQbeBd7VNt/tWl6ocx2dZbO0Vj3lfxk3tYDyfxyJrh
3xxpKGevKOv3DMejqxOeEPLCT0776aPTOhpmv+irtmqXO05pdlWdWxXepdD1
4B9xa2scJg31vzX6dlAn989ZnVyfW6Jup+c6DJ2Zt7PD6+KdUjC2j/HCPhrf
jG33KutthO8pNcJXp1vXIDoHh6WbLoj8FbTBnjonz2mzjG2O4GbXWiYbW1ak
gU4JvxUypciTFkT4HsHJCJjwW4E3wt+HLBV89tAuoVsiV879DHySN1Folry3
4kPDhAcSPjLKRAacOHTNoGcGnVhVkY4x2TvGBd6zK6qdD91m7fppGoVX9C7y
22J+vDPyxgQ9lfkJjRVZhh2rzQf6Vpn7kP5j7m8X/Tm7ymny0zwmQ2NcHiky
n137+yQ+75XwPCKjjnw6PJDQVYnLU5rcWv+jb6nz5HT7V0aYNKSHBote2v8E
7bka3SltloWGN/fYbPNmrMi2rrqT5U6B51buxW1Mo4cPEnwN2SnC8EN+qzvo
slbLCsP//njEb1OwVRcIuBh5wMfgKZ+RZT5z4h6P+IsqzBt/tvrh4grzyhPX
X/PzXMY21XRs9PS161BEZyI0zXZaMO+Ym6JM4H+hej3XZl14wAYmMpXIhT0R
Yfhr0BkEj82reZbDb8dTJwcuiq08ZIvZCwcq75lV/h5U5W/kicCvwYfAhfYr
s0wy+R6OeHBUeKKXBhxgcA9hb4UGz3w+ONN3yrmBf/6db1pUu+woPnxd6CKC
LgNNBj5b5JLAuzcr7a8hp8QdhTsL95THov8ZO3jA/pdlPjD0NnAnQ7cYfEP0
Be+T52S7z+s7meca3uv2OUIYutmJ2eZrXxH8P8dGPPw/x2ebnoZ/QoTRUc03
fEHwrpMXPvkXiz3XsG0OT9Rh1eaLWhHzj7l3R6HDyxRuzvWcrNF8SNE+eXj1
1nyEl6aZL+bEqBs8UYdFPHD5hj+KMT8o4qkH6eENoh8OjfgD5B/I2CicK7z4
zL7+3lDjf8Qj9zI42/Yvfs5239FvbxQ4fFzEw79IuhWl5p2Fb/YvwVlf42/C
+8q/Is11O6Taeqxo4yFRn0NirhKmDn/XmH95Val9eJh7FbrP6W/g7RcwE6r/
gL7+vlfpjymxrDa0Eu7oPTKtm4h3v1HBo1gafIr4fHM2sXaQp2SdLi+xLD18
/Zx5pIGn8feeGvM+llH5Qgvoz2an2663bSIiv/Kp4s9os34I3mpJC+9kJ43l
c7mW3b8mfGTooYGRFlzuuELbqOT/bo3WhYEejClFPkOQT7ms0HLvvPN20v/W
RsuCL9F9ammD77jsM1VV3gcK4+zh3Dm+yfom0DXB2ZQf8fMrLE+L3NiiCsOD
pkgayoXHnbMrL9IDD7jIzPyFvFiTdQasKrOPnESGxiWlr+vBuTAieKfpZ+TA
kUtFPrUywugAp/+hGT6S7T6gfzLVt7+2mTefva0yxgiZLs5ReJXnyZ8rN0xp
ZvMGkGuZbs5Xzm/0Bqegt6ExdF9EPGf64T1MY23XN4QP/ZX7Zk7cOSknM9KT
j/zwevGfdOj4+lcP0/6Qm8+vNE/Dqznmk8GHl6FjvmnX6Jj6pMJ1gV4LDkE+
6F68NcPHsOUdv8Jy+9DGUtET1uTvMTE2jMv3GvMf5C7MtW6di6AnKj4t8Bhw
mHacBt3Oa9UHU3q7DOJIB98dfN/p0Vf0JTZu6cf/oVugxPMSuTry8Q6OnAVy
8chaLCo3fzxjjHznkKgDupbpH+7s0JahK1M/cJ+M6M+ZOstmyP0r13ryaAc4
zGq16ZM2l0Ha9BhraIFfxJvyP5p7P2s9DsrdimOxRuBPoGzKXRVhaHr3F/kf
8edVmt7KvALX6x59NbPI8grIDvyptOvlLmDPVP8PbPRbFnRC4EDzfDTXuieg
ifI+D60U2R/optBPoa8O1lpIa7MMf0e5G/M8T9GJ93Pou+5Zbp0X0NeJ4x/8
zWtLXCZvMv+oTzb28Te8DPBGsK+tV/zXgj8m13pJkL1EVwl+1yrLZiKL0SXC
2yndfbnGQaBNIl+E3MaaKuvwBQ4ygfQJ/P/IAXSL+UNct4hP0jz6VuXeqfQt
ufY5xzoqflaryzhM/Ta1yTShN+Xvq+9Vada7MDvWKfXqHHWeqra83eA7JrqF
lod+oRXRJ+zh8N6viHCuyvqqzbLEyOsit4v+4V+rrBf7hlzL72IfGD3ezUHj
fTXo7tDfmRt5vW1LmHR/qPwv25yX9qbE3OCetOW+lOa7BXcMeMLRd0KYuwa8
LQMi/LPG7qcSf6Nzhbzcs/5Q36xtddkr9f+Xkq06Wc6MNMiQMa/hA+e9iPcj
1tz7VX5D5a2T+YlMT26stVWh2xw6IfHPqg5D0e+Wbz0o2O89v8nzjLlFH8I/
/1Cu//O+RB1fiDaelOkygE/7no/2IqtNf6NvfFWJ5QTgEVsu2BfWe11fXmle
rpfirHsuztPeWkNlvX1H+L7E64+3DmSU/oy1Bs8Ia/zNVPOVfB5h1jxh+Eug
Q0CPgCfwmkKHmTM760wuaLL+Fewqc5bAMz9c66tXtXVzwetbr/DO4LHZTsNZ
05X7n9yEPNspRhYN+c2+OdZrgD0U0k8MmOgr/6/CpyV7XyM9+x7lNFRb5g4b
bcDC3h8w7gqYyOWRhnohpwM/IDTY1AqHiaMu1Olt5V2t+BKF16daLwBh6IXI
Y/as9tsvcaWRhrnL/GeMVsZaQL8371ikuSD8skiPDCZ9whs1/OfA7A9dJuqA
/u1k7hbV5kUkrkvU7cQ8h5EnfD3qjswR/UR/wVu6JN59eK/JCP3fpHkk0tCf
8NeSp66zzx7sq7M/sJ7RK47tht8Utzrb/JvwqvJ9VGfTjYnnrkRbf432oiOf
vOjJ5y61JtKQ9rcIs9+x71HOlHh35819FXbVlWaB8I1XIoysH+2lrchk4S+O
8KIIkwb4lIX+JWiu0GCRg0LnHXrcoNPOjLV8VJrruDrqib8mwttGv6PvCP1y
vWJewROaHGNBHz2Y7fl4WKHn5J3JjnsowsQ9GOF+wVMK3/fgwOGRP8L/OfD8
k+O+jF73MUUOc2ehHT9G/YlbEfGnRJh80JVJQ7vPCZiU06HYZQAfec3qHNMB
NmU7/Lbix5a7X+iTvxW/Qa4q2fr3Fir+yHS/mf2T7TP6hu5ORxp02K+Mcf9a
6X8Gj0m1/0uEoVMiZwetknfwFVV++4amxzc0l3+iXOCTbiNjKb9FdWzO8Tf/
SYecH/A2BUx0/VMeek+J4x9tJC/ftLF9Ta5JcrqfqqwjlTp/VeNvcAf49uCR
A4f4LMJLqiwjsSL4A4kH52C//DL2SeTGkB9Dj8KyCCNHRv8tij7kLgkcdGrt
kjBcYK6IfoC2Cd2TfkG3IXE/RjzwgLtTjvMtlTs5cCfGApo/+gOXRDw8O9QV
/OhonQ9Xtxnn2CnhOnG/3hZ6jdzczsbjwUHZA7g7zKkybkkcuP6CVK+b92Oe
8J90nCn9cwyrNce0KuK5d4DPzo283OuRq0HHF7xDwIIHCZuUTTnWw8A4E54a
cc0xPxnDlpgDxLVEPO8llLmps2Exh+Hra08HHNr6YbS3j+LacpwPncDoMkVn
I2cE5w3nBf8Jc+4Q7hPx93Z2X90TZW4b/dYvwqTH7x9h9Lv1ibLaIp586FB9
I8ql/NcjvHf8Q7cq/E28wcEHtbTYvDJ8fxvjzxzrH22hrC+LrdOBf5UBFxlv
+JngY+BeDv8cMvbwMvDuhlwQb2/w98HnB88eNqeg6+1Q4DeRbWr85pJfbDof
/KXwYuwa/Bhf6Nx/Hxm8UvMhAwd+PHQJQJdBt8CcCsPhbQX9BNCAkONHBga6
AjScNOV/h3fHPMtVQUOBfnK2cJY9hHvvlGc6BPxV0H84JzmDOSvRUwu/Kbym
nKWcqeAYvEPyvstbJHr7sROHDg1oRZy3rDvsVIDjw3N1qdp7SZX1QcFPCl8p
+m8vqfM3fKXwom6MeMojDXyn+9VZTwfwkV3lfoCM0knCu45SH81X265SG1eo
H3ctsN4weL/g++Kb+hH+uNp20LFJMSXkYQk3BC0GuYRPleaTastB4ZOHsqCl
gY8wz6nX5qgncnLQ26DH8nazX5Xfa37vpXsUMsvchxWeqHB6rvXBJwJXXaf4
wW3WIbC78u1WZX0fwADW/krTWmld+f9f/2au38nQ+Qo8dOyTj/yH55r+jZ52
aOA7KO8P5f6er31snyq/K+0T8AnvGuUiyz8Onj3VZ1a5dc1uX2V51RPVtzPU
x+/l27bRTlWWb8XfOcJ/qS3XtllWfb3Cxbp3VOb6/y7gbLmhUznXsvTwocOr
DC86etfQS4otBfSL3Bn45J+Cc36b9YPSL9QVXSjYGts16ow+cnSjc0dApwV1
Qq/FDvJ3ZL7luh07RFt2jDC6KtBT/lKD76q7RFuAgZ7yFxp8R1tYYZ0FvGcw
f9FLy3zG37HAOn6xQ7e02jbpZmm9XtTX38w15k9lqvkL0YlGXtYzewH7AHrZ
0IF1aUfbslsScNClRjw85rwT/V7jN6Q30U/f5rWH7nB4FuFXhD6KDCo0Yegx
0GXQJb4p1/ztlIPuNeBxx4fvHfjE12XZb68DdvGoH+2lzqzZ5ytM34R+21V3
kdoWyz4BY2HU/60crx/WDvQIyseeC/xF7JPYgOB+j5wha5i4ORHfvt72i3X6
SfQb/qcRRgacspAD37nO6Vi/8E8i2wbv5YHa0w7ubd6qbI3j733MX4otDPqH
t4Mk1b+yxbK18HSQF95L/pMOPebYzUiO9M+oz69ucD8dqnzLW/zuBG8TvCng
btDEOteYLgYvBjwZ8JPAY4R+XOSYkBdEbhA+5YfVn58rbWOWdeePjHOqPte2
BuALLiwxLyZ8mOzxHeO84M2eMHv/CZmG8af6+eV888VQp0GaY+vh28u3TBXl
Ild1hdpxdb1pnr+AT0IvUJqBdbYTxnw+XfvGZMF+INf8KOgVRZ4I+YiGKAu+
XWQliDtSdeiVZXs31KV3pEFGoGfE5+S5/5gn6AkADvICE1XOZznOj60e0oNj
8F0feeHfT88yf/4DGos9e/v7wVzrq6Z+PP680eBz/s18+5zVe6qer+TZlh38
u8gsABc9LfznHN/yHpjrN0H2XPbHo3hvbbPuCfqcdybem3hrKq80XzU6vBdq
Llze6Lesj1TPx3KdrqLSPOXYZoBvnLTwZcPTThy857wRsKZ4O8iS/3aJbag0
K+9rFda5uFx78kuqR5u+J2reXtFovid4ZkgLvwJvUMTxDsWbFe9ZvHnBD4Nu
d+4uCcHPLPe/+WrTRy0uF/4v+PngAYMvDB46eMj2UJo9Gs1/xBycmWOeYOQn
iIMf6Vz1d31f/5tTYp575ho2LND1jJ5neJ6xQQJPC9/of74y5iNpWQvf9NT8
a7DdmXHyf290Pb4vMy8V9UM2CZki5C6YG8wZxnGo0jf19TdvlYwD74nIrVMW
tgfwh0R4jcr6vo/PSnhSwMN+Ex47QnDebLUM/Xz581o9/8/QWrmlzXMNvrjN
wRuHfB5xzL09kestNL2XPRNcpzDVb9Dg6ej8PE5wxjcZR4TnENjsC8ADLvTD
jRF+JeYac4l3zR+V7/x60+tqQwf0bem2GUYYXdALS4wHsbfurvWR3cd6i6sV
3r2v6WPIY9GH6Wneq9izkHUdqbaf3ui9cAfsezRYLzdrmT2K9Qxf0+lV5m16
qofDl0NfUtldyk1/Asek/8AjwSGhuYAzgTfyH7yQfYw+B189XmX+r8m4BXK3
1Ic3BXjVl+eYX32a5uH1Df4m34kxXugkYIzRp817BnVnD+dcoQ84Rxj3k2K+
9ROcjL4+o9Bjiu0c+Lu+rbBNCWycocMLXV7o0h8u+FMr/I2tOmzYYYNjKrqa
Ndb9Cq3PDF1t6O1Ahwu6XNCFMkJ5Z1T4X0H5VlryXgn7vIduF7Rq3srBRcBR
0J3FPNq90P+uLTQdEBpgcoNtsXCPmKM5vLCn+2Ga5un0VsvcU6e+haZXtwTd
mrJOqzTdmjLnC8bSFttiGq3+X9VoWf9eVdZHQzt+q7BMLzS7nQN3A8dD/o7z
ibPpLpX5ptbFHLUvt9x67dlD4d/D7g/8T8tVx2/7OP8clbusj/XAYQuQ/sT2
HzrtqAu8f+jSoQ+xY/JVidPC29Uz6kb8j4L5TR/jdbsFzgseuKXuVbaDskPg
feB7rKeNsb5Y/8h/8m4/g/eFPtbxzPs+vAFvdPa+yTdv/cQNivjXG2yHgDMa
XoAzI569b0nsjaytM2J9LYn8wIO/mDW/KPjn4YfnzniyYH7Y6Pn3UeBb7bjl
JbGHgPswZ8F/dgy7CMQzNvC5Ql+dp74ak2e42EwgDed4Y5Xtx9DfV9X77Ofc
X1DivYs9rLP2h5/bTC9/T2vx3YaQGSzxfGF+jtH4ds9z36Uo/co2vxE1BHzW
xRa/yrZg1lbYLhB8lvAnIisOjyL8lZxp8FYiQ4dMNPv5ByWWN+UbmVPki5En
Rb4UOVNkXS/lTbDF38h3U3dwk4sV36B1vSDH8tn4yGWjjxO9mtgURg6GOz48
GOjhmVpuGS7sT7K2sUe5SPN5cav5SmjXYWGbMkX+UXI3d7NeEMLoBoEnKrfC
svzwRvENDxU6oNEFjZxCdvC0o18CWuspiu+QnJT0SLHDB6dab3V26LLIijDp
kd8HPjJ3HXTHHVDvshaojh+0Gm4/+DGKbbMbPRZZkRfYpwb8UyIN5VYrTbnC
VejULHY9eXf+ptx2HB5U3p31r5o7XpHbUBm2pXEVxbYxPao43raLHa4MOJxn
wAHXrVJcD9JAu052eGWybUBiM5J7AX5thEeofb+oXduhR1Ph3xTeUeHGUvvI
ENxX5DzYmnxRc3BYveuMfj/g8H+l8q2S2155ni2zf1Cm36OAzTvQcOX7SWn6
VVg26tDQT8U+wx7EHv684F9W73MW3ZF/hb2SIsH6o8iyn1vsVBVZNxf/sGnS
Hrcu0pAPHZToS1wfuijbw38GTHSF/x06KtEltkkutZP1gBFGFxg6xDYUWf8V
usXQM/akyp3e229vvLsBb33YWeH/hkhDeGPoJbskdJShdyspdJdRFrrKNkb6
vwJOe5v+jLYwb8qU586O1h2KvQn0doJ/gJegqxNdX/QndhDqKhxPH5IWvrNx
Cv9e7m/Cr0Q88EhbF7pMX1D/X1HvNMwl5iS8T+A8NQFziw25YrerEL2vff1v
gtZLdS/rhKW+zPnTox9IT9srK2y7Gh016KqpjHByD8djE46+YT6gk41v0sAb
zNqoirnNvK6KuvEuypziTRG+TPS8bLEFhj0UtefCCq+5iyq8XjjnxxbZngRr
87Yi1/PiCqdhL9m50PHw6hyhut2k8A2plj0aEmk2qr1Fbf4G3u1yz6daH3aH
XtaJjV1x7ItDG0G/KGH0V4Mz3FxkvAGeO8qGx+a3AsMCTgfB3qbNNmbAT4BP
3S+pcHrqQL1ujroBi29sGGOLmLcW3lPQl3+T0mekWS/sjdRX6ZME+8l604HQ
mXNS6M05t9X6qdENjZwzMszo6eE/6ZBlxj8hwhsybFsJO0rdM22XHnv0WaHn
hzQnRF74T6nfrVE3/FsizBsQdcYGMDp9b1P++1L9n3ToGcaWE7aN0A1bUux/
6CgmjjpgNwi94VdFGJtO2HDCfhO2wofFWOBjMxzb2+zR7OlJyZaf7KvwCdC5
ix1GN11zsfXsoOPuz2R/E/6x1XdF7ono4CENOnzwWyMNd/rWiq37dGvs+fht
EZ4RMN9LthwJsi7IkmBHiTBvgujZAyZ6fvoX2/Y2ZxB+vwj3i/i2iCcdNrFP
yHCYNO1tox1txQ7TRnQTtUUYO6nXFVln4ha/yDRAbNeOKrIN2Qmq++UVwR9e
4XnJnOyQ6b5FJpq81wYcxuTqGDt0sBNmrFgPw2IsntS4X1Zhfvkczrsi61Vm
nL+Msb6uwmHmQ3sb1iU77ahIn1Xssqlzmuozosjyj6QhjP0Y2jAywtjSpY20
+7eYM9wLmDd8I5N+oPzvi2yfCh16v5Vaj97qUoeXMVe1bv4HvqR94vNS60ve
LtU0pc/KfKd/ucx5SL+L0k5tsV7j2dpP5si9p38fltpWB3Y6psn/Vf5XqfZX
RRhdtmtLrc82STA6tFjv+3nqn+ll1rvUU+fUvGa/+/1R6vR58JyUmef6pDTz
Hq4P/kN4Ntv5JeHLhh+bdC8Iztxm643oUWp7G5yf6FldEjQ57i6flBk/hnaE
jgfoRRPVJ++2+N9K4Y0zm61P4kvh4LOardcYGfx5IYd/fbnDxMF7gWwqcqlz
dQdZ0ux//8htKDUv+tclvh+yp85QOTNb3NeLlHYxfRr6gfD/08E2CIDN+/x3
1K3ZNIyNJe77CehCE07+VbPlOZfBc9Toe+HPSv9es+XaprdYnwXtZF0sVd5n
Ql6Wc4K18GKZ+50+/6DJdz/ufS8LztvNftP5UOGpzZaZR8bu8zLrdD2Sfijz
GPVSv93ZZvuQr6rM1+TmKrxEsOfQ5/JPKbE+d3S5L1c5NzZb3qWszPYj0S30
k/b7O5ot65ykc