(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5910,        207]
NotebookOptionsPosition[      3560,        139]
NotebookOutlinePosition[      4884,        172]
CellTagsIndexPosition[      4841,        169]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Geodesy Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpheroidalDistance",
  BaseStyle->"Link",
  ButtonData->"paclet:Geodesy/ref/SpheroidalDistance"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " distance between two points on a spheroid"
}], "GuideText",
 CellID->203374175],

Cell[TextData[{
 Cell[TextData[ButtonBox["Eccentricity",
  BaseStyle->"Link",
  ButtonData->"paclet:Geodesy/ref/Eccentricity"]], "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["SemimajorAxis",
  BaseStyle->"Link",
  ButtonData->"paclet:Geodesy/ref/SemimajorAxis"]], "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->230411525],

Cell["\t", "GuideDelimiter",
 CellID->3637415],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToAuthalicRadius",
  BaseStyle->"Link",
  ButtonData->"paclet:Geodesy/ref/ToAuthalicRadius"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " radius of the authalic sphere based on a given spheroid"
}], "GuideText",
 CellID->532034961],

Cell[TextData[{
 Cell[TextData[ButtonBox["GeodeticToAuthalic",
  BaseStyle->"Link",
  ButtonData->"paclet:Geodesy/ref/GeodeticToAuthalic"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " coordinates of a point on an authalic sphere"
}], "GuideText",
 CellID->250238874],

Cell["\t", "GuideDelimiter",
 CellID->311258892],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToDegrees",
  BaseStyle->"Link",
  ButtonData->"paclet:Geodesy/ref/ToDegrees"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert a coordinate from DMS to degrees"
}], "GuideText",
 CellID->325524718],

Cell[TextData[{
 Cell[TextData[ButtonBox["ToDMS",
  BaseStyle->"Link",
  ButtonData->"paclet:Geodesy/ref/ToDMS"]], "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " convert from degrees to DMS"
}], "GuideText",
 CellID->291215743]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Geodesy Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Geodesy/tutorial/Geodesy"]], "GuideTutorial",
 CellID->161016672]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["World Plotting Package",
 BaseStyle->"Link",
 ButtonData->"paclet:WorldPlot/guide/WorldPlottingPackage"]], "GuideMoreAbout",\

 CellID->736414323],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"],
  FontSlant->"Italic"],
 ButtonBox[" Data Collections",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/DataCollections"]
}], "GuideMoreAbout",
 CellID->241203317]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Geodesy Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 52.8974944}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Geodesy Package Guide", 
    "language" -> "en", "paclet" -> "Geodesy Package", "status" -> "None", 
    "summary" -> 
    "SpheroidalDistance -- distance between two points on a spheroid, \
SphericalDistance -- distance between two points on a sphere, \
ToAuthalicRadius -- radius of the authalic sphere based on a given spheroid, \
GeodeticToAuthalic -- coordinates of a point on an authalic sphere, ToDegrees \
-- convert a coordinate from DMS to degrees, ToDMS -- convert from degrees to \
DMS", "synonyms" -> {}, "title" -> "Geodesy Package", "type" -> "Guide", 
    "uri" -> "Geodesy/guide/GeodesyPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 57, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[679, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[738, 31, 296, 9, 70, "GuideText",
 CellID->203374175],
Cell[1037, 42, 430, 11, 70, "InlineGuideFunctionListing",
 CellID->230411525],
Cell[1470, 55, 46, 1, 70, "GuideDelimiter",
 CellID->3637415],
Cell[1519, 58, 303, 8, 70, "GuideText",
 CellID->532034961],
Cell[1825, 68, 299, 9, 70, "GuideText",
 CellID->250238874],
Cell[2127, 79, 48, 1, 70, "GuideDelimiter",
 CellID->311258892],
Cell[2178, 82, 274, 8, 70, "GuideText",
 CellID->325524718],
Cell[2455, 92, 253, 8, 70, "GuideText",
 CellID->291215743]
}, Open  ]],
Cell[CellGroupData[{
Cell[2745, 105, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[2810, 108, 149, 3, 70, "GuideTutorial",
 CellID->161016672]
}, Open  ]],
Cell[CellGroupData[{
Cell[2996, 116, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3061, 119, 171, 4, 70, "GuideMoreAbout",
 CellID->736414323],
Cell[3235, 125, 283, 9, 70, "GuideMoreAbout",
 CellID->241203317]
}, Open  ]],
Cell[3533, 137, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

